<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Migration_Tbl_notification extends TT_migration {

    const table_name = 'tbl_notification';

    public function up() {
        $this->field_name('notification_id')->type('INT')->size(11)->auto_increment()->generate();
        $this->field_name('notification_description')->type('TEXT')->set_null()->generate();
        $this->field_name('notification_date_time')->type('DATETIME')->generate();
        $this->field_name('notify_by')->type('INT')->size(11)->generate();
        $this->field_name('notify_to')->type('VARCHAR')->size(50)->generate();
        $this->field_name('notification_view_by')->type('VARCHAR')->size(50)->set_null()->generate();
        $this->field_name('notification_type')->type('TINYINT')->size(2)->generate();
        $this->set_primary_key('notification_id')->set_table_name(self::table_name)->create();
    }

    public function down() {
        
    }

    /**
      All Notification type
      ---------------------------------------
      1->send link request,
      2-> Accept Link request,
      3-> Group post,
      4->group request send,
      5->join request acceptance,
      6->Add Course,
      7->Update Course,
      8->Course Regisration;
      9->Course Permission;
      10->Course Upcomming
      11->Active Course
      12->InActive course
      13->Archive course
      14->Pending course
      15->Apporved course
      16->Draft course

      17->Add bkash Payment Method
      18->Add Check Payment Method
      19->Add Paypal Payment Method
      20->Update bkash Payment Method
      21->Update Check Payment Method
      22->Update Paypal Payment Method

      23->Add new invoice [save invoice ID]
      24->Update invoice [save invoice ID]
     */
}
