<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Migration_Tbl_invoice_payment extends TT_migration {

    const table_name = 'tbl_invoice_payment';

    public function up() {
        $this->field_name('invoice_payment_id')->type('INT')->size(7)->auto_increment()->generate();
        $this->field_name('invoice_id')->type('INT')->size(7)->generate();

        // Cash=>1, Cheque =>2, bKash=>3
        $this->field_name('invoice_payment_type')->type('TINYINT')->size(1)->generate();
        $this->field_name('invoice_payment_type_id')->type('INT')->size(7)->generate();
        $this->field_name('currency_type')->type('TINYINT')->size(1)->generate();
        $this->field_name('paid_amount')->type('DECIMAL')->size('8,2')->generate();
        $this->field_name('invoice_paid_date')->type('DATETIME')->generate();
        $this->set_primary_key('invoice_payment_id')->set_table_name(self::table_name)->create();
    }

    public function down() {
        
    }

}
