<?php

/**
 * Description => All kind of post related function
 *
 * @author Md Jaherul Islam
 */
class Tt_post extends cf{
    /**
     * @Function            : time_format_for_read_write 
     * @Description         : time format for read write status
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 26-07-2016 02:32 PM   
     * @Status              : available      
     * */
    function time_format_for_post($user_time) {
        $current_date = date('Y-m-d H:i:s', time());
        $formated_current_date = new DateTime($current_date);
        $formated_user_date = new DateTime($user_time);

        $interval = $formated_user_date->diff($formated_current_date);

        if ($interval->format("%d")) {
            echo ' ' . $interval->format("%d days");
        }
        if ($interval->format("%h")) {
            echo ' ' . $interval->format("%h hours");
        }
        if ($interval->format("%i")) {
            echo ' ' . $interval->format("%i minutes");
        }
        echo ' ' . $interval->format("%s seconds");
        echo ' Ago ';
    }

    private $input_data;

    function set_filter_input_data($input) {
        $this->input_data = htmlspecialchars(preg_replace('#(@br */?@\s*)+#i', '@break##', $input), ENT_QUOTES);
    }

    function get_filter_input_data() {
        return $this->input_data;
    }

    function get_post_details($post_value) {
        $post_data = '';
        $array_data = explode('@break##', $post_value);
        for ($i = 0; $i < count($array_data); $i++) {
            $post_data.=$array_data[$i] . '<br>';
        }
        return $post_data;
    }

    function get_post_details_for_update($post_value) {
        $post_data = '';
        $array_data = explode('@break##', $post_value);
        for ($i = 0; $i < count($array_data); $i++) {
            $post_data.="$array_data[$i]\r";
        }
        return $post_data;
    }

    function get_post_data($post_details, $limit, $function) {
        $details = $this->get_post_details($post_details);
        if (strlen($details) > $limit) {
            $limited_string = mb_substr($details, 0, $limit, 'utf-8');
            $update_details = $this->view_emoticons($limited_string);
            return $update_details . '<a href="javascript:void(0)" style="padding-left: 10px;"
                    onclick="' . $function . '" >more...</a>';
        } else {
            return $this->view_emoticons($details);
        }
    }

}
