<?php

/**
 * Description => View all notification related function
 *
 * @author Md Jaherul Islam
 */
class Tt_notification {

    private $notification_type;

    function set_notification_type($notification_type) {
        $this->notification_type = $notification_type;
        return $this;
    }

    private $result;

    function get_result() {
        return $this->result;
    }

    /**
     * @Function            : get_notification_type_msg 
     * @Description         : get course notification type message
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 23-09-2016 04:33 PM
     * @Parameter           : $notification_type[INTEGER]
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function get_notification_type_msg($notification_type) {
        $notification_msg = '';
        $other_notification_type = Array(1, 2, 3, 4, 5);
        $course_notification_type = Array(6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16);
        switch ($notification_type) {
            case in_array($notification_type, $other_notification_type):
                $notification_msg = 'other notification type';
                break;
            case in_array($notification_type, $course_notification_type):
                $notification_msg = $this->get_notification_course_type_msg($notification_type);
                break;
        }
        return $notification_msg;
    }

    /**
     * @Function            : get_post_type_message 
     * @Description         : get post type message
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 23-09-2016 05:10 PM
     * @Parameter           : $post_type[INTEGER]
     * @Return              : $message    
     * @Status              : Available       
     * */
    function get_post_type_message($post_type) {
        $post_type_msg = '';
        switch ($post_type) {
            case 1:
                $post_type_msg = 'a note';
                break;
            case 2:
                $post_type_msg = 'an alert';
                break;
            case 3:
                $post_type_msg = 'an assignment';
                break;
            case 4:
                $post_type_msg = 'an image';
                break;
            case 5:
                $post_type_msg = 'a video';
                break;
        }
        return $post_type_msg;
    }

    /**
     * @Function            : get_notification_type_msg 
     * @Description         : get course notification type message
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 23-09-2016 04:33 PM
     * @Parameter           : $notification_type[INTEGER]
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function get_notification_course_type_msg($notification_type) {
        $notification_msg = '';
        switch ($notification_type) {
            case 6: // Active course
                $notification_msg = 'created';
                break;
            case 7: // Active course
                $notification_msg = 'updated';
                break;
            case 8: // Active course
                $notification_msg = 'registered';
                break;
            case 9: // Active course
                $notification_msg = 'updated permission';
                break;
            case 10:  // Archive course
                $notification_msg = 'change upcomming status';
                break;
            case 11:  // Active course
                $notification_msg = 'actived';
                break;
            case 12:  // inactive course
                $notification_msg = 'inactived';
                break;
            case 13:  // Archive course
                $notification_msg = 'archived';
                break;
            case 14:  // Pending course
                $notification_msg = 'pending';
                break;
            case 15:  // Apporved course
                $notification_msg = 'apporved';
                break;
            case 16:  // Draft course
                $notification_msg = 'draft';
                break;
             case 25:  //TT assign course
                $notification_msg = 'assign';
                break;
        }
        return $notification_msg;
    }

    /**
     * @Description         : get payment notification data
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 02-01-2017 12:49 PM   
     * */
//    function set_payment_notification_message() {
//        switch ($this->notification_type) {
//            case 17:
//                $this->result = 'added a bkash payment method for';
//                break;
//            case 18:
//                $this->result = 'added a cheque payment method for';
//                break;
//            case 19:
//                $this->result = 'added a paypal payment method for';
//                break;
//            case 20:
//                $this->result = 'update a bkash payment method for';
//                break;
//            case 21:
//                $this->result = 'updated a cheque payment method for';
//                break;
//            case 22:
//                $this->result = 'updated a paypal payment method for';
//                break;
//            case 23:
//                $this->result = 'A invoice created for ';
//                break;
//            case 24:
//                $this->result = 'added new payment';
//                break;
//            default :
//                $this->result = 'payment option';
//                break;
//        }
//        return $this;
//    }

    /**
     * @Function            : calculate_notification_date_time 
     * @Description         : calculate date time for notification
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 23-09-2016 04:53 PM
     * @Parameter           : $user_time[DateTime
     * @Return              : $time format    
     * @Status              : Available       
     * */
    function calculate_notification_date_time($user_time) {
        $output = '';
        $todays_date = date("y-m-d H:i:s", (strtotime(date("Y-m-d h:i:s a"))));
        $formated_current_date = new DateTime($todays_date);
        $formated_user_date = new DateTime($user_time);

        $interval = $formated_user_date->diff($formated_current_date);
        if ($interval->format("%d") == 0) {
            if ($interval->format("%h")) {
                $output.= ' ' . $interval->format("%h hours");
            }
            if ($interval->format("%i")) {
                $output.= ' ' . $interval->format("%i minutes");
            }
            $output.= ' ' . $interval->format("%s seconds");
            $output.= ' Ago ';
            return $output;
        } else {
            return (($interval->format("%d") == 1) ? 'Yesterday' : $formated_user_date->format("F d")) . ' at ' . $formated_user_date->format("h:i a");
        }
    }

    /**
     * @Function            : get_notification_seen_info 
     * @Description         : get notification seen information
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 24-09-2016 10:40 AM
     * @Parameter           : $person_id[INTEGER],$person_view[SRING]
     * @Return              : 1/2    
     * @Status              : Available       
     * */
    function get_notification_seen_info($person_id, $person_view) {
        $person_view_array = array_unique(array_filter(explode(',', $person_view)));
        if (in_array($person_id, $person_view_array)) {
            return 1;
        } else {
            return 2;
        }
    }

}
