<?php

/**
 * Description of Tt_file
 *
 * @author User
 */
class Tt_files {

    private $work_file_size = 10485760;
    private $allowed_work_file_type = Array("zip", "rar", "txt", "rtf", "pdf", "gif", "jpeg", "jpg", "png", "psd", "flv", "mp4",
        " epub", " azw3", " cbr", "lit", "mobi", "swf", "docx", "xlsx", "pub", "pptx", "one", "doc", "vsdx", "accdb",
        "xlsb", "mso", "rpmsg", "asd", "xls", "oft", "thmx", "mdb", "xlsm", "mpp", "obi", "pst", "snp", "xsn", "olm",
        "ost", "dotx", "vsd", "laccdb", "accdr", "wbk", "pptm", "dot", "ppt", "xlam", "onepkg", "xltx", "mde", "docm",
        "pip", "ppsx", "ppsm", "accde", "grv", "xla", "slk", "potx", "iaf", "xlt", "crtx", "xlb", "vss", "xar", "xlw",
        "pps", "pa", "oab", "dotm", "mpd", "svd", "ops", "pot", "xlm", "mpt", "acl", "xltm", "mdt", "ade", "xl", "vst",
        "accdc", "mdw", "accdt", "mat", "vdx", "xsf", "xll", "sldx", "mda", "mar", "ppam", "accda", "ppa", "vsx", "puz",
        "prf", "maf", "vtx", "potm", "xlc", "wll", "accdp", "mam", "sldm", "maq", "accdu", "cnv", "maw", "xslb");

    /**
     * @Function            : set_file
     * @Description         : set uploaded file index
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 23-10-2016 12:10 PM
     * @Parameter           : $file_index
     * @Return              : NULL    
     * @Status              : Available        
     * */
    private $file_index;

    function set_file($file_index) {
        $this->file_index = $file_index;
        return $this;
    }    
    
    /*
     * @Description         : set upload file name
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 31-01-2016 03:23 PM 
     */
    function set_file_name($file_name){
        $this->file_name = $file_name;
        return $this;
    }
    
    /*
     * @Description         : set upload file size
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 31-01-2016 03:23 PM 
     */
    function set_file_size($file_size){
        $this->size = $file_size;
        return $this;
    }
    
    /*
     * @Description         : set allowed upload file type
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 31-01-2016 03:23 PM 
     */
    function set_allowed_type($allowed_type){
        $this->allowed_type = $allowed_type;
        return $this;
    }
    
    
    private $encrypt_file_name = FALSE;
    function set_encrypt_name(){
        $this->encrypt_file_name = TRUE;
        return $this;
    }

    /**
     * @Function            : get_file_extension
     * @Description         : get file extension
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 31-10-2016 03:35 PM
     * @Parameter           : Null
     * @Return              : $file_extension    
     * @Status              : Available        
     * */
    function get_file_extension() {
        return $this->file_extension;
    }

    /**
     * @Function            : get_file_size_with_design
     * @Description         : get file size with design format
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 25-10-2016 02:27 PM
     * @Parameter           : Null
     * @Return              : $filesize_with_design    
     * @Status              : Available        
     * */
    function get_file_size() {
        return $_FILES[$this->file_index]['size'];
    }

    /*
     * @Function            : assign_data 
     * @Description         : assign data required data
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 23-10-2016 05:15 PM
     * @Parameter           : $file_type
     * @Return              : NULL    
     * @Status              : Available        
     */

    private $size;
    private $allowed_type;

    function assign_data($file_type) {
        switch ($file_type) {
            case 1: // for Course Work file
                $this->size = $this->work_file_size;
                $this->allowed_type = $this->allowed_work_file_type;
                break;
        }
        return $this;
    }

    /*
     * @Function            : check_validation 
     * @Description         : check uploaded file validation
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 23-10-2016 10:15 AM
     * @Parameter           : Null
     * @Return              : NULL    
     * @Status              : Available        
     */

    private $file_extension;
    private $error_message;

    function check_validation() {
        if (isset($_FILES[$this->file_index])) {
            $this->file_extension = pathinfo($_FILES[$this->file_index]['name'], PATHINFO_EXTENSION);

            switch ($_FILES[$this->file_index]) {
                case (!$_FILES[$this->file_index]['tmp_name']):
                    $this->error_message = 'location_error';
                    break;
                case ($_FILES[$this->file_index]['size'] == 0):
                    $this->error_message = 'size_zero';
                    break;
                case ($_FILES[$this->file_index]['size'] > $this->size):
                    $this->error_message = 'big_size';
                    break;
                case (!in_array(strtolower($this->file_extension), $this->allowed_type)):
                    $this->error_message = 'type_error';
                    break;

                default:
                    $this->error_message = '';
                    break;
            }
        } else {
            $this->error_message = 'no_file';
        }
        return $this;
    }

    /*
     * @Function            : set_upload_dir 
     * @Description         : set upload dir
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 31-10-2016 11:59 AM
     * @Parameter           : $upload_dir
     * @Return              : NULL    
     * @Status              : Available        
     */

    private $upload_dir;

    function set_upload_dir($upload_dir) {
        $this->upload_dir = $upload_dir;
        return $this;
    }

    /*
     * @Function            : set_file_name 
     * @Description         : set file name
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 31-10-2016 12:15 PM
     * @Parameter           : $file_name
     * @Return              : NULL    
     * @Status              : Available        
     */

    private $file_name;

    function set_file_random_number($random_number) {
        $CI = & get_instance();
        $CI->tt_random_number->set_random_number($random_number);
        $this->file_name = "$random_number.$this->file_extension";
        return $this;
    }

    /*
     * @Function            : upload_file 
     * @Description         : upload file into directory
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 23-10-2016 10:30 AM
     * @Parameter           : Null
     * @Return              : NULL    
     * @Status              : Available        
     */

    private $uploaded_file_data;

    function upload_file() {
        $CI = & get_instance();
        $config['upload_path'] = './' . $this->upload_dir;
        $config['allowed_types'] = implode('|', $this->allowed_type);
        if(empty($this->encrypt_file_name)){
            $config['file_name'] = $this->file_name;
        }        
        $config['max_size'] = $this->size;
        $config['remove_spaces'] = FALSE;
        $config['overwrite'] = TRUE;
        $config['detect_mime'] = TRUE;
        $config['mod_mime_fix'] = TRUE;
        $config['encrypt_name'] = $this->encrypt_file_name;
        $CI->load->library('upload', $config);

        if ($CI->upload->do_upload($this->file_index)) {
            $this->uploaded_file_data = $CI->upload->data();
            $this->error_message = '';
        } else {
            $this->error_message = $CI->upload->display_errors();
        }
        return $this;
    }
    
    
    /*
     * @Description         : set uploaded file data
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 31-01-2016 03:23 PM 
     */
    function get_uploaded_file_data(){
        return $this->uploaded_file_data;
    }

    /*
     * @Function            : get_upload_directory 
     * @Description         : get uploaded directory
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 26-10-2016 05:08 PM
     * @Parameter           : Null
     * @Return              : $upload_dir    
     * @Status              : Available        
     */

    function get_upload_directory() {
        return $this->upload_dir;
    }

    /*
     * @Function            : error_message 
     * @Description         : get error message
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 24-10-2016 11:19 AM
     * @Parameter           : Null
     * @Return              : NULL    
     * @Status              : Available        
     */

    function error_message() {
        return $this->error_message;
    }


    /*
     * @Function            : unset variable 
     * @Description         : unset variable
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 26-10-2016 02:51 PM
     * @Parameter           : $arg
     * @Return              : NULL    
     * @Status              : Available        
     */

    function unset_variable($arg) {
        if (!empty($arg)) {
            unset($arg);
        }
    }

    /*
     * @Function            : __destruct 
     * @Description         : destroy all asigned variable
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 23-10-2016 06:15 PM
     * @Parameter           : Null
     * @Return              : NULL    
     * @Status              : Available        
     */

    public function __destruct() {
        $this->unset_variable($this->size);
        $this->unset_variable($this->file_index);
        $this->unset_variable($this->file_name);
        $this->unset_variable($this->upload_dir);
        $this->unset_variable($this->allowed_type);
        $this->unset_variable($this->error_message);
        $this->unset_variable($this->file_extension);
        $this->unset_variable($this->uploaded_file_data);
    }

}
