<?php

/**
 * Description of TT_convert_currency
 *
 * @author User
 */
class TT_currency {

    private $to;
    private $from;
    private $amount;
    private $convert_value;
    private $output;

    /**
     * @Description         : set variable 
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 28-11-2016 11:06 PM  
     * @Parameter           : $to=>which currency to convert,
     *                        $from-> which converted currency
     *                        $amount=> how many amount to convert  
     * */
    function set($amount, $from, $to) {
        $this->to = $to;
        $this->from = $from;
        $this->amount = $amount;
        return $this;
    }

    /**
     * @Description         : convert currency
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 28-11-2016 11:06 PM   
     * */
    function convert_currency() {
        // get currency informaton using google API
        $url = "https://www.google.com/finance/converter?a=$this->amount&from=$this->from&to=$this->to";
        // return all file value in a string
        $data = file_get_contents($url);
        // get all converation value
        preg_match("/<span class=bld>(.*)<\/span>/", $data, $this->convert_value);
        $this->convert_value = preg_replace("/[^0-9.]/", "", $this->convert_value[1]);
        $this->output = round($this->convert_value, 2);
        return $this;
    }

    /**
     * @Description         : get final result
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 28-11-2016 11:06 PM   
     * */
    function get() {
        return $this->output;
    }

    public function __destruct() {
        if (!empty($this->amount)) {
            unset($this->amount);
        }
        if (!empty($this->convert_value)) {
            unset($this->convert_value);
        }
        if (!empty($this->from)) {
            unset($this->from);
        }
        if (!empty($this->output)) {
            unset($this->output);
        }
        if (!empty($this->to)) {
            unset($this->to);
        }
    }

}
