<?php

/**
 * Description of TT_migration
 *
 * @author User
 */
class TT_migration extends CI_Migration {

    private $field_name;
    public $table_info = [];

    function field_name($field_name) {
        $this->field_name = $field_name;
        return $this;
    }

    private $new_field_name;

    function new_field_name($new_field_name) {
        $this->new_field_name = $new_field_name;
        return $this;
    }

    private $type;

    function type($type) {
        $this->type = $type;
        return $this;
    }

    private $size = NULL;

    function size($size) {
        $this->size = $size;
        return $this;
    }

    private $attributes = FALSE;

    function attributes() {
        $this->attributes = TRUE;
        return $this;
    }

    private $unique = FALSE;

    function unique() {
        $this->unique = TRUE;
        return $this;
    }

    private $default = NULL;

    function set_default($default_value) {
        $this->default = $default_value;
        return $this;
    }

    private $first = FALSE;

    function first() {
        $this->first = TRUE;
        return $this;
    }

    private $after = NULL;

    function after($after) {
        $this->after = $after;
        return $this;
    }

    private $null = FALSE;

    function set_null() {
        $this->null = TRUE;
        return $this;
    }

    private $auto_increment = FALSE;

    function auto_increment() {
        $this->auto_increment = TRUE;
        return $this;
    }

    private $primary_key;

    function set_primary_key($primary_key) {
        $this->primary_key = $primary_key;
        return $this;
    }

    private $table_name;

    function set_table_name($table_name) {
        $this->table_name = $table_name;
        return $this;
    }

    private $new_table_name;

    function set_new_table_name($new_table_name) {
        $this->new_table_name = $new_table_name;
        return $this;
    }

    function generate() {
        if (!empty($this->new_field_name)) {
            $this->table_info[$this->field_name]['name'] = $this->new_field_name;
        }

        $this->table_info[$this->field_name]['type'] = $this->type;

        if (!empty($this->size)) {
            $this->table_info[$this->field_name]['constraint'] = $this->size;
        }

        if (!empty($this->attributes)) {
            $this->table_info[$this->field_name]['unsigned'] = $this->attributes;
        }

        if (!empty($this->unique)) {
            $this->table_info[$this->field_name]['unique'] = $this->unique;
        }

        if (!empty($this->default)) {
            $this->table_info[$this->field_name]['default'] = $this->default;
        }

        if (!empty($this->first)) {
            $this->table_info[$this->field_name]['first'] = $this->first;
        }

        if (!empty($this->after)) {
            $this->table_info[$this->field_name]['after'] = $this->after;
        }

        if (!empty($this->null)) {
            $this->table_info[$this->field_name]['null'] = $this->null;
        }

        if (!empty($this->auto_increment)) {
            $this->table_info[$this->field_name]['auto_increment'] = $this->auto_increment;
        }

        $this->unset_data();
        return $this;
    }

    function create() {
        $this->dbforge->add_field($this->table_info);
        $this->dbforge->add_key($this->primary_key, TRUE);
        $this->dbforge->create_table($this->table_name);
        return $this;
    }

    function rename() {
        $this->dbforge->rename_table($this->table_name, $this->new_table_name);
        return $this;
    }

    function drop() {
        $this->dbforge->drop_table($this->table_name);
        return $this;
    }

    function add_column() {
        $this->dbforge->add_column($this->table_name, $this->table_info);
        return $this;
    }

    function drop_column() {
        $this->dbforge->drop_column($this->table_name, $this->field_name);
        return $this;
    }

    function modify_column() {
        $this->dbforge->modify_column($this->table_name, $this->table_info);
        return $this;
    }

    function unset_data() {
        if (!empty($this->new_field_name)) {
            $this->new_field_name = NULL;
        }
        if (!empty($this->type)) {
            $this->type = NULL;
        }
        if (!empty($this->size)) {
            $this->size = NULL;
        }
        if (!empty($this->attributes)) {
            $this->attributes = FALSE;
        }
        if (!empty($this->unique)) {
            $this->unique = FALSE;
        }
        if (!empty($this->default)) {
            $this->default = NULL;
        }
        if (!empty($this->first)) {
            $this->first = FALSE;
        }
        if (!empty($this->after)) {
            $this->after = NULL;
        }
        if (!empty($this->null)) {
            $this->null = FALSE;
        }
        if (!empty($this->auto_increment)) {
            $this->auto_increment = FALSE;
        }
        if (!empty($this->primary_key)) {
            $this->primary_key = NULL;
        }
    }

}
