<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Welcome extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $person_id = $this->session->userdata('person_id');
//-------------Start check login Status------------------------------
        $data['left_side_menu_view'] = 1;
        $data['left_side'] = 1;
        $start_time = $this->session->userdata('login_start_time');
        $refresh_time = time();
        if ($refresh_time - $start_time > 1800) {
            $person_pc_info_id = $this->session->userdata('person_pc_info_id');
            $this->super_admin_profile_model->save_person_unexpected_value($person_pc_info_id);
        } else {
            $sData['login_start_time'] = $refresh_time;
            $this->session->set_userdata($sData);
        }
//-------------End check login Status------------------------------
        if ($person_id) {
            $this->notification_model->delete_after_one_month_notification();
            $this->redirect_to_session_url($person_id);
            $this->content_library_model->delete_person_content_library(); // delete person content libarary if deletion status is 2
        }
    }

    /**
     * @Function            : index 
     * @Used IN             : @function-'user/home.php'
     * @Description         : View Deshboard content  
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : Unknown
     * @Updated Date Time   : 31-05-2016 09:40 AM
     * @Updated By          : MD Jaherul Islam
     * @Parameter           : NULL
     * @View                : user/home, user/master
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available       
     * */
    public function index() {        
        if(defined('ACCESS_REQUEST')&& ACCESS_REQUEST == "external"){
            return;
        }
        $person_id = $this->session->userdata('person_id');
        if (!$person_id) {
            $this->view_home_page();
        } else {
            $person_info = $this->person_model->select_backend_active_person_information_by_user_id($person_id);
            if ($person_info) {
                redirect('super-admin');
            } else {
                $data['person_info'] = $this->person_model->get_single_person_information_by_person_id($person_id);
                $data['active_menu'] = '';
                $data['active_sub_menu'] = '';
                $data['left_side'] = 1;
                $data['left_side_menu_view'] = 1;

                $post_data = $this->post_model->get_dashboard_post_data($data);

                $post_data['main_content'] = $this->load->view('user/home', $post_data, TRUE);
                $this->load->view('user/master', $post_data);
            }
        }
    }

    /**
     * @Function            : redirect_to_session_url 
     * @Used IN             : @function-'__construct'      this[@Controller]
     * @Description         : redirect to session url if it have   
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 08-09-2016 10:24 AM
     * @Parameter           : NULL
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function redirect_to_session_url() {
        $redirect_url = $this->session->userdata('url');
        if ($redirect_url) {
            $this->session->unset_userdata('url');
            redirect($redirect_url);
        }
    }

    /**
     * @Function            : view_home_page 
     * @Used IN             : @function-'index'      welcome[@Controller]
     * @Description         : View front end home page with out loggin  
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : Unknown
     * @Parameter           : NULL
     * @View                : front_end/home, front_end/master
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available       
     * */
    public function view_home_page() {
        $data = $this->welcome_model->generate_menu();
        $data['meta_description'] = '';
        $data['meta_keywords'] = '';
        $data['author'] = '';

        $data['main_content'] = $this->load->view('front_end/home', $data, TRUE);
        $this->load->view('front_end/master', $data);
    }

    function download_public_content_library($post_id) {
        $result = $this->post_model->get_single_post_by_post_id($post_id);
        $profile = $this->post_model->get_profile_url($result->posted_by);
        $this->load->helper('download');
        $file_name = $result->post_file_original_name;
        $files_url = 'content-library/' . $profile->url . '/' . $result->post_details;
        $data = file_get_contents("$files_url");
        if ($data) {
            force_download($file_name, $data);
        } else {
            return;
        }
    }

    //-------------------------Start Public Profile Post View-----------------------------
    function view_post_details($id, $type) {
        $data['left_side'] = 1;
        $data['left_side_menu_view'] = 1;
        $result = $this->post_model->get_post_details($id, $type);
        $post_original_value = $this->tt_post->get_post_details($result);
        echo $this->cf->view_emoticons($post_original_value);
    }

    function view_next_post_value($person_id, $counter, $type) {
        $data['left_side'] = 1;
        $data['left_side_menu_view'] = 1;
        $data['person_info'] = $this->person_model->select_active_person_information_by_user_id($person_id);
        $data['profile_name'] = $data['person_info']->person_first_name . " " . $data['person_info']->person_last_name;
        if ($type == 'note') {
            $data['note_alert_counter'] = $counter;
            $data['post_type'] = $type;
            $data['public_note_alert'] = $this->post_model->all_public_note_person_id($person_id, $data['note_alert_counter']);
            foreach ($data['public_note_alert'] as $post_value) {
                $data['post_function'][$post_value->post_id] = $this->post_model->get_post_value_by_post_id($post_value->post_id);
                $data['post_url'][$post_value->post_id] = $this->post_model->select_post_comment_url($post_value->post_id, 1);
            }
            $data['total_public_note_alert'] = $this->post_model->total_count_public_note_alert_person_id($person_id, 1);
        }else if ($type == 'alert') {
            $data['note_alert_counter'] = $counter;
            $data['post_type'] = $type;
            $data['public_note_alert'] = $this->post_model->all_public_alert_person_id($person_id, $data['note_alert_counter']);
            foreach ($data['public_note_alert'] as $post_value) {
                $data['post_function'][$post_value->post_id] = $this->post_model->get_post_value_by_post_id($post_value->post_id);
                $data['post_url'][$post_value->post_id] = $this->post_model->select_post_comment_url($post_value->post_id, 1);
            }
            $data['total_public_note_alert'] = $this->post_model->total_count_public_note_alert_person_id($person_id, 2);
        } else if ($type == 'assignment') {
            $data['assignment_counter'] = $counter;
            $data['post_type'] = $type;
            $data['total_public_assaignment'] = $this->post_model->total_public_assaignment_person_id($person_id);
            $data['public_assaignment'] = $this->post_model->all_public_assignment_person_id($person_id, $data['assignment_counter']);
            foreach ($data['public_assaignment'] as $post_value) {
                $data['post_function'][$post_value->post_id] = $this->post_model->get_post_value_by_post_id($post_value->post_id);
            }
        } else if ($type == 'image') {
            $data['image_counter'] = $counter;
            $data['post_type'] = $type;
            $data['total_public_image'] = $this->post_model->total_public_image_person_id($person_id);
            $data['public_image'] = $this->post_model->all_public_image_person_id($person_id, $data['image_counter']);
            foreach ($data['public_image'] as $post_value) {
                $data['post_function'][$post_value->post_id] = $this->post_model->get_post_value_by_post_id($post_value->post_id);
            }
        } else if ($type == 'video') {
            $data['video_counter'] = $counter;
            $data['post_type'] = $type;
            $data['total_public_video'] = $this->post_model->total_public_video_person_id($person_id);
            $data['public_video'] = $this->post_model->all_public_video_person_id($person_id, $data['video_counter']);
            foreach ($data['public_video'] as $post_value) {
                $data['post_function'][$post_value->post_id] = $this->post_model->get_post_value_by_post_id($post_value->post_id);
            }
        }

        echo $this->load->view('user/profile_view/ajax_view/view_profile_right_content', $data, TRUE);
    }

    //-------------------------End Public Profile Post View-----------------------------

    public function view_skill_test($person_url, $quiz_url) {
        $data = $this->welcome_model->generate_menu();
        $data['left_side'] = 1;
        $data['left_side_menu_view'] = 1;
        $person_id = $this->session->userdata('user_id');
        $data['person_info'] = $this->profile_model->person_info_by_url($person_url);
        $data['quiz_info'] = $this->quiz_model->select_quiz_all_status_by_url($quiz_url);
        $data['active_menu'] = '';
        $data['active_sub_menu'] = '';
        $data['quiz_result'] = $this->quiz_model->select_quiz_result($data['person_info']->person_id, $data['quiz_info']->quiz_id);
        if (!$data['quiz_result']) {
            redirect($person_url . '/profile');
        }
        $data['quiz_questions'] = $this->quiz_model->select_active_question_by_quiz_id($data['quiz_info']->quiz_id);
        $data['quiz_total_participant'] = $this->quiz_model->select_person_rank($data['quiz_info']->quiz_id);
        $rank = 0;
        foreach ($data['quiz_total_participant'] as $v_participant) {
            if ($data['person_info']->person_id == $v_participant->person_id) {
                $rank++;
                break;
            }
            $rank++;
            if ($rank >= 25) {
                break;
            }
        }
        $data['person_rank'] = $rank;
        $data['correct_ans'] = $correct_ans = $data['quiz_result']->quiz_correct_answer;
        $data['wrong_ans'] = $wrong_ans = $data['quiz_result']->quiz_wrong_answer;
        $data['total_question'] = $total_question = $data['quiz_result']->quiz_total_question;
        $data['total_marks'] = $total_marks = $data['quiz_result']->quiz_total_marks;
        $data['receive_marks'] = $receive_marks = $data['quiz_result']->quiz_receive_marks;
        $data['taken_time'] = $taken_time = $data['quiz_result']->quiz_finish_time;
        if (!$correct_ans) {
            $correct_ans = 0;
        }
        if (!$wrong_ans) {
            $wrong_ans = 0;
        }
        if (!$receive_marks) {
            $receive_marks = 0;
        }

        $data['unanswered'] = $total_question - ($correct_ans + $wrong_ans);
        if ($total_question) {
            $data['correct_percentage'] = ($correct_ans * 100) / $total_question;
        } else {
            $data['correct_percentage'] = 0;
        }
        if ($total_marks) {
            $data['marks_percentage'] = ( $receive_marks * 100) / $total_marks;
        } else {
            $data['marks_percentage'] = 0;
        }

        $data['quiz_grade'] = $this->quiz_model->select_quiz_grade($data['quiz_info']->quiz_id);
        if ($data['quiz_grade']) {
            $temp_total = 0;
            foreach ($data['quiz_grade'] as $v_grade) {
                if ($receive_marks >= $v_grade->grade_number && $v_grade->grade_number > $temp_total) {
                    $temp_total = $v_grade->grade_number;
                    $grade_id = $v_grade->grade_id;
                } else {
                    $grade_id = $v_grade->grade_id;
                }
            }
            if ($grade_id) {
                $data['grade'] = $this->quiz_model->select_grade_by_id($grade_id);
            }
        }
        $data['main_content'] = $this->load->view('user/profile_view/view_skill_test', $data, true);

        $this->load->view('user/master', $data);
    }

    public function download($files_url, $resource_person_url) {
        $this->load->helper('download');
        $file_name = explode('/', $files_url);
        $file_name = $file_name[count($file_name) - 1];
        $files_url = 'content-library/' . $resource_person_url . '/' . $files_url;
        $data = file_get_contents("$files_url");
        if ($data) {
            force_download($file_name, $data);
        } else {
            return;
        }
    }

    public function start_class($url) {
        if ($this->uri->segment(2)) {
            redirect();
        }
        $data = array();
        $sdata = array();        
        $now = date('Y-m-d H:i:s', strtotime(gmdate('Y-m-d H:i:s')));

        $person_id = $this->session->userdata('user_id');
        $person_info = $this->profile_model->select_active_user_info_by_id($person_id);
        if (!$person_info) {
            redirect('sign-in');
        }
        // classroom info
        $data['classroom_info'] = $this->classroom_model->select_classroom_info_by_url($url);
        $classroom_id = $data['classroom_info']->classroom_id;
        $course_id = $data['classroom_info']->course_id;
        $classroom_creator = $data['classroom_info']->person_id;
        if (!$data['classroom_info']) {
            redirect('classroom/' . $this->session->userdata('active_menu'));
        }

        // Course information
        $data['course_info'] = $this->classroom_model->select_course_info_by_id($course_id);

        // Classroom course resource person
        $data['course_resource_person_info'] = $this->classroom_model->select_course_resource_person($course_id);
        $teacher_person_id = $data['course_resource_person_info']->person_id;

        //chacking schedule time
        $class_start_time = date('Y-m-d H:i:s', strtotime($data['classroom_info']->class_start_time));
        $class_time_in_second = $data['course_resource_person_info']->class_hour_per_day * 60 * 60;
        $class_possible_end_time = date("Y-m-d H:i:s", (strtotime($class_start_time) + $class_time_in_second));

        // Check Permission
        if ($teacher_person_id == $person_id || $person_id == $classroom_creator) {
            $permission = TRUE;
            //we have to check virtual classroom feature
            $allow = $this->check_feature_start_class($data['classroom_info']);
            if ($allow == 2) {
                $permission = TRUE;
            } else {
                $permission = TRUE;
            }
            /* ACTIVATE CLASSROOM AGAIN for Leave OR Unexpectedly End Classroom */
            $status = $data['classroom_info']->classroom_status;
            if ($status == 0 && $now < $class_start_time) {
                if ($data['classroom_info']->classroom_teacher_join_status == 6) {
                    $this->classroom_model->classroom_teacher_status_update_to_visit($classroom_id); //classroom teacher status will be 5 = visited
                }
            } else if (($status == 0 || $status == 3 || $status == 4 || $status == 5 || $status == 7) && ($now > $class_start_time && $now < $class_possible_end_time)) {//&& $data['classroom_info']->classroom_status == 1
                $this->classroom_model->activate_classroom($classroom_id); // set classroom_teacher_update_time and classroom teacher status will be 7 = joined
                $this->classroom_model->set_classroom_image_upload_table($classroom_id); // set $classroom_id in tbl_classroom_image_upload 
            } else if ($status == 6) {
                $permission = FALSE;
            }
        } else if ($person_id) {
            $data['student_info'] = $this->classroom_model->select_student_info_by_course_id($person_id, $course_id);
            if (!$data['student_info']) {
                redirect('course/learner');
            }

            // if paid course check student payment status
            if ($data['course_info']->course_type == 1) {
                $data['student_payment_status'] = $this->classroom_model->select_student_payment_status($data['student_info']->payment_id);
                $permission = TRUE;
            } else {
                $permission = TRUE;
            }

            //we have to check virtual classroom feature for number of attendee
            $data['classroom_student_info'] = $this->classroom_model->select_classroom_student_information($classroom_id, $data['student_info']->student_id);
            $sdata['classroom_student_id'] = $classroom_student_id = $data['classroom_student_info']->classroom_student_id;
            $student_join_status = $data['classroom_student_info']->classroom_student_join_status;
            if (!$data['classroom_student_info']) {
                $permission = FALSE;
            } else if ($student_join_status == 2) {
                $permission = FALSE;
            }
            //SET CLASS TIME OR DEMO
            if (($student_join_status == 5 || $student_join_status == 6) && $now < $class_start_time) {
                $permission = TRUE;
                $this->classroom_model->set_classroom_student_visited($classroom_student_id);
            } else if (($student_join_status == 3 || $student_join_status == 5 || $student_join_status == 6 || $student_join_status == 7) && ($now > $class_start_time && $now < $class_possible_end_time)) {//&& $data['classroom_info']->classroom_status == 1
                $permission = TRUE;
                $this->classroom_model->activate_classroom_student_again($classroom_student_id);
            }
        } else {
            $sdata['url'] = $url;
            redirect('sign-in');
        }

        // If permission is true then load classroom view

        if ($permission == TRUE) {
            $data['all_students'] = $this->classroom_model->select_class_room_student($course_id);
            foreach ($data['all_students'] as $v_course_student) {
                $data['attendee_student'][$v_course_student->student_id] = $this->classroom_model->select_class_room_attended_student($v_course_student->student_id);
            }

            //$base_url = "http://classroom.talhatraining.com/";
            $base_url = "http://localhost/classroom/";
            $redirect_url = "$base_url#$url";
            header("location: $redirect_url");
        } else {
            redirect('course/learner');
        }
    }

    public function check_feature_start_class($clasroom_info) {
        $schedule_date = date('Y-m-d', strtotime($clasroom_info->class_start_time));
        $schedule_time = date('H:i:s', strtotime($clasroom_info->class_start_time));
        $class_duration = $clasroom_info->class_duration * 60;
        $schedule_start_date_time = date('Y-m-d H:i:s', strtotime($clasroom_info->class_start_time));
        $schedule_end_date_time = date('Y-m-d H:i:s', strtotime($clasroom_info->class_end_time));

        $person_id = $this->session->userdata('user_id');
        $person_role = $this->session->userdata('person_role');

        $data['person_info'] = $this->profile_model->person_info_by_person_id($person_id);

        //START CHECK FEATURE
        $data['schedule_date'] = $schedule_date;
        $data = $this->classroom_model->person_feature_info($data);
        if ($data['status'] === '0' || $data['status'] === '3') {
            return $data['status'];
        }

        $total_scheduled_class = 0;
        if ($person_role == 4) {
            $organization_id = $this->session->userdata('organization_id');
            $data['org_resource_person'] = $this->classroom_model->select_organization_resource_person_by_org_id($organization_id);
            foreach ($data['org_resource_person'] as $value) {
                $result = $this->classroom_model->person_class_schedule($value->person_id);
                foreach ($result as $value) {
                    $scheduled_class = $this->classroom_model->person_class_schedule_by_date_time($value->classroom_id, $schedule_start_date_time, $schedule_end_date_time);
                    if ($scheduled_class) {
                        $total_scheduled_class++;
                    }
                }
            }
        } else if ($person_role == 3) {
            $result = $this->classroom_model->person_class_schedule($person_id);
            foreach ($result as $value) {
                $scheduled_class = $this->classroom_model->person_class_schedule_by_date_time($value->classroom_id, $schedule_start_date_time, $schedule_end_date_time);
                if ($scheduled_class) {
                    $total_scheduled_class++;
                }
            }
        }

        $feature_price_id = explode(',', $data['person_info']->feature_price_id);
        $data['virtual_classroom_feature_info'] = $this->classroom_model->select_active_feature_by_feature_id($feature_price_id[0]);
        if ($data['virtual_classroom_feature_info']) {
            $data['virtual_classroom_number'] = $data['virtual_classroom_feature_info']->virtual_classroom_number;
            $data['virtual_classroom_attendees_number'] = $data['virtual_classroom_feature_info']->virtual_classroom_attendees_number;
            $data['virtual_classroom_type'] = $data['virtual_classroom_feature_info']->virtual_classroom_type;
        } else {
            return 1;
        }
        if ($total_scheduled_class >= $data['virtual_classroom_number']) {
            return 1;
        }
        return 2;
    }

// END Classroom Authentication


    public function select_course($course_category_id, $course_category_name) {
        $data = array();
        $data['all_menus'] = $this->welcome_model->select_all_published_menu();
        $data['course_category_name'] = str_replace('%20', ' ', $course_category_name);
        $data['course'] = $this->welcome_model->select_course($course_category_id);
        $data['main_content'] = $this->load->view('front_end_user/front_end_dashboard', $data, TRUE);
        $data['course_category'] = $this->welcome_model->select_course_category();

        $this->load->view('front_end_user/front_end_master_page', $data);
    }

    public function add_to_wish($course_id) {
        $person_id = $this->session->userdata('user_id');
        if ($person_id) {
            $sdata = array();
            $sdata['course_id'] = $this->session->userdata('course_id');
            $sdata['person_id'] = $person_id;
            $sdata['wishlist_status'] = 1;
            $this->welcome_model->add_to_wish($sdata);
            redirect('profile/wishlist_content');
        } else {
            $data = array();
            $data['wish_url'] = 'test';
            $data['course_id'] = $course_id;
            $this->session->set_userdata($data);
            redirect('sign-in');
        }
    }

    public function redirect_to_view_invoice($payment_id) {
        $this->remove_pricing_page_session_after_create_invoice();
        $e_payment_id = $this->encrypt->encode($payment_id);
        $id = str_replace("/", "%F2", $e_payment_id);
        redirect('view-invoice-set-id/' . $id);
    }

// Online Exam Buying=============================================

    public function check_user_for_exam_buy() {
        $free_exam = $this->input->post('free_exam', TRUE);
        if ($free_exam == 'free') {
            redirect('sign-in');
        }
        $person_id = $this->input->post('person_id', TRUE);
        $sdata = array();
        $data = array();
        $data['person_info'] = $this->profile_model->student_info_by_id($person_id);

        $sdata['person_id'] = $this->input->post('person_id', TRUE);
        $sdata['unit_p'] = $this->input->post('monthly_price', TRUE);
        $sdata['totla_price'] = $this->input->post('monthly_price', TRUE);
        $sdata['package_time'] = $this->input->post('package_time', TRUE);
        $sdata['storageCapacity'] = '1 GB';
        $sdata['online_exam_feature_id'] = $this->input->post('online_exam_feature_id', TRUE);
        $this->session->set_userdata($sdata);

        if ($person_id) {
            redirect('f_end/save_buying_online_exam_info');
        } else {
            $edata = array();
            $edata['exam_buy'] = 'exam_buy';
            $this->session->set_userdata($edata);
            redirect('sign-in');
        }
    }
 

    public function manage_error() {
        $person_role = $this->session->userdata('person_role');
        if ($person_role == '3' || $person_role == '4' || $person_role == '5') {
            exit();
            $data = array();
            $data['active'] = '';
            $data['main_content'] = $this->load->view('admin/error_page', $data, true);
            $this->load->view('front_end/master', $data);
        } else if ($person_role == '1' || $person_role == '2' || $person_role == '6') {
            $data = array();
            $data['active'] = '';
            $data['main_content'] = $this->load->view('admin/error_page', $data, true); //error_page
            $this->load->view('admin/admin_master', $data);
        } else {
            exit();
            $data = array();
            $data['active'] = '';
            $data['active'] = $this->load->view('admin/error_page', $data, true); //error_page

            $data['main_content'] = 'We are sorry, the page you requested cannot be found.';
            $this->load->view('f_end/error_page', $data);
        }
    }

    /*
     * ----------------------------Start Public View (Quiz)-------------------------------------
     */

    public function run_course_quiz($quiz_public_id) {

        $running_quiz_status = $this->session->userdata('running_quiz_status');
        if (!$running_quiz_status) {
            $this->session->unset_userdata('correct_ans');
            $this->session->unset_userdata('wrong_ans');
            $this->session->unset_userdata('total_question');
            $this->session->unset_userdata('total_marks');
            $this->session->unset_userdata('receive_marks');
            $this->session->unset_userdata('quiz_id');
            $this->session->unset_userdata('taken_time');
            unset($_SESSION['pageload']);
        }
        $data['quiz_info'] = $result = $this->quiz_model->select_quiz_by_public_id($quiz_public_id);

        if (!$data['quiz_info']) {
            echo'This Course Have No Quiz';
            return;
        }
        $quiz_id = $result->quiz_id;

        $data['question'] = $this->f_end_model->select_all_active_question_info($quiz_id);
        foreach ($data['question'] as $term) {
            $data['options'][$term->question_id] = $this->f_end_model->select_question_by_id($term->question_id);
        }
        $data['total_question'] = count($this->f_end_model->select_all_active_question_info($quiz_id));
        $data['total_marks'] = $this->f_end_model->select_all_marks_active_question_info($quiz_id);

        $sdata = array();
        if ($data['quiz_info']->quiz_random_static == 1) {

            if (count($data['question']) > $data['quiz_info']->total_number_of_question) {
                $sdata['total_question'] = $data['quiz_info']->total_number_of_question;
            } else {
                $sdata['total_question'] = count($data['question']);
            }
        } else {
            $sdata['total_question'] = $data['total_question'];
        }
        $sdata['total_marks'] = $data['total_marks']->total;
        $sdata['quiz_id'] = $quiz_id;
        $sdata['quiz_public_id'] = $quiz_public_id;
        $sdata['running_quiz_status'] = TRUE;
        $this->session->set_userdata($sdata);

        if ($result && $result->quiz_pulication_status != 5) {
            echo'Quiz Not assign for this Course';
            return;
        }

        $data['creator_info'] = $this->profile_model->person_info_by_person_id($result->quiz_created_by);

        echo $this->load->view(
                'front_end/quiz/course_quiz_test', $data);
    }

    public function set_to_cart($id, $name, $answer = '') {

        $this->load->library('cart');
        if ($answer) {
            $data = array(
                'id' => $id,
                'qty' => 1,
                'price' => 1.5,
                'name' => "question",
                'options' => array('answer' => "$answer")
            );
            $this->cart->insert($data);
        } else {
            $data = array(
                'id' => $id,
                'qty' => 1,
                'price' => 1.5,
                'name' => 'question',
                'options' => array('answer' => '')
            );
            $this->cart->insert($data);
        }
    }

    public function quiz_marking($quiz_public_id) {
        $mark_per_question = $this->input->post('points_per_answer', TRUE);
        $question_type = $this->input->post('question_type', TRUE);
        $question_id = $this->input->post('question_id', TRUE);
        $taken_time = $this->input->post('taken_time', TRUE);
        $question_number = $this->input->post('question_number', TRUE);

        $question_info = $this->quiz_model->select_question_info_by_id($question_id);

        if ($this->input->post('submit_btn', TRUE) == 'Skip Question') {
            $qdata['taken_time'] = $this->session->userdata('taken_time') + $taken_time;
            $this->session->set_userdata($qdata);
            $this->run_course_quiz($quiz_public_id);
        }

        if ($question_type == 3) {

            $answer_word = $this->f_end_model->select_answer_words($question_id);

            $answer = $this->input->post('desc_answer', TRUE);

            $student_answer = (explode(" ", $answer));
            $words = array(".", "?", ":", ",", ";", "'", "(", ")", "=", "+", "  ");
            $student_answer = str_replace($words, "", $student_answer);
            $unique_ans = array_unique($student_answer);

            $temp_ans_count = 0;
            if ($unique_ans) {
                foreach ($unique_ans as $v_answer) {
                    $result = $this->f_end_model->match_answer_word($v_answer);
                    if ($result) {
                        $temp_ans_count++;
                    }
                }
                $this->set_to_cart($question_id, $question_info->question_details, $answer);
                echo $answer;
            }

            $percentage = ( $temp_ans_count * 100) / $answer_word;
            if ($percentage >= 5) {
                $qdata['correct_ans'] = $this->session->userdata('correct_ans') + 1;
                $qdata['receive_marks'] = $this->session->userdata('receive_marks') + $mark_per_question;
                $qdata['taken_time'] = $this->session->userdata('taken_time') + $taken_time;
                $this->session->set_userdata($qdata);
                $this->run_course_quiz($quiz_public_id);
            } else {
                $qdata['wrong_ans'] = $this->session->userdata('wrong_ans') + 1;
                $qdata['taken_time'] = $this->session->userdata('taken_time') + $taken_time;
                $this->session->set_userdata($qdata);
                $this->run_course_quiz($quiz_public_id);
            }
        } else if ($question_type == 4) {

            $result = $this->f_end_model->select_fil_answer_words($question_id);
            $answer_word = explode(",", $result->descriptive_ans_keyword);
            $total_answer_word = count(array_pop($answer_word));

            $answer = $this->input->post('fill_answer', TRUE);
            $student_answer = (explode(" ", $answer));
            $words = array(".", "?", ":", ",", ";", "'", "(", ")", "=", "+", "  ");
            $student_answer = str_replace($words, "", $student_answer);
            $unique_ans = array_unique($student_answer);

            $temp_ans_count = 0;
            if ($unique_ans) {
                foreach ($unique_ans as $v_answer) {
                    $result = $this->f_end_model->match_fil_answer_word($v_answer);
                    if ($result) {
                        $temp_ans_count++;
                    }
                }
                $this->set_to_cart($question_id, $question_info->question_details, $answer);
            }

            $percentage = ( $temp_ans_count * 100) / $total_answer_word;

            if ($percentage >= 5) {
                $qdata['correct_ans'] = $this->session->userdata('correct_ans') + 1;
                $qdata['receive_marks'] = $this->session->userdata('receive_marks') + $mark_per_question;
                $qdata['taken_time'] = $this->session->userdata('taken_time') + $taken_time;
                $this->session->set_userdata($qdata);
                $this->run_course_quiz($quiz_public_id);
            } else {
                $qdata['wrong_ans'] = $this->session->userdata('wrong_ans') + 1;
                $qdata['taken_time'] = $this->session->userdata('taken_time') + $taken_time;
                $this->session->set_userdata($qdata);
                $this->run_course_quiz($quiz_public_id);
            }
        } else {
            $value = $_POST['status'];
            if ($value == '') {
                $qdata['taken_time'] = $this->session->userdata('taken_time') + ($question_info->time_limit / 60);
                $this->session->set_userdata($qdata);
                $this->set_to_cart($question_id, $question_info->question_details, '');
                $this->run_course_quiz($quiz_public_id);
                return;
            }
            $result = $this->f_end_model->confirm_answer($value);
            $sdata = array();
            if ($result) {
                $qdata['correct_ans'] = $this->session->userdata('correct_ans') + 1;
                $qdata['receive_marks'] = $this->session->userdata('receive_marks') + $mark_per_question;
                $qdata['taken_time'] = $this->session->userdata('taken_time') + $taken_time;
                $this->session->set_userdata($qdata);
                $this->run_course_quiz($quiz_public_id);

                return;
            } else {
                $qdata['wrong_ans'] = $this->session->userdata('wrong_ans') + 1;
                $this->session->set_userdata($qdata);
                $this->run_course_quiz($quiz_public_id);

                return;
            }
        }
    }

    public function previous_question($question_id) {
        $data = array();
        $data['question_id'] = $question_id;
        $data['question'] = $this->quiz_model->select_question_info_by_id($question_id);
        $data['options'] = $this->f_end_model->select_question_by_id($question_id);

        echo $this->load->view('front_end/quiz/course_quiz_previous_question', $data, true);
    }

    public function quiz_result() {
        $this->cart->destroy();
        $quiz_id = $this->session->userdata('quiz_id');
        $quiz_public_id = $this->session->userdata('quiz_public_id');
        $person_id = $this->session->userdata('person_id');

        $this->session->unset_userdata('running_quiz_status');

        $data['quiz_info'] = $this->quiz_model->select_quiz_by_public_id($quiz_public_id);
        $data['quiz_questions'] = $this->quiz_model->select_active_question_by_quiz_id($data['quiz_info']->quiz_id);

        $data['correct_ans'] = $correct_ans = $this->session->userdata('correct_ans');
        $data['wrong_ans'] = $wrong_ans = $this->session->userdata('wrong_ans');
        $data['total_question'] = $total_question = $this->session->userdata('total_question');
        $data['total_marks'] = $total_marks = $this->session->userdata('total_marks');
        $data['receive_marks'] = $receive_marks = $this->session->userdata('receive_marks');
        $data['taken_time'] = $taken_time = $this->session->userdata('taken_time');

        if (!$correct_ans) {
            $correct_ans = 0;
        }
        if (!$wrong_ans) {
            $wrong_ans = 0;
        }
        if (!$receive_marks) {
            $receive_marks = 0;
        }

        $data['unanswered'] = $total_question - ($correct_ans + $wrong_ans);

        if ($total_question) {
            $data['correct_percentage'] = ($correct_ans * 100) / $total_question;
        } else {
            $data['correct_percentage'] = 0;
        }
        if ($total_marks) {
            $data['marks_percentage'] = ( $receive_marks * 100) / $total_marks;
        } else {
            $data['marks_percentage'] = 0;
        }

        $data['quiz_grade'] = $this->quiz_model->select_quiz_grade($data['quiz_info']->quiz_id);
        if ($data['quiz_grade']) {
            foreach ($data['quiz_grade'] as $v_grade) {
                if ($receive_marks >= $v_grade->grade_number && $v_grade->grade_number > $temp_total) {
                    $temp_total = $v_grade->grade_number;
                    $grade_id = $v_grade->grade_id;
                } else {
                    $grade_id = $v_grade->grade_id;
                }
            }
            if ($grade_id) {
                $data['grade'] = $this->quiz_model->select_grade_by_id($grade_id);
            }
        }


        echo $this->load->view('front_end/quiz/course_quiz_result', $data, true);
    }

    public function run_video_course_quiz($quiz_public_id) {

        $running_quiz_status = $this->session->userdata('running_quiz_status');
        if (!$running_quiz_status) {
            $this->session->unset_userdata('correct_ans');
            $this->session->unset_userdata('wrong_ans');
            $this->session->unset_userdata('total_question');
            $this->session->unset_userdata('total_marks');
            $this->session->unset_userdata('receive_marks');
            $this->session->unset_userdata('quiz_id');
            $this->session->unset_userdata('taken_time');
            unset($_SESSION['pageload']);
        }

        $data['quiz_info'] = $result = $this->quiz_model->select_quiz_by_public_id($quiz_public_id);

        if (!$data['quiz_info']) {
            echo'This Course Have No Quiz';
            return;
        }
        $quiz_id = $result->quiz_id;

        $data['question'] = $this->f_end_model->select_all_active_question_info($quiz_id);
        foreach ($data['question'] as $term) {
            $data['options'][$term->question_id] = $this->f_end_model->select_question_by_id($term->question_id);
        }
        $data['total_question'] = count($this->f_end_model->select_all_active_question_info($quiz_id));
        $data['total_marks'] = $this->f_end_model->select_all_marks_active_question_info($quiz_id);

        $sdata = array();
        if ($data['quiz_info']->quiz_random_static == 1) {

            if (count($data['question']) > $data['quiz_info']->total_number_of_question) {
                $sdata['total_question'] = $data['quiz_info']->total_number_of_question;
            } else {
                $sdata['total_question'] = count($data['question']);
            }
        } else {
            $sdata['total_question'] = $data['total_question'];
        }
        $sdata['total_marks'] = $data['total_marks']->total;
        $sdata['quiz_id'] = $quiz_id;
        $sdata['quiz_public_id'] = $quiz_public_id;
        $sdata['running_quiz_status'] = TRUE;
        $this->session->set_userdata($sdata);

        if ($result && $result->quiz_pulication_status != 6) {
            echo'Quiz Not assign for this Video Course';
            return;
        }

        $data['creator_info'] = $this->profile_model->person_info_by_person_id($result->quiz_created_by);

        echo $this->load->view('front_end/quiz/video_course_quiz_test', $data, TRUE);
    }

    public function video_quiz_marking($quiz_public_id) {

        $mark_per_question = $this->input->post('points_per_answer', TRUE);
        $question_type = $this->input->post('question_type', TRUE);
        $question_id = $this->input->post('question_id', TRUE);
        $taken_time = $this->input->post('taken_time', TRUE);
        $question_number = $this->input->post('question_number', TRUE);

        $question_info = $this->quiz_model->select_question_info_by_id($question_id);

        if ($question_type == 3) {

            $answer_word = $this->f_end_model->select_answer_words($question_id);

            $answer = $this->input->post('desc_answer', TRUE);

            $student_answer = (explode(" ", $answer));
            $words = array(".", "?", ":", ",", ";", "'", "(", ")", "=", "+", "  ");
            $student_answer = str_replace($words, "", $student_answer);
            $unique_ans = array_unique($student_answer);

            $temp_ans_count = 0;
            if ($unique_ans) {
                foreach ($unique_ans as $v_answer) {
                    $result = $this->f_end_model->match_answer_word($v_answer);
                    if ($result) {
                        $temp_ans_count++;
                    }
                }
                $this->set_to_cart($question_id, $question_info->question_details, $answer);
                echo $answer;
            }

            $percentage = ( $temp_ans_count * 100) / $answer_word;

            if ($percentage >= 5) {
                $qdata['correct_ans'] = $this->session->userdata('correct_ans') + 1;
                $qdata['receive_marks'] = $this->session->userdata('receive_marks') + $mark_per_question;
                $qdata['taken_time'] = $this->session->userdata('taken_time') + $taken_time;
                $this->session->set_userdata($qdata);
                $this->run_video_course_quiz($quiz_public_id);
            } else {
                $qdata['wrong_ans'] = $this->session->userdata('wrong_ans') + 1;
                $qdata['taken_time'] = $this->session->userdata('taken_time') + $taken_time;
                $this->session->set_userdata($qdata);
                $this->run_video_course_quiz($quiz_public_id);
            }
        } else if ($question_type == 4) {

            $result = $this->f_end_model->select_fil_answer_words($question_id);
            $answer_word = explode(",", $result->descriptive_ans_keyword);
            $total_answer_word = count(array_pop($answer_word));

            $answer = $this->input->post('fill_answer', TRUE);
            $student_answer = (explode(" ", $answer));
            $words = array(".", "?", ":", ",", ";", "'", "(", ")", "=", "+", "  ");
            $student_answer = str_replace($words, "", $student_answer);
            $unique_ans = array_unique($student_answer);

            $temp_ans_count = 0;
            if ($unique_ans) {
                foreach ($unique_ans as $v_answer) {
                    $result = $this->f_end_model->match_fil_answer_word($v_answer);
                    if ($result) {
                        $temp_ans_count++;
                    }
                }
                $this->set_to_cart($question_id, $question_info->question_details, $answer);
            }

            $percentage = ( $temp_ans_count * 100) / $total_answer_word;

            if ($percentage >= 5) {
                $qdata['correct_ans'] = $this->session->userdata('correct_ans') + 1;
                $qdata['receive_marks'] = $this->session->userdata('receive_marks') + $mark_per_question;
                $qdata['taken_time'] = $this->session->userdata('taken_time') + $taken_time;
                $this->session->set_userdata($qdata);
                $this->run_video_course_quiz($quiz_public_id);
            } else {
                $qdata['wrong_ans'] = $this->session->userdata('wrong_ans') + 1;
                $qdata['taken_time'] = $this->session->userdata('taken_time') + $taken_time;
                $this->session->set_userdata($qdata);
                $this->run_video_course_quiz($quiz_public_id);
            }
        } else {
            $value = $_POST['status'];
            if ($value == '') {
                $qdata['taken_time'] = $this->session->userdata('taken_time') + ($question_info->time_limit * 60);
                $this->session->set_userdata($qdata);
                $this->set_to_cart($question_id, $question_info->question_details, '');
                $this->run_video_course_quiz($quiz_public_id);

                return;
            }
            $result = $this->f_end_model->confirm_answer($value);
            $sdata = array();
            if ($result) {
                $qdata['correct_ans'] = $this->session->userdata('correct_ans') + 1;
                $qdata['receive_marks'] = $this->session->userdata('receive_marks') + $mark_per_question;
                $qdata['taken_time'] = $this->session->userdata('taken_time') + $taken_time;
                $this->session->set_userdata($qdata);
                $this->run_video_course_quiz($quiz_public_id);
                return;
            } else {
                $qdata['wrong_ans'] = $this->session->userdata('wrong_ans') + 1;
                $this->session->set_userdata($qdata);
                $this->run_video_course_quiz($quiz_public_id);
                return;
            }
        }
    }

    public function video_quiz_result() {
        $this->cart->destroy();
        $quiz_id = $this->session->userdata('quiz_id');
        $quiz_public_id = $this->session->userdata('quiz_public_id');
        $person_id = $this->session->userdata('person_id');

        $this->session->unset_userdata('running_quiz_status');

        $data['quiz_info'] = $this->quiz_model->select_quiz_by_public_id($quiz_public_id);
        $data['quiz_questions'] = $this->quiz_model->select_active_question_by_quiz_id($data['quiz_info']->quiz_id);
        $data['correct_ans'] = $correct_ans = $this->session->userdata('correct_ans');
        $data['wrong_ans'] = $wrong_ans = $this->session->userdata('wrong_ans');
        $data['total_question'] = $total_question = $this->session->userdata('total_question');
        $data['total_marks'] = $total_marks = $this->session->userdata('total_marks');
        $data['receive_marks'] = $receive_marks = $this->session->userdata('receive_marks');
        $data['taken_time'] = $taken_time = $this->session->userdata('taken_time');

        if (!$correct_ans) {
            $correct_ans = 0;
        }
        if (!$wrong_ans) {
            $wrong_ans = 0;
        }
        if (!$receive_marks) {
            $receive_marks = 0;
        }

        $data['unanswered'] = $total_question - ($correct_ans + $wrong_ans);

        if ($total_question) {
            $data['correct_percentage'] = ($correct_ans * 100) / $total_question;
        } else {
            $data['correct_percentage'] = 0;
        }
        if ($total_marks) {
            $data['marks_percentage'] = ( $receive_marks * 100) / $total_marks;
        } else {
            $data['marks_percentage'] = 0;
        }

        $data['quiz_grade'] = $this->quiz_model->select_quiz_grade($data['quiz_info']->quiz_id);
        if ($data['quiz_grade']) {
            foreach ($data['quiz_grade'] as $v_grade) {
                if ($receive_marks >= $v_grade->grade_number && $v_grade->grade_number > $temp_total) {
                    $temp_total = $v_grade->grade_number;
                    $grade_id = $v_grade->grade_id;
                } else {
                    $grade_id = $v_grade->grade_id;
                }
            }
            if ($grade_id) {
                $data['grade'] = $this->quiz_model->select_grade_by_id($grade_id);
            }
        }

        echo $this->load->view('front_end/quiz/course_quiz_result', $data, true);
    }

    /*
     * ----------------------------End Public View (Quiz)-------------------------------------
     */

    /*
     * ----------------------------Start Public View (Group)-------------------------------------
     */

    /**
     * @Function            : join_group
     * @Used IN             : group_public_view
     * @Description         : send join group requst from group public view
     * @Developed By        : Afrin jahan noumin 
     * @Start DateTime      : 1/06/2016
     * @Updated Date Time   : 
     * @Updated By          :       
     * @Parameter           : 
     * @View                : 
     * @Redirect            : 'group/' . $group_url
     * @Return              :   
     * @Status              : Available       
     */
    public function join_group($group_code) {

        $data['group_info'] = $this->group_model->group_info_by_public_id($group_code);
        if (!$data['group_info']) {
            redirect();
        }
        $user_id = $this->session->userdata('user_id');
        $group_id = $data['group_info']->group_id;
        if ($user_id) {
            $group_id = $data['group_info']->group_id;
            $result = $this->group_model->check_member_requst($user_id, $group_id);
            $gdata = array();
            if (!$result) {
                $gdata['person_id'] = $user_id;
                $gdata['group_id'] = $group_id;
                $offset = $this->session->userdata('time_offset');
                $gdata['group_join_date_time'] = date('y-m-d-h-i-s', (time() - $offset));
                $gdata['group_member_status'] = 3;
                $this->group_model->save_group_member_information($gdata);
                //.................. save group notification for sending group request to group creator.................
                $this->notification_model->save_group_request_notification_to_creator($user_id, $data['group_info']);
                //.................. END save group notification for sending group request to group creator.............

                $sdata = array();
                redirect('group/' . $data['group_info']->url);
            } elseif ($result && $result->group_member_status == 3) {
                redirect('group/' . $data['group_info']->url);
            } elseif ($result && $result->group_member_status == 1) {
                redirect('group/' . $data['group_info']->url);
            } elseif ($result && $result->group_member_status == 2) {
                $this->group_model->active_archive_member_id($user_id, $group_id);
                //.................. save group notification for sending group request to group creator.................
                $this->notification_model->save_group_request_notification_to_creator($user_id, $data['group_info']);
                //.................. END save group notification for sending group request to group creator.............
                redirect('group/' . $data['group_info']->url);
            }
        } else {
            $sdata ['url'] = base_url() . 'join-group/' . $group_code;
            $this->session->set_userdata($sdata);
            redirect('sign-in');
        }
    }
    
    /**
     * @Function            : group_view 
     * @Description         : Loads the view for individual group details
     * @Developed By        : Unknown
     * @Updated By          : Md Mashqur Ul Alam [03-09-17]
     * @Parameter           : $code[url of a group]    
     * @Status              : available      
     * */
    public function group_view() {
        $person_id = $this->session->userdata('user_id');
        $data = $this->welcome_model->generate_menu();
        $data['active_menu'] = '';
        $data['active_sub_menu'] = '';
        $data['right_content_variation'] = 1;
        $number = $this->input->post('number', TRUE);

        $code = $this->uri->segment(2);
        $result = $this->group_model->selected_group_details_info_by_code($code);
        if (!$result) {
            redirect();
        }
        $data['group_info'] = $this->group_model->group_info_for_public($result->group_id);
        if (!$data['group_info']) {
            redirect();
        } else {
            $group_permission = $data['group_info']->group_permission;

            switch ($group_permission) {
                case 2:
                    if (!$person_id) {
                        $sdata ['url'] = 'group/' . $code;
                        $this->session->set_userdata($sdata);
                        redirect('sign-in', 'refresh');
                    }
                    break;

                case 3:
//check_user in my link
                    if (!$person_id) {
                        $sdata ['url'] = 'group/' . $code;
                        $this->session->set_userdata($sdata);
                        redirect('sign-in', 'refresh');
                    }

                    if ($person_id != $data['group_info']->group_created_by) {
                        $person_link = $this->profile_model->select_person_to_person_link($data['group_info']->group_created_by);
                        if (!$person_link) {
// redirecting to Group creator profile
                            $sdata['url'] = 'group/' . $code;
                            $this->session->set_userdata($sdata);

                            $data['creator_info'] = $this->profile_model->person_info_by_id($data['group_info']->group_created_by);
                            redirect($data ['creator_info']->url . '/profile');
                        }
                    }
                    break;

                case 4:
//check_user in only_group_member
                    if (!$person_id) {
                        $sdata ['url'] = 'group/' . $code;
                        $this->session->set_userdata($sdata);
                        redirect('sign-in', 'refresh');
                    }

                    if ($person_id != $data['group_info']->group_created_by) {
                        $person_group_info = $this->group_model->check_group_active_member($person_id, $data['group_info']->group_id);
                        if (!$person_group_info) {
// redirecting to Group creator profile
                            $sdata['message'] = '<span style=color:red> \'' . $data['group_info']->group_name . '\' group is only for group member. Send request for join group </span>';
                            $this->session->set_userdata($sdata);
                            redirect('groups/learner');
                        }
                        if ($person_group_info->group_member_status == 3) {
                            $sdata['message'] = '<span style=color:red> \'' . $data['group_info']->group_name . '\' group is only for group member. Your Request is pending </span>';
                            $this->session->set_userdata($sdata);
                            redirect('groups/learner');
                        }
                    }
                    break;

                default:
                    break;
            }

            $data['group_creator_info'] = $this->profile_model->person_info_by_id($data['group_info']->group_created_by);
            if ($person_id) {
                $data['group_member_info'] = $this->group_model->check_member_requst($person_id, $result->group_id);
            }
            $data['count_group_member'] = $this->group_model->select_group_member_list_info($data['group_info']->group_id);
            $data['group_member_list'] = $this->group_model->select_group_member_info_for_public_view($data['group_info']->group_id, 10);
            //$data['group_quiz'] = $this->group_model->select_group_quiz_list($data['group_info']->group_id);
            //$data['group_popular_quiz'] = $this->group_model->select_group_popular_quiz($data['group_info']->group_id);

            $data['main_content'] = $this->load->view('user/group_public_view', $data, true);
            $this->load->view('user/master', $data);
        }
    }

    /**
     * @Function            :   all_group
     * @Developed By        :   
     * @DevelopeDateTime    :   02-03-2016 10:40 AM   |
     * @Updated Date Time   :
     * @Updated By          :   Afrin jahan noumin
     * @Router              :   
     * @Works               :   
     * @parameter           :   
     * @Return              :   
     * @Redirect            :   
     * 
     * @External call       :   
     * @Internal call       :   
     *
     * */
    public function all_group($page = NULL) {
        $data = $this->welcome_model->generate_menu();
        $data['meta_description'] = '';
        $data['meta_keywords'] = '';
        $data['author'] = '';
        $sdata['topic_grade'] = 'All Latest';
        $this->session->set_userdata($sdata);
        $data['active_menu'] = '';
        $data['active_sub_menu'] = '';
        $data['content_variable'] = 'quiz_group_active';
        $data['left_side'] = 1;
        $data['person_id'] = $this->session->userdata('user_id');
        $data['right_content_variation'] = 1; //in ridht content for group data['right_content_variation']=1 because this means create own group shows first 
        $data['tt_all_group_left_menu'] = 1;
        $data['popular_group'] = $this->welcome_model->select_all_group_popular(3);
        $data['totall_popular_type'] = $this->welcome_model->count_select_all_group_popular();
        $data['latest_group'] = $this->welcome_model->select_all_group_latest(3);
        $data['totall_type'] = $this->welcome_model->select_all_group_type();
        if ($page != NULL) {
            $data['page'] = $page;
            $number = $page * 10 - 10;
            $data['serial'] = $number;
        } else {
            $data['page'] = 0;
            $data['serial'] = 0;
            $number = 0;
        }

        $data['group'] = $this->welcome_model->select_all_group($number);
        $data['group_list'] = $this->welcome_model->count_select_all_group();
        if ($data['group']) {
            foreach ($data['group'] as $val) {
                $data['group_creator_info'][$val->group_id] = $this->welcome_model->select_all_group_creator_info($val->group_created_by);
                //$data['all_course'][$val->group_id] = $this->welcome_model->select_all_group_course($val->group_id);
                $data['all_member'][$val->group_id] = $this->welcome_model->select_all_group_member($val->group_id);
            }
        }

        $data['main_content'] = $this->load->view('front_end/group/all_group', $data, TRUE);
        if ($data['person_id']) {
            $this->load->view('user/master', $data);
        } else if (!$data['person_id']) {
            $this->load->view('front_end/master', $data);
        }
    }

    function group_member_more_view() {
        $person_id = $this->session->userdata('user_id');
        $data = $this->welcome_model->generate_menu();
        $data['active_menu'] = '';
        $data['active_sub_menu'] = '';
        $data['right_content_variation'] = 1;
        $number = $this->input->post('member_counter', True);
        $group_id = $this->input->post('group_id', True);


        $data['group_info'] = $this->group_model->group_info_for_public($group_id);

        $data['group_creator_info'] = $this->profile_model->person_info_by_id($data['group_info']->group_created_by);
        if ($person_id) {
            $data['group_member_info'] = $this->group_model->check_member_requst($person_id, $group_id);
        }
        $data['group_member_list'] = $this->group_model->select_group_member_info_for_public_view($data['group_info']->group_id, $number + 10);

        echo json_encode($data['group_member_list']);
    }

    public function select_other_latest_group() {
        $data = array();
        $data['number'] = $this->input->post("number", TRUE);
        $data['latest_group'] = $this->welcome_model->select_all_group_latest($data['number'] + 3);

        echo json_encode($data['latest_group']);
    }

    public function select_popular_group_other() {
        $data = array();
        $data['number_popular'] = $this->input->post("number_popular", TRUE);
        $data['popular_group'] = $this->welcome_model->select_all_group_popular($data['number_popular'] + 3);


        echo json_encode($data['popular_group']);
    }

    public function join_group_public() {
        $group_id = $this->input->post("group_id", TRUE);
        $user_id = $this->session->userdata("user_id");

        $check_member_ship = $this->welcome_model->select_membership_info($group_id, $user_id);
        if ($check_member_ship) {
            echo "1";
        } else {
            $save_member = $this->welcome_model->save_group_member_info($group_id, $user_id);
            $check_group_status = $this->welcome_model->check_group_status($group_id);
            if ($check_group_status->group_status == 4) {
                echo '2';
            } else {
                echo '3';
            }
        }
    }

    public function select_category_wise_group() {

        $group_type_id = $this->input->post("type_id", TRUE);
        $page = $this->input->post("page", TRUE);
        if ($page != 0) {
            $data['page'] = $page;
            $number = $page * 10 - 10;
            $data['serial'] = $number;
        } else {
            $data['page'] = 0;
            $data['serial'] = 0;
            $number = 0;
        }
        if ($group_type_id) {
            $group_type_id_array = explode(",", $group_type_id);
            if ($group_type_id_array[count($group_type_id_array) - 1] == '') {
                array_pop($group_type_id_array);
            }

            $data['group_list'] = $this->welcome_model->count_select_type_wise_group($group_type_id, $group_type_id_array);
            $data['group'] = $this->welcome_model->select_type_wise_group($group_type_id, $group_type_id_array, $number);
            if ($data['group']) {
                foreach ($data['group'] as $val) {
                    $data['group_creator_info'][$val->group_id] = $this->welcome_model->select_all_group_creator_info($val->group_created_by);
                    $data['all_member'][$val->group_id] = $this->welcome_model->select_all_group_member($val->group_id);
                }
            }
        } else {
            $data['group_list'] = $this->welcome_model->count_category_select_all_group();
            $data['group'] = $this->welcome_model->category_select_all_group($number);
            if ($data['group']) {
                foreach ($data['group'] as $val) {
                    $data['group_creator_info'][$val->group_id] = $this->welcome_model->select_all_group_creator_info($val->group_created_by);

                    $data['all_member'][$val->group_id] = $this->welcome_model->select_all_group_member($val->group_id);
                }
            }
        }

        echo $this->load->view('front_end/group/group_ajax_pages/group_category_wise_view', $data, TRUE);
    }

    public function select_popular_group_type() {
        $data = array();
        $data['number_popular'] = $this->input->post("number_popular", TRUE);
        $data['popular_group'] = $this->welcome_model->select_all_group_popular($data['number']);

        echo $this->load->view('front_end/quiz/quiz_ajax_page/popular_group_ajax_page', $data, TRUE);
    }

    function pagination_group_more_view() {
        $group_type_id = $this->input->post("type_id", TRUE);
        $page = $this->input->post("page", TRUE);
        if ($page != 0) {
            $data['page'] = $page;
            $number = $page * 10 - 10;
            $data['serial'] = $number;
        } else {
            $data['page'] = 0;
            $data['serial'] = 0;
            $number = 0;
        }
        if ($group_type_id) {
            $group_type_id_array = explode(",", $group_type_id);
            if ($group_type_id_array[count($group_type_id_array) - 1] == '') {
                array_pop($group_type_id_array);
            }

            $data['group_list'] = $this->welcome_model->count_select_type_wise_group($group_type_id, $group_type_id_array);
            $data['group'] = $this->welcome_model->select_type_wise_group($group_type_id, $group_type_id_array, $number);
            if ($data['group']) {
                foreach ($data['group'] as $val) {
                    $data['group_creator_info'][$val->group_id] = $this->welcome_model->select_all_group_creator_info($val->group_created_by);
                    $data['all_member'][$val->group_id] = $this->welcome_model->select_all_group_member($val->group_id);
                }
            }
        } else {
            $data['group_list'] = $this->welcome_model->count_category_select_all_group();
            $data['group'] = $this->welcome_model->category_select_all_group($number);
            if ($data['group']) {
                foreach ($data['group'] as $val) {
                    $data['group_creator_info'][$val->group_id] = $this->welcome_model->select_all_group_creator_info($val->group_created_by);

                    $data['all_member'][$val->group_id] = $this->welcome_model->select_all_group_member($val->group_id);
                }
            }
        }

        echo $this->load->view('front_end/group/group_ajax_pages/group_category_wise_view', $data, TRUE);
    }

    /*
     * ----------------------------End Public View (Group)-------------------------------------
     */

    /*
     * ----------------------------Srart Connent User View-------------------------------------
     */

    public function connect_user($requested_person_id) {
        $person_id = $this->session->userdata('user_id');
        if (!$person_id) {
            $sdata['url'] = $requested_person_id . '/connect';
            $this->session->set_userdata($sdata);
            redirect('sign-in');
        }
    }

    /*
     * ----------------------------End Connent User View -------------------------------------
     */
    /*
     * ----------------------------Public View (for future work)-------------------------------------
     */
    public function end_class() {
        $data = $this->welcome_model->generate_menu();
        $data['meta_description'] = '';
        $data['meta_keywords'] = '';
        $data['author'] = '';

        $data['main_content'] = $this->load->view('front_end/end_class/end_class', $data, TRUE);
        $this->load->view('front_end/master', $data);
    }

    public function scholarship() {
        $data = $this->welcome_model->generate_menu();
        $data['meta_description'] = '';
        $data['meta_keywords'] = '';
        $data['author'] = '';
        $data['main_content'] = $this->load->view('front_end/scholarship', $data, TRUE);
        $this->load->view('front_end/master', $data);
    }

    public function scholarship_list() {
        $data = $this->welcome_model->generate_menu();
        $data['meta_description'] = '';
        $data['meta_keywords'] = '';
        $data['author'] = '';
        $data['main_content'] = $this->load->view('front_end/scholarship_list', $data, TRUE);
        $this->load->view('front_end/master', $data);
    }

    public function pricing() {
        $data = $this->welcome_model->generate_menu();
        $data['meta_description'] = '';
        $data['meta_keywords'] = '';
        $data['author'] = '';
        $data['active_tab'] = 'online_academy';
        $data['main_content'] = $this->load->view('front_end/pricing/pricing', $data, TRUE);
        $this->load->view('front_end/master', $data);
    }

    /*
     * ----------------------------Public View (for future work)-------------------------------------
     */

    public function logout() {
        $person_pc_info_id = $this->session->userdata('person_pc_info_id');
        $timeZone_differrent = $this->session->userdata('timezone_differrent');
        $this->load->model('super_admin_profile_model');
        $logout_time = date('Y-m-d h:i A', (time() - ($timeZone_differrent)));
        $this->super_admin_profile_model->save_person_logout_time($logout_time, $person_pc_info_id);
        $this->session->sess_destroy();
        redirect();
    }

}
