<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class User_video extends TT_user_login {
    public function __construct() {
        parent::__construct();
        $user_id = $this->session->userdata('user_id');
        if ($user_id == NULL) {
            $sdata = array();
            $sdata['url'] = base_url() . $this->uri->segment(1) . '/' . $this->uri->segment(2);
            $this->session->set_userdata($sdata);
        }
    }

    /*
      -----------@@@RIPON@ Start add/edit Video Course view Part----------------------------------
     */

    /**
     * @Function            : add_video_course 
     * @Used IN             : @user/video/video_course_list.php [13]
     * @                    : @user/video/video_course_list_organization.php [11]
     * @Description         : Add Video Course information and check all kind of validation   
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 21-04-2016 11:15 AM
     * @Parameter           : NULL
     * @View                : user/video/add_video_course.php, user/master.php
     * @Redirect            : base_url()
     * @Return              : NULL 
     * @Status              : available      
     * */
    public function add_video_course() {
        $data = Array();
        $data['active_menu'] = $this->session->userdata('active_menu');
        $data['active_sub_menu'] = $this->session->userdata('active_sub_menu');
        $data['tab'] = '';
        $data['left_side_menu_view'] = 1;
        $data['left_side'] = 1;

        $person_id = $this->session->userdata('user_id');
        $data['person_info'] = $this->person_model->get_single_person_information_by_person_id($person_id);
        if (($data['person_info']->person_role != 3) && ($data['person_info']->person_role != 4)) {
            redirect();
        }
        $video_course_data = $this->user_video_model->get_information_for_video_course($data);        
        
        $this->check_add_video_course_validaton($video_course_data);
        if ($this->form_validation->run() == FALSE) {
            if ($video_course_data['person_info']->person_role == 4) {
                $organization_info = $this->organization_model->select_single_organization_info_by_person_id($video_course_data['person_info']->person_id);
                $video_course_data['all_resource_person'] = $this->resource_person_model->get_all_resource_person_info_by_organizarion_id($organization_info->organization_id);
            }
            $video_course_data['all_course_category'] = $this->category_model->select_all_available_category($video_course_data['person_info']->person_id);
            $video_course_data['main_content'] = $this->load->view('user/video/add_video_course', $video_course_data, true);
            $this->load->view('user/master', $video_course_data);
        } else {            
            $video_management_id = $this->user_video_model->save_video_course_information($video_course_data);
            //$video_course_info = $this->user_video_model->get_single_video_course_information_by_id($video_management_id);
            //redirect('upload-video/' . $video_course_info->url);
            redirect('video/teacher');
        }
    }

    /**
     * @Function            : check_add_video_course_validaton 
     * @Used IN             : @function-'add_video_course'    user_video[@controller]- [38]
     * @Description         : check validation for add video course   
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 21-04-2016 12:15 AM
     * @Parameter           : $data[ARRAY]
     * @View                : NULL
     * @Redirect            : None
     * @Return              : NULL 
     * @Status              : available      
     * */
    function check_add_video_course_validaton($data) {
        $this->load->library('form_validation');
        $this->form_validation->set_rules('video_course_title', 'Video Course Title', 'trim|required');
        $this->form_validation->set_rules('video_course_url', 'Video Course URL', 'max_length[250]|required|callback_check_video_course_url');
        $this->form_validation->set_rules('category_id', 'Video Course Category', 'required');
        if ($this->input->post('category_id', TRUE) == 'other') {
            $this->form_validation->set_rules('course_category_name', 'Course Category Name', 'required|trim|max_length[150]|callback_course_category_name_check');
        }
        if ($data['person_info']->person_role == 4) {
            $this->form_validation->set_rules('resource_person_id', 'Resource person', 'required');
        }
        $this->form_validation->set_rules('video_course_level', 'Video Course Level', 'required');
        //$this->check_video_course_type_validation();
        //$this->form_validation->set_rules('video_course_upload_video_type', 'Upload Video Type', 'required');
        //if ($this->input->post('video_course_upload_video_type', TRUE) == 1) {
        //    $this->form_validation->set_rules('video_course_folder_name', 'Video Course Folder Name', 'trim|required|max_length[150]|callback_check_video_folder_name[' . $data['person_info']->person_id . ']');
        //}        
        $this->form_validation->set_rules('video_course_folder_name', 'Video Course Folder Name', 'trim|required|max_length[150]|callback_check_video_folder_name[' . $data['person_info']->person_id . ']');
        $this->form_validation->set_rules('video_course_language', 'Video Language', 'required');
        $this->form_validation->set_rules('video_course_access_level', 'Video Access Level', 'required');
    }

    /**
     * @Function            : check_video_course_type_validation 
     * @Used IN             : @function-'check_add_video_course_validaton'    user_video[@controller]- [87]
     * @Description         : check video course type validation
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 27-04-2016 06:31 PM
     * @Parameter           : $data[ARRAY]
     * @View                : NULL
     * @Redirect            : None
     * @Return              : NULL 
     * @Status              : available      
     * */
    function check_video_course_type_validation() {
        $this->form_validation->set_rules('video_course_type', 'Video Course Type', 'required');

        if ($this->input->post('video_course_type', TRUE) == 1) {
            $this->form_validation->set_rules('video_course_price_currency', 'Price Currency', 'required');
            $this->form_validation->set_rules('video_course_price', 'Price', 'required|trim|numeric|greater_than[0]');
        }
    }

    /**
     * @Function            : check_video_course_url 
     * @Used IN             : @function-'add_video_course'   user_video[@controller] - [77]
     * @Description         : check video course existence    
     * @Developed By        : Jaherul Islam
     * @Start DateTime      : 03-04-2016 09:55 AM  
     * @Parameter           : $url[STRING]
     * @View                : None
     * @Redirect            : None
     * @Return              : TRUE/FALSE    
     * @Status              : available      
     * */
    public function check_video_course_url($url) {
        $sp = '/^[0-9a-zA-Z\-]+$/';
        if (!preg_match($sp, $url)) {
            $this->form_validation->set_message('check_video_course_url', "URL Cann't contain any '/[!@#$%&*()^,._;:]/'  if need use '-' Don't use Space");
            return FALSE;
        } else if (strstr($url, ' ')) {
            $this->form_validation->set_message('check_video_course_url', " Use '-' in place of space");
            return FALSE;
        } else if ($this->url_model->check_url_exists1($url) == 1) {
            $this->form_validation->set_message('check_video_course_url', "This URL Already Exist");
            return FALSE;
        } else {
            return TRUE;
        }
    }

    /**
     * @Function            : course_category_name_check 
     * @Used IN             : @function-'add_video_course'   user_video[@controller] - [80]
     * @Description         : course category name existance  
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 03-04-2016 09:55 AM  
     * @Parameter           : $course_category_name[STRING]
     * @View                : None
     * @Redirect            : None
     * @Return              : TRUE/FALSE    
     * @Status              : available        
     * */
    public function course_category_name_check($course_category_name) {
        if ($course_category_name == '') {
            $this->form_validation->set_message('course_category_name_check', "Video course category name is required");
            return FALSE;
        } else {
            $result = $this->category_model->check_course_category_name_exists($course_category_name);
            if ($result) {
                $this->form_validation->set_message('course_category_name_check', "This Course Category Already Exists");
                return FALSE;
            } else {
                return TRUE;
            }
        }
    }

    /**
     * @Function            : check_video_folder_name 
     * @Used IN             : @function-'add_video_course'   user_video[@controller] - [88]
     * @Description         : video folder name existence
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 03-04-2016 09:55 AM  
     * @Parameter           : $video_folder_name[STRING]
     * @View                : None
     * @Redirect            : None
     * @Return              : TRUE/FALSE    
     * @Status              : available        
     * */
    public function check_video_folder_name($video_folder_name, $person_id) {
        $sp = "/^[0-9a-zA-Z-]+$/";
        if (preg_match($sp, $video_folder_name)) {
            $result = $this->user_video_model->check_video_folder_name($video_folder_name, $person_id);
            if ($result) {
                $this->form_validation->set_message('check_video_folder_name', "This video folder name already exist");
                return FALSE;
            } else {
                return TRUE;
            }
        } else {
            $this->form_validation->set_message('check_video_folder_name', "Video folder name can't contain special character accept ' - '");
            return FALSE;
        }
    }

    /**
     * @Function            : check_group_validation 
     * @Used IN             : @function-'check_video_access_level_validation'   user_video[@controller] - [108]
     * @Description         : check group validation
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 24-04-2016 09:55 AM  
     * @Parameter           : $group_id[STRING]
     * @View                : None
     * @Redirect            : None
     * @Return              : TRUE/FALSE    
     * @Status              : available        
     * */
    function check_group_validation($group_id) {
        $temp = 0;
        $person_id = $this->session->userdata('user_id');
        $all_person_id = $this->person_model->get_all_resource_person_of_organization_by_person_id($person_id);
        $group_list = $this->group_model->select_all_front_end_selected_group($all_person_id, '');
        $group_id_array = explode(',', $group_id);
        foreach ($group_list as $group_value) {
            if (in_array($group_value->group_id, $group_id_array)) {
                $temp = 0;
                continue;
            } else {
                $temp = 1;
                break;
            }
        }
        if ($temp == 1) {
            $this->form_validation->set_message('check_group_validation', "You Enter Invalid Group Name");
            return FALSE;
        }
    }

    /**
     * @Function            : check_special_user_validation 
     * @Used IN             : @function-'check_video_access_level_validation'   user_video[@controller] - [110]
     * @Description         : check special user validation
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 24-04-2016 10:55 AM  
     * @Parameter           : $special_user_id[STRING]
     * @View                : None
     * @Redirect            : None
     * @Return              : TRUE/FALSE    
     * @Status              : available        
     * */
    function check_special_user_validation($special_user_id) {
        $temp = 0;
        $person_id = $this->session->userdata('user_id');
        $all_person_id = $this->person_model->get_all_linked_person1($person_id);
        $all_person_id_array = explode(',', $all_person_id);
        $special_user_id_array = explode(',', $special_user_id);
        for ($i = 0; $i < count($special_user_id_array); $i++) {
            if (in_array($special_user_id_array[$i], $all_person_id_array)) {
                $temp = 0;
                continue;
            } else {
                $temp = 1;
                break;
            }
        }
        if ($temp == 1) {
            $this->form_validation->set_message('check_special_user_validation', "You Enter Invalid Special user Name");
            return FALSE;
        }
    }

    /**
     * @Function            : check_video_url_existance 
     * @Used IN             : @function-'getUrlValue()'  user/video/add_video_course.php - [53]
     * @Description         : check URL exists in jQuery Validation   
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 08-03-2016 12:47 AM    
     * @Parameter           : NULL
     * @View                : None
     * @Redirect            : None
     * @Return              : TRUE/FALSE    
     * @Status              : available      
     * */
    public function check_video_url_existance() {
        $video_coursse_url = $this->input->post('video_course_url', TRUE);
        echo $this->url_model->check_url_exists1($video_coursse_url);
    }

    /**
     * @Function            : check_video_category_exixtence 
     * @Used IN             : @function-'checkCourseCategory()'  user/video/add_video_course.php - [115]
     * @Description         : check category name exists in jQuery Validation   
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 25-04-2016 03:07 PM    
     * @Parameter           : NULL
     * @View                : None
     * @Redirect            : None
     * @Return              : 1/2    
     * @Status              : available      
     * */
    function check_video_category_exixtence() {
        $category_name = $this->input->post('category_name', TRUE);
        $result = $this->category_model->check_course_category_name_exists($category_name);
        if ($result) {
            echo 1;
        } else {
            echo 2;
        }
    }

    /**
     * @Function            : check_video_folder_name_existanc 
     * @Used IN             : @function-'checkCourseCategory()'  user/video/add_video_course.php - [218]
     * @Description         : video folder name existence in jQuery validation   
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 24-02-2016 12:06 PM
     * @Parameter           : NULL
     * @View                : None
     * @Redirect            : None
     * @Return              : 1/2         
     * @Status              : available      
     * */
    public function check_video_folder_name_existance() {
        $person_id = $this->input->post('person_id', TRUE);
        $video_folder_name1 = $this->input->post('video_folder_name', TRUE);
        $result = $this->user_video_model->check_video_folder_name($video_folder_name1, $person_id);
        if ($result) {
            echo 1;
        } else {
            echo 2;
        }
    }

    /*
      -----------@@@RIPON@ End add/edit Video Course view Part----------------------------------
     */

    /**
     * @Function            : my_video 
     * @Used IN             : @function-'user/side_menu.php' - [832]
     * @Description         : view video
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 05-05-2016 01:10 AM  
     * @Parameter           : NULL
     * @View                : None
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available        
     * */
    public function my_video() {
        $active_menu = $this->session->userdata('active_menu');
        if ($active_menu == 'organization') {
            $this->organization_video();
        } else if ($active_menu == 'teacher') {
            $this->teacher_video();
        } else if ($active_menu == 'learner') {
            $this->learner_video();
        }
    }

    /*
      -----------@@@RIPON@ Start Video Course view Part (Organization and Teacher)----------------------------------
     */

    /**
     * @Function            : teacher_video 
     * @Used IN             : @function-'user/video/video_course_list.php'
     * @Description         : view Teacher Video COurse  
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 02-02-2016 01:38 PM
     * @Parameter           : NULL
     * @View                : user/video/video_course_list.php, user/master.php
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available       
     * */
    public function organization_video() {
        $data = Array();
        $data['active_menu'] = $sdata['active_menu'] = 'organization';
        $data['active_sub_menu'] = $sdata['active_sub_menu'] = 'organization_video';
        $data['tab'] = '';
        $data['left_side_menu_view'] = 1;
        $data['left_side'] = 1;
        $this->session->set_userdata($sdata);

        $data['page'] = 1;
        $person_id = $this->session->userdata('user_id');
        $data['person_info'] = $this->person_model->get_single_person_information_by_person_id($person_id);
        if (($data['person_info']->person_role != 3) && ($data['person_info']->person_role != 4)) {
            redirect();
        }
        $video_course_data = $this->user_video_model->get_information_for_video_course($data);
        $all_video_course_data = $this->user_video_model->get_all_video_course_value($video_course_data, 4, 0);

        $all_video_course_data['main_content'] = $this->load->view('user/video/video_course_list', $all_video_course_data, TRUE);
        $this->load->view('user/master', $all_video_course_data);
    }

    /**
     * @Function            : teacher_video 
     * @Used IN             : @function-'user/video/video_course_list.php'
     * @Description         : view Teacher Video COurse  
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 02-02-2016 01:38 PM
     * @Parameter           : NULL
     * @View                : user/video/video_course_list.php, user/master.php
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available       
     * */
    public function teacher_video() {
        $data = Array();
        $data['active_menu'] = $sdata['active_menu'] = 'teacher';
        $data['active_sub_menu'] = $sdata['active_sub_menu'] = 'teacher_video';
        $data['tab'] = '';
        $data['left_side_menu_view'] = 1;
        $data['left_side'] = 1;
        $this->session->set_userdata($sdata);

        $data['page'] = 1;
        $person_id = $this->session->userdata('user_id');
        $data['person_info'] = $this->person_model->get_single_person_information_by_person_id($person_id);
        if (($data['person_info']->person_role != 3) && ($data['person_info']->person_role != 4)) {
            redirect();
        }
        $video_course_data = $this->user_video_model->get_information_for_video_course($data);
        $all_video_course_data = $this->user_video_model->get_all_video_course_value($video_course_data, 3, 0);

        $all_video_course_data['main_content'] = $this->load->view('user/video/video_course_list', $all_video_course_data, TRUE);
        $this->load->view('user/master', $all_video_course_data);
    }

    /**
     * @Function            : video_course_pagination 
     * @Used IN             : @function-'user/course/video_course_list.php'
     * @Description         : Video Course pagination view
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 18-05-2016 03:06 PM
     * @Parameter           : NULL
     * @View                : None
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function video_course_pagination() {
        $data = Array();
        $person_id = $this->session->userdata('user_id');
        $data['person_info'] = $this->person_model->get_single_person_information_by_person_id($person_id);
        $video_course_data = $this->user_video_model->get_information_for_video_course($data);
        $video_course_data['video_course_type'] = $this->input->post('video_course_type', TRUE);
        $video_course_data['page'] = $this->input->post('page_number', TRUE);
        $limit = $video_course_data['page'] * 10 - 10;
        if ($video_course_data['video_course_type'] == 'draft') {
            $this->view_draft_video_course_for_ajax_view($video_course_data, $limit);
        }
        if ($video_course_data['video_course_type'] == 'submit') {
            $this->view_submission_video_course_for_ajax_view($video_course_data, $limit);
        }
        if ($video_course_data['video_course_type'] == 'active') {
            $this->view_active_video_course_for_ajax_view($video_course_data, $limit);
        }
    }

    /**
     * @Function            : view_draft_video_course_for_ajax_view 
     * @Used IN             : @function-'video_course_pagination'     this[@controller]
     * @Description         : view draft video course for pagination
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 18-05-2016 03:25 PM
     * @Parameter           : $video_course_data[ARRAY], $limit[INTEGER]
     * @View                : user/video/ajax_page/view_video_course.php
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function view_draft_video_course_for_ajax_view($video_course_data, $limit) {
        if ($video_course_data['resource_person_info']->person_role == 4) {
            $draft_course_data = $this->user_video_model->select_all_draft_video_courses($video_course_data, $video_course_data['person_info']->person_id, 5, $limit, '');
        } else {
            $draft_course_data = $this->user_video_model->select_all_draft_video_courses($video_course_data, $video_course_data['person_info']->person_id, 5, $limit, $video_course_data['resource_person_info']->resource_person_id);
        }
        echo $this->load->view('user/video/ajax_page/view_video_course.php', $draft_course_data, TRUE);
    }

    /**
     * @Function            : view_submission_video_course_for_ajax_view 
     * @Used IN             : @function-'video_course_pagination'     this[@controller]
     * @Description         : view submission video course for pagination
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 18-05-2016 03:35 PM
     * @Parameter           : $video_course_data[ARRAY], $limit[INTEGER]
     * @View                : user/video/ajax_page/view_video_course.php
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function view_submission_video_course_for_ajax_view($video_course_data, $limit) {
        if ($video_course_data['resource_person_info']->person_role == 4) {
            $submit_course_data = $this->user_video_model->select_all_submit_video_courses($video_course_data, $video_course_data['person_info']->person_id, 3, $limit, '');
        } else {
            $submit_course_data = $this->user_video_model->select_all_submit_video_courses($video_course_data, $video_course_data['person_info']->person_id, 3, $limit, $video_course_data['resource_person_info']->resource_person_id);
        }
        echo $this->load->view('user/video/ajax_page/view_video_course.php', $submit_course_data, TRUE);
    }

    /**
     * @Function            : view_active_video_course_for_ajax_view 
     * @Used IN             : @function-'video_course_pagination'     this[@controller]
     * @Description         : view Active OR Apporved video course for pagination
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 18-05-2016 03:11 PM
     * @Parameter           : $course_data[ARRAY], $limit[INTEGER]
     * @View                : user/video/ajax_page/view_video_course.php
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function view_active_video_course_for_ajax_view($video_course_data, $limit) {
        $active_course_status = '1,4';
        if ($video_course_data['resource_person_info']->person_role == 4) {
            $active_course_data = $this->user_video_model->select_all_active_video_courses($video_course_data, $video_course_data['person_info']->person_id, $active_course_status, $limit, '');
        } else {
            $active_course_data = $this->user_video_model->select_all_active_video_courses($video_course_data, $video_course_data['person_info']->person_id, $active_course_status, $limit, $video_course_data['resource_person_info']->resource_person_id);
        }
        echo $this->load->view('user/video/ajax_page/view_video_course.php', $active_course_data, TRUE);
    }

    /*
      -----------@@@RIPON@ Start Video Course view Part (Organization and Teacher)----------------------------------
     */







    /*
      -----------@@@RIPON@ Start Learner View Video Course Part----------------------------------
     */

    /**
     * @Function            : learner_video 
     * @Used IN             : @function-'my_video'       user_video[@Controller]
     * @Description         : view learner video list
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 05-05-2016 01:10 AM  
     * @Parameter           : NULL
     * @View                : user/video/video_course_list_learner.php,user/master.php
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available        
     * */
    public function learner_video() {
        $data = Array();
        $data['active_menu'] = $sdata['active_menu'] = 'learner';
        $data['active_sub_menu'] = $sdata['active_sub_menu'] = 'learner_video';
        $data['active_sub_menu_item'] = $sdata['active_sub_menu_item'] = '';
        $data['left_side_menu_view'] = 1;
        $data['left_side'] = 1;
        if ($this->session->userdata('learner_tab_session')) {
            $data['tab'] = $this->session->userdata('video_learner_tab_session');
        } else {
            $data['tab'] = 'free';
        }
        $data['page'] = 1;
        $this->session->set_userdata($sdata);

        $person_id = $this->session->userdata('user_id');

        $free_video_course_data = $this->user_video_model->get_free_video_course_value($data, $person_id, 0);
        $register_video_course_data = $this->user_video_model->get_register_video_course_value($free_video_course_data, $person_id, 0);

        $register_video_course_data['main_content'] = $this->load->view('user/video/learner_video_course_list', $register_video_course_data, true);
        $this->load->view('user/master', $register_video_course_data);
    }

    /**
     * @Function            : cancel_learner_video_course_registration 
     * @Used IN             : @function-'user/video/learner_video_course_list.php' - [90]
     * @Description         : Cancel learner video cource register
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 05-05-2016 05:09 AM  
     * @Parameter           : $id[INTEGER], $type[STRING]
     * @View                : user/video/video_course_list_learner.php,user/master.php
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available        
     * */
    function cancel_learner_video_course_registration($id, $type) {
        if ($type == 'free') {
            $this->utility_model->delete_information_in_database('tbl_student', 'student_id', $id);
            redirect('video/learner');
        }
        if ($type == 'registration') {
            $data['payment_status'] = 5;
            $this->utility_model->update_information_in_database('tbl_payment', 'payment_id', $id, $data);
            redirect('video/learner');
        }
    }

    /**
     * @Function            : learner_video_course_pagination 
     * @Used IN             : @function-'user/video/learner_video_course_list.php' 
     * @Description         :  learner video cource register pagination
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 07-05-2016 11:31 AM  
     * @Parameter           : None
     * @View                : 
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available        
     * */
    function learner_video_course_pagination() {
        $data = Array();
        $person_id = $this->session->userdata('user_id');
        $data['video_course_type'] = $this->input->post('video_course_type', TRUE);
        $page_number = $this->input->post('page_number', TRUE);
        $data['page'] = $page_number;
        $number = $page_number * 10 - 10;

        if ($data['video_course_type'] == 'free') {
            $free_video_course_data = $this->user_video_model->get_free_video_course_value($data, $person_id, $number);
            echo $this->load->view('user/video/ajax_page/view_learner_video_course.php', $free_video_course_data, TRUE);
        }
        if ($data['video_course_type'] == 'register') {
            $register_video_course_data = $this->user_video_model->get_register_video_course_value($data, $person_id, $number);
            echo $this->load->view('user/video/ajax_page/view_learner_video_course.php', $register_video_course_data, TRUE);
        }
    }

    /*
      -----------@@@RIPON@ End View Learner Video Course Part----------------------------------
     */

//    @@@@@@@@ it must be deleted after complete all function video course@@@@@@@@@@@@@@@@



    public function populate_right_side($right_side_content) {
// Right Sidebar Content Information
        $person_id = $this->session->userdata('user_id');
        $data = array();
        if ($right_side_content['quizes']) {
            $data['quizes'] = $this->quiz_model->select_sugested_quiz();
        }
        if ($right_side_content['popular_group']) {
            $data['popular_group'] = $this->group_model->select_popular_group();
        }
        if ($right_side_content['suggested_link']) {
            $data['person_link'] = $this->profile_model->select_person_link();
            if ($data['person_link']) {
                $link['person_id'] = array('FALSE');
                $link['requested_person_id'] = array('FALSE');
                foreach ($data['person_link'] as $v_person_link) {
                    if ($v_person_link->person_id != $person_id) {
                        $person_linked[$v_person_link->person_id] = TRUE;
                    }
                    if ($v_person_link->requested_person_id != $person_id) {
                        $person_linked[$v_person_link->requested_person_id] = TRUE;
                    }
                }
            }

            $data['suggested_link'] = $this->profile_model->select_suggested_link();

            foreach ($data['suggested_link'] as $v_suggested_link) {
                if (!$person_linked[$v_suggested_link->person_id] && !$person_linked[$v_suggested_link->person_id]) {
                    $data['link_info'][$v_suggested_link->person_id] = $this->profile_model->select_link_person_info($v_suggested_link->person_id);
                }
                if (!$person_linked[$v_suggested_link->requested_person_id] || !$person_linked[$v_suggested_link->requested_person_id]) {
                    $data['link_info'][$v_suggested_link->requested_person_id] = $this->profile_model->select_link_person_info($v_suggested_link->requested_person_id);
                }
            }
        }

        if ($right_side_content['tt_online_course']) {
//TalhaTraining ONLINE COURSES
            $data['tt_online_course'] = $this->course_model->select_tt_online_course();
        }
        $data['footer_section'] = $this->welcome_model->select_all_section(2, 0);
        foreach ($data['footer_section'] as $section_value) {
            $data['child_menu_with_section'][$section_value->menu_section] = $this->welcome_model->select_child_menu_with_section(2, $section_value->parent_menu_id, $section_value->menu_section);
        }
        $data['view_category'] = $this->welcome_model->select_all_published_category();
        return $data;
    }

    public function check_video_folder_name_edit($video_folder_name) {
        $video_course_url = $this->uri->segment(2);
        $sql = "SELECT * FROM tbl_video_management as vm, tbl_url as u WHERE vm.url_id = u.url_id AND u.url= '$video_course_url' ";
        $result = $this->db->query($sql)->row();
        if ($result->video_folder_name != $video_folder_name) {
            if ($video_folder_name == '') {
                $this->form_validation->set_message('check_video_folder_name_edit', "Video folder name is required");
                return FALSE;
            } else {
                $sp = "/^[0-9a-zA-Z-]+$/";
                if (preg_match($sp, $video_folder_name)) {
                    $result = $this->user_video_model->check_video_folder_name($video_folder_name);
                    if ($result) {
                        $this->form_validation->set_message('check_video_folder_name_edit', "This video folder name already exist");
                        return FALSE;
                    } else {
                        return TRUE;
                    }
                } else {
                    $this->form_validation->set_message('check_video_folder_name_edit', "Video folder name can't contain special character accept ' - '");
                    return FALSE;
                }
            }
        } else {
            return TRUE;
        }
    }

    public function check_video_course_url_edit($url) {
        $old_url = $this->uri->segment(2);
        if ($old_url == $url) {
            return TRUE;
        } else {
            $sp = '/^[0-9a-zA-Z\-]+$/';
            if (!preg_match($sp, $url)) {
                $this->form_validation->set_message('check_video_course_url_edit', "URL Cann't contain any '/[!@#$%&*()^,._;:]/'  if need use '-' Don't use Space");
                return FALSE;
            } else if (strstr($url, ' ')) {
                $this->form_validation->set_message('check_video_course_url_edit', " Use '-' in place of space");
                return FALSE;
            } else if ($this->super_admin_course_model->check_course_category_url($url)) {
                $this->form_validation->set_message('check_video_course_url_edit', "This URL Already Exist");
                return FALSE;
            } else {
                return TRUE;
            }
        }
    }

    public function check_currency($course_currency) {
        $course_type = $this->input->post('course_type');
        if ($course_type == 1) {
            if ($course_currency == '') {
                $this->form_validation->set_message('check_currency', "Course currency is required");
                return FALSE;
            } else {
                return TRUE;
            }
        }
    }

    public function check_video_course_price($course_price) {
        $course_type = $this->input->post('video_course_type');
        if ($course_type == 1) {
            if ($course_price) {
                $price_number_regex = '/^[\-\+]?((([0-9]{1,3})([,][0-9]{3})*)|([0-9]+))?([\.]([0-9]+))?$/';
                if (preg_match($price_number_regex, $course_price)) {
                    if ($course_price > 0) {
                        return TRUE;
                    } else {
                        $this->form_validation->set_message('check_video_course_price', "Course price can't be negative or zero");
                        return FALSE;
                    }
                } else {
                    $this->form_validation->set_message('check_video_course_price', "Course price is not a valid integer");
                    return FALSE;
                }
            } else {
                $this->form_validation->set_message('check_video_course_price', "Course price field is required");
                return FALSE;
            }
        }
    }

    public function select_video_course_access_user() {

        $access_level = $_POST['givenText'];
        $video_url = $_POST['videoURl'];
        $person_id = $this->session->userdata('user_id');
        $data['link_person'] = $this->user_course_model->select_link_person($person_id);
        $data['group'] = $this->user_course_model->select_group_by_person_id($person_id);
        $data['all_tt_user'] = $this->user_course_model->select_all_talhatraining_user();

        $data['access_level'] = $access_level;

        if ($access_level == 3) {
            $data['link_person'] = $this->user_course_model->select_link_person($person_id);
            foreach ($data['link_person'] as $v_link) {
                if ($v_link->person_id != $person_id) {
                    $data['link_person_info'][$v_link->person_link_id] = $this->profile_model->person_info_by_person_id($v_link->person_id);
                } else if ($v_link->requested_person_id != $person_id) {
                    $data['link_person_info'][$v_link->person_link_id] = $this->profile_model->person_info_by_person_id($v_link->requested_person_id);
                }
            }
            $data['video_management_info'] = $this->user_video_model->select_video_management_by_url($video_url);
            if ($data['video_management_info']) {
                $data['video_course_access_user'] = $this->user_video_model->select_video_course_access_user($data['video_management_info']->video_management_id);
            }
        }
// Only Group
        else if ($access_level == 4) {
            $data['group'] = $this->user_course_model->select_group_by_person_id($person_id);
            $data['video_management_info'] = $this->user_video_model->select_video_management_by_url($video_url);
            if ($data['video_management_info']) {
                $data['video_course_access_user'] = $this->user_video_model->select_video_course_access_group($data['video_management_info']->video_management_id);
            }
        }
// Special Person
        else if ($access_level == 5) {
            $data['link_person'] = $this->user_course_model->select_link_person($person_id);
            foreach ($data['link_person'] as $v_link) {
                if ($v_link->person_id != $person_id) {
                    $data['link_person_info'][$v_link->person_link_id] = $this->profile_model->person_info_by_person_id($v_link->person_id);
                } else if ($v_link->requested_person_id != $person_id) {
                    $data['link_person_info'][$v_link->person_link_id] = $this->profile_model->person_info_by_person_id($v_link->requested_person_id);
                }
            }
            $data['video_management_info'] = $this->user_video_model->select_video_management_by_url($video_url);
            if ($data['video_management_info']) {
                $data['video_course_access_user'] = $this->user_video_model->select_video_course_access_user($data['video_management_info']->video_management_id);
            }
        }
        echo $this->load->view('user/video/select_video_course_access_user', $data, true);
    }

    public function video_course_price() {
        $video_course_type = $this->input->post('video_course_type', TRUE);
        if ($video_course_type == 2) {
            $video_course_price = $this->input->post('video_course_price', TRUE);
            if ($video_course_price == '') {
                $this->form_validation->set_message('video_course_price', "Video Course Price is required");
                return FALSE;
            } else {
                return TRUE;
            }
        } else if ($video_course_type == 1) {
            return TRUE;
        }
    }

    public function get_video_duration($video_path) {
        $matches[1] = '00:00:00';
        $xyz = shell_exec("ffmpeg -i \"{$video_path}\" 2>&1");
        $search = '/Duration: (.*?),/';
        preg_match($search, $xyz, $matches);
        if (isset($matches[1])) {
            return $matches[1];
        } else {
            return '00:00:00';
        }
    }

    public function getVideoTag($file_location, $fileextention, $section, $video) {
        $video_tag = "<video width='5' height='5' id='player$section$video' src='$file_location' type='video/$fileextention' controls='controls'></video>";

        return $video_tag;
    }

    /**
     * @Function            : get_course_by_category_id 
     * @Used IN             : @function-'user/video/video_course_list_organization.php'
     * @Description         : delete video course
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 26-03-2016 07:24 PM
     * @Status              : available      
     * */
    public function delete_video_couse() {
        $video_course_url = $this->input->post('video_course_url', TRUE);
        $video_course_info = $this->user_video_model->get_single_video_course_information_by_url($video_course_url);

        $upload_video_id = $this->user_video_model->get_all_upload_video_id_by_video_course_id($video_course_info->video_management_id);

        if ($upload_video_id != '') {
            $course_creator_url = $this->user_video_model->get_profile_url($video_course_info->course_creator_id);
            $section_directory = 'content-library/' . $course_creator_url . '/my-video/' . $video_course_info->video_folder_name;
            if (is_dir($section_directory)) {
                $this->user_video_model->remove_directory($section_directory);
            }

            $upload_video_id_array = explode(',', $upload_video_id);
            for ($i = 0; $i < count($upload_video_id_array); $i++) {
                $video_work_file_info = $this->user_video_model->get_work_file_info_by_video_upload_id($upload_video_id_array[$i]);
                if ($video_work_file_info) {
                    $this->user_video_model->remove_upload_video_course_work_file_by_work_file_id($video_work_file_info->work_files_management_id);
                }
                $this->user_video_model->delete_single_video_course_by_upload_video_id($upload_video_id_array[$i]);
            }
        }
        $this->user_video_model->delete_information_in_database('tbl_video_management', 'video_management_id', $video_course_info->video_management_id);
        echo 'success';
    }

    public function video_course_detail($video_course_url) {
// Left AND Right Sidebar Content Information

        $person_id = $this->session->userdata('user_id');
        $person_role = $this->session->userdata('person_role');


        if ($person_role == 3) {
            $data['active_menu'] = 'As Teacher';
        } else if ($person_role == 4) {
            $data['active_menu'] = 'organization';
        } else if ($person_role == 5) {
            $data['active_menu'] = 'As Learner';
        } else {
            $data['active_menu'] = '';
        }
        $data['active_sub_menu'] = 'Video';

        $data['tab'] = 'video_information';


        if ($person_role == 3) {
            $data['person_info'] = $this->profile_model->person_info_by_person_id($person_id);
        } else if ($person_role == 4) {
            $data['person_info'] = $this->profile_model->organization_info_by_person_id($person_id);
            $data['resource_persons'] = $this->user_course_model->select_organization_all_resource_persons($data['person_info']->organization_id);
        }

        $data['video_course_info'] = $this->user_video_model->select_video_course_by_url($video_course_url);
        $data['video_management_section'] = $this->user_video_model->select_video_management_section($data['video_course_info']->video_management_id);
        foreach ($data['video_management_section'] as $v_video_section) {
            $data['section_video'][$v_video_section->upload_video_section_name] = $this->user_video_model->select_video_course_videos($data['video_course_info']->video_management_id, $v_video_section->upload_video_section_name);
            foreach ($data['section_video'][$v_video_section->upload_video_section_name] as $v_video) {
                $data['work_files'][$v_video_section->upload_video_section_name][$v_video->upload_video_id] = $this->user_video_model->select_upload_video_work_files($v_video->upload_video_id);
            }
        }

        $data['course_categories'] = $this->user_course_model->select_all_available_course_category();
        $data['main_content'] = $this->load->view('front_end/course_detail', $data, true);
        $this->load->view('front_end/master', $data);
    }

    public function load_video() {
        $upload_video_id = $_POST['video'];
        $data['video_info'] = $this->user_video_model->select_video_by_id($upload_video_id);
        echo $this->load->view('user/video/load_video_view', $data, true);
    }

    public function video_course_video_list($url) {

// Left AND Right Sidebar Content Information

        $person_id = $this->session->userdata('user_id');
        $person_role = $this->session->userdata('person_role');


        if ($person_role == 3) {
            $data['active_menu'] = 'As Teacher';
        } else if ($person_role == 4) {
            $data['active_menu'] = 'organization';
        } else if ($person_role == 5) {
            $data['active_menu'] = 'As Learner';
        } else {
            $data['active_menu'] = '';
        }
        $data['active_sub_menu'] = 'Video';

        $data['tab'] = 'video_information';
        $data['video_course_info'] = $this->user_video_model->select_video_course_by_url($url);
        if (!$data['video_course_info'] || $data['video_course_info']->video_course_type == 2) {
            redirect();
        }
        $data['all_video'] = $this->user_video_model->select_video_course_all_video_by_url($url);

        $data['main_content'] = $this->load->view('user/video/video_list', $data, true);
        $this->load->view('user/master', $data);
    }

    public function set_video_id($url, $e_upload_video_id) {
        $d_id = str_replace('%F2', '/', $e_upload_video_id);
        $upload_video_id = $this->encrypt->decode($d_id);
        $sdata = array();
        $sdata['upload_video_id'] = $upload_video_id;
        $this->session->set_userdata($sdata);
        redirect('my-video/' . $url);
    }

    function formatSeconds($seconds) {
        $hours = 0;
        $milliseconds = str_replace("0.", '', $seconds - floor($seconds));

        if ($seconds > 3600) {
            $hours = floor($seconds / 3600);
        }
        $seconds = $seconds % 3600;

        return str_pad($hours, 2, '0', STR_PAD_LEFT)
                . gmdate(':i:s', $seconds)
                . ($milliseconds ? ".$milliseconds" : '')
        ;
    }

    public function view_video($url) {

// Left AND Right Sidebar Content Information
        $person_id = $this->session->userdata('user_id');
        $person_role = $this->session->userdata('person_role');

        if ($person_role == 3) {
            $data['active_menu'] = 'As Teacher';
        } else if ($person_role == 4) {
            $data['active_menu'] = 'organization';
        } else if ($person_role == 5) {
            $data['active_menu'] = 'As Learner';
        } else {
            $data['active_menu'] = '';
        }
        $data['active_sub_menu'] = 'Video';

        $data['tab'] = 'video_information';
        $data['video_course_info'] = $this->user_video_model->select_video_course_by_url($url);
        if (!$data['video_course_info']) {
            redirect();
        }
        if ($data['video_course_info']->video_course_type == 2) {
            redirect($url);
        }
        $data['all_video'] = $this->user_video_model->select_video_course_all_video_by_url($url);
        $data['course_creator_info'] = $this->profile_model->person_info_by_person_id($data['video_course_info']->person_id);
//Start Releted Video Course

        $upload_video_id = $this->session->userdata('upload_video_id');
        if (!$upload_video_id) {
            $data['video_in_top'] = $this->user_video_model->select_video_management_top_video($data['video_course_info']->video_management_id);
            $upload_video_id = $data['video_in_top']->upload_video_id;
        }

        $data['all_related_video'] = array();
        $video_course_title = $data['video_course_info']->video_course_title;
        $course_category_id = $data['video_course_info']->course_category_id;
        $video_management_id = $data['video_course_info']->video_management_id;
//End Related Video Course

        $data['video_info'] = $this->user_video_model->select_video_by_name_and_course_id($upload_video_id, $data['video_course_info']->video_management_id);
        if (!$data['video_info']) {
            redirect('video-course/' . $url);
        }
        $video_name = $data['video_info']->upload_video_name;
        $data['related_video_course'] = $this->user_video_model->select_releted_video_course($video_course_title, $video_name, $video_management_id);
        if ($data['video_info']) {
            $this->db->set('upload_video_view', $data['video_info']->upload_video_view + 1);
            $this->db->where('upload_video_id', $upload_video_id);
            $this->db->update('tbl_upload_video');
        }

        $subtitle_data['video_location'] = $data['video_info']->upload_video_location;
        $subtitle_data['video_time_length'] = $data['video_info']->upload_video_time_length;
        $subtitle_data['transcript'] = $data['video_info']->upload_video_transcript;
        $subtitle_data = $this->user_video_model->create_subtitle($subtitle_data);
        $data['subtitle_path'] = $subtitle_data['subtitle_path'];

        $data['main_content'] = $this->load->view('user/video/view_video', $data, true);
        $this->load->view('user/master', $data);
    }

    public function play_video($url, $e_upload_video_id) {

        $d_id = str_replace('%F2', '/', $e_upload_video_id);
        $upload_video_id = $this->encrypt->decode($d_id);

        $sdata = array();
        $sdata['upload_video_id'] = $upload_video_id;
        $this->session->set_userdata($sdata);
        $person_id = $this->session->userdata('user_id');
        $person_role = $this->session->userdata('person_role');

        if ($person_role == 3) {
            $data['active_menu'] = 'As Teacher';
        } else if ($person_role == 4) {
            $data['active_menu'] = 'organization';
        } else if ($person_role == 5) {
            $data['active_menu'] = 'As Learner';
        } else {
            $data['active_menu'] = '';
        }
        $data['active_sub_menu'] = 'Video';

        $data['tab'] = 'video_information';

        $data['all_video'] = $this->user_video_model->select_video_course_all_video_by_url($url);
        $data['video_course_info'] = $this->user_video_model->select_video_course_by_url($url);
        if (!$data['video_course_info']) {
            echo 'no_video_course_info';
            return;
        }

        $data['course_creator_info'] = $this->profile_model->person_info_by_person_id($data['video_course_info']->person_id);
        $upload_video_id = $this->session->userdata('upload_video_id');

        if (!$upload_video_id) {
            $data['video_in_top'] = $this->user_video_model->select_video_management_top_video($data['video_course_info']->video_management_id);
            $upload_video_id = $data['video_in_top']->upload_video_id;
        }

        $data['all_related_video'] = array();
        $video_course_title = $data['video_course_info']->video_course_title;
        $course_category_id = $data['video_course_info']->course_category_id;
        $video_management_id = $data['video_course_info']->video_management_id;

        $data['video_info'] = $this->user_video_model->select_video_by_name_and_course_id($upload_video_id, $data['video_course_info']->video_management_id);
        if (!$data['video_info']) {
            echo 'no_video_info';
            return;
        }
        $video_name = $data['video_info']->upload_video_name;
        $data['related_video_course'] = $this->user_video_model->select_releted_video_course($video_course_title, $video_name, $video_management_id);
        if ($data['video_info']) {
            $this->db->set('upload_video_view', $data['video_info']->upload_video_view + 1);
            $this->db->where('upload_video_id', $upload_video_id);
            $this->db->update('tbl_upload_video');
        }

        $data['subtitle_path'] = '';
        if ($data['video_info']->upload_video_transcript) {
            $subtitle_data['video_location'] = $data['video_info']->upload_video_location;
            $subtitle_data['video_time_length'] = $data['video_info']->upload_video_time_length;
            $subtitle_data['transcript'] = $data['video_info']->upload_video_transcript;
            $subtitle_data = $this->user_video_model->create_subtitle($subtitle_data);
            $data['subtitle_path'] = $subtitle_data['subtitle_path'];
        }

        echo base_url() . 'content-library/' . $data['course_creator_info']->url . '/' . $data['video_info']->upload_video_location;
        echo '##';
        echo base_url() . $data['subtitle_path'];
    }

    public function reload_related_video() {
        $data = array();

        $course_url = $_POST['course_url'];
        $video_url = $_POST['video_url'];

        $d_id = str_replace('%F2', '/', $video_url);
        $upload_video_id = $this->encrypt->decode($d_id);

        $data['video_course_info'] = $this->user_video_model->select_video_course_by_url($course_url);
        $data['video_info'] = $this->user_video_model->select_video_by_name_and_course_id($upload_video_id, $data['video_course_info']->video_management_id);

        $video_course_title = $data['video_course_info']->video_course_title;
        $video_management_id = $data['video_course_info']->video_management_id;
        $video_name = $data['video_info']->upload_video_name;

        $data['related_video_course'] = $this->user_video_model->select_releted_video_course($video_course_title, $video_name, $video_management_id);

        echo $this->load->view('user/video/related_video_reload', $data, true);
    }

    public function view_related_video_course($course_url, $e_upload_video_id) {
        $d_id = str_replace('%F2', '/', $e_upload_video_id);
        $upload_video_id = $this->encrypt->decode($d_id);

        $data['video_course_info'] = $this->user_video_model->select_video_course_by_url($course_url);
        $data['video_info'] = $this->user_video_model->select_video_by_name_and_course_id($upload_video_id, $data['video_course_info']->video_management_id);

        $sdata = array();
        $sdata['public_view_video_id'] = $upload_video_id;
        $sdata['public_view_video_management_id'] = $data['video_course_info']->video_management_id;
        $this->session->set_userdata($sdata);

        if (!$data['video_course_info']) {
            redirect();
        }
        if (!$data['video_info']) {
            redirect();
        }
        redirect($data['video_course_info']->url);
    }

    public function array_msort($array, $cols) {
        $colarr = array();
        foreach ($cols as $col => $order) {
            $colarr[$col] = array();
            foreach ($array as $k => $row) {
                $colarr[$col]['_' . $k] = strtolower($row[$col]);
            }
        }
        $eval = 'array_multisort(';
        foreach ($cols as $col => $order) {
            $eval .= '$colarr[\'' . $col . '\'],' . $order . ',';
        }
        $eval = substr($eval, 0, -1) . ');';
        eval($eval);
        $ret = array();
        foreach ($colarr as $col => $arr) {
            foreach ($arr as $k => $v) {
                $k = substr($k, 1);
                if (!isset($ret[$k]))
                    $ret[$k] = $array[$k];
                $ret[$k][$col] = $array[$k][$col];
            }
        }
        return $ret;
    }

    public function video_course_registration($video_management_id) {

        $person_id = $this->session->userdata('user_id');
        if (!$person_id) {
            $sdata = array();
            $sdata['classroom_buy'] = 'classroom_buy';
            $sdata['url'] = 'video-course-registration/' . $video_management_id;
            $this->session->set_userdata($sdata);
            redirect('sign-in');
        }
        /* if user already register in this course */
        $data['student_info'] = $this->user_course_model->selected_video_course_student_info($video_management_id, $person_id);
        $data['course_info'] = $this->user_course_model->select_video_course_info($video_management_id);
        if ($data['student_info']) {
            $sdata['message'] = 'You are already REGISTERED in this Video Course ';
            $this->session->set_userdata($sdata);
            redirect($data['course_info']->url);
        }

        /* if user not register in this course */
        $student_data = array();
        $student_data['course_id'] = $video_management_id;
        $student_data['student_type'] = 2;

        $student_data['person_id'] = $person_id;
        /* for Free and public Course */
        $student_id = $this->user_course_model->save_student_information($student_data);

        /* check in wish list and clear from Wish list */
        $wish_result = $this->profile_model->select_person_video_course_wish_info($video_management_id, $person_id);
        if ($wish_result) {
            $this->profile_model->delete_select_wishlist($wish_result->wish_list_management_id);
        }

        /* START for Paid Course payment Process */

        if ($data['course_info']->video_course_type == 1) {
            $data['student_info'] = $this->user_course_model->selected_video_course_student_info($video_management_id, $person_id);
            $this->student_video_course_payment($data);
        } else {
            redirect('video/learner');
        }
        /* Redirect to Course Url in this Stage (for free course) */

        $url = $this->session->userdata('url');
        if ($url) {
            redirect($url);
        }

        redirect($data['course_info']->url);
    }

    public function student_video_course_payment($data) {
        $person_id = $this->session->userdata('user_id');
        $result = $data['student_info'];
        $data['person_info'] = $this->profile_model->person_info_by_person_id($person_id);

        /*
         * START Payment Information
         */
        $payment_data = array();
        $payment_data['person_id'] = $person_id;
        $payment_data['payment_name'] = $result->person_first_name . ' ' . $data['person_info']->person_last_name;
        $payment_data['invoice_number'] = 'tt-' . $data['person_info']->url . '-' . date("Y-m-d-H-i-s", strtotime(gmdate('Y-m-d H:i:s')) - $this->session->userdata('time_offset'));
        $payment_data['invoice_created_date'] = date("Y-m-d", strtotime(gmdate('Y-m-d')) - $this->session->userdata('time_offset'));
        $payment_data['due_date'] = $payment_data['invoice_created_date'];
        if ($data['course_info']->video_course_type == 1) {
            $payment_data['payment_status'] = 3;
        } else {
            $payment_data['payment_status'] = 1;
        }
        $payment_data['payment_description'] = $data['course_info']->video_course_title . ' Course Registration Payment ';
        $payment_data['quantity'] = '1';
        $payment_data['unit_price'] = $data['course_info']->video_course_price;
        $payment_data['total_price'] = $data['course_info']->video_course_price;
        $payment_data['coupon_id'] = '';
        $payment_id = $this->user_course_model->save_student_payment_information($payment_data);
        /*
         * END Payment Information
         */
        $student_data = array();
        $this->db->set('payment_id', $payment_id);
        $this->db->where('student_id', $result->student_id);
        $this->db->update('tbl_student', $student_data);
        /*
         * END Update Student Information
         */
        $payment_id = $this->encrypt->encode($payment_id);
        $id = str_replace("/", "%F2", $payment_id);
        redirect('view-invoice-set-id/' . $id);
    }

//    @@@@@@@@ it must be deleted after complete all function video course@@@@@@@@@@@@@@@@

    /*
      -----------@@@RIPON@ Start Video Course Part----------------------------------
     */

    /**

     * @Function            : edit_video_course 
     * @Used IN             : @function-'Self'  User_video[@controller],
     * @Description         : Edit Video Course  
     * @Developed By        : Mahabub Alam
     * @Start DateTime      : Unknown
     * @Updated Date Time   : 24-02-2016 10:46 PM   |  19-03-2016 08:46 PM
     * @Updated By          : Ripon Jaherul         |  Ripon Jaherul      
     * @Status              : available      
     * */
    public function edit_video_course($video_url) {

        $person_role = $this->session->userdata('person_role');
        if ($person_role == 3) {
            $data['active_menu'] = 'teacher';
        } else if ($person_role == 4) {
            $data['active_menu'] = 'organization';
        } else if ($person_role == 5) {
            $data['active_menu'] = 'As Learner';
        } else {
            $data['active_menu'] = '';
        }
        $data['active_sub_menu'] = 'teacher_video';

        //$data['tab'] = 'course_profile';
        $data['left_side'] = 1;
        $data['left_side_menu_view'] = 1;
        $person_id = $this->session->userdata('user_id');
        $data['person_info'] = $this->profile_model->get_single_person_information_by_person_id($person_id);
        if (($data['person_info']->person_role != 3) && ($data['person_info']->person_role != 4)) {
            redirect();
        }
        $data['resource_person_info'] = $this->profile_model->select_resource_person_info($data['person_info']->person_id);

//        $data['feature_info'] = $this->super_admin_feature_model->check_course_feature_information($person_id);
//        if ($data['feature_info']) {
//            $data['feature_price_status'] = $data['feature_info']->feature_price_status;
//        } else {
//            $data['feature_price_status'] = '';
//        }

        $data['video_course_info'] = $this->user_video_model->get_single_video_course_information_by_url($video_url);                
        if ($data['video_course_info']->video_access_level == 4) {
            $data['selected_group'] = $this->user_video_model->get_selected_group_by_video_course_id($data['video_course_info']->video_management_id, 2);
        } else if ($data['video_course_info']->video_access_level == 5) {
            $data['selected_special_uesr'] = $this->user_video_model->get_selected_special_uesr_by_video_course_id($data['video_course_info']->video_management_id, 2);
        }

        $data['all_video_section'] = $this->user_video_model->select_all_video_course_section_by_video_course_id($data['video_course_info']->video_management_id);

        $this->form_validation->set_rules('course_category_id', 'Course Category', 'trim|required');
        if ($this->input->post('course_category_id', TRUE) === 'other') {
            $this->form_validation->set_rules('course_category_name', 'Course Category Name', 'trim|max_length[150]|callback_course_category_name_check');
        }
        if ($this->input->post('video_folder_name', TRUE) != $data['video_course_info']->video_folder_name) {
            $this->form_validation->set_rules('video_folder_name', 'Video Folder Name', 'trim|required|max_length[150]|callback_check_video_folder_name');
        }
        if ($data['person_info']->person_role == 4) {
            $this->form_validation->set_rules('resource_person_id', 'Resource person', 'required');
        }

        $this->form_validation->set_rules('video_course_title', 'Video Title', 'trim|required');
        if ($this->input->post('video_course_url', TRUE) != $data['video_course_info']->url) {
            $this->form_validation->set_rules('video_course_url', 'Video Course URL Address', 'max_length[100]|required|callback_check_video_course_url');
        }
        $this->form_validation->set_rules('video_course_price_currency', 'video Course Price Curreency', 'callback_check_currency');
        $this->form_validation->set_rules('video_course_price', 'video_price', 'callback_check_video_course_price');
        $this->form_validation->set_rules('video_training_objectives', 'video_training_objectives');
        $this->form_validation->set_rules('video_training_outline', 'video_training_outline');
        $this->form_validation->set_rules('video_management_status', 'Video Management Status');
        $this->form_validation->set_rules('video_management_level', 'Video Management Level', 'required');
        $this->form_validation->set_rules('video_access_level', 'Video Access Level', 'required');
        $video_access_level = $this->input->post('video_access_level', TRUE);
        if ($video_access_level == 4) {
            $this->form_validation->set_rules('hidden_search_group_name', 'Group Name', 'required');
        } else if ($video_access_level == 5) {
            $this->form_validation->set_rules('hidden_special_user_name', 'Special User Name', 'required');
        }
        $this->form_validation->set_rules('video_language', 'Video Language', 'required'); 
        
        if ($this->form_validation->run() == FALSE) {            
            if ($data['person_info']->person_role == 4) {
                $resource_person_info = $this->profile_model->select_resource_person_info($data['person_info']->person_id);
                $data['all_resource_person'] = $this->profile_model->get_all_resource_person_info_by_organizarion_id($resource_person_info->organization_id);
            }            
            $data['all_course_category'] = $this->user_video_model->get_all_course_category();
            $data['video_course_info']->video_training_objectives = $this->tinymce_model->changed_text_to_special_character($data['video_course_info']->video_training_objectives);
            $data['video_course_info']->video_training_outline = $this->tinymce_model->changed_text_to_special_character($data['video_course_info']->video_training_outline);
            
            $data['main_content'] = $this->load->view('user/video/edit_video_course', $data, true);
            $this->load->view('user/master', $data);
        } else {
            $this->user_video_model->update_video_course_information($data['video_course_info']);
            redirect('video/teacher');
//            if ($data['all_video_section']) {
//                redirect('edit-uploaded-video/' . $data['video_course_info']->url);
//            } else {
//                redirect('upload-video/' . $data['video_course_info']->url);
//            }
        }
    }

    /**
     * @Function            : check_video_course_type 
     * @Used IN             : @function-'self'  this[@controller],
     * @Description         : check video  course type    
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 24-02-2016 12:06 PM   
     * @Status              : available      
     * */
    public function check_video_course_type($course_type) {
        if ($course_type == 1) {
            $feature_info = $this->check_course_feature_information();
            if ($feature_info->feature_price_status == 1) {
                return TRUE;
            } else {
                $this->form_validation->set_message('check_course_type', "You don't have any access to create paid course");
                return FALSE;
            }
        }
    }

    /**
     * @Function            : get_person_feature_status 
     * @Used IN             : @function-''  user_video[@controller],
     * @Description         : check person feature status    
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 08-03-2016 01:44 AM      
     * @Status              : available      
     * */
    function get_person_feature_status() {
        $feature_info = $this->check_course_feature_information();
        if ($feature_info) {
            $video_course_type = $this->input->post('video_course_type', TRUE);
            if ($video_course_type == '1') {
                if ($feature_info->feature_price_status == 1) {
                    echo 'paid_course';
                } else {
                    echo 'not_paid_course';
                }
            }
        }
    }

    /**
     * @Function            : check_cpurse_feature_information 
     * @Used IN             : @function-'get_person_feature_status'            this[@controller]
     * @Description         : check feature status
     * @Developed By        : Copied  from - 'user_course[@Controller]'
     * @Start DateTime      : 08-03-2016 01:52 AM    
     * @Status              : available      
     * */
    function check_course_feature_information() {
        $person_id = $this->session->userdata('user_id');
        $data['person_info'] = $this->profile_model->get_single_person_information_by_person_id($person_id);
        if ($data['person_info']->person_role == 3) {
            $data['resource_person_info'] = $this->profile_model->select_resource_person_info($data['person_info']->person_id);
            if ($data['resource_person_info']->resource_person_type == 1) {
                return $this->get_feature_information_by_feature_id($data['resource_person_info']->feature_price_id, $data['resource_person_info']->person_id);
            } else if ($data['resource_person_info']->resource_person_type == 2) {
                return $this->get_feature_information_by_feature_id($data['resource_person_info']->feature_price_id, $data['resource_person_info']->person_id);
            } else if ($data['resource_person_info']->resource_person_type == 3) {
                $organization_info = $this->profile_model->select_organization_info_by_organization_id($data['resource_person_info']->organization_id);
                return $this->get_feature_information_by_feature_id($organization_info->feature_price_id, $organization_info->person_id);
            }
        } else if ($data['person_info']->person_role == 4) {
            $data['resource_person_info'] = $this->profile_model->select_resource_person_info($data['person_info']->person_id);
            $organization_info = $this->profile_model->select_organization_info($data['person_info']->person_id);
            return $this->get_feature_information_by_feature_id($organization_info->feature_price_id, $organization_info->person_id);
        }
    }

    /**
     * @Function            : get_feature_information 
     * @Used IN             : @function-'add_course'      this[@controller]- 3 times
     * @Description         : check feature status
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 02-03-2016 06:38 PM    
     * @Status              : available      
     * */
    public function get_feature_information_by_feature_id($feature_price_id, $person_id) {
        if ($feature_price_id != '') {
            $feature_id = explode(',', $feature_price_id);
            if ($feature_id[0] != '') {
                return $this->user_course_model->get_feature_information($feature_id[0], $person_id);
            } else {
                return $this->user_course_model->get_feature_information('', $person_id);
            }
        } else {
            return $this->user_course_model->get_feature_information('', $person_id);
        }
    }

    /*
      -----------@@@RIPON@ END Video Course Part----------------------------------
     */

    /*
      -----------@@@RIPON@ Start Video Course Upload Video Part Part----------------------------------
     */

    /**
     * @Function            : upload_video 
     * @Used IN             : @function-'upload_video.php'     user_video[@Controller]
     * @Description         : upload course video
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 24-02-2016 07:22 PM
     * @Status              : available      
     * */
    public function upload_video($video_course_url) {
        $person_id = $this->session->userdata('user_id');
        $person_role = $this->session->userdata('person_role');
// Left AND Right Sidebar Content Information

        if ($person_role == 3) {
            $data['active_menu'] = 'As Teacher';
        } else if ($person_role == 4) {
            $data['active_menu'] = 'organization';
        } else if ($person_role == 5) {
            $data['active_menu'] = 'As Learner';
        } else {
            $data['active_menu'] = '';
        }

        $data['active_sub_menu'] = 'Video';
        $data['tab'] = 'video_information';
        $data['left_side_menu_view'] = 1;
        $data['left_side'] = 1;
// Left AND Right Sidebar Content Information
        $data['video_course_info'] = $this->user_video_model->get_single_video_course_information_by_url($video_course_url);
        if (!$data['video_course_info']) {
            redirect();
        }
        $data['section_counter'] = 1;
        $data['video_counter'] = 1;
        $data['main_content'] = $this->load->view('user/video/upload_video', $data, true);
        $this->load->view('user/master', $data);
    }

    /**
     * @Function            : edit_uploaded_video 
     * @Used IN             : @function-'edit_uploaded_video'      user_video[@Controller]
     * @Description         : upload course video
     * @Developed By        : Mahabub-A-Mawla
     * @Start DateTime      : Unkonwn
     * @Updated Date Time   : 24-02-2016 07:22 PM
     * @Updated By          : Ripon Jaherul  
     * @Status              : available      
     * */
    public function edit_uploaded_video($video_course_url) {
        $person_id = $this->session->userdata('user_id');
        $person_role = $this->session->userdata('person_role');
// Left AND Right Sidebar Content Information


        if ($person_role == 3) {
            $data['active_menu'] = 'As Teacher';
        } else if ($person_role == 4) {
            $data['active_menu'] = 'organization';
        } else if ($person_role == 5) {
            $data['active_menu'] = 'As Learner';
        } else {
            $data['active_menu'] = '';
        }

        $data['person_info'] = $this->profile_model->get_single_person_information_by_person_id($person_id);
        if (($data['person_info']->person_role != 3) && ($data['person_info']->person_role != 4)) {
            redirect();
        }

        $data['active_sub_menu'] = 'Video';
        $data['tab'] = 'video_information';
        $data['left_side_menu_view'] = 1;
        $data['left_side'] = 1;
// Left AND Right Sidebar Content Information

        $data['section_counter'] = 0;
        $data['video_course_info'] = $this->user_video_model->get_single_video_course_information_by_url($video_course_url);
        $data['all_video_section'] = $this->user_video_model->select_all_video_course_section_by_video_course_id($data['video_course_info']->video_management_id);
        foreach ($data['all_video_section'] as $section_value) {
            $data['upload_video_info'][$section_value->upload_video_section_name] = $this->user_video_model->get_all_upload_id_by_section_name1($data['video_course_info']->video_management_id, $section_value->upload_video_section_name);
            foreach ($data['upload_video_info'][$section_value->upload_video_section_name] as $upload_video_value) {
                if ($upload_video_value->video_work_files == 1) {
                    $data['video_work_file_info'][$upload_video_value->upload_video_id] = $this->user_video_model->get_work_file_info_by_video_upload_id($upload_video_value->upload_video_id);
                }
            }
        }

        $data['main_content'] = $this->load->view('user/video/edit_uploaded_video', $data, true);
        $this->load->view('user/master', $data);
    }

    /**
     * @Function            : save_uploaded_video 
     * @Used IN             : @function-'add_video_course'          user_video[@Controller]
     * @Description         : save uploaded course video file
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 27-02-2016 06:39 PM 
     * @Status              : available      
     * */
    function save_uploaded_video($video_course_url) {
        $this->user_video_model->save_video_course_work_file();
        redirect('video-course-review-and-publish/' . $video_course_url);
    }

    /**
     * @Function            : save_video_course_as_draft 
     * @Used IN             : @function-'review_adn_publish.php'
     * @Description         : save video course as a draft
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 23-03-2016 05:42 PM 
     * @Status              : available      
     * */
    public function save_video_course_as_draft($video_course_url) {
        if ($video_course_url) {
            $data['video_course_info'] = $this->user_video_model->get_single_video_course_information_by_url($video_course_url);
            $vData['video_management_status'] = 5;
            $this->user_video_model->update_information_in_database('tbl_video_management', 'video_management_id', $data['video_course_info']->video_management_id, $vData);
            redirect('my-video');
        }
    }

    /**
     * @Function            : submit_video_course 
     * @Used IN             : @function-'review_adn_publish.php'
     * @Description         : save video course as a pending
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 23-03-2016 05:42 PM 
     * @Status              : available      
     * */
    public function submit_video_course($video_course_url) {
        if ($video_course_url) {
            $data['video_course_info'] = $this->user_video_model->get_single_video_course_information_by_url($video_course_url);
            $vData['video_management_status'] = 3;
            $this->user_video_model->update_information_in_database('tbl_video_management', 'video_management_id', $data['video_course_info']->video_management_id, $vData);
            redirect('my-video');
        }
    }

    /**
     * @Function            : skip_video_course_work_file 
     * @Used IN             : @function-'upload_video.php'
     * @Description         : skip video course work file
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 23-03-2016 06:39 PM 
     * @Status              : available      
     * */
    function skip_video_course_work_file() {
        $video_course_url = $this->input->post('video_course_url', TRUE);
        $video_course_info = $this->user_video_model->get_single_video_course_information_by_url($video_course_url);

        $upload_video_id = $this->user_video_model->get_all_upload_video_id_by_video_course_id($video_course_info->video_management_id);

        if ($upload_video_id != '') {
            $course_creator_url = $this->user_video_model->get_profile_url($video_course_info->course_creator_id);
            $section_directory = 'content-library/' . $course_creator_url . '/my-video/' . $video_course_info->video_folder_name;
            if (is_dir($section_directory)) {
                $this->user_video_model->remove_directory($section_directory);
            }

            $upload_video_id_array = explode(',', $upload_video_id);
            for ($i = 0; $i < count($upload_video_id_array); $i++) {
                $video_work_file_info = $this->user_video_model->get_work_file_info_by_video_upload_id($upload_video_id_array[$i]);
                if ($video_work_file_info) {
                    $this->user_video_model->remove_upload_video_course_work_file_by_work_file_id($video_work_file_info->work_files_management_id);
                }
                $this->user_video_model->delete_single_video_course_by_upload_video_id($upload_video_id_array[$i]);
            }
            $folder = 'content-library/' . $course_creator_url . '/my-video/' . $video_course_info->video_folder_name . '/';
            if (!file_exists($folder)) {
                mkdir($folder, 0777, true);
            }
            echo 'success';
        } else {
            echo 'success';
        }
    }

    /**
     * @Function            : skip_edit_video_course_work_file 
     * @Used IN             : @function-'edit_uploaded_video.php'
     * @Description         : skip edit video course work file
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 23-03-2016 08:09 PM 
     * @Status              : available      
     * */
    function skip_edit_video_course_work_file() {
        $video_course_url = $this->input->post('video_course_url', TRUE);
        $video_course_info = $this->user_video_model->get_single_video_course_information_by_url($video_course_url);
        $upload_video_id = $this->user_video_model->get_all_upload_video_id_by_video_course_id($video_course_info->video_management_id);
        if ($upload_video_id != '') {
            $upload_video_id_array = explode(',', $upload_video_id);

            for ($i = 0; $i < count($upload_video_id_array); $i++) {
                $video_work_file_info = $this->user_video_model->get_work_file_info_by_video_upload_id($upload_video_id_array[$i]);
                if ($video_work_file_info) {
                    $wData['work_files_status'] = 3;
                    $this->user_video_model->update_information_in_database('tbl_work_files_management', 'work_files_management_id', $video_work_file_info->work_files_management_id, $wData);
                }
                $vData['upload_video_status'] = 5;
                $this->user_video_model->update_information_in_database('tbl_upload_video', 'upload_video_id', $upload_video_id_array[$i], $vData);
            }
            echo 'success';
        } else {
            echo 'success';
        }
    }

    /**
     * @Function            : edit_uploaded_video 
     * @Used IN             : @function-'save_uploaded_video'     this[@Controller]
     * @Description         : video review and published
     * @Developed By        : Mahabub-A-Mawla
     * @Start DateTime      : Unkonwn
     * @Updated Date Time   : 20-03-2016 01:50 PM
     * @Updated By          : Ripon Jaherul  
     * @Status              : available      
     * */
    public function video_course_review_and_publish($video_course_url) {
// Left AND Right Sidebar Content Information

        $person_role = $this->session->userdata('person_role');

        $data['left_side_menu_view'] = 1;
        $data['left_side'] = 1;
        if ($person_role == 3) {
            $data['active_menu'] = 'As Teacher';
        } else if ($person_role == 4) {
            $data['active_menu'] = 'organization';
        } else if ($person_role == 5) {
            $data['active_menu'] = 'As Learner';
        } else {
            $data['active_menu'] = '';
        }
        $data['active_sub_menu'] = 'Video';
        $data['tab'] = 'video_information';
        $data['video_course_url'] = $video_course_url;
        $data['main_content'] = $this->load->view('user/video/review_and_publish', $data, true);
        $this->load->view('user/master', $data);
    }

    /**
     * @Function            : check_video_section_name_existence 
     * @Used IN             : @function-'Self'       this[@controller],
     * @Description         : Check video section name and existence
     * @Developed By        : Copied from 'Super_admin_video'
     * @Start DateTime      : 27-02-2016 04:17 PM         
     * @Status              : available      
     * */
    function check_section_name_exist() {
        $video_section_name = $this->input->post('video_section_name', TRUE);
        $video_management_id = $this->input->post('video_management_id', TRUE);
        $all_upload_id1 = explode(',', $this->input->post('all_upload_id', TRUE));
        $all_upload_id = array_filter($all_upload_id1);

        if ($video_section_name != '' && $video_management_id != '') {
            $result = $this->user_video_model->check_video_course_section_name($video_management_id, $video_section_name, implode(',', $all_upload_id));
            if ($result) {
                echo 1;
            } else {
                echo 2;
            }
        }
    }

    /**
     * @Function            : check_video_file_name_exist 
     * @Used IN             : @function-'Self'       this[@controller],
     * @Description         : Check video name and existence
     *  @Developed By       : Copied from 'super-admin-video'
     * @Start DateTime      : 15-02-2016 01:11 PM   
     * @Status              : available      
     * */
    function check_video_file_name_exist() {
        $upload_video_id = $this->input->post('upload_video_id', TRUE);
        $upload_video_id1 = $this->input->post('upload_video_id1', TRUE);
        $upload_video_info = $this->user_video_model->get_upload_video_information_by_upload_video_id($upload_video_id);
        $video_management_id = $this->input->post('video_management_id', TRUE);
        $video_name = $this->input->post('upload_video_name', TRUE);

        $result = $this->user_video_model->check_upload_video_name($video_management_id, $upload_video_info->upload_video_section_name, $video_name, $upload_video_id1);
        if ($result) {
            echo 1;
        } else {
            echo 2;
        }
    }

    /**
     * @Function            : uploaded_video_courses_video_file 
     * @Used IN             : @function-'Self'       this[@controller],
     * @Description         : Upload video for video course
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 25-02-2016 12:27 AM
     * @Updated Date Time   : 19-04-2016 02:50 PM
     * @Updated By          : MD Jaherul Islam    
     * @Parameter           : NULL
     * @View                : None
     * @Redirect            : None
     * @Return              : NULL        
     * @Status              : available      
     * */
    function uploaded_video_courses_video_file() {
        $data['video_management_id'] = $this->input->post('video_management_id', TRUE);
        $video_course_info = $this->user_video_model->get_single_video_course_information_by_id($data['video_management_id']);
        $person_info = $this->person_model->get_single_person_information_by_person_id($video_course_info->course_creator_id);

        if ($person_info->person_role == 6 || $person_info->person_role == 1) {
            $this->check_validation_for_upload_video_course($video_course_info);
        } else if ($person_info->person_role == 3 || $person_info->person_role == 4) {
            //$feature_info = $this->super_admin_feature_model->check_course_feature_information($video_course_info->course_creator_id);
            //if ($feature_info) {
                if ($_FILES['video_file']) {
                    $fileSize = $_FILES["video_file"]["size"];
                    $used_storage = $this->person_model->get_person_total_used_storage($video_course_info->course_creator_id);
                    $total_storage = ((($feature_info->feature_price_storage * 1024) * 1024) * 1024);

                    if ($total_storage >= ($used_storage + $fileSize)) {
                        $this->check_validation_for_upload_video_course($video_course_info);
                    } else {
                        echo 'size_exists';
                    }
                } else {
                    echo 'file_not_found';
                }
//            } else {
//                echo 'no_feature';
//            }
        }
    }

    function check_validation_for_upload_video_course($video_course_info) {
        $fileSize = $_FILES["video_file"]["size"];
        $fileTmpLoc = $_FILES["video_file"]["tmp_name"];
        $fileName = $_FILES["video_file"]["name"];
        $file_explode = explode('.', $fileName);
        $file_extention = strtolower($file_explode[count($file_explode) - 1]);

        if ($fileTmpLoc) {
            if ($fileSize > 524288000) {
                echo 'error_size';
            } elseif ($this->user_video_model->check_video_file_type($file_extention) == 2) {
                echo 'error_type';
            } else {
                $this->upload_video_for_video_course($video_course_info->video_management_id, $fileName, $fileTmpLoc, $fileSize, $file_extention);
            }
        } else {
            echo 'error_loc';
        }
    }

    /**
     * @Function            : get_course_by_category_id 
     * @Used IN             : @function-'get_course_value'  super_admin_course[@controller],
     * @Description         : get all available course using category ID  
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 10-04-2016 02:38 PM     
     * @Parameter           : $video_management_id[INTEGER], $fileName[STRING], $fileTmpLoc[STRING], $fileSize[INTEGER], $file_extention[STRING]
     * @View                : None
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function upload_video_for_video_course($video_management_id, $fileName, $fileTmpLoc, $fileSize, $file_extention) {
        $upload_video_id = $this->input->post('upload_video_id', TRUE);
        $all_upload_video_id_array1 = explode(',', $this->input->post('all_upload_video_id', TRUE));
        $all_upload_video_id_array = array_filter($all_upload_video_id_array1);

        $video_data['video_management_id'] = $video_management_id;
        $video_data['upload_video_name'] = $video_name = $this->input->post('upload_video_name', TRUE);
        $video_data['upload_video_size'] = $fileSize;
        $video_data['upload_video_time_length'] = $this->get_video_duration($fileTmpLoc);
        $video_data['upload_video_date'] = date('Y/m/d H:i:s', (time() - $this->session->userdata('time_offset')));
        $video_data['upload_video_transcript'] = $this->input->post('upload_video_transcript', TRUE);
        $video_data['upload_video_access_level'] = 1;
        $video_data['upload_video_status'] = 5;
        $video_data['video_work_files'] = 2;

        $video_course_info = $this->user_video_model->get_single_video_course_information_by_id($video_management_id);
        $course_creator_url = $this->user_video_model->get_profile_url($video_course_info->course_creator_id);

        if ($upload_video_id == '') {
            if (!$all_upload_video_id_array) {
                $video_data['upload_video_section_name'] = $this->input->post('upload_video_section_name', TRUE);
                $make_diriectory = 'content-library/' . $course_creator_url . '/my-video/' . $video_course_info->video_folder_name . '/' . $video_data['upload_video_section_name'] . '/';
                mkdir($make_diriectory, 0777, true);
            } else {
                $video_upload_info = $this->user_video_model->get_upload_video_information_by_upload_video_id($all_upload_video_id_array[0]);
                $video_data['upload_video_section_name'] = $video_upload_info->upload_video_section_name;
            }
        } else {
            $video_upload_info = $this->user_video_model->get_upload_video_information_by_upload_video_id($upload_video_id);
            $file_path = 'content-library/' . $course_creator_url . $video_upload_info->upload_video_location;
            if (file_exists($file_path)) {
                unlink($file_path);
            }
            $video_data['upload_video_section_name'] = $video_upload_info->upload_video_section_name;
        }
        $section_diriectory = 'content-library/' . $course_creator_url . '/my-video/' . $video_course_info->video_folder_name . '/' . $video_data['upload_video_section_name'] . '/';
        $target_file = $section_diriectory . $fileName;

        if (move_uploaded_file($fileTmpLoc, $target_file)) {
            $source_file = "$section_diriectory$video_name.$file_extention";
            rename("$target_file", "$source_file");
            $video_data['upload_video_location'] = '/my-video/' . $video_course_info->video_folder_name . '/' . $video_data['upload_video_section_name'] . '/' . "$video_name.$file_extention";

            if ($upload_video_id == '') {
                $upload_video_id = $this->user_video_model->save_information_in_database('tbl_upload_video', $video_data);
                echo $upload_video_id . '@@@' . $fileSize;
            } else {
                $this->user_video_model->update_information_in_database('tbl_upload_video', 'upload_video_id', $upload_video_id, $video_data);
                echo $upload_video_id . '@@@' . $fileSize;
            }
        }
    }

    /**
     * @Function            : add_video_work_file_view 
     * @Used IN             : @function-'Self'       this[@controller],
     * @Description         : add video work file view
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 25-02-2016 04:44 PM       
     * @Status              : available      
     * */
    function add_video_work_file_view() {
        $data['video_management_id'] = $this->input->post('video_management_id', TRUE);
        $data['section_counter'] = $this->input->post('section_counter', TRUE);
        $data['video_counter'] = $this->input->post('video_counter', TRUE);
        echo $this->load->view('user/video/ajax_page/add_single_work_file', $data, true);
    }

    /**
     * @Function            : remove_video_work_file_view 
     * @Used IN             : @function-'Self'       this[@controller],
     * @Description         : remo0ve video work file view
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 27-02-2016 10:54 PM       
     * @Status              : available      
     * */
    function remove_video_work_file_view() {
        $work_files_management_id = $this->input->post('work_files_management_id', TRUE);
        $work_file_info = $this->user_video_model->get_upload_video_work_file_info_by_work_file_id($work_files_management_id);
        $course_creator_url = $this->user_video_model->get_profile_url($work_file_info->course_creator_id);
        $file_path = 'content-library/' . $course_creator_url . $work_file_info->work_files_url;
        if (file_exists($file_path)) {
            unlink($file_path);
        }
        $this->user_video_model->change_work_file_status_in_course_video($work_file_info->upload_video_id, 2);
        $this->user_video_model->remove_upload_video_course_work_file_by_work_file_id($work_files_management_id);
        echo 'success';
    }

    /**
     * @Function            : check_video_work_file_name_exist 
     * @Used IN             : @function-'Self'       this[@controller],
     * @Description         : check video course work file name existence
     * @Developed By        : Copied from 'super_admin_model'
     * @Start DateTime      : 27-02-2016 04:38 PM           
     * @Status              : available      
     * */
    function check_video_work_file_name_exist() {
        $all_upload_video_id_array = array();
        $upload_video_id = $this->input->post('upload_video_id', TRUE);
        $upload_video_id1 = $this->input->post('upload_video_id1', TRUE);
        $upload_video_info = $this->user_video_model->get_upload_video_information_by_upload_video_id($upload_video_id);
        $all_upload_video_id = $this->user_video_model->get_all_upload_id_by_section_name1($upload_video_info->video_management_id, $upload_video_info->upload_video_section_name);
        foreach ($all_upload_video_id as $value) {
            $all_upload_video_id_array[] = $value->upload_video_id;
        }
        $work_files_name = $this->input->post('work_files_name', TRUE);
        $result = $this->user_video_model->check_video_course_work_file_name_existence(implode(',', $all_upload_video_id_array), $work_files_name, $upload_video_id1);
        if ($result) {
            echo 1;
        } else {
            echo 2;
        }
    }

    /**
     * @Function            : check_video_work_file_name_exist 
     * @Used IN             : @function-'Self'       this[@controller],
     * @Description         : check video work file validation 
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 25-02-2016 06:06 PM
     * @Updated Date Time   : 19-04-2016 06:23 PM
     * @Updated By          : MD Jaherul Islam  
     * @Parameter           : NULL
     * @View                : None
     * @Redirect            : None
     * @Return              : NULL             
     * @Status              : available      
     * */
    function upload_video_course_work_file() {
        $data['video_management_id'] = $this->input->post('video_management_id', TRUE);
        $video_course_info = $this->user_video_model->get_single_video_course_information_by_id($data['video_management_id']);
        $person_info = $this->person_model->get_single_person_information_by_person_id($video_course_info->course_creator_id);

        if ($person_info->person_role == 6 || $person_info->person_role == 1) {
            $this->check_validation_for_add_video_work_file();
        } else if ($person_info->person_role == 3 || $person_info->person_role == 4) {
            $feature_info = $this->super_admin_feature_model->check_course_feature_information($video_course_info->course_creator_id);
            if ($feature_info) {
                if ($_FILES['video_work_file']) {
                    $fileSize = $_FILES["video_work_file"]["size"];
                    $used_storage = $this->person_model->get_person_total_used_storage($video_course_info->course_creator_id);
                    $total_storage = ((($feature_info->feature_price_storage * 1024) * 1024) * 1024);

                    if ($total_storage >= ($used_storage + $fileSize)) {
                        $this->check_validation_for_add_video_work_file();
                    } else {
                        echo 'size_exists';
                    }
                } else {
                    echo 'file_not_found';
                }
            } else {
                echo 'no_feature';
            }
        }
    }

    function check_validation_for_add_video_work_file() {
        $fileSize = $_FILES["video_work_file"]["size"];
        $fileTmpLoc = $_FILES["video_work_file"]["tmp_name"];
        $fileName = $_FILES["video_work_file"]["name"];
        $file_explode = explode('.', $fileName);
        $file_extention = $file_explode[count($file_explode) - 1];

        if ($fileTmpLoc) {
            if ($fileSize == 0) {
                echo 'error_size_zero';
            } else if ($fileSize > 10485760) {
                echo 'error_max_size';
            } elseif ($this->user_course_model->check_work_file_type(strtolower($file_extention)) == 2) {
                echo 'error_type';
            } else {
                $this->upload_video_course_work_file1($fileName, $fileSize, $fileTmpLoc, $file_extention);
            }
        } else {
            echo 'error_location';
        }
    }

    /**
     * @Function            : upload_video_course_work_file1 
     * @Used IN             : @function-'upload_video_course_work_file'       this[@controller],
     * @Description         : upload video course work file 
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 20-04-2016 09:30 AM
     * @Parameter           : $fileName[STRING], $fileSize[INTEGER], $fileTmpLoc[STRING], $file_extention[STRING]
     * @View                : None
     * @Redirect            : None
     * @Return              : NULL             
     * @Status              : available      
     * */
    function upload_video_course_work_file1($fileName, $fileSize, $fileTmpLoc, $file_extention) {
        $upload_video_id = $this->input->post('upload_video_id', TRUE);
        $upload_video_info = $this->user_video_model->get_upload_video_information_by_upload_video_id($upload_video_id);
        $course_creator_url = $this->user_video_model->get_profile_url($upload_video_info->course_creator_id);

        $work_data['upload_video_id'] = $upload_video_id;
        $work_data['work_file_folder_name'] = $upload_video_info->upload_video_section_name;
        $work_data['work_files_name'] = $work_files_name = $this->input->post('work_files_name', TRUE);
        $work_data['work_files_upload_date'] = date('Y/m/d', (time() - $this->session->userdata('time_offset')));
        $work_data['work_file_size'] = $fileSize;
        $work_data['work_files_management_access_level'] = $upload_video_info->upload_video_access_level;
        $work_data['work_files_status'] = 3;

        $diriectory = 'content-library/' . $course_creator_url . '/my-video/' . $upload_video_info->video_folder_name . '/' . $upload_video_info->upload_video_section_name . '/';

        $work_files_management_id = $this->input->post('work_files_management_id', TRUE);
        if ($work_files_management_id != '') {
            $video_work_file_info = $this->user_video_model->get_upload_video_work_file_info_by_work_file_id($work_files_management_id);
            $file_path = 'content-library/' . $course_creator_url . $video_work_file_info->work_files_url;
            if (file_exists($file_path)) {
                unlink($file_path);
            }
        }

        $target_file = $diriectory . $fileName;
        if (move_uploaded_file($fileTmpLoc, $target_file)) {
            $destination_file = $diriectory . "$work_files_name.$file_extention";
            rename("$target_file", "$destination_file");

            $work_data['work_files_url'] = '/my-video/' . $upload_video_info->video_folder_name . '/' . $upload_video_info->upload_video_section_name . '/' . "$work_files_name.$file_extention";

            if ($work_files_management_id == '') { // if file uploaded first time
                $video_data['video_work_files'] = 1;
                $this->utility_model->update_information_in_database('tbl_upload_video', 'upload_video_id', $upload_video_id, $video_data);
                $work_files_management_id1 = $this->utility_model->save_information_in_database('tbl_work_files_management', $work_data);
                echo $work_files_management_id1 . '@@@' . $fileSize; // concat upload_file_id and uploaded file Size
            } else { // if file uploaded is override 
                $this->user_video_model->update_information_in_database('tbl_work_files_management', 'work_files_management_id', $work_files_management_id, $work_data);
                echo $work_files_management_id . '@@@' . $fileSize; // concat upload_file_id and uploaded file Size
            }
        }
    }

    /**
     * @Function            : uploaded_course_video_file_size 
     * @Used IN             : @function-'upload_course_work_file'                   this[@controller],
     * @Description         : get uploaded video file size and total drive size
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 06-03-2016 03:37 PM
     * @Updated Date Time   : 06-04-2016 06:03 PM
     * @Updated By          : MD Jaherul Islam      
     * @Parameter           : NULL
     * @View                : None
     * @Redirect            : None
     * @Return              : NULL           
     * @Status              : available      
     * */
    function uploaded_course_video_file_size() {
        $video_management_id = $this->input->post('video_management_id', TRUE);
        $video_course_info = $this->user_video_model->get_single_video_course_information_by_id($video_management_id);
        $person_info = $this->person_model->get_single_person_information_by_person_id($video_course_info->course_creator_id);
        if ($person_info->person_role == 6 || $person_info->person_role == 1) {
            $this->get_back_end_user_storage($person_info->url);
        } else if ($person_info->person_role == 3 || $person_info->person_role == 4) {
            $this->get_front_end_user_storage($video_course_info);
        }
    }

    function get_back_end_user_storage($url) {
        $directory = 'content-library/' . $url;
        $used_space = $this->user_video_model->person_available_disk_space($directory);
        $fileSize = '';
        $fileSize1 = $this->input->post('upload_file_size', TRUE);
        $fileSize2 = round(($fileSize1 / 1024), 2);
        if ($fileSize2 > 1024) {
            $fileSize = round(($fileSize2 / 1024), 2) . ' MB';
        } else {
            $fileSize = ($fileSize2) . ' KB';
        }
        if ($used_space > 1048576) {
            $used_space = round(($used_space / 1024 / 1024 / 1024), 2) . ' GB';
        } else {
            $used_space = round(($used_space / 1024 / 1024), 2) . ' MB';
        }
        echo 'Your file size is <span style="color: red;">' . $fileSize . '</span>, and You have used <span style="color: red;">' . $used_space . '</span>';
    }

    function get_front_end_user_storage($video_course_info) {
        $used_storage = $this->person_model->get_person_total_used_storage($video_course_info->course_creator_id);
        //$feature_info = $this->super_admin_feature_model->check_course_feature_information($video_course_info->course_creator_id);
        //$total_storage = ((($feature_info->feature_price_storage * 1024) * 1024) * 1024);
        //$remaining_storage = round($total_storage - $used_storage);

        $fileSize = '';
        $used_space = '';
        $fileSize1 = $this->input->post('upload_file_size', TRUE);
        $fileSize2 = round(($fileSize1 / 1024), 2);
        if ($fileSize2 > 1024) {
            $fileSize = round(($fileSize2 / 1024), 2) . ' MB';
        } else {
            $fileSize = ($fileSize2) . ' KB';
        }

        if ($remaining_storage > 1048576) {
            $used_space = round(($remaining_storage / 1024 / 1024 / 1024), 2) . ' GB';
        } else {
            $used_space = round(($remaining_storage / 1024 / 1024), 2) . ' MB';
        }
        echo 'Your file size is <span style="color: red;">' . $fileSize . '</span>, and Your remaining volume is <span style="color: red;">' . $used_space . '</span>';
    }

    /**
     * @Function            : uploaded_course_video_file_size 
     * @Used IN             : @function-'upload_course_work_file'                   this[@controller],
     * @Description         : get uploaded video file size and total drive size
     * @Developed By        : Copied from 'user_video'-controller
     * @Start DateTime      : 06-03-2016 03:37 PM       
     * @Status              : available      
     * */
    function get_user_total_storage($person_id) {
        $total_used_space = '';
        $resource_person_info = $this->user_video_model->select_resource_person_information($person_id);
        if ($resource_person_info->resource_person_type == 3) {
            $all_organization_user = $this->user_video_model->select_all_organization_user_information($resource_person_info->organization_id);
            foreach ($all_organization_user as $organization_user_value) {
                $directory = 'content-library/' . $organization_user_value->url;
                $total_used_space+= $this->user_video_model->person_available_disk_space($directory);
            }
        } else {
            $directory = 'content-library/' . $resource_person_info->url;
            $total_used_space = $this->user_video_model->person_available_disk_space($directory);
        }
        return $total_used_space;
    }

    /**
     * @Function            : upload_single_video_course_work_file 
     * @Used IN             : @function-'Self'       this[@controller],
     * @Description         : get upload video course area
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 27-02-2016 11:45 AM    
     * @Status              : available      
     * */
    function upload_single_video_course_work_file() {
        $video_counter = $this->input->post('video_counter', TRUE);
        $video_management_id = $this->input->post('video_management_id', TRUE);
        $data['section_counter'] = $this->input->post('section_counter', TRUE);
        $data['video_counter'] = ++$video_counter;
        $data['video_course_info'] = $this->user_video_model->get_single_video_course_information_by_id($video_management_id);
        echo $this->load->view('user/video/ajax_page/add_single_video_course', $data, true);
    }

    /**
     * @Function            : delete_single_video_course_area 
     * @Used IN             : @function-'removeSingleVideo'             video_course.js
     * @Description         : Remove Single uploaded video course area with work file if it has been a work file
     * @Developed By        : Copied from 'super_admin_video'
     * @Start DateTime      : 27-02-2016 12:13 PM    
     * @Status              : available      
     * */
    function delete_single_video_course() {
        $upload_video_id = $this->input->post('upload_video_id', TRUE);
        $upload_video_info = $this->user_video_model->get_upload_video_information_by_upload_video_id($upload_video_id);
        $course_creator_url = $this->user_video_model->get_profile_url($upload_video_info->course_creator_id);

        if (count($this->user_video_model->get_all_upload_id_by_section_name1($upload_video_info->video_management_id, $upload_video_info->upload_video_section_name)) == 1) {
            $section_directory = 'content-library/' . $course_creator_url . '/my-video/' . $upload_video_info->video_folder_name . '/' . $upload_video_info->upload_video_section_name;
            if (is_dir($section_directory)) {
                $this->user_video_model->remove_directory($section_directory);
            }
            $video_work_file_info = $this->user_video_model->get_work_file_info_by_video_upload_id($upload_video_id);
            if ($video_work_file_info) {
                $this->user_video_model->remove_upload_video_course_work_file_by_work_file_id($video_work_file_info->work_files_management_id);
            }
            $this->user_video_model->delete_single_video_course_by_upload_video_id($upload_video_id);
        } else {
            $video_directory = 'content-library/' . $course_creator_url . $upload_video_info->upload_video_location;
            if (file_exists($video_directory)) {
                unlink($video_directory);
            }

            $video_work_file_info = $this->user_video_model->get_work_file_info_by_video_upload_id($upload_video_id);
            if ($video_work_file_info) {
                $video_work_file_directory = 'content-library/' . $course_creator_url . $video_work_file_info->work_files_url;
                if (file_exists($video_work_file_directory)) {
                    unlink($video_work_file_directory);
                }
                $this->user_video_model->remove_upload_video_course_work_file_by_work_file_id($video_work_file_info->work_files_management_id);
            }
            $this->user_video_model->delete_single_video_course_by_upload_video_id($upload_video_id);
        }
        echo 'success';
    }

    /**
     * @Function            : add_video_course_section_area 
     * @Used IN             : @function-'Self'       this[@controller],
     * @Description         : Add Video course Section area
     * @Developed By        : Copied from 'super-admin-video'
     * @Start DateTime      : 27-02-2016 01:28 PM    
     * @Status              : available      
     * */
    function add_video_course_section_area() {
        $section_counter = $this->input->post('section_counter', TRUE);
        $video_management_id = $this->input->post('video_management_id', TRUE);
        $data['section_counter'] = ++$section_counter;
        $data['video_counter'] = 1;
        $data['video_course_info'] = $this->user_video_model->get_single_video_course_information_by_id($video_management_id);
        echo $this->load->view('user/video/ajax_page/view_video_section', $data, true);
    }

    /**
     * @Function            : remove_video_course_section_area 
     * @Used IN             : @function-'Self'       this[@controller],
     * @Description         : Remove Video course Section area
     * @Developed By        : Copied from 'super-admin-video'
     * @Start DateTime      : 21-02-2016 02:02 PM    
     * @Status              : available      
     * */
    function remove_video_course_section_area() {
        $all_upload_video_id = $this->input->post('all_upload_video_id', TRUE);
        $all_upload_video_id_array = explode(',', $all_upload_video_id);

        $upload_video_info = $this->user_video_model->get_upload_video_information_by_upload_video_id($all_upload_video_id_array[0]);
        $course_creator_url = $this->user_video_model->get_profile_url($upload_video_info->course_creator_id);
        $section_directory = 'content-library/' . $course_creator_url . '/my-video/' . $upload_video_info->video_folder_name . '/' . $upload_video_info->upload_video_section_name;
        if (is_dir($section_directory)) {
            $this->user_video_model->remove_directory($section_directory);
        }

        for ($i = 0; $i < count($all_upload_video_id_array); $i++) {
            $video_work_file_info = $this->user_video_model->get_work_file_info_by_video_upload_id($all_upload_video_id_array[$i]);
            if ($video_work_file_info) {
                $this->user_video_model->remove_upload_video_course_work_file_by_work_file_id($video_work_file_info->work_files_management_id);
            }
            $this->user_video_model->delete_single_video_course_by_upload_video_id($all_upload_video_id_array[$i]);
        }
        echo 'success';
    }

    /**
     * @Function            : get_video_duration 
     * @Used IN             : @function-'Self'       this[@controller],
     * @Description         : get uploaded video duration
     * @Developed By        : Copied from---------- user_video[@Controller]
     * @Start DateTime      : 16-02-2016 12:14 AM    
     * @Status              : available      
     * */
    function get_video_duration1($video_path) {
        $matches = '';
        $check_path = shell_exec("ffmpeg -i \"{$video_path}\" 2>&1");
        $search = '/Duration: (.*?),/';
        preg_match($search, $check_path, $matches);
        if ($matches[1]) {
            return $matches[1];
        } else {
            return 0;
        }
    }

    /*
      -----------@@@RIPON@ End Video Course Upload Video Part Part----------------------------------
     */

    /*
      Suddam -> Video_order function->for mastering->16-05-2016
     */

    public function video_order() {
        $data = array();
        $data['active_menu'] = $sdata['active_menu'] = 'organization';
        $data['active_sub_menu'] = $sdata['active_sub_menu'] = 'organization_video';
        $data['tab'] = 'course_profile';
        $data['left_side'] = 1;
        $data['left_side_menu_view'] = 1;

        $data['main_content'] = $this->load->view('user/video/video_ordering', $data, true);
        $this->load->view('user/master', $data);
    }

    /*
      -----------@@@RIPON@ Start View Group name and Special user name for Course and Video COurse (09-08-16)----------------------------------
     */

    /**
     * @Function            : get_front_end_group_name 
     * @Used IN             : @function-'user/video/ajax_view/special_user_view.php'
     * @Description         : view group name for Course and Video COurse
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 19-03-2016 11:40 AM
     * @Updated Date Time   : 23-04-2016 01:38 PM   09-08-2016 10:54 AM
     * @Updated By          : MD Jaherul Islam      MD Jaherul Islam
     * @Parameter           : NULL
     * @Return              : NULL    
     * @Status              : Available        
     * */
    function get_front_end_group_name() {
        if ((filter_input(INPUT_SERVER, 'HTTP_X_REQUESTED_WITH')) && (filter_input(INPUT_SERVER, 'HTTP_X_REQUESTED_WITH') == 'XMLHttpRequest')) {
            $data = Array();
            $person_id = $this->session->userdata('user_id');
            $search_input = $this->input->post('search_group_name', TRUE);
            $selected_group_id = $this->input->post('selected_group_id', TRUE);

            $group_data = $this->group_model->group_information($person_id, $selected_group_id, $search_input, $data);
            echo json_encode($group_data);
        } else {
            redirect();
        }
    }

    /**
     * @Function            : front_end_special_user_name 
     * @Used IN             : @function-'user/video/ajax_view/special_user_view.php'
     * @Description         : view group name for Course and Video COurse
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 20-03-2016 08:29 AM  
     * @Updated Date Time   : 23-04-2016 01:38 PM
     * @Updated By          : MD Jaherul Islam
     * @Parameter           : NULL
     * @View                : user/video/ajax_page/special_user_view.php
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available        
     * */
    public function front_end_special_user_name() {
        if ((filter_input(INPUT_SERVER, 'HTTP_X_REQUESTED_WITH')) && (filter_input(INPUT_SERVER, 'HTTP_X_REQUESTED_WITH') == 'XMLHttpRequest')) {
            $data = Array();
            $course_creator_id = $this->input->post('course_creator_id', TRUE);
            $course_creator_info = $this->person_model->get_single_person_info_by_person_id($course_creator_id);
            $resource_person_id = $this->input->post('resource_person_id', TRUE);
            $resource_person_info = $this->resource_person_model->select_person_information_by_resource_person_id($resource_person_id);
            $search_input = $this->input->post('search_input', TRUE);
            $selected_user_id = $this->input->post('selected_person_id', TRUE);

            if ($selected_user_id != '') {
                $data['selected_user_data'] = $this->person_model->get_all_selected_person($selected_user_id, $resource_person_info->person_id);
            } else {
                $data['selected_user_data'] = Array();
            }

            $special_user_data = $this->super_admin_course_model->get_special_user_information($course_creator_info, $search_input, $course_creator_id, $resource_person_info, $selected_user_id, $data);
            echo json_encode($special_user_data);
        }
    }
    
    
         /**
     * @Function            : delete_video_course
     * @Description         : changes video Course status to archieve
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 27-03-2017   
     * @Status              : available     
     * */
    public function delete_video_course(){
        if($this->input->is_ajax_request()){
         $video_url = $this->input->post('video_course_url', TRUE);
         $video_course_info = $this->user_video_model->get_single_video_course_information_by_url($video_url);
         $this->user_video_model->update_video_course_status($video_course_info->video_management_id);
         echo json_encode('ok');
        }        
    }

    /*
      -----------@@@RIPON@ End View Group name and Special user name for Course and Video COurse (09-08-16)----------------------------------
     */
}
