<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class User_Course extends TT_user_login {

    public function __construct() {
        parent::__construct();
        $this->load->helper('security');
        $this->load->library('tt_currency');
    }

    /*
      -----------@@@RIPON@ Start add Course Part----------------------------------
     */

    /**
     * @Function            : add_course
     * @Used IN             : @user/video/course_list.php [13]
     * @Description         : add course information and check all kind of validation
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 07-05-2016 01:38 PM
     * @updated by          : MD Jaherul Islam
     * @updated date        : 24-07-2016 05:36 PM
     * @parameter           : NONE
     * @return              : NONE
     * @view                : user/course/add_course.php, user/master.php
     * @redirect            : redirect('add-course-work-file'), redirect('invite-learners')
     * @Status              : Available       
     * */
    public function add_course() {
        $data = Array();
        $person_id = $this->session->userdata('user_id');
        $person_role = $this->session->userdata('person_role');
        $data['person_info'] = $this->person_model->get_single_person_information_by_person_id($person_id);
        $course_data = $this->user_course_model->get_information_for_course($data);

        if (($person_role != 3) && ($person_role != 4)) {  // if person role Teacher OR Organization
            redirect();
        }

        $this->check_add_course_validation($person_role); // check server side validation

        if ($this->form_validation->run() == FALSE) { // if Course Field does not Exist validation
            $course_data_info = $this->user_course_model->get_course_information($course_data);
            $course_data_info['main_content'] = $this->load->view('user/course/add_course', $course_data_info, TRUE);
            $this->load->view('user/master', $course_data_info);
        } else {
            $course_id = $this->user_course_model->save_course_information($person_id, $course_data);
            $course_info = $this->user_course_model->get_course_information_with_url_by_course_id($course_id);
            if ($course_info->course_work_files == 1) {
                redirect('user/course/add-work-file/' . $course_info->url, 'refresh');
            } else {
                redirect('invite-learners/' . $course_info->url, 'refresh');
            }
        }
    }

    /**
     * @Function            : check_add_course_validation 
     * @Used IN             : @function-'add_course'     this[@controller],
     * @Description         : check add course validation
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 08-05-2016 03:31 PM
     * @Parameter           : $person_role[INTEGER]
     * @View                : None  
     * @Status              : Available       
     * */
    function check_add_course_validation($person_role) {
        $this->form_validation->set_rules('course_name', 'course Name', 'required|trim|max_length[120]');
        $this->form_validation->set_rules('course_url', 'course URL', 'required|trim|callback_course_url_check');

        $this->form_validation->set_rules('course_start_date', 'course start date', 'required|callback_check_date_status');
        $this->form_validation->set_rules('last_date_of_registration', 'last date of registration', 'required|callback_check_date_status|callback_compare_with_end_date');
        $this->form_validation->set_rules('course_finished_date', 'course finished date', 'required|callback_check_date_status|callback_compare_with_start_date');

        $this->course_common_field_validation($person_role);
    }

    /*
      -----------@@@RIPON@ End add Course Part----------------------------------
     */
    /**
     * @Function            : invite_learners 
     * @Description         : Invite Learner to enroll course
     * @Developed By        : Md. Delwar Hossain
     * @Start DateTime      : 05-05-2017 11:31 AM
     * @Parameter           : $course_url
     * @Status              : Available       
     * */
    public function invite_learners($course_url){
        $data = array();
        $data['active_menu'] = $this->session->userdata('active_menu');
        $data['active_sub_menu'] = $this->session->userdata('active_sub_menu');
        $data['tab'] = 'invite_learners';
        $data['left_side_menu_view'] = 1;
        $data['left_side'] = 1;
        
        $this->load->library('form_validation');
        $this->form_validation->set_rules('to_address','email','required');
        $this->form_validation->set_rules('invitation_message','invitation','required');
        
        $data['course_info'] = $this->user_course_model->get_course_creator_info_by_course_url($course_url);
        if (($data['course_info']->person_role != 3) && ($data['course_info']->person_role != 4)) {  // if person role Teacher OR Organization
            redirect();
        }
        $this->form_validation->set_rules('to_address', 'Email', 'required|trim|callback_email_check');
        $this->form_validation->set_rules('invitation_message', 'Invitation Message', 'required|trim');
        if ($this->form_validation->run() == FALSE) { 
            $data['main_content'] = $this->load->view('user/course/invite_learner',$data, true);
            $this->load->view('user/master', $data);
        }
        else{
            $this->invite_learner_by_email($data['course_info']);
            redirect(($data['course_info']->person_role == 4) ? 'course/organization' : 'course/teacher');
            
        }
    }
    /**
     * @Function            : email_check   
     * @Description         : multiple email check 
     * @Developed By        : Kazol
     * @Start DateTime      : Unknown
     * @Parameter           : none
     * @Return              : true, false
     * @Status              : Available        
     * */
    function email_check() {
        $person_email = $this->input->post('to_address', TRUE);
        $sp = '/^([_a-z0-9\-]+)(\.[_a-z0-9\-]+)*@([a-z0-9\-]{2,}\.)*([a-z]{2,4})(,([_a-z0-9\-]+)(\.[_a-z0-9\-]+)*@([a-z0-9\-]{2,}\.)*([a-z]{2,4}))*$/';
        if (preg_match($sp,$person_email)) {           
                return TRUE;            
        } else {
            $this->form_validation->set_message('email_check', get_message("email_invalid"));
            return FALSE;
        }
    }
    
    /**
     * @Function            : invite_learner_by_email 
     * @Used IN             : @function-'invite_learners'
     * @Description         : Invite Learner By Email
     * @Developed By        : Md. Delwar Hossain
     * @Start DateTime      : 06-05-2017 9:31 AM
     * @Parameter           : $course_info
     * @Status              : Available       
     * */
    function invite_learner_by_email($course_info){
        $learner_email = $this->input->post('to_address');
        $invitation_message = $this->input->post('invitation_message');
        $email_array = array_unique(explode(",", rtrim($learner_email, ',')));

        foreach($email_array as $student_email){
            $mdata = array();
            $mdata['course_data'] = $course_info;
            $mdata['from_address'] = 'no-replay@talhatraining.com';
            $mdata['company_name'] = 'Talha Training';
            $mdata['admin_name'] = 'Talha Training';
            $mdata['to_address'] = $student_email;
            $mdata['subject'] = 'Invitation Message for enroll new course';
            $mdata['invitation_message'] = $invitation_message;
            $this->mailer_model->send_email($mdata, 'email_for_invite_learners');

        }       
    }
    
    /**
     * @Function            : skip_invite_learners 
     * @Description         : Skip Invite Learner
     * @Developed By        : Md. Delwar Hossain
     * @Start DateTime      : 06-05-2017 11:31 AM
     * @Parameter           : $course_info
     * @Status              : Available       
     * */
    public function skip_invite_learners($course_url) {
        $data['course_data'] = $this->user_course_model->get_course_creator_info_by_course_url($course_url);
        if($data['course_data'] != ''){
            redirect(($data['course_data']->person_role == 4) ? 'course/organization' : 'course/teacher');
        }
    }

    /*
      -----------@@@RIPON@ Start Edit Course Part(24-07-16)----------------------------------
     */

    /**
     * @Function            : edit course information 
     * @Used IN             : @function-'user/edit_course.php'  
     * @Description         : edit course information  
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 22-03-2016 08:17 AM    
     * @updated by          : MD Jaherul Islam
     * @updated date        : 24-09-2016 05:36 PM 
     * @Parameter           : $course_url[STRING]
     * @Return              : NULL   
     * @Status              : available      
     * */
    public function edit_course($course_url) {
        $data = Array();
        $person_id = $this->session->userdata('user_id');
        $person_role = $this->session->userdata('person_role');
        if (($person_role != 3) && ($person_role != 4)) {
            redirect();
        }
        $data['course_info'] = $this->user_course_model->get_course_information_with_url_by_course_url($course_url);
        if (!$data['course_info']) {
            redirect();
        }
        $data['person_info'] = $this->person_model->get_single_person_info_by_person_id($person_id);
        $course_data = $this->user_course_model->get_information_for_edit_course($data);

        $this->check_edit_course_authentication($person_id, $person_role, $course_data);
        $this->check_edit_course_validation($person_role, $course_data);

        if ($this->form_validation->run() == FALSE) {// if Course Field does not Exist validation
            $course_data['main_content'] = $this->load->view('user/course/edit_course', $course_data, TRUE);
            $this->load->view('user/master', $course_data);
        } else {
            $this->course_info = $this->user_course_model->get_course_information_with_url_by_course_url($course_url);
            $this->user_course_model->update_course_information($course_data);
            switch ($data['course_info']->course_status) {
                case (in_array($data['course_info']->course_status, Array(1, 4))):
                    $sData['course_tab'] = 'submission';
                    break;
                case 3:
                    $sData['course_tab'] = 'submission';
                    break;
                case (in_array($data['course_info']->course_status, Array(5, 6))):
                    $sData['course_tab'] = 'draft';
                    break;
        }       
        $sData['course_id'] = $this->course_info->course_id;
        $this->session->set_userdata($sData);
            redirect(($person_role == 4) ? 'course/organization' : 'course/teacher');
        }
    }

    /**
     * @Function            : check_edit_course_authentication
     * @Used IN             : @function-'edit_course'      this[@controller],
     * @Description         : check edit course authentication  
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 25-03-2016 10:25 AM
     * @Parameter           : $person_id[INTEGER], $person_role[INTEGER],$data[ARRAY]
     * @Return              : NULL   
     * @Status              : available      
     * */
    function check_edit_course_authentication($person_id, $person_role, $data) {
        if ($person_id != $data['course_info']->course_creator_id) {
            if ($person_role == 4) { // if person is Organization
                redirect('course/organization');
            }
            if ($person_role == 3) { // if person is Teacher
                $this->check_resource_auth_for_edit_course($person_id, $data);
            }
        }
    }

    /**
     * @Function            : check_resource_auth_for_edit_course
     * @Used IN             : @function-'check_edit_course_authentication'      this[@controller],
     * @Description         : check resource person authentication for edit course   
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 28-08-2016 12:18 PM
     * @Parameter           : $person_id[INTEGER], $data[ARRAY]
     * @Return              : NULL   
     * @Status              : available      
     * */
    function check_resource_auth_for_edit_course($person_id, $data) {
        if ($data['course_info']->course_resource_person_edit != 1) {
            redirect('course/teacher');
        } else {
            $resource_person_info = $this->resource_person_model->single_resource_person_information_by_person_id($person_id);
            if ($resource_person_info->resource_person_id != $data['course_info']->resource_person_id) {
                redirect('course/teacher');
            }
        }
    }

    /**
     * @Function            : check_edit_course_validation 
     * @Used IN             : @function-'user/edit_course.php'  
     * @Description         : edit course server side validation
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 26-07-2016 11:27 AM    
     * @Parameter           : $person_role[INTEGER], $course_data[ARRAY]
     * @Return              : NULL   
     * @Status              : available      
     * */
    function check_edit_course_validation($person_role, $course_data) {
        $this->form_validation->set_rules('edit_course_name', 'Course Name', 'required|trim|max_length[120]');
        if ($this->input->post('course_url', TRUE) != $course_data['course_info']->url) {
            $this->form_validation->set_rules('course_url', 'Course URL', 'required|trim|callback_course_url_check');
        }

        if ($this->input->post('course_start_date', TRUE) != $course_data['course_info']->course_start_date) {
            $this->form_validation->set_rules('course_start_date', 'Course Start Date', 'required|callback_check_date_status');
        }
        if ($this->input->post('last_date_of_registration', TRUE) != $course_data['course_info']->last_date_of_registration) {
            $this->form_validation->set_rules('last_date_of_registration', 'Last Date of Registration', 'required|callback_check_date_status|callback_compare_with_end_date');
        }
        if ($this->input->post('course_finished_date', TRUE) != $course_data['course_info']->course_finished_date) {
            $this->form_validation->set_rules('course_finished_date', 'Course Finished Date', 'required|callback_check_date_status|callback_compare_with_start_date');
        }

        $this->course_common_field_validation($person_role);
    }

    /*
      -----------@@@RIPON@ End Edit Course Part(24-07-16)----------------------------------
     */






    /*
      -----------@@@RIPON@ Start Course Common @finction Part(14-08-16)----------------------------------
     */

    /**
     * @Function            : course_common_field_validation 
     * @Used IN             : @function-'add_course'      this[@controller],
     * @                    : @function-'edit_course'     this[@controller],
     * @Description         : check Server side validation From add and edit course common field
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 14-08-2016 10:12 AM
     * @Parameter           : $person_role[INTEGER]
     * @View                : None  
     * @Status              : Available       
     * */
    function course_common_field_validation($person_role) {
        $this->form_validation->set_rules('parent_topic_id', 'Parent Topic', 'required');
        $this->form_validation->set_rules('topic_id', 'Topic', 'required');
        $this->form_validation->set_rules('other_topic_name', 'Topic Name', 'trim|callback_topic_name_check');
        $this->form_validation->set_rules('course_level', 'Course Level', 'required');
        $this->form_validation->set_rules('number_of_classes', 'Number of Classes', 'required|trim|integer|numeric|greater_than[0]|less_than[100]');
        $this->form_validation->set_rules('class_hour_per_day', 'Class Hour Per Day', 'required|trim|numeric|greater_than[0]|less_than[600]');
        $this->form_validation->set_rules('class_time', 'Class Time', 'required');
        $this->form_validation->set_rules('course_work_files', 'Course Work Files', 'required');
        $this->form_validation->set_rules('course_training_objectives', 'Course Training Objectives', 'required');
        $this->form_validation->set_rules('course_training_outline', 'Course Training Outline', 'required');
        $this->form_validation->set_rules('course_days[]', 'Course Days', 'required');
        $this->form_validation->set_rules('course_language', 'Course Language', 'required');
        $this->form_validation->set_rules('course_access_level', 'Course Access Level', 'required');
        if ($person_role == 4) {
            $this->form_validation->set_rules('resource_person_id', 'resource person', 'required');
            if ($this->input->post('resource_person_id', TRUE) == 'other') {
                $this->form_validation->set_rules('resource_person_name', 'resource person name', 'required|trim|max_length[150]');
            }
        }

        $this->course_common_more_field_validation($person_role);
    }

    /**
     * @Function            : course_common_more_field_validation 
     * @Used IN             : @function-'add_course'      this[@controller],
     * @                    : @function-'edit_course'     this[@controller],
     * @Description         : check Server side validation From add and edit course common field
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 14-08-2016 10:12 AM
     * @Parameter           : $person_role[INTEGER]
     * @View                : None  
     * @Status              : Available       
     * */
    function course_common_more_field_validation($person_role) {
        $this->form_validation->set_rules('course_type', 'course type', 'required');
        if ($this->input->post('course_type', TRUE) == 1) {
            $this->form_validation->set_rules('course_price_currency', 'price currency', 'required');
            $this->form_validation->set_rules('course_price', 'course price', 'required|trim|numeric|greater_than[0]');
        }

        if ($person_role == 4) {
            $this->form_validation->set_rules('course_resource_person_edit', 'course resource person edit');
            $this->form_validation->set_rules('course_resource_person_view_invoice', 'course resource person view invoice');
            $this->form_validation->set_rules('course_resource_person_pay_invoice', 'course resource person pay invoice');
        }
    }

    /**
     * @Function            : check_course_url_existance 
     * @Used IN             : @function-'check_add_course_validation'     this[@controller] [97]
     * @Description         : check course url existence
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 22-09-2016 06:14 PM      
     * @Status              : available      
     * */
    function check_course_url_existance() {
        if ((filter_input(INPUT_SERVER, 'HTTP_X_REQUESTED_WITH')) && (filter_input(INPUT_SERVER, 'HTTP_X_REQUESTED_WITH') == 'XMLHttpRequest')) {
            $course_url = $this->input->post('course_url', TRUE);
            echo $this->url_model->check_url_existence($course_url);
        } else {
            redirect();
        }
    }

    /**
     * @Function            : make_course_url 
     * @Used IN             : @function-'user/add_course.php'
     * @Description         : Make course URl
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 17-07-2016 12:59 PM 
     * @Parameter           : NULL
     * @Return              : NULL         
     * @Status              : available      
     * */
    function make_course_url() {
        if($this->input->is_ajax_request()){ 
            $course_url = $this->input->post('course_url', TRUE);
            echo $this->url_model->make_existence_url($course_url);
        } else {
            redirect();
        }
    }

    /**
     * @Function            : course_url_check 
     * @Used IN             : @function-'check_add_course_validation'      this[@controller],
     * @                    : @function-'check_edit_course_validation'     this[@controller],
     * @Description         : check URL exists for add course
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 08-05-2016 12:50 PM
     * @Parameter           : $url[STRING]
     * @View                : None  
     * @Status              : Available       
     * */
    function course_url_check($url) {
        $sp = '/^[0-9a-zA-Z\-]+$/';
        if (!preg_match($sp, $url)) {
            $this->form_validation->set_message('course_url_check', "URL Cann't contain any '/[!@#$%&*()^,._;:]/'  if need use '-' Don't use Space");
            return FALSE;
        } else if (strstr($url, ' ')) {
            $this->form_validation->set_message('course_url_check', " Use '-' in place of space");
            return FALSE;
        } else if ($this->url_model->check_url_existence($url) == 1) {
            $this->form_validation->set_message('course_url_check', "This URL Already Exist");
            return FALSE;
        } else {
            return TRUE;
        }
    }

    /**
     * @Function            : topic_name_check 
     * @Used IN             : @function-'check_add_course_validation'      this[@controller],
     * @                    : @function-'check_edit_course_validation'     this[@controller],
     * @Description         : check topic name existence for php validation
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 24-07-2016 09:56 AM
     * @Parameter           : $url[STRING]
     * @View                : None  
     * @Status              : Available       
     * */
    function topic_name_check($topic_name) {
        if ($this->input->post('topic_id', TRUE) == 'other') {
            if ($topic_name == '') {
                $this->form_validation->set_message('topic_name_check', "Topic Name is Required");
                return FALSE;
            } else {
                $parent_topic_id = $this->input->post('parent_topic_id', TRUE);
                $topic_name = preg_replace('/\s+/', ' ', urldecode(strtolower($topic_name)));
                $result = $this->topic_model->check_topic_name(0, $parent_topic_id, $topic_name);
                if ($result) {
                    $this->form_validation->set_message('topic_name_check', "Topic Name Already Exists");
                    return FALSE;
                } else {
                    return TRUE;
                }
            }
        } else {
            return TRUE;
        }
    }

    /**
     * @Function            : view_child_topic 
     * @Used IN             : @function-'view/user/course/add_course.php'
     * @Description         : view child topic
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 23-07-2016 05:30 PM
     * @Parameter           : $topic_id[INTEGER]
     * @Return              : TRUE/FALSE  
     * @Status              : Available       
     * */
    function view_child_topic($topic_id, $person_id) {
        if ($this->input->is_ajax_request()) {
            $topic_info = $this->topic_model->get_all_child_topic_by_parent_topic_id($topic_id, $person_id);
            echo json_encode($topic_info);
        } else {
            redirect();
        }
    }

    /**
     * @Function            : check_topic_name 
     * @Used IN             : @function-'view/user/course/add_course.php'
     * @Description         : check topic name excistence
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 23-07-2016 06:30 PM
     * @Parameter           : Null
     * @Return              : 1/2  
     * @Status              : Available       
     * */
    function check_topic_name() {
        if ($this->input->is_ajax_request()) {
            $parent_topic_id = $this->input->post('parent_topic_id', TRUE);
            $topic_name = preg_replace('/\s+/', ' ', urldecode(strtolower($this->input->post('topic_name', TRUE))));
            $result = $this->topic_model->check_topic_name(0, $parent_topic_id, $topic_name);
            echo $result ? 1 : 2;
        } else {
            redirect();
        }
    }

    /**
     * @Function            : check_date_status 
     * @Used IN             : @function-'check_add_course_validation'     this[@controller]
     * @Description         : check date status
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 08-05-2016 02:46 PM
     * @Parameter           : $date[DATTIME]
     * @Return              : TRUE/FALSE  
     * @Status              : Available       
     * */
    public function check_date_status($date) {
        $today = date('Y-m-d', strtotime(gmdate('Y-m-d')) - $this->session->userdata('time_offset'));
        if ($date >= $today) {
            return TRUE;
        } else {
            $this->form_validation->set_message('check_date_status', "Course start date can not be before today");
            return FALSE;
        }
    }

    /**
     * @Function            : compare_with_start_date 
     * @Used IN             : @function-'check_add_course_validation'     this[@controller],
     * @Description         : compare start date and finish date
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 08-05-2016 02:46 PM
     * @Parameter           : $date[DATTIME]
     * @Return              : TRUE/FALSE  
     * @Status              : Available       
     * */
    public function compare_with_start_date($date) {
        $start_date = $this->input->post('course_start_date', TRUE);
        if ($start_date) {
            if ($start_date <= $date) {
                return TRUE;
            } else {
                $this->form_validation->set_message('compare_with_start_date', "Course End date must bigger than Course Start and End Date");
                return FALSE;
            }
        }
    }

    /**
     * @Function            : compare_with_end_date 
     * @Used IN             : @function-'check_add_course_validation'     this[@controller]
     * @Description         : compare start end and finish date
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 08-05-2016 02:46 PM
     * @Parameter           : $date[DATTIME]
     * @Return              : TRUE/FALSE  
     * @Status              : Available       
     * */
    public function compare_with_end_date($date) {
        $end_date = $this->input->post('course_finished_date', TRUE);
        if ($end_date) {
            if ($end_date >= $date) {
                return TRUE;
            } else {
                $this->form_validation->set_message('compare_with_end_date', "Course Regstration date must smaller than Course End Date");
                return FALSE;
            }
        }
    }

    /*
      -----------@@@RIPON@ End Course Common @finction Part(14-08-16)----------------------------------
     */






    /*
      -----------@@@RIPON@ Start Course view Part (Organization and Teacher)----------------------------------
     */

    /**
     * @Function            : organization_course_list 
     * @Used IN             : @function-'user/course/course_list.php'  [12,19,25]
     * @Description         : View Organization Course List(if any Organization Teacher Create any course that have view as Organization Course)
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 08-05-2016 10:30 AM
     * @Updated Date Time   : 17-05-2016 10:00 AM
     * @Updated By          : MD Jaherul Islam
     * @Parameter           : NULL
     * @View                : user/course/course_list.php,user/master.php
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available       
     * */
    public function organization_course_list() {
        $data = Array();
        $side_menu_data = $this->user_course_model->side_menu_info($data, 'organization', 'organization_course');

        $tab = $this->session->userdata('course_tab');
        if ($tab != '') {
            $side_menu_data['course_tab'] = $tab;
        } else {
            $side_menu_data['course_tab'] = 'draft';
        }
        $side_menu_data['page'] = 1;

        $person_id = $this->session->userdata('user_id');
        $side_menu_data['person_info'] = $this->person_model->get_single_person_information_by_person_id($person_id);
        if (($side_menu_data['person_info']->person_role != 4)) {
            redirect();
        }
        $course_data = $this->user_course_model->get_information_for_course($side_menu_data);
        $all_course_data = $this->user_course_model->get_all_course_value($course_data, 4, 0);
        $all_course_data['main_content'] = $this->load->view('user/course/course_list', $all_course_data, TRUE);
        $this->load->view('user/master', $all_course_data);
    }

    /**
     * @Function            : teacher_course_list 
     * @Used IN             : @function-'user/course/course_list.php'  [12,19,25]
     * @Description         : Teacher Course List
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 08-05-2016 10:30 AM
     * @Updated Date Time   : 17-05-2016 10:43 AM
     * @Updated By          : MD Jaherul Islam
     * @Parameter           : NULL
     * @View                : user/course/course_list.php,user/master.php
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available       
     * */
    public function teacher_course_list() {
        $data = array();
        $person_id = $this->session->userdata('user_id');
        $data['person_info'] = $this->profile_model->get_single_person_information_by_person_id($person_id);
        if (($data['person_info']->person_role != 3)) {
            redirect();
        }

        $side_menu_data = $this->user_course_model->side_menu_info($data, 'teacher', 'teacher_course');
        $course_data = $this->user_course_model->get_information_for_course($side_menu_data);

        $tab = $this->session->userdata('course_tab');
        $course_data['course_tab'] = ($tab != '') ? $tab : 'draft';
        $course_data['page'] = 1;

        $all_course_data = $this->user_course_model->get_all_course_value($course_data, 3, 0);

        $all_course_data['main_content'] = $this->load->view('user/course/course_list', $all_course_data, TRUE);
        $this->load->view('user/master', $all_course_data);
    }

    /**
     * @Function            : course_pagination 
     * @Used IN             : @function-'user/course/course_list.php'
     * @Description         : Course pagination view
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 17-05-2016 04:33 PM
     * @Parameter           : NULL
     * @View                : None
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function course_pagination() {
        $data = Array();
        $person_id = $this->session->userdata('user_id');
        $data['person_info'] = $this->person_model->get_single_person_information_by_person_id($person_id);
        $course_data = $this->user_course_model->get_information_for_course($data);
        $course_data['course_type'] = $this->input->post('course_type', TRUE);
        $course_data['page'] = $this->input->post('page_number', TRUE);
        $limit = $course_data['page'] * 10 - 10;
        if ($course_data['course_type'] == 'draft') {
            $this->view_draft_course_for_ajax_view($course_data, $limit);
        }
        if ($course_data['course_type'] == 'submit') {
            $this->view_submission_course_for_ajax_view($course_data, $limit);
        }
        if ($course_data['course_type'] == 'active') {
            $this->view_active_course_for_ajax_view($course_data, $limit);
        }
    }

    /**
     * @Function            : view_draft_course_for_ajax_view 
     * @Used IN             : @function-'course_pagination'     this[@controller]
     * @Description         : view draft course for pagination
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 17-05-2016 05:04 PM
     * @Parameter           : $course_data[ARRAY], $limit[INTEGER]
     * @View                : user/course/ajax_page/view_course.php
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function view_draft_course_for_ajax_view($course_data, $limit) {
        if ($course_data['resource_person_info']->person_role == 4) {
            $draft_course_data = $this->user_course_model->select_all_draft_courses($course_data, $course_data['person_info']->person_id, 5, $limit, '');
        } else {
            $draft_course_data = $this->user_course_model->select_all_draft_courses($course_data, $course_data['person_info']->person_id, 5, $limit, $course_data['resource_person_info']->resource_person_id);
        }
        echo $this->load->view('user/course/ajax_page/view_course.php', $draft_course_data, TRUE);
    }

    /**
     * @Function            : view_submission_course_for_ajax_view 
     * @Used IN             : @function-'course_pagination'     this[@controller]
     * @Description         : view submission course for pagination
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 17-05-2016 05:11 PM
     * @Parameter           : $course_data[ARRAY], $limit[INTEGER]
     * @View                : user/course/ajax_page/view_course.php
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function view_submission_course_for_ajax_view($course_data, $limit) {
        if ($course_data['resource_person_info']->person_role == 4) {
            $submit_course_data = $this->user_course_model->select_all_submit_courses($course_data, $course_data['person_info']->person_id, 3, $limit, '');
        } else {
            $submit_course_data = $this->user_course_model->select_all_submit_courses($course_data, $course_data['person_info']->person_id, 3, $limit, $course_data['resource_person_info']->resource_person_id);
        }
        echo $this->load->view('user/course/ajax_page/view_course.php', $submit_course_data, TRUE);
    }

    /**
     * @Function            : view_active_course_for_ajax_view 
     * @Used IN             : @function-'course_pagination'     this[@controller]
     * @Description         : view Active OR Apporved course for pagination
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 17-05-2016 05:30 PM
     * @Parameter           : $course_data[ARRAY], $limit[INTEGER]
     * @View                : user/course/ajax_page/view_course.php
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function view_active_course_for_ajax_view($course_data, $limit) {
        $active_course_status = '1,4';
        if ($course_data['resource_person_info']->person_role == 4) {
            $active_course_data = $this->user_course_model->select_all_active_courses($course_data, $course_data['person_info']->person_id, $active_course_status, $limit, '');
        } else {
            $active_course_data = $this->user_course_model->select_all_active_courses($course_data, $course_data['person_info']->person_id, $active_course_status, $limit, $course_data['resource_person_info']->resource_person_id);
        }
        echo $this->load->view('user/course/ajax_page/view_course.php', $active_course_data, TRUE);
    }

    /**
     * @Function            : delete_course 
     * @Used IN             : @function-'delete_course'     this[@controller]
     * @Description         : Delete course in front End
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 22-09-2016 10:37 AM
     * @Parameter           : Null
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function delete_course() {
        if ($this->input->is_ajax_request()) {
            $course_url = $this->input->post('course_url', TRUE);
            $course_info = $this->user_course_model->get_course_information_with_url_by_course_url($course_url);
            $data = Array();
            $data['course_status'] = 2;
            $this->utility_model->update_information_in_database('tbl_course', 'course_id', $course_info->course_id, $data);
            $person_id = $this->session->userdata('person_id');
            $course_data = $this->utility_model->get_single_table_information('*', 'tbl_course', 'course_id', $course_info->course_id);
            $this->notification_course_model->save_course_status_change_notification($course_data, $person_id, 13);
        } else {
            redirect();
        }
    }

    /*
      -----------@@@RIPON@ End Course view Part (Organization and Teacher)----------------------------------
     */



    /*
      -----------@@@RIPON@ Start learner Course list Part (30-08-2016)----------------------------------
     */

    /**
     * @Function            : learner_course_list 
     * @Used IN             : @function-'user/side_menu.php' - [851]
     * @Description         : view all learner course list
     * @                    : @Update1=>change datebase field name
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 04-05-2016 06:34 PM
     * @Updated Date Time   : 30-08-2016 11:44 AM
     * @Updated By          : MD Jaherul Islam
     * @Parameter           : NULL
     * @Return              : NULL    
     * @Status              : Available       
     * */
    public function learner_course_list() {
        $data = Array();
        $side_menu_data = $this->user_course_model->side_menu_info($data, 'learner', 'learner_course');

        if ($this->session->userdata('learner_tab_session')) {
            $side_menu_data['learner_tab'] = $this->session->userdata('learner_tab_session');
            $sess_course_id = $this->session->userdata('sess_course_id');
        } else {
            $side_menu_data['learner_tab'] = 'free';
            $sess_course_id = '';
        }

        $person_id = $this->session->userdata('user_id');
        $this->utility_model->remove_session_data('learner_tab_session', 'sess_course_id');

        if ($sess_course_id) {
            $side_menu_data['sess_course_info'] = $this->user_course_model->get_single_learner_course($person_id, $sess_course_id);
            if ($side_menu_data['sess_course_info']->course_type == 1) {
                $side_menu_data['sess_price_info'] = $this->price_model->get_single_price_information(1, $side_menu_data['sess_course_info']->course_id);
            }
        } else {
            $side_menu_data['sess_course_info'] = Array();
        }

        if ($side_menu_data['learner_tab'] == 'free') {
            $course_data = $this->user_course_model->get_learner_free_course_value($side_menu_data, $person_id, $sess_course_id, 1);
            $course_data['register_courses'] = '';
            $course_data['total_register_courses'] = $this->user_course_model->select_learner_total_register_course_list(1, $person_id);
        
            $course_data['paid_courses'] = '';
            $course_data['total_paid_courses'] = $this->user_course_model->select_learner_total_paid_course_list(1, $person_id);
        
        }
        if ($side_menu_data['learner_tab'] == 'paid') {
            $course_data = $this->user_course_model->get_learner_paid_course_value($side_menu_data, $person_id, $sess_course_id, 1);
            $course_data['register_courses'] = '';
            $course_data['total_register_courses'] = $this->user_course_model->select_learner_total_register_course_list(1, $person_id);
        
            $course_data['free_courses'] = '';
            $course_data['total_free_courses'] = $this->user_course_model->select_learner_total_course_list(2, $person_id);
           
        }

        if ($side_menu_data['learner_tab'] == 'registration') {
            $course_data = $this->user_course_model->get_register_course_value($side_menu_data, $person_id, $sess_course_id, 1);
            $course_data['free_courses'] = '';
            $course_data['total_free_courses'] = $this->user_course_model->select_learner_total_course_list(2, $person_id);
            
            $course_data['paid_courses'] = '';
            $course_data['total_paid_courses'] = $this->user_course_model->select_learner_total_paid_course_list(1, $person_id);
        
        }

        $course_data['main_content'] = $this->load->view('user/course/learner_course_list', $course_data, TRUE);
        $this->load->view('user/master', $course_data);
    }

    /**
     * @Function            : view_learner_course 
     * @Description         : view learner course using select tab, pagination
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 31-08-2016 11:39 AM
     * @Parameter           : Null
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function view_learner_course() {
        if ($this->input->is_ajax_request()) {
            $course_info = json_decode(file_get_contents("php://input"));
            $data = Array();
            $person_id = $this->session->userdata('person_id');
            $data['course_type'] = $course_info->course_type;
            $course_id = $this->session->userdata('sess_course_id');

            switch ($course_info->course_type) {
                case 'free':
                    $course_data = $this->user_course_model->get_learner_free_course_value($data, $person_id, $course_id, $course_info->page_number);
                    break;
                case 'paid':
                    $course_data = $this->user_course_model->get_learner_paid_course_value($data, $person_id, $course_id, $course_info->page_number);
                    break;
                case 'registration':
                    $course_data = $this->user_course_model->get_register_course_value($data, $person_id, $course_id, $course_info->page_number);
                    break;
            }
            echo $this->load->view('user/course/ajax_page/view_learner_course', $course_data, TRUE);
        } else {
            redirect();
        }
    }

    /**
     * @Function            : cancel_learner_course_registration 
     * @Used IN             : @function-'user/course/learner_course_list.php' - [111]
     * @Description         : Cancel learner cource register
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 02-10-2016 04:01 PM
     * @Parameter           : $course_url[STRING]
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function cancel_learner_course_registration($roll_number, $type) {
        if ($this->input->is_ajax_request()) {
            $person_id = $this->session->userdata('person_id');
            $course_id = $this->utility_model->get_single_table_information('student_type_id', 'tbl_student', 'student_roll_number', $roll_number)->student_type_id;
            $notification_info = $this->notification_model->get_single_notification_info(8, $course_id, $person_id);

            if ($notification_info) {
                $this->utility_model->delete_multiple_field_in_table('tbl_notification', 'notification_id', $notification_info->notification_id);
                $this->utility_model->delete_multiple_field_in_table('tbl_notification_type_info', 'notification_id', $notification_info->notification_id);
            }
            
            $this->utility_model->delete_registered_course_information_in_database($roll_number);
            
            $this->utility_model->delete_information_in_database('tbl_student', 'student_roll_number', $roll_number);
            
            $data['learner_tab_session'] = $type;
            $this->session->set_userdata($data);
        } else {
            redirect();
        }
    }

    /*
      -----------@@@RIPON@ End learner Course list Part (30-08-2016)----------------------------------
     */


    /*
      -----------@@@RIPON@ Start Course learner list  Part (30-08-2016)----------------------------------
     */

    /**
     * @Function            : registered_student_list  
     * @Description         : view register student list in single course
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 13-06-2016 12:09 PM
     * @Updated Date Time   : 01-08-2016 02:43 PM
     * @Updated By          : MD Jaherul Islam  
     * @Parameter           : $course_url[STRING]
     * @Return              : NULL    
     * @Status              : Available        
     * */
    public function registered_student_list($course_url) {
        $data = array();
        $person_id = $this->session->userdata('user_id');
        $this->utility_model->remove_session_data('sess_start_date', 'sess_end_date');
        $side_menu_data = $this->user_course_model->side_menu_info($data, '', '');

        $side_menu_data['person_info'] = $this->person_model->get_single_person_info_by_person_id($person_id);
        $side_menu_data['resource_person_info'] = $this->resource_person_model->single_resource_person_information_by_person_id($person_id);
        $side_menu_data['course_info'] = $this->user_course_model->get_course_information_with_url_by_course_url($course_url);
        $side_menu_data['course_creator_info'] = $this->person_model->get_single_person_info_by_person_id($side_menu_data['course_info']->course_creator_id);

        $this->registered_student_list_validation($side_menu_data);

        $date = Array();
        $course_data = $this->user_course_model->get_all_course_register_student($side_menu_data, $date, 1);
        //add by tania akter 23-06-2016
        $course_data['batch'] = $this->get_batch_info($side_menu_data['course_info']->course_id);
        foreach ($course_data['course_register_student'] as $register_student) {
            $course_data['total_checked_boxes'][$register_student->student_id] = $this->batch_model->get_total_checked($register_student->student_id);
        }
        
        $course_data['random_number'] = $this->user_course_model->get_invoice_random_number_payment_status_by_person_id(1, $course_data['course_info']->course_id);
        //end 
        $course_data['main_content'] = $this->load->view('user/course/course_registered_student', $course_data, true);
        $this->load->view('user/master', $course_data);
    }

    /**
     * @Function            : registered_student_list_validation 
     * @Used IN             : @function-'registered_student_list'   this[@controller]
     * @Description         : validate register student list
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 13-06-2016 12:09 PM  
     * @Parameter           : $data[ARRAY]
     * @View                : None
     * @Redirect            : course/organization, course/teacher
     * @Return              : NULL    
     * @Status              : Available        
     * */
    function registered_student_list_validation($data) {
        if ($data['course_info']->course_creator_id != $data['person_info']->person_id && $data['course_info']->resource_person_id != $data['resource_person_info']->resource_person_id) {
            if ($data['person_info']->person_role == 3) {
                redirect('course/teacher');
            }

            if ($data['person_info']->person_role == 4) {
                redirect('course/organization');
            }
        }
    }

    /**
     * @Function            : view_register_course_student 
     * @Description         : view course register student by dateWise
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 18-09-2016 04:56 PM  
     * @Parameter           : $data[ARRAY]
     * @Return              : NULL    
     * @Status              : Available        
     * */
    function view_register_course_student() {
        if ($this->input->is_ajax_request()) {
            $date_data = Array();
            $date_data['sess_start_date'] = $this->input->post('start_date', TRUE);
            $date_data['sess_end_date'] = $this->input->post('end_date', TRUE);
            $this->session->set_userdata($date_data);

            $course_id = $this->input->post('course_id', TRUE);
            $data['course_info'] = $this->user_course_model->get_course_information_with_url_by_course_id($course_id);
            $data['course_creator_info'] = $this->person_model->get_single_person_info_by_person_id($data['course_info']->person_id);
            $page_number = 1;
            $course_data = $this->user_course_model->get_all_course_register_student($data, $date_data, $page_number);

            foreach ($course_data['course_register_student'] as $register_student) {
                $course_data['total_checked_boxes'][$register_student->student_id] = $this->batch_model->get_total_checked($register_student->student_id);
            }
            $course_data['random_number'] = $this->user_course_model->get_invoice_random_number_payment_status_by_person_id(1, $course_data['course_info']->course_id);
            echo $this->load->view('user/course/ajax_page/view_course_register_student', $course_data, TRUE);
        } else {
            redirect();
        }
    }

    /**
     * @Function            : register_course_student_pagination 
     * @Description         : resiter course pagination
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 01-09-2016 04:20 PM  
     * @Parameter           : Null
     * @Return              : NULL    
     * @Status              : Available        
     * */
    function register_course_student_pagination() {
        if ($this->input->is_ajax_request()) {
            $data = $date_data = Array();
            $course_id = $this->input->post('course_id', TRUE);
            $data['course_info'] = $this->user_course_model->get_course_information_with_url_by_course_id($course_id);
            $data['course_creator_info'] = $this->person_model->get_single_person_info_by_person_id($data['course_info']->person_id);
            $page_number = $this->input->post('page_number', TRUE);

            if ($this->session->userdata('sess_start_date') != '') {
                $date_data['sess_start_date'] = $this->session->userdata('sess_start_date');
                $date_data['sess_end_date'] = $this->session->userdata('sess_end_date');
            }
            $course_data = $this->user_course_model->get_all_course_register_student($data, $date_data, $page_number);

            foreach ($course_data['course_register_student'] as $register_student) {
                $course_data['total_checked_boxes'][$register_student->student_id] = $this->batch_model->get_total_checked($register_student->student_id);
            }
            echo $this->load->view('user/course/ajax_page/view_course_register_student', $course_data, TRUE);
        } else {
            redirect();
        }
    }

    /**
     * @Function            : remove_registered_student 
     * @Description         : remove register student
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 18-09-2016 01:07 PM  
     * @Parameter           : Null
     * @Return              : NULL    
     * @Status              : Available        
     * */
    function remove_registered_student() {
        if ($this->input->is_ajax_request()) {
            $roll_number = $this->input->post('student_roll_number', TRUE);
            $student_info = $this->utility_model->get_single_table_information('*', 'tbl_student', 'student_roll_number', $roll_number);
            if ($student_info->student_type == 1) {
                $notification_info = $this->notification_model->get_single_notification_info(8, $student_info->student_type_id, $student_info->person_id);
                $this->utility_model->delete_information_in_database('tbl_notification', 'notification_id', $notification_info->notification_id);
                $this->utility_model->delete_information_in_database('tbl_notification_type_info', 'notification_id', $notification_info->notification_id);
            }

            $this->utility_model->delete_information_in_database('tbl_student', 'student_roll_number', $roll_number);
        } else {
            redirect('admin/manage-course');
        }
    }

    /*
      -----------@@@RIPON@ End Course learner list  Part (30-08-2016)----------------------------------
     */



    /*
      -----------@@@RIPON@ Start add Course Work file Part----------------------------------
     */

    /**
     * @Function            : add_course_work_file 
     * @Description         : add Course Work file
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 22-10-2016 10:20 AM  
     * @Parameter           : $course_url[STRING]
     * @Return              : NULL    
     * @Status              : Available        
     * */
    function add_course_work_file($course_url) {
        $data = $session_data = Array();
        $person_id = $this->session->person_id;
        $person_role = $this->session->person_role;
        $side_menu_data = $this->user_course_model->side_menu_info($data, '', '');
        $side_menu_data['course_info'] = $this->user_course_model->get_course_information_with_url_by_course_url($course_url);

        $session_data['work_file_course_id'] = $side_menu_data['course_info']->course_id;
        $this->check_course_work_file_authentication($person_id, $person_role, $side_menu_data['course_info']);

        $condition = ['work_file_type' => 1, 'work_file_type_id' => $side_menu_data['course_info']->course_id];
        $side_menu_data['work_file_info'] = $this->utility_model->get_all_table_data('*', 'tbl_work_files', $condition);
        if ($side_menu_data['work_file_info']) {// a course have several work file
            $this->work_file_model->set_edit_work_file_data($side_menu_data['work_file_info'], $session_data);

            // Update Course Work file Status
            $this->work_file_model->set_course_id($this->session->work_file_course_id)->set_type(1)->set_status(1)->update_status();
            // get folder name in work file
            $condition = ['work_file_folder_id' => $side_menu_data['work_file_info'][0]->work_file_folder_id];
            $side_menu_data['folder_name'] = $this->utility_model->get_table_information('work_file_folder_name', 'tbl_work_file_folder', $condition)->work_file_folder_name;
            $side_menu_data['main_content'] = $this->load->view('user/course/edit_course_work_file', $side_menu_data, TRUE);
        } else {
            $session_data['sess_work_file'] = Array('counter' => [1], 'work_file_random_id' => []);
            set_session($session_data);
            $side_menu_data['main_content'] = $this->load->view('user/course/add_course_work_file', $side_menu_data, TRUE);
        }
        $this->load->view('user/master', $side_menu_data);
    }

    /**
     * @Function            : save_course_work_file 
     * @Description         : save Course Work file
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 01-11-2016 05:04 PM  
     * @Parameter           : $course_url[STRING]
     * @Return              : NULL    
     * @Status              : Available        
     * */
    function save_course_work_file($course_url) {
        $data = $session_data = [];
        $data['course_info'] = $this->user_course_model->get_course_information_with_url_by_course_url($course_url);

        if (!$data['course_info']) {
            redirect();
        }

        $this->form_validation->set_rules('work_file_folder_name', 'Course work folder name', 'required|trim|callback_check_folder_name');
        $all_counter = count($this->session->sess_work_file['counter']);
        $id = count($this->session->sess_work_file['work_file_random_id']);
//        echo '<pre>';
//        print_r('all_counter : '. $all_counter);
//        echo '<br>';
//        print_r('id : '. $id);
//        exit();
        if ($this->form_validation->run() == FALSE || ($all_counter != $id) || $all_counter == 0) {
            $sdata['folder_name_error_msg'] = form_error('work_file_folder_name');
            $sdata['work_file_error_msg'] = 'There are some problem please try again later';
            set_session($sdata);
            redirect('user/course/add-work-file/' . $course_url);
        } else {
            $this->work_file_model->set_work_file_post_data()
                    ->update_folder_name()->update_work_file();

            $this->session->unset_userdata('work_file_course_id');
            $this->session->unset_userdata('sess_work_file');
            redirect(($this->session->person_role == 4) ? 'course/organization' : 'course/teacher');
        }
    }

    /**
     * @Function            : check_folder_name 
     * @Description         : check folder name validation
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 07-11-2016 02:48 PM  
     * @Parameter           : $folder_name[STRING]
     * @Return              : NULL    
     * @Status              : Available        
     * */
    function check_folder_name($folder_name) {
        if ($this->security->xss_clean($folder_name, TRUE) == FALSE) {
            $this->form_validation->set_message('check_folder_name', "Invalid input");
            return FALSE;
        } else {
            $folder_name_array = $this->work_file_model->get_work_file_folder_name();
            if (in_array($folder_name, $folder_name_array)) {
                $this->form_validation->set_message('check_folder_name', "Folder name already exists");
                return FALSE;
            } else {
                return TRUE;
            }
        }
    }

    /**
     * @Function            : get_work_file_info 
     * @Description         : get work file data
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 03-11-2016 05:02 PM  
     * @Parameter           : Null
     * @Return              : NULL    
     * @Status              : Available        
     * */
    function get_work_file_info() {
        if ($this->input->is_ajax_request()) {
            $course_id = $this->session->work_file_course_id;
            $data['work_fle_id'] = $data['work_file_name'] = $work_file_id = [];
            // get work file folder INfo
            $data['work_folder_info'] = $this->work_file_model->get_work_file_folder_name();
            $condition = ['work_file_type' => 1, 'work_file_type_id' => $course_id];
            $work_file_info = $this->utility_model->get_all_table_data('work_file_id,work_file_name', 'tbl_work_files', $condition);
            if ($work_file_info) {
                foreach ($work_file_info as $value) {
                    $work_file_id[] = $value->work_file_id;
                    $data['work_file_name'][] = pathinfo($value->work_file_name, PATHINFO_FILENAME);
                }
                $work_random_file_info = $this->random_number_model->set_type_id_array('random_number', 3, $work_file_id)->get_random_number_by_type_id();
                foreach ($work_random_file_info as $value1) {
                    $data['work_fle_id'][] = $this->tt_random_number->set_random_number($value1->random_number)->filter_number('45')->get_filter_number();
                }
            }
            echo json_encode($data);
        } else {
            redirect();
        }
    }

    /**
     * @Function            : check_course_work_file_authentication 
     * @Description         : check course work file authentication
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 22-10-2016 10:20 AM  
     * @Parameter           : $person_id[INTEGER], $person_role[INTEGER], $course_info[data]
     * @Return              : NULL    
     * @Status              : Available        
     * */
    function check_course_work_file_authentication($person_id, $person_role, $course_info) {
        if (!in_array($person_role, Array(3, 4))) {
            redirect();
        }

        $resource_person_id = $this->utility_model->get_single_table_information('resource_person_id', 'tbl_resource_person', 'person_id', $person_id)->resource_person_id;
        if ($person_id != $course_info->course_creator_id && $resource_person_id != $course_info->resource_person_id) {
            redirect(($person_role == 4) ? 'course/organization' : 'course/teacher');
        }
    }

    /**
     * @Function            : get_more_work_file_view 
     * @Description         : view new course work file
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 22-10-2016 11:30 AM  
     * @Parameter           : NULL
     * @Return              : NULL    
     * @Status              : Available        
     * */
    function get_more_work_file_view() {
        if ($this->input->is_ajax_request()) {
            $data = $resposse_data = Array();
            $counter = $this->input->post('counter', TRUE);
            $total_div = $this->input->post('total_div', TRUE);
            $total_work_file = $this->work_file_model->get_total_work_file(1, $this->session->work_file_course_id);
            if ($total_div == $total_work_file) {
                $session_data['sess_work_file'] = $this->session->sess_work_file;
                $data['course_type'] = $this->utility_model->get_single_table_information('course_type', 'tbl_course', 'course_id', $this->session->work_file_course_id)->course_type;
                $data['counter'] = $resposse_data['counter'] = $session_data['sess_work_file']['counter'][] = ++$counter;
                set_session($session_data);
                $resposse_data['view_page'] = $this->load->view('user/course/ajax_page/course_single_work_file_view', $data, TRUE);
            } else {
                $resposse_data['error'] = 'error';
            }
            echo json_encode($resposse_data);
        } else {
            redirect();
        }
    }

    /**
     * @Function            : upload_course_work_file 
     * @Description         : upload Course Work file
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : (22-10-2016 06:00 PM - )
     * @Parameter           : Null
     * @Return              : NULL    
     * @Status              : Available        
     * */
    function upload_course_work_file() {
        if ($this->input->is_ajax_request()) {
            $rsponse_data = [];
            // assign data for course work file, set file index and check file validation
            $this->tt_files->assign_data(1)->set_file('work_file_data')->check_validation();

            if ($this->tt_files->error_message() == '') {
                // return random number which used for create folder to upload work file
                $this->work_file_model->save_folder_information()
                        ->set_work_file_data() // set file related information and make work file directory(if not) and upload file
                        ->make_work_file_upload_dir(); // make upload directory
                // set upload directory in tt_file library
                $this->tt_files->set_upload_dir($this->work_file_model->get_upload_dir());
                $random_number = (empty($this->work_file_model->check_work_file_id())) ?
                        $this->tt_random_number->get_random_number() :
                        $this->tt_random_number->set_random_number($this->work_file_model->check_work_file_id())
                                ->filter_number('TT')->get_filter_number(); // get random number
                //set random file name into tt files and upload file 
                $this->tt_files->set_file_random_number($random_number)->upload_file();
                // save uploaded work file into Database
                $this->save_upload_course_work_file();
            } else {
                $rsponse_data['error_msg'] = $this->tt_files->error_message();
                echo json_encode($rsponse_data);
            }
        } else {
            redirect();
        }
    }

    /**
     * @Function            : process_upload_course_work_file 
     * @Description         : process upload course work file
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 23-10-2016 06:00 PM
     * @Parameter           : Null
     * @Return              : NULL    
     * @Status              : Available        
     * */
    function save_upload_course_work_file() {
        $rsponse_data = [];
        if ($this->tt_files->error_message() == '') { // if return any error while uploding work file
            if (empty($this->work_file_model->check_work_file_id())) { // any work file does not uploaded
                $work_file_id = $this->utility_model
                        ->save_information_in_database('tbl_work_files', $this->work_file_model->get_work_file_data());

                $session_data['sess_work_file'] = $this->session->sess_work_file; // get session data into array
                $rsponse_data['work_fle_random_id'] = $session_data['sess_work_file']['work_file_random_id'][] = $this->tt_random_number
                                ->filter_number('45')->get_filter_number();
                $rsponse_data['work_file_name'] = $this->work_file_model->get_file_name();
                set_session($session_data);
                // save random number for course work file (type=>3 [1st parameter])
                $random_number = $this->tt_random_number->get_rand_number();
                $this->random_number_model->save_random_number(3, $work_file_id, $random_number);
            } else {
                $this->work_file_model->update_work_file_data();
            }
            // get work file data for save into database
            $rsponse_data['work_file_name'] = $this->work_file_model->get_file_name();
            $rsponse_data['file_size'] = $this->work_file_model->get_work_file_size();
        } else {
            $rsponse_data['error_msg'] = $this->tt_files->error_message();
        }
        echo json_encode($rsponse_data);
    }

    /**
     * @Function            : delete_work_file 
     * @Description         : delete single course work file
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 27-10-2016 12:56 PM
     * @Parameter           : Null
     * @Return              : NULL    
     * @Status              : Available        
     * */
    function delete_work_file() {
        if ($this->input->is_ajax_request()) {
            $counter = $this->input->post('counter', TRUE);
            $sess_work_file = $this->session->sess_work_file;
            if (in_array($counter, $sess_work_file['counter'])) {
                $session_data['sess_work_file'] = $this->work_file_model->remove_course_work_file($counter, $sess_work_file);
                set_session($session_data);
            }
        } else {
            redirect();
        }
    }

    /**
     * @Function            : skip_work_file 
     * @Description         : skip course work file 
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 07-11-2016 03:52 PM
     * @Parameter           : Null
     * @Return              : NULL    
     * @Status              : Available        
     * */
    function skip_work_file() {
        if ($this->input->is_ajax_request()) {
            $this->work_file_model->set_course_id($this->session->work_file_course_id)->set_type(1)->set_status(1)->update_status();
            $course_info = $this->user_course_model->get_course_information_with_url_by_course_id($this->session->work_file_course_id);
            $this->session->unset_userdata('work_file_course_id');
            $this->session->unset_userdata('sess_work_file');
            $data['redirect_url'] = 'invite-learners/' . $course_info->url;
            echo json_encode($data);
        } else {
            redirect();
        }
    }

    /**
     * @Function            : view_work_file 
     * @Description         : view course work file 
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 07-11-2016 05:52 PM
     * @Parameter           : $course_url
     * @Return              : NULL    
     * @Status              : Available        
     * */
    function view_work_file($course_url) {
        $data = $session_data = Array();
        $side_menu_data = $this->user_course_model->side_menu_info($data, '', '');
        $side_menu_data['course_info'] = $this->user_course_model->get_course_information_with_url_by_course_url($course_url);

        $condition = ['work_file_type' => 1, 'work_file_type_id' => $side_menu_data['course_info']->course_id];
        $side_menu_data['work_file_info'] = $this->work_file_model->get_order_work_file_data('*', $condition);

        foreach ($side_menu_data['work_file_info'] as $file_value) {
            $condition1 = ['work_file_folder_id' => $file_value->work_file_folder_id];
            $side_menu_data['folder_name'][$file_value->work_file_id] = $this->utility_model
                            ->get_table_information('work_file_folder_name', 'tbl_work_file_folder', $condition1)->work_file_folder_name;

            $condition2 = ['random_type' => 3, 'random_type_id' => $file_value->work_file_id];
            $side_menu_data['random_number'][$file_value->work_file_id] = $this->tt_random_number
                            ->set_random_number($this->utility_model
                                    ->get_table_information('random_number', 'tbl_random', $condition2)->random_number)
                            ->filter_number('31')->get_filter_number();
        }

        $side_menu_data['main_content'] = $this->load->view('user/course/view_work_file', $side_menu_data, TRUE);
        $this->load->view('user/master', $side_menu_data);
    }

    /**
     * @Function            : get_work_file 
     * @Description         : get course work file 
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 08-11-2016 11:52 AM
     * @Parameter           : $random_number
     * @Return              : NULL    
     * @Status              : Available        
     * */
    function get_work_file($random_number) {
        if ($this->input->is_ajax_request()) {
            $work_file = ['id' => [], 'file_name' => []];
// filter random number
            $filter_random_number = $this->tt_random_number->set_random_number($random_number)->filter_number('TT')->get_filter_number();
            // get work file ID
            $work_file_id = $this->random_number_model->set_value(3, '', $filter_random_number)->get_type_id();
            // get Course ID
            $condition1 = ['work_file_id' => $work_file_id];
            $course_id = $this->utility_model->get_table_information('work_file_type_id', 'tbl_work_files', $condition1)->work_file_type_id;
            // get work file infomation except select workfile ID
            $work_file_info = $this->work_file_model->get_work_file_info_by_type_id('work_file_name,random_number', 1, $course_id, $work_file_id);

            foreach ($work_file_info as $value) {
                $work_file['id'][] = $this->tt_random_number->set_random_number($value->random_number)->filter_number('31')->get_filter_number();
                $work_file['file_name'][] = pathinfo($value->work_file_name, PATHINFO_FILENAME);
            }

            echo json_encode($work_file);
        } else {
            redirect();
        }
    }

    /**
     * @Function            : update_file_order 
     * @Description         : Update file Order
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 08-11-2016 02:17 PM
     * @Parameter           : Null
     * @Return              : NULL    
     * @Status              : Available        
     * */
    function update_file_order($course_url) {
        $this->form_validation->set_rules('random_number', 'Random Number', 'callback_check_random_number');
        $this->form_validation->set_rules('file_order', 'File Order', 'required');
        if ($this->input->post('file_order', TRUE) == 2) {
            $this->form_validation->set_rules('selected_file', 'File Name', 'required');
        }
        if ($this->form_validation->run() == FALSE) {
            $data['error_message'] = 'Unable to order file';
            set_session($data);
            redirect('user/course/view-work-file/' . $course_url);
        } else {
            $this->work_file_model->update_work_file_order($course_url);
            redirect('user/course/view-work-file/' . $course_url);
        }
    }

    /**
     * @Function            : check_random_number 
     * @Description         : check random number
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 08-11-2016 02:34 PM
     * @Parameter           : Null
     * @Return              : NULL    
     * @Status              : Available        
     * */
    function check_random_number($random_number) {
        $filter_random_number = $this->tt_random_number->set_random_number($random_number)->filter_number('TT')->get_filter_number();
        $work_file_id = $this->random_number_model->set_value(3, '', $filter_random_number)->get_type_id();

        if (!$work_file_id) {
            $this->form_validation->set_message('check_random_number', "Invalid Access");
            return FALSE;
        }
    }

    /**
     * @Function            : delete_work_file_in_view 
     * @Description         : delete work file in view
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 10-11-2016 10:04 AM
     * @Parameter           : Null
     * @Return              : NULL    
     * @Status              : Available        
     * */
    function delete_work_file_in_view() {
        if ($this->input->is_ajax_request()) {
            $random_number = $this->input->post('id', TRUE);
            // filter random number
            $filter_random_number = $this->tt_random_number->set_random_number($random_number)->filter_number('TT')->get_filter_number();
            // get work file ID
            $work_file_id = $this->random_number_model->set_value(3, '', $filter_random_number)->get_type_id();
            // get course ID by work file ID
            $course_id = $this->utility_model->get_single_table_information('work_file_type_id', 'tbl_work_files', 'work_file_id', $work_file_id)->work_file_type_id;
            // delete course work file
            $this->work_file_model->delete_course_work_file($work_file_id);
            // Reset work file order 
            $this->work_file_model->reset_order($course_id);
        } else {
            redirect();
        }
    }

    /*
      -----------@@@RIPON@ End add Course Work file Part----------------------------------
     */



    /*
      -----------@@@RIPON@ Start add Course  Part----------------------------------
     */

    /**
     * @Function            : review_and_publish 
     * @Used IN             : @function-'review_and_publish.php'  
     * @Description         : course review and published 
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 22-03-2016 04:28 AM      
     * @Status              : available      
     * */
    public function review_and_publish($course_url) {
        $data['active_menu'] = $this->session->userdata('active_menu');
        $data['active_sub_menu'] = $this->session->userdata('active_sub_menu');
        $data['tab'] = 'review_and_publish';
        $data['left_side_menu_view'] = 1;
        $data['left_side'] = 1;

        $data['course_info'] = $this->user_course_model->select_course_information_by_course_url($course_url);
        if (!$data['course_info']) {
            redirect();
        }

        $data['main_content'] = $this->load->view('user/course/review_and_publish', $data, true);
        $this->load->view('user/master', $data);
    }

    /**
     * @Function            : save_as_draft 
     * @Used IN             : @function-'review_and_publish.php'  
     * @Description         : course save as draft
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 22-03-2016 04:37 PM      
     * @Status              : available      
     * */
    public function save_as_draft($course_url) {
        if ($course_url) {
            $data['course_info'] = $this->user_course_model->select_course_information_by_course_url($course_url);
            $cData['course_status'] = 5;
            $this->user_course_model->update_information_in_database('tbl_course', 'course_id', $data['course_info']->course_id, $cData);
            redirect('course/' . $this->session->userdata('active_menu'));
        } else {
            redirect('course');
        }
    }

    /**
     * @Function            : submit_course 
     * @Used IN             : @function-'review_and_publish.php'  
     * @Description         : course save as draft
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 22-03-2016 04:37 PM      
     * @Status              : available      
     * */
    public function submit_course($course_url) {
        if ($course_url) {
            $data['course_info'] = $this->user_course_model->select_course_information_by_course_url($course_url);
            $cData['course_status'] = 3;
            $this->user_course_model->update_information_in_database('tbl_course', 'course_id', $data['course_info']->course_id, $cData);
            redirect('course/' . $this->session->userdata('active_menu'));
        } else {
            redirect('course');
        }
    }

    /*
      -----------@@@RIPON@ End add Course Work file Part----------------------------------
     */

    /*
      -----------@@@RIPON@ Start Course Work file Part----------------------------------
     */

    /**
     * @Function            : redirect_invite_learners
     * @Used IN             : @function-'Self'    
     * @Description         : redirect to invite_learners 
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 07-03-2016 05:52 PM     
     * @Status              : available      
     * */
    function redirect_invite_learners($course_id) {
        $course_info = $this->user_course_model->select_course_information_by_course_id($course_id);
        redirect('invite-learners/' . $course_info->url);
    }

    public function delete_student_id() {
        $student_id = $this->input->post('student_id', TRUE);
        $this->user_course_model->delete_student_id_for_course($student_id);
    }

    /*
      -----------@@@RIPON@ Start Course Work file Part----------------------------------
     */
    /* ------------------------ start unassigned student ------------------------- */

    // 19-09-2016 tania akter
    function unassigned_student_list($course_url) {
        $data = array();
        $person_id = $this->session->userdata('user_id');
        $data_info = $this->user_course_model->side_menu_info($data, '', '');
        $data_info['person_info'] = $this->person_model->get_single_person_info_by_person_id($person_id);
        $data_info['resource_person_info'] = $this->resource_person_model->single_resource_person_information_by_person_id($person_id);
        $data_info['course_info'] = $this->user_course_model->get_course_information_with_url_by_course_url($course_url);
        $data_info['course_creator_info'] = $this->person_model->get_single_person_info_by_person_id($data_info['course_info']->course_creator_id);
        $this->registered_student_list_validation($data_info);
        $date = Array();
        $data_info['unasigned_student'] = $unasigned_student = $this->get_unassigned_student_array($data_info['course_info']->course_id);
        $data_info['count_student'] = $total_count = count($unasigned_student);
        $page_number = 1;
        $data_info1 = $this->batch_model->get_unassigned_students($data_info, $date, $page_number, $total_count);

        $data_info1['course_url'] = $course_url;
        $data_info1['person_info'] = $this->person_model->get_single_person_information_by_person_id($person_id);
        $data_info1['batch'] = $this->get_batch_info($data_info['course_info']->course_id);
        $data_info1['main_content'] = $this->load->view('user/batch/course_unassigned_student', $data_info1, true);
        $this->load->view('user/master', $data_info1);
    }

    function get_unassigned_student_array($course_id) {
        $assigned_student = $this->batch_model->get_assigned_student($course_id);
        $assigned_student_array = array_unique(explode(',', $assigned_student));
        $register_student = $this->batch_model->get_register_student($course_id);
        $register_student_array = array_unique(explode(',', $register_student));
        $unasigned_student = array_diff($register_student_array, $assigned_student_array);
        return $unasigned_student;
    }

    function unassigned_student_pagination() {
        $date = Array();
        $course_url = $this->input->post('course_url', TRUE);
        $page_number = $this->input->post('page_number', TRUE);
        $data_info['course_info'] = $this->user_course_model->get_course_information_with_url_by_course_url($course_url);
        $data_info['course_creator_info'] = $this->person_model->get_single_person_info_by_person_id($data_info['course_info']->course_creator_id);
        $data_info['unasigned_student'] = $unasigned_student = $this->get_unassigned_student_array($data_info['course_info']->course_id);
        $data_info['count_student'] = $total_count = count($unasigned_student);
        $data_info1 = $this->batch_model->get_unassigned_students($data_info, $date, $page_number, $total_count);
        $data_info1['course_url'] = $course_url;
        $data_info1['batch'] = $this->get_batch_info($data_info['course_info']->course_id);
        echo $this->load->view('user/batch/ajax_page/view_unassigned_student_pagination', $data_info1, true);
    }

    //tania
    function assign_student_from_unassign_student_list() {
        $date = array();
        $page_number = 1;
        $person_id = $this->session->userdata('user_id');
        $course_url = $this->input->post('course_url', TRUE);
        $student_id = $this->input->post('student_id', TRUE);
        $course_data['course_info'] = $course_info = $this->user_course_model->get_course_information_with_url_by_course_url($course_url);
        $unasigned_student = $this->get_unassigned_student_array($course_info->course_id);
        unset($unasigned_student[array_search($student_id, $unasigned_student)]);
        $course_data['count_student'] = $total_count = count($unasigned_student);
        $course_data['unassigned_student_info'] = $this->batch_model->all_unassigned_student_list($unasigned_student, $date, $page_number);
        $params = array('url' => '', 'div_id' => 'unassignStudentPagination', 'total_row' => $total_count, 'per_page' => 10, 'current_page' => $page_number, 'total_link' => 10);
        $course_data['unassigned_student_paginzation_link'] = $this->tt_pagination->view_pagination_link($params);
        $course_data['course_url'] = $course_url;
        $course_data['person_info'] = $this->person_model->get_single_person_information_by_person_id($person_id);
        $course_data['batch'] = $this->get_batch_info($course_info->course_id);
        echo $this->load->view('user/batch/ajax_page/ajax_view_unassigned_student', $course_data, true);
    }

    function view_unassign_student() {
        $person_id = $this->session->userdata('user_id');
        $course_url = $this->input->post('course_url', TRUE);

        $date_data = Array();
        $date_data['sess_start_date'] = $this->input->post('start_date', TRUE);
        $date_data['sess_end_date'] = $this->input->post('end_date', TRUE);
        $this->session->set_userdata($date_data);

        $data_info['person_info'] = $this->person_model->get_single_person_info_by_person_id($person_id);
        $data_info['resource_person_info'] = $this->resource_person_model->single_resource_person_information_by_person_id($person_id);
        $data_info['course_info'] = $this->user_course_model->get_course_information_with_url_by_course_url($course_url);
        $data_info['course_creator_info'] = $this->person_model->get_single_person_info_by_person_id($data_info['course_info']->course_creator_id);
        $data_info['unasigned_student'] = $unasigned_student = $this->get_unassigned_student_array($data_info['course_info']->course_id);

        $page_number = 1;
        $count_by_search = $this->batch_model->get_total_unassigned_student_by_search($unasigned_student, $date_data);
        $data_info['count_student'] = $total_count = count($count_by_search);
        $data_info['unassigned_student_info'] = $this->batch_model->all_unassigned_student_list($unasigned_student, $date_data, $page_number);

        $params = array('url' => '', 'div_id' => 'unassignStudentPagination', 'total_row' => $total_count, 'per_page' => 10, 'current_page' => $page_number, 'total_link' => 10);
        $data_info['unassigned_student_paginzation_link'] = $this->tt_pagination->view_pagination_link($params);
        $data_info['course_url'] = $course_url;
        $data_info['batch'] = $this->get_batch_info($data_info['course_info']->course_id);
        echo $this->load->view('user/batch/ajax_page/view_unassigned_student', $data_info, true);
    }

    function get_batch_info($course_id) {
        $batch_info = $this->batch_model->get_batch_info_course_id($course_id); //08-00-2016
        return $batch = ($batch_info) ? 1 : 0;
    }

    function make_not_eligible() {
        $course_id = $this->input->post('course_id', TRUE);
        $student_id = $this->input->post('student_id', TRUE);
        $this->batch_model->make_student_not_eligible($course_id, $student_id);
    }

    function make_eligible() {
        $course_id = $this->input->post('course_id', TRUE);
        $student_id = $this->input->post('student_id', TRUE);
        $this->batch_model->make_student_eligible($course_id, $student_id);
    }

    function not_eligible_student_list($course_url) {
        $data = array();
        $person_id = $this->session->userdata('user_id');
        $this->utility_model->remove_session_data('sess_start_date', 'sess_end_date');
        $side_menu_data = $this->user_course_model->side_menu_info($data, '', '');
        $side_menu_data['person_info'] = $this->person_model->get_single_person_info_by_person_id($person_id);
        $side_menu_data['resource_person_info'] = $this->resource_person_model->single_resource_person_information_by_person_id($person_id);
        $side_menu_data['course_info'] = $this->user_course_model->get_course_information_with_url_by_course_url($course_url);
        $side_menu_data['course_creator_info'] = $this->person_model->get_single_person_info_by_person_id($side_menu_data['course_info']->course_creator_id);
        $this->registered_student_list_validation($side_menu_data);
        $date = Array();
        $side_menu_data['course_url'] = $course_url;
        $course_data = $this->batch_model->get_all_course_not_eligible_student($side_menu_data, 1);
        $course_data['batch'] = $this->get_batch_info($side_menu_data['course_info']->course_id);
        $course_data['main_content'] = $this->load->view('user/batch/course_not_eligible_student', $course_data, true);
        $this->load->view('user/master', $course_data);
    }

    function not_eligible_pagination() {
        $course_url = $this->input->post('course_url', TRUE);
        $page_number = $this->input->post('page_number', TRUE);
        $data_info['course_info'] = $this->user_course_model->get_course_information_with_url_by_course_url($course_url);
        $data_info['course_creator_info'] = $this->person_model->get_single_person_info_by_person_id($data_info['course_info']->course_creator_id);
        $data_info = $this->batch_model->get_all_course_not_eligible_student($data_info, $page_number);
        $data_info['course_url'] = $course_url;
        $data_info['batch'] = $this->get_batch_info($data_info['course_info']->course_id);
        echo $this->load->view('user/batch/ajax_page/view_not_eligible_student_pagination', $data_info, true);
    }

    function not_eligible_by_search() {
        $course_url = $this->input->post('course_url', TRUE);
        $student_name = $this->input->post('student_name', TRUE);
        $course_info = $this->user_course_model->get_course_information_with_url_by_course_url($course_url);
        $data_info['course_creator_info'] = $this->person_model->get_single_person_info_by_person_id($course_info->course_creator_id);
        $data_info = $this->batch_model->get_all_not_eligible_student_by_search($student_name, $course_info, 1);
        $data_info['course_info'] = $course_info;
        $data_info['course_url'] = $course_url;
        $data_info['batch'] = $this->get_batch_info($course_info->course_id);
        echo $this->load->view('user/batch/ajax_page/view_not_eligible_student_search', $data_info, true);
    }

    /* ------------------------ end unassigned student 24-09-2016 ------------------------- */
}
