<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Super_admin_profile extends TT_admin_login {

    public function __construct() {
        parent::__construct();
    }
    
    public function add_work_exprience_form($person_id) {
        $data['person_id'] = $person_id;
        echo $this->load->view('admin/person_profile/admin_add_work_experience', $data, TRUE);
    }

    public function profile_add_work_experience($person_id) {
        $this->profile_model->add_work_information($person_id);
        $data['user_work_details'] = $this->profile_model->select_user_work_details($person_id);
        $data['person_info'] = $this->profile_model->user_info_by_id($person_id);
        echo $this->load->view('admin/person_profile/admin_view_work_experience', $data, TRUE);
    }
    
         /*
     * @Function            : profile_view_quiz_result 
     * @Description         : Displays the detail quiz result 
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 21-01-17
     * @Parameter           : $quiz_public_id, $profile_url
     * @Return              : NULL    
     * @Status              : Available       
     * */
    public function profile_view_quiz_result($quiz_public_id, $profile_url){
        $data['person_info'] = $this->person_model->get_single_person_information_by_person_url($profile_url);        
        $data['active_menu'] = 'user_management';
        $data['active_sub_menu'] = '';
        $person_id = $data['person_info']->person_id;        
        $data['quiz_info'] = $this->quiz_model->select_quiz_by_public_id($quiz_public_id);        
        
        $data['quiz_questions'] = $this->quiz_model->select_active_question_by_quiz_id($data['quiz_info']->quiz_id);
        $data['quiz_result'] = $this->quiz_model->select_quiz_result($person_id, $data['quiz_info']->quiz_id);
        if (!$data['quiz_info'] || !$data['quiz_questions'] || !$data['quiz_result']) {
            redirect();
        }

        $data['correct_ans'] = $correct_ans = $data['quiz_result']->quiz_correct_answer;
        $data['wrong_ans'] = $wrong_ans = $data['quiz_result']->quiz_wrong_answer;
        $data['total_question'] = $total_question = $data['quiz_result']->quiz_total_question;
        $data['total_marks'] = $total_marks = $data['quiz_result']->quiz_total_marks;
        $data['receive_marks'] = $receive_marks = $data['quiz_result']->quiz_receive_marks;
        $data['taken_time'] = $taken_time = $data['quiz_result']->quiz_finish_time;
        if (!$correct_ans) {
            $correct_ans = 0;
        }
        if (!$wrong_ans) {
            $wrong_ans = 0;
        }
        if (!$receive_marks) {
            $receive_marks = 0;
        }

        $data['unanswered'] = $total_question - ($correct_ans + $wrong_ans);
        if ($total_question) {
            $data['correct_percentage'] = ($correct_ans * 100) / $total_question;
        } else {
            $data['correct_percentage'] = 0;
        }
        if ($total_marks) {
            $data['marks_percentage'] = ($receive_marks * 100) / $total_marks;
        } else {
            $data['marks_percentage'] = 0;
        }

        $data['main_content'] = $this->load->view('admin/person_profile/admin_profile_quiz_result', $data, true);
        $this->load->view('admin/admin_master', $data);
    }
    
     /*
     * @Function            : change_quiz_result_status 
     * @Description         : Change the status of quiz result
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 18-01-17
     * @Parameter           : Null
     * @Return              : NULL    
     * @Status              : Available       
     * */
    public function change_quiz_result_status() {
        $data['quiz_result_id'] = $this->input->post('quiz_result_id');
        $data['status'] = $this->input->post('status');
        $this->quiz_model->change_quiz_result_status_model($data);
        echo json_encode('ok');
    }
    
    
    /*
     * @Function            : change_quiz_result_permission 
     * @Description         : Change the status of quiz result permission
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 19-01-17
     * @Parameter           : Null
     * @Return              : NULL    
     * @Status              : Available       
     * */
    public function change_quiz_result_permission(){
        $result_id = $this->input->post('quiz_result_id');
        $permission = $this->input->post('permission');        
        $this->quiz_model->change_quiz_result_permission($result_id, $permission);
        echo json_encode('ok');
    }
    
        /*
     * @Function            : delete_quiz_result 
     * @Description         : delete quiz result permanently
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 19-01-17
     * @Parameter           : Null
     * @Return              : NULL    
     * @Status              : Available       
     * */
    public function delete_quiz_result(){
        $result_id = (int)$this->input->post('quiz_result_id');
        $this->quiz_model->delete_quiz_result_model($result_id);
        echo json_encode('ok');
        
    }
    
    /*
     * @Function            : update_person_info_by_id
     * @Description         : Reloads the personal info view when cancel button
     *                        clicked in edit personal information in admin.
     * @Updated By          : Md Mashqur Ul ALam
     * @Start DateTime      : 07-01-17
     * @Parameter           : $person_id
     * @Return              : Ajax View [admin_view_person_details.php]    
     * @Status              : Available       
     */
        
    public function update_person_info_by_id($person_id) {
        $this->profile_model->update_personal_information_by_id($person_id);
        $data['person_info'] = $this->profile_model->user_info_by_id($person_id);
        $data['person_feature_details'] = $this->super_admin_model->select_person_feature_details_by_id($person_id);

        $data['friends_details_part1'] = $this->profile_model->select_my_friends_details_part1($person_id);
        $part1_total = count($data['friends_details_part1']);
        $data['friends_details_part2'] = $this->profile_model->select_my_friends_details_part2($person_id);
        $part2_total = count($data['friends_details_part2']);
        $data['total_friends'] = $part1_total + $part2_total;

        echo $this->load->view('admin/person_profile/admin_view_person_details', $data, TRUE);
    }
    
    
    /*
     * @Function            : cancel_update_person_info
     * @Description         : Reloads the personal info view when cancel button
     *                        clicked in edit personal information in admin.
     * @Updated By          : Md Mashqur Ul ALam
     * @Start DateTime      : 07-01-17
     * @Parameter           : Null
     * @Return              : Ajax View [admin_view_person_details.php]    
     * @Status              : Available       
     */

    public function cancel_update_person_info() {

        if ($this->input->is_ajax_request()) {
            $profile_url = $this->input->post('profile_url', true);
            $this->load->model('map_model');
            $person_id  = $this->map_model->model_person_id_by_url($profile_url);           
            $data['person_info'] = $this->profile_model->user_info_by_id($person_id);
            $data['person_feature_details'] = $this->super_admin_model->select_person_feature_details_by_id($person_id);

            $data['friends_details_part1'] = $this->profile_model->select_my_friends_details_part1($person_id);
            $part1_total = count($data['friends_details_part1']);
            $data['friends_details_part2'] = $this->profile_model->select_my_friends_details_part2($person_id);
            $part2_total = count($data['friends_details_part2']);
            $data['total_friends'] = $part1_total + $part2_total;
            echo $this->load->view('user/profile_view/ajax_view/view_person_details', $data, TRUE);
        } else {
            redirect('/');
        }
    }
    
    /*
     * @Function            : edit_person_detail_form 
     * @Used IN             : admin profile edit
     * @Description         : load the ajax view file for editing person detail
     * @Updated By          : MD Md Mashqur Ul Alam
     * @Start DateTime      : 07-01-17     
     * @Parameter           : $person_id
     * @Status              : Available       
     */
    
    public function edit_person_detail_form($person_id) {
        $data['person_info'] = $this->profile_model->user_info_by_id($person_id);

        $data['friends_details_part1'] = $this->profile_model->select_my_friends_details_part1($person_id);
        $part1_total = count($data['friends_details_part1']);
        $data['friends_details_part2'] = $this->profile_model->select_my_friends_details_part2($person_id);
        $part2_total = count($data['friends_details_part2']);
        $data['total_friends'] = $part1_total + $part2_total;

        echo $this->load->view('admin/person_profile/admin_edit_person_detail_form', $data, TRUE);
    }

    /*
     * @Function            : edit_person_interest_form 
     * @Used IN             : admin profile edit
     * @Description         : load the ajax view file for editing interest field
     * @Developed By        : MD Md Mashqur Ul Alam
     * @Start DateTime      : 07-01-17     
     * @Parameter           : $person_id
     * @Status              : Available       
     */
       
    public function edit_person_interest_form($person_id) {
        $data['interest_field_info_all'] = $this->profile_model->select_user_interest_field_all($person_id);
        $data['person_info'] = $this->profile_model->user_info_by_id($person_id);
        echo $this->load->view('admin/person_profile/admin_edit_interest_form_action', $data, TRUE);
    }
    
    
    /*
     * @Function            : cancel_update_interest_field 
     * @Used IN             : admin profile edit
     * @Description         : cancel editing interest field in profile from admin
     * @Developed By        : MD Md Mashqur Ul Alam
     * @Start DateTime      : 07-01-17     
     * @Parameter           : Null
     * @Status              : Available       
     */
    public function cancel_update_interest_field() {        
        if ($this->input->is_ajax_request()) {
            $profile_url = $this->input->post('profile_url', TRUE);
            $this->load->model('map_model');
            $person_id  = $this->map_model->model_person_id_by_url($profile_url);           
            $data['interest_field_info_all'] = $this->profile_model->select_user_interest_field_all($person_id);
            $data['person_info'] = $this->profile_model->user_info_by_id($person_id);
            echo $this->load->view('admin/person_profile/admin_interest_field_view_action', $data, TRUE);
        } else {
            redirect();
        }
    }
    
    
    /*
     * @Function            : update_interest_field 
     * @Used IN             : admin profile edit
     * @Description         : updates the interest field after editing
     * @Developed By        : MD Md Mashqur Ul Alam
     * @Start DateTime      : 07-01-17     
     * @Parameter           : $person_id
     * @Status              : Available       
     */
    public function update_interest_field($person_id) {
        $this->profile_model->update_interest_field_by_id($person_id);
        $data['interest_field_info_all'] = $this->profile_model->select_user_interest_field_all($person_id);
        $data['person_info'] = $this->profile_model->user_info_by_id($person_id);
        echo $this->load->view('admin/person_profile/admin_interest_field_view_action', $data, TRUE);
    }
    
    /*
     * @Function            : select_institute 
     * @Used IN             : route[select-institute]
     * @Description         : selects education institutes for displaying dropdown list
     * @Developed By        : MD Md Mashqur Ul Alam
     * @Start DateTime      : 26-12-16 03.30PM     
     * @Parameter           : NULL
     * @View                : None
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available       
     */
    public function select_institute() {
        if ($this->input->is_ajax_request()) {
            $array_key = array('eduInsType', 'eduInsCountry', 'eduInsCity');
            $data = $this->input->post($array_key, TRUE);
            $eduinsStatus = ['1', '3'];

            if ($data['eduInsType'] != NULL) {
                $condition['education_institute_type'] = $data['eduInsType'];
            }
            if ($data['eduInsCountry'] != NULL) {
                $condition['education_institute_country'] = $data['eduInsCountry'];
            }
            if ($data['eduInsCity'] != NULL) {
                $condition['education_institute_city'] = $data['eduInsCity'];
            }

            $output = $this->super_admin_profile_model->select_institute_dropdown($condition, $eduinsStatus);
            echo json_encode($output);
        } else {
            redirect('/');
        }
    }

    public function user_profile($url) {
        $data = array();
        $person_id_obj = $this->super_admin_model->get_person_id_by_url($url);
        $person_id = $person_id_obj->person_id;
        $this->load->view('admin/user/user_profile');
    }

    public function education() {
        $data = array();
        $role_name = $this->uri->segment(3);
        $person_id = $this->uri->segment(4);
        $data['active'] = $role_name . '_User';
        $data['role_name'] = $role_name;
        $data['person_id'] = $person_id;

        $this->load->helper(array('form', 'url'));
        $this->load->library('form_validation');
        $this->form_validation->set_rules('education_institution_id', 'Education Institution is required', 'required|trim|required|max_length[200]');
        $this->form_validation->set_rules('start_time_period', 'Start Time Period', 'required');
        $this->form_validation->set_rules('end_time_period', 'End Time Period', 'required');
        $this->form_validation->set_rules('educational_description', 'Educational Description', 'max_length[200]');
        $this->form_validation->set_rules('attended_for', 'Attended For', 'required');
        $this->form_validation->set_rules('person_education_view_status', 'Education View Status is Required', 'required');
        $this->form_validation->set_rules('person_education_status', 'Education Status is not required');

        if ($this->form_validation->run() == FALSE) {
            $data['person_edu_info'] = $this->super_admin_profile_model->select_person_edication_by_id($person_id);
            $data['main_content'] = $this->load->view('admin/person_profile/add_education_page', $data, true);
            $this->load->view('admin/admin_master', $data);
        } else {
            $this->super_admin_profile_model->save_education_information();
            redirect('super_admin_profile/education/' . $role_name . '/' . $person_id);
        }
    }

    /*
     * @Function            : add_education 
     * @Used IN             : @ admin profile section
     * @Description         : saves new education detail added to profile from admin
     * @Developed By        : Md Mashqur Ul Alam
     * @Develop Date        : 05-01-17   
     * @Parameter           : $person_id     
     * @Status              : Available
     */
    
    public function add_education($person_id) {
        $this->profile_model->save_education_information($person_id);
        $data['user_education_details'] = $this->profile_model->select_user_education_details($person_id);
        echo $this->load->view('admin/person_profile/admin_view_education_details_action', $data, TRUE);
    }

    /*
     * @Function            : add_education_form 
     * @Used IN             : @ admin profile section
     * @Description         : loads the view for add education form in profile
     * @Developed By        : Md Mashqur Ul Alam
     * @Develop Date        : 05-01-17   
     * @Parameter           : $person_id     
     * @Status              : Available
     */
    public function add_education_form($person_id) {
        $data['person_id'] = $person_id;
        echo $this->load->view('admin/person_profile/admin_add_education_action', $data, TRUE);
    }

    /*
     * @Function            : update_education 
     * @Used IN             : @ admin profile section
     * @Description         : updates the education detail from back-end admin
     * @Developed By        : Md Mashqur Ul Alam
     * @Develop Date        : 05-01-17   
     * @Parameter           : $person_id     
     * @Status              : Available
     */
    public function update_education($education_details_id) {
        $this->profile_model->update_education_information($education_details_id);
        $person_id = $this->profile_model->get_perrson_id($education_details_id);
        $data['user_education_details'] = $this->profile_model->select_user_education_details($person_id->person_id);
        echo $this->load->view('admin/person_profile/admin_view_education_details_action', $data, TRUE);
    }

       /*
     * @Function            : edit_education_form 
     * @Used IN             : @ admin profile section
     * @Description         : loads the edit education form
     * @Developed By        : Md Mashqur Ul Alam
     * @Develop Date        : 05-01-17   
     * @Parameter           : $person_id     
     * @Status              : Available
     */
    public function edit_education_form($education_details_id) {
        $data['edication_details'] = $this->profile_model->Selected_education_Information($education_details_id);
        echo $this->load->view('admin/person_profile/admin_edit_education_form', $data, TRUE);
    }
    
    
    /*
     * @Function            : cancel_update_education 
     * @Used IN             : @ admin profile section
     * @Description         : loads the edit education form
     * @Developed By        : Md Mashqur Ul Alam
     * @Develop Date        : 05-01-17   
     * @Parameter           : $person_id     
     * @Status              : Available
     */
    public function cancel_update_education($education_details_id) {
        $person_id = $this->profile_model->get_perrson_id($education_details_id);
        $data['user_education_details'] = $this->profile_model->select_user_education_details($person_id->person_id);
        echo $this->load->view('admin/person_profile/admin_view_education_details_action', $data, TRUE);
    }
    
    /*
     * @Function            : delete_education 
     * @Used IN             : @ admin profile section
     * @Description         : deletes education detail from profile
     * @Developed By        : Md Mashqur Ul Alam
     * @Develop Date        : 05-01-17   
     * @Parameter           : $person_id     
     * @Status              : Available
     */
    public function delete_education() {
        if ($this->input->is_ajax_request()) {
            $this->form_validation->set_rules('eduDetail', 'Education Institute Details', 'required|trim|integer');
            if ($this->form_validation->run() == TRUE) {
                $person_url = $this->input->post('profileUrl', TRUE);
                $this->load->model('map_model');
                $data['person_id'] = $this->map_model->model_person_id_by_url($person_url);
                $data['person_education_details_id'] = $this->input->post('eduDetail', TRUE);
                $this->super_admin_profile_model->delete_education_detail_information($data);
            }
        } else {
            redirect('/');
        }
    }

    public function edit_edication_information() {
        $data = array();
        $role_name = $this->uri->segment(3);
        $person_id = $this->uri->segment(4);
        $education_detail_id = $this->uri->segment(5);
        $data['active'] = $role_name . '_User';
        $data['role_name'] = $role_name;
        $data['person_id'] = $person_id;
        $data['education_detail_id'] = $education_detail_id;

        $this->load->helper(array('form', 'url'));
        $this->load->library('form_validation');
        $this->form_validation->set_rules('education_institution_id', 'Education Institution is required', 'required|trim|required|max_length[200]');
        $this->form_validation->set_rules('education_institution_id', 'Education Institution Name', 'required|trim|required|max_length[200]');
        $this->form_validation->set_rules('start_time_period', 'Start Time Period', 'required');
        $this->form_validation->set_rules('end_time_period', 'End Time Period', 'required');
        $this->form_validation->set_rules('educational_description', 'Educational Description', 'max_length[200]');
        $this->form_validation->set_rules('attended_for', 'Attended For', 'required');
        $this->form_validation->set_rules('person_education_view_status', 'Education View Status is Required', 'required');
        $this->form_validation->set_rules('person_education_status', 'Education Status is Required', 'required');

        if ($this->form_validation->run() == FALSE) {
            $data['person_edu_info'] = $this->super_admin_profile_model->select_person_edication_by_education_id($person_id, $education_detail_id);
            $data['education_institute'] = $this->super_admin_profile_model->select_institute($data['person_edu_info']->education_institute_country, $data['person_edu_info']->education_institute_city, $data['person_edu_info']->attended_for);
            $data['main_content'] = $this->load->view('admin/person_profile/edit_education_page', $data, true);
            $this->load->view('admin/admin_master', $data);
        } else {
            $this->super_admin_profile_model->update_education_information($education_detail_id);
            redirect('super_admin_profile/education/' . $role_name . '/' . $person_id);
        }
    }

    public function archive_education_detail_information($education_detail_id) {
        $this->super_admin_profile_model->archive_education_detail_information($education_detail_id);
        $data['value'] = $this->super_admin_profile_model->select_user_education_detail_by_edu_id($education_detail_id);
        echo $this->load->view('admin/user/education_details_action', $data, TRUE);
    }

    public function active_education_detail_information($education_detail_id) {
        $this->super_admin_profile_model->active_education_detail_information($education_detail_id);
        $data['value'] = $this->super_admin_profile_model->select_user_education_detail_by_edu_id($education_detail_id);
        echo $this->load->view('admin/user/education_details_action', $data, TRUE);
    }

    public function delete_education_detail_information($education_detail_id) {
        $this->super_admin_profile_model->delete_education_detail_information($education_detail_id);
    }

    public function inactive_education_detail_information($education_detail_id) {
        $data = array();
        $role_name = $this->uri->segment(3);
        $person_id = $this->uri->segment(4);
        $education_detail_id = $this->uri->segment(5);
        $data['active'] = $role_name . '_User';
        $data['role_name'] = $role_name;
        $data['person_id'] = $person_id;
        $data['education_detail_id'] = $education_detail_id;
        $this->super_admin_profile_model->inactive_education_detail_information($education_detail_id);
        $data['person_edu_info'] = $this->super_admin_profile_model->select_person_edication_by_id($person_id);
        $data['main_content'] = $this->load->view('admin/person_profile/add_education_page', $data, true);
        $this->load->view('admin/admin_master', $data);
    }

    public function work_details() {
        $data = array();
        $role_name = $this->uri->segment(3);
        $person_id = $this->uri->segment(4);
        $data['active'] = $role_name . '_User';
        $data['role_name'] = $role_name;
        $data['person_id'] = $person_id;

        $this->load->helper(array('form', 'url'));
        $this->load->library('form_validation');

        $this->form_validation->set_rules('company_name', 'Company Name', 'trim|required|max_length[100]');
        $this->form_validation->set_rules('designation', 'Designation', 'trim|required|max_length[100]');
        $this->form_validation->set_rules('company_address', 'Company Address', 'max_length[150]|required');
        $this->form_validation->set_rules('company_website_url', 'Company Website Address', 'max_length[100]|required');
        $this->form_validation->set_rules('job_start_date', 'Job Start Date', 'required');
        $this->form_validation->set_rules('job_end_date', 'Job End Date', 'required');
        $this->form_validation->set_rules('work_currently_here', 'Work Current Status', 'required');
        $this->form_validation->set_rules('job_responsibility_details', 'Job Responsibility', 'max_length[200]');
        $this->form_validation->set_rules('person_work_view_status', 'Work View Status is required', 'required');
        $this->form_validation->set_rules('work_details_status', 'Who Can See My Work Details', '');

        if ($this->form_validation->run() == FALSE) {
            $data['person_work_info'] = $this->super_admin_profile_model->select_person_work_by_id($person_id);
            $data['main_content'] = $this->load->view('admin/person_profile/add_work_details_page', $data, true);
            $this->load->view('admin/admin_master', $data);
        } else {
            $this->super_admin_profile_model->save_work_details_information();
            redirect('super_admin_profile/work_details/' . $role_name . '/' . $person_id);
        }
    }

    public function add_work_experience($url) {
        $data = array();
        $person_id_obj = $this->super_admin_model->get_person_id_by_url($url);
        $person_id = $person_id_obj->person_id;
        $data['person_id'] = $person_id;

        $this->load->helper(array('form', 'url'));
        $this->load->library('form_validation');

        $this->form_validation->set_rules('company_name', 'Company Name', 'trim|required|max_length[100]');
        $this->form_validation->set_rules('designation', 'Designation', 'trim|required|max_length[100]');
        $this->form_validation->set_rules('company_address', 'Company Address', 'max_length[150]|required');
        $this->form_validation->set_rules('company_website_url', 'Company Website Address', 'max_length[100]|required');
        $this->form_validation->set_rules('job_start_date', 'Job Start Date', 'required');
        $this->form_validation->set_rules('work_currently_here', 'Work Current Status', 'required');
        if ($this->input->post('work_currently_here', TRUE) == 2) {
            $this->form_validation->set_rules('job_end_date', 'Job End Date', 'required');
        }

        $this->form_validation->set_rules('job_responsibility_details', 'Job Responsibility', 'max_length[200]');
        $this->form_validation->set_rules('person_work_view_status', 'Work View Status is required', 'required');
        $this->form_validation->set_rules('work_details_status', 'Who Can See My Work Details', '');

        if ($this->form_validation->run() == FALSE) {
            $person_role = $this->session->userdata('person_role');
            $data = array();
            $data['active_menu'] = 'user_management';
            $data['active_sub_menu'] = $this->session->person_role;
            $data['active_tab'] = 'add_work_experience';
            $data['active'] = 1;
            if ($person_role === 'organization') {
                $data['active_top_menu'] = 1;
            } else {
                $data['active_top_menu'] = 0;
            }
            if ($person_role === 'resource_person') {
                $data['inactive_organization_top_menu'] = 1;
            } else {
                $data['inactive_organization_top_menu'] = 0;
            }
            if ($person_role === 'learner') {
                $data['inactive_organization_teacher_top_menu'] = 1;
            } else {
                $data['inactive_organization_teacher_top_menu'] = 0;
            }

            $data['person_info'] = $this->super_admin_model->select_user_information_by_id($person_id);

            if ($data['person_info']->person_role == 4) {
//                $data['org_info'] = $this->super_admin_model->select_organization_information($person_id);
//                $sdata['number_of_classroom'] = count($this->super_admin_organization_model->select_all_classroom($person_id, '', '', ''));
                $sdata['number_of_student'] = '';
                $sdata['number_of_resource_person'] = '';
                $this->session->set_userdata($sdata);
            }
            $this->session->set_userdata('active_tab', 'add_work_experience');
            $data['active_sub_menu'] = 0;
            $data['person_education_details'] = $this->super_admin_model->select_user_education_details_by_id($person_id);
            $data['person_work_details'] = $this->super_admin_model->select_user_work_details_by_id($person_id);
            $data['person_browse_details'] = $this->super_admin_model->select_person_browse_details_by_id($person_id);
            $data['person_feature_details'] = $this->super_admin_model->select_person_feature_details_by_id($person_id);
            $data['person_self_assessmet_skills'] = $this->super_admin_model->select_self_assessment_skills_by_id($person_id);
            $data['person_interest_field'] = $this->super_admin_model->select_user_interest_field_all($person_id);
            $data['person_language'] = $this->super_admin_model->select_person_language_by_id($person_id);

            $data['friends_details_part1'] = $this->profile_model->select_my_friends_details_part1($person_id);
            $part1_total = count($data['friends_details_part1']);
            $data['friends_details_part2'] = $this->profile_model->select_my_friends_details_part2($person_id);
            $part2_total = count($data['friends_details_part2']);
            $data['total_friends'] = $part1_total + $part2_total;

            $data['add_work_experience_form'] = $this->load->view('admin/user/add_work_experience', $data, TRUE);
            $data['main_content'] = $this->load->view('admin/person_detail_profile', $data, TRUE);

            $this->load->view('admin/admin_master', $data);
        } else {
            $this->super_admin_profile_model->save_work_details_information();
            redirect('super_admin/view_detail/' . $url);
        }
    }

        /*
     * @Function            : search_company_name 
     * @Used IN             : @function 'companyNameSuggestion' - [admin_edit_profile.js]
     * @Description         : Suggests company name from database based on users 
       *                      input in the company name field in workexperience section
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 08-01-2017  
     * @Parameter           : NULL
     * @View                : None
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available       
     */
    public function search_company_name(){
        $search_key = $this->input->post('search_key', true);
        $result = $this->profile_model->search_company_name_model($search_key);
        echo json_encode($result);
    }
    
    
    /*
     * @Function            : edit_work_experience 
     * @Used IN             : @ admin profile section
     * @Description         : loads the edit work exp form
     * @Developed By        : Unknown
     * @Updated By          : Md Mashqur Ul Alam
     * @Update Date        : 08-01-17   
     * @Parameter           : $person_id     
     * @Status              : Available
     */
    public function edit_work_experience($id) {
        $data['work_value'] = $this->super_admin_profile_model->select_user_work_experience_detail_by_id($id);
        echo $this->load->view('admin/person_profile/admin_edit_work_form', $data, TRUE);
    }
    
    /*
     * @Function            : cancel_update_work_experience 
     * @Used IN             : @ admin profile section
     * @Description         : Cancel the edit form of work experience in admin
     * @Developed By        : Unknown
     * @Updated By          : Md Mashqur Ul Alam
     * @Update Date        : 08-01-17   
     * @Parameter           : $person_id     
     * @Status              : Available
     */
    public function cancel_update_work_experience($person_work_detail_id) {
        $data['p_value'] = $this->profile_model->select_user_work_experience_detail_by_id($person_work_detail_id);
        echo $this->load->view('admin/person_profile/admin_view_work_single_action', $data, TRUE);
    }

    public function update_work_experience($person_work_detail_id) {
//        $this->super_admin_profile_model->update_work_experience_information($person_work_detail_id);
//        $data['p_value'] = $this->super_admin_profile_model->select_user_work_experience_detail_by_id($person_work_detail_id);
//        $data['person_info'] = $this->super_admin_model->select_user_information_by_id($data['p_value']->person_id);
//        echo $this->load->view('admin/user/work_detail_action', $data, TRUE);
        
        $this->profile_model->update_work_experience_information($person_work_detail_id);
        $data['p_value'] = $this->profile_model->select_user_work_experience_detail_by_id($person_work_detail_id);
        echo $this->load->view('user/profile_view/ajax_view/view_work_single_action', $data, TRUE);
    }

    public function archive_work_detail_information($work_detail_id) {
        $this->super_admin_profile_model->archive_word_detail_information($work_detail_id);
        $data['p_value'] = $this->super_admin_profile_model->select_user_work_detail_by_edu_id($work_detail_id);
        echo $this->load->view('admin/user/work_detail_action', $data, TRUE);
    }

    public function active_work_detail_information($work_detail_id) {
        $this->super_admin_profile_model->active_word_detail_information($work_detail_id);
        $data['p_value'] = $this->super_admin_profile_model->select_user_work_detail_by_edu_id($work_detail_id);
        echo $this->load->view('admin/user/work_detail_action', $data, TRUE);
    }

    public function delete_work_detail_information($work_detaail_id) {
        $this->super_admin_profile_model->delete_work_detail_information($work_detaail_id);
    }

    public function inactive_work_detail_information($work_detail_id) {
        $data = array();
        $role_name = $this->uri->segment(3);
        $person_id = $this->uri->segment(4);
        $work_detail_id = $this->uri->segment(5);
        $data['active'] = $role_name . '_User';
        $data['role_name'] = $role_name;
        $data['person_id'] = $person_id;
        $data['education_detail_id'] = $work_detail_id;
        $this->super_admin_profile_model->inactive_work_detail_information($work_detail_id);
        $data['person_work_info'] = $this->super_admin_profile_model->select_person_work_by_id($person_id);
        $data['main_content'] = $this->load->view('admin/person_profile/add_work_details_page', $data, true);
        $this->load->view('admin/admin_master', $data);
    }
    
    /*
     * @Function            : edit_self_assesment_form 
     * @Used IN             : @ admin profile section
     * @Description         : Displays form for updating self assessment skill
     * @Developed By        : Md Mashqur Ul Alam
     * @Develop Date        : 08-01-17   
     * @Parameter           : $person_id     
     * @Status              : Available
     */
    public function edit_self_assesment_form($person_id) {
        $data['person_self_assessmet_skills'] = $this->super_admin_model->select_self_assessment_skills_by_id($person_id);
        $data['person_info'] = $this->profile_model->user_info_by_id($person_id);

        echo $this->load->view('admin/person_profile/admin_self_assesment_form_action', $data, TRUE);
    }
    
    /*
     * @Function            : update_self_assesment 
     * @Used IN             : @ admin profile section
     * @Description         : Updates the self assessment skill after editing
     * @Developed By        : Md Mashqur Ul Alam
     * @Develop Date        : 09-01-17   
     * @Parameter           : $person_id     
     * @Status              : Available
     */
    public function update_self_assesment($person_id) {
        $this->profile_model->update_self_assessment_by_id($person_id);
        $data['person_self_assessmet_skills'] = $this->super_admin_model->select_self_assessment_skills_by_id($person_id);
        $data['person_info'] = $this->profile_model->user_info_by_id($person_id);

        echo $this->load->view('admin/person_profile/admin_self_assesment_view_action', $data, TRUE);
    }
    
    /*
     * @Function            : cancel_self_assessment 
     * @Used IN             : @ admin profile section
     * @Description         : cancel the person self assesment edit form
     * @Developed By        : Md Mashqur Ul Alam
     * @Develop Date        : 09-01-17   
     * @Parameter           : $person_id     
     * @Status              : Available
     */
    
    public function cancel_self_assessment($person_id){
        $data['person_self_assessmet_skills'] = $this->super_admin_model->select_self_assessment_skills_by_id($person_id);
        $data['person_info'] = $this->profile_model->user_info_by_id($person_id);
        echo $this->load->view('admin/person_profile/admin_self_assesment_view_action', $data, TRUE);
    }

    /*
     *  Start Feature Status Field
     */

    public function change_status_to_talha_user() {
        $field = $this->uri->segment(3);
        $new_status = $this->uri->segment(4);
        $person_id = $this->uri->segment(5);
        switch ($field) {
            case 'email':
                $this->super_admin_profile_model->change_email_status($new_status, $person_id);
                $data['person_feature_details'] = $this->super_admin_model->select_person_feature_details_by_id($person_id);
                echo $this->load->view('admin/user/email_view_action', $data, TRUE);
                break;
            case 'contact':
                $this->super_admin_profile_model->change_contact_status($new_status, $person_id);
                $data['person_feature_details'] = $this->super_admin_model->select_person_feature_details_by_id($person_id);
                echo $this->load->view('admin/user/contact_view_action', $data, TRUE);
                break;
            case 'address':
                $this->super_admin_profile_model->change_address_status($new_status, $person_id);
                $data['person_feature_details'] = $this->super_admin_model->select_person_feature_details_by_id($person_id);
                echo $this->load->view('admin/user/address_view_action', $data, TRUE);
                break;
            case 'birthday':
                $this->super_admin_profile_model->change_birthday_status($new_status, $person_id);
                $data['person_feature_details'] = $this->super_admin_model->select_person_feature_details_by_id($person_id);
                echo $this->load->view('admin/user/birthday_view_action', $data, TRUE);
                break;
        }
    }

    public function change_status_to_public() {
        $field = $this->uri->segment(3);
        $new_status = $this->uri->segment(4);
        $person_id = $this->uri->segment(5);
        switch ($field) {
            case 'email':
                $this->super_admin_profile_model->change_email_status($new_status, $person_id);
                $data['person_feature_details'] = $this->super_admin_model->select_person_feature_details_by_id($person_id);
                echo $this->load->view('admin/user/email_view_action', $data, TRUE);
                break;
            case 'contact':
                $this->super_admin_profile_model->change_contact_status($new_status, $person_id);
                $data['person_feature_details'] = $this->super_admin_model->select_person_feature_details_by_id($person_id);
                echo $this->load->view('admin/user/contact_view_action', $data, TRUE);
                break;
            case 'address':
                $this->super_admin_profile_model->change_address_status($new_status, $person_id);
                $data['person_feature_details'] = $this->super_admin_model->select_person_feature_details_by_id($person_id);
                echo $this->load->view('admin/user/address_view_action', $data, TRUE);
                break;
            case 'birthday':
                $this->super_admin_profile_model->change_birthday_status($new_status, $person_id);
                $data['person_feature_details'] = $this->super_admin_model->select_person_feature_details_by_id($person_id);
                echo $this->load->view('admin/user/birthday_view_action', $data, TRUE);
                break;
        }
    }

    public function change_status_to_link() {
        $field = $this->uri->segment(3);
        $new_status = $this->uri->segment(4);
        $person_id = $this->uri->segment(5);
        switch ($field) {
            case 'email':
                $this->super_admin_profile_model->change_email_status($new_status, $person_id);
                $data['person_feature_details'] = $this->super_admin_model->select_person_feature_details_by_id($person_id);
                echo $this->load->view('admin/user/email_view_action', $data, TRUE);
                break;
            case 'contact':
                $this->super_admin_profile_model->change_contact_status($new_status, $person_id);
                $data['person_feature_details'] = $this->super_admin_model->select_person_feature_details_by_id($person_id);
                echo $this->load->view('admin/user/contact_view_action', $data, TRUE);
                break;
            case 'address':
                $this->super_admin_profile_model->change_address_status($new_status, $person_id);
                $data['person_feature_details'] = $this->super_admin_model->select_person_feature_details_by_id($person_id);
                echo $this->load->view('admin/user/address_view_action', $data, TRUE);
                break;
            case 'birthday':
                $this->super_admin_profile_model->change_birthday_status($new_status, $person_id);
                $data['person_feature_details'] = $this->super_admin_model->select_person_feature_details_by_id($person_id);
                echo $this->load->view('admin/user/birthday_view_action', $data, TRUE);
                break;
        }
    }

    public function change_status_to_only_me() {
        $field = $this->uri->segment(3);
        $new_status = $this->uri->segment(4);
        $person_id = $this->uri->segment(5);
        switch ($field) {
            case 'email':
                $this->super_admin_profile_model->change_email_status($new_status, $person_id);
                $data['person_feature_details'] = $this->super_admin_model->select_person_feature_details_by_id($person_id);
                echo $this->load->view('admin/user/email_view_action', $data, TRUE);
                break;
            case 'contact':
                $this->super_admin_profile_model->change_contact_status($new_status, $person_id);
                $data['person_feature_details'] = $this->super_admin_model->select_person_feature_details_by_id($person_id);
                echo $this->load->view('admin/user/contact_view_action', $data, TRUE);
                break;
            case 'address':
                $this->super_admin_profile_model->change_address_status($new_status, $person_id);
                $data['person_feature_details'] = $this->super_admin_model->select_person_feature_details_by_id($person_id);
                echo $this->load->view('admin/user/address_view_action', $data, TRUE);
                break;
            case 'birthday':
                $this->super_admin_profile_model->change_birthday_status($new_status, $person_id);
                $data['person_feature_details'] = $this->super_admin_model->select_person_feature_details_by_id($person_id);
                echo $this->load->view('admin/user/birthday_view_action', $data, TRUE);
                break;
        }
    }

    /*
     *  End Feature Status Field
     */

    /*
     *  Start Self Assessment Field
     */

    public function add_self_assessment($url) {
        $person_id_obj = $this->super_admin_model->get_person_id_by_url($url);
        $person_id = $person_id_obj->person_id;
        $this->session->set_userdata('active_tab', 'add_self_assessment');
        $this->super_admin_profile_model->save_self_assessment_skills($person_id);
        redirect('super_admin/view_detail/' . $url);
    }

    public function edit_self_assessment($url) {
        $person_id_obj = $this->super_admin_model->get_person_id_by_url($url);
        $person_id = $person_id_obj->person_id;
        $this->session->set_userdata('active_tab', 'add_self_assessment');
        $this->super_admin_profile_model->update_self_assessment_skills($person_id);
        redirect('super_admin/view_detail/' . $url);
    }

    /*
     *  End Self Assessment Field
     */

    /*
     *  Start Field of Interesst
     */

    public function add_interest_field($url) {
        $person_id_obj = $this->super_admin_model->get_person_id_by_url($url);
        $person_id = $person_id_obj->person_id;
        $this->form_validation->set_rules('tokenize_placeholder_add_interest', 'Field of Interest Name', 'required');
        if ($this->form_validation->run() == FALSE) {
            $this->session->set_userdata('active_tab', 'add_interest_field');
            redirect('super_admin/view_detail/' . $url);
        } else {
            $this->session->set_userdata('active_tab', 'add_interest_field');
            $this->super_admin_profile_model->save_interest_field($person_id);
            redirect('super_admin/view_detail/' . $url);
        }
    }

    public function edit_interest_field($url) {
        $person_id_obj = $this->super_admin_model->get_person_id_by_url($url);
        $person_id = $person_id_obj->person_id;
        $this->form_validation->set_rules('tokenize_placeholder_interest_edit', 'Field of Interest Name', 'required');
        if ($this->form_validation->run() == FALSE) {
            $this->session->set_userdata('active_tab', 'add_interest_field');
            redirect('super_admin/view_detail/' . $url);
        } else {
            $this->session->set_userdata('active_tab', 'add_interest_field');
            $this->super_admin_profile_model->update_interest_field($person_id);
            redirect('super_admin/view_detail/' . $url);
        }
    }

    /*
     *  End Field of Interesst
     */

    /*
     *  Start Language Field
     */
    
    
    /*
     * @Description         : Displays add language form in admin section
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 15-01-17
     * @Parameter           : $person_id
     * @Return              : Null 
     */    
    public function add_language_form($person_id) {
        $data['person_id'] = $person_id;
        echo $this->load->view('admin/person_profile/admin_add_language_form', $data, TRUE);
    }
    
    /*
     * @Description         : Add new language to profile
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 16-01-17
     * @Parameter           : $person_id
     * @Return              : Null 
     */
    
    function add_language($person_id) {
        $this->profile_model->save_language($person_id);
        $data['person_info'] = $this->profile_model->user_info_by_id($person_id);
        $data['person_language'] = $this->super_admin_model->select_person_language_by_id($person_id);
        echo $this->load->view('admin/person_profile/admin_view_language_details', $data, TRUE);
    }

    /*
     * @Description         : Edit Existing Language in profile section
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 16-01-17
     * @Parameter           : NULL
     * @Return              : Null 
     */  
    
    public function edit_language_by_id() {
        $person_id = $this->uri->segment(4);
        $person_language_id = $this->uri->segment(3);
        $data['person_language_id'] = $person_language_id;
        $data['selected_person_language'] = $this->profile_model->get_selected_language($person_language_id);
        $data['person_info'] = $this->profile_model->user_info_by_id($person_id);
        $data['person_language'] = $this->profile_model->select_person_language_without_language_id($person_id, $person_language_id);

        echo $this->load->view('admin/person_profile/admin_edit_language_form', $data, TRUE);
    }
    
    /*
     * @Function            : cancel_edit_language
     * @Description         : Reloads the view of language section when cancel 
     *                        Button clicked from language edit
     * @Developed By        : Md Mashqur Ul ALam
     * @Start DateTime      : 16-01-17
     * @Parameter           : Null
     * @Return              : NULL   
     * @Status              : Available       
     */
    public function cancel_edit_language($profile_url){
        $this->load->model('map_model');        
        $person_id = $this->map_model->model_person_id_by_url($profile_url);
        $data['person_language'] = $this->super_admin_model->select_person_language_by_id($person_id);        
        echo $this->load->view('admin/person_profile/admin_view_language_details', $data, TRUE);
    }
    
    /*
     * @Function            : update_language
     * @Description         : Updates the profile language info
     * @Developed By        : Md Mashqur Ul ALam
     * @Start DateTime      : 16-01-17
     * @Parameter           : Null
     * @Return              : NULL   
     * @Status              : Available       
     */
    
    public function update_language() {
        $person_id = $this->uri->segment(4);
        $person_language_id = $this->uri->segment(3);
        $this->profile_model->update_language_by_language_id($person_language_id);
        $data['person_info'] = $this->profile_model->user_info_by_id($person_id);
        $data['person_language'] = $this->super_admin_model->select_person_language_by_id($person_id);

        echo $this->load->view('admin/person_profile/admin_view_language_details', $data, TRUE);
    }

    
    /*
 * @Function            : delete_language_by_language_id
 * @Used IN             : Language section of Profile
 * @Description         : Deletes the selected language details
 * @Developed By        : Unknown
 * @Updated By          : Md Mashqur Ul Alam [16-01-17]
 * @Parameter           : langDetail
 * @Return              : Null
 * @Status              : Available       
 */
    public function delete_language_by_language_id() {        
        $person_language_id = $this->input->post('person_language_id', TRUE);
        $profile_url = $this->input->post('profile_url', TRUE);
        $this->load->model('map_model');        
        $person_id = $this->map_model->model_person_id_by_url($profile_url);
        $this->profile_model->delete_language_by_id($person_language_id);
        $data['person_info'] = $this->profile_model->user_info_by_id($person_id);
        $data['person_language'] = $this->super_admin_model->select_person_language_by_id($person_id);
        echo $this->load->view('admin/person_profile/admin_view_language_details', $data, TRUE);
    }

    function archive_language($person_language_id) {
        $this->super_admin_profile_model->archive_language_by_id($person_language_id);
        $data['l_value'] = $this->super_admin_profile_model->select_single_language_value($person_language_id);
        echo $this->load->view('admin/user/language_view_action', $data, TRUE);
    }

    function active_language($person_language_id) {
        $this->super_admin_profile_model->active_language_by_id($person_language_id);
        $data['l_value'] = $this->super_admin_profile_model->select_single_language_value($person_language_id);
        echo $this->load->view('admin/user/language_view_action', $data, TRUE);
    }

    function delete_language($person_language_id) {
        $this->super_admin_profile_model->delete_language_by_id($person_language_id);
    }

    public function user_link($url) {
        $person_id_obj = $this->super_admin_model->get_person_id_by_url($url);
        $person_id = $person_id_obj->person_id;

        $data['active_menu'] = 'dashboard';
        $data['active_sub_menu'] = 'my_link';
        $data['left_content'] = $this->load->view('user/side_menu', $data, TRUE);
        $data['right_content'] = $this->load->view('user/right_content', $data, TRUE);
        $data['person_id'] = $person_id;

        $data['start'] = $start = ($this->uri->segment(4)) ? $this->uri->segment(4) : 0;
        $data['limit'] = $limit = 10;
        $data['person_link'] = $this->super_admin_profile_model->select_person_link_with_pagination($person_id, '', '');
        $data['person_link'] = $this->super_admin_profile_model->select_person_link_with_pagination($person_id, $start, $limit);
        foreach ($data['person_link'] as $v_link) {
            if ($v_link->person_id != $person_id) {
                $data['link_person_info'][$v_link->person_link_id] = $this->profile_model->person_info_by_person_id($v_link->person_id);
            } else if ($v_link->requested_person_id != $person_id) {
                $data['link_person_info'][$v_link->person_link_id] = $this->profile_model->person_info_by_person_id($v_link->requested_person_id);
            }
        }

        $data['this_page'] = count($data['person_link']);

        if (!$data['person_link']) {
            $sdata = array();
            $sdata['message'] = 'You do not have any Link';
            $this->session->set_userdata($sdata);
        }

        $data['main_content'] = $this->load->view('admin/user/user_link', $data, true);
        $this->load->view('admin/admin_master', $data);
    }

}
