<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Super_admin_group extends TT_admin_login {

    public function __construct() {
        parent::__construct();
    }

    public function index() {
        $data = array();
        $data['active'] = 'manage_list';

        $status = $this->session->userdata('status');
        $short = $this->session->userdata('short');
        $start = ($this->uri->segment(2)) ? $this->uri->segment(2) : 0;
        $limit = $this->session->userdata('per_page');

        if (!$status) {
            $status = '';
        }
        if ($limit == '') {
            $limit = 10;
        }
        $data['groups'] = $this->super_admin_group_model->select_group($start, $limit, $status, $short);

        $data['main_content'] = $this->load->view('admin/group/group_list', $data, TRUE);
        $this->load->view('admin/group/admin_master', $data);
    }

    /*
     * START GROUP Type Mastering
     * By Suddam Hossain
     * 14-02-2016
     */

    public function create_group_type() {
        $data = array();
        $data['active_menu'] = 'group';
        $data['active_sub_menu'] = 'create_group_type';
        $data['main_content'] = $this->load->view('admin/group/create_group_type', $data, true);
        $this->load->view('admin/admin_master', $data);
    }

    public function manage_group_type($arg = NULL) {
        $data = array();
        $data['active_menu'] = 'group';
        $data['active_sub_menu'] = 'manage_group_type';
        if ($arg != NULL) {
            $data['page'] = $arg;
            $number = $arg * 10 - 10;
            $data['serial'] = $number;
        } else {
            $data['page'] = 0;
            $data['serial'] = 0;
            $number = 0;
        }
        $person_id = $this->session->userdata('person_id');
        $data['check_person_status'] = $this->super_admin_group_model->select_person_role($person_id);
        $data['type_value'] = $this->super_admin_group_model->select_limited_type_value($number, "");
        $data['total_limit_value'] = $this->super_admin_group_model->select_type_value();

        $data['main_content'] = $this->load->view('admin/group/manage_group_type', $data, true);
        $this->load->view('admin/admin_master', $data);
    }

    public function detail_group_list($arg = NULL) {
        $data = array();
        $data['active_menu'] = 'group';
        $data['active_sub_menu'] = 'detail_group_list';
        if ($arg != NULL) {
            $data['page'] = $arg;
            $number = $arg * 10 - 10;
            $data['serial'] = $number;
        } else {
            $data['page'] = 0;
            $data['serial'] = 0;
            $number = 0;
        }
        $data['all_group_list'] = $this->super_admin_group_model->select_all_group_list($number, "");
        $data['total_group_list'] = $this->super_admin_group_model->select_total_all_group_list();
        $person_id = $this->session->userdata('person_id');
        $data['check_person_status'] = $this->super_admin_group_model->select_person_role($person_id);
        foreach ($data['all_group_list'] as $val) {

            $data['grp_url_name'][$val->group_id] = $this->super_admin_group_model->select_all_url_name($val->url_id);
            $data['total_member'][$val->group_id] = $this->super_admin_group_model->group_total_member($val->group_id);
            $data['total_post'][$val->group_id] = $this->super_admin_group_model->total_group_note($val->group_id);
            $data['total_note'][$val->group_id] = $this->super_admin_group_model->select_note_info($data['total_post'][$val->group_id]);
            $data['total_alert'][$val->group_id] = $this->super_admin_group_model->select_alert_info($data['total_post'][$val->group_id]);
            $data['total_assignment'][$val->group_id] = $this->super_admin_group_model->select_assignment_info($data['total_post'][$val->group_id]);
            $data['total_photo'][$val->group_id] = $this->super_admin_group_model->select_photo_info($data['total_post'][$val->group_id]);
            $data['total_video'][$val->group_id] = $this->super_admin_group_model->select_video_info($data['total_post'][$val->group_id]);
            $data['total_course'][$val->group_id] = $this->super_admin_group_model->select_total_course_info($val->group_id);
            $data['total_video_course'][$val->group_id] = $this->super_admin_group_model->select_total_video_course_info($val->group_id);
        }


        $data['main_content'] = $this->load->view('admin/group/detail_group_list', $data, true);
        $this->load->view('admin/admin_master', $data);
    }

    public function group_course_member_details($url_name, $grp_url) {
        $data = array();
        $data['active'] = 'detail_group_list';
        $data['url_id'] = $this->super_admin_group_model->get_url_id($url_name);
        $data['grp_url_id'] = $this->super_admin_group_model->get_url_id($grp_url);
        $data['url'] = $url_name;
        $data['grp_url'] = $grp_url;
        $data['grp_id'] = $this->super_admin_group_model->select_group_id_for_note($data['grp_url_id']->url_id);
        $person_id = $this->session->userdata('person_id');
        $data['check_person_status'] = $this->super_admin_group_model->select_person_role($person_id);
        $data['course_id'] = $this->super_admin_group_model->select_course_id_by_url($data['url_id']->url_id);

        $data['student_id'] = $this->super_admin_group_model->select_student_for_that_course($data['course_id']->course_id);

        if ($data['student_id']) {
            foreach ($data['student_id'] as $val) {
                $data['student_info'][$val->person_id] = $this->super_admin_group_model->select_student_info_person_id($val->person_id);

                $data['person_payment_status'][$val->person_id] = $this->super_admin_group_model->select_payment_status($val->payment_id);
            }
        }

        $data['main_content'] = $this->load->view('admin/group/view_group_course_member_details', $data, true);
        $this->load->view('admin/admin_master', $data);
    }

    public function group_video_course_list($url_name) {
        $data = array();
        $data['active_menu'] = 'group';
        $data['active_sub_menu'] = 'detail_group_list';
        $data['url_id'] = $this->super_admin_group_model->get_url_id($url_name);
        $data['url'] = $url_name;
        $data['grp_id'] = $this->super_admin_group_model->select_group_id_for_note($data['url_id']->url_id);
        $data['course_id'] = $this->super_admin_group_model->select_video_courses_for_group($data['grp_id']->group_id);
        if ($data['course_id']) {
            foreach ($data['course_id'] as $val) {

                $data['group_course_info'][$val->course_id] = $this->super_admin_group_model->select_group_video_course_info_by_course_id($val->course_id);
                $data['course_url'] = $this->super_admin_group_model->select_course_url($data['group_course_info'][$val->course_id]->url_id);
                $data['group_course_student'][$val->course_id] = $this->super_admin_group_model->select_group_video_course_student($val->course_id);
            }
        }
        $data['main_content'] = $this->load->view('admin/group/group_video_course_list', $data, true);
        $this->load->view('admin/admin_master', $data);
    }

    public function group_video_course_member_details($url_name) {
        $data = array();
        $data['active'] = 'detail_group_list';
        $data['url_id'] = $this->super_admin_group_model->get_url_id($url_name);
        $data['url'] = $url_name;

        $data['course_id'] = $this->super_admin_group_model->select_video_course_id_by_url($data['url_id']->url_id);
        $data['student_id'] = $this->super_admin_group_model->select_student_for_that_video_course($data['course_id']->video_management_id);

        if ($data['student_id']) {
            foreach ($data['student_id'] as $val) {
                $data['student_info'][$val->person_id] = $this->super_admin_group_model->select_student_info_person_id($val->person_id);

                $data['person_payment_status'][$val->person_id] = $this->super_admin_group_model->select_payment_status($val->payment_id);
            }
        }
        $data['main_content'] = $this->load->view('admin/group/view_group_video_course_member_details', $data, true);
        $this->load->view('admin/admin_master', $data);
    }

    public function group_note($url_name, $arg = NULL) {
        $data = array();
        $total_post_id = array();
        $data['active_menu'] = 'group';
        $data['active_sub_menu'] = 'detail_group_list';
        if ($arg != NULL) {
            $data['page'] = $arg;
            $number = $arg * 10 - 10;
            $data['serial'] = $number;
        } else {
            $data['page'] = 0;
            $data['serial'] = 0;
            $number = 0;
        }
        $data['url_id'] = $this->super_admin_group_model->get_url_id($url_name);
        $data['url'] = $url_name;
        $user_id = $this->super_admin_group_model->get_url_id($url_name);
        $person_id = $this->session->userdata('person_id');
        $data['check_person_status'] = $this->super_admin_group_model->select_person_role($person_id);

        $data['grp_id'] = $this->super_admin_group_model->select_group_id_for_note($data['url_id']->url_id);


        $data['total_post'] = $this->super_admin_group_model->select_note_info_for_group($data['grp_id']->group_id);
        if ($data['total_post']) {
            foreach ($data['total_post'] as $val) {
                $total_post_id[] = $val->post_id;
            }

            $total_post_id_array = implode(",", $total_post_id);
            $data['post_id_array'] = $total_post_id_array;

            $data['total_note'] = $this->super_admin_group_model->select_total_note_count_for_that_group($total_post_id_array);
            $data['total_post_info'] = $this->super_admin_group_model->select_only_note_info_for_group($total_post_id_array, $number, "");
            if ($data['total_post_info']) {
                foreach ($data['total_post_info'] as $value) {
                    $data['post_info'][$value->post_id] = $this->super_admin_group_model->select_specific_note_info($value->post_id);

                    $data['post_url'][$value->post_id] = $this->super_admin_group_model->select_note_url_value($data['post_info'][$value->post_id]->post_id);

                    $data['person_info'][$value->post_id] = $this->super_admin_group_model->select_note_creator_info($data['post_info'][$value->post_id]->posted_by);
                }
            }
        }
        $data['main_content'] = $this->load->view('admin/group/group_note_details', $data, true);
        $this->load->view('admin/admin_master', $data);
    }

    public function group_alert($url_name, $arg = NULL) {
        $data = array();
        $data['active_menu'] = 'group';
        $data['active_sub_menu'] = 'detail_group_list';
        if ($arg != NULL) {
            $data['page'] = $arg;
            $number = $arg * 10 - 10;
            $data['serial'] = $number;
        } else {
            $data['page'] = 0;
            $data['serial'] = 0;
            $number = 0;
        }
        $data['url_id'] = $this->super_admin_group_model->get_url_id($url_name);
        $data['url'] = $url_name;
        $person_id = $this->session->userdata('person_id');
        $data['check_person_status'] = $this->super_admin_group_model->select_person_role($person_id);
        $data['grp_id'] = $this->super_admin_group_model->select_group_id_for_note($data['url_id']->url_id);

        $data['total_post'] = $this->super_admin_group_model->select_note_info_for_group($data['grp_id']->group_id);


        if ($data['total_post']) {
            foreach ($data['total_post'] as $val) {
                $total_post_id[] = $val->post_id;
            }
            $total_post_id_array = implode(",", $total_post_id);
            $data['total_alert'] = $this->super_admin_group_model->select_total_alert_count_for_that_group($total_post_id_array);
            $data['total_post_info'] = $this->super_admin_group_model->select_only_alert_info_for_group($total_post_id_array, $number, "");
            if ($data['total_post_info']) {
                foreach ($data['total_post_info'] as $value) {
                    $data['post_info'][$value->post_id] = $this->super_admin_group_model->select_specific_alert_info($value->post_id);
                    $data['post_url'][$value->post_id] = $this->super_admin_group_model->select_note_url_value($data['post_info'][$value->post_id]->post_id);
                    $data['person_info'][$value->post_id] = $this->super_admin_group_model->select_note_creator_info($data['post_info'][$value->post_id]->posted_by);
                }
            }
        }
        $data['main_content'] = $this->load->view('admin/group/group_alert_details', $data, true);
        $this->load->view('admin/admin_master', $data);
    }

    public function group_assignment($url_name, $arg = NULL) {
        $data = array();
        $data['active_menu'] = 'group';
        $data['active_sub_menu'] = 'detail_group_list';
        $data['url_id'] = $this->super_admin_group_model->get_url_id($url_name);
        $data['url'] = $url_name;
        $person_id = $this->session->userdata('person_id');
        if ($arg != NULL) {
            $data['page'] = $arg;
            $number = $arg * 10 - 10;
            $data['serial'] = $number;
        } else {
            $data['page'] = 0;
            $data['serial'] = 0;
            $number = 0;
        }
        $data['check_person_status'] = $this->super_admin_group_model->select_person_role($person_id);
        $data['grp_id'] = $this->super_admin_group_model->select_group_id_for_note($data['url_id']->url_id);
        $data['total_post'] = $this->super_admin_group_model->select_note_info_for_group($data['grp_id']->group_id);


        if ($data['total_post']) {
            foreach ($data['total_post'] as $val) {
                $total_post_id[] = $val->post_id;
            }

            $total_post_id_array = implode(",", $total_post_id);
            $data['total_assignment'] = $this->super_admin_group_model->select_total_assignment_count_for_that_group($total_post_id_array);
            $data['total_post_info'] = $this->super_admin_group_model->select_only_assignment_info_for_group($total_post_id_array, $number, "");

            if ($data['total_post_info']) {
                foreach ($data['total_post_info'] as $value) {
                    $data['post_info'][$value->post_id] = $this->super_admin_group_model->select_specific_assignment_info($value->post_id);
                    $data['person_info'][$value->post_id] = $this->super_admin_group_model->select_note_creator_info($data['post_info'][$value->post_id]->posted_by);
                }
            }
        }
        $data['main_content'] = $this->load->view('admin/group/group_assignment_details', $data, true);
        $this->load->view('admin/admin_master', $data);
    }

    public function group_photo($url_name, $arg = NULL) {
        $data = array();
        $data['active_menu'] = 'group';
        $data['active_sub_menu'] = 'detail_group_list';
        if ($arg != NULL) {
            $data['page'] = $arg;
            $number = $arg * 10 - 10;
            $data['serial'] = $number;
        } else {
            $data['page'] = 0;
            $data['serial'] = 0;
            $number = 0;
        }
        $data['url_id'] = $this->super_admin_group_model->get_url_id($url_name);
        $data['url'] = $url_name;
        $person_id = $this->session->userdata('person_id');
        $data['check_person_status'] = $this->super_admin_group_model->select_person_role($person_id);
        $data['grp_id'] = $this->super_admin_group_model->select_group_id_for_note($data['url_id']->url_id);
        $data['total_post'] = $this->super_admin_group_model->select_note_info_for_group($data['grp_id']->group_id);


        if ($data['total_post']) {
            foreach ($data['total_post'] as $val) {
                $total_post_id[] = $val->post_id;
            }

            $total_post_id_array = implode(",", $total_post_id);
            $data['total_photo'] = $this->super_admin_group_model->select_total_photo_count_for_that_group($total_post_id_array);
            $data['total_post_info'] = $this->super_admin_group_model->select_only_photo_info_for_group($total_post_id_array, $number, "");

            if ($data['total_post_info']) {
                foreach ($data['total_post_info'] as $value) {
                    $data['post_info'][$value->post_id] = $this->super_admin_group_model->select_specific_photo_info($value->post_id);
                    $data['person_info'][$value->post_id] = $this->super_admin_group_model->select_note_creator_info($data['post_info'][$value->post_id]->posted_by);
                }
            }
        }
        $data['main_content'] = $this->load->view('admin/group/group_photo_details', $data, true);
        $this->load->view('admin/admin_master', $data);
    }

    public function group_video($url_name, $arg = NULL) {
        $data = array();
        $data['active_menu'] = 'group';
        $data['active_sub_menu'] = 'detail_group_list';
        if ($arg != NULL) {
            $data['page'] = $arg;
            $number = $arg * 10 - 10;
            $data['serial'] = $number;
        } else {
            $data['page'] = 0;
            $data['serial'] = 0;
            $number = 0;
        }
        $data['url_id'] = $this->super_admin_group_model->get_url_id($url_name);
        $data['url'] = $url_name;
        $person_id = $this->session->userdata('person_id');
        $data['check_person_status'] = $this->super_admin_group_model->select_person_role($person_id);
        $data['grp_id'] = $this->super_admin_group_model->select_group_id_for_note($data['url_id']->url_id);
        $data['total_post'] = $this->super_admin_group_model->select_note_info_for_group($data['grp_id']->group_id);


        if ($data['total_post']) {
            foreach ($data['total_post'] as $val) {
                $total_post_id[] = $val->post_id;
            }

            $total_post_id_array = implode(",", $total_post_id);
            $data['total_video'] = $this->super_admin_group_model->select_total_video_count_for_that_group($total_post_id_array);
            $data['total_post_info'] = $this->super_admin_group_model->select_only_video_info_for_group($total_post_id_array, $number, "");

            if ($data['total_post_info']) {
                foreach ($data['total_post_info'] as $value) {
                    $data['post_info'][$value->post_id] = $this->super_admin_group_model->select_specific_video_info($value->post_id);
                    $data['person_info'][$value->post_id] = $this->super_admin_group_model->select_note_creator_info($data['post_info'][$value->post_id]->posted_by);
                }
            }
        }
        $data['main_content'] = $this->load->view('admin/group/group_video_details', $data, true);

        $this->load->view('admin/admin_master', $data);
    }

    public function edit_group_view($group_type_id) {

        $sdata = array();
        $sdata['group_type_id'] = $group_type_id;

        $this->session->set_userdata($sdata);

        redirect('edit-group-type');
    }

    public function edit_group_type() {
        $data = array();
        $group_type_id_temp = $this->session->userdata("group_type_id");
        $decode_group_type_id = str_replace("%F2", "/", $group_type_id_temp);
        $group_type_id = $this->encrypt->decode($decode_group_type_id);
        if (!$group_type_id) {
            redirect("super-admin-manage-group-type");
        }

        $data['active_menu'] = 'group';
        $data['active_sub_menu'] = 'manage_group_type';
        $data['group_type_info'] = $this->super_admin_group_model->select_type_value_type_id($group_type_id);
        $data['main_content'] = $this->load->view('admin/group/edit_group_type', $data, true);
        $this->load->view('admin/admin_master', $data);
    }

    /*
     * START GROUP MANAGEMENT
     */

    public function create_group() {
        $this->load->helper(array('form', 'url'));
        $this->load->library('form_validation');
        $data['active_menu'] = 'group';
        $data['active_sub_menu'] = 'create_group';

        $user_id = $this->session->userdata('person_id');
        $data['login_person_details'] = $this->super_admin_group_model->login_person_details($user_id);
        $data['group_type'] = $this->super_admin_group_model->all_group_type_list();
        $data['main_content'] = $this->load->view('admin/group/add_group_form', $data, true);
        $this->load->view('admin/admin_master', $data);
    }

    public function check_public_group_code($code) {
        $result = $this->super_admin_group_model->check_group_code($code);
        if ($result) {
            echo 1;
        } else {

            echo 2;
        }
    }

    public function check_group_url($code) {

        $result = $this->super_admin_group_model->check_group_url($code);
        if ($result) {
            echo 1;
        } else {
            echo 2;
        }
    }

    public function manage_group($arg = NULL) {
        $data = array();
        $data['active_menu'] = 'group';
        $data['active_sub_menu'] = 'manage_group';

        if ($arg != NULL) {
            $data['page'] = $arg;
            $number = $arg * 10 - 10;
            $data['serial'] = $number;
        } else {
            $data['page'] = 0;
            $data['serial'] = 0;
            $number = 0;
        }
        $person_id = $this->session->userdata('person_id');
        $data['person_info'] = $this->super_admin_group_model->check_person_role($person_id);
        $data['groups'] = $this->super_admin_group_model->select_group($number, '');
        $data['total_group'] = $this->super_admin_group_model->select_total_group_count();

        foreach ($data['groups'] as $v_group) {
            $data['type_name'][$v_group->group_id] = $this->super_admin_group_model->group_type_name($v_group->group_id);
            $data['total_member'][$v_group->group_id] = $this->super_admin_group_model->group_total_member($v_group->group_id);
            $data['url_info'][$v_group->group_id] = $this->super_admin_group_model->select_url_name($v_group->url_id);
            $data['total_member_pending'][$v_group->group_id] = $this->super_admin_group_model->group_total_member_pending($v_group->group_id);
            $data['group_status'][$v_group->group_id] = $this->super_admin_group_model->select_group_status($v_group->group_id);
            //$data['total_quiz'][$v_group->group_id] = $this->super_admin_group_model->group_total_quiz($v_group->group_id);
            $data['total_note'][$v_group->group_id] = $this->super_admin_group_model->group_total_note($v_group->group_id);
            $data['total_assignment'][$v_group->group_id] = $this->super_admin_group_model->group_total_assignment($v_group->group_id);
            $data['total_photo'][$v_group->group_id] = $this->super_admin_group_model->group_total_photo($v_group->group_id);
        }
        $data['this_page'] = count($data['groups']);
        $data['main_content'] = $this->load->view('admin/group/group_list', $data, true);
        $this->load->view('admin/admin_master', $data);
    }

    public function group_information($group_id = NULL) {
        $data = array();
        $data['active'] = 'manage_group';

        $data['group_details'] = $this->super_admin_group_model->group_info($group_id);
        $data['total_member'] = $this->super_admin_group_model->group_total_member($group_id);
        $data['total_member_pending'] = $this->super_admin_group_model->group_total_member_pending($group_id);
        $data['group_member_list'] = $this->super_admin_group_model->select_group_member_list_info($group_id);
        $data['main_content'] = $this->load->view('admin/group/group_detail', $data, true);
        $this->load->view('admin/admin_master', $data);
    }

    public function user_group_details($grp_url) {
        $data = array();
        $data['active_menu'] = 'group';
        $data['active_sub_menu'] = 'detail_group_list';
        $url_id = $this->super_admin_group_model->select_url_id_for_member($grp_url);
        $group_id = $this->super_admin_group_model->select_group_no($url_id->url_id);
        $data['grp_url'] = $grp_url;
        $data['group_info'] = $this->super_admin_group_model->select_group_deltails_info($group_id->group_id);
        $data['grp_member'] = $this->super_admin_group_model->group_total_member($group_id->group_id);
        $data['main_content'] = $this->load->view('admin/group/view_group_details', $data, TRUE);
        $this->load->view('admin/admin_master', $data);
    }

    public function invite_message() {

        $data = array();
        $data['active'] = 'manage_group';
        $data['main_content'] = $this->load->view('admin/group/invite_message', $data, TRUE);
        $this->load->view('admin/admin_master', $data);
    }

    public function group_member_quiz_details() {
        $data = array();
        $data['active_menu'] = 'group';
        $data['active_sub_menu'] = 'detail_group_list';
        $data['main_content'] = $this->load->view('admin/group/group_member_quiz_details', $data, TRUE);
        $this->load->view('admin/admin_master', $data);
    }

    public function group_course_list($url_name) {

        $data = array();
        $data['active_menu'] = 'group';
        $data['active_sub_menu'] = 'detail_group_list';
        $data['url_id'] = $this->super_admin_group_model->get_url_id($url_name);
        $data['url'] = $url_name;
        $data['grp_id'] = $this->super_admin_group_model->select_group_id_for_note($data['url_id']->url_id);
        $data['course_id'] = $this->super_admin_group_model->select_courses_for_group($data['grp_id']->group_id);
        if ($data['course_id']) {
            foreach ($data['course_id'] as $val) {

                $data['group_course_info'][$val->course_id] = $this->super_admin_group_model->select_group_course_info_by_course_id($val->course_id);
                $data['course_url'][$val->course_id] = $this->super_admin_group_model->select_course_url($data['group_course_info'][$val->course_id]->url_id);
                $data['group_course_student'][$val->course_id] = $this->super_admin_group_model->select_group_course_student($val->course_id);
            }
        }




        $data['main_content'] = $this->load->view('admin/group/group_course_list', $data, TRUE);
        $this->load->view('admin/admin_master', $data);
    }

    public function view_test() {

        $data = array();
        $data['active'] = 'manage_group';
        $data['in_active'] = 'left_menu';
        $data['main_content'] = $this->load->view('admin/group/view_test', $data, TRUE);
        $this->load->view('admin/admin_master', $data);
    }

    public function requested_group_member_details($grp_url) {
        $data = array();
        $data['active_menu'] = 'group';
        $data['active_sub_menu'] = 'manage_group';
        $url_id = $this->super_admin_group_model->select_url_id_for_member($grp_url);
        $data['group_id'] = $this->super_admin_group_model->select_group_no($url_id->url_id);
        $person_id = $this->session->userdata('person_id');
        $data['person_info'] = $this->super_admin_group_model->check_person_role($person_id);
        $data['grp_url'] = $grp_url;
        $data['group_pending_member'] = $this->super_admin_group_model->select_all_pending_memeber_info($data['group_id']->group_id);
        if ($data['group_pending_member']) {
            foreach ($data['group_pending_member'] as $val) {
                $data['pending_member_info'][$val->group_member_id] = $this->super_admin_group_model->select_member_info_from_poerson_tbl($val->person_id);
            }
        }
        $data['main_content'] = $this->load->view('admin/group/details_requested_group_member', $data, TRUE);
        $this->load->view('admin/admin_master', $data);
    }

    public function profile() {

        $data = array();
        $data['active'] = 'manage_group';
        $data['in_active'] = 'left_menu';
        $data['main_content'] = $this->load->view('admin/group/profile', $data, TRUE);
        $this->load->view('admin/admin_master', $data);
    }

    public function view_group_member_information($group_url) {        
        $data = array();
        $data['active_menu'] = 'group';
        $data['active_sub_menu'] = 'detail_group_list';
        $url_id = $this->super_admin_group_model->select_url_id_for_member($group_url);
        $group_id = $this->super_admin_group_model->select_group_no($url_id->url_id);
        $data['grp_url'] = $group_url;
        $person_id = $this->session->userdata('person_id');
        $data['person_info'] = $this->super_admin_group_model->check_person_role($person_id);
        $data['group_member'] = $this->super_admin_group_model->select_all_memeber_info($group_id->group_id);
        foreach ($data['group_member'] as $val) {
            $data['member_info'][$val->group_member_id] = $this->super_admin_group_model->select_member_info_from_poerson_tbl($val->person_id);
        }
        $data['main_content'] = $this->load->view('admin/group/view_group_member_detail', $data, true);
        $this->load->view('admin/admin_master', $data);
    }

    public function set_per_page($per_page) {
        $sdata = array();
        $sdata['per_page'] = $per_page;
        $this->session->set_userdata($sdata);
    }

    public function select_group_all_quiz($group_id, $start = null) {
        $data = array();
        $data['active'] = 'manage_group';
        $data['group_details'] = $this->super_admin_group_model->group_info($group_id);
        $data['total_member'] = $this->super_admin_group_model->group_total_member($group_id);
        $data['total_member_pending'] = $this->super_admin_group_model->group_total_member_pending($group_id);

        $data['quiz_list'] = $this->super_admin_group_model->group_all_active_quizes($group_id);
        foreach ($data['quiz_list'] as $v_term) {
            $data['total_question'][$v_term->quiz_id] = count($this->super_admin_quiz_model->select_quiz_quantity_by_id($v_term->quiz_id));
        }
        $data['main_content'] = $this->load->view('admin/group/group_quizes', $data, true);
        $this->load->view('admin/admin_master', $data);
    }

    public function update($group_id) {
        $this->load->helper(array('form', 'url'));
        $this->load->library('form_validation');
        $this->form_validation->set_rules('group_name', 'Group Name', 'trim|required|max_length[50]');
        $this->form_validation->set_rules('group_type', 'Group Type', 'trim|required|max_length[50]');
        $this->form_validation->set_rules('group_other_type', 'Group Type', 'trim|max_length[50]');
        $this->form_validation->set_rules('group_url', 'Group Url', 'trim|required|max_length[50]');
        $this->form_validation->set_rules('group_description', 'Group Description', 'trim');
        $this->form_validation->set_rules('group_public_id', 'group invitation code', 'trim|required');
        $this->form_validation->set_rules('created_by', 'Created Time');

        if ($this->form_validation->run() == FALSE) {
            $data['active'] = 'manage_group';
            $data['group_details'] = $this->super_admin_group_model->group_info($group_id);
            $data['group_type'] = $this->super_admin_group_model->group_type_list();
            $data['resourse_person'] = $this->super_admin_course_model->select_all_available_resource_person();
            $data['main_content'] = $this->load->view('admin/group/edit_group_form', $data, true);
            $this->load->view('admin/admin_master', $data);
        } else {
            $this->super_admin_group_model->update_group_information($group_id);
            $sdata = array();
            $sdata['message'] = 'Group Information Succesfully Updated';
            $this->session->set_userdata($sdata);
            redirect('super_admin_group/manage_group/');
        }
    }

    public function check_group_url_for_edit($code) {

        $group_id = $this->session->userdata('group_id');
        $result = $this->super_admin_group_model->check_group_code($code);
        if ($result && $group_id != $result->group_id) {
            echo 1;
        } else {
            echo 2;
        }
    }

    public function check_public_group_code_for_edit($code) {
        $group_id = $this->session->userdata('group_id');
        $result = $this->super_admin_group_model->check_group_code($code);
        if ($result && $group_id != $result->group_id) {
            echo 1;
        } else {
            echo 2;
        }
    }

    public function view_member_information($group_member_id) {
        $data = array();
        $data['member_info'] = $this->super_admin_model->select_group_member_information_by_id($group_member_id);
        $data['main_content'] = $this->load->view('admin/group/edit_group_member_form', $data, true);
        $this->load->view('admin/admin_master', $data);
    }

    public function make_group_active($group_id) {
        $this->super_admin_group_model->make_group_active($group_id);
        $sdata = array();
        $sdata['message'] = 'Group Updated to Active';
        $this->session->set_userdata($sdata);
        redirect('super_admin_group/manage_group/' . $this->uri->segment(4));
    }

    public function make_group_inactive($group_id) {
        $this->super_admin_group_model->make_group_inactive($group_id);
        $sdata = array();
        $sdata['message'] = 'Group Status Updated to Inactive';
        $this->session->set_userdata($sdata);
        redirect('super_admin_group/manage_group/' . $this->uri->segment(4));
    }

    public function archive_group($group_id) {
        $this->super_admin_group_model->archive_group($group_id);
        $sdata = array();
        $sdata['message'] = 'Group Archived';
        $this->session->set_userdata($sdata);
        redirect('super_admin_group/manage_group/' . $this->uri->segment(4));
    }

    /*
     * END GROUP MANAGEMENT
     */

    public function update_group_member($group_member_id) {

        $this->load->helper(array('form', 'url'));
        $this->load->library('form_validation');
        $data = array();
        $data['member_info'] = $this->super_admin_group_model->select_group_member_information_by_id($group_member_id);
        if ($this->form_validation->run() == FALSE) {
            $data['active'] = 'manage_group';
            $data['main_content'] = $this->load->view('admin/group/edit_group_member_form', $data, true);
            $this->load->view('admin/admin_master', $data);
        } else {
            $this->super_admin_group_model->update_group_member_information($group_member_id);
            $sdata = array();
            $sdata['message'] = 'Group Information Succesfully Updated';
            $this->session->set_userdata($sdata);
            redirect('super_admin_group/manage_group/');
        }
    }

    public function group_member_information($group_member_id) {
        $data = array();
        $data['active'] = 'manage_group';
        $data['member_info'] = $this->super_admin_group_model->select_group_member_information_by_id($group_member_id);
        $data['main_content'] = $this->load->view('admin/group/view_group_member_detail', $data, true);
        $this->load->view('admin/admin_master', $data);
    }

    public function make_group_member_active($group_member_id, $group_id) {
        $this->super_admin_group_model->make_group_member_active($group_member_id);
        $sdata = array();
        $sdata['message'] = 'Group Member Updated to Active';
        $this->session->set_userdata($sdata);
        redirect('super_admin_group/group_information/' . $group_id);
    }

    public function archive_member($group_member_id, $group_id) {
        $this->super_admin_group_model->archive_member($group_member_id);
        $sdata = array();
        $sdata['message'] = 'Group Member Archived';
        $this->session->set_userdata($sdata);
        redirect('super_admin_group/group_information/' . $group_id);
    }

    public function make_group_member_inactive($group_member_id, $group_id) {
        $this->super_admin_group_model->make_group_member_inactive($group_member_id);
        $sdata = array();
        $sdata['message'] = 'Group Member Status Updated to Inactive';
        $this->session->set_userdata($sdata);
        redirect('super_admin_group/group_information/' . $group_id);
    }

    //super admin grpop creat
    /**
     * @Function            : start add_backend_group 
     * @Used IN             : @self
     * @Description         :backend group
     * @Developed By        : Afrin Jahan noumin
     * @Start DateTime      : 15-02-2016 09:38 AM
     * @Status              : available      
     * */
    public function add_backend_group_type() {
        $this->form_validation->set_rules('group_type_name', 'Group type name', 'required|trim');
        $this->form_validation->set_rules('group_type_description', 'Group Type Description');
        $this->form_validation->set_rules('group_type_status', 'group_type_status', 'required|trim');

        if ($this->form_validation->run() == FALSE) {
            $data = array();
            $data['main_content'] = $this->load->view('admin/group/create_group_type', $data, true);
            $this->load->view('admin/admin_master', $data);
        } else {
            $group_type_name = $this->input->post("group_type_name");
            $string2 = preg_replace("/[\s-]+/", " ", $group_type_name);
            $all_group_name = $this->super_admin_group_model->saved_group_name($string2);
            if ($all_group_name) {
                $qdata = array();
                $data = array();
                $qdata['save_group'] = "This type has already been existed.Please type another name.";

                $this->session->set_userdata($qdata);
                $data['main_content'] = $this->load->view('admin/group/create_group_type', $data, true);
                $this->load->view('admin/admin_master', $data);
            } else {
                $this->super_admin_group_model->save_group_type();
                redirect('super-admin-manage-group-type');
            }
        }
    }

    public function add_backend_group() {
        $this->form_validation->set_rules('group_name', 'Group  name', 'required|trim');
        $this->form_validation->set_rules('group_url', 'Group url', 'required|trim|callback_url_check');
        $this->form_validation->set_rules('invitation_code', 'Invitation code', 'required|trim|callback_url_check');

        $this->form_validation->set_rules('user_permission', 'User  Permission', 'required|trim|callback_url_check');
        $this->form_validation->set_rules('group_type_id', 'Group Type name ', 'required');
        $this->form_validation->set_rules('group_status', 'Group Status', 'required|trim');

        if ($this->form_validation->run() == FALSE) {
            redirect('super_admin_group/create_group');
        } else {
            $data = array();
            $url_id = $this->url_model->save_group_url();
            $invitation_code = $this->input->post("invitation_code");
            $string2 = preg_replace("/[\s-]+/", " ", $invitation_code);
            $invitation_code = $this->super_admin_group_model->check_invitation_code($string2);
            if ($invitation_code) {
                $pdata = array();
                $pdata['save_group_inco'] = "This Invitation code has already been exsist.Please try another one";

                $this->session->set_userdata($pdata);
                $data['group_type'] = $this->super_admin_group_model->group_type_list();
                $data['main_content'] = $this->load->view('admin/group/add_group_form', $data, true);
                $this->load->view('admin/admin_master', $data);
            } else {
                $grp_id = $this->super_admin_group_model->save_group($url_id);
                $this->super_admin_group_model->save_group_group_memebr($grp_id);
                redirect('super-admin-manage-group');
            }
        }
    }

    /**
     * @Description         : check person Url validation in server side
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 03-12-2016 09:49 PM       
     * */
    public function url_check($url) {
            $result = $this->url_model->check_url_existence($url);
            if ($result == 1) {
                $this->form_validation->set_message('url_check', "URL Already Exist");
                return false;
            } else {
                $sp = '/[!@\#$%&*()^,_";:]/';
                if (preg_match($sp, $url)) {
                    $this->form_validation->set_message('url_check', "URL Cann't contain any '/[!@#$%&*()^,._;:]/'  if need use '-' Don't use Space");
                    return FALSE;
                } else if (strstr($url, ' ')) {
                    $this->form_validation->set_message('url_check', " Don't use Space if need use '-', alse URL Cann't contain any special carecter like '/[!@#$%&*()^,._;:-]/'");
                    return FALSE;
                } else if (preg_match('/--/', $url)) {
                    $this->form_validation->set_message('url_check', "URL Cann't contain multiple hypen");
                    return FALSE;
                } else if (substr($url, (strlen($url) - 1)) == '-') {
                    $this->form_validation->set_message('url_check', "No hypen allow at the last");
                    return FALSE;
                } else {
                    $this->form_validation->set_message('url_check', "OK");
                    return TRUE;
                }
            }
    }

    public function edit_backend_group_type() {
        $data = array();
        $group_type_id = $this->input->post("group_type_id");
        $data['group_type_info'] = $this->super_admin_group_model->select_type_value_type_id($group_type_id);

        $this->form_validation->set_rules('group_type_name', 'Group type name', 'required|trim|callback_url_check');
        $this->form_validation->set_rules('group_type_description', 'Group Type Description');
        $this->form_validation->set_rules('group_type_status', 'Group type status', 'required|trim');

        if ($this->form_validation->run() == FALSE) {
            $data['main_content'] = $this->load->view('admin/group/edit_group_type', $data, true);
            $this->load->view('admin/admin_master', $data);
        } else {
            $group_type_id = $this->input->post("group_type_id");
            $group_type_name = $this->input->post("group_type_name");
            $string2 = preg_replace("/[\s-]+/", " ", $group_type_name);

            $all_group_name = $this->super_admin_group_model->saved_group_name($string2);
            if ($all_group_name) {
                foreach ($all_group_name as $val) {
                    if ($val->group_type_id == $group_type_id) {
                        $this->super_admin_group_model->update_group_type();
                        redirect('super-admin-manage-group-type');
                    } else {
                        $qdata = array();
                        $qdata['save_group'] = "This type has already been existed.Please type another name.";

                        $this->session->set_userdata($qdata);
                        redirect('edit-group-type');
                    }
                }
            } else {
                $this->super_admin_group_model->update_group_type();
                redirect('super-admin-manage-group-type');
            }
        }
    }

    public function delete_backend_group_type() {
        $group_type_id = $this->input->post('group_type_id', TRUE);
        $group_type_exit = $this->super_admin_group_model->select_group_by_group_typ($group_type_id);
        $person_id = $this->session->userdata('person_id');
        $check_person_status = $this->super_admin_group_model->select_person_role($person_id);
        if ($check_person_status->person_role == 6) {
            $this->super_admin_group_model->delete_group_type($group_type_id);
            if ($group_type_exit) {

                foreach ($group_type_exit as $val_grp) {
                    $this->super_admin_group_model->inactive_all_group($val_grp->group_id);
                    //inactive group memeber
                    $this->super_admin_group_model->inactive_all_group_memeber($val_grp->group_id);
                    //inactive_content
                    $this->super_admin_group_model->inactive_all_content_for_that_group($val_grp->group_id);
                    //inactive_course
                }
            }
            echo 1;
        } else {
            if ($group_type_exit) {
                echo 0;
            } else {
                $this->super_admin_group_model->delete_group_type($group_type_id);
                echo 1;
            }
        }
    }

    public function check_group_url_exists() {
        $url_status = $this->input->post('url_status', TRUE);
        $video_url = $this->input->post('group_url', TRUE);
        if ($url_status == '1') {
            echo $this->url_model->check_url_exists($video_url);
        } else {
            echo $this->url_model->check_url_exists1($video_url);
        }
    }

    public function pending_status_change() {
        $group_type_id = $this->input->post('group_type_id', TRUE);
        $this->super_admin_group_model->change_pending_status($group_type_id);
    }

    public function approved_status_change() {
        $group_type_id = $this->input->post('group_type_id', TRUE);
        $this->super_admin_group_model->change_approved_status($group_type_id);
    }

    public function active_status_change() {
        $group_type_id = $this->input->post('group_type_id', TRUE);
        $this->super_admin_group_model->change_active_status($group_type_id);
        $group_type_exit = $this->super_admin_group_model->select_group_by_group_typ($group_type_id);
        if ($group_type_exit) {
            foreach ($group_type_exit as $val) {
                $this->super_admin_group_model->inactive_all_group($val->group_id);
            }
        }
    }

    public function inactive_status_change() {
        $group_type_id = $this->input->post('group_type_id', TRUE);
        $this->super_admin_group_model->inactive_status_change($group_type_id);
    }

    public function check_invite_code() {
        $invitation_code = $this->input->post("group_public_id");
        $string2 = preg_replace("/[\s-]+/", " ", $invitation_code);
        $check_inco = $this->super_admin_group_model->check_invitation_code($string2);
        if ($check_inco) {
            echo 1;
        }
    }

    public function change_status_public() {
        $group_id = $this->input->post("group_id");
        $this->super_admin_group_model->change_public_status($group_id);
    }

    public function change_status_group() {
        $group_id = $this->input->post("group_id");
        $this->super_admin_group_model->change_group_status($group_id);
    }

    public function change_active_value() {
        $group_id = $this->input->post("group_id");
        $this->super_admin_group_model->change_active_value_for_group($group_id);
    }

    public function change_inactive_value() {
        $group_id = $this->input->post("group_id");
        $this->super_admin_group_model->change_inactive_value_for_group($group_id);
    }

    public function change_archieve_value() {
        $group_id = $this->input->post("group_id");
        $this->super_admin_group_model->change_archieve_value_for_group($group_id);
    }

    public function delete_group_backend() {
        $grp_m = array();
        $group_id = $this->input->post("group_id");
        $person_id = $this->session->userdata('person_id');
        $person_role = $this->super_admin_group_model->check_person_role($person_id);
        if ($person_role->person_role == 6) {
            $this->super_admin_group_model->delete_group($group_id);
            $this->super_admin_group_model->delete_group_member_from_group($group_id);
            //inactive_content
            $this->super_admin_group_model->inactive_all_content_for_that_group($group_id);
        } else {
            $grp_mem = $this->super_admin_group_model->check_group_member($group_id);
            foreach ($grp_mem as $val) {
                $grp_m[] = $val->group_member_id;
            }
            if (count($grp_m) > 1) {
                echo 1;
            } else {
                $this->super_admin_group_model->delete_group($group_id);
            }
        }
    }

    public function edit_group($grp_url) {
        $data = array();
        $data['active_menu'] = 'group';
        $data['active_sub_menu'] = 'manage_group';
        $url_info = $this->super_admin_group_model->select_group_url_id($grp_url);
        $data['url_info'] = $grp_url;
        $data['url_id'] = $url_info;
        $data['edit_group'] = $this->super_admin_group_model->select_group_info($url_info->url_id);
        $data['group_type'] = $this->super_admin_group_model->select_group_type_info($data['edit_group']->group_type_id);
        $data['group_type_all'] = $this->super_admin_group_model->select_all_group_type_info();
        $data['main_content'] = $this->load->view('admin/group/edit_group', $data, true);
        $this->load->view('admin/admin_master', $data);
    }

    public function update_group_value() {

        $data = array();
        $group_url = $this->input->post("group_url");
        $group_url_id = $this->input->post("url_id");
        $group_id = $this->input->post("group_id");
        $url_id = $this->super_admin_group_model->save_edit_group_url($group_url, $group_url_id);
        $grp_id = $this->super_admin_group_model->update_group($group_id, $group_url_id);
        redirect('super-admin-manage-group');
    }

    public function check_edit_invite_code() {
        $group_id = $this->input->post("group_id");
        $invitation_code = $this->input->post("group_public_id");
        $string2 = preg_replace("/[\s-]+/", " ", $invitation_code);
        $check_inco = $this->super_admin_group_model->check_edit_invitation_code($string2, $group_id);
        if ($check_inco) {
            echo 1;
        }
    }

    public function check_edit_url_code() {
        $url_name = $this->input->post("url_name");
        $url_id = $this->input->post("url_id");
        $check_url = $this->super_admin_group_model->check_edit_url($url_name, $url_id);
        if ($check_url) {
            echo 1;
        }
    }

    public function change_active_member_value() {
        $group_member_id = $this->input->post("group_member_id");
        $group_id = $this->input->post("group_id");
        $this->super_admin_group_model->change_active_member_status($group_member_id, $group_id);
    }

    public function change_inactive_member_value() {
        $group_member_id = $this->input->post("group_member_id");
        $group_id = $this->input->post("group_id");
        $this->super_admin_group_model->change_inactive_member_status($group_member_id, $group_id);
    }

    public function change_block_member_value() {
        $group_member_id = $this->input->post("group_member_id");
        $group_id = $this->input->post("group_id");
        $this->super_admin_group_model->change_block_member_status($group_member_id, $group_id);
    }

    public function leave_group_member() {
        $group_member_id = $this->input->post("group_member_id");
        $group_id = $this->input->post("group_id");
        $check_member = $this->super_admin_group_model->check_group_member_person_id($group_member_id);
        $check_group_creator = $this->super_admin_group_model->check_group_creator($group_id);
        if ($check_member->person_id == $check_group_creator->group_created_by) {
            echo 1;
        } else {
            $this->super_admin_group_model->leave_group_member_status($group_member_id, $group_id);
        }
    }

    public function add_requesting_group_member() {
        $group_member_id = $this->input->post("group_member_id");
        $group_id = $this->input->post("group_id");
        $this->super_admin_group_model->change_requesting_group_member($group_member_id, $group_id);
    }

    public function remove_requesting_group_member() {
        $group_member_id = $this->input->post("group_member_id");
        $group_id = $this->input->post("group_id");
        $this->super_admin_group_model->remove_specific_requesting_group_member($group_member_id, $group_id);
    }

    public function block_requesting_group_member() {
        $group_member_id = $this->input->post("group_member_id");
        $group_id = $this->input->post("group_id");
        $this->super_admin_group_model->block_specific_requesting_group_member($group_member_id, $group_id);
    }

    public function active_block_requesting_group_member() {
        $group_member_id = $this->input->post("group_member_id");
        $group_id = $this->input->post("group_id");
        $this->super_admin_group_model->change_block_status_active_requesting_group_member($group_member_id, $group_id);
    }

    public function remove_group_note_from_group() {
        $grp_id = array();
        $post_id = $this->input->post("post_id");
        $group_id = $this->input->post("group_id");

        $person_id = $this->session->userdata('user_id');
        $check_person_role = $this->super_admin_group_model->check_person_role($person_id);
        $check_post_by = $this->super_admin_group_model->check_posted_person_id($post_id);
        $group_creator = $this->super_admin_group_model->check_group_creator_id($group_id);
        if ($check_person_role->person_role == 6 || $check_post_by->posted_by == $person_id) {
            $post_url_id = $this->super_admin_group_model->search_post_from_tbl_post_comment_url($post_id);
            if ($post_url_id) {
                $this->super_admin_group_model->delete_post_from_tbl_post_comment_url($post_url_id->post_comment_url_id);
            }
            $this->super_admin_group_model->remove_post_group_note($post_id);
            $this->super_admin_group_model->remove_group_note($post_id);
        } else if ($group_creator->group_created_by == $person_id && $check_person_role->person_role == 1) {

            $this->super_admin_group_model->remove_post_group_note_by_admin_or_creator($post_id, $group_id);
            $check_all_grp_delete = $this->super_admin_group_model->select_post_visibity_for_all_group($post_id);
            foreach ($check_all_grp_delete as $val) {
                $grp_id[] = $val->group_id;
            }
            $group_id_array = implode(",", $grp_id);
            echo $group_id_array . "<br>";
            $check_post = $this->super_admin_group_model->check_group_visibility_for_that_post($post_id, $group_id_array, $grp_id);
            print_r($check_post);
            if ($check_post == NULL) {
                $this->super_admin_group_model->change_post_status($post_id);
            }
        } else {
            echo 1;
        }
    }

    public function download_assigment_file_authenticate() {
        $person_id = $this->session->userdata('user_id');

        $check_person_role = $this->super_admin_group_model->check_person_role($person_id);
        if ($check_person_role->person_role == 6) {
            echo 1;
        }
    }

    public function download_assignment_file_group($post_id) {
        $post_info = $this->super_admin_group_model->select_specific_post_info($post_id);
        $post_path = $post_info->post_details;
        $file_name = $post_info->post_file_original_name;
        $post_by = $post_info->posted_by;
        $profile_url = $this->post_model->get_profile_url($post_by);
        $file_path = 'content-library/' . $profile_url->url . '/' . $post_path;

        $download_post_path = file_get_contents($file_path);
        $this->load->helper('download');
        force_download($file_name, $download_post_path);
    }

    /**
     * @Function            : view_post_in_group_viedo 
     * @Used IN             : @function-'get_course_value'  super_admin_course[@controller],
     * @Description         : view all kind of post using post ID
     * @                    : #ripon@update1 - view post reply with read/write action
     * @Developed By        : Nowmin Jahan
     * @Start DateTime      : Unknown
     * @Updated Date Time   : 03-03-2016 01:38 AM
     * @Updated By          : Ripon Jaherul      
     * @Status              : available      
     * */
    public function view_post_in_group_viedo($post_id) {
        $data = array();
        $data['active_menu'] = 'group';
        $data['active_sub_menu'] = 'detail_group_list';
        $data['active'] = 'group_video';
        $data['post_value'] = $this->post_model->select_post_by_post_id($post_id);
        $data["person_info"] = $this->super_admin_group_model->select_student_info_person_id($data['post_value']->posted_by);
        $data['post_url'] = $this->post_model->select_post_comment_url($post_id, 1);
        $data['post_function'][$post_id] = $this->post_model->get_post_value_by_post_id($post_id);
        $data['total_comment'][$post_id] = $this->post_model->get_total_first_comment_by_post_id($post_id);

        $data['post_comment'][$post_id] = $this->post_model->get_post_first_comment_by_post_id($post_id);
        foreach ($data['post_comment'][$post_id] as $post_comment_value) {
            $data['comment_url'][$post_comment_value->comment_id] = $this->post_model->select_post_comment_url($post_comment_value->comment_id, 2);

            $data['comment_reply'][$post_comment_value->comment_id] = $this->post_model->get_post_comment_replay_limit_post_comment_id($post_comment_value->comment_id);
            $data['total_comment_reply'][$post_comment_value->comment_id] = $this->post_model->get_total_comment_by_comment_id($post_comment_value->comment_id);
            foreach ($data['comment_reply'][$post_comment_value->comment_id] as $comment_reply_value) {
                $data['reply_comment_url'][$comment_reply_value->comment_id] = $this->post_model->select_post_comment_url($comment_reply_value->comment_id, 2);
                $data['total_nested_reply'][$comment_reply_value->comment_id] = $this->post_model->get_total_comment_by_comment_id($comment_reply_value->comment_id);
            }
        }
        if ($data['post_value']->post_type == 3 || $data['post_value']->post_type == 4 || $data['post_value']->post_type == 5) {
            $profile_url = $this->post_model->get_profile_url($data['post_value']->posted_by);
            $data['file_path'] = 'content-library/' . $profile_url->url . '/' . $data['post_value']->post_details;
        }

        $data['main_content'] = $this->load->view('admin/group/view_video', $data, true);
        $this->load->view('admin/admin_master', $data);
    }

    /**
     * @Function            : view_more_reply 
     * @Used IN             : @function-'self'  
     * @Description         : view more reply  
     * @Developed By        : Copied from - 'post'- @Controller
     * @Start DateTime      : 03-03-2016 01:38 AM      
     * @Status              : available      
     * */
    function view_nested_replies($comment_id, $counter) {
        $data['comment_id'] = $comment_id;
        $data['total_nested_reply'] = $this->post_model->get_total_comment_by_comment_id($comment_id);
        $data['nested_reply'] = $this->post_model->get_post_comment_replay_limit_post_comment_id($comment_id, $counter + 3);
        foreach ($data['nested_reply'] as $nested_reply_value) {
            $data['nested_reply_url'][$nested_reply_value->comment_id] = $this->post_model->select_post_comment_url($nested_reply_value->comment_id, 2);
            $data['total_replies_reply'][$nested_reply_value->comment_id] = $this->post_model->get_total_comment_by_comment_id($nested_reply_value->comment_id);
        }
        echo $this->load->view('admin/group/ajax_group_pages/view_replies', $data, TRUE);
    }

    /**
     * @Function            : view_more_reply 
     * @Used IN             : @function-'self'  
     * @Description         : view more reply  
     * @Developed By        : Copied from - 'post'- @Controller
     * @Start DateTime      : 03-03-2016 01:38 AM      
     * @Status              : available      
     * */
    function view_more_reply($comment_id, $counter) {
        $data['comment_id'] = $comment_id;
        $data['total_comment_replay'] = $this->post_model->get_total_comment_by_comment_id($comment_id);
        $data['comment_reply'] = $this->post_model->get_post_comment_replay_limit_post_comment_id($comment_id, $counter + 3);
        foreach ($data['comment_reply'] as $comment_reply_value) {
            $data['reply_comment_url'][$comment_reply_value->comment_id] = $this->post_model->select_post_comment_url($comment_reply_value->comment_id, 2);
            $data['total_nested_reply'][$comment_reply_value->comment_id] = $this->post_model->get_total_comment_by_comment_id($comment_reply_value->comment_id);
        }
        echo $this->load->view('admin/group/ajax_group_pages/view_comment_reply', $data, TRUE);
    }

    /**
     * @Function            : view_writes 
     * @Used IN             : @function-'self'  
     * @Description         : view more reply  
     * @Developed By        : Copied from - 'post'- @Controller
     * @Start DateTime      : 03-03-2016 01:38 AM      
     * @Status              : available      
     * */
    function view_writes($post_id, $counter) {
        $data['post_id'] = $post_id;
        $data['total_comment'] = $this->post_model->get_total_first_comment_by_post_id($post_id);
        $data['post_comment'] = $this->post_model->get_post_first_comment_by_post_id($post_id, $counter + 5);
        foreach ($data['post_comment'] as $post_comment_value) {
            $data['comment_url'][$post_comment_value->comment_id] = $this->post_model->select_post_comment_url($post_comment_value->comment_id, 2);
            $data['total_comment_reply'][$post_comment_value->comment_id] = $this->post_model->get_total_comment_by_comment_id($post_comment_value->comment_id);
            $data['comment_reply'][$post_comment_value->comment_id] = $this->post_model->get_post_comment_replay_limit_post_comment_id($post_comment_value->comment_id);
            foreach ($data['comment_reply'][$post_comment_value->comment_id] as $comment_reply_value) {
                $data['reply_comment_url'][$comment_reply_value->comment_id] = $this->post_model->select_post_comment_url($comment_reply_value->comment_id, 2);
                $data['total_nested_reply'][$comment_reply_value->comment_id] = $this->post_model->get_total_comment_by_comment_id($comment_reply_value->comment_id);
            }
        }
        echo $this->load->view('admin/group/ajax_group_pages/view_comments', $data, TRUE);
    }

    public function delete_group_course_memeber() {
        $course_id = $this->input->post("course_id");
        $group_id = $this->input->post("group_id");
        $person_id = $this->input->post("person_id");
        $student_id = $this->input->post("student_id");
        $course_student_id = $this->super_admin_group_model->select_student_for_course($course_id, $student_id);
        $group_member_id = $this->super_admin_group_model->select_group_member_for_group($group_id, $person_id);
        $payment_status = $this->super_admin_group_model->select_student_payment_status_for_course($course_student_id->payment_id);

        if ($payment_status->payment_status == 3 || $payment_status->payment_status == 5 || $payment_status->payment_status == 6 || $payment_status->payment_status == 7) {
            $this->super_admin_group_model->delete_select_student_for_course($course_student_id->student_id);
            $this->super_admin_group_model->delete_select_group_member_for_group($group_member_id->group_member_id);
        } else {
            echo 1;
        }
    }

    public function remove_group_media_file_backend() {
        $post_id = $this->input->post("post_id");
        $group_id = $this->input->post("group_id");
        $person_id = $this->session->userdata('user_id');
        $post_info = $this->super_admin_group_model->select_specific_post_info($post_id);
        $post_path = $post_info->post_details;
        $post_by = $post_info->posted_by;
        $profile_url = $this->post_model->get_profile_url($post_by);
        $file_path = 'content-library/' . $profile_url->url . '/' . $post_path;
        $check_person_role = $this->super_admin_group_model->check_person_role($person_id);
        $check_post_by = $this->super_admin_group_model->check_posted_person_id($post_id);
        $group_creator = $this->super_admin_group_model->check_group_creator_id($group_id);
        if ($check_person_role->person_role == 6 || $check_post_by->posted_by == $person_id) {
            if (unlink($file_path)) {

                $post_url_id = $this->super_admin_group_model->search_post_from_tbl_post_comment_url($post_id);
                if ($post_url_id) {
                    $this->super_admin_group_model->delete_post_from_tbl_post_comment_url($post_url_id->post_comment_url_id);
                }
                $this->super_admin_group_model->remove_post_group_note($post_id);
                $this->super_admin_group_model->remove_group_note($post_id);
            }
        } else if ($group_creator->group_created_by == $person_id && $check_person_role->person_role == 1) {

            $this->super_admin_group_model->remove_post_group_note_by_admin_or_creator($post_id, $group_id);
            $check_all_grp_delete = $this->super_admin_group_model->select_post_visibity_for_all_group($post_id);
            foreach ($check_all_grp_delete as $val) {
                $grp_id[] = $val->group_id;
            }
            $group_id_array = implode(",", $grp_id);
            $check_post = $this->super_admin_group_model->check_group_visibility_for_that_post($post_id, $group_id_array, $grp_id);
            if ($check_post == NULL) {
                $this->super_admin_group_model->change_post_status($post_id);
            }
        } else {
            echo 1;
        }
    }

    public function super_admin_search_manage_group() {
        $value = $this->input->post("value");
        $data['page'] = 0;
        $data['serial'] = 0;
        $data['groups'] = $this->super_admin_group_model->select_group(0, $value);
        $data['total_group'] = $this->super_admin_group_model->select_total_group_count();

        foreach ($data['groups'] as $v_group) {
            $data['type_name'][$v_group->group_id] = $this->super_admin_group_model->group_type_name($v_group->group_id);
            $data['total_member'][$v_group->group_id] = $this->super_admin_group_model->group_total_member($v_group->group_id);
            $data['url_info'][$v_group->group_id] = $this->super_admin_group_model->select_url_name($v_group->url_id);




            $data['total_member_pending'][$v_group->group_id] = $this->super_admin_group_model->group_total_member_pending($v_group->group_id);
            $data['group_status'][$v_group->group_id] = $this->super_admin_group_model->select_group_status($v_group->group_id);

            //$data['total_quiz'][$v_group->group_id] = $this->super_admin_group_model->group_total_quiz($v_group->group_id);

            $data['total_note'][$v_group->group_id] = $this->super_admin_group_model->group_total_note($v_group->group_id);
            $data['total_assignment'][$v_group->group_id] = $this->super_admin_group_model->group_total_assignment($v_group->group_id);
            $data['total_photo'][$v_group->group_id] = $this->super_admin_group_model->group_total_photo($v_group->group_id);
        }


        $data['this_page'] = count($data['groups']);
        echo $this->load->view('admin/group/ajax_group_pages/ajax_group_list', $data, true);
    }

    public function super_admin_detail_search_manage_group() {
        $data = array();
        $data['page'] = 0;
        $data['serial'] = 0;
        $value = $this->input->post("value");
        $data['all_group_list'] = $this->super_admin_group_model->select_all_group_list(0, $value);
        $data['total_group_list'] = $this->super_admin_group_model->select_total_all_group_list();
        $person_id = $this->session->userdata('person_id');
        $data['check_person_status'] = $this->super_admin_group_model->select_person_role($person_id);
        foreach ($data['all_group_list'] as $val) {

            $data['grp_url_name'][$val->group_id] = $this->super_admin_group_model->select_all_url_name($val->url_id);
            $data['total_member'][$val->group_id] = $this->super_admin_group_model->group_total_member($val->group_id);
            $data['total_post'][$val->group_id] = $this->super_admin_group_model->total_group_note($val->group_id);
            $data['total_note'][$val->group_id] = $this->super_admin_group_model->select_note_info($data['total_post'][$val->group_id]);
            $data['total_alert'][$val->group_id] = $this->super_admin_group_model->select_alert_info($data['total_post'][$val->group_id]);
            $data['total_assignment'][$val->group_id] = $this->super_admin_group_model->select_assignment_info($data['total_post'][$val->group_id]);
            $data['total_photo'][$val->group_id] = $this->super_admin_group_model->select_photo_info($data['total_post'][$val->group_id]);
            $data['total_video'][$val->group_id] = $this->super_admin_group_model->select_video_info($data['total_post'][$val->group_id]);
            $data['total_course'][$val->group_id] = $this->super_admin_group_model->select_total_course_info($val->group_id);
            $data['total_video_course'][$val->group_id] = $this->super_admin_group_model->select_total_video_course_info($val->group_id);
        }
        echo $this->load->view('admin/group/ajax_group_pages/ajax_detail_group_list', $data, true);
    }

    public function super_admin_search_group_type() {
        $data = array();
        $data['page'] = 0;
        $data['serial'] = 0;
        $value = $this->input->post("value");
        $data['type_value'] = $this->super_admin_group_model->select_limited_type_value(0, $value);
        $data['total_limit_value'] = $this->super_admin_group_model->select_type_value();

        echo $this->load->view('admin/group/ajax_group_pages/ajax_group_type_list', $data, true);
    }

    public function super_admin_group_note_search() {
        $data['page'] = 0;
        $data['serial'] = 0;
        $number = 0;
        $value_search = $this->input->post("value", TRUE);
        $url_name = $this->input->post("url_name", TRUE);
        $data['url_id'] = $this->super_admin_group_model->get_url_id($url_name);
        $data['url'] = $url_name;
        $user_id = $this->super_admin_group_model->get_url_id($url_name);
        $person_id = $this->session->userdata('person_id');
        $data['check_person_status'] = $this->super_admin_group_model->select_person_role($person_id);

        $data['grp_id'] = $this->super_admin_group_model->select_group_id_for_note($data['url_id']->url_id);
        $data['total_post'] = $this->super_admin_group_model->select_note_info_for_group($data['grp_id']->group_id);
        if ($data['total_post']) {
            foreach ($data['total_post'] as $val) {
                $total_post_id[] = $val->post_id;
            }
            $total_post_id_array = implode(",", $total_post_id);

            $data['post_id_array'] = $total_post_id_array;
            $data['total_note'] = $this->super_admin_group_model->select_total_note_count_for_that_group($total_post_id_array);
            $data['total_post_info'] = $this->super_admin_group_model->select_only_note_info_for_group($total_post_id_array, $number, $value_search);
            if ($data['total_post_info']) {
                foreach ($data['total_post_info'] as $value) {
                    $data['post_info'][$value->post_id] = $this->super_admin_group_model->select_specific_note_info($value->post_id);
                    $data['post_url'][$value->post_id] = $this->super_admin_group_model->select_note_url_value($data['post_info'][$value->post_id]->post_id);
                    $data['person_info'][$value->post_id] = $this->super_admin_group_model->select_note_creator_info($data['post_info'][$value->post_id]->posted_by);
                }
            }
        }
        echo $this->load->view('admin/group/ajax_group_pages/group_note_search', $data, true);
    }

    public function super_admin_group_alert_search() {
        $data['page'] = 0;
        $data['serial'] = 0;
        $number = 0;
        $value_search = $this->input->post("value", TRUE);
        $url_name = $this->input->post("url_name", TRUE);
        $data['url_id'] = $this->super_admin_group_model->get_url_id($url_name);
        $data['url'] = $url_name;
        $person_id = $this->session->userdata('person_id');
        $data['check_person_status'] = $this->super_admin_group_model->select_person_role($person_id);
        $data['grp_id'] = $this->super_admin_group_model->select_group_id_for_note($data['url_id']->url_id);

        $data['total_post'] = $this->super_admin_group_model->select_note_info_for_group($data['grp_id']->group_id);


        if ($data['total_post']) {
            foreach ($data['total_post'] as $val) {
                $total_post_id[] = $val->post_id;
            }
            $total_post_id_array = implode(",", $total_post_id);
            $data['total_alert'] = $this->super_admin_group_model->select_total_alert_count_for_that_group($total_post_id_array);
            $data['total_post_info'] = $this->super_admin_group_model->select_only_alert_info_for_group($total_post_id_array, $number, $value_search);
            if ($data['total_post_info']) {
                foreach ($data['total_post_info'] as $value) {
                    $data['post_info'][$value->post_id] = $this->super_admin_group_model->select_specific_alert_info($value->post_id);
                    $data['post_url'][$value->post_id] = $this->super_admin_group_model->select_note_url_value($data['post_info'][$value->post_id]->post_id);
                    $data['person_info'][$value->post_id] = $this->super_admin_group_model->select_note_creator_info($data['post_info'][$value->post_id]->posted_by);
                }
            }
        }

        echo $this->load->view('admin/group/ajax_group_pages/ajax_alert_search', $data, true);
    }

    public function super_admin_group_assignment_search() {
        $data['page'] = 0;
        $data['serial'] = 0;
        $number = 0;
        $value_search = $this->input->post("value", TRUE);
        $url_name = $this->input->post("url_name", TRUE);

        $data['url_id'] = $this->super_admin_group_model->get_url_id($url_name);
        $data['url'] = $url_name;
        $person_id = $this->session->userdata('person_id');

        $data['check_person_status'] = $this->super_admin_group_model->select_person_role($person_id);
        $data['grp_id'] = $this->super_admin_group_model->select_group_id_for_note($data['url_id']->url_id);
        $data['total_post'] = $this->super_admin_group_model->select_note_info_for_group($data['grp_id']->group_id);


        if ($data['total_post']) {
            foreach ($data['total_post'] as $val) {
                $total_post_id[] = $val->post_id;
            }

            $total_post_id_array = implode(",", $total_post_id);
            $data['total_assignment'] = $this->super_admin_group_model->select_total_assignment_count_for_that_group($total_post_id_array);
            $data['total_post_info'] = $this->super_admin_group_model->select_only_assignment_info_for_group($total_post_id_array, $number, $value_search);

            if ($data['total_post_info']) {
                foreach ($data['total_post_info'] as $value) {
                    $data['post_info'][$value->post_id] = $this->super_admin_group_model->select_specific_assignment_info($value->post_id);
                    $data['person_info'][$value->post_id] = $this->super_admin_group_model->select_note_creator_info($data['post_info'][$value->post_id]->posted_by);
                }
            }
        }
        echo $this->load->view('admin/group/ajax_group_pages/ajax_group_assignment_search', $data, true);
    }

    public function super_admin_group_photo_search() {
        $data['page'] = 0;
        $data['serial'] = 0;
        $number = 0;
        $value_search = $this->input->post("value", TRUE);
        $url_name = $this->input->post("url_name", TRUE);
        $data['url_id'] = $this->super_admin_group_model->get_url_id($url_name);
        $data['url'] = $url_name;
        $person_id = $this->session->userdata('person_id');
        $data['check_person_status'] = $this->super_admin_group_model->select_person_role($person_id);
        $data['grp_id'] = $this->super_admin_group_model->select_group_id_for_note($data['url_id']->url_id);
        $data['total_post'] = $this->super_admin_group_model->select_note_info_for_group($data['grp_id']->group_id);


        if ($data['total_post']) {
            foreach ($data['total_post'] as $val) {
                $total_post_id[] = $val->post_id;
            }

            $total_post_id_array = implode(",", $total_post_id);
            $data['total_photo'] = $this->super_admin_group_model->select_total_photo_count_for_that_group($total_post_id_array);
            $data['total_post_info'] = $this->super_admin_group_model->select_only_photo_info_for_group($total_post_id_array, $number, $value_search);

            if ($data['total_post_info']) {
                foreach ($data['total_post_info'] as $value) {
                    $data['post_info'][$value->post_id] = $this->super_admin_group_model->select_specific_photo_info($value->post_id);
                    $data['person_info'][$value->post_id] = $this->super_admin_group_model->select_note_creator_info($data['post_info'][$value->post_id]->posted_by);
                }
            }
        }
        echo $this->load->view('admin/group/ajax_group_pages/ajax_group_photo_search', $data, true);
    }

    public function super_admin_group_video_search() {
        $data['page'] = 0;
        $data['serial'] = 0;
        $number = 0;
        $value_search = $this->input->post("value", TRUE);
        $url_name = $this->input->post("url_name", TRUE);
        $data['url_id'] = $this->super_admin_group_model->get_url_id($url_name);
        $data['url'] = $url_name;
        $person_id = $this->session->userdata('person_id');
        $data['check_person_status'] = $this->super_admin_group_model->select_person_role($person_id);
        $data['grp_id'] = $this->super_admin_group_model->select_group_id_for_note($data['url_id']->url_id);
        $data['total_post'] = $this->super_admin_group_model->select_note_info_for_group($data['grp_id']->group_id);


        if ($data['total_post']) {
            foreach ($data['total_post'] as $val) {
                $total_post_id[] = $val->post_id;
            }

            $total_post_id_array = implode(",", $total_post_id);
            $data['total_video'] = $this->super_admin_group_model->select_total_video_count_for_that_group($total_post_id_array);
            $data['total_post_info'] = $this->super_admin_group_model->select_only_video_info_for_group($total_post_id_array, $number, $value_search);

            if ($data['total_post_info']) {
                foreach ($data['total_post_info'] as $value) {
                    $data['post_info'][$value->post_id] = $this->super_admin_group_model->select_specific_video_info($value->post_id);
                    $data['person_info'][$value->post_id] = $this->super_admin_group_model->select_note_creator_info($data['post_info'][$value->post_id]->posted_by);
                }
            }
        }
        echo $this->load->view('admin/group/ajax_group_pages/ajax_group_video_search', $data, true);
    }

// super admin group content status change works by afrin jahan noumin
    public function super_admin_group_note_active_inactive() {
        $post_id = $this->input->post("post_id", TRUE);
        $post_status = $this->input->post("post_status", TRUE);
        $changing_status = $this->super_admin_group_model->change_group_note_status($post_id, $post_status);
        echo $changing_status;
    }

// end super admin group content status change works by afrin jahan noumin

    /* @Function                : end add_backend_group 
     * @Used IN             : @self
     * @Description         :backend group
     * @Developed By        : Afrin Jahan noumin
     * @Start DateTime      : 15-02-2016 09:38 AM
     * @Status              : available      
     * */
    //-----------end---------afrin-------------//
    //super admin group end
}
