<?php

defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * Description => 1. Add Course with all validation
 *                2. Edit Course with all validation
 *                3. Manage Course (Active, inactive...) with pagination
 *
 * @author=> Md Jaherul Islam
 */
class Super_Admin_Course extends TT_admin_login {

    public function __construct() {
        parent::__construct();
    }

    /*
      -----------@@@RIPON@ Start Add Course Part(12-07-16)----------------------------------
     */

    /**
     * @Function            : add_course 
     * @Used IN             : @function-'Self'  super_admin_course[@controller],
     * @Description         : Add Course 
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 18-01-2016 01:38 PM
     * @Updated Date Time   : 14-07-2016 10:17 AM
     * @Updated By          : MD Jaherul Islam     
     * @Parameter           : NULL
     * @View                : None
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : available      
     * */
    public function add_course() {
        $person_id = $this->session->userdata('person_id');
        // Cheack add COurse Validation
        $this->check_add_course_validation();

        if ($this->form_validation->run() == FALSE) {
            $data = Array();
            $course_data = $this->super_admin_course_model->get_informaton_for_add_course($data);
            $course_data['main_content'] = $this->load->view('admin/course/add_course_form', $course_data, true);
            $this->load->view('admin/admin_master', $course_data);
        } else {
            $menu_id = $this->input->post('menu_id', TRUE);
            $course_url_id = $this->url_model->save_course_url($menu_id);
            $this->super_admin_course_model->save_course_information($person_id, $course_url_id);
            redirect('admin/manage-course');
        }
    }

    /**
     * @Function            : check_add_course_validation 
     * @Used IN             : @function-'add_course'    super_admin_course[@Controller]
     * @Description         : check add course validation
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 14-07-2016 10:27 AM  
     * @Parameter           : NULL
     * @Return              : NULL    
     * @Status              : Available        
     * */
    function check_add_course_validation() {
        $this->form_validation->set_rules('course_name', 'Course Name', 'required|trim');
        $this->form_validation->set_rules('course_url', 'Course Url', 'required|trim|callback_course_url_check');
        $this->form_validation->set_rules('course_start_date', 'Course Start Date', 'callback_check_date_status');
        $this->form_validation->set_rules('course_finished_date', 'Course Finished Date', 'callback_check_date_status|callback_compare_with_start_date');
        $this->form_validation->set_rules('last_date_of_registration', 'Last Date of Registration', 'callback_check_date_status|callback_compare_with_end_date');
        // Check validation for add course more field
        $this->course_common_field_validation();
    }

    /*
      -----------@@@RIPON@ End Add Course Part(12-07-16)----------------------------------
     */




    /*
      -----------@@@RIPON@ Start Edit Course Part(06-08-16)----------------------------------
     */

    /**
     * @Function            : edit_course 
     * @Used IN             : @function-'Self'  super_admin_course[@controller],
     * @Description         : Edit course information and check all kind of validation
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 06-08-2016 03:17 PM
     * @Parameter           : $course_url[STRING]
     * @Return              : NULL      
     * @Status              : available      
     * */
    function edit_course($course_url) {
        $data = Array();
        $data['course_info'] = $this->user_course_model->get_course_information_with_url_by_course_url($course_url);
        $data['course_creator_info'] = $this->person_model->get_single_person_information_by_person_id($data['course_info']->course_creator_id);
        if (!$data['course_info']) {
            redirect('admin/manage-course');
        }
        $course_data = $this->super_admin_course_model->get_informaton_for_edit_course($data);

        $this->check_edit_course_validation($data);

        if ($this->form_validation->run() == FALSE) {
            $course_data['main_content'] = $this->load->view('admin/course/edit_course_form', $course_data, true);
            $this->load->view('admin/admin_master', $course_data);
        } else {
            $this->super_admin_course_model->update_course_information($course_data);
            redirect('admin/manage-course');
        }
    }

    /**
     * @Function            : check_edit_course_validation 
     * @Used IN             : @function-'edit_course'    this[@controller],
     * @Description         : Check Edit Course Validation
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 07-08-2016 12:36 PM
     * @Parameter           : $data[Array]
     * @Return              : NULL      
     * @Status              : available      
     * */
    function check_edit_course_validation($data) {
        $this->form_validation->set_rules('edit_course_name', 'Course Name', 'required|trim');

        if ($this->input->post('course_url', TRUE) != $data['course_info']->url) {
            $this->form_validation->set_rules('course_url', 'Course Url', 'required|trim|callback_course_url_check');
        }
        if ($this->input->post('course_start_date', TRUE) != $data['course_info']->course_start_date) {
            $this->form_validation->set_rules('course_start_date', 'Course Start Date', 'callback_check_date_status');
        }
        if ($this->input->post('course_finished_date', TRUE) != $data['course_info']->course_finished_date) {
            $this->form_validation->set_rules('course_finished_date', 'Course Finished Date', 'callback_check_date_status|callback_compare_with_start_date');
        }

        if ($this->input->post('last_date_of_registration', TRUE) != $data['course_info']->last_date_of_registration) {
            $this->form_validation->set_rules('last_date_of_registration', 'Last Date of Registration', 'callback_check_date_status|callback_compare_with_end_date');
        }

        // Check validation for Edit course more field
        $this->course_common_field_validation();
    }

    /*
      -----------@@@RIPON@ End Edit Course Part(16-07-16)----------------------------------
     */

    /*
      -----------@@@RIPON@ Start Manage Course Part(03-08-16)----------------------------------
     */

    /**
     * @Function            : manage_course 
     * @Used IN             : @function-'admin/course/manage_course.php'
     * @Description         : View and Manage all Course
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 03-08-2016 12:51 PM 
     * @Parameter           : $arg [Integer]
     * @Return              : NULL            
     * @Status              : available      
     * */
    function manage_course($arg = NULL) {
        $data = $s_data = Array();
        $data['active_menu'] = 'course';
        $data['active_sub_menu'] = 'manage_course';
        $page_number = 1;

        if ($arg == NULL) {
            $data['search_input'] = $this->session->userdata('sess_course_name_notification');
            $this->utility_model->remove_session_data('sess_course_status', 'sess_course_sort_by', 'sess_course_search_input', 'sess_course_name_notification');
        } else {
            $data['search_input'] = $this->session->userdata('sess_course_search_input');
        }
        if ($arg == 'asc' || $arg == 'desc') {
            $s_data['sess_course_sort_by'] = $arg;
            $this->session->set_userdata($s_data);
        } else {
            $page_number = ($arg == '') ? 1 : $arg;
        }

        $data['status'] = $this->session->userdata('sess_course_status');
        $data['sort_by'] = $this->session->userdata('sess_course_sort_by');

        $course_data = $this->super_admin_course_model->view_course_info_for_manage_course($data, $page_number, $data['search_input'], $data['status'], $data['sort_by']);
        $course_data['main_content'] = $this->load->view('admin/course/manage_course', $course_data, true);
        $this->load->view('admin/admin_master', $course_data);
    }

    /**
     * @Function            : course_value_by_status 
     * @Used IN             : @function-'admin/course/manage_course.php'
     * @Description         : View course by status
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 06-08-2016 10:51 AM 
     * @Parameter           : $status[INTEGER]
     * @Return              : NULL            
     * @Status              : available      
     * */
    function course_value_by_status($status1) {
        if ($this->input->is_ajax_request()) {
            $data = $s_data = Array();
            $s_data['sess_course_status'] = ($status1 == 0) ? '' : $status1;
            $this->session->set_userdata($s_data);
            $data['search_input'] = $this->session->userdata('sess_course_search_input');
            $data['sort_by'] = $this->session->userdata('sess_course_sort_by');
            $course_data = $this->super_admin_course_model->view_course_info_for_manage_course($data, 1, $data['search_input'], $s_data['sess_course_status'], $data['sort_by']);
            echo $this->load->view('admin/course/ajax_page/view_course', $course_data, TRUE);
        } else {
            redirect('admin/manage-course');
        }
    }

    /**
     * @Function            : search_course 
     * @Used IN             : @function-'admin/course/manage_course.php'
     * @Description         : search Course
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 06-08-2016 12:10 PM 
     * @Parameter           : Null
     * @Return              : NULL            
     * @Status              : available      
     * */
    function search_course() {
        if ($this->input->is_ajax_request()) {
            $search_input = $this->input->post('search_input', TRUE);
            $s_data['sess_course_search_input'] = $search_input;
            $this->session->set_userdata($s_data);
            $data['sort_by'] = $this->session->userdata('sess_course_sort_by');
            $data['status'] = $this->session->userdata('sess_course_status');
            $course_data = $this->super_admin_course_model->view_course_info_for_manage_course($data, 1, $s_data['sess_course_search_input'], $data['status'], $data['sort_by']);
            echo $this->load->view('admin/course/ajax_page/view_course', $course_data, TRUE);
        } else {
            redirect('admin/manage-course');
        }
    }

    /**
     * @Function            : chnage_course_permission 
     * @Used IN             : @function-'admin/course/manage_course.php'
     * @Description         : Change Course Resource person Permission
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 04-08-2016 09:50 PM 
     * @Parameter           : $course_id, $status
     * @Return              : NULL            
     * @Status              : available      
     * */
    function chnage_course_permission($course_id, $status) {
        if ($this->input->is_ajax_request()) {
            $data = Array();
            $person_id = $this->session->userdata('person_id');
            $data['course_resource_person_edit'] = ($status == 'yes') ? 1 : 2;
            $this->utility_model->update_information_in_database('tbl_course', 'course_id', $course_id, $data);
            $course_info = $this->user_course_model->get_course_information_with_url_by_course_id($course_id);
            // save course notification for change permission 
            $notification_type = 9; // for course permission
            $this->notification_course_model->save_course_status_change_notification($course_info, $person_id, $notification_type);
            echo json_encode($course_info);
        } else {
            redirect('admin/manage-course');
        }
    }

    /**
     * @Function            : chnage_course_upcomming_status 
     * @Used IN             : @function-'admin/course/manage_course.php'
     * @Description         : Change Course Upcomming Status
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 04-08-2016 10:23 PM 
     * @Parameter           : $course_id, $status
     * @Return              : NULL            
     * @Status              : available      
     * */
    function chnage_course_upcomming_status($course_id, $status) {
        if ($this->input->is_ajax_request()) {
            $data = Array();
            $person_id = $this->session->userdata('person_id');
            $data['upcoming_course'] = ($status == 'yes') ? 1 : 2;
            $this->utility_model->update_information_in_database('tbl_course', 'course_id', $course_id, $data);
            $course_info = $this->user_course_model->get_course_information_with_url_by_course_id($course_id);
            // save course notification for change permission 
            $notification_type = 10; // for course upcomming status
            $notification_id = $this->notification_course_model->save_course_status_change_notification($course_info, $person_id, $notification_type);
            $this->mailer_model->save_course_status_change_email($notification_id, $person_id, $course_info);
            echo json_encode($course_info);
        } else {
            redirect('admin/manage-course');
        }
    }

    /**
     * @Function            : change_course_status 
     * @Used IN             : @function-'admin/course/manage_course.php'
     * @Description         : Change Course Status
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 04-08-2016 10:23 PM 
     * @Parameter           : $course_id, $status
     * @Return              : NULL            
     * @Status              : available      
     * */
    function change_course_status($course_id, $status) {
        if ($this->input->is_ajax_request()) {

            if ($status == 'delete') {
                $course_info = $this->user_course_model->get_course_information_with_url_by_course_id($course_id);
                $this->super_admin_course_model->delete_course($course_info);
            } else {
                $data = Array();
                $person_id = $this->session->userdata('person_id');
                $data['course_status'] = $status;
                $this->utility_model->update_information_in_database('tbl_course', 'course_id', $course_id, $data);

                $course_info = $this->user_course_model->get_course_information_with_url_by_course_id($course_id);
                $notification_type = $this->notification_course_model->get_notification_type($status); // for course upcomming status
                $notification_id = $this->notification_course_model->save_course_status_change_notification($course_info, $person_id, $notification_type);
                $this->mailer_model->save_course_status_change_email($notification_id, $person_id, $course_info);
                echo json_encode($course_info);
            }
        } else {
            redirect('admin/manage-course');
        }
    }

    /**
     * @Function            : view_course_register_student 
     * @Used IN             : @function-'admin/course/manage_course.php'
     * @Description         : view course register student
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 01-09-2016 05:15 PM 
     * @Parameter           : $course_url
     * @Return              : NULL            
     * @Status              : available      
     * */
    function view_course_register_student($course_url) {
        $data = $date_data = Array();
        $data['active_menu'] = 'course';
        $data['active_sub_menu'] = 'manage_course';
        $page_number = 1;
        $this->utility_model->remove_session_data('sess_start_date', 'sess_end_date');
        $data['course_info'] = $this->user_course_model->get_course_information_with_url_by_course_url($course_url);
        $course_data = $this->super_admin_course_model->view_course_register_student_info($data, $date_data, $page_number);
        $course_data['main_content'] = $this->load->view('admin/course/course_register_student', $course_data, true);
        $this->load->view('admin/admin_master', $course_data);
    }

    /**
     * @Function            : remove_course_register_student 
     * @Used IN             : @function-'admin/course/manage_course.php'
     * @Description         : remove course registered student
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 01-09-2016 05:50 PM 
     * @Updated By          : Md Mashqur Ul Alam [25-02-17]
     * @Parameter           : Null
     * @Return              : NULL            
     * @Status              : available      
     * */
    function remove_course_register_student() {
        if ($this->input->is_ajax_request()) {
            $roll_number = $this->input->post('roll_number', TRUE);
            $student_info = $this->utility_model->get_single_table_information('*', 'tbl_student', 'student_roll_number', $roll_number); 
            if ($student_info->student_type == 1) {
                $notification_info = $this->notification_model->get_single_notification_info(8, $student_info->student_type_id, $student_info->person_id);
                $this->utility_model->delete_information_in_database('tbl_notification', 'notification_id', $notification_info->notification_id);
                $this->utility_model->delete_information_in_database('tbl_notification_type_info', 'notification_id', $notification_info->notification_id);
            }            
            $this->course_model->remove_batch_assign_student($student_info->student_id);
            $this->utility_model->delete_information_in_database('tbl_student', 'student_roll_number', $roll_number);
        } else {
            redirect('admin/manage-course');
        }
    }

    /**
     * @Function            : register_course_student_pagination 
     * @Used IN             : @function-'admin/course/manage_course.php'
     * @Description         : register course student pagination
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 01-09-2016 06:07 PM 
     * @Parameter           : Null
     * @Return              : NULL            
     * @Status              : available      
     * */
    function register_course_student_pagination() {
        if ($this->input->is_ajax_request()) {
            $data = $date_data = Array();
            $course_id = $this->input->post('course_id', TRUE);
            if ($this->session->userdata('sess_start_date') != '') {
                $date_data['sess_start_date'] = $this->session->userdata('sess_start_date');
                $date_data['sess_end_date'] = $this->session->userdata('sess_end_date');
            }
            $page_number = $this->input->post('page_number', TRUE);
            $data['course_info'] = $this->user_course_model->get_course_infomation_by_course_id($course_id);
            $course_date = $this->super_admin_course_model->view_course_register_student_info($data, $date_data, $page_number);
            echo $this->load->view('admin/course/ajax_page/course_register_student', $course_date, TRUE);
        } else {
            redirect('admin/manage-course');
        }
    }

    /**
     * @Function            : view_register_course_student_by_date 
     * @Used IN             : @function-'admin/course/manage_course.php'
     * @Description         : register course student usinf date different
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 22-09-2016 11:40 AM 
     * @Parameter           : Null
     * @Return              : NULL            
     * @Status              : available      
     * */
    function view_register_course_student_by_date() {
        if ($this->input->is_ajax_request()) {
            $data = Array();
            $date_data['sess_start_date'] = $this->input->post('start_date', TRUE);
            $date_data['sess_end_date'] = $this->input->post('end_date', TRUE);
            $this->session->set_userdata($date_data);

            $course_url = $this->input->post('course_url', TRUE);
            $page_number = 1;
            $data['course_info'] = $this->user_course_model->get_course_information_with_url_by_course_url($course_url);
            $course_date = $this->super_admin_course_model->view_course_register_student_info($data, $date_data, $page_number);
            echo $this->load->view('admin/course/ajax_page/course_register_student', $course_date, TRUE);
        } else {
            redirect('admin/manage-course');
        }
    }

    /*
      -----------@@@RIPON@ End Manage Course Part(03-08-16)----------------------------------
     */


    /*
      -----------@@@RIPON@ Start Course Common Part(07-08-16)----------------------------------
     */

    /**
     * @Function            : course_common_field_validation 
     * @Used IN             : @function-'add_course'       this[@controller],
     * @                    : @function-'edit_course'      this[@controller],
     * @Description         : Add and Edit Course common field validation
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 18-07-2016 01:38 PM
     * @Parameter           : NULL
     * @Return              : NULL    
     * @Status              : available      
     * */
    function course_common_field_validation() {
        $this->form_validation->set_rules('menu_id', 'Menu ID');
        $this->form_validation->set_rules('parent_topic_id', 'Parent Topic', 'required');
        $this->form_validation->set_rules('topic_id', 'Topic', 'required');
        $this->form_validation->set_rules('resource_person_id', 'Resource Person', 'required');
        $this->form_validation->set_rules('course_level', 'Course Level', 'required');
        $this->form_validation->set_rules('number_of_classes', 'Number of Class', 'required|trim|integer|numeric|greater_than[0]|less_than[100]');
        $this->form_validation->set_rules('class_hour_per_day', 'Class Hour Per Day', 'required|trim|numeric|greater_than[0]|less_than[600]');
        $this->form_validation->set_rules('course_author', 'Course Author');
        $this->form_validation->set_rules('class_time', 'Class Time');
        $this->form_validation->set_rules('course_days', 'Course Days', 'callback_check_course_days');
        $this->form_validation->set_rules('course_meta_title', 'Course Meta Title');
        $this->form_validation->set_rules('course_meta_keywords', 'Course Meta Keyword', 'callback_check_empty_course_meta_keyword');
        $this->form_validation->set_rules('course_meta_description', 'Course Meta Description');
        $this->form_validation->set_rules('course_training_objectives', 'Course Training Objectives');
        $this->form_validation->set_rules('course_training_outline', 'Course Training Outline');
        $this->form_validation->set_rules('course_language', 'Course Language', 'required');
        $this->form_validation->set_rules('course_access_level', 'Course Access Level', 'required');

        $this->course_common_more_field_validation();
    }

    /**
     * @Function            : course_common_field_validation 
     * @Used IN             : @function-'course_common_field_validation'       this[@controller]
     * @Description         : Add and Edit Course common field validation [Excluding for (must 20 line function)]
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 18-07-2016 01:38 PM
     * @Parameter           : NULL
     * @Return              : NULL    
     * @Status              : available      
     * */
    function course_common_more_field_validation() {
        $this->form_validation->set_rules('course_rating', 'Course Rating', 'callback_check_rating');
        $this->form_validation->set_rules('course_type', 'Course Type', 'required');

        $course_type = $this->input->post('course_type', TRUE);
        if ($course_type == '1') {
            $this->form_validation->set_rules('course_price_currency', 'Course Price Currency', 'required');
            $this->form_validation->set_rules('course_price', 'Course Price', 'required|trim|numeric|greater_than[0]');
        }

        $this->form_validation->set_rules('course_status', 'Course Status', 'required');
        $this->form_validation->set_rules('course_resource_person_edit', 'course_resource_person_edit');
        $this->form_validation->set_rules('course_resource_person_view_invoice', 'course_resource_person_view_invoice');
        $this->form_validation->set_rules('upcoming_course', 'upcoming_course');
        $this->form_validation->set_rules('course_resource_person_pay_invoice', 'course_resource_person_pay_invoice');
    }

    /**
     * @Function            : view_child_topic 
     * @Used IN             : @function-'admin/course/add_course_from.php'
     * @Description         : view child topic using parent topic ID
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 14-07-2016 10:27 AM  
     * @Parameter           : $topic_id[INTEGER],$person_id[INTEGER]
     * @Return              : NULL    
     * @Status              : Available        
     * */
    function view_child_topic($topic_id, $person_id = null) {
        if ($this->input->is_ajax_request()) {
            $topic_info = $this->topic_model->get_all_child_topic_by_parent_topic_id($topic_id, $person_id);
            echo json_encode($topic_info);
        } else {
            redirect('super-admin');
        }
    }

    /**
     * @Function            : course_url_check 
     * @Used IN             : @function-'check_add_course_validation'    super_admin_course[@Controller]
     * @Description         : check course url
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 14-07-2016 10:33 AM  
     * @Parameter           : $course_url[STRING]
     * @Return              : NULL    
     * @Status              : Available        
     * */
    public function course_url_check($course_url) {
        $sp = '/[!@#$%&*()^,._;:]/';
        if (preg_match($sp, $course_url)) {
            $this->form_validation->set_message('course_url_check', get_message('url_specual_char'));
            return FALSE;
        } else if (preg_match('/[A-Z]/', $course_url)) {
            $this->form_validation->set_message('course_url_check', get_message('url_uppercase_check'));
            return FALSE;
        } else if (strstr($course_url, ' ')) {
            $this->form_validation->set_message('course_url_check', get_message('url_character_hypen'));
            return FALSE;
        } else if ($this->url_model->check_url_existence($course_url) == 1) {
            $this->form_validation->set_message('course_url_check', get_message('url_exist'));
            return FALSE;
        } else {
            return TRUE;
        }
    }

    /**
     * @Function            : check_course_url 
     * @Used IN             : @function-'user/admin/add_course_from.php'
     * @Description         : check course url existence
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 12-07-2016 10:29 AM  
     * @Parameter           : NULL
     * @Return              : NULL    
     * @Status              : Available        
     * */
    function check_course_url() {
        if ($this->input->is_ajax_request()) {
            $course_url = $this->input->post('course_url', TRUE);
            echo $this->url_model->check_url_existence($course_url);
        } else {
            redirect('super-admin');
        }
    }

    /**
     * @Function            : make_new_course_url 
     * @Used IN             : @function-'user/admin/add_course_from.php'
     * @Description         : make new course url
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 12-07-2016 10:34 AM  
     * @Parameter           : NULL
     * @Return              : NULL    
     * @Status              : Available        
     * */
    function make_new_course_url() {
        if ($this->input->is_ajax_request()) {
            $course_url = $this->input->post('course_url', TRUE);
            echo $this->url_model->make_existence_url($course_url);
        } else {
            redirect('super-admin');
        }
    }

    /**
     * @Function            : check_date_status 
     * @Used IN             : @function-'check_add_course_validation'     this[@controller],
     * @                    : @function-'edit_course'    this[@controller]
     * @Description         : check date status if date insert before today  
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 02-02-2016 01:38 PM
     * @Parameter           : $date[DATETIME]
     * @Return              : TRUE/FALSE
     * @Status              : available      
     * */
    public function check_date_status($date) {
        if ($date == '') {
            return TRUE;
        } else {
            $today = date('Y-m-d', strtotime(gmdate('Y-m-d')) - $this->session->userdata('time_offset'));
            if ($date >= $today) {
                return TRUE;
            } else {
                $this->form_validation->set_message('check_date_status', get_message('date_start_check'));
                return FALSE;
            }
        }
    }

    /**
     * @Function            : compare_with_start_date 
     * @Used IN             : @function-'check_add_course_validation'     this[@controller]
     * @Description         : compare start date with End Date
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 14-07-2016 10:43 AM  
     * @Parameter           : $date[DATETIME]
     * @Return              : TRUE/FALSE    
     * @Status              : Available        
     * */
    public function compare_with_start_date($date) {
        $start_date = $this->input->post('course_start_date', TRUE);
        if ($start_date) {
            if ($start_date <= $date) {
                return TRUE;
            } else {
                $this->form_validation->set_message('compare_with_start_date', get_message('date_compare_with_end_date'));
                return FALSE;
            }
        }
    }

    /**
     * @Function            : compare_with_end_date 
     * @Used IN             : @function-'check_add_course_validation'     this[@controller]
     * @Description         : compare end date with course finished Date
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 14-07-2016 10:45 AM  
     * @Parameter           : $date[DATETIME]
     * @Return              : TRUE/FALSE    
     * @Status              : Available        
     * */
    public function compare_with_end_date($date) {
        $end_date = $this->input->post('course_finished_date', TRUE);
        if ($end_date) {
            if ($end_date >= $date) {
                return TRUE;
            } else {
                $this->form_validation->set_message('compare_with_end_date', get_message('date_reg_compare_with_end_date'));
                return FALSE;
            }
        }
    }

    /**
     * @Function            : check_course_days 
     * @Used IN             : @function-'check_add_course_validation'     this[@controller]
     * @Description         : check course days validation
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 14-07-2016 10:47 AM  
     * @Parameter           : Null
     * @Return              : TRUE/FALSE    
     * @Status              : Available        
     * */
    public function check_course_days() {
        if ($this->input->post('course_days', TRUE)) {
            $days = array('Saturday', 'Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday');
            $course_days = $this->input->post('course_days', TRUE);
            foreach ($course_days as $value) {
                if (in_array($value, $days)) {
                    return TRUE;
                } else {
                    $this->form_validation->set_message('check_course_days', get_message('course_days_check'));
                    return FALSE;
                }
            }
        }
    }

    /**
     * @Function            : check_empty_course_meta_keyword 
     * @Used IN             : @function-'check_add_course_validation'     this[@controller]
     * @Description         : check empty course meta keyword
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 14-07-2016 10:49 AM  
     * @Parameter           : Null
     * @Return              : TRUE/FALSE    
     * @Status              : Available        
     * */
    public function check_empty_course_meta_keyword() {
        if ($this->input->post('course_meta_keywords', TRUE)) {
            $course_meta_keywords1 = $this->input->post('course_meta_keywords', TRUE);
            $course_meta_keywords = array_filter($course_meta_keywords1, 'strlen');
            if (count($course_meta_keywords) > 0) {
                foreach ($course_meta_keywords as $value) {
                    $value = trim($value);
                    if (empty($value)) {
                        $this->form_validation->set_message('check_empty_course_meta_keyword', get_message('course_meta_keyword'));
                        return FALSE;
                    } else {
                        continue;
                    }
                }
            }
        }
    }

    /**
     * @Function            : check_rating 
     * @Used IN             : @function-'check_add_course_validation'     this[@controller]
     * @Description         : check course rating
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 14-07-2016 03:24 PM  
     * @Parameter           : Null
     * @Return              : TRUE/FALSE    
     * @Status              : Available        
     * */
    public function check_rating($course_rating) {
        if ($course_rating) {
            if ($course_rating >= 1 && $course_rating <= 5) {
                return TRUE;
            } else {
                $this->form_validation->set_message('check_rating', get_message('course_rating'));
                return FALSE;
            }
        } else {
            return TRUE;
        }
    }

    /*
      -----------@@@RIPON@ End Course Common Part(07-08-16)----------------------------------
     */



    /*
      -----------@@@RIPON@ Start Add Course WOrk file part(11-11-16)----------------------------------
     */

    /**
     * @Description         : add course work file by topic
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 11-11-2016 09:47 PM       
     * */
    function add_work_file() {
        $data = array();
        $data['active_menu'] = 'course';
        $data['active_sub_menu'] = 'add_work_file';
        // Unset all session data
        (!empty($this->session->work_file_course_id)) ? $this->session->unset_userdata('work_file_course_id') : '';
        (!empty($this->session->sess_work_file)) ? $this->session->unset_userdata('sess_work_file') : '';

        $data['parent_topic'] = $this->utility_model->get_all_table_data('topic_id,topic_name', 'tbl_topic', ['parent_topic_id' => 0]);
        $data['main_content'] = $this->load->view('admin/course/add_work_file', $data, true);
        $this->load->view('admin/admin_master', $data);
    }

    /**
     * @Description         : save course work file
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 14-11-2016 10:50 PM       
     * */
    function save_work_file() {
        $this->form_validation->set_rules('work_file_folder_name', 'Course work folder name', 'required|trim|callback_check_folder_name');

        $all_counter = count($this->session->sess_work_file['counter']);
        $id = count($this->session->sess_work_file['work_file_random_id']);

        if ($this->form_validation->run() == FALSE || ($id <= 0) || ($all_counter != $id)) {
            $course_url = $this->input->post('course_url', TRUE);
            $course_info = $this->course_model->course_info_by_url('course_id', $course_url);

            if (!$course_info) {
                redirect('admin/course/manage-work-file');
            }
            $sdata['work_file_error_msg'] = 'There are some problem please try again later';
            set_session($sdata);

            $work_file_info = $this->utility_model
                    ->get_all_table_data('*', 'tbl_work_files', ['work_file_type' => 1, 'work_file_type_id' => $course_info->course_id]);

            if ($work_file_info) {
                redirect('admin/course/edit-work-file/' . $course_url);
            } else {
                redirect('admin/course/add-work-file');
            }
        } else {
            $this->work_file_model->set_work_file_post_data()
                    ->update_folder_name()->update_work_file();

            $this->session->unset_userdata('work_file_course_id');
            $this->session->unset_userdata('sess_work_file');
            redirect('admin/course/manage-work-file');
        }
    }

    /**
     * @Description         : check folder name validation
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 07-11-2016 02:48 PM  
     * @Parameter           : $folder_name[STRING]     
     * */
    function check_folder_name($folder_name) {
        if ($this->security->xss_clean($folder_name, TRUE) == FALSE) {
            $this->form_validation->set_message('check_folder_name', "Invalid input");
            return FALSE;
        } else {
            $folder_name_array = $this->work_file_model->get_work_file_folder_name();
            if (in_array($folder_name, $folder_name_array)) {
                $this->form_validation->set_message('check_folder_name', "Folder name already exists");
                return FALSE;
            } else {
                return TRUE;
            }
        }
    }

    /**
     * @Description         : get all course work file information
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 11-11-2016 10:21 PM       
     * */
    function get_work_file_info() {
        if ($this->input->is_ajax_request()) {
            $course_id = $this->session->work_file_course_id;
            $data['work_fle_id'] = $data['work_file_name'] = $work_file_id = [];
            // get work file folder INfo
            $data['work_folder_info'] = $this->work_file_model->get_work_file_folder_name();
            $condition = ['work_file_type' => 1, 'work_file_type_id' => $course_id];
            $work_file_info = $this->utility_model->get_all_table_data('work_file_id,work_file_name', 'tbl_work_files', $condition);
            if ($work_file_info) {
                foreach ($work_file_info as $value) {
                    $work_file_id[] = $value->work_file_id;
                    $data['work_file_name'][] = pathinfo($value->work_file_name, PATHINFO_FILENAME);
                }
                $work_random_file_info = $this->random_number_model->set_type_id_array('random_number', 3, $work_file_id)->get_random_number_by_type_id();
                foreach ($work_random_file_info as $value1) {
                    $data['work_fle_id'][] = $this->tt_random_number->set_random_number($value1->random_number)->filter_number('45')->get_filter_number();
                }
            }
            echo json_encode($data);
        } else {
            redirect('super-admin');
        }
    }

    /**
     * @Description         : get all child topic by parent ID
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 11-11-2016 10:58 AM       
     * */
    function get_child_topic() {
        if ($this->input->is_ajax_request()) {
            $parent_topic = $this->input->post('parent_topic', TRUE);
            $child_topic = $this->utility_model->get_all_table_data('topic_id,topic_name', 'tbl_topic', ['parent_topic_id!=' => 0, 'parent_topic_id' => $parent_topic]);
            echo json_encode($child_topic);
        } else {
            redirect('super-admin');
        }
    }

    /**
     * @Description         : get all courses by topic
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 11-11-2016 11:15 AM       
     * */
    function get_course_by_topic() {
        if ($this->input->is_ajax_request()) {
            $child_topic_id = $this->input->post('child_topic_id', TRUE);
            $course_id = explode(',', $this->work_file_model->get_work_file_course_id());
            $course_info = $this->course_model->get_courses_by_topic_id('url,course_name', $child_topic_id, $course_id);
            echo json_encode($course_info);
        } else {
            redirect('super-admin');
        }
    }

    /**
     * @Description         : get courses work file view page 
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 11-11-2016 12:27 PM       
     * */
    function get_work_file_view_page() {
        if ($this->input->is_ajax_request()) {
            $data = [];
            $data['counter'] = 1;
            $course_url = $this->input->post('course_url', TRUE);
            $data['course_type'] = $this->course_model->course_info_by_url('course_type', $course_url)->course_type;
            echo $this->load->view('admin/course/ajax/add_single_work_file_view', $data, true);
        } else {
            redirect('super-admin');
        }
    }

    /**
     * @Description         : get more courses work file view page 
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 11-11-2016 06:37 PM       
     * */
    function get_more_work_file_view() {
        if ($this->input->is_ajax_request()) {
            $data = $resposse_data = Array();
            $counter = $this->input->post('counter', TRUE);
            $total_div = $this->input->post('total_div', TRUE);
            $total_work_file = $this->work_file_model->get_total_work_file(1, $this->session->work_file_course_id);
            if ($total_div == $total_work_file) {
                $session_data['sess_work_file'] = $this->session->sess_work_file;
                $data['course_type'] = $this->utility_model->get_single_table_information('course_type', 'tbl_course', 'course_id', $this->session->work_file_course_id)->course_type;
                $data['counter'] = $resposse_data['counter'] = $session_data['sess_work_file']['counter'][] = ++$counter;
                set_session($session_data);
                $resposse_data['view_page'] = $this->load->view('admin/course/ajax/add_single_work_file_view', $data, TRUE);
            } else {
                $resposse_data['error'] = 'error';
            }
            echo json_encode($resposse_data);
        } else {
            redirect('super-admin');
        }
    }

    /**
     * @Description         : upload course work file
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 11-11-2016 03:46 PM       
     * */
    function upload_work_file() {
        if ($this->input->is_ajax_request()) {
            $rsponse_data = [];
            // assign data for course work file, set file index and check file validation
            $this->tt_files->assign_data(1)->set_file('work_file_data')->check_validation();

            if ($this->tt_files->error_message() == '') {
                // get course url and set course id into session
                ($this->session->work_file_course_id == '') ?
                                $this->work_file_model->set_course_url($this->input->post('course_url', TRUE))->set_course_id_into_session() : '';
                // return random number which used for create folder to upload work file
                $this->work_file_model->save_folder_information()
                        ->set_work_file_data() // set file related information and make work file directory(if not) and upload file
                        ->make_work_file_upload_dir(); // make upload directory
                // set upload directory in tt_file library
                $this->tt_files->set_upload_dir($this->work_file_model->get_upload_dir());

                $random_number = (empty($this->work_file_model->check_work_file_id())) ?
                        $this->tt_random_number->get_random_number() :
                        $this->tt_random_number->set_random_number($this->work_file_model->check_work_file_id())
                                ->filter_number('TT')->get_filter_number(); // get random number
                //set random file name into tt files and upload file 
                $this->tt_files->set_file_random_number($random_number)->upload_file();

                // save uploaded work file into Database
                $this->save_upload_work_file();
            } else {
                $rsponse_data['error_msg'] = $this->tt_files->error_message();
                echo json_encode($rsponse_data);
            }
        } else {
            redirect('super-admin');
        }
    }

    /**
     * @Description         : save uploaded course work file data
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 11-11-2016 04:54 PM       
     * */
    function save_upload_work_file() {
        $rsponse_data = [];
        if ($this->tt_files->error_message() == '') { // if return any error while uploding work file
            if (empty($this->work_file_model->check_work_file_id())) { // any work file does not uploaded
                $work_file_id = $this->utility_model
                        ->save_information_in_database('tbl_work_files', $this->work_file_model->get_work_file_data());

                $session_data['sess_work_file'] = $this->session->sess_work_file; // get session data into array
                $rsponse_data['work_fle_random_id'] = $session_data['sess_work_file']['work_file_random_id'][] = $this->tt_random_number
                                ->filter_number('45')->get_filter_number();
                $rsponse_data['work_file_name'] = $this->work_file_model->get_file_name();
                set_session($session_data);
                // save random number for course work file (type=>3 [1st parameter])
                $random_number = $this->tt_random_number->get_rand_number();
                $this->random_number_model->save_random_number(3, $work_file_id, $random_number);
            } else {
                $this->work_file_model->update_work_file_data();
            }
            // get work file data for save into database
            $rsponse_data['work_file_name'] = $this->work_file_model->get_file_name();
            $rsponse_data['file_size'] = $this->work_file_model->get_work_file_size_for_admin();
        } else {
            $rsponse_data['error_msg'] = $this->tt_files->error_message();
        }
        echo json_encode($rsponse_data);
    }

    /**
     * @Description         : delete single work file
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 11-11-2016 04:54 PM       
     * */
    function delete_work_file() {
        if ($this->input->is_ajax_request()) {
            $counter = $this->input->post('counter', TRUE);
            $sess_work_file = $this->session->sess_work_file;
            if (!empty($sess_work_file)) {
                if (in_array($counter, $sess_work_file['counter'])) {
                    $session_data['sess_work_file'] = $this->work_file_model->remove_course_work_file($counter, $sess_work_file);
                    set_session($session_data);
                }
            }
        } else {
            redirect();
        }
    }

    /*
      -----------@@@RIPON@ End Add Course WOrk file part (11-11-16)----------------------------------
     */


    /*
      -----------@@@RIPON@ Start Manage Course WOrk file part (12-11-16)----------------------------------
     */

    /**
     * @Description         : manage course work file
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 12-11-2016 11:43 AM       
     * */
    public function manage_work_file($arg = '') {
        $data = array();
        $data['active_menu'] = 'course';
        $data['active_sub_menu'] = 'manage_work_file';
        $page_number = ($arg == '') ? 1 : $arg;
        $limit = ($page_number - 1) * 10;
        ($arg == '') ? $this->session->unset_userdata('sess_search_input') : '';

        $search_input = (empty($this->session->sess_search_input)) ? '' : $this->session->sess_search_input;
        $data['work_file'] = $this->work_file_model
                ->get_all_work_file('work_file_id,work_file_type_id,work_file_folder_id,work_file_status', 1, $limit, $search_input);

        $work_file_data = $this->get_work_file_data($data);

        $total_rows = $this->work_file_model->get_total_course_work_file('work_file_id', 1, $search_input); // total row
        $params = array('url' => 'admin/course/manage-work-file/', 'total_row' => $total_rows, 'per_page' => 10, 'current_page' => $page_number, 'total_link' => 10);
        $work_file_data['pagination_link'] = $this->tt_pagination->view_pagination_link($params);

        $work_file_data['main_content'] = $this->load->view('admin/course/manage_work_file', $work_file_data, true);
        $this->load->view('admin/admin_master', $work_file_data);
    }

    /**
     * @Description         : get work file data
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 12-11-2016 02:17 PM       
     * */
    function get_work_file_data($data) {
        foreach ($data['work_file'] as $value) {
            if(isset($data['random_number'][$value->work_file_id])){
            $data['random_number'][$value->work_file_id] = $this->utility_model
                            ->get_table_information('random_number', 'tbl_random', ['random_type' => 3, 'random_type_id' => $value->work_file_id])->random_number;
                    }
            $data['folder_name'][$value->work_file_id] = $this->utility_model
                            ->get_table_information('work_file_folder_name', 'tbl_work_file_folder', ['work_file_folder_id' => $value->work_file_folder_id])->work_file_folder_name;
            $data['course_info'][$value->work_file_id] = $this->utility_model
                    ->get_table_information('topic_id,url_id,course_name', 'tbl_course', ['course_id' => $value->work_file_type_id]);
            $data['course_url'][$value->work_file_id] = $this->utility_model
                            ->get_table_information('url', 'tbl_url', ['url_id' => $data['course_info'][$value->work_file_id]->url_id])->url;
            $data['topic_name'][$value->work_file_id] = $this->utility_model
                            ->get_table_information('topic_name', 'tbl_topic', ['topic_id' => $data['course_info'][$value->work_file_id]->topic_id])->topic_name;
            $data['total_work_file'][$value->work_file_id] = $this->utility_model
                    ->total_row('work_file_id', 'tbl_work_files', ['work_file_type' => 1, 'work_file_type_id' => $value->work_file_type_id]);
        }
        return $data;
    }

    /**
     * @Description         : search course work file 
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 15-11-2016 04:56 PM       
     * */
    function search_work_file() {
        if ($this->input->is_ajax_request()) {
            $search_input = $this->input->post('search_input', TRUE);
            $this->session->set_userdata('sess_search_input', $search_input);
            $data['work_file'] = $this->work_file_model
                    ->get_all_work_file('work_file_id,work_file_type_id,work_file_folder_id,work_file_status', 1, 0, $search_input);
            $work_file_data = $this->get_work_file_data($data);
            $total_rows = $this->work_file_model->get_total_course_work_file('work_file_id', 1, $search_input); // total row
            $params = array('url' => 'admin/course/manage-work-file/', 'total_row' => $total_rows, 'per_page' => 10, 'current_page' => 1, 'total_link' => 10);
            $work_file_data['pagination_link'] = $this->tt_pagination->view_pagination_link($params);
            echo $this->load->view('admin/course/ajax/manage_work_file', $work_file_data, TRUE);
        } else {
            redirect();
        }
    }

    /**
     * @Description         : delete all course work file by course url 
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 15-11-2016 12:06 PM       
     * */
    function delete_all_work_file() {
        if ($this->input->is_ajax_request()) {
            $course_url = $this->input->post('course_url', TRUE);
            $course_info = $this->course_model->course_info_by_url('course_id', $course_url);

            if ($course_info) {
                $work_file_info = $this->utility_model
                        ->get_all_table_data('work_file_id,work_file_type_id,work_file_folder_id', 'tbl_work_files', ['work_file_type' => 1, 'work_file_type_id' => $course_info->course_id]);
                $folder_id = $work_file_info[0]->work_file_folder_id;

                foreach ($work_file_info as $value) {
                    $this->work_file_model->delete_course_work_file($value->work_file_id);
                }

                $condition = ['random_type' => 2, 'random_type_id' => $folder_id];
                $folder_name = $this->utility_model->get_table_information('random_number', 'tbl_random', $condition)->random_number;

                $dir = 'content-library/' . $this->url_model->course_creator_url($course_info->course_id) . '/my-work-file/' . $folder_name . '/';
                if (is_dir($dir)) {
                    rmdir($dir);
                }
                // delete course work file
                $this->utility_model->delete_information_in_database('tbl_work_file_folder', 'work_file_folder_id', $folder_id);
                // delete random number according to course work file
                $this->utility_model->delete_information_in_database('tbl_random', 'random_number', $folder_name);
            } else {
                echo 'error';
            }
        } else {
            redirect();
        }
    }

    /*
      -----------@@@RIPON@ End Manage Course WOrk file part (12-11-16)----------------------------------
     */


    /*
      -----------@@@RIPON@ Start View Course WOrk file part (12-11-16)----------------------------------
     */

    /**
     * @Description         : view work file data
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 12-11-2016 05:48 PM       
     * */
    function view_work_file($course_url) {
        $data = array();
        $data['active_menu'] = 'course';
        $data['active_sub_menu'] = 'manage_work_file';
        $data['course_info'] = $this->course_model->course_info_by_url('course_id,url', $course_url);

        $condition = ['work_file_type' => 1, 'work_file_type_id' => $data['course_info']->course_id];
        $data['work_file_info'] = $this->work_file_model->get_order_work_file_data('*', $condition);

        foreach ($data['work_file_info'] as $file_value) {
            $condition1 = ['work_file_folder_id' => $file_value->work_file_folder_id];
            $data['folder_name'][$file_value->work_file_id] = $this->utility_model
                            ->get_table_information('work_file_folder_name', 'tbl_work_file_folder', $condition1)->work_file_folder_name;

            $condition2 = ['random_type' => 3, 'random_type_id' => $file_value->work_file_id];
            if(isset($data['random_number'][$file_value->work_file_id])){
            $data['random_number'][$file_value->work_file_id] = $this->tt_random_number
                            ->set_random_number($this->utility_model
                                    ->get_table_information('random_number', 'tbl_random', $condition2)->random_number)
                            ->filter_number('31')->get_filter_number();
            }
        }

        $data['main_content'] = $this->load->view('admin/course/view_work_file', $data, true);
        $this->load->view('admin/admin_master', $data);
    }

    /**
     * @Description         : get work file data for ordering work file
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 12-11-2016 06:14 PM       
     * */
    function get_work_file($random_number) {
        if ($this->input->is_ajax_request()) {
            $work_file = ['id' => [], 'file_name' => []];
            // filter random number
            $filter_random_number = $this->tt_random_number->set_random_number($random_number)->filter_number('TT')->get_filter_number();
            // get work file ID
            $work_file_id = $this->random_number_model->set_value(3, '', $filter_random_number)->get_type_id();
            // get Course ID
            $condition1 = ['work_file_id' => $work_file_id];
            $course_id = $this->utility_model->get_table_information('work_file_type_id', 'tbl_work_files', $condition1)->work_file_type_id;
            // get work file infomation except select workfile ID
            $work_file_info = $this->work_file_model->get_work_file_info_by_type_id('work_file_name,random_number', 1, $course_id, $work_file_id);

            foreach ($work_file_info as $value) {
                $work_file['id'][] = $this->tt_random_number->set_random_number($value->random_number)->filter_number('31')->get_filter_number();
                $work_file['file_name'][] = pathinfo($value->work_file_name, PATHINFO_FILENAME);
            }

            echo json_encode($work_file);
        } else {
            redirect();
        }
    }

    /**
     * @Description         : update work file order
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 12-11-2016 06:19 PM       
     * */
    function update_file_order($course_url) {
        $this->form_validation->set_rules('random_number', 'Random Number', 'callback_check_random_number');
        $this->form_validation->set_rules('file_order', 'File Order', 'required');
        if ($this->input->post('file_order', TRUE) == 2) {
            $this->form_validation->set_rules('selected_file', 'File Name', 'required');
        }
        if ($this->form_validation->run() == FALSE) {
            $data['error_message'] = 'Unable to order file';
            set_session($data);
            redirect('admin/course/view-work-file/' . $course_url);
        } else {
            $this->work_file_model->update_work_file_order($course_url);
            redirect('admin/course/view-work-file/' . $course_url);
        }
    }

    /**
     * @Description         : check random number validation
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 12-11-2016 06:21 PM       
     * */
    function check_random_number($random_number) {
        $filter_random_number = $this->tt_random_number->set_random_number($random_number)->filter_number('TT')->get_filter_number();
        $work_file_id = $this->random_number_model->set_value(3, '', $filter_random_number)->get_type_id();

        if (!$work_file_id) {
            $this->form_validation->set_message('check_random_number', "Invalid Access");
            return FALSE;
        }
    }

    /**
     * @Description         : delete single work file
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 12-11-2016 06:25 PM       
     * */
    function delete_work_file_in_view() {
        if ($this->input->is_ajax_request()) {
            $random_number = $this->input->post('id', TRUE);
            // filter random number
            $filter_random_number = $this->tt_random_number->set_random_number($random_number)->filter_number('TT')->get_filter_number();
            // get work file ID
            $work_file_id = $this->random_number_model->set_value(3, '', $filter_random_number)->get_type_id();
            // get course ID by work file ID
            $course_id = $this->utility_model->get_single_table_information('work_file_type_id', 'tbl_work_files', 'work_file_id', $work_file_id)->work_file_type_id;
            // delete course work file
            $this->work_file_model->delete_course_work_file($work_file_id);
            // Reset work file order 
            $this->work_file_model->reset_order($course_id);
        } else {
            redirect();
        }
    }

    /*
      -----------@@@RIPON@ End View Course WOrk file part (12-11-16)----------------------------------
     */

    /*
      -----------@@@RIPON@ Start Edit Course WOrk file part (12-11-16)----------------------------------
     */

    /**
     * @Description         : get work file data
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 12-11-2016 02:17 PM       
     * */
    function edit_work_file($course_url) {
        $data = array();
        $data['active_menu'] = 'course';
        $data['active_sub_menu'] = 'manage_work_file';
        $data['course_info'] = $this->course_model->course_info_by_url('course_id,course_name,course_type,url', $course_url);
        if (!$data['course_info']) {
            redirect();
        }

        $session_data['work_file_course_id'] = $data['course_info']->course_id;
        $data['work_file_info'] = $this->utility_model
                ->get_all_table_data('*', 'tbl_work_files', ['work_file_type' => 1, 'work_file_type_id' => $data['course_info']->course_id]);

        $this->work_file_model->set_edit_work_file_data($data['work_file_info'], $session_data);
        // Update Course Work file Status
        $this->work_file_model->set_course_id($this->session->work_file_course_id)->set_type(1)->set_status(3)->update_status();
        // get folder name in work file
        $condition = ['work_file_folder_id' => $data['work_file_info'][0]->work_file_folder_id];
        $data['folder_name'] = $this->utility_model->get_table_information('work_file_folder_name', 'tbl_work_file_folder', $condition)->work_file_folder_name;

        $data['main_content'] = $this->load->view('admin/course/edit_work_file', $data, true);
        $this->load->view('admin/admin_master', $data);
    }

    /*
      -----------@@@RIPON@ End Edit Course WOrk file part (12-11-16)----------------------------------
     */
}
