<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Super_admin_certificate extends TT_admin_login {

    public function __construct() {
        parent::__construct();
        $this->load->model('certificate_model');
    }

    /*
     * @Function            : save_course_certificate 
     * @Description         : validates data for creating course certificate
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 30-01-17
     * @Parameter           : NULL         
     * @Status              : Available       
     */

    public function save_course_certificate() {
        $this->form_validation->set_rules('certificate_name', 'Certificate Name', 'required');
        $this->form_validation->set_rules('certificate_template', 'Certificate Template', 'required');
        $this->form_validation->set_rules('certificate_logo', 'Certificate Logo', 'callback_image_check');
        $this->form_validation->set_rules('certificate_status', 'Certificate Status', 'required');
        if ($this->form_validation->run() == FALSE) {
            $this->course_create_certificate($this->session->certificate_course_url);
        } else {
            $this->certificate_model->save_certificate_model();
            $course_url = $this->session->certificate_course_url;
            $unset_items = array('uploaded_certificate_logo',
                'certificate_assign_to_type',
                'certificate_assign_to_type_id',
                'certificate_course_url');
            $this->session->unset_userdata($unset_items);
            redirect('admin/course-demo-certificate/' . $course_url);
        }
    }

    /*
     * @Function            : course_create_certificate 
     * @Description         : displays the create certificate view page
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 31-01-17
     * @Parameter           : NULL         
     * @Status              : Available       
     */

    public function course_create_certificate($course_url) {
        // get the course information
        $data['course_info'] = $this->certificate_model->get_course_info_by_url($course_url);
        $certificate_info = $this->certificate_model->check_certificate(1, $data['course_info']->course_id);
        if (isset($certificate_info)) {
            redirect('admin/course-demo-certificate/' . $course_url);
            exit();
        }
        // Keep course information in session for saving certificate
        $this->session->set_userdata('certificate_course_url', $course_url);
        $this->session->set_userdata('certificate_assign_to_type', 1);
        $this->session->set_userdata('certificate_assign_to_type_id', $data['course_info']->course_id);
        // load the add create certificate form
        $data['active_menu'] = 'course';
        $data['active_sub_menu'] = 'manage_course';
        $data['certificate_type'] = 'Course:';
        $data['main_content'] = $this->load->view('admin/certificate/admin_create_certificate', $data, TRUE);
        $this->load->view('admin/admin_master', $data);
    }

    /*
     * @Function            : image_check 
     * @Description         : call back function for validating image in save_certificate
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 31-01-17
     * @Parameter           : NULL         
     * @Status              : Available       
     */

    public function image_check() {
        if (isset($this->session->uploaded_certificate_logo)) {
            return TRUE;
        } else {
            $person_url = $this->session->login_person_url;
            //checks and creates image upload directory
            $upload_path = 'content-library/' . $person_url . '/my-image/' . 'certificate-logo' . '/';
            if (!is_dir($upload_path)) {
                mkdir($upload_path, 0777, true);
            }
            $this->tt_files->set_file('certificate_logo')->set_upload_dir($upload_path)
                    ->set_encrypt_name()
                    ->set_file_size(2048000)
                    ->set_allowed_type(['png', 'jpeg', 'jpg'])
                    ->check_validation()->upload_file();

            if (!empty($this->tt_files->error_message())) {
                $this->form_validation->set_message('image_check', $this->tt_files->error_message());
                return FALSE;
            } else {
                $file_data = $this->tt_files->get_uploaded_file_data();
                // Create thumb image
                $image_path = $upload_path . $file_data['file_name'];
                $thumbnail_image_path = $upload_path . 'thumb_' . $file_data['file_name'];
                $this->image_model->create_thumbnail_image($thumbnail_image_path, $image_path);
                //Save the thumb image path in session
                $this->session->set_userdata('uploaded_certificate_logo', $thumbnail_image_path);
                //delete old image
                unlink($image_path);
                return TRUE;
            }
        }
    }

    /*
     * @Function            : remove_temporary_logo
     * @Used In             : @function removePreviousLogo [admin_certificate.js] 
     * @Description         : removes previous logo when logo changed while 
     *                        creating form
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 01-02-17
     * @Parameter           : NULL         
     * @Status              : Available       
     */

    public function remove_temporary_logo() {
        $previous_logo = $this->session->uploaded_certificate_logo;
        if (isset($previous_logo)) {
            unlink($previous_logo);
            $this->session->unset_userdata('uploaded_certificate_logo');
        }
    }

    /*
     * @Function            : view_demo_course_certificate 
     * @Description         : displays demo certificate based on certificate id
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 01-02-17
     * @Parameter           : NULL         
     * @Status              : Available       
     */

    public function view_demo_course_certificate($course_url) {
        $course_info = $this->certificate_model->get_course_info_by_url($course_url);
        $certificate_info = $this->certificate_model->check_certificate(1, $course_info->course_id);
        $resource_person_info = $this->certificate_model->get_resource_person_info($course_info->resource_person_id);
        //organiztion info   
        if ($resource_person_info->resource_person_type === '1') {
            $data['organization_name'] = 'Talha Training';
        } elseif ($resource_person_info->resource_person_type === '3') {
            $company_info = $this->certificate_model->get_organization_name($course_info->person_id);
            isset($company_info) ? $data['organization_name'] = $company_info : $data['organization_name'] = '';
        } elseif ($resource_person_info->resource_person_type === '2') {
            $data['organization_name'] = '';
        }

        //display demo certificate page
        $data['course_url'] = $course_url;
        $data['certificate_logo'] = $certificate_info->certificate_image;
        $data['course_name'] = $course_info->course_name;
        $data['resource_person'] = $resource_person_info->person_first_name . ' ' . $resource_person_info->person_last_name;
        $data['active_menu'] = 'course';
        $data['active_sub_menu'] = 'manage_course';
        $data['certificate_type'] = 'Course:';
        $data['main_content'] = $this->load->view('admin/certificate/admin_demo_certificate', $data, TRUE);
        $this->load->view('admin/admin_master', $data);
    }

    /*
     * @Function            : edit_course_certificate 
     * @Description         : displays form for editing certificate
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 02-02-17
     * @Parameter           : $course_url         
     * @Status              : Available       
     */

    public function edit_course_certificate($course_url) {
        $data['course_info'] = $this->certificate_model->get_course_info_by_url($course_url);
        $data['certificate_info'] = $this->certificate_model->check_certificate(1, $data['course_info']->course_id);
        //keep data in session
        $this->session->set_userdata('uploaded_certificate_logo', $data['certificate_info']->certificate_image);
        $this->session->set_userdata('certificate_course_url', $course_url);
        $this->session->set_userdata('certificate_id', $data['certificate_info']->certificate_id);
        $this->session->set_userdata('certificate_assign_to_type', 1);
        $this->session->set_userdata('certificate_assign_to_type_id', $data['course_info']->course_id);

        //Load view page for edit
        $data['active_menu'] = 'course';
        $data['active_sub_menu'] = 'manage_course';
        $data['certificate_type'] = 'Course:';
        $data['main_content'] = $this->load->view('admin/certificate/admin_edit_certificate', $data, TRUE);
        $this->load->view('admin/admin_master', $data);
    }

    /*
     * @Function            : update_course_certificate 
     * @Description         : Updates the course certificate
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 02-02-17
     * @Parameter           : Null         
     * @Status              : Available       
     */

    public function update_course_certificate() {
        $this->remove_temporary_logo();
        $this->form_validation->set_rules('certificate_name', 'Certificate Name', 'required');
        $this->form_validation->set_rules('certificate_template', 'Certificate Template', 'required');
        $this->form_validation->set_rules('certificate_logo', 'Certificate Logo', 'callback_image_check');
        $this->form_validation->set_rules('certificate_status', 'Certificate Status', 'required');
        if ($this->form_validation->run() == FALSE) {
            $this->edit_course_certificate($this->session->certificate_course_url);
        } else {
            $this->certificate_model->update_certificate_model();
            $course_url = $this->session->certificate_course_url;
            $unset_items = array('uploaded_certificate_logo',
                'certificate_assign_to_type',
                'certificate_assign_to_type_id',
                'certificate_course_url',
                'certificate_id');
            $this->session->unset_userdata($unset_items);
            redirect('admin/course-demo-certificate/' . $course_url);
        }
    }

    // permanent certificate section start here - Mashqur



    /*
     * @Function            : manage_batch_certificate 
     * @Description         : Loads the batch graduation certificate page
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 26-02-17
     * @Parameter           : $encoded_course_batch_id         
     * @Status              : Available       
     */
    public function manage_batch_certificate($encoded_course_batch_id) {
        $course_batch_id = $this->utility_model->decode_id($encoded_course_batch_id, 'Tt', '/');
        $data['active_menu'] = 'batch';
        $data['active_sub_menu'] = 'manage_batch';
        $data['batch_info'] = $batch_info = $this->batch_model->get_batch_information($course_batch_id);
        $data['course_info'] = $this->certificate_model->get_course_info_by_batch_id($course_batch_id);
        $data['student_number'] = count(explode(',', $batch_info->student_id));
        if (!empty($batch_info->student_id)) {
            $data['assigned_student_info'] = $this->certificate_model->get_student_info($batch_info->student_id);
            $data['main_content'] = $this->load->view('admin/batch/batch_graduation_certificate', $data, true);
            $this->load->view('admin/admin_master', $data);
        } else {
            redirect('super-admin/manage-batch');
        }
    }

    /*
     * @Function            : assign_batch_student_certificate 
     * @Description         : Assigns Certificate to batch student on ajax call
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 26-02-17
     * @Parameter           : NULL
     * @Status              : Available       
     */

    public function assign_batch_student_certificate() {
        if ($this->input->is_ajax_request()) {
            $student_roll = $this->input->post('student_roll', TRUE);
            $course_batch_id = $this->input->post('course_batch_id', TRUE);
            $this->check_certificate_existance($student_roll, $course_batch_id);
        } else {
            redirect();
        }
    }

    /*
     * @Function            : check_certificate_existance 
     * @Description         : Check certificate already exit or not
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 28-02-17
     * @Parameter           : $student_roll, $course_batch_id
     * @Status              : Available       
     */

    public function check_certificate_existance($student_roll, $course_batch_id) {
        $certificate_data = $this->certificate_model->check_certificate_existance($student_roll, $course_batch_id);
        if (!isset($certificate_data)) {
            $this->assign_student_certificate($student_roll, $course_batch_id);
        }
    }

    /*
     * @Function            : assign_student_certificate 
     * @Description         : Assign Certificate to student
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 28-02-17
     * @Parameter           : $student_roll, $course_batch_id
     * @Status              : Available       
     */

    public function assign_student_certificate($student_roll, $course_batch_id) {
        $certificate_dtl = $this->certificate_model->get_certificate_dtl_by_batch_id($course_batch_id);
        if (isset($certificate_dtl)) {
            $unset_array = ['student_certificate_id', 'person_id', 'student_roll_number'];
            foreach ($unset_array as $unset_value) {
                unset($certificate_dtl->$unset_value);
            }
            $certificate_dtl->person_id = $this->certificate_model->get_person_id_by_roll($student_roll);
            $certificate_dtl->student_roll_number = $student_roll;
            $this->certificate_model->save_certificate($certificate_dtl);
        } else {
            $data = $this->prepare_certificate_detail($student_roll, $course_batch_id);
            $this->certificate_model->save_certificate($data);
        }
    }

    /*
     * @Function            : prepare_certificate_detail 
     * @Used In             : assign_batch_student_certificate
     * @Description         : organize all certificate data
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 26-02-17
     * @Parameter           : $student_roll
     * @Status              : Available       
     */

    public function prepare_certificate_detail($student_roll, $course_batch_id) {
        $data['person_id'] = $this->certificate_model->get_person_id_by_roll($student_roll);
        $data['course_batch_id'] = $course_batch_id;
        $data['certificate_logo'] = $this->get_permanent_certificate_logo($course_batch_id);
        $data['course_by'] = $this->certificate_model->get_course_by_name($course_batch_id);
        $course_info = $this->certificate_model->get_certificate_course_info_by_batch_id($course_batch_id);
        $data['course_name'] = $course_info->course_name;
        $data['course_completion_date'] = $course_info->course_completion_date;
        $data['course_resource_person'] = $this->certificate_model->get_resource_person_name($course_info->resource_person_id);
        $data['student_roll_number'] = $student_roll;
        $data['certificate_template'] = $this->certificate_model->get_certificate_template($course_batch_id);
        return $data;
    }

    /*
     * @Function            : get_permanent_certificate_logo
     * @Description         : Copy and transfer certificate logo in permanent folder
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 27-02-17
     * @Parameter           : $course_batch_id        
     * @Status              : Available       
     */

    public function get_permanent_certificate_logo($course_batch_id) {
        $logo_file = 'content-library/certificate-logo/' . md5($course_batch_id) . '.jpg';
        if (!file_exists($logo_file)) {
            $certificate_logo = $this->certificate_model->get_current_logo($course_batch_id);
            if (!copy($certificate_logo->certificate_image, $logo_file)) {
                echo 'Error Happend While Assigning Certificate !';
                exit();
            } else {
                return $logo_file;
            }
        } else {
            return $logo_file;
        }
    }

    /*
     * @Function            : cancel_batch_student_certificate 
     * @Description         : Update certificate status to cancel
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 28-02-17
     * @Parameter           : Null
     * @Status              : Available       
     */

    public function cancel_batch_student_certificate() {
        if ($this->input->is_ajax_request()) {
            $student_roll = $this->input->post('student_roll', TRUE);
            $course_batch_id = $this->input->post('course_batch_id', TRUE);
            $this->certificate_model->cancel_batch_student_certificate($student_roll, $course_batch_id);
        } else {
            redirect();
        }
    }

    /*
     * @Function            : manage_certificate 
     * @Description         : Loads the manage certificate view in admin section
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 08-03-17
     * @Parameter           : Null
     * @Status              : Available       
     */

    public function manage_certificate() {
        $data['active_menu'] = 'batch';
        $data['active_sub_menu'] = 'manage-certificate';
        $data['main_content'] = $this->load->view('admin/certificate/admin_manage_certificate', '', TRUE);
        $this->load->view('admin/admin_master', $data);
    }

    /**
     * @Function            : search_student_for_manage_certificate
     * @Description In      : displays the search result output for certificate student
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 09-03-17
     * @Parameter           : NULL
     * @Status              : Available       
     */
    public function search_student_for_manage_certificate() {
        if ($this->input->is_ajax_request()) {
            $student_dtl = [];
            $certificate_dtl = [];
            $param = $this->input->post('parameter', TRUE);
            $student_dtl = $this->certificate_model->get_student_data($param);
            foreach ($student_dtl as $student) {
                $certificate_dtl[$student->person_id] = $this->certificate_model->get_certificate_detail($student->person_id);
            }
            $data['student_dtl'] = $student_dtl;
            $data['certificate_dtl'] = $certificate_dtl;
            echo $this->load->view('admin/certificate/ajax_view/ajax_admin_manage_certificate', $data, TRUE);
        }
    }

    /**
     * @Function            : view_permanent_certificate
     * @Description         : Displays the permanent certificate in admin
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 11-03-17
     *  @parameter          : $student_roll
     * @Status              : available
     * */
    public function view_permanent_certificate($student_roll) {
        $data['active_menu'] = 'batch';
        $data['active_sub_menu'] = 'manage-certificate';
        $this->load->model('certificate_model');
        $data['certificate_data'] = $this->get_certificate_detail($student_roll);
        if (!isset($data['certificate_data']) || empty($data['certificate_data'])) {
            redirect();
        }
        $data['main_content'] = $this->load->view('admin/certificate/admin_view_permanent_certificate', $data, TRUE);
        $this->load->view('admin/admin_master', $data);
    }

    /**
     * @Function            : get_certificate_detail
     * @Description         : get detail information of a single certificate
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 11-03-17
     *  @parameter          : $student_roll
     * @Status              : available
     * */
    public function get_certificate_detail($student_roll) {
        $data = $this->certificate_model->certificate_info_for_public_view($student_roll);
        $data->student_name = $this->certificate_model->get_student_name_by_id($data->person_id);
        return $data;
    }

    /**
     * @Function            : edit_permanent_certificate
     * @Description         : Load the view for edit certificate in admin
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 11-03-17
     * @parameter          : $student_roll
     * @Status              : available
     * */
    public function edit_permanent_certificate($student_roll) {
        $data['active_menu'] = 'batch';
        $data['active_sub_menu'] = 'manage-certificate';
        $this->load->model('certificate_model');
        $data['certificate_data'] = $this->get_certificate_detail($student_roll);
        $data['person_info'] = $this->person_model->get_single_person_info_by_person_id($data['certificate_data']->person_id);
        if (!isset($data['certificate_data']) || empty($data['certificate_data'])) {
            redirect();
        }

        $data['main_content'] = $this->load->view('admin/certificate/admin_edit_individual_certificate',$data,TRUE);
        $this->load->view('admin/admin_master', $data);
    }
    
   
    /**
     * @Function            : update_permanent_certificate_validation
     * @Description         : validates update certificate data
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 12-03-17
     * @parameter           : NULL
     * @Status              : available
     * */
    public function update_permanent_certificate_validation(){
        $this->form_validation->set_rules('first_name', 'First Name', 'required|trim');
        $this->form_validation->set_rules('last_name', 'Last Name','required|trim');
        $this->form_validation->set_rules('course_by', 'Course By Name','required|trim');
        $this->form_validation->set_rules('course_name', 'Course Name','required|trim');
        $this->form_validation->set_rules('course_completion_date', 'Course Completion Date','required|trim');
        $this->form_validation->set_rules('course_resource_person', 'Resource Person Name','required|trim');
    }
    
    
        /**
     * @Function            : update_permanent_certificate
     * @Description         : Updates permanent certificate data into datbase
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 12-03-17
     * @parameter           : $student_roll
     * @Status              : available
     * */
    public function update_permanent_certificate($student_roll){        
            $field_name = ['first_name','last_name','course_by','course_name','course_completion_date','course_resource_person'];
            $form_data = $this->input->post($field_name, TRUE);
            
            $this->update_permanent_certificate_validation();
            if($this->form_validation->run() == FALSE){
                $this->edit_permanent_certificate($student_roll);
            }else{
                $student_id = $this->certificate_model->get_student_person_id($student_roll);
                $this->certificate_model->update_permanent_certificate($form_data, $student_roll);
                $this->certificate_model->update_student_name($form_data, $student_id->person_id);
                $this->session->set_userdata('submit_message', 'Certificate Information Updated Successfully');
                redirect('admin/edit-certificate/'.$student_roll);
            }            
            
        
    }

}
