<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Super_admin_batch extends TT_admin_login {

    public function __construct() {
        parent::__construct();
    }

    /*
     * @Function            : create_batch 
     * @Description         : creates batch against a course from admin
     * @Developed By        : Unknown
     * @Start DateTime      : Unknown
     * @Parameter           : NULL         
     * @Status              : Available 
     * @Comment Added By    : Md Mashqur Ul Alam [04-02-17]      
     */

    function create_batch() {
        $data = array();
        $data['active_menu'] = 'batch';
        $data['active_sub_menu'] = 'create_batch';
        $this->create_batch_form_validation();
        $data['courses'] = $this->super_admin_batch_model->select_all_active_courses(); //course_info
        if ($this->form_validation->run() == FALSE) {
            $data['main_content'] = $this->load->view('admin/batch/create_batch', $data, true);
            $this->load->view('admin/admin_master', $data);
        } else {
            $this->super_admin_batch_model->save_course_batch_information();
            redirect('super-admin/manage-batch');
        }
    }

    /*
     * @Function            : create_batch_form_validation 
     * @Description         : Used in create batch for form validation
     * @Developed By        : Unknown
     * @Start DateTime      : Unknown
     * @Parameter           : NULL         
     * @Status              : Available 
     * @Comment Added By    : Md Mashqur Ul Alam [04-02-17]      
     */

    function create_batch_form_validation() {
        $this->form_validation->set_rules('course_batch_name', 'Batch name', 'required');
        $this->form_validation->set_rules('course', 'course information', 'required|callback_select_course');
        $this->form_validation->set_rules('course_batch_start_date', 'Course batch start date', 'required|trim');
        $this->form_validation->set_rules('course_batch_finish_date', 'Course batch finish date', 'required|trim');
    }

    /*
     * Function         : select_course
     * Used IN          : function[add_batch_form_validation] controller[batch]
     * Description      : used to select course validation
     * Parameter        : $course
     * return           : true, false(validation message)
     * redirect         : none
     * view             : none
     * Developed By     : Tania Akter
     * Date             : 
     */

    function select_course($course) {
        if ($course == '') {
            $this->form_validation->set_message('select_course', "<span style=color:red>Please select course</span>");
            return FALSE;
        } else {
            return TRUE;
        }
    }

    /*
     * Function         : batch_course_info
     * Used IN          : user/batch/create_batch , 
     *                    user/batch/edit_batch, 
     *                    $route['batch-course-info'] = "batch/batch_course_info";  
     * Description      : get batch course information
     * Parameter        : none
     * return           : none
     * redirect         : none
     * view             : user/batch/ajax_page/ajax_batch_course_info
     * Developed By     : Tania Akter
     * Date             : 27-09-2016
     */

    function batch_course_info() {
        $course_id = $this->input->post('course_id', TRUE);
        $data['course_info'] = $this->super_admin_batch_model->select_course_info_by_course_id($course_id);
        echo $this->load->view('admin/batch/ajax_page/ajax_batch_course_info', $data, TRUE);
    }

    function select_course_type() {
        $course_type = $this->input->post('course_type', TRUE);
        if ($course_type == 1) {  //1= tt
            $data['course_type'] = '--Select Talhatraining Course--';
            $data['courses'] = $this->super_admin_batch_model->select_active_courses(6); //course_info   
        } else if ($course_type == 2) { //2=all
            $data['course_type'] = '--Select All Course--';
            $data['courses'] = $this->super_admin_batch_model->select_all_active_courses(); //course_info    
        } else if ($course_type == 3) { //3=organization
            $data['course_type'] = '--Select Organization Course--';
            $data['courses'] = $this->super_admin_batch_model->select_active_courses(4); //course_info    
        } else if ($course_type == 4) { //4=teacher
            $data['course_type'] = '--Select Teacher Course--';
            $data['courses'] = $this->super_admin_batch_model->select_active_courses(3); //course_info            
        }
        echo $this->load->view('admin/batch/ajax_page/ajax_view_course_info', $data, TRUE);
    }

    function search_course_type() {
        $search_value = $this->input->post('search_value', TRUE);
        $course_type = $this->input->post('course_type', TRUE);
        if ($course_type == 3) {
            $data['course_type'] = '--Select Organization Course--';
            $data['courses'] = $this->super_admin_batch_model->select_active_courses_search(4, $search_value);
        } else if ($course_type == 4) {
            $data['course_type'] = '--Select Teacher Course--';
            $data['courses'] = $this->super_admin_batch_model->select_active_courses_search(3, $search_value);
        }
        echo $this->load->view('admin/batch/ajax_page/ajax_view_course_info_search', $data, TRUE);
    }

    /*
     * @Function            : auto_update_course_batch_type 
     * @Used in             : Used in manage_batch
     * @Description         : Updates Course Batch status based on date
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 05-02-17
     * @Parameter           : NULL         
     * @Status              : Available      
     */

    function auto_update_course_batch_type() {
        $batch_info = $this->batch_model->select_batch_info();
        foreach ($batch_info as $course_batch) {
            $start_date = $course_batch->course_batch_start_date;
            $finish_date = $course_batch->course_batch_finish_date;
            $present_date = date("Y-m-d");
            if ($start_date < $present_date && $present_date < $finish_date) {
                $this->batch_model->update_batch_type($course_batch->course_batch_id, 1); //1= running
            } else if ($start_date < $present_date && $present_date > $finish_date) {
                $this->batch_model->update_batch_type($course_batch->course_batch_id, 2); //2=finished
            }
        }
    }

    /*
     * @Function            : manage_batch 
     * @Description         : $route['super-admin/manage-batch']
     * @Developed By        : Unknown
     * @Updated By          : Md Mashqur Ul Alam
     * @Update DateTime     : 05-02-17
     * @Parameter           : NULL         
     * @Status              : Available      
     */

    function manage_batch() {
        $data = array();
        $data['active_menu'] = 'batch';
        $data['active_sub_menu'] = 'manage_batch';
        $data['batch_tab'] = $this->get_batch_tab();
        $this->auto_update_course_batch_type();
        $data['total_created_batch'] = $this->super_admin_batch_model->get_total_batch_status(4); //4= create
        $data['total_running_batch'] = $this->super_admin_batch_model->get_total_batch_status(1); //1= running
        $data['total_finished_batch'] = $this->super_admin_batch_model->get_total_batch_status(2); //2= finished
        $data['total_cancel_batch'] = $this->super_admin_batch_model->get_total_batch_status(3); //3=cancel
        $data['page'] = 1;
        $data['created_batch_info'] = $this->super_admin_batch_model->get_batch_info(4); //4= create batch
        foreach ($data['created_batch_info'] as $created_batch) {
            $data['course_registrated_student'][$created_batch->course_id] = $this->super_admin_batch_model->get_course_registarted_student($created_batch->course_id);
            $data['batch_created_by'][$created_batch->person_id] = $this->person_model->get_single_person_information_by_person_id($created_batch->person_id);
            $data['batch_resource_person'][$created_batch->resource_person_id] = $this->super_admin_batch_model->get_resource_person_info($created_batch->resource_person_id);
            $data['student_number_in_batch'][$created_batch->course_batch_id] = $this->super_admin_batch_model->count_number_of_student_in_batch($created_batch->course_batch_id);
        }

        // running batch
        $data['running_batch_info'] = $this->super_admin_batch_model->get_batch_info(1);   //1= running batch     
        foreach ($data['running_batch_info'] as $running_batch) {
            $data['course_registrated_student'][$running_batch->course_id] = $this->super_admin_batch_model->get_course_registarted_student($running_batch->course_id);
            $data['batch_created_by'][$running_batch->person_id] = $this->person_model->get_single_person_information_by_person_id($running_batch->person_id);
            $data['batch_resource_person'][$running_batch->resource_person_id] = $this->super_admin_batch_model->get_resource_person_info($running_batch->resource_person_id);
            $data['student_number_in_batch'][$running_batch->course_batch_id] = $this->super_admin_batch_model->count_number_of_student_in_batch($running_batch->course_batch_id);
        }

        $data['finished_batch_info'] = $this->super_admin_batch_model->get_batch_info(2); //2= finished batch      
        foreach ($data['finished_batch_info'] as $finished_batch) {
            $data['course_registrated_student'][$finished_batch->course_id] = $this->super_admin_batch_model->get_course_registarted_student($finished_batch->course_id);
            $data['batch_created_by'][$finished_batch->person_id] = $this->person_model->get_single_person_information_by_person_id($finished_batch->person_id);
            $data['batch_resource_person'][$finished_batch->resource_person_id] = $this->super_admin_batch_model->get_resource_person_info($finished_batch->resource_person_id);
            $data['student_number_in_batch'][$finished_batch->course_batch_id] = $this->super_admin_batch_model->count_number_of_student_in_batch($finished_batch->course_batch_id);
        }

        //cancel batch
        $data['cancel_batch_info'] = $this->super_admin_batch_model->get_batch_info(3); //3=cancel batch      
        foreach ($data['cancel_batch_info'] as $cancel_batch) {
            $data['batch_created_by'][$cancel_batch->person_id] = $this->person_model->get_single_person_information_by_person_id($cancel_batch->person_id);
            $data['batch_resource_person'][$cancel_batch->resource_person_id] = $this->super_admin_batch_model->get_resource_person_info($cancel_batch->resource_person_id);
            $data['student_number_in_batch'][$cancel_batch->course_batch_id] = $this->super_admin_batch_model->count_number_of_student_in_batch($cancel_batch->course_batch_id);
        }
        $data['main_content'] = $this->load->view('admin/batch/view_course_batch', $data, true);
        $this->load->view('admin/admin_master', $data);
    }

    /*
     * @Function            : get_batch_tab 
     * @Description         : Used in manage_batch
     * @Developed By        : Unknown
     * @Start DateTime      : Unknown
     * @Parameter           : NULL         
     * @Status              : Available
     * @Commented By        : Md Mashqur Ul Alam [05-02-17]      
     */

    function get_batch_tab() {
        $tab = $this->session->userdata('batch_tab');
        if ($tab != '') {
            $tab = $this->session->userdata('batch_tab');
        } else {
            $tab = 'created';
        }
        return $tab;
    }

    function edit_batch($batch_tab, $encode_course_batch_id) {
        $data['active_menu'] = 'batch';
        $data['active_sub_menu'] = 'manage_batch';
        $this->create_batch_form_validation();
        $this->session->set_userdata('batch_tab', $batch_tab);
        $data['batch_tab'] = $batch_tab;
        $course_batch_id = $this->utility_model->decode_id($encode_course_batch_id, 'Tt', '/');
        $data['course_batch_id'] = $course_batch_id;
        $data['batch_info'] = $this->super_admin_batch_model->get_batch_information($course_batch_id);
        $course_id = $data['batch_info']->course_id;
        $data['resourse_person_info'] = $this->super_admin_batch_model->get_resourse_info_by_course_id($course_id);
        $data['course_creator_info'] = $this->super_admin_batch_model->get_creator_info_by_course_id($course_id);
        $data['course_data'] = $this->super_admin_batch_model->select_all_active_courses();           //course_info
        if ($this->form_validation->run() == FALSE) {
            $data['main_content'] = $this->load->view('admin/batch/edit_batch', $data, true);
            $this->load->view('admin/admin_master', $data);
        } else if ($data['batch_info']->course_batch_status == 3) {
            $this->batch_model->update_batch_information($course_batch_id, 4);
            $sdata['batch_tab'] = $batch_tab;
            $this->session->set_userdata($sdata);
            redirect('super-admin/manage-batch'); //created batch
        } else {
            $this->batch_model->update_batch_information($course_batch_id, $data['batch_info']->course_batch_status);
            $sdata['batch_tab'] = $batch_tab;
            $this->session->set_userdata($sdata);
            redirect('super-admin/manage-batch');
        }
    }

    function cancel_batch() {
        $course_batch_id = $this->input->post('course_batch_id', TRUE);
        $this->super_admin_batch_model->cancel_batch_by_course_batch_id($course_batch_id);
    }

    function delete_batch() {
        $course_batch_id = $this->input->post('course_batch_id', TRUE);
        $this->super_admin_batch_model->delete_batch_by_course_batch_id($course_batch_id);
    }

    /*
     * @Function            : registered_student_list 
     * @Description         : Displays the list of student registered in a course
     * @Developed By        : Unknown
     * @Start DateTime      : Unknown
     * @Parameter           : $course_url
     * @Status              : Available
     * @Commented By        : Md Mashqur Ul Alam [06-02-17]      
     */

    function registered_student_list($course_url) {
        $data = $date_data = Array();
        $data['active_menu'] = 'batch';
        $data['active_sub_menu'] = 'manage_batch';
        $page_number = 1;
        $this->utility_model->remove_session_data('sess_start_date', 'sess_end_date');
        $data['course_info'] = $this->super_admin_batch_model->get_course_information_with_url_by_course_url($course_url);
        $course_data = $this->super_admin_batch_model->view_course_register_student_info($data, $date_data, $page_number);
        foreach ($course_data['course_register_student'] as $register_student) {
            $course_data['total_checked_boxes'][$register_student->student_id] = $this->batch_model->get_total_checked($register_student->student_id);
        }
        $course_data['batch'] = $this->get_batch_info($data['course_info']->course_id);
        $course_data['main_content'] = $this->load->view('admin/batch/course_registered_student', $course_data, true);
        $this->load->view('admin/admin_master', $course_data);
    }

    function get_batch_info($course_id) {
        $batch_info = $this->super_admin_batch_model->get_batch_info_course_id($course_id);
        return $batch = ($batch_info) ? 1 : 0;
    }

    /*
     * @Function            : make_not_eligible 
     * @Description         : Make student not eligible
     * @Developed By        : Unknown
     * @Start DateTime      : Unknown
     * @Parameter           : Null
     * @Status              : Available
     * @Commented By        : Md Mashqur Ul Alam [06-02-17]      
     */

    function make_not_eligible() {
        $course_id = $this->input->post('course_id', TRUE);
        $student_id = $this->input->post('student_id', TRUE);
        $this->super_admin_batch_model->make_student_not_eligible($course_id, $student_id);
    }

    /*
     * Function         : assign_studen_for_batch     
     * Description      : get registrared student in batch
     * Parameter        : none
     * return           : none
     * redirect         : none
     * view             : user/batch/ajax_page/student_batch_assign
     * Developed By     : Tania Akter
     * Date             : 
     */

    function assign_student_for_batch() {
        $data['student_id'] = $student_id = $this->input->post('student_id', TRUE);
        $data['batch_info'] = $this->batch_model->select_batch_for_student($data['student_id']);
        echo $this->load->view('admin/batch/ajax_page/student_batch_assign', $data, true);
    }

    /*
     * Function         : update_student_in_tbl_course_batch     
     * Description      : update student in batch
     * Parameter        : none
     * return           : none
     * redirect         : none
     * Developed By     : Tania Akter
     * Date             : 
     */

    function update_student_in_tbl_course_batch() {
        $this->batch_model->update_assign_student_for_batch();
    }

    /*
     * Function         : remove_student_from_batch
     * Used IN          : admin\batch\ajax_page\student_batch_assign.php , 
     *                admin\batch\ajax_page\view_student_assigned_batch.php
     * Description      : used to remove student from batch
     * Parameter        : none
     * return           : none
     * redirect         : none
     * view             : admin/batch/ajax_page/view_student_assigned_batch
     * Developed By     : Tania Akter
     * Date             : 
     * Updated By       : Md Mashqur Ul Alam [07-02-17]
     */

    function remove_student_from_batch() {
        $data['student_id'] = $student_id = $this->input->post('studentID', TRUE);
        $course_id = $this->input->post('courseID', TRUE);
        $this->batch_model->remove_student_from_assigned_batch();
        $data['batch_info'] = $this->batch_model->select_assigned_batch_for_view($student_id, $course_id);
        echo $this->load->view('admin/batch/ajax_page/view_student_assigned_batch', $data, true);
    }

    /*
     * Function         : view_assigned_batch     
     * Description      : used to view student who assigned in batch
     * Parameter        : none
     * return           : none
     * redirect         : none     
     * Developed By     : Tania Akter
     * Updated By       : Md Mashqur Ul Alam [06-02-17]
     */

    function view_assigned_batch() {
        $data['student_id'] = $student_id = $this->input->post('student_id', TRUE);
        $course_id = $this->input->post('course_id', TRUE);
        $data['batch_info'] = $this->batch_model->select_assigned_batch_for_view($student_id, $course_id);
        echo $this->load->view('admin/batch/ajax_page/view_student_assigned_batch', $data, true);
    }

    /**
     * @Function            : remove_registered_student 
     * @Description         : remove register student
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 18-09-2016 01:07 PM 
     * @Updated By          : Md Mashqur Ul Alam [06-02-17] 
     * @Parameter           : Null
     * @Return              : NULL    
     * @Status              : Available        
     * */
    function remove_registered_student() {
        if ((filter_input(INPUT_SERVER, 'HTTP_X_REQUESTED_WITH')) && (filter_input(INPUT_SERVER, 'HTTP_X_REQUESTED_WITH') == 'XMLHttpRequest')) {
            $roll_number = $this->input->post('student_roll_number', TRUE);
            $student_info = $this->utility_model->get_single_table_information('*', 'tbl_student', 'student_roll_number', $roll_number);
            if ($student_info->student_type == 1) {
                $notification_info = $this->notification_model->get_single_notification_info(8, $student_info->student_type_id, $student_info->person_id);
                $this->utility_model->delete_information_in_database('tbl_notification', 'notification_id', $notification_info->notification_id);
                $this->utility_model->delete_information_in_database('tbl_notification_type_info', 'notification_id', $notification_info->notification_id);
            }

            $this->utility_model->delete_information_in_database('tbl_student', 'student_roll_number', $roll_number);
        } else {
            redirect('admin/manage-course');
        }
    }

    /*
     * Function         : view_assigned_student
     * Used IN          : admin\batch\ajax_page\view_finished_batch.php , 
     *                    admin\batch\ajax_page\view_created_batch.php, 
     *                    admin\batch\view_course_batch.php
     * Description      : used to view assigned student
     * Parameter        : $encoded_course_batch_id
     * view             : admin/batch/batch_assigned_student_list
     * Developed By     : Tania Akter
     * Updated By       : Md Mashqur Ul Alam [06-02-17]
     */

    function view_assigned_student($encoded_course_batch_id) {
        $course_batch_id = $this->utility_model->decode_id($encoded_course_batch_id, 'Tt', '/');
        $person_id = $this->session->userdata('user_id');
        $data['person_info'] = $this->person_model->get_single_person_information_by_person_id($person_id);
        $data['active_menu'] = 'batch';
        $data['active_sub_menu'] = 'manage_batch';
        $data['course_batch_id'] = $course_batch_id;
        $data['batch_info'] = $batch_info = $this->batch_model->get_batch_information($course_batch_id);
        $data['course_url'] = $this->batch_model->get_course_url($course_batch_id);
        $data['student_number'] = count(explode(',', $batch_info->student_id));
        if (!empty($batch_info->student_id)) {
            $data['assigned_student_info'] = $this->batch_model->get_batch_assigned_student_list($batch_info->student_id);
            $data['main_content'] = $this->load->view('admin/batch/batch_assigned_student_list', $data, true);
            $this->load->view('admin/admin_master', $data);
        } else {
            redirect('super-admin/manage-batch');
        }
    }

    /*
     * Function         : remove_assigned_student     
     * Description      : Removes assigned student in a batch
     * Parameter        : none
     * return           : none
     * redirect         : none
     * Developed By     : Tania Akter
     * Updated By       : Md Mashqur Ul Alam
     */

    function remove_assigned_student() {
        $this->batch_model->remove_assigned_student_from_batch();
    }

    /**
     * @Function            : batch_pagination 
     * @Description         : Displays the pagination and updates page
     *                        in Admin Batch section
     * @Updated By          : Md Mashqur Ul Alam [09-02-17] 
     * @Parameter           : Null
     * @Return              : NULL    
     * @Status              : Available        
     * */
    function batch_pagination() {
        $person_id = $this->session->userdata('person_id');
        $batch_type = $this->input->post('batch_type', TRUE);
        $page = $this->input->post('page_number', TRUE);
        $limit = $page * 5 - 5;
        if ($batch_type == 'created') {
            $this->view_created_batch_for_ajax_view($page, $limit, $person_id);
        } else if ($batch_type == 'running') {
            $this->view_running_batch_for_ajax_view($page, $limit, $person_id);
        } else if ($batch_type == 'finished') {
            $this->view_finished_batch_for_ajax_view($page, $limit, $person_id);
        } else if ($batch_type == 'cancel') {
            $this->view_cancel_batch_for_ajax_view($page, $limit, $person_id);
        }
    }

    /**
     * @Function            : view_created_batch_for_ajax_view 
     * @Description         : Used in batch_pagination() function
     * @Updated By          : Md Mashqur Ul Alam [09-02-17] 
     * @Parameter           : Null
     * @Return              : NULL    
     * @Status              : Available        
     * */
    function view_created_batch_for_ajax_view($page, $limit, $person_id) {
        $person_info = $this->person_model->get_single_person_information_by_person_id($person_id);
        $data['page'] = $page;
        if ($person_info->person_role == 1 || $person_info->person_role == 6) {
            $data['created_batch_info'] = $this->super_admin_batch_model->get_batch_info_admin_pagination(4, $limit);
            $data['total_created_batch'] = $this->super_admin_batch_model->get_total_batch_status(4);
            foreach ($data['created_batch_info'] as $created_batch) {
                $data['course_registrated_student'][$created_batch->course_id] = $this->batch_model->get_course_registarted_student($created_batch->course_id);
                $data['batch_created_by'][$created_batch->person_id] = $this->person_model->get_single_person_information_by_person_id($created_batch->person_id);
                $data['batch_resource_person'][$created_batch->resource_person_id] = $this->batch_model->get_resource_person_info($created_batch->resource_person_id);
                $data['student_number_in_batch'][$created_batch->course_batch_id] = $this->batch_model->count_number_of_student_in_batch($created_batch->course_batch_id);
            }
        }
        echo $this->load->view('admin/batch/ajax_page/view_created_batch', $data, TRUE);
    }

    /**
     * @Function            : view_running_batch_for_ajax_view 
     * @Description         : Used in batch_pagination() function
     * @Updated By          : Md Mashqur Ul Alam [09-02-17] 
     * @Parameter           : Null
     * @Return              : NULL    
     * @Status              : Available        
     * */
    function view_running_batch_for_ajax_view($page, $limit, $person_id) {
        $person_info = $this->person_model->get_single_person_information_by_person_id($person_id);    //person_info
        $data['page'] = $page;
        if ($person_info->person_role == 1 || $person_info->person_role == 6) {   //person is organization
            $data['running_batch_info'] = $this->super_admin_batch_model->get_batch_info_admin_pagination(1, $limit);
            $data['total_running_batch'] = $this->super_admin_batch_model->get_total_batch_status(1);
            foreach ($data['running_batch_info'] as $running_batch) {
                $data['course_registrated_student'][$running_batch->course_id] = $this->batch_model->get_course_registarted_student($running_batch->course_id);
                $data['batch_created_by'][$running_batch->person_id] = $this->person_model->get_single_person_information_by_person_id($running_batch->person_id);
                $data['batch_resource_person'][$running_batch->resource_person_id] = $this->batch_model->get_resource_person_info($running_batch->resource_person_id);
                $data['student_number_in_batch'][$running_batch->course_batch_id] = $this->batch_model->count_number_of_student_in_batch($running_batch->course_batch_id);
            }
        }
        echo $this->load->view('admin/batch/ajax_page/view_running_batch', $data, TRUE);
    }

    /**
     * @Function            : view_finished_batch_for_ajax_view 
     * @Description         : Used in batch_pagination() function
     * @Updated By          : Md Mashqur Ul Alam [09-02-17] 
     * @Parameter           : Null
     * @Return              : NULL    
     * @Status              : Available        
     * */
    function view_finished_batch_for_ajax_view($page, $limit, $person_id) {
        $person_info = $this->person_model->get_single_person_information_by_person_id($person_id);
        $data['page'] = $page;
        if ($person_info->person_role == 1 || $person_info->person_role == 6) {
            $data['finished_batch_info'] = $this->super_admin_batch_model->get_batch_info_admin_pagination(2, $limit);
            $data['total_finished_batch'] = $this->super_admin_batch_model->get_total_batch_status(2);
            foreach ($data['finished_batch_info'] as $finished_batch) {
                $data['course_registrated_student'][$finished_batch->course_id] = $this->batch_model->get_course_registarted_student($finished_batch->course_id);
                $data['batch_created_by'][$finished_batch->person_id] = $this->person_model->get_single_person_information_by_person_id($finished_batch->person_id);
                $data['batch_resource_person'][$finished_batch->resource_person_id] = $this->batch_model->get_resource_person_info($finished_batch->resource_person_id);
                $data['student_number_in_batch'][$finished_batch->course_batch_id] = $this->batch_model->count_number_of_student_in_batch($finished_batch->course_batch_id);
            }
        }
        echo $this->load->view('admin/batch/ajax_page/view_finished_batch', $data, TRUE);
    }

    /**
     * @Function            : view_cancel_batch_for_ajax_view 
     * @Description         : Used in batch_pagination() function
     * @Updated By          : Md Mashqur Ul Alam [09-02-17] 
     * @Parameter           : Null
     * @Return              : NULL    
     * @Status              : Available        
     * */
    function view_cancel_batch_for_ajax_view($page, $limit, $person_id) {
        $person_info = $this->person_model->get_single_person_information_by_person_id($person_id);
        $data['page'] = $page;
        if ($person_info->person_role == 1 || $person_info->person_role == 6) {
            $data['cancel_batch_info'] = $this->super_admin_batch_model->get_batch_info_admin_pagination(3, $limit);
            $data['total_cancel_batch'] = $this->super_admin_batch_model->get_total_batch_status(3);
            foreach ($data['cancel_batch_info'] as $cancel_batch) {
                $data['course_registrated_student'][$cancel_batch->course_id] = $this->batch_model->get_course_registarted_student($cancel_batch->course_id);
                $data['batch_created_by'][$cancel_batch->person_id] = $this->person_model->get_single_person_information_by_person_id($cancel_batch->person_id);
                $data['batch_resource_person'][$cancel_batch->resource_person_id] = $this->batch_model->get_resource_person_info($cancel_batch->resource_person_id);
                $data['student_number_in_batch'][$cancel_batch->course_batch_id] = $this->batch_model->count_number_of_student_in_batch($cancel_batch->course_batch_id);
            }
        }
        echo $this->load->view('admin/batch/ajax_page/view_cancel_batch', $data, TRUE);
    }

    /**
     * @Function            : register_course_student_pagination 
     * @Description         : used in batch registered student pagination
     * @Updated By          : Md Mashqur Ul Alam [12-02-17] 
     * @Parameter           : Null
     * @Return              : NULL    
     * @Status              : Available        
     * */
    function register_course_student_pagination() {
        if ((filter_input(INPUT_SERVER, 'HTTP_X_REQUESTED_WITH')) && (filter_input(INPUT_SERVER, 'HTTP_X_REQUESTED_WITH') == 'XMLHttpRequest')) {
            $data = $date_data = Array();
            $course_id = $this->input->post('course_id', TRUE);
            $data['course_info'] = $this->user_course_model->get_course_information_with_url_by_course_id($course_id);
            $data['course_creator_info'] = $this->person_model->get_single_person_info_by_person_id($data['course_info']->person_id);
            $page_number = $this->input->post('page_number', TRUE);

            if ($this->session->userdata('sess_start_date') != '') {
                $date_data['sess_start_date'] = $this->session->userdata('sess_start_date');
                $date_data['sess_end_date'] = $this->session->userdata('sess_end_date');
            }
            $course_data = $this->super_admin_batch_model->view_course_register_student_info($data, $date_data, $page_number);

            foreach ($course_data['course_register_student'] as $register_student) {
                $course_data['total_checked_boxes'][$register_student->student_id] = $this->batch_model->get_total_checked($register_student->student_id);
            }
            $course_data['batch'] = $this->get_batch_info($data['course_info']->course_id);
            echo $this->load->view('admin/batch/ajax_page/view_course_register_student', $course_data, TRUE);
        } else {
            redirect();
        }
    }

    /**
     * @Function            : select_course_type_for_search 
     * @Description         : used in search section of admin batch ajax call
     * @Updated By          : Md Mashqur Ul Alam [13-02-17] 
     * Modified By          : Md. Delwar Hossain [29-5-2017]
     * @Parameter           : Null
     * @Return              : NULL    
     * @Status              : Available        
     * */
    function select_course_type_for_search() {
        if ($this->input->is_ajax_request()) {
            $course_type = $this->input->post('course_type', TRUE);
            if ($course_type == 1) {  //1= tt
                $data['course_type'] = '--Select Talhatraining Course--';
                $data['courses'] = $this->super_admin_batch_model->select_active_courses(6); //course_info   
            } else if ($course_type == 2) { //2=all
                $data['course_type'] = '--Select All Course--';
                $data['courses'] = $this->super_admin_batch_model->select_all_active_courses(); //course_info    
            } else if ($course_type == 3) { //3=organization
                $data['course_type'] = '--Select Organization Course--';
                $data['courses'] = $this->super_admin_batch_model->select_active_courses(4); //course_info    
            } else if ($course_type == 4) { //4=teacher
                $data['course_type'] = '--Select Teacher Course--';
                $data['courses'] = $this->super_admin_batch_model->select_active_courses(3); //course_info            
            }
            echo $this->load->view('admin/batch/ajax_page/view_course_info_for_batch_search', $data, TRUE);
        } else {
            redirect('/');
        }
    }

    /**
     * @Function            : batch_search_course_type 
     * @Description         : used in search section of admin batch ajax call
     * @Updated By          : Md Mashqur Ul Alam [13-02-17] 
     * @Parameter           : Null
     * @Return              : NULL    
     * @Status              : Available        
     * */
    function batch_search_course_type() {
        if ($this->input->is_ajax_request()) {
            $search_value = $this->input->post('search_value', TRUE);
            $course_type = $this->input->post('course_type', TRUE);
            if ($course_type == 3) {
                $data['course_type'] = '--Select Organization Course--';
                $data['courses'] = $this->super_admin_batch_model->select_active_courses_search(4, $search_value);
            } else if ($course_type == 4) {
                $data['course_type'] = '--Select Teacher Course--';
                $data['courses'] = $this->super_admin_batch_model->select_active_courses_search(3, $search_value);
            }
            echo $this->load->view('admin/batch/ajax_page/view_course_info_for_batch_search', $data, TRUE);
        } else {
            redirect('/');
        }
    }

    /**
     * @Function            : view_batch_by_course 
     * @Description         : used in search section of admin batch ajax call
     * @Updated By          : Md Mashqur Ul Alam [13-02-17] 
     * @Parameter           : Null
     * @Return              : NULL    
     * @Status              : Available        
     * */
    function view_batch_by_course() {
        if ($this->input->is_ajax_request()) {
            $data['course_id'] = $course_id = $this->input->post('course_id', TRUE);
            $data['batch_tab'] = $this->get_batch_tab();
            $this->auto_update_course_batch_type();
            $data['total_created_batch'] = $this->super_admin_batch_model->get_total_batch_by_course($course_id, 4); //4= create
            $data['total_running_batch'] = $this->super_admin_batch_model->get_total_batch_by_course($course_id, 1); //1= running
            $data['total_finished_batch'] = $this->super_admin_batch_model->get_total_batch_by_course($course_id, 2); //2= finished
            $data['total_cancel_batch'] = $this->super_admin_batch_model->get_total_batch_by_course($course_id, 3); //3=cancel        

            $data['page'] = 1;
            $data['created_batch_info'] = $this->super_admin_batch_model->get_batch_info_by_course($course_id, 4); //4= create batch 
            foreach ($data['created_batch_info'] as $created_batch) {
                $data['course_registrated_student'][$created_batch->course_id] = $this->super_admin_batch_model->get_course_registarted_student($created_batch->course_id);
                $data['batch_created_by'][$created_batch->person_id] = $this->person_model->get_single_person_information_by_person_id($created_batch->person_id);
                $data['batch_resource_person'][$created_batch->resource_person_id] = $this->super_admin_batch_model->get_resource_person_info($created_batch->resource_person_id);
                $data['student_number_in_batch'][$created_batch->course_batch_id] = $this->super_admin_batch_model->count_number_of_student_in_batch($created_batch->course_batch_id);
            }
            // running batch
            $data['running_batch_info'] = $this->super_admin_batch_model->get_batch_info_by_course($course_id, 1);   //1= running batch     
            foreach ($data['running_batch_info'] as $running_batch) {
                $data['course_registrated_student'][$running_batch->course_id] = $this->super_admin_batch_model->get_course_registarted_student($running_batch->course_id);
                $data['batch_created_by'][$running_batch->person_id] = $this->person_model->get_single_person_information_by_person_id($running_batch->person_id);
                $data['batch_resource_person'][$running_batch->resource_person_id] = $this->super_admin_batch_model->get_resource_person_info($running_batch->resource_person_id);
                $data['student_number_in_batch'][$running_batch->course_batch_id] = $this->super_admin_batch_model->count_number_of_student_in_batch($running_batch->course_batch_id);
            }

            $data['finished_batch_info'] = $this->super_admin_batch_model->get_batch_info_by_course($course_id, 2); //2= finished batch      
            foreach ($data['finished_batch_info'] as $finished_batch) {
                $data['course_registrated_student'][$finished_batch->course_id] = $this->super_admin_batch_model->get_course_registarted_student($finished_batch->course_id);
                $data['batch_created_by'][$finished_batch->person_id] = $this->person_model->get_single_person_information_by_person_id($finished_batch->person_id);
                $data['batch_resource_person'][$finished_batch->resource_person_id] = $this->super_admin_batch_model->get_resource_person_info($finished_batch->resource_person_id);
                $data['student_number_in_batch'][$finished_batch->course_batch_id] = $this->super_admin_batch_model->count_number_of_student_in_batch($finished_batch->course_batch_id);
            }

            //cancel batch
            $data['cancel_batch_info'] = $this->super_admin_batch_model->get_batch_info_by_course($course_id, 3); //3=cancel batch      
            foreach ($data['cancel_batch_info'] as $cancel_batch) {
                $data['batch_created_by'][$cancel_batch->person_id] = $this->person_model->get_single_person_information_by_person_id($cancel_batch->person_id);
                $data['batch_resource_person'][$cancel_batch->resource_person_id] = $this->super_admin_batch_model->get_resource_person_info($cancel_batch->resource_person_id);
                $data['student_number_in_batch'][$cancel_batch->course_batch_id] = $this->super_admin_batch_model->count_number_of_student_in_batch($cancel_batch->course_batch_id);
            }

            echo $this->load->view('admin/batch/ajax_page/search_batch_main_content', $data, TRUE);
        } else {
            redirect('/');
        }
    }

    
    /*
     * @Function            : batch_pagination_course_wise 
     * @Description         : displays the pagination in admin course batch
     * @Updated By          : Md Mashqur Ul Alam [14-02-17] 
     * @Parameter           : Null
     * @Return              : NULL    
     * @Status              : Available        
     */
    function batch_pagination_course_wise() {
        $batch_type = $this->input->post('batch_type', TRUE);
        $course_id = $this->input->post('course_id', TRUE);
        $page = $this->input->post('page_number', TRUE);
        $limit = $page * 5 - 5;
        if ($batch_type == 'created') {
            $this->view_created_batch_course_wise($page, $limit, $course_id);
        } else if ($batch_type == 'running') {
            $this->view_running_batch_course_wise($page, $limit, $course_id);
        } else if ($batch_type == 'finished') {
            $this->view_finished_batch_course_wise($page, $limit, $course_id);
        } else if ($batch_type == 'cancel') {
            $this->view_cancel_batch_course_wise($page, $limit, $course_id);
        }
    }

    
    /*
     * @Function            : view_created_batch_course_wise 
     * @Description         : Used in batch_pagination_course_wise
     * @Updated By          : Md Mashqur Ul Alam [14-02-17] 
     * @Parameter           : $page, $limit, $course_id
     * @Return              : NULL    
     * @Status              : Available        
     */
    public function view_created_batch_course_wise($page, $limit, $course_id) {
        $data['course_id'] = $course_id;
        $data['page'] = $page;
        $data['batch_tab'] = $this->get_batch_tab();
        $data['total_created_batch'] = $this->super_admin_batch_model->get_total_batch_by_course($course_id, 4);
        $data['created_batch_info'] = $this->super_admin_batch_model->pagination_get_batch_info_by_course($limit, $course_id, 4);
        foreach ($data['created_batch_info'] as $created_batch) {
            $data['course_registrated_student'][$created_batch->course_id] = $this->super_admin_batch_model->get_course_registarted_student($created_batch->course_id);
            $data['batch_created_by'][$created_batch->person_id] = $this->person_model->get_single_person_information_by_person_id($created_batch->person_id);
            $data['batch_resource_person'][$created_batch->resource_person_id] = $this->super_admin_batch_model->get_resource_person_info($created_batch->resource_person_id);
            $data['student_number_in_batch'][$created_batch->course_batch_id] = $this->super_admin_batch_model->count_number_of_student_in_batch($created_batch->course_batch_id);
        }
        echo $this->load->view('admin/batch/ajax_page/view_created_batch_course_wise', $data, TRUE);
    }

    /*
     * @Function            : view_created_batch_course_wise 
     * @Description         : Used in batch_pagination_course_wise
     * @Updated By          : Md Mashqur Ul Alam [14-02-17] 
     * @Parameter           : $page, $limit, $course_id
     * @Return              : NULL    
     * @Status              : Available        
     */
    public function view_running_batch_course_wise($page, $limit, $course_id) {
        $data['course_id'] = $course_id;
        $data['page'] = $page;
        $data['batch_tab'] = $this->get_batch_tab();
        $data['total_running_batch'] = $this->super_admin_batch_model->get_total_batch_by_course($course_id, 1);
        $data['running_batch_info'] = $this->super_admin_batch_model->pagination_get_batch_info_by_course($limit, $course_id, 1);   //1= running batch     
        foreach ($data['running_batch_info'] as $running_batch) {
            $data['course_registrated_student'][$running_batch->course_id] = $this->super_admin_batch_model->get_course_registarted_student($running_batch->course_id);
            $data['batch_created_by'][$running_batch->person_id] = $this->person_model->get_single_person_information_by_person_id($running_batch->person_id);
            $data['batch_resource_person'][$running_batch->resource_person_id] = $this->super_admin_batch_model->get_resource_person_info($running_batch->resource_person_id);
            $data['student_number_in_batch'][$running_batch->course_batch_id] = $this->super_admin_batch_model->count_number_of_student_in_batch($running_batch->course_batch_id);
        }
        echo $this->load->view('admin/batch/ajax_page/view_running_batch_course_wise', $data, TRUE);
    }

    /*
     * @Function            : view_created_batch_course_wise 
     * @Description         : Used in batch_pagination_course_wise
     * @Updated By          : Md Mashqur Ul Alam [14-02-17] 
     * @Parameter           : $page, $limit, $course_id
     * @Return              : NULL    
     * @Status              : Available        
     */
    public function view_finished_batch_course_wise($page, $limit, $course_id) {
        $data['course_id'] = $course_id;
        $data['page'] = $page;
        $data['batch_tab'] = $this->get_batch_tab();
        $data['total_finished_batch'] = $this->super_admin_batch_model->get_total_batch_by_course($course_id, 2);
        $data['finished_batch_info'] = $this->super_admin_batch_model->pagination_get_batch_info_by_course($limit, $course_id, 2); //2= finished batch      
        foreach ($data['finished_batch_info'] as $finished_batch) {
            $data['course_registrated_student'][$finished_batch->course_id] = $this->super_admin_batch_model->get_course_registarted_student($finished_batch->course_id);
            $data['batch_created_by'][$finished_batch->person_id] = $this->person_model->get_single_person_information_by_person_id($finished_batch->person_id);
            $data['batch_resource_person'][$finished_batch->resource_person_id] = $this->super_admin_batch_model->get_resource_person_info($finished_batch->resource_person_id);
            $data['student_number_in_batch'][$finished_batch->course_batch_id] = $this->super_admin_batch_model->count_number_of_student_in_batch($finished_batch->course_batch_id);
        }
        echo $this->load->view('admin/batch/ajax_page/view_finished_batch_course_wise', $data, TRUE);
    }

    /*
     * @Function            : view_created_batch_course_wise 
     * @Description         : Used in batch_pagination_course_wise
     * @Updated By          : Md Mashqur Ul Alam [14-02-17] 
     * @Parameter           : $page, $limit, $course_id
     * @Return              : NULL    
     * @Status              : Available        
     */
    public function view_cancel_batch_course_wise($page, $limit, $course_id) {
        $data['course_id'] = $course_id;
        $data['page'] = $page;
        $data['batch_tab'] = $this->get_batch_tab();
        $data['total_cancel_batch'] = $this->super_admin_batch_model->get_total_batch_by_course($course_id, 3);
        $data['cancel_batch_info'] = $this->super_admin_batch_model->pagination_get_batch_info_by_course($limit, $course_id, 3); //3=cancel batch      
        foreach ($data['cancel_batch_info'] as $cancel_batch) {
            $data['batch_created_by'][$cancel_batch->person_id] = $this->person_model->get_single_person_information_by_person_id($cancel_batch->person_id);
            $data['batch_resource_person'][$cancel_batch->resource_person_id] = $this->super_admin_batch_model->get_resource_person_info($cancel_batch->resource_person_id);
            $data['student_number_in_batch'][$cancel_batch->course_batch_id] = $this->super_admin_batch_model->count_number_of_student_in_batch($cancel_batch->course_batch_id);
        }
        echo $this->load->view('admin/batch/ajax_page/view_cancel_batch_course_wise', $data, TRUE);
    }

    
    /*
     * @Function            : ajax_edit_batch 
     * @Description         : Displays edit batch form after searching batch from
     *                        admin section
     * @Updated By          : Md Mashqur Ul Alam [15-02-17] 
     * @Parameter           : Null
     * @Return              : NULL    
     * @Status              : Available        
     */
    public function ajax_edit_batch() {
        if ($this->input->is_ajax_request()) {
            $id = $this->input->post('course_batch_id');
            $course_batch_id = $this->utility_model->decode_id($id, 'Tt', '/');
            $data['course_batch_id'] = $course_batch_id;
            $data['batch_info'] = $this->super_admin_batch_model->get_batch_information($course_batch_id);
            $course_id = $data['batch_info']->course_id;
            $data['resourse_person_info'] = $this->super_admin_batch_model->get_resourse_info_by_course_id($course_id);
            $data['course_creator_info'] = $this->super_admin_batch_model->get_creator_info_by_course_id($course_id);
            $data['course_data'] = $this->super_admin_batch_model->select_all_active_courses();
            echo $this->load->view('admin/batch/ajax_page/ajax_edit_batch', $data, true);
        }else{
            redirect('/');
        }
    }

    /*
     * @Function            : ajax_update_batch 
     * @Description         : Updates batch after editing in admin batch section
     * @Updated By          : Md Mashqur Ul Alam [15-02-17] 
     * @Parameter           : Null
     * @Return              : NULL    
     * @Status              : Available        
     */
    public function ajax_update_batch() {
        if ($this->input->is_ajax_request()) {
            $id = $this->input->post('course_batch_id');
            $this->create_batch_form_validation();
            $course_batch_id = $this->utility_model->decode_id($id, 'Tt', '/');
            $data['course_batch_id'] = $course_batch_id;
            $data['batch_info'] = $this->super_admin_batch_model->get_batch_information($course_batch_id);
            $course_id = $data['batch_info']->course_id;
            $data['resourse_person_info'] = $this->super_admin_batch_model->get_resourse_info_by_course_id($course_id);
            $data['course_creator_info'] = $this->super_admin_batch_model->get_creator_info_by_course_id($course_id);
            $data['course_data'] = $this->super_admin_batch_model->select_all_active_courses(); 
            if ($this->form_validation->run() == FALSE) {
                echo $this->load->view('admin/batch/ajax_page/ajax_edit_batch', $data, true);
            } else if ($data['batch_info']->course_batch_status == 3) {
                $this->batch_model->update_batch_information($course_batch_id, 4);
                echo json_encode('updated');
            } else {
                $this->batch_model->update_batch_information($course_batch_id, $data['batch_info']->course_batch_status);
                echo json_encode('updated');
            }
        }else{
            redirect('/');
        }
    }
    /*
     * @Function            : update_batch_tab 
     * @Description         : Updates batch tab for ajax search section
     * @Updated By          : Md Mashqur Ul Alam [15-02-17] 
     * @Parameter           : Null
     * @Return              : NULL    
     * @Status              : Available        
     */
    public function update_batch_tab(){
        $batch_tab = $this->input->post('batch_tab');
        $this->session->set_userdata('batch_tab', $batch_tab);
    }

}
