<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Super_admin extends TT_admin_login {

    public function __construct() {
        parent::__construct();
        $this->person_model->check_person_login_status();  //check login person Status
    }

    /**
     * @Function            : index 
     * @Used IN             : @function-''
     * @Description         : get all available course using category ID  
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 11-05-2016 01:22 PM
     * @Parameter           : NULL
     * @View                : admin/dashboard.php, admin/admin_master.php
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available       
     * */
    public function index() {
        $data = Array();
        $data['active_menu'] = '';
        $data['active_sub_menu'] = '';
        $admin_data = $this->super_admin_model->get_dashboard_data($data);
        $admin_data['main_content'] = $this->load->view('admin/dashboard', $admin_data, true);
        $this->load->view('admin/admin_master', $admin_data);
    }

    /*
     * Start
     * By : Jaherul Islam
     * Description : Add user (ADMIN Part) - 10-11-2016
     */

    /**
     * @Function            : create_new_user 
     * @Used IN             : @function-'get_course_value'  super_admin_course[@controller],
     * @Description         : create new user  
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : Unknown
     * @Updated Date Time   : 03-01-2016 01:38 PM    |   01-03-2016 03:21 PM
     * @Updated By          : Ripon Jaherul          |   Ripon Jaherul      
     * @Status              : available      
     * */
    public function create_new_user($user_role = null) {
        $data = [];
        $this->form_validation->set_rules('person_email', 'Email', 'required|trim|max_length[256]|valid_email|callback_email_check');
        $this->form_validation->set_rules('person_password', 'Password', 'required|min_length[6]|max_length[32]|callback_password_check');
        $this->form_validation->set_rules('person_first_name', 'First Name', 'required|trim|max_length[100]|callback_check_name');
        $this->form_validation->set_rules('person_last_name', 'Last Name', 'trim|max_length[100]');
        $this->form_validation->set_rules('profile_url', 'Profile URL', 'required|trim|callback_profile_url_check');
        $this->form_validation->set_rules('person_gender', 'Gender', 'required');
        $this->form_validation->set_rules('person_birthday', 'Birthday', 'required|callback_birthday_check');
        $this->form_validation->set_rules('country_code', 'Country Code Required', 'trim');
        $this->form_validation->set_rules('person_contact_number', 'Person Contact Number', 'required|trim|max_length[16]|numeric');
        $this->form_validation->set_rules('person_country', 'Country', 'required|max_length[30]');
        $this->form_validation->set_rules('person_city', 'City', 'required');
        $this->form_validation->set_rules('person_address', 'Address', 'required');
        $this->form_validation->set_rules('person_zip', 'Zip', 'required|max_length[11]');
        $this->form_validation->set_rules('person_image', 'Image', 'callback_image_validation');
        $this->form_validation->set_rules('person_role', 'Role', 'required|min_length[1]');

        $person_role = $this->input->post('person_role', TRUE);
        if ($person_role == 4) {
            $this->form_validation->set_rules('organization_name', 'Organization Name', 'required|min_length[1]|max_length[150]');
            $this->form_validation->set_rules('organization_code', 'Organization Code', 'required|min_length[1]|max_length[25]|callback_check_person_organization_code');
        }
        if ($person_role == 3) {
            $this->form_validation->set_rules('resource_person_type', 'Resourse Persson Type', 'required');
        }

        $this->form_validation->set_rules('person_status', 'Status', 'required|min_length[1]');
        $this->form_validation->set_rules('image_path', 'path');

        if ($this->form_validation->run() == FALSE) {
            $data['active_menu'] = 'user_management';
            $data['active_sub_menu'] = $this->session->userdata('user_role_session');
            $data['main_content'] = $this->load->view('admin/add_user_form', $data, true);
            $this->load->view('admin/admin_master', $data);
        } else {
            if ($_POST) {
                $url_data = $this->url_model->add_user_url();
                $person_id = $this->super_admin_model->save_person_information($url_data);
                $person_info = $this->person_model->set_person_id($person_id)->set_field_name('*')->set_info_by_id()->get_info();

                /// send mail to user
                $mdata = array();
                $mdata['person_name'] = $person_info->person_first_name . ' ' . $person_info->person_last_name;
                $mdata['from_address'] = 'no-reply@talhatraining.com';
                $mdata['company_name'] = 'Talha Training';
                $mdata['admin_name'] = 'Talha Training Administrator';
                $mdata['to_address'] = $person_info->person_email;
                $mdata['passsword'] = md5($person_info->person_password);
                $mdata['subject'] = 'Add New User';
                $mdata['site_link'] = (in_array($person_info->person_role, Array(1, 2, 6, 8, 9))) ? 'https://talhatraining.com/babbamamma' : 'https://talhatraining.com/sign-in';
                $this->mailer_model->send_email_to_add_new_user($mdata);


                $this->session->unset_userdata('active_manu_item');

                switch ($person_info->person_role) {
                    case '6':
                        redirect('super-admin-user');
                        break;
                    case '1':
                        redirect('admin-user');
                        break;
                    case '2':
                        redirect('account-officer');
                        break;
                    case '3':
                        redirect('individual-teacher');
                        break;
                    case '4':
                        redirect('organization');
                        break;
                    case '5':
                        redirect('learner');
                        break;

                    default:
                        redirect('super-admin/all-user');
                        break;
                }
            } else {
                $sdata = array();
                $sdata['message'] = '<span class="danger">Please Enter Requred User Information to add a new user</span>';
                $this->session->set_userdata($sdata);
                $this->session->unset_userdata('active_manu_item');
                redirect('super-admin/add-user');
            }
            redirect('super-admin/add-user');
        }
    }

    /**
     * @Description         : check email validation in server side
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 03-12-2016 09:49 PM       
     * */
    public function email_check() {
        $person_email = $this->input->post('person_email', TRUE);
        $email_result = $this->super_admin_model->check_person_email($person_email);
        if ($email_result) {
            $this->form_validation->set_message('email_check', "<p style='color:red;'> Email Already Exits</p>");
            return FALSE;
        } else {
            return TRUE;
        }
    }

    /**
     * @Description         : check password validation in server side
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 03-12-2016 09:49 PM       
     * */
    public function password_check($str) {
        $person_password = $this->input->post('person_password', TRUE);
        $confirm_password = $this->input->post('confirm_password', TRUE);

        $sp = '/[!@#$%&*()^,._;:-]/  ';
        if (preg_match('#[0-9]#', $str) && preg_match('#[a-z]#', $str) && preg_match('#[A-Z]#', $str) && preg_match($sp, $str)) {
            if ($person_password == $confirm_password) {
                return TRUE;
            } else {
                $this->form_validation->set_message('password_check', 'Password Not Matched with Confirm Password !!!');
                return FALSE;
            }
        } else {
            $this->form_validation->set_message('password_check', 'Please Enter Strong Password');
            return FALSE;
        }
    }

    /**
     * @Description         : check User Name validation in server side
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 03-12-2016 09:49 PM       
     * */
    public function check_name($name) {
        $sp = '/[!@#$%&*()^,_;:]/  ';
        if (!preg_match($sp, $name)) {
            return TRUE;
        } else {
            $this->form_validation->set_message('check_name', "Person Name can't contain special Character");
            return FALSE;
        }
    }

    /**
     * @Description         : check person Url validation in server side
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 03-12-2016 09:49 PM       
     * */
    public function profile_url_check($url) {
        $old_url = $this->input->post('old_url');
        if ($old_url == $url) {
            return true;
        } else {
            $result = $this->url_model->check_url_existence($url);
            if ($result == 1) {
                $this->form_validation->set_message('profile_url_check', "URL Already Exist");
                return false;
            } else {
                $sp = '/[!@\#$%&*()^,_";:]/';
                if (preg_match($sp, $url)) {
                    $this->form_validation->set_message('profile_url_check', "URL Cann't contain any '/[!@#$%&*()^,._;:]/'  if need use '-' Don't use Space");
                    return FALSE;
                } else if (strstr($url, ' ')) {
                    $this->form_validation->set_message('profile_url_check', " Don't use Space if need use '-', alse URL Cann't contain any special carecter like '/[!@#$%&*()^,._;:-]/'");
                    return FALSE;
                } else if (preg_match('/--/', $url)) {
                    $this->form_validation->set_message('profile_url_check', "URL Cann't contain multiple hypen");
                    return FALSE;
                } else if (substr($url, (strlen($url) - 1)) == '-') {
                    $this->form_validation->set_message('profile_url_check', "No hypen allow at the last");
                    return FALSE;
                } else {
                    $this->form_validation->set_message('profile_url_check', "OK");
                    return TRUE;
                }
            }
        }
    }

    /**
     * @Description         : check birthday validation in server side
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 03-12-2016 09:49 PM       
     * */
    public function birthday_check() {
        $date = new DateTime();
        $current_date = $date->format('Y-m-d');
        $person_birthday = $this->input->post('person_birthday', TRUE);
        if ($current_date < $person_birthday) {
            $this->form_validation->set_message('birthday_check', "<p style='color:red;'> Invalid Person Birthday</p>");
            return FALSE;
        } else {
            return TRUE;
        }
    }

    /**
     * @Description         : check image validation in server side
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 03-12-2016 09:49 PM       
     * */
    public function image_validation() {
        $allowed_type = array('gif', 'jpg', 'png', 'jpeg');
        $selected_file_type = explode('/', $_FILES['person_image']['type']);
        if ($_FILES['person_image']['name']) {
            if (in_array(strtolower($selected_file_type[1]), $allowed_type)) {
                if ($_FILES['person_image']['size'] < 2097152) {
                    return TRUE;
                } else {
                    $this->form_validation->set_message('image_validation', "Image Format will be Less than 2mb");
                    return FALSE;
                }
            } else {
                $this->form_validation->set_message('image_validation', "Image Format will be JPG,PNG,GIF");
                return FALSE;
            }
        } else {
            return TRUE;
        }
    }

    /**
     * @Description         : check organization code validation in server side
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 03-12-2016 09:49 PM       
     * */
    public function check_person_organization_code() {
        $person_role = $this->input->post('person_role', TRUE);

        if ($person_role == 3) {
            return true;
            $org_id = $this->input->post('selected_organization_id', TRUE);
            $org_code = $this->input->post('selected_organization_code', TRUE);
            if ($org_id == 'individual') {
                return TRUE;
            }
            if ($org_code == '') {
                $this->form_validation->set_message('check_person_organization_code', "<p style='color:red;'> * Please Enter Organization Code </p>");
                return FALSE;
            } else {
                $result = $this->super_admin_model->check_organization_name_code($org_code, $org_id);
                if (!$result) {
                    $this->form_validation->set_message('check_person_organization_code', "<p style='color:red;'> * Organization Code Not Matched</p>");
                    return FALSE;
                }
            }
        } else if ($person_role == 4) {
            $org_code = $this->input->post('organization_code', TRUE);
            if ($org_code == '') {
                $this->form_validation->set_message('check_person_organization_code', "<p style='color:red;'> * Please Enter Organization Code </p>");
                return FALSE;
            } else {
                $result = $this->super_admin_model->select_organization_by_code($org_code);
                if ($result) {
                    $this->form_validation->set_message('check_person_organization_code', "<p style='color:red;'> * Organization Code is Allready Exist </p>");
                    return FALSE;
                } else {
                    return TRUE;
                }
            }
        }
    }

    /**
     * @Description         : check person url validation in client side
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 03-12-2016 09:51 PM       
     * */
    public function check_profile_id_existance2($profile_url) {
        echo $this->url_model->make_existence_url($profile_url);
    }

    /**
     * @Description         : check person url validation in client side
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 03-12-2016 09:51 PM       
     * */
    public function check_profile_id_existance($url) {
        echo $this->url_model->check_url_existence($url);
    }

    /**
     * @Description         : check email validation in client side
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 03-12-2016 09:51 PM       
     * */
    public function check_user_email($user_email_address) {
        $result = $this->super_admin_model->check_person_email($user_email_address);
        if ($result) {
            echo '1';
        } else {
            echo '2';
        }
    }

    /**
     * @Description         : check person url validation in client side
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 03-12-2016 09:51 PM       
     * */
    public function check_user_organization_code($user_organization_code) {
        $result = $this->super_admin_model->select_organization_by_code($user_organization_code);
        if ($result) {
            echo '1';
        } else {
            echo '2';
        }
    }

    /*
     * END
     * By : Jaherul Islam
     * Description : Add user (ADMIN Part) - 10-11-2016
     */




    /*
     * 
     * 
     * START
     * By : Jaherul Islam
     * Description : Update user (ADMIN Part) - 10-11-2016
     * -------------------------------------------------------------------
     */

    /**
     * @Function            : edit_user_information 
     * @Used IN             : @function-'self'      
     * @Description         : Edit user information
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : Unknown
     * @Updated Date Time   : 01-02-2016 01:38 PM   |   01-03-2016 05:21 PM
     * @Updated By          : Ripon Jaherul         |   Ripon Jaherul      
     * @Status              : available      
     * */
    public function edit_user_information($url) {
        $data = [];
        $data['user_info'] = $this->person_model->set_person_url($url)->set_field_name('*')->set_info_by_url()->get_info();
        $role_name = 'All';
        $person_id = $data['user_info']->person_id;

        if ($data['user_info']->person_role == 4) {
            $data['user_info_organization'] = $this->utility_model->set_single_row_info('*', 'tbl_organization', ['person_id' => $person_id])->get_single_row_info();
        } else if ($data['user_info']->person_role == 3) {
            $data['user_info_resource_person'] = $this->utility_model->set_single_row_info('*', 'tbl_resource_person', ['person_id' => $person_id])->get_single_row_info();
        }

        if ($this->input->post('old_person_email', TRUE) != $this->input->post('person_email', TRUE)) {
            $this->form_validation->set_rules('person_email', 'Email', 'required|trim|max_length[256]|valid_email|callback_email_check');
        }

        if ($this->input->post('person_password', TRUE)) {
            $this->form_validation->set_rules('person_password', 'Password', 'required|min_length[6]|max_length[32]|callback_password_check');
        }

        $this->form_validation->set_rules('person_first_name', 'First Name', 'required|trim|max_length[100]|callback_check_name');
        $this->form_validation->set_rules('person_last_name', 'Last Name', 'trim|max_length[100]');

        $person_url = $this->input->post('profile_url', TRUE);
        $person_old_url = $this->input->post('old_url', TRUE);

        if ($person_url != $person_old_url) {
            $this->form_validation->set_rules('profile_url', 'Profile URL', 'required|trim|callback_profile_url_check_for_edit[' . $data['user_info']->person_last_change_url_date . ']');
        }

        $this->form_validation->set_rules('person_gender', 'Gender', 'required');
        $this->form_validation->set_rules('person_birthday', 'Birthday', 'required|callback_birthday_check');
        $this->form_validation->set_rules('country_code', 'Country Code Required', 'trim');
        $this->form_validation->set_rules('person_contact_number', 'Person Contact Number', 'required|trim|max_length[16]|numeric');
        $this->form_validation->set_rules('person_country', 'Country', 'required|max_length[30]');
        $this->form_validation->set_rules('person_city', 'City', 'required');
        $this->form_validation->set_rules('person_address', 'Address', 'required');
        $this->form_validation->set_rules('person_zip', 'Zip', 'required|max_length[11]');
        $this->form_validation->set_rules('person_new_image', 'Image', 'callback_image_validation');
        $this->form_validation->set_rules('person_role', 'Role', 'required|min_length[1]');

        $person_role = $this->input->post('person_role', TRUE);
        if ($person_role == 4) {
            $this->form_validation->set_rules('organization_name', 'Organization Name', 'required|min_length[1]|max_length[150]');

            if ($this->input->post('old_organization_code', TRUE)) {
                if ($this->input->post('old_organization_code', TRUE) != $this->input->post('organization_code', TRUE)) {
                    $this->form_validation->set_rules('organization_code', 'Organization Code', 'required|min_length[1]|max_length[25]|callback_check_person_organization_code');
                }
            } else {
                $this->form_validation->set_rules('organization_code', 'Organization Code', 'required|min_length[1]|max_length[25]|callback_check_person_organization_code');
            }
        }
        if ($person_role == 3) {
            $this->form_validation->set_rules('resource_person_type', 'Resourse Persson Type', 'required');
        }

        $this->form_validation->set_rules('person_status', 'Status', 'required|min_length[1]');
        $this->form_validation->set_rules('image_path', 'path');
        $data['user_role'] = $role_name;
// date diffenent for url change
        if ($data['user_info']->person_last_change_url_date) {
            $user_date = $data['user_info']->person_last_change_url_date;
            $current_date = date('Y-m-d', time() - $this->session->userdata('time_offset'));
            $data['url_change_different'] = $this->cf->dateDifference($current_date, $user_date);
        }

        $data['user_role'] = $role_name;
        if ($this->form_validation->run() == FALSE) {
            $data['active_menu'] = 'user_management';
            $data['active_sub_menu'] = $this->session->userdata('user_role_session');
            $data['main_content'] = $this->load->view('admin/edit_user_form', $data, true);
            $this->load->view('admin/admin_master', $data);
        } else {
            $url_data = $this->url_model->update_user_url();
            $person_id1 = $this->super_admin_model->update_user_information($person_id, $url_data);
            $person_info = $this->person_model->set_person_id($person_id1)->set_field_name('*')->set_info_by_id()->get_info();
            // send mail to user
            $mdata = array();
            $mdata['person_name'] = $person_info->person_first_name . ' ' . $person_info->person_last_name;
            $mdata['from_address'] = 'no-reply@talhatraining.com';
            $mdata['company_name'] = 'Talha Training';
            $mdata['admin_name'] = 'Talha Training Administrator';
            $mdata['to_address'] = $person_info->person_email;
            $password = $this->input->post('person_password', TRUE);
            if($password){
            $mdata['password'] = $password;
            }else{
                $mdata['password'] = 'Password not changed';
            }
            $mdata['subject'] = 'Update User Informaation';
            $mdata['site_link'] = (in_array($person_info->person_role, Array(1, 2, 6, 8, 9))) ? 'https://talhatraining.com/babbamamma' : 'https://talhatraining.com/sign-in';
            $this->mailer_model->send_email_to_update_user($mdata);

            switch ($person_info->person_role) {
                case '6':
                    redirect('super-admin-user');
                    break;
                case '1':
                    redirect('admin-user');
                    break;
                case '2':
                    redirect('account-officer');
                    break;
                case '3':
                    redirect('individual-teacher');
                    break;
                case '4':
                    redirect('organization');
                    break;
                case '5':
                    redirect('learner');
                    break;

                default:
                    redirect('super-admin/all-user');
                    break;
            }
        }
    }

    /**
     * @Description         : check person url validation in client side when edit user
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 03-12-2016 10:08 AM       
     * */
    public function profile_url_check_for_edit($url, $user_edit_date) {
        $url_change_different = '';
        if ($user_edit_date != '') {
            $current_date = date('Y-m-d', time() - $this->session->userdata('time_offset'));
            $url_change_different = $this->cf->dateDifference($current_date, $user_edit_date);
        }
        $old_url = $this->input->post('old_url');
        if ($old_url == $url) {
            return true;
        } else {
            $result = $this->url_model->check_url_existence($url);
            if ($result == 1) {
                $this->form_validation->set_message('profile_url_check_for_edit', "URL Already Exist");
                return false;
            } else {
                $sp = '/[!@\#$%&*()^,_";:]/';
                if (preg_match($sp, $url)) {
                    $this->form_validation->set_message('profile_url_check_for_edit', "URL Cann't contain any '/[!@#$%&*()^,._;:]/'  if need use '-' Don't use Space");
                    return FALSE;
                } else if (strstr($url, ' ')) {
                    $this->form_validation->set_message('profile_url_check_for_edit', " Don't use Space if need use '-', alse URL Cann't contain any special carecter like '/[!@#$%&*()^,._;:-]/'");
                    return FALSE;
                } else if (preg_match('/--/', $url)) {
                    $this->form_validation->set_message('profile_url_check_for_edit', "URL Cann't contain multiple hypen");
                    return FALSE;
                } else if (substr($url, (strlen($url) - 1)) == '-') {
                    $this->form_validation->set_message('profile_url_check_for_edit', "No hypen allow at the last");
                    return FALSE;
                } else if ($url_change_different != '') {
                    if ($url_change_different < 1) {
                        $this->form_validation->set_message('profile_url_check_for_edit', "You can not change your url within 1 days");
                        return FALSE;
                    }
                } else {
                    $this->form_validation->set_message('profile_url_check_for_edit', "OK");
                    return TRUE;
                }
            }
        }
    }

    /*
     * 
     * ----------------------------------------------------
     * END
     * By : Jaherul Islam
     * Description : Update user (ADMIN Part) - 10-11-2016
     */




    /*
     * @@Start
     * By : Jaherul Islam
     * Description : View user (ADMIN Part) - 01-12-2016
     */

    /**
     * @Function            : user_list 
     * @Used IN             : @function-'get_course_value'  super_admin_course[@controller],
     * @Description         : view all user
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : Unknown
     * @Parameter           : $arg[STRING], $arg1[INTEGER]
     * @View                : admin/user_list.php,admin/admin_master.php
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available       
     * */
    public function user_list($arg = NULL, $arg1 = NULL) {
        $data = array();
        $data['page'] = 1;
        $data['active_menu'] = 'user_management';

        if ($arg == NULL) {
            $number = 0;
            $data['sort_by'] = '';
            $sdata['session_user_view_per_page'] = 10;
            $sdata['session_limit_value'] = $number;
            $this->session->set_userdata($sdata);
            $this->session->unset_userdata('user_role_session');
            $this->session->unset_userdata('sort_user_session');
            $this->session->unset_userdata('status_user_session');
        } elseif ($arg == 'role') {
            $data['sort_by'] = $this->session->userdata('sort_user_session');
            $sData['user_role_session'] = $arg1;
            $sData['session_limit_value'] = 0;
            $this->session->set_userdata($sData);
        } elseif ($arg == 'asc' | $arg == 'desc') {
            $data['sort_by'] = $arg;
            $sData['sort_user_session'] = $arg;
            $this->session->set_userdata($sData);
        } else {
            $data['sort_by'] = $this->session->userdata('sort_user_session');
            $per_page_view = $this->session->userdata('session_user_view_per_page');
            $data['page'] = $arg;
            $sData['session_limit_value'] = $arg * $per_page_view - $per_page_view;
            $this->session->set_userdata($sData);
        }

        $data['active_sub_menu'] = $role = $this->session->userdata('user_role_session');
        $sort = $this->session->userdata('sort_user_session');
        $status = $this->session->userdata('status_user_session');
        $start_limit_value = $this->session->userdata('session_limit_value');
        $per_page_view = ($this->session->userdata('session_user_view_per_page') != '') ? $this->session->userdata('session_user_view_per_page') : 10;
        $search_value = '';

        $data['total_user'] = $this->super_admin_model->get_total_user($role, $status, $search_value);
        $data['users'] = $this->super_admin_model->select_all_user($role, $status, $search_value, $sort, $start_limit_value, $per_page_view);
        foreach ($data['users'] as $user_value) {
            if ($user_value->person_role == '3') {
                $data['resource_person_info'][$user_value->person_id] = $this->resource_person_model->set_person_id($user_value->person_id)->get_info_by_person_id();
            }
        }
        $data['main_content'] = $this->load->view('admin/user_list', $data, true);
        $this->load->view('admin/admin_master_user_management_left_menu', $data);
    }
    
    /**
     * @Function            : send_email_to_user_for_security_reset_password 
     * @Description         : used to send email for security password reset
     * Developed By         : Md. Delwar Hossain
     * @Developed date      : 10-04-2017  
     * @Parameter           : $id
     * @View                : mailscripts/security_reset_password_link
     * @Return              : none  
     * @Status              : Available       
     * */
    function send_email_to_user_for_security_reset_password($id) {
        $p_id = str_replace("%F2", "/", $id);
        $person_id = $this->encryption->decrypt($p_id);
        $user_info = $this->super_admin_model->get_single_user_info($person_id); 
        $this->sign_up_model->password_recovery_request_status($user_info->person_id);

        $mdata = array();
        $mdata['person_id'] = $user_info->person_id;
        $mdata['person_name'] = $user_info->person_first_name;
        $mdata['from_address'] = 'no-replay@talhatraining.com';
        $mdata['company_name'] = 'Talha Training';
        $mdata['admin_name'] = 'Talha Training';
        $mdata['to_address'] = $user_info->person_email;
        $mdata['subject'] = 'For security purposes, your TalhaTraining account has been locked';
        $mdata['site_link'] = base_url() . 'recover-password/' . $id;
        $this->mailer_model->send_email($mdata, 'security_reset_password_link');
        redirect('super-admin/all-user');
    }
    
    /**
     * 
     * 
     * 
     * @Description         : get all search value in user list
     * @Developed By        : MD Jaherul Islam  
     * @Start DateTime      : 03-12-2016 10:31 AM          
     * */
    public function get_search_value($search_value1) {
        if ($search_value1 != 'null') {
            $data['search_value'] = urldecode($search_value1);
            $data['page'] = 1;
            $sdata['session_limit_value'] = 0;
            $this->session->set_userdata($sdata);
        } else {
            $data['search_value'] = '';
            $data['page'] = 1;
            $sdata['session_limit_value'] = 0;
            $this->session->set_userdata($sdata);
        }

        $role = $this->session->userdata('user_role_session');
        $sort = $this->session->userdata('sort_user_session');
        $status = $this->session->userdata('status_user_session');
        $start_limit_value = $this->session->userdata('session_limit_value');
        $per_page_view = $this->session->userdata('session_user_view_per_page');

        $data['total_user'] = $this->super_admin_model->get_total_user($role, $status, $data['search_value']);
        $data['users'] = $this->super_admin_model->select_all_user($role, $status, $data['search_value'], $sort, $start_limit_value, $per_page_view);
        echo $this->load->view('admin/ajax_view/view_user_list', $data, true);
    }

    /**
     * 
     * 
     * 
     * @Description         : get all user when select any user_role
     * @Developed By        : MD Jaherul Islam  
     * @Start DateTime      : 03-12-2016 10:25 AM          
     * */
    public function get_header_role_value($person_role) {
        if ($person_role != 'null') {
            $this->session->unset_userdata('user_role_session');
            $data['page'] = 1;
            $sData['user_role_session'] = $person_role;
            $sData['session_limit_value'] = 0;
            $this->session->set_userdata($sData);
        } else {
            $person_role = '';
            $data['page'] = 1;
            $sData['user_role_session'] = $person_role;
            $sData['session_limit_value'] = 0;
            $this->session->set_userdata($sData);
        }

        $role = $this->session->userdata('user_role_session');
        $sort = $this->session->userdata('sort_user_session');
        $status = $this->session->userdata('status_user_session');
        $start_limit_value = $this->session->userdata('session_limit_value');
        $per_page_view = $this->session->userdata('session_user_view_per_page');
        $search_value = '';

        $data['total_user'] = $this->super_admin_model->get_total_user($role, $status, $search_value);
        $data['users'] = $this->super_admin_model->select_all_user($role, $status, $search_value, $sort, $start_limit_value, $per_page_view);
        echo $this->load->view('admin/ajax_view/view_user_list', $data, true);
    }

    /**
     * 
     * 
     * 
     * @Description         : view upper button
     * @Developed By        : MD Jaherul Islam   
     * */
    public function get_view_upper_button() {
        $data['person_role'] = $this->session->userdata('person_role');
        $data['selected_person_role'] = $this->session->userdata('user_role_session');
        $data['sort_by'] = $this->session->userdata('sort_user_session');

        echo $this->load->view('admin/ajax_view/view_upper_button', $data, true);
    }

    /**
     * 
     * 
     * 
     * @Description         : get all user when select any status
     * @Developed By        : MD Jaherul Islam     
     * */
    public function get_user_status_value($person_status) {
        if ($person_status != 'null') {
            $this->session->unset_userdata('status_user_session');
            if ($person_status == 3) {
                $person_status = '0,3';
            }
            $data['page'] = 1;
            $sData['status_user_session'] = $person_status;
            $sData['session_limit_value'] = 0;
            $this->session->set_userdata($sData);
        } else {
            $person_status = '';
            $data['page'] = 1;
            $sData['status_user_session'] = $person_status;
            $sData['session_limit_value'] = 0;
            $this->session->set_userdata($sData);
        }

        $role = $this->session->userdata('user_role_session');
        $sort = $this->session->userdata('sort_user_session');
        $status = $this->session->userdata('status_user_session');
        $start_limit_value = $this->session->userdata('session_limit_value');
        $per_page_view = $this->session->userdata('session_user_view_per_page');
        $search_value = '';

        $data['total_user'] = $this->super_admin_model->get_total_user($role, $status, $search_value);
        $data['users'] = $this->super_admin_model->select_all_user($role, $status, $search_value, $sort, $start_limit_value, $per_page_view);
        echo $this->load->view('admin/ajax_view/view_user_list', $data, true);
    }

    /**
     * 
     * 
     * 
     * @Description         : change user role by modal
     * @Developed By        : MD Jaherul Islam     
     * */
    public function change_user_role($person_id, $old_person_role = NULL) {
        $org_name_status = '';
        $org_code_status = '';
        $urlSpecialCharacter = '/^[0-9a-zA-Z\-]+$/';
        $person_role = $this->input->post('person_role', TRUE);

        if ($person_role == '') {
            echo 'startRole>Please Select Person Role<endRole';
        } else {
            if ($person_role == 3) {
                $resource_person_type = $this->input->post('resource_person_type', TRUE);
                if ($resource_person_type == '') {
                    echo 'startResourcePersonType>Please Select Resourse Person Type<endResourcePersonType';
                } else {
                    // Save resource persom information
                    $this->resource_person_model->set_person_id($person_id)
                            ->set_resource_person_type($resource_person_type)->save();

                    // Change person role
                    $this->person_model->set_person_id($person_id)->person_role = $person_role;
                    $this->person_model->update();
                    echo 'success';
                }
            } else if ($person_role == 4) {
                $organization_name = $this->input->post('organization_name', TRUE);
                $organization_code = $this->input->post('organization_code', TRUE);

                if ($organization_name == '') {
                    echo 'startOrgName>Please Select Organization Name<endOrgName';
                } else if (strlen($organization_name) > 150) {
                    echo 'startOrgName>Organization Name less than 150 character<endOrgName';
                } else {
                    $org_name_status = 1;
                }

                if ($organization_code == '') {
                    echo 'startOrgCode>Please Select Organization Code<endOrgCode';
                } elseif (strlen($organization_code) > 25) {
                    echo 'startOrgCode>Organization Code less than 25 character<endOrgCode';
                } elseif ($this->check_user_organization_code($organization_code) == 1) {
                    echo 'startOrgCode>Organization Code Exists<endOrgCode';
                } elseif (!preg_match($urlSpecialCharacter, $organization_code)) {
                    echo 'startOrgCode>No special Character allow<endOrgCode';
                } else {
                    $org_code_status = 1;
                }

                if ($org_name_status == 1 && $org_code_status == 1) {
                    // Save Organization information
                    $this->organization_model->person_id = $person_id;
                    $this->organization_model->organization_name = $organization_name;
                    $this->organization_model->organization_code = $organization_code;
                    $this->organization_model->organization_status = 1;
                    $organization_id = $this->organization_model->set_table_name('tbl_organization')->save()->create_insert_id()->get_id();

                    if ($old_person_role == 5) {
                        // Save resource persom information
                        $resource_person_id = $this->resource_person_model->set_person_id($person_id)
                                        ->set_resource_person_type(3)->save()->create_insert_id()->get_id();
                    } else {
                        $resource_person_info = $this->resource_person_model->set_person_id($person_id)->get_info_by_person_id();

//                        // Update resource persom information
                        $this->resource_person_model->set_resource_person_id($resource_person_info->resource_person_id)->resource_person_type = 3;
                        $this->resource_person_model->update();
                        $resource_person_id = $resource_person_info->resource_person_id;
                    }

                    // Save organization resource person information
                    $this->organization_model->set_empty();
                    $this->organization_model->organization_id = $organization_id;
                    $this->organization_model->resource_person_id = $resource_person_id;
                    $this->organization_model->set_table_name('tbl_organization_resource_person')->save();
                    // Change person role
                    $this->person_model->set_person_id($person_id)->person_role = $person_role;
                    $this->person_model->update();
                    echo 'success';
                }
            } else {
                // Change person role
                $this->person_model->set_person_id($person_id)->person_role = $person_role;
                $this->person_model->update();
                echo 'success';
            }
        }
    }

    /**
     * 
     * @Description         : Make user active
     * @Developed By        : MD Jaherul Islam  
     * @Develop Date Time   : 03-12-2016 11:09 AM   
     * */
    public function make_user_active($person_id) {
        $this->person_model->set_person_id($person_id)->person_status = 1;
        $this->person_model->update();
        $data['person_info'] = $this->person_model->set_field_name('*')->set_info_with_url_by_id()->get_info();
        echo $this->load->view('admin/user_list_action', $data, TRUE);
    }

    /**
     * 
     * @Description         : Make user inactive
     * @Developed By        : MD Jaherul Islam  
     * @Develop Date Time   : 03-12-2016 11:19 AM   
     * */
    public function make_user_inactive($person_id) {
        $this->person_model->set_person_id($person_id)->person_status = 3;
        $this->person_model->update();
        $data['person_info'] = $this->person_model->set_field_name('*')->set_info_with_url_by_id()->get_info();
        echo $this->load->view('admin/user_list_action', $data, TRUE);
    }

    /**
     * 
     * @Description         : Make user archive
     * @Developed By        : MD Jaherul Islam  
     * @Develop Date Time   : 03-12-2016 11:09 AM   
     * */
    public function make_user_archive($person_id) {
        $this->person_model->set_person_id($person_id)->person_status = 2;
        $this->person_model->update();
        $data['person_info'] = $this->person_model->set_field_name('*')->set_info_with_url_by_id()->get_info();
        echo $this->load->view('admin/user_list_action', $data, TRUE);
    }

    /**
     * 
     * 
     * 
     * @Description         : Delete user
     * @Developed By        : MD Jaherul Islam  
     * @Develop Date Time   : 02-12-2016 03:27 PM   
     * */
    public function delete_user($person_url) {
        $user_info = $this->person_model->set_person_url($person_url)->set_field_name('person_id,person_role')->set_info_by_url()->get_info();
        if ($user_info) {
            $person_view_status = $this->utility_model->set_single_row_info('*', 'tbl_person_info_view_status', ['person_id' => $user_info->person_id])->get_single_row_info();
            if ($person_view_status) {
                $this->utility_model->set_table_id('person_id')->set_id($user_info->person_id)
                        ->set_table('tbl_person_info_view_status')->delete();
            }

            if ($user_info->person_role == 4) {
                $resource_person = $this->utility_model->set_single_row_info('*', 'tbl_resource_person', ['person_id' => $user_info->person_id])->get_single_row_info();

                if ($resource_person) {
                    $this->utility_model->set_table_id('resource_person_id')->set_id($resource_person->resource_person_id)
                            ->set_table('tbl_organization_resource_person')->delete();
                }

                $this->utility_model->set_table_id('person_id')->set_id($user_info->person_id)
                        ->set_table('tbl_organization')->delete();
                $this->utility_model->set_table_id('person_id')->set_id($user_info->person_id)
                        ->set_table('tbl_resource_person')->delete();
            }

            if ($user_info->person_role == 3) {
                $this->utility_model->set_table_id('person_id')->set_id($user_info->person_id)
                        ->set_table('tbl_resource_person')->delete();
            }

            $this->utility_model->set_table_id('url')->set_id($person_url)
                    ->set_table('tbl_url')->delete();
            $this->person_model->set_person_id($user_info->person_id)->delete();
        }

        $dir = 'content-library/' . $person_url;
        $this->utility_model->remove_directory($dir);

        $person_role = $this->session->userdata('user_role_session');
        switch ($person_role) {
            case '6':
                redirect('super-admin-user');
                break;
            case '1':
                redirect('admin-user');
                break;
            case '2':
                redirect('account-officer');
                break;
            case '3':
                redirect('individual-teacher');
                break;
            case '4':
                redirect('organization');
                break;
            case '5':
                redirect('learner');
                break;

            default:
                redirect('super-admin/all-user');
                break;
        }
    }

    /**
     * 
     * 
     * 
     * @Description         : change status for multiple user
     * @Developed By        : MD Jaherul Islam   
     * @Develop Date Time   : (-) - 02-12-2016 03:27 PM   
     * */
    public function change_header_status($user_list, $selected_status, $person_id) {
        $result = $this->person_model->set_person_id($person_id)->set_field_name('person_role')->set_info_by_id()->get_info();
        $person_array = array_filter(explode(",", $user_list));
        if ($result->person_role == 1) {
            for ($i = 0; $i < count($person_array); $i++) {
                $person_info = $this->person_model->set_person_id($person_array[$i])->set_field_name('person_role')->set_info_by_id()->get_info();
                if ($person_info->person_role == 6) {
                    echo 'super_admin';
                    break;
                } else if ($person_id == $person_array[$i]) {
                    echo 'self_id';
                    break;
                } else {
                    $this->person_model->person_status = $selected_status;
                    $this->person_model->update();
                }
            }
        } else if ($result->person_role == 6) {
            for ($i = 0; $i < count($person_array); $i++) {
                if ($person_id == $person_array[$i]) {
                    echo 'self_id';
                    break;
                } else {
                    $this->person_model->set_person_id($person_array[$i])->person_status = $selected_status;
                    $this->person_model->update();
                }
            }
        }
    }

    /**
     * 
     * 
     * 
     * @Description         : get prepare value
     * @Developed By        : MD Jaherul Islam  
     * @Develop Date Time   : (-) - 02-12-2016 03:27 PM   
     * */
    public function get_perpage_value($value) {
        if ($value) {
            $sData['session_user_view_per_page'] = $value;
            $this->session->set_userdata($sData);
        }
        $data['page'] = 1;
        $role = $this->session->userdata('user_role_session');
        $sort = $this->session->userdata('sort_user_session');
        $status = $this->session->userdata('status_user_session');
        $start_limit_value = $this->session->userdata('session_limit_value');
        $per_page_view = $this->session->userdata('session_user_view_per_page');
        $search_value = '';

        $data['total_user'] = $this->super_admin_model->get_total_user($role, $status, $search_value);
        $data['users'] = $this->super_admin_model->select_all_user($role, $status, $search_value, $sort, $start_limit_value, $per_page_view);
        echo $this->load->view('admin/ajax_view/view_user_list', $data, true);
    }

    /**
     * 
     * 
     * 
     * @Description         : view error page
     * @Developed By        : MD Jaherul Islam 
     * @Develop Date Time   : (-) - 02-12-2016 03:27 PM    
     * */
    public function manage_error() {
        $data = array();
        $data['active_menu'] = '';
        $data['active_sub_menu'] = '';
        $data['main_content'] = $this->load->view('admin/error_page', $data, true); //error_page
        $this->load->view('admin/admin_master', $data);
    }

    /*
     * 
     * 
     * 
     * @@End
     * By : Jaherul Islam
     * Description : View user (ADMIN Part) - 01-12-2016
     */

    /**
     * @Description         : View single user details 
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 02-02-2016 01:38 PM
     * @Updated By          : Md Mashqur Ul Alam
     * @Updated Date Time   : 03-01-17 10:00 AM
     * @Updated By          : MD Jaherul Islam  
     * */
    public function view_detail($url) {
        $data1 = array();
        $profile_url = $url;
        $data1['person_info'] = $this->person_model->get_single_person_information_by_person_url($url);        
        $data1['active_menu'] = 'user_management';
        $data1['active_sub_menu'] = $data1['person_info']->person_role;
        
        $data = $this->super_admin_model->assign_data_for_fromt_end_user_view($data1);
        $person_id = $data['person_info']->person_id;
        $data['tab'] = 1;

        if ($data['person_info']->person_role == 4) {
//            $data['org_info'] = $this->super_admin_model->select_organization_information($person_id);
//            $sdata['number_of_classroom'] = count($this->super_admin_organization_model->select_all_classroom($person_id, '', '', ''));
            $sdata['number_of_student'] = '';
            $sdata['number_of_resource_person'] = '';
            $this->session->set_userdata($sdata);
        }
        $data['active_tab'] = 'add_education';

        //$data['person_education_details'] = $this->super_admin_model->select_user_education_details_by_id($person_id);
        //$data['person_work_details'] = $this->super_admin_model->select_user_work_details_by_id($person_id);
        //$data['person_browse_details'] = $this->super_admin_model->select_person_browse_details_by_id($person_id);
        $data['person_feature_details'] = $this->super_admin_model->select_person_feature_details_by_id($person_id);
        $data['person_self_assessmet_skills'] = $this->super_admin_model->select_self_assessment_skills_by_id($person_id);
        //$data['person_interest_field'] = $this->super_admin_model->select_user_interest_field_all($person_id);
        $data['person_language'] = $this->super_admin_model->select_person_language_by_id($person_id);

        // Counts the number of links associated with this id
        $data['friends_details_part1'] = $this->profile_model->select_my_friends_details_part1($person_id);
        $part1_total = count($data['friends_details_part1']);
        $data['friends_details_part2'] = $this->profile_model->select_my_friends_details_part2($person_id);
        $part2_total = count($data['friends_details_part2']);
        $data['total_friends'] = $part1_total + $part2_total;
        
        // following section added by Mashqur
        $data['profile_url'] = $profile_url;
        $data['current_city'] = $this->load->view('admin/person_profile/admin_current_location', '', true);
        $data['travels'] = $this->load->view('admin/person_profile/admin_travel_location', '', true);
        $data['connectivity'] = $this->load->view('admin/person_profile/admin_links_network', '', true);
        $data['my_link'] = $this->load->view('admin/person_profile/admin_my_link', '', true);
        $data['user_work_details'] = $this->profile_model->select_user_work_details($person_id);        
        $data['user_education_details'] = $this->profile_model->select_user_education_details($person_id);
        $data['interest_field_info_all'] = $this->profile_model->select_user_interest_field_all($person_id);        
        $data = $this->quiz_model->view_quiz_result_for_profile($person_id, $data); // gets the detail for quiz result
        $data['main_content'] = $this->load->view('admin/person_detail_profile', $data, true);
        $this->load->view('admin/admin_master', $data);
    }

    /**
     * @Description         : View payment details details
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 02-02-2016 01:38 PM
     * @Updated Date Time   : 02-02-2016 01:38 PM
     * @Updated By          : MD Jaherul Islam  
     * */
    public function user_payment_details($url) {
        $data = array();
        $person_id_obj = $this->super_admin_model->get_person_id_by_url($url);
        $person_id = $person_id_obj->person_id;
        $data['user_role'] = '';
        $data['tab'] = 1;
        $data['person_info'] = $this->super_admin_model->select_user_information_by_id($person_id);

//        if ($data['person_info']->person_role == 4) {
//            $data['org_info'] = $this->super_admin_model->select_organization_information($person_id);
//            $sdata['number_of_classroom'] = count($this->super_admin_organization_model->select_all_classroom($person_id, '', '', ''));
//            $sdata['number_of_student'] = '';
//            $sdata['number_of_resource_person'] = '';
//            $this->session->set_userdata($sdata);
//        }
        $person_role = $this->session->userdata('person_role');
        $data['active_menu'] = 'user_management';
        $data['active_sub_menu'] = $data['person_info']->person_role;
        if ($person_role === 'organization') {
            $data['active_top_menu'] = 1;
        } else {
            $data['active_top_menu'] = 0;
        }
        if ($person_role === 'resource_person') {
            $data['inactive_organization_top_menu'] = 1;
        } else {
            $data['inactive_organization_top_menu'] = 0;
        }
        if ($person_role === 'learner') {
            $data['inactive_organization_teacher_top_menu'] = 1;
        } else {
            $data['inactive_organization_teacher_top_menu'] = 0;
        }

        $data['main_content'] = $this->load->view('admin/user/user_payment_details', $data, true);
        $this->load->view('admin/admin_master', $data);
    }

    /*
     * START ADD USER Manager 
     */


    /*
     * 
     * 
     * 
     * 
     * @@Start
     * By : Jaherul Islam
     * Description : Add Menu (ADMIN Part) - 03-12-2016
     * ---------------------------------Start--------------------------------------------------------
     */

    /**
     * 
     * 
     * @Description         : Add menu information
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 18-01-2016 12:17 PM       
     * @Update DateTime     : 03-12-2016 12:27 PM       
     * */
    public function add_menu() {
        $data = [];
        $this->form_validation->set_rules('menu_type', 'Menu Type', 'required|trim|max_length[50]');
        $this->form_validation->set_rules('menu_name', 'Menu Name', 'required|callback_menu_name_check');
        $this->form_validation->set_rules('menu_url', 'Menu URL', 'required|trim|callback_menu_url_check');
        $this->form_validation->set_rules('manu_status', 'Menu Status', 'required');
        $this->form_validation->set_rules('menu_section_name', 'Menu Section Name');
        $this->form_validation->set_rules('parent_menu');

        if ($this->input->post('menu_order', TRUE)) {
            $this->form_validation->set_rules('menu_order', 'Menu Order', 'required|trim|max_length[50]|callback_check_number');
        }

        $menu_section_name = $this->input->post('menu_section_name', TRUE);
        if ($menu_section_name == '1') {
            $this->form_validation->set_rules('new_menu_section_name', 'Menu Section Name', 'required|trim|max_length[50]|callback_check_menu_section_name');
        }


        if ($this->form_validation->run() == FALSE) {
            $data['active_menu'] = 'view_menu';
            $data['active_sub_menu'] = 'add_menu';
            $data['all_menu'] = $this->super_admin_model->select_published_menu();
            $data['all_section_menu'] = $this->super_admin_model->select_all_section_menu();
            $data['main_content'] = $this->load->view('admin/menu/add_menu_form', $data, true);
            $this->load->view('admin/admin_master', $data);
        } else {
            $menu_url_id = $this->url_model->save_menu_url();
            $this->super_admin_model->save_menu_information($menu_url_id);
            redirect('super-admin/manage-menu');
        }
    }

    /**
     * 
     * @Description         : Check menu name
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : Unknown      
     * */
    public function menu_name_check($menu_name) {
        $old_menu_name = $this->input->post('old_menu_name');
        if ($old_menu_name == $menu_name) {
            return true;
        } else {
            $result = $this->super_admin_model->check_menu_name($menu_name);
            if ($result) {
                $this->form_validation->set_message('menu_name_check', "Menu Name Already Exist");
                return false;
            } else {
                return true;
            }
        }
    }

    /**
     * 
     * @Description         : Check menu url
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : Unknown      
     * */
    public function menu_url_check($menu_url) {
        $old_url = $this->input->post('old_url');
        if ($old_url == $menu_url) {
            return true;
        } else {
            $result = $this->url_model->check_url_existence($menu_url);
            if ($result == 1) {
                $this->form_validation->set_message('menu_url_check', "URL Already Exist");
                return false;
            } else {
                $sp = '/[!@#$%&*()^,._;:]/';
                if (preg_match($sp, $menu_url)) {
                    $this->form_validation->set_message('menu_url_check', "URL Cann't contain any '/[!@#$%&*()^,._;:]/'  if need use '-' Don't use Space");
                    return FALSE;
                } else if (strstr($menu_url, ' ')) {
                    $this->form_validation->set_message('menu_url_check', " Don't use Space if need use '-', alse URL Cann't contain any special carecter like '/[!@#$%&*()^,._;:-]/'");
                    return FALSE;
                } else {
                    $this->form_validation->set_message('menu_url_check', "OK");
                    return TRUE;
                }
            }
        }
    }

    /**
     * 
     * @Description         : Check menu number
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : Unknown      
     * */
    function check_number() {
        $menu_order = $this->input->post('menu_order', TRUE);
        if (!preg_match('/^[0-9]+$/', $menu_order)) {
            $this->form_validation->set_message('check_number', "Only used Positive Integer");
            return false;
        } else {
            return TRUE;
        }
    }

    /**
     * 
     * @Description         : Check menu section name
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : Unknown      
     * */
    function check_menu_section_name() {
        $menu_section_name = $this->input->post('menu_section_name', TRUE);
        if (!preg_match("/^[0-9a-zA-Z\. \ ' \-']+$/", $menu_section_name)) {
            $this->form_validation->set_message('check_menu_section_name', "Only used Capital or small letter");
            return false;
        } else {
            return TRUE;
        }
    }

    /**
     * @Function            : manu_name_existance 
     * @Used IN             : @function-'self'  this[@controller],
     * @Description         : check menu if name is exists 
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : Unknown
     * @Updated Date Time   : 09-02-2016 05:50 PM
     * @Updated By          : Ripon Jaherul      
     * @Status              : available      
     * */
    function manu_name_existance() {
        $manu_name = $this->input->post('manu_name', TRUE);
        $result = $this->super_admin_model->check_menu_name($manu_name);
        if ($result) {
            echo 1;
        } else {
            echo 0;
        }
    }

    /*
     * 
     * 
     * ----------------------------End---------------------------------
     * 
     * @@End
     * By : Jaherul Islam
     * Description : Add Menu (ADMIN Part) - 03-12-2016
     */

    /*
     * 
     * 
     * 
     * 
     * @@Start
     * By : Jaherul Islam
     * Description : Edit Menu (ADMIN Part) - 03-12-2016
     * ---------------------------------Start--------------------------------------------------------
     */

    /**
     * @Function            : edit_menu 
     * @Used IN             : @function-'Seld'  super_admin[@controller],
     * @Description         : Edit menu Using ID  
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 18-01-2016 01:38 PM
     * @Updated Date Time   : 10-02-2016 12:12 PM
     * @Updated By          : Ripon Jaherul      
     * @Status              : available      
     * */
    public function edit_menu($menu_url) {
        $menu_id = $this->super_admin_model->get_menu_id_by_menu_url($menu_url);
        $this->form_validation->set_rules('menu_type', 'Menu Type', 'required|trim|max_length[50]');

        if ($this->input->post('menu_name', TRUE) == $this->input->post('old_menu_name', TRUE)) {
            $this->form_validation->set_rules('menu_name', 'Menu Name', 'required');
        } else {
            $this->form_validation->set_rules('menu_name', 'Menu Name', 'required|callback_menu_name_check');
        }

        if ($this->input->post('menu_url', TRUE) != $this->input->post('old_menu_url', TRUE)) {
            $this->form_validation->set_rules('menu_url', 'Menu URL', 'required|trim|max_length[50]|callback_menu_url_check');
        }

        $this->form_validation->set_rules('manu_status', 'Menu Status', 'required');
        $this->form_validation->set_rules('menu_section_name', 'Menu Section Name');
        $this->form_validation->set_rules('parent_menu');


        if ($this->input->post('menu_order', TRUE)) {
            $this->form_validation->set_rules('menu_order', 'Menu Order', 'required|trim|max_length[50]|callback_check_number');
        }

        $menu_section_name = $this->input->post('menu_section_name', TRUE);
        if ($menu_section_name == '1') {
            $this->form_validation->set_rules('new_menu_section_name', 'Menu Section Name', 'required|trim|max_length[50]|callback_check_menu_section_name');
        }

        if ($this->form_validation->run() == FALSE) {
            $data['active_menu'] = 'view_menu';
            $data['active_sub_menu'] = 'manage_menu';
            $data['all_menu'] = $this->super_admin_model->select_published_menu($menu_id);
            $data['all_section_menu'] = $this->super_admin_model->select_all_section_menu();
            $data['single_menu_details'] = $this->super_admin_model->select_single_menu_value($menu_id);
            $data['main_content'] = $this->load->view('admin/menu/edit_menu_form', $data, true);
            $this->load->view('admin/admin_master', $data);
        } else {
            $this->url_model->update_menu_url();
            $this->super_admin_model->update_menu_information($menu_id);
            redirect('super-admin/manage-menu');
        }
    }

    /*
     * 
     * --------------------------------End---------------------------------------------------------
     * 
     * 
     * @@Start
     * By : Jaherul Islam
     * Description : Edit Menu (ADMIN Part) - 03-12-2016
     */

    /*
     * 
     * 
     * 
     * 
     * @@Start
     * By : Jaherul Islam
     * Description : Manage Menu (ADMIN Part) - 03-12-2016
     * ---------------------------------Start--------------------------------------------------------
     */

    /**
     * 
     * 
     * @Description         : manage menu
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : Unknown      
     * */
    public function manage_menu($number = NULL) {
        $this->session->unset_userdata('active_menu');
        $data = array();
        $data['active_menu'] = 'view_menu';
        $data['active_sub_menu'] = 'manage_menu';

        $data['page'] = $number;
        if ($number != NULL) {
            $value = $number * 10 - 10;
        } else {
            $value = 0;
        }

        $data['all_menu'] = $this->super_admin_model->select_all_menu_details($value);
        $data['total_menu'] = $this->super_admin_model->get_total_menu();
        $data['header_type1'] = $this->super_admin_model->get_header_menu_value_for_type(1, 1);

        foreach ($data['all_menu'] as $type2_value) {
            $data['type2_menu_id'][$type2_value->parent_menu_id] = $this->super_admin_model->select_menu_for_type2($type2_value->parent_menu_id);
        }

        $data['header_menu_section'] = $this->super_admin_model->get_all_header_section();
        foreach ($data['header_menu_section'] as $section_value) {
            $data['type3_menu_id'][$section_value->parent_menu_id][$section_value->menu_section] = $this->super_admin_model->select_header_menu_value_for_type3($section_value->parent_menu_id, $section_value->menu_section);
        }

        $data['footer_type1'] = $this->super_admin_model->get_header_menu_value_for_type(2, 1);
        $data['footer_type2'] = $this->super_admin_model->get_header_menu_value_for_type(2, 2);
        $data['footer_section_without_parent'] = $this->super_admin_model->get_footer_section(2);
        foreach ($data['footer_section_without_parent'] as $section_value) {
            $data['footer_section_type'][$section_value->menu_section] = $this->super_admin_model->get_header_all_section_value(2, $section_value->menu_section);
        }

        foreach ($data['all_menu'] as $single_menu_value) {
            $data['manu_parent_name'][$single_menu_value->menu_id] = $this->super_admin_model->select_single_menu_value($single_menu_value->parent_menu_id);
        }
        $data['main_content'] = $this->load->view('admin/menu/manage_menu', $data, true);
        $this->load->view('admin/admin_master', $data);
    }

    /**
     * @Function            : get_course_by_category_id 
     * @Used IN             : @function-'self'           super_admin[@controller],
     * @Description         : get all menu array Using 'menu_type', 'parent_menu' and 'section_name'  
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : Unknown
     * @Updated Date Time   : 02-02-2016 01:38 PM
     * @Updated By          : Ripon Jaherul      
     * @Status              : available      
     * */
    function get_menu_order($menu_type, $parent_menu_id, $section_name) {
        $result = $this->super_admin_model->get_menu_order($menu_type, $parent_menu_id, $section_name);
        $menu_order_array = array();
        foreach ($result as $result_value) {
            $menu_order_array[] = $result_value->menu_order;
        }
        echo implode(",", $menu_order_array);
    }

    /**
     * 
     * 
     * @Description         : get parent menu
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : Unknown      
     * */
    function get_parent_menu($menu_type) {
        $data['type'] = 'parent';
        $data['parent_menu'] = $this->super_admin_model->get_header_menu($menu_type);
        echo $this->load->view('admin/menu/menu_ajax/select_menu_view', $data, TRUE);
    }

    /**
     * 
     * 
     * @Description         : get section menu
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : Unknown      
     * */
    function get_section_menu($menu_type, $parent_menu) {
        $data['type'] = 'section';
        $data['section_menu'] = $this->super_admin_model->get_section_menu($menu_type, $parent_menu);
        echo $this->load->view('admin/menu/menu_ajax/select_menu_view', $data, TRUE);
    }

    /**
     * 
     * 
     * @Description         : change menu order
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : Unknown      
     * */
    public function change_menu_order($menu_id, $status) {
        echo $this->super_admin_model->change_menu_order($menu_id, $status);
    }

    /**
     * 
     * 
     * @Description         : change menu status
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : Unknown      
     * */
    public function change_menu_status($id, $type) {
        $this->super_admin_model->change_menu_status($id, $type);
        $data['menu_value'] = $this->super_admin_model->select_single_menu_value($id);
        echo $this->load->view('admin/menu/menu_ajax/menu_action.php', $data, TRUE);
    }

    /**
     * 
     * 
     * @Description         : check child ID
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : Unknown      
     * */
    public function check_child_id($menu_id) {
        $result = $this->super_admin_model->check_child_id($menu_id);
        if ($result) {
            echo '1';
        } else {
            echo '2';
        }
    }

    /*
     * 
     * --------------------------------End---------------------------------------------------------
     * 
     * 
     * @@End
     * By : Jaherul Islam
     * Description : Manage Menu (ADMIN Part) - 03-12-2016
     */



    /*
      -----------@@@RIPON@ Start Coupon Part----------------------------------
     */

    /**
     * @Function            : add_coupon 
     * @Used IN             : @function-'Self'  this[@controller]
     * @Description         : add coupon  
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 29-02-2016 11:17 AM      
     * @Status              : available      
     * */
    public function add_coupon() {
        $this->form_validation->set_rules('coupon_name', 'Coupon Name', 'required|trim|max_length[256]|callback_check_coupon_name');
        $this->form_validation->set_rules('coupon_code', 'Coupon Code', 'required|trim|max_length[50]|callback_check_coupon_code');

        $this->form_validation->set_rules('coupon_expire_type', 'Coupon Expire Type', 'required');
        if ($this->input->post('coupon_expire_type', TRUE) == '1') {
            $this->form_validation->set_rules('coupon_can_use_number', 'Coupon Use Number', 'required|trim|max_length[11]|integer|is_natural_no_zero|greater_than[0]');
        } else if ($this->input->post('coupon_expire_type', TRUE) == '2') {
            $this->form_validation->set_rules('coupon_start_date', 'Coupon Start Date', 'required|trim|max_length[256]|callback_check_date_status');
            $this->form_validation->set_rules('coupon_finish_date', 'Coupon End Date', 'required|trim|max_length[256]|callback_check_date_status|callback_compare_with_start_date');
        }

        $this->form_validation->set_rules('coupon_price_type', 'Coupon Price Type', 'required');
        if ($this->input->post('coupon_price_type', TRUE) == '2') {
            $this->form_validation->set_rules('coupon_discount_amount2', 'Coupon Amount', 'required|trim|max_length[13]|numeric|greater_than[0]');
        } else if ($this->input->post('coupon_price_type', TRUE) == '1') {
            $this->form_validation->set_rules('coupon_discount_amount1', 'Coupon Discount Amount', 'required|trim|max_length[13]|numeric|greater_than[0]');
        }

        $this->form_validation->set_rules('coupon_type', 'Coupon Type', 'required');
        $this->form_validation->set_rules('coupon_status', 'Coupon Status', 'required');

        if ($this->form_validation->run() == FALSE) {
            $data['active_menu'] = 'coupon';
            $data['active_sub_menu'] = 'add_coupon';
            $data['main_content'] = $this->load->view('admin/coupon/add_coupon_form', $data, true);
            $this->load->view('admin/admin_master', $data);
        } else {
            if ($_POST) {
                $this->super_admin_model->save_coupon_information();
                redirect('manage-coupon');
            }
        }
    }

    /**
     * @Function            : edit_coupon 
     * @Used IN             : @function-'Self'  this[@controller]
     * @Description         : Edit Coupon
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 29-02-2016 06:26 PM      
     * @Status              : available      
     * */
    public function edit_coupon($coupon_code) {
        $data['coupon_value'] = $this->super_admin_model->get_single_coupon_value_by_coupon_code($coupon_code);

        if (preg_replace('/\s+/', ' ', trim($this->input->post('coupon_name', TRUE))) != $data['coupon_value']->coupon_name) {
            $this->form_validation->set_rules('coupon_name', 'Coupon Name', 'required|trim|max_length[256]|callback_check_coupon_name');
        } else {
            $this->form_validation->set_rules('coupon_name', 'Coupon Name', 'required|trim|max_length[256]');
        }

        if ($this->input->post('coupon_code', TRUE) != $data['coupon_value']->coupon_code) {
            $this->form_validation->set_rules('coupon_code', 'Coupon Code', 'required|trim|max_length[50]|callback_check_coupon_code');
        } else {
            $this->form_validation->set_rules('coupon_code', 'Coupon Code', 'required|trim|max_length[50]');
        }


        $this->form_validation->set_rules('coupon_expire_type', 'Coupon Expire Type', 'required');
        if ($this->input->post('coupon_expire_type', TRUE) == '1') {
            $this->form_validation->set_rules('coupon_can_use_number', 'Coupon Use Number', 'required|trim|max_length[11]|integer|is_natural_no_zero|greater_than[0]');
        } else if ($this->input->post('coupon_expire_type', TRUE) == '2') {
            $this->form_validation->set_rules('coupon_start_date', 'Coupon Start Date', 'required|trim|max_length[256]|callback_check_date_status');
            $this->form_validation->set_rules('coupon_finish_date', 'Coupon End Date', 'required|trim|max_length[256]|callback_check_date_status|callback_compare_with_start_date');
        }

        $this->form_validation->set_rules('coupon_price_type', 'Coupon Price Type', 'required');
        if ($this->input->post('coupon_price_type', TRUE) == '2') {
            $this->form_validation->set_rules('coupon_discount_amount2', 'Coupon Amount', 'required|trim|max_length[13]|numeric|greater_than[0]');
        } else if ($this->input->post('coupon_price_type', TRUE) == '1') {
            $this->form_validation->set_rules('coupon_discount_amount1', 'Coupon Discount Amount', 'required|trim|max_length[13]|numeric|greater_than[0]');
        }

        $this->form_validation->set_rules('coupon_type', 'Coupon Type', 'required');
        $this->form_validation->set_rules('coupon_status', 'Coupon Status', 'required');

        if ($this->form_validation->run() == FALSE) {
            $data['active_menu'] = 'coupon';
            $data['active_sub_menu'] = 'manage_coupon';
            $data['main_content'] = $this->load->view('admin/coupon/edit_coupon_form', $data, true);
            $this->load->view('admin/admin_master', $data);
        } else {
            if ($_POST) {
                $this->super_admin_model->update_coupon_information($data['coupon_value']);
                redirect('manage-coupon');
            }
        }
    }

    /**
     * @Function            : manage_coupon 
     * @Used IN             : @function-'Self'  this[@controller]
     * @Description         : get all coupon for manage  
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 29-02-2016 01:26 PM      
     * @Status              : available      
     * */
    public function manage_coupon($arg = NULL) {
        $data = array();
        $data['active_menu'] = 'coupon';
        $data['active_sub_menu'] = 'manage_coupon';
        if ($arg == NULL) {
            $data['page'] = $number = 0;
            $data['serial'] = 0;
        } else {
            $data['page'] = $arg;
            $number = $arg * 10 - 10;
            $data['serial'] = $number;
        }

        $data['all_coupon'] = $this->super_admin_model->select_all_coupon('', $number);
        $data['total_coupon'] = $this->super_admin_model->select_total_coupon();
        $data['main_content'] = $this->load->view('admin/coupon/manage_coupon', $data, true);
        $this->load->view('admin/admin_master', $data);
    }

    /**
     * @Function            : search_coupon 
     * @Used IN             : @function-'Self'  this[@controller]
     * @Description         : search coupon using coupon name and coupon_code
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 29-02-2016 04:51 PM      
     * @Status              : available      
     * */
    public function search_coupon() {
        $search_value1 = $this->input->post('search_value', TRUE);
        if ($search_value1 != '') {
            $search_value = $search_value1;
        } else {
            $search_value = '';
        }
        $number = 0;
        $data['serial'] = 0;
        $data['all_coupon'] = $this->super_admin_model->select_all_coupon($search_value, $number);
        echo $this->load->view('admin/coupon/ajax_page/manage_coupon_view', $data, true);
    }

    /**
     * @Function            : check_coupon_status_by_coupon_id 
     * @Used IN             : @function-'Self'  this[@controller]
     * @Description         : change coupon status and delete
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 29-02-2016 01:57 PM      
     * @Status              : available      
     * */
    public function check_coupon_status_by_coupon_id() {
        $coupon_id = $this->input->post('coupon_id', TRUE);
        $coupon_status = $this->input->post('coupon_status', TRUE);
        if ($coupon_status == 'Delete') {
            $this->super_admin_model->delete_information_in_database('tbl_coupon', 'coupon_id', $coupon_id);
            echo $coupon_status;
        } else {
            if ($coupon_status == 'Active') {
                $data['coupon_status'] = 1;
            } else if ($coupon_status == 'Inactive') {
                $data['coupon_status'] = 2;
            }
            $this->super_admin_model->update_information_in_database('tbl_coupon', 'coupon_id', $coupon_id, $data);
            $data['coupon_value'] = $this->super_admin_model->get_single_coupon_value_by_coupon_id($coupon_id);
            echo $this->load->view('admin/coupon/ajax_page/coupon_status_view', $data, TRUE);
        }
    }

    /**
     * @Function            : check_coupon_name 
     * @Used IN             : @function-'Self'  this[@controller]
     * @Description         : get coupon Name and check existence 
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 29-02-2016 05:54 AM      
     * @Status              : available      
     * */
    public function check_coupon_name($coupon_name1) {
        $coupon_name = preg_replace('/\s+/', ' ', trim($coupon_name1));
        $result = $this->super_admin_model->check_coupon_name_existence($coupon_name);
        if ($result) {
            $this->form_validation->set_message('check_coupon_name', "Coupon Name Already Exists");
            return FALSE;
        } else {
            return TRUE;
        }
    }

    /**
     * @Function            : check_coupon_code 
     * @Used IN             : @function-'Self'  this[@controller]
     * @Description         : get coupon Name and check existence 
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 29-02-2016 05:54 PM      
     * @Status              : available      
     * */
    public function check_coupon_code($couon_code1) {
        $rp = '/[!@#$%&*()^,._;:]/';
        $coupon_code = preg_replace('/\s+/', ' ', trim($couon_code1));
        $result = $this->super_admin_model->check_coupon_code_existence($coupon_code);
        if ($result) {
            $this->form_validation->set_message('check_coupon_code', "Coupon Code Already Exists");
            return FALSE;
        } else if (preg_match($rp, $coupon_code)) {
            $this->form_validation->set_message('check_coupon_code', "Coupon Code Cann't contain any '/[!@#$%&*()^,._;:]/'  if need use '-' Don't use Space");
            return FALSE;
        } else if (strstr($coupon_code, ' ')) {
            $this->form_validation->set_message('check_coupon_code', " Don't use Space if need use '-'");
            return FALSE;
        } else {
            return TRUE;
        }
    }

    /**
     * @Function            : check_coupon_name_existence 
     * @Used IN             : @function-'Self'  this[@controller]
     * @Description         : get coupon Name and check existence 
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 29-02-2016 11:20 AM      
     * @Status              : available      
     * */
    public function check_coupon_name_existence() {
        $coupon_name = trim($this->input->post('coupon_name', TRUE));
        $result = $this->super_admin_model->check_coupon_name_existence($coupon_name);
        if ($result) {
            echo 1;
        } else {
            echo 2;
        }
    }

    /**
     * @Function            : check_coupon_code_existence 
     * @Used IN             : @function-'Self'  this[@controller]
     * @Description         : get coupon code and check existence
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 29-02-2016 11:22 AM      
     * @Status              : available      
     * */
    public function check_coupon_code_existence() {
        $coupon_code = $this->input->post('coupon_code', TRUE);
        $result = $this->super_admin_model->check_coupon_code_existence($coupon_code);
        if ($result) {
            echo 1;
        } else {
            echo 2;
        }
    }

    /**
     * @Function            : check_date_status 
     * @Used IN             : @function-'add_coupon'     this[@controller]- 2 times
     * @Description         : check date status if date insert before today  
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 29-02-2016 12:15 PM
     * @Status              : available      
     * */
    public function check_date_status($date) {
        if ($date != '') {
            $today = date('Y-m-d', strtotime(gmdate('Y-m-d')) - $this->session->userdata('time_offset'));
            if ($date >= $today) {
                return TRUE;
            } else {
                $this->form_validation->set_message('check_date_status', "Course start date can not be before today");
                return FALSE;
            }
        }
    }

    /**
     * @Function            : compare_with_start_date 
     * @Used IN             : @function-'add_coupon'     this[@controller]
     * @Description         : check date if date 
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 29-02-2016 12:22 PM
     * @Status              : available      
     * */
    public function compare_with_start_date($end_date) {
        $start_date = $this->input->post('coupon_start_date', TRUE);
        if ($end_date) {
            if ($end_date >= $start_date) {
                return TRUE;
            } else {
                $this->form_validation->set_message('compare_with_start_date', "Coupon Finished Date must bigger than Coupon Start Date");
                return FALSE;
            }
        }
    }

    /*
      -----------@@@RIPON@ Start Coupon Part----------------------------------
     */

    public function manage_course_wish_list() {
        $data = array();
        $data['active_menu'] = 'wish_list';
        $data['active_sub_menu'] = 'course_wish_list';
        $data['all_wishlist'] = $this->super_admin_model->select_all_wishlist();
        foreach ($data['all_wishlist'] as $val) {
            $data['person_info'][$val->wish_list_management_id] = $this->super_admin_model->select_person_info($val->person_id);
            $data['course_info'][$val->wish_list_management_id] = $this->super_admin_model->select_course_info($val->course_id);
            if ($data['course_info'][$val->wish_list_management_id]) {
                $data['course_created_person_info'][$val->wish_list_management_id] = $this->super_admin_model->select_course_status_info($data['course_info'][$val->wish_list_management_id]->person_id);
                if ($data['course_created_person_info'][$val->wish_list_management_id]->person_role == 3) {
                    $data['resource_person_role'][$val->wish_list_management_id] = $this->super_admin_model->check_resource_person_role($data['course_created_person_info'][$val->wish_list_management_id]->person_id);
                }
            }
        }

        $data['main_content'] = $this->load->view('admin/wish_list/manage_course_wish_list', $data, true);
        $this->load->view('admin/admin_master', $data);
    }

    public function delete_wishlist() {
        $wishList_id = $this->input->post("wish_list_management_id", TRUE);
        $this->super_admin_model->deleted_wishlistist($wishList_id);
    }

    public function manage_video_wish_list() {
        $data = array();
        $data['active_menu'] = 'wish_list';
        $data['active_sub_menu'] = 'video_wish_list';
        $data['main_content'] = $this->load->view('admin/wish_list/manage_video_wish_list', $data, true);
        $this->load->view('admin/admin_master', $data);
    }

    public function user_video_wish_list_details() {
        $data = array();
        $data['active_menu'] = 'wish_list';
        $data['active_sub_menu'] = 'video_wish_list';
        $data['main_content'] = $this->load->view('admin/wish_list/student_view_details', $data, true);
        $this->load->view('admin/admin_master', $data);
    }

    public function user_course_wish_list_details() {
        $data = array();
        $data['active_menu'] = 'wish_list';
        $data['active_sub_menu'] = 'course_wish_list';
        $data['main_content'] = $this->load->view('admin/wish_list/student_view_details', $data, true);
        $this->load->view('admin/admin_master', $data);
    }

    public function waiver_list() {
        $data = array();
        $data['active'] = 'manage_scholarship';
        $data['main_content'] = $this->load->view('admin/scholarship/waiver_list', $data, true);
        $this->load->view('admin/admin_master', $data);
    }

    public function logout() {
        $data = Array();
        $person_pc_info_id = $this->session->userdata('person_pc_info_id');
        $timeZone_differrent = $this->session->userdata('time_offset');
        $data['person_site_visit_end_time'] = date('Y-m-d h:i A', (time() - ($timeZone_differrent)));
        $data['person_login_status'] = 2;
        $this->utility_model->update_information_in_database('tbl_person_pc_info', 'person_pc_info_id', $person_pc_info_id, $data);
        $this->session->sess_destroy();
        redirect('babbamamma', 'refresh');
    }

}
