<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Sign_Up extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('sign_up_model');
    }

    /**
     * @Function            : index 
     * @Used IN             : @function-'self'  
     * @Description         : Sign up new user 
     * @                    : @Update1 - remove all free feature issue in sign in 
     * @Developed By        : Mahabub-A-Mawla
     * @Start DateTime      : Unknown
     * @Updated Date Time   : 01-03-2016 01:54 PM
     * @Updated By          : Ripon Jaherul 
     * @Updated By          : Tania Akter
     * @Update Date         : 25-05-2016     
     * @Status              : available      
     * */
    function index() {
        $data = $this->welcome_model->generate_menu(); //used for mega menu
        $person_id = $this->session->userdata('user_id');
        if ($person_id) {
            redirect();
        } else {
            $this->sign_up_form_validation();
            if ($this->form_validation->run() == FALSE) {
                //$data['captcha'] = $this->sign_up_model->generate_captcha();
                $data['main_content'] = $this->load->view('front_end/sign_up', $data, TRUE);
                $this->load->view('front_end/master', $data);
            } else {
                $person_url_id = $this->url_model->save_person_url();
                $person_id = $this->sign_up_model->save_person_information($person_url_id);
                $data['person_info'] = $this->person_model->get_single_person_information_by_person_id($person_id);
                $this->save_information_by_person_role($data);
                $profile_url = $data['person_info']->url;
                $this->cf->create_folder($profile_url);
                $this->send_email_to_user_for_account_activation($data);
                $sdata['message'] = 'Please check your email and active your account.';
                $this->session->set_userdata($sdata);
                redirect('sign-in', 'refresh');
            }
        }
    }

    /**
     * @Function              : sign_up_form_validation
     * @Description           : used to sign up form validation
     * @Used IN               : function[index]  controller[sign_up]
     * @Developed By          : Tania Akter [This function code was part of (function['index'] controller['sign_up']). In here i have divided (function['index'] controller['sign_up']) only]
     * @Developed Date Time   : 17-08-2016  
     * @Status                : available      
     * */
    function sign_up_form_validation() {
        $this->form_validation->set_rules('person_email', 'email', 'required|trim|valid_email|max_length[256]|callback_email_check');
        $this->form_validation->set_rules('person_first_name', 'first Name', 'required|trim|max_length[100]|callback_check_name');
        $this->form_validation->set_rules('person_last_name', 'last Name', 'required|trim|max_length[100]|callback_check_name');
        $this->form_validation->set_rules('person_password', 'password', 'required|min_length[6]|callback_password_check');
        $this->form_validation->set_rules('confirm_password', 'confirm password', 'required|min_length[6]|callback_password_check');
        $this->form_validation->set_rules('country_code', 'country code', 'trim');
        $this->form_validation->set_rules('hidden_country_code', 'country code', 'required|trim');
        $this->form_validation->set_rules('person_contact_number', 'contact Number', 'required|numeric|max_length[16]|trim');
        $this->form_validation->set_rules('person_country', 'country', 'required');
        $this->form_validation->set_rules('person_role', 'person role', 'required');
        $this->form_validation->set_rules('google_captcha', 'google_captcha', 'required');
        //$this->form_validation->set_rules('captcha', 'captcha', 'trim|strip_tags|callback_captcha_check');
    }

    /**
     * @Function              : save_information_by_person_role
     * @Description           : save person information according to person role
     * @Used IN               : @function-'index' controller-- 'sign_up' 
     * @Developed By          : Tania Akter [This function code was part of (function['index'] controller['sign_up']). In here i have divided (function['index'] controller['sign_up']) only]
     * @Developed Date Time   : 25-05-2016 01:54 PM   
     * @Status                : available      
     * */
    function save_information_by_person_role($data) {
        if ($data['person_info']->person_role == 4) {
            //save organization information
            $data['organization_id'] = $organization_id = $this->sign_up_model->save_organization_information($data);
            //save resource person information
            $this->sign_up_model->save_resource_person_information($data);
        } else if ($data['person_info']->person_role == 3) {
            //save resource person information
            $this->sign_up_model->save_resource_person_information($data);
        }
    }

    /**
     * @Function              : send_email_to_user_for_account_activation
     * @Used IN               : @function['index'] controller['sign_up']
     * @Description           : send email to user for account activation
     * @Start Date Time       : 25-05-2016 01:54 PM
     * @Developeded By        : Tania Akter [This function code was part of (function['index'] controller['sign_up']). In here i have divided (function['index'] controller['sign_up']) only]     
     * @Status                : available      
     * */
    function send_email_to_user_for_account_activation($data) {
        $mdata = array();
        $mdata['person_id'] = $data['person_info']->person_id;
        $mdata['person_name'] = $data['person_info']->person_first_name . ' ' . $data['person_info']->person_last_name;
        $mdata['from_address'] = 'no-replay@talhatraining.com';
        $mdata['company_name'] = 'Talha Training';
        $mdata['admin_name'] = 'Talha Training Administrator';
        $mdata['to_address'] = $data['person_info']->person_email;
        $mdata['subject'] = 'Account Activation Email ';
        $id = $this->encryption->encrypt($data['person_info']->person_id);
        $p_id = str_replace("/", "%F2", $id);
        $mdata['site_link'] = base_url() . 'active-account/' . $p_id;
        $this->mailer_model->send_email($mdata, 'email_to_user_active_account');
    }

    /*
     * @Function            : check_person_role 
     * @Used IN             : function['index'] controller[sign_up]
     * @Description         : used to check person role
     * @parameter           : $person_role(admin_user=1;account_officer=2;account_officer=2;teacher=3;organization=4;student=5;super_admin=6)
     * @Developed By        : Unknown
     * @Start DateTime      : Unknown
     * @Updated By          : Tania Akter
     * @Updated Date        : 25-05-2016
     * @Status              : available      
     */

    function check_person_role($person_role) {
        if ($person_role == 3 || $person_role == 4 || $person_role == 5) {
            return true;  //here true means condition (person role 3 or 4 or 5)is fullfilled. no need to show error(validation) message.
        } else {
            $this->form_validation->set_message('check_person_role', get_message('person_role'));
            return false; //here false means condition (person role 3 or 4 or 5) not fullfilled. need to show error(validation) message.
        }
    }

    /*
     * @Function            : email_check 
     * @Used IN             : function[index] controller[sign_up]
     * @Description         : check email address to validate
     * @parameter           : none
     * @Developed By        : Unknown
     * @Start DateTime      : Unknown
     * @Status              : available      
     */

    function email_check() {
        $person_email = $this->input->post('person_email', TRUE);
        $sp = '/^(([^<>()[\]\\.,;:\s@\"]+(\.[^<>()[\]\\.,;:\s@\"]+)*)|(\".+\"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/';
        if (preg_match($sp, $person_email)) {
            $email_result = $this->sign_up_model->check_user_email_info($person_email);
            if ($email_result) {
                $this->form_validation->set_message('email_check', get_message('email_exist'));
                return FALSE; //if email already exist in db... it show validation message
            } else {
                return TRUE;    //if email not exist in db
            }
        } else {
            $this->form_validation->set_message('email_check', "Invalid email address");
            return FALSE;       //if email is invalid ---it show message
        }
    }


    /*
     * @Function            : check_user_email_registration 
     * @Used IN             : front_end/sign_up
     * @Description         : used to check user email
     * @parameter           : none
     * @Developed By        : Unknown
     * @Updated By          : Tania Akter
     * @Update DateTime     : 24-05-2016 5:43 AM
     * @Update By           : Tania Akter
     * @Date                : 06-08-2016
     * @Status              : available      
     */
    function check_user_email_registration() {
        $user_email_address = $this->input->post('given_email', TRUE);
        $result = $this->sign_up_model->check_user_email_info($user_email_address);
        $forbidden_email = $this->sign_up_model->check_exist_sign_up_forbidden($user_email_address, 4);
        if ($result) {
            echo '1';       //here 1 means email address exist in db . it is show error( validation message)
        } else if ($forbidden_email) {
            echo '3';   // here 3 means email exist in forbidden table
        } else {
            echo '2';       //here 2 means email address not exist in db . not show error( validation message)
        }
    }

    /* only comment by Tania Akter(25-05-2016)
     * @Function            : check_name 
     * @Used IN             : function[index] controller[sign_up]
     * @Description         : check person name to validate
     * @parameter           : $str (person name)
     * @Developed By        : Unknown
     * @Start DateTime      : Unknown
     * @Update By           : Tania Akter
     * @Update Date         : 25-5-2016
     * @Status              : available      
     */

    function check_name($str) {
        $sp = '/[^A-Za-z0-9 \- \.]/';
        if (!preg_match($sp, $str)) {
            return TRUE;  // person name ok no need to show error( validation message)
        } else {
            $this->form_validation->set_message('check_name', get_message('person_name_character'));
            return FALSE; // it show error( validation message)
        }
    }

    /* only comment by Tania Akter(25-05-2016)
     * @Function            : password_check 
     * @Used IN             : function[index] controller[sign_up]
     * @Description         : used to check person password validate
     * @parameter           : $str(person password)
     * @Developed By        : Unknown
     * @Start DateTime      : Unknown
     * @Status              : available      
     */

    function password_check($str) {
        $person_password = $this->input->post('person_password', TRUE);
        $confirm_password = $this->input->post('confirm_password', TRUE);

        if (strlen($person_password) < 6) {
            $this->form_validation->set_message('password_check', get_message("password_length"));
            return FALSE;   //if password legth is less than 6 . it return false and show validation message
        } else if (preg_match('#[0-9]#', $str) && preg_match('#[a-z]#', $str)) {
            if ($person_password == $confirm_password) {
                return TRUE;        //if password matched with confirm password . it return true and no need to show validation message
            } else {
                $this->form_validation->set_message('password_check', get_message("password_match"));
                return FALSE;       //if password  not matched with confirm password . it return false and  show validation message
            }
        } else {
            $this->form_validation->set_message('password_check', get_message("password_character"));
            return FALSE;       //if password not contain one capital letter or one special charecter . it return false and show validation message
        }
    }
   

    /*
     * @Function            : check_sign_up_forbidden_exist 
     * @Used IN             : front_end/sign_up.php
     * @Description         : used to check person name exist in tbl_forbidden
     * @parameter           : none
     * @Developed By        : Tania Akter
     * @Start DateTime      : 21-05-2016 5:43 AM
     * @Update by           : Tania
     * @Date                : 06-08-2016
     * @Status              : available      
     */

    function check_sign_up_forbidden_exist() {
        $account_type = $this->input->post('account_type', TRUE);
        $first_name = preg_replace('/[^A-Za-z0-9 -]/', '', $this->input->post('first_name', TRUE));
        $last_name = preg_replace('/[^A-Za-z0-9 -]/', '', $this->input->post('last_name', TRUE));
        $create_name = $this->create_sign_up_name($first_name, $last_name);
        $check_name = $this->sign_up_model->check_exist_sign_up_forbidden($create_name, 2);
        $check_last_name = $this->sign_up_model->check_exist_sign_up_forbidden($last_name, 2);
        $check_name_org = $this->sign_up_model->check_exist_sign_up_forbidden($create_name, 3);
        $check_last_name_org = $this->sign_up_model->check_exist_sign_up_forbidden($last_name, 3);
        if ($account_type == 4) {
            if ($check_name_org) {
                echo "1"; // if person name exist in forbidden table
            } else if ($check_last_name_org) {
                echo "1"; // if person name exist in forbidden table  
            } else {
                echo "2"; // if person name not exist in forbidden
            }
        } else {
            if ($check_name) {
                echo "1"; // if person name exist in forbidden table
            } else if ($check_last_name) {
                echo "1"; // if person name exist in forbidden table  
            } else {
                echo "2"; // if person name not exist in forbidden
            }
        }
    }

    /*
     * @Function            : create_sign_up_name 
     * @Used IN             : function[check_sign_up_forbidden_exist] @controller[sign_up]
     * @Description         : used to make name by using person first_name or last_name
     * @parameter           : none
     * @Developed By        : Tania Akter
     * @Start DateTime      : 21-05-2016 5:43 AM
     * @Status              : available      
     */

    function create_sign_up_name($person_first_name, $person_last_name) {
        $first_name = str_replace(' ', '', $person_first_name);
        $create_name = preg_replace('/[^A-Za-z0-9 -]/', '', $person_first_name);
        $last_name = preg_replace('/[^A-Za-z0-9 -]/', '', $person_last_name);
        if ($last_name) {
            $create_name = $first_name . ' ' . $last_name;
        }
        return $create_name;        //person name
    }
    
    /*
     * @Function            : active_account 
     * @Used IN             : function [send_email_to_user_for_account_activation] controller[sign_up]
     * @Description         : used to active user account
     * @parameter           : $p_id (person_id)
     * @Developed By        : Unknown
     * @Start DateTime      : Unknown
     * @Redirect            : sign-in
     * @Status              : available      
     */

    function active_account($p_id) {
        $data = $this->welcome_model->generate_menu();
        $pe_id = str_replace("%F2", "/", $p_id);
        $person_id = $this->encryption->decrypt($pe_id);
        $data['person_id'] = $person_id;

        $person_info = $this->sign_up_model->select_user_by_person_id($person_id);
        if ($person_info) {
            if ($person_info->person_status == 1) {     //1 means person_status active
                $sdata['message'] = '<span style=color:red>You are already an active user please sign in</span>';
                $this->session->set_userdata($sdata);
                redirect('sign-in');
            } else if ($person_info->person_status == 0) {      //0 means person_status inactive
                $this->sign_up_model->active_user_account($person_id);
                $sdata['message'] = '<span style=color:green>Your account activate successfully</span>';
                $this->session->set_userdata($sdata);
            }
        } else {
            $sdata['message'] = '<span style=color:red> </span>';
            $this->session->set_userdata($sdata);
        }
        redirect('sign-in');
    }

//06-08-2016 
    /*
     * @Function            : check_org_forbidden 
     * @Used IN             : front_end/sign_up.php
     * @Description         : used to check organization name exist in forbidden table
     * @parameter           : none
     * @Developed By        : Tania Akter
     * @Start DateTime      : 06-08-2016
     * @Status              : available      
     */
    function check_org_forbidden() {
        $account_type = $this->input->post('account_type', TRUE);
        $first_name = preg_replace('/[^A-Za-z0-9 -]/', '', $this->input->post('first_name', TRUE));
        $last_name = preg_replace('/[^A-Za-z0-9 -]/', '', $this->input->post('last_name', TRUE));
        $create_name = $this->create_sign_up_name($first_name, $last_name);
        $check_name = $this->sign_up_model->check_exist_sign_up_forbidden($create_name, 3);
        $check_last_name = $this->sign_up_model->check_exist_sign_up_forbidden($last_name, 3);
        if ($account_type == 4) {
            if ($check_name) {
                echo "1"; // if person name exist in forbidden table
            } else if ($check_last_name) {
                echo "1"; // if person name exist in forbidden table  
            } else {
                echo "2"; // if person name not exist in forbidden
            }
        } else {
            echo "2"; // if person name not exist in forbidden
        }
    }
}
