<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Profile extends TT_user_login {

    public function __construct() {
        parent::__construct();
        $this->load->model('map_model');
    }

    /**
     * @Function            : change_quiz_result_status 
     * @Description         : Change the status of quiz result
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 18-01-17
     * @Parameter           : Null
     * @Return              : NULL    
     * @Status              : Available       
     * */
    public function change_quiz_result_status() {
        $data['quiz_result_id'] = $this->input->post('quiz_result_id');
        $data['status'] = $this->input->post('status');
        echo $this->quiz_model->change_quiz_result_status_model($data);
        echo json_encode('ok');
    }

    /**
     * @Function            : select_institute 
     * @Used IN             : route[select-institute]
     * @Description         : selects education institutes for displaying dropdown list
     * @Developed By        : MD Md Mashqur Ul Alam
     * @Start DateTime      : 26-12-16 03.30PM     
     * @Parameter           : NULL
     * @View                : None
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available       
     * */
    public function select_institute() {
        if ($this->input->is_ajax_request()) {
            $array_key = array('eduInsType', 'eduInsCountry', 'eduInsCity');
            $data = $this->input->post($array_key, TRUE);
            $eduinsStatus = ['1', '3'];

            if ($data['eduInsType'] != NULL) {
                $condition['education_institute_type'] = $data['eduInsType'];
            }
            if ($data['eduInsCountry'] != NULL) {
                $condition['education_institute_country'] = $data['eduInsCountry'];
            }
            if ($data['eduInsCity'] != NULL) {
                $condition['education_institute_city'] = $data['eduInsCity'];
            }

            $output = $this->super_admin_profile_model->select_institute_dropdown($condition, $eduinsStatus);
            echo json_encode($output);
        } else {
            redirect('/');
        }
    }

    /**
     * @Function            : delete_education 
     * @Used IN             : route[delete-education]
     * @Description         : Delete education detail from user profile
     * @Developed By        : MD Mashqur Ul Alam
     * @Start DateTime      : 28-12-16 12.30AM     
     * @Parameter           : NULL
     * @View                : None
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available       
     * */
    public function delete_education() {
        if ($this->input->is_ajax_request()) {
            $this->form_validation->set_rules('eduDetail', 'Education Institute Details', 'required|trim|integer');
            if ($this->form_validation->run() == TRUE) {
                $data['person_id'] = $this->session->person_id;
                $data['person_education_details_id'] = $this->input->post('eduDetail', TRUE);
                $this->super_admin_profile_model->delete_education_detail_information($data);
            }
        } else {
            redirect('/');
        }
    }

    /**
     * @Function            : edit_profile 
     * @Used IN             : @function-'user/profile_view/edit_profile.php'
     * @Description         : edit prifile view
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : Unknown
     * @Updated Date Time   : 09-06-2016 12:57 PM
     * @Updated By          : MD Jaherul Islam
     * @Parameter           : $person_url[STRING]
     * @View                : None
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available       
     * */
    public function edit_profile($person_url) {
        $data['active_menu'] = '';
        $data['active_sub_menu'] = '';
        $data['right_content_variation'] = 3; //right content for profile

        $person_id = $this->session->userdata('person_id');
        $data['profile_person_id'] = $person_id;
        $data['person_info'] = $this->person_model->get_single_person_information_by_person_url($person_url);
        if ($data['person_info']) {
            if ($data['person_info']->person_id != $person_id) {
                redirect();
            }
        } else {
            redirect();
        }
        $url_changed_data = $this->profile_model->check_profile_url_change_status($data);
        $course_data = $this->profile_model->get_all_course_created_by_person_id($url_changed_data, $person_id);
        $link_data = $this->profile_model->get_total_friends($course_data, $person_id);
        $person_data = $this->profile_model->get_profiled_person_information($link_data, $person_id);
        $person_content_data = $this->profile_model->get_person_all_image_data_by_person_id($person_data);
        $person_content_data['main_content'] = $this->load->view('user/profile_view/edit_profile', $person_content_data, TRUE);
        $this->load->view('user/master', $person_content_data);
    }

    public function edit_self_assesment_form($person_id) {
        $data['person_self_assessmet_skills'] = $this->super_admin_model->select_self_assessment_skills_by_id($person_id);
        $data['person_info'] = $this->profile_model->user_info_by_id($person_id);

        echo $this->load->view('user/profile_view/ajax_view/self_assesment_form_action', $data, TRUE);
    }

    public function update_self_assesment($person_id) {
        $this->profile_model->update_self_assessment_by_id($person_id);
        $data['person_self_assessmet_skills'] = $this->super_admin_model->select_self_assessment_skills_by_id($person_id);
        $data['person_info'] = $this->profile_model->user_info_by_id($person_id);

        echo $this->load->view('user/profile_view/ajax_view/self_assesment_view_action', $data, TRUE);
    }

    public function edit_persson_interest_form($person_id) {
        $data['interest_field_info_all'] = $this->profile_model->select_user_interest_field_all($person_id);
        $data['person_info'] = $this->profile_model->user_info_by_id($person_id);

        echo $this->load->view('user/profile_view/ajax_view/edit_interest_form_action', $data, TRUE);
    }

    public function update_interest_field($person_id) {
        $this->profile_model->update_interest_field_by_id($person_id);
        $data['interest_field_info_all'] = $this->profile_model->select_user_interest_field_all($person_id);
        $data['person_info'] = $this->profile_model->user_info_by_id($person_id);

        echo $this->load->view('user/profile_view/ajax_view/interest_field_view_action', $data, TRUE);
    }

    /*
     * @Function            : cancel_update_interest_field
     * @Description         : Reloads the view when Update Interest in Profile
     *                        cancel button clicked.
     * @Developed By        : Md Mashqur Ul ALam
     * @Start DateTime      : 29-12-16  12:30 AM
     * @Parameter           : Null
     * @Return              : Ajax View [edit_interest_form_action.php]    
     * @Status              : Available       
     */

    public function cancel_update_interest_field() {
        if ($this->input->is_ajax_request()) {
            $person_id = $this->session->person_id;
            $data['interest_field_info_all'] = $this->profile_model->select_user_interest_field_all($person_id);
            $data['person_info'] = $this->profile_model->user_info_by_id($person_id);
            echo $this->load->view('user/profile_view/ajax_view/interest_field_view_action', $data, TRUE);
        } else {
            redirect('/');
        }
    }

    //Add person Language view Action

    public function add_language_form($person_id) {
        $data['person_id'] = $person_id;

        echo $this->load->view('user/profile_view/ajax_view/add_language_form', $data, TRUE);
    }

    public function add_language($person_id) {
        $limit = 0;
        $this->profile_model->save_language($person_id);
        $data['person_info'] = $this->profile_model->user_info_by_id($person_id);
        $data['person_language'] = $this->super_admin_model->select_person_limited_language_by_id($person_id, $limit);

        echo $this->load->view('user/profile_view/ajax_view/view_language_details', $data, TRUE);
    }

    public function edit_langiage_by_id() {
        $person_id = $this->uri->segment(4);
        $person_language_id = $this->uri->segment(3);
        $data['person_language_id'] = $person_language_id;
        $data['selected_person_language'] = $this->profile_model->get_selected_language($person_language_id);
        $data['person_info'] = $this->profile_model->user_info_by_id($person_id);
        $data['person_language'] = $this->profile_model->select_person_language_by_language_id($person_id, $person_language_id);

        echo $this->load->view('user/profile_view/ajax_view/edit_language_form', $data, TRUE);
    }

    /*
     * @Function            : cancel_edit_language
     * @Description         : Reloads the view of language section when cancel 
     *                        Button clicked from language edit
     * @Developed By        : Md Mashqur Ul ALam
     * @Start DateTime      : 15-01-17
     * @Parameter           : Null
     * @Return              : Ajax View [edit_language_action.php]    
     * @Status              : Available       
     */

    public function cancel_edit_language() {
        $person_id = $this->session->person_id;
        $data['person_language'] = $this->super_admin_model->select_person_language_by_id($person_id);
        echo $this->load->view('user/profile_view/ajax_view/view_language_details', $data, TRUE);
    }

    public function update_language() {
        $limit = 0;
        $person_id = $this->uri->segment(4);
        $person_language_id = $this->uri->segment(3);
        $this->profile_model->update_language_by_language_id($person_language_id);
        $data['person_info'] = $this->profile_model->user_info_by_id($person_id);
        $data['person_language'] = $this->super_admin_model->select_person_limited_language_by_id($person_id, $limit);

        echo $this->load->view('user/profile_view/ajax_view/view_language_details', $data, TRUE);
    }

    /*
     * @Function            : delete_language_by_language_id
     * @Used IN             : Language section of Profile
     * @Description         : Deletes the selected language details
     * @Developed By        : Unknown
     * @Updated By          : Md Mashqur Ul Alam [15-01-17]
     * @Parameter           : langDetail
     * @Return              : Null
     * @Status              : Available       
     */

    public function delete_language_by_language_id() {
        $limit = 0;
        $person_id = $this->session->person_id;
        $person_language_id = $this->input->post('person_language_id', TRUE);
        $this->profile_model->delete_language_by_id($person_language_id);
        $data['person_info'] = $this->profile_model->user_info_by_id($person_id);
        $data['person_language'] = $this->super_admin_model->select_person_limited_language_by_id($person_id, $limit);
        echo $this->load->view('user/profile_view/ajax_view/view_language_details', $data, TRUE);
    }

    //End person Language view Action
    //Start personal Details view

    public function edit_person_detail_form($person_id) {
        $data['person_info'] = $this->profile_model->user_info_by_id($person_id);

        $data['friends_details_part1'] = $this->profile_model->select_my_friends_details_part1($person_id);
        $part1_total = count($data['friends_details_part1']);
        $data['friends_details_part2'] = $this->profile_model->select_my_friends_details_part2($person_id);
        $part2_total = count($data['friends_details_part2']);
        $data['total_friends'] = $part1_total + $part2_total;

        echo $this->load->view('user/profile_view/ajax_view/edit_person_detail_form', $data, TRUE);
    }

    public function update_person_info_by_id($person_id) {
        $this->profile_model->update_personal_information_by_id($person_id);
        $data['person_info'] = $this->profile_model->user_info_by_id($person_id);
        $data['person_feature_details'] = $this->super_admin_model->select_person_feature_details_by_id($person_id);

        $data['friends_details_part1'] = $this->profile_model->select_my_friends_details_part1($person_id);
        $part1_total = count($data['friends_details_part1']);
        $data['friends_details_part2'] = $this->profile_model->select_my_friends_details_part2($person_id);
        $part2_total = count($data['friends_details_part2']);
        $data['total_friends'] = $part1_total + $part2_total;

        echo $this->load->view('user/profile_view/ajax_view/view_person_details', $data, TRUE);
    }

    /*
     * @Function            : cancel_update_person_info
     * @Description         : Reloads the personal info view when cancel button
     *                        clicked in edit personal information.
     * @Developed By        : Md Mashqur Ul ALam
     * @Start DateTime      : 29-12-16  11:30 AM
     * @Parameter           : Null
     * @Return              : Ajax View [view_person_details.php]    
     * @Status              : Available       
     */

    public function cancel_update_person_info() {

        if ($this->input->is_ajax_request()) {
            $person_id = $this->session->person_id;
            $data['person_info'] = $this->profile_model->user_info_by_id($person_id);
            $data['person_feature_details'] = $this->super_admin_model->select_person_feature_details_by_id($person_id);

            $data['friends_details_part1'] = $this->profile_model->select_my_friends_details_part1($person_id);
            $part1_total = count($data['friends_details_part1']);
            $data['friends_details_part2'] = $this->profile_model->select_my_friends_details_part2($person_id);
            $part2_total = count($data['friends_details_part2']);
            $data['total_friends'] = $part1_total + $part2_total;
            echo $this->load->view('user/profile_view/ajax_view/view_person_details', $data, TRUE);
        } else {
            redirect('/');
        }
    }

    //End personal Details view


    public function change_status_to_talha_user() {
        $field = $this->uri->segment(3);
        $new_status = $this->uri->segment(4);
        $person_id = $this->uri->segment(5);
        switch ($field) {
            case 'email':
                $this->super_admin_profile_model->change_email_status($new_status, $person_id);
                $data['person_feature_details'] = $this->super_admin_model->select_person_feature_details_by_id($person_id);

                echo $this->load->view('user/profile_view/ajax_view/view_profile_email_action', $data, TRUE);
                break;
            case 'contact':
                $this->super_admin_profile_model->change_contact_status($new_status, $person_id);
                $data['person_feature_details'] = $this->super_admin_model->select_person_feature_details_by_id($person_id);

                echo $this->load->view('user/profile_view/ajax_view/view_profile_contact_action', $data, TRUE);
                break;
            case 'address':
                $this->super_admin_profile_model->change_address_status($new_status, $person_id);
                $data['person_feature_details'] = $this->super_admin_model->select_person_feature_details_by_id($person_id);

                echo $this->load->view('user/profile_view/ajax_view/view_profile_address_action', $data, TRUE);
                break;
            case 'birthday':
                $this->super_admin_profile_model->change_birthday_status($new_status, $person_id);
                $data['person_feature_details'] = $this->super_admin_model->select_person_feature_details_by_id($person_id);

                echo $this->load->view('user/profile_view/ajax_view/view_profile_birthday_action', $data, TRUE);
                break;
        }
    }

    public function change_status_to_public() {
        $field = $this->uri->segment(3);
        $new_status = $this->uri->segment(4);
        $person_id = $this->uri->segment(5);
        switch ($field) {
            case 'email':
                $this->super_admin_profile_model->change_email_status($new_status, $person_id);
                $data['person_feature_details'] = $this->super_admin_model->select_person_feature_details_by_id($person_id);

                echo $this->load->view('user/profile_view/ajax_view/view_profile_email_action', $data, TRUE);
                break;
            case 'contact':
                $this->super_admin_profile_model->change_contact_status($new_status, $person_id);
                $data['person_feature_details'] = $this->super_admin_model->select_person_feature_details_by_id($person_id);

                echo $this->load->view('user/profile_view/ajax_view/view_profile_contact_action', $data, TRUE);
                break;
            case 'address':
                $this->super_admin_profile_model->change_address_status($new_status, $person_id);
                $data['person_feature_details'] = $this->super_admin_model->select_person_feature_details_by_id($person_id);

                echo $this->load->view('user/profile_view/ajax_view/view_profile_address_action', $data, TRUE);
                break;
            case 'birthday':
                $this->super_admin_profile_model->change_birthday_status($new_status, $person_id);
                $data['person_feature_details'] = $this->super_admin_model->select_person_feature_details_by_id($person_id);

                echo $this->load->view('user/profile_view/ajax_view/view_profile_birthday_action', $data, TRUE);
                break;
        }
    }

    public function change_status_to_link() {
        $field = $this->uri->segment(3);
        $new_status = $this->uri->segment(4);
        $person_id = $this->uri->segment(5);
        switch ($field) {
            case 'email':
                $this->super_admin_profile_model->change_email_status($new_status, $person_id);
                $data['person_feature_details'] = $this->super_admin_model->select_person_feature_details_by_id($person_id);
                echo $this->load->view('user/profile_view/ajax_view/view_profile_email_action', $data, TRUE);
                break;
            case 'contact':
                $this->super_admin_profile_model->change_contact_status($new_status, $person_id);
                $data['person_feature_details'] = $this->super_admin_model->select_person_feature_details_by_id($person_id);
                echo $this->load->view('user/profile_view/ajax_view/view_profile_contact_action', $data, TRUE);
                break;
            case 'address':
                $this->super_admin_profile_model->change_address_status($new_status, $person_id);
                $data['person_feature_details'] = $this->super_admin_model->select_person_feature_details_by_id($person_id);
                echo $this->load->view('user/profile_view/ajax_view/view_profile_address_action', $data, TRUE);
                break;
            case 'birthday':
                $this->super_admin_profile_model->change_birthday_status($new_status, $person_id);
                $data['person_feature_details'] = $this->super_admin_model->select_person_feature_details_by_id($person_id);
                echo $this->load->view('user/profile_view/ajax_view/view_profile_birthday_action', $data, TRUE);
                break;
        }
    }

    public function change_status_to_only_me() {
        $field = $this->uri->segment(3);
        $new_status = $this->uri->segment(4);
        $person_id = $this->uri->segment(5);
        switch ($field) {
            case 'email':
                $this->super_admin_profile_model->change_email_status($new_status, $person_id);
                $data['person_feature_details'] = $this->super_admin_model->select_person_feature_details_by_id($person_id);
                echo $this->load->view('user/profile_view/ajax_view/view_profile_email_action', $data, TRUE);
                break;
            case 'contact':
                $this->super_admin_profile_model->change_contact_status($new_status, $person_id);
                $data['person_feature_details'] = $this->super_admin_model->select_person_feature_details_by_id($person_id);
                echo $this->load->view('user/profile_view/ajax_view/view_profile_contact_action', $data, TRUE);
                break;
            case 'address':
                $this->super_admin_profile_model->change_address_status($new_status, $person_id);
                $data['person_feature_details'] = $this->super_admin_model->select_person_feature_details_by_id($person_id);
                echo $this->load->view('user/profile_view/ajax_view/view_profile_address_action', $data, TRUE);
                break;
            case 'birthday':
                $this->super_admin_profile_model->change_birthday_status($new_status, $person_id);
                $data['person_feature_details'] = $this->super_admin_model->select_person_feature_details_by_id($person_id);
                echo $this->load->view('user/profile_view/ajax_view/view_profile_birthday_action', $data, TRUE);
                break;
        }
    }

    //End personal Details view Action

    public function master_page() {
        $data = array();
        $this->load->view('user_back_end/master', $data);
    }

    public function view_test() {
        $data = array();
        $right_side_content = array('FALSE');
        $right_side_content['quizes'] = TRUE;
        $right_side_content['popular_group'] = TRUE;
        $right_side_content['suggested_link'] = TRUE;
        $right_side_content['tt_online_course'] = TRUE;
        $data = $this->populate_right_side($right_side_content);

        $person_id = $this->session->userdata('user_id');
        $data['active_menu'] = '';
        $data['active_sub_menu'] = '';
        $data['left_side'] = 1;
        $data['left_side_menu_view'] = 1;
        $data['right_content'] = $this->load->view('user/profile_view/profile_right_content', $data, TRUE);

        $data['main_content'] = $this->load->view('user/profile_view/view_test', $data, true);
        $this->load->view('user/master', $data);
    }

    public function my_wish_list($person_url) {

        $person_id = $this->session->userdata('user_id');
        $data['person_info'] = $this->profile_model->person_info_by_url($person_url);
        if ($data['person_info']) {
            if ($data['person_info']->person_id != $person_id) {
                redirect();
            }
        } else {
            redirect();
        }

        $data['active_menu'] = 'dashboard';
        $data['active_sub_menu'] = 'my_wish_list';
        $data['left_side'] = 1;
        $data['left_side_menu_view'] = 1;
        $data['left_content'] = $this->load->view('user/side_menu', $data, TRUE);
        $data['right_content'] = $this->load->view('user/right_content', $data, TRUE);

        $data['student_info'] = $this->profile_model->student_info_by_id($person_id);
        $data['user_work_details'] = $this->profile_model->select_user_work_details($person_id);
        $data['user_education_details'] = $this->profile_model->select_user_education_details($person_id);
        $data['wish_list_info'] = $this->profile_model->select_wish_list($person_id);
        foreach ($data['wish_list_info'] as $v_wish_list_info) {
            $data['url'][$v_wish_list_info->course_id] = $this->profile_model->select_all_course_url($v_wish_list_info->url_id);
        }

        //NEW VIEW

        $data['main_content'] = $this->load->view('user/profile_view/dashboard/my_wish_list', $data, true);
        $this->load->view('user/master', $data);
    }

    /**
     * @Function            : my_content_library 
     * @Used IN             : @self
     * @Description         : view content library if user post or add to content library
     * @                    : @Update1 - check if user can add other content library
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : Unknown
     * @Updated Date Time   : 26-02-2016 12:07 AM
     * @Updated By          : Ripon Jaherul
     * @Status              : available      
     * */
    public function my_content_library() {
        $data['active_menu'] = 'dashboard';
        $data['active_sub_menu'] = 'content_library';
        $data['left_side'] = 1;
        $data['left_side_menu_view'] = 1;

        $person_id = $this->session->userdata('user_id');
        //$data['page'] = $number;
//        if ($number != NULL) {
//            $value = $number * 10 - 10;
//        } else {
//            $value = 0;
//        }
        $page_number=1;
        $data['person_detail'] = $this->profile_model->user_info_by_id($this->session->person_id);
        $data['content_library'] = $this->post_model->select_my_content_library_by_person_id($person_id, 0);
        $data['total_content_library'] = count($this->post_model->total_content_library_by_person_id($person_id));
        // $this->cf->debug($data['total_content_library']);
        $data['post_images'] = $this->profile_model->get_post_image_album_content();
        $data['post_last_image'] = $this->profile_model->get_last_post_image_content();
        $data['profile_images'] = $this->profile_model->get_profile_image_album_content();
        //$this->cf->debug($data['profile_images']); 
        $params = array('url' => '', 'div_id' => 'content_library_pagination', 'total_row' => $data['total_content_library'], 'per_page' => 10, 'current_page' => $page_number, 'total_link' => 10);
        $data['pagination_link'] = $this->tt_pagination->view_pagination_link($params);

        $data['main_content'] = $this->load->view('user/profile_view/dashboard/content_library', $data, true);
        $this->load->view('user/master', $data);
    }
    
    public function my_content_library_ajax(){
        if ($this->input->is_ajax_request()){
            $page_number = $this->input->post('page_number', TRUE);
            $limit_offset = ($page_number * 10) - 10;
            $person_id = $this->session->userdata('user_id');
            $data['person_detail'] = $this->profile_model->user_info_by_id($this->session->person_id);
            $data['content_library'] = $this->post_model->select_my_content_library_by_person_id($person_id, $limit_offset);
            $data['total_content_library'] = count($this->post_model->total_content_library_by_person_id($person_id));
            //$this->cf->dd($data['total_content_library']);
            $data['post_images'] = $this->profile_model->get_post_image_album_content();
            $data['post_last_image'] = $this->profile_model->get_last_post_image_content();
            $data['profile_images'] = $this->profile_model->get_profile_image_album_content();
            //$this->cf->debug($data['profile_images']); 
            $params = array('url' => '', 'div_id' => 'content_library_pagination', 'total_row' => $data['total_content_library'], 'per_page' => 10, 'current_page' => $page_number, 'total_link' => 10);
            $data['pagination_link'] = $this->tt_pagination->view_pagination_link($params);

            echo $this->load->view('user/profile_view/dashboard/dashboard_ajax_view/content_library_ajax_view', $data, true);
            
        }
    }

    public function download_content_library($post_id) {
        $result = $this->post_model->get_single_post_by_post_id($post_id);
        $profile = $this->post_model->get_profile_url($result->posted_by);
        $this->load->helper('download');
        $file_name = $result->post_file_original_name;
        $files_url = 'content-library/' . $profile->url . '/' . $result->post_details;
        $data = file_get_contents("$files_url");
        if ($data) {
            force_download($file_name, $data);
        } else {
            return;
        }
    }

    /**
     * @Function            : my_note_alert 
     * @Used IN             : @function-'user/profile_view/dashboard/note_alert.php'
     * @Description         : validate all kind of password related condition and update password
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : Unknown
     * @Parameter           : number[INTEGER]
     * @View                : user/profile_view/dashboard/note_alert.php
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available        
     * */
    public function my_note_alert($number = NULL) {
        $data['active_menu'] = 'dashboard';
        $data['active_sub_menu'] = 'note_alert';
        $data['left_side'] = 1;
        $data['left_side_menu_view'] = 1;
        $person_id = $this->session->userdata('user_id');

//        $data['page'] = $number;
//        if ($number != NULL) {
//            $value = $number * 10 - 10;
//        } else {
//            $value = 0;
//        }
        $page_number = 1;

        $data['all_approved_group'] = $this->post_model->select_approved_group_by_person_id($person_id);
        $data['note_alert'] = $this->post_model->select_my_note_alert_by_person_id($person_id, 0);
         
        foreach ($data['note_alert'] as $note_alert_value) {
            $data['note_alert_url'][$note_alert_value->post_id] = $this->post_model->select_all_post_url_value_by_post_id($note_alert_value->post_id, 1);
        }
        $data['total_note_alert'] = count($this->post_model->total_my_note_alert_by_person_id($person_id));
       //$this->cf->dd($data['total_note_alert']);
        $params = array('url' => '', 'div_id' => 'note_alert_pagination', 'total_row' => $data['total_note_alert'], 'per_page' => 10, 'current_page' => $page_number, 'total_link' => 10);
        $data['pagination_link'] = $this->tt_pagination->view_pagination_link($params);
        
        $data['main_content'] = $this->load->view('user/profile_view/dashboard/note_alert', $data, true);
        $this->load->view('user/master', $data);
    }
    
    public function my_note_alert_ajax_view($number = NULL) {
        $data['active_menu'] = 'dashboard';
        $data['active_sub_menu'] = 'note_alert';
        $data['left_side'] = 1;
        $data['left_side_menu_view'] = 1;
        $person_id = $this->session->userdata('user_id');

//        $data['page'] = $number;
//        if ($number != NULL) {
//            $value = $number * 10 - 10;
//        } else {
//            $value = 0;
//        }
        $page_number = $this->input->post('page_number', TRUE);
        $limit_offset = ($page_number*10)-10; 

        $data['all_approved_group'] = $this->post_model->select_approved_group_by_person_id($person_id);
        $data['note_alert'] = $this->post_model->select_my_note_alert_by_person_id($person_id, $limit_offset);
         
        foreach ($data['note_alert'] as $note_alert_value) {
            $data['note_alert_url'][$note_alert_value->post_id] = $this->post_model->select_all_post_url_value_by_post_id($note_alert_value->post_id, 1);
        }
        $data['total_note_alert'] = count($this->post_model->total_my_note_alert_by_person_id($person_id));
       //$this->cf->dd($data['total_note_alert']);
        $params = array('url' => '', 'div_id' => 'note_alert_pagination', 'total_row' => $data['total_note_alert'], 'per_page' => 10, 'current_page' => $page_number, 'total_link' => 10);
        $data['pagination_link'] = $this->tt_pagination->view_pagination_link($params);
        
       echo $this->load->view('user/profile_view/dashboard/dashboard_ajax_view/note_alert_ajax_view', $data, true);
        
    }

    /**
     * @Function            : view_note_alert 
     * @Used IN             : @function-'user/profile_view/dashboard/note_alert.php'
     * @Description         : view note alert
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : Unknown
     * @Parameter           : $post_id[INTEGER]
     * @View                : user/profile_view/dashboard/view_note_alert.php
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available        
     * */
    public function view_note_alert($encoded_post_id, $type) {
        $person_id = $this->session->userdata('user_id');
        $post_id = $this->utility_model->decode_id($encoded_post_id, 'Tt', '/');
        $data['post_value'] = $this->post_model->select_post_by_post_id($post_id);

        if (!$data['post_value']) {
            redirect();
        }

        if (in_array($data['post_value']->post_status, Array(2, 3, 4))) {
            redirect();
        }

        $this->check_view_note_alert_validation($data, $person_id, $type);

        $data['active_menu'] = 'dashboard';
        if ($data['post_value']->post_type == 1 || $data['post_value']->post_type == 2) {
            $data['active_sub_menu'] = 'note_alert';
        } elseif ($data['post_value']->post_type == 3 || $data['post_value']->post_type == 4 || $data['post_value']->post_type == 5) {
            $data['active_sub_menu'] = 'content_library';
        }
        $data['left_side'] = 1;
        $data['left_side_menu_view'] = 1;

        $post_data = $this->post_model->get_single_post_data($data, $person_id, $post_id);

        $data['main_content'] = $this->load->view('user/profile_view/dashboard/view_note_alert', $post_data, TRUE);
        $this->load->view('user/master', $data);
    }

    /**
     * @Function            : edit_post 
     * @Used IN             : @function-'user/home.php'
     * @Description         : edit post
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 05-06-2016 04:08 PM
     * @Parameter           : $encrypted_post_id[STRING]
     * @View                : None
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function edit_post($encrypted_post_id) {
        $person_id = $this->session->userdata('user_id');
        $post_id = $this->utility_model->decode_id($encrypted_post_id, 'Tt', '/');
        $data['person_id'] = $person_id;
        $data['all_approved_group'] = $this->post_model->select_approved_group_by_person_id($person_id);
        $data['post_value'] = $this->post_model->select_post_by_post_id($post_id);

        if (!$data['post_value']) {
            redirect();
        }
        if ($data['post_value']->posted_by != $person_id) {
            redirect();
        }
        $data['active_menu'] = '';
        $data['active_sub_menu'] = '';
        $data['left_side'] = 1;
        $data['left_side_menu_view'] = 1;
        $data['selected_group_id'] = Array();

        if ($data['post_value']->post_publication_status == 4) {
            $data['selected_group'] = $this->post_model->get_all_selected_group($post_id);
            foreach ($data['selected_group'] as $value) {
                $data['selected_group_id'][] = $value->group_id;
            }
        }

        $data['post_url'] = $this->post_model->select_post_comment_url($post_id, 1);

        $data['main_content'] = $this->load->view('user/post_ajax/edit_post_from', $data, TRUE);
        $this->load->view('user/master', $data);
    }

    /**
     * @Function            : check_view_note_alert_validation 
     * @Used IN             : @function-'view_note_alert'    this[@controller]
     * @Description         : view note alert
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 05-06-2016 02:38 PM
     * @Parameter           : $data[ARRAY], $person_id[INTEGER], $type[INTEGER]
     * @View                : None
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available        
     * */
    function check_view_note_alert_validation($data, $person_id, $type) {
        if (!$data['post_value']) {
            if ($type == 1) {
                redirect('my-note-alert');
            }
            if ($type == 2) {
                redirect('my-content-library');
            }
        }
        $this->check_linked_note_alert_validation($data, $person_id);
        $this->check_group_note_alert_validation($data, $person_id);
    }

    /**
     * @Function            : check_linked_note_alert_validation 
     * @Used IN             : @function-'check_view_note_alert_validation'    this[@controller]
     * @Description         : view note alert
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 05-06-2016 02:38 PM
     * @Parameter           : $data[ARRAY], $person_id[INTEGER], $type[INTEGER]
     * @View                : None
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available        
     * */
    function check_linked_note_alert_validation($data, $person_id) {
        $note_alert_array = Array('1', '2');
        $content_array = Array('3', '4', '5');
        if ($data['post_value']->post_publication_status == 3) {
            $linked_person = $this->post_model->get_all_linked_person($person_id);
            if ($linked_person) {
                if (!in_array($person_id, $linked_person)) {
                    if (in_array($data['post_value']->post_type, $note_alert_array)) {
                        redirect('my-note-alert');
                    }
                    if (in_array($data['post_value']->post_type, $content_array)) {
                        redirect('my-content-library');
                    }
                }
            }
        }
    }

    /**
     * @Function            : check_group_note_alert_validation 
     * @Used IN             : @function-'check_view_note_alert_validation'    this[@controller]
     * @Description         : view note alert
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 05-06-2016 02:38 PM
     * @Parameter           : $data[ARRAY], $person_id[INTEGER], $type[INTEGER]
     * @View                : None
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available        
     * */
    function check_group_note_alert_validation($data, $person_id) {
        $note_alert_array = Array('1', '2');
        $content_array = Array('3', '4', '5');
        if ($data['post_value']->post_publication_status == 4) {
            $grouped_person = $this->post_model->get_all_grouped_person_by_post_id($data['post_value']->post_id);
            if ($grouped_person->grouped_person_id != '') {
                $grouped_person_array = explode(',', $grouped_person->grouped_person_id);
                if (!in_array($person_id, $grouped_person_array)) {
                    if (in_array($data['post_value']->post_type, $note_alert_array)) {
                        redirect('my-note-alert');
                    }
                    if (in_array($data['post_value']->post_type, $content_array)) {
                        redirect('my-content-library');
                    }
                }
            }
        }
    }

    public function delete_wishlist($wish_list_management_id) {

        $this->profile_model->delete_select_wishlist($wish_list_management_id);
        redirect('profile/wishlist_content');
    }

    public function my_billing() {


        $person_id = $this->session->userdata('user_id');
        $data['active_menu'] = 'dashboard';
        $data['active_sub_menu'] = 'my_billing';
        $data['left_side'] = 1;
        $data['left_side_menu_view'] = 1;

        $person_id = $this->session->userdata('user_id');
        $data['student_info'] = $this->profile_model->student_info_by_id($person_id);
        $data['user_work_details'] = $this->profile_model->select_user_work_details($person_id);
        $data['user_education_details'] = $this->profile_model->select_user_education_details($person_id);
        $data['my_billing'] = $this->payment_model->all_my_billing_details($person_id);

        $data['main_content'] = $this->load->view('user/profile_view/dashboard/my_billing', $data, true);
        $this->load->view('user/master', $data);
    }

    public function connect_user($person_id) {

        $data = array();
        $user_id = $this->session->userdata('user_id');
        $profile_id = $this->session->userdata('profile_id');
        if ($user_id == $person_id) {
            redirect($profile_id . '/my-link');
        }
        $person_info = $this->profile_model->person_info_by_id($person_id);
        if (!$person_info) {
            redirect($profile_id . '/my-link');
        }
        $result = $this->f_end_model->check_tt_requst($user_id, $person_id);
        $gdata = array();
        if (!$result) {
            $gdata['person_id'] = $person_id;
            $gdata['requested_person_id'] = $user_id;
            $gdata['add_link_request_status'] = 3;
            $gdata['add_link_requested_date_time'] = date("Y-m-d H:i:s", strtotime(gmdate('Y-m-d H:i:s')) - $this->session->userdata('time_offset'));
            $this->profile_model->save_tt_link_information($gdata);



            redirect($profile_id . '/my-link');
        } else if ($result && $result->add_link_request_status == 3) {

            redirect($profile_id . '/my-link');
        } elseif ($result && $result->add_link_request_status == 1) {

            redirect($profile_id . '/my-link');
        } elseif ($result && $result->add_link_request_status == 2) {
            $data['person_link_info'] = $this->profile_model->person_link_info_by_link_person_id($person_id);
            if ($data['person_link_info']->requested_person_id == $person_id) {
                $this->profile_model->reconnect_person_link($data['person_link_info']->person_link_id, $result->requested_person_id, $data['person_link_info']->pl_person_id);
            } else {
                $this->profile_model->reconnect_person_link($data['person_link_info']->person_link_id, $data['person_link_info']->pl_person_id, $data['person_link_info']->requested_person_id);
            }
            redirect($profile_id . '/my-link');
        } elseif ($result && $result->add_link_request_status == 0) {
            $data['person_link_info'] = $this->profile_model->person_link_info_by_link_person_id($person_id);
            if ($data['person_link_info']->requested_person_id == $person_id) {
                $this->profile_model->reconnect_person_link($data['person_link_info']->person_link_id, $result->requested_person_id, $data['person_link_info']->pl_person_id);
            } else {
                $this->profile_model->reconnect_person_link($data['person_link_info']->person_link_id, $data['person_link_info']->pl_person_id, $data['person_link_info']->requested_person_id);
            }
            redirect($profile_id . '/my-link');
        } elseif ($result && $result->add_link_request_status == 5) {
            $data['person_link_info'] = $this->profile_model->person_link_info_by_link_person_id($person_id);
            if ($data['person_link_info']->requested_person_id == $person_id) {
                $this->profile_model->reconnect_person_link($data['person_link_info']->person_link_id, $result->requested_person_id, $data['person_link_info']->pl_person_id);
            } else {
                $this->profile_model->reconnect_person_link($data['person_link_info']->person_link_id, $data['person_link_info']->pl_person_id, $data['person_link_info']->requested_person_id);
            }
            redirect($profile_id . '/my-link');
        }
    }

    /**
     * @Function            : connect_user_from_profile
     * @Used IN             : for sending link request
     * @Description         : 
     * @Developed By        : 
     * @Start DateTime      :
     * @Updated Date Time   : 19/04/2016
     * @Updated By          : Afrin jahan Noumin  
     * @modified for        : Save notification for Sending link request.     
     * @Parameter           : 
     * @View                : None
     * @Redirect            : None
     * @Return              :   
     * @Status              : Available       
     */
    public function connect_user_from_profile($person_id) {
        $data = array();
        $user_id = $this->session->userdata('user_id');
        $profile_id = $this->session->userdata('profile_id');

        $result = $this->profile_model->check_tt_requst($user_id, $person_id);
        $gdata = array();
        if (!$result) {
            $gdata['person_id'] = $person_id;
            $gdata['requested_person_id'] = $user_id;
            $gdata['add_link_request_status'] = 3;
            $gdata['add_link_requested_date_time'] = date("Y-m-d H:i:s", strtotime(gmdate('Y-m-d H:i:s')) - $this->session->userdata('time_offset'));            
            $link_request_id = $this->profile_model->save_tt_link_information($gdata);
            
            //........save_notification for send request.....
            $this->notification_dashboard_model->save_send_link_request_notification($gdata['person_id'], $gdata['requested_person_id'], $link_request_id);
            //........end save_notification for send request.......
            $this->profile_action_view($person_id);
        } elseif ($result && $result->add_link_request_status == 3) {
            $this->profile_action_view($person_id);
        } elseif ($result && $result->add_link_request_status == 1) {
            $this->profile_action_view($person_id);
        } elseif ($result && $result->add_link_request_status == 2) {
            $data['person_link_info'] = $this->profile_model->person_link_info_by_link_person_id($person_id);
            if ($data['person_link_info']->requested_person_id == $person_id) {
                $link_request_id = $this->profile_model->reconnect_person_link($data['person_link_info']->person_link_id, $result->requested_person_id, $data['person_link_info']->pl_person_id);
                //.........................save_notification for send request........................
                $this->notification_dashboard_model->save_send_link_request_notification($person_id, $user_id, $link_request_id);
                //.........................end save_notification for send request........................
                $this->profile_action_view($person_id);
            } else {
                $link_request_id = $this->profile_model->reconnect_person_link($data['person_link_info']->person_link_id, $data['person_link_info']->pl_person_id, $data['person_link_info']->requested_person_id);
                $this->notification_dashboard_model->save_send_link_request_notification($data['person_link_info']->pl_person_id, $data['person_link_info']->requested_person_id, $link_request_id);
            }
            $this->profile_action_view($person_id);
        } elseif ($result && $result->add_link_request_status == 0) {
            $data['person_link_info'] = $this->profile_model->person_link_info_by_link_person_id($person_id);
            if ($data['person_link_info']->requested_person_id == $person_id) {
                $link_request_id = $this->profile_model->reconnect_person_link($data['person_link_info']->person_link_id, $result->requested_person_id, $data['person_link_info']->pl_person_id);
                $this->notification_dashboard_model->save_send_link_request_notification($person_id, $user_id, $link_request_id);
            } else {
                $link_request_id = $this->profile_model->reconnect_person_link($data['person_link_info']->person_link_id, $data['person_link_info']->pl_person_id, $data['person_link_info']->requested_person_id);
                $this->notification_dashboard_model->save_send_link_request_notification($data['person_link_info']->pl_person_id, $data['person_link_info']->requested_person_id, $link_request_id);
            }
            $this->profile_action_view($person_id);
        } elseif ($result && $result->add_link_request_status == 5) {
            $data['person_link_info'] = $this->profile_model->person_link_info_by_link_person_id($person_id);
            if ($data['person_link_info']->requested_person_id == $person_id) {
                $link_request_id = $this->profile_model->reconnect_person_link($data['person_link_info']->person_link_id, $result->requested_person_id, $data['person_link_info']->pl_person_id);
                $this->notification_dashboard_model->save_send_link_request_notification($person_id, $user_id, $link_request_id);
            } else {
                $link_request_id = $this->profile_model->reconnect_person_link($data['person_link_info']->person_link_id, $data['person_link_info']->pl_person_id, $data['person_link_info']->requested_person_id);
                $this->notification_dashboard_model->save_send_link_request_notification($data['person_link_info']->pl_person_id, $data['person_link_info']->requested_person_id, $link_request_id);
            }
            $this->profile_action_view($person_id);
        }
    }

    public function profile_action_view($person_id) {
        $data['person_link_info'] = $this->profile_model->person_link_info_by_link_person_id($person_id);
        $data['person_info'] = $this->profile_model->person_info_by_person_id($person_id);
        echo $this->load->view('user/profile_view/profile_action', $data, true);
    }

    public function connect_suggested_user($person_id) {

        $data = array();
        $user_id = $this->session->userdata('user_id');
        $profile_id = $this->session->userdata('profile_id');

        $result = $this->f_end_model->check_tt_requst($user_id, $person_id);
        $gdata = array();
        if (!$result) {
            $gdata['person_id'] = $person_id;
            $gdata['requested_person_id'] = $user_id;
            $gdata['add_link_request_status'] = 3;
            $gdata['add_link_requested_date_time'] = date("Y-m-d H:i:s", strtotime(gmdate('Y-m-d H:i:s')) - $this->session->userdata('time_offset'));
            $this->profile_model->save_tt_link_information($gdata);
            $this->notification_dashboard_model->save_send_link_request_notification($gdata['person_id'], $gdata['requested_person_id']);

            $this->link_page_suggestion();
        } elseif ($result && $result->add_link_request_status == 3) {
            echo '0';
        } elseif ($result && $result->add_link_request_status == 1) {
            echo '0';
        } elseif ($result && $result->add_link_request_status == 2) {
            $data['person_link_info'] = $this->profile_model->person_link_info_by_link_person_id($person_id);
            if ($data['person_link_info']->requested_person_id == $person_id) {
                $this->profile_model->reconnect_person_link($data['person_link_info']->person_link_id, $result->requested_person_id, $data['person_link_info']->pl_person_id);
                $this->notification_dashboard_model->save_send_link_request_notification($person_id, $user_id);
            } else {
                $this->profile_model->reconnect_person_link($data['person_link_info']->person_link_id, $data['person_link_info']->pl_person_id, $data['person_link_info']->requested_person_id);
                $this->notification_dashboard_model->save_send_link_request_notification($data['person_link_info']->pl_person_id, $data['person_link_info']->requested_person_id);
            }
            $this->link_page_suggestion();
        } elseif ($result && $result->add_link_request_status == 0) {
            $data['person_link_info'] = $this->profile_model->person_link_info_by_link_person_id($person_id);
            if ($data['person_link_info']->requested_person_id == $person_id) {
                $this->profile_model->reconnect_person_link($data['person_link_info']->person_link_id, $result->requested_person_id, $data['person_link_info']->pl_person_id);

                $this->notification_dashboard_model->save_send_link_request_notification($person_id, $user_id);
            } else {
                $this->profile_model->reconnect_person_link($data['person_link_info']->person_link_id, $data['person_link_info']->pl_person_id, $data['person_link_info']->requested_person_id);
                $this->notification_dashboard_model->save_send_link_request_notification($data['person_link_info']->pl_person_id, $data['person_link_info']->requested_person_id);
            }
            $this->link_page_suggestion();
        } elseif ($result && $result->add_link_request_status == 5) {
            $data['person_link_info'] = $this->profile_model->person_link_info_by_link_person_id($person_id);
            if ($data['person_link_info']->requested_person_id == $person_id) {
                $this->profile_model->reconnect_person_link($data['person_link_info']->person_link_id, $result->requested_person_id, $data['person_link_info']->pl_person_id);
                $this->notification_dashboard_model->save_send_link_request_notification($person_id, $user_id);
            } else {
                $this->profile_model->reconnect_person_link($data['person_link_info']->person_link_id, $data['person_link_info']->pl_person_id, $data['person_link_info']->requested_person_id);
                $this->notification_dashboard_model->save_send_link_request_notification($data['person_link_info']->pl_person_id, $data['person_link_info']->requested_person_id);
            }
            $this->link_page_suggestion();
        }
        return;
    }

    public function connect_connectivity_suggested_user() {

        if ((filter_input(INPUT_SERVER, 'HTTP_X_REQUESTED_WITH')) && (filter_input(INPUT_SERVER, 'HTTP_X_REQUESTED_WITH') == 'XMLHttpRequest')) {
            $person_id = $this->input->post('resuest_person_id');
            $data = array();
            $user_id = $this->session->userdata('user_id');
            $profile_id = $this->session->userdata('profile_id');

            $result = $this->F_end_model->check_tt_requst($user_id, $person_id);
            $gdata = array();
            if (!$result) {
                $gdata['person_id'] = $person_id;
                $gdata['requested_person_id'] = $user_id;
                $gdata['add_link_request_status'] = 3;
                $gdata['add_link_requested_date_time'] = date("Y-m-d H:i:s", strtotime(gmdate('Y-m-d H:i:s')) - $this->session->userdata('time_offset'));
                $this->profile_model->save_tt_link_information($gdata);
                $this->notification_dashboard_model->save_send_link_request_notification($gdata['person_id'], $gdata['requested_person_id']);
            } elseif ($result && $result->add_link_request_status == 3) {
                echo '0';
            } elseif ($result && $result->add_link_request_status == 1) {
                echo '0';
            } elseif ($result && $result->add_link_request_status == 2) {
                $data['person_link_info'] = $this->profile_model->person_link_info_by_link_person_id($person_id);
                if ($data['person_link_info']->requested_person_id == $person_id) {
                    $this->profile_model->reconnect_person_link($data['person_link_info']->person_link_id, $result->requested_person_id, $data['person_link_info']->pl_person_id);
                    $this->notification_dashboard_model->save_send_link_request_notification($person_id, $user_id);
                } else {
                    $this->profile_model->reconnect_person_link($data['person_link_info']->person_link_id, $data['person_link_info']->pl_person_id, $data['person_link_info']->requested_person_id);
                    $this->notification_dashboard_model->save_send_link_request_notification($data['person_link_info']->pl_person_id, $data['person_link_info']->requested_person_id);
                }
            } elseif ($result && $result->add_link_request_status == 0) {
                $data['person_link_info'] = $this->profile_model->person_link_info_by_link_person_id($person_id);
                if ($data['person_link_info']->requested_person_id == $person_id) {
                    $this->profile_model->reconnect_person_link($data['person_link_info']->person_link_id, $result->requested_person_id, $data['person_link_info']->pl_person_id);
                    $this->notification_dashboard_model->save_send_link_request_notification($person_id, $user_id);
                } else {
                    $this->profile_model->reconnect_person_link($data['person_link_info']->person_link_id, $data['person_link_info']->pl_person_id, $data['person_link_info']->requested_person_id);

                    $this->notification_dashboard_model->save_send_link_request_notification($data['person_link_info']->pl_person_id, $data['person_link_info']->requested_person_id);
                }
                $this->connectivity_page_suggestion();
            } elseif ($result && $result->add_link_request_status == 5) {
                $data['person_link_info'] = $this->profile_model->person_link_info_by_link_person_id($person_id);
                if ($data['person_link_info']->requested_person_id == $person_id) {
                    $this->profile_model->reconnect_person_link($data['person_link_info']->person_link_id, $result->requested_person_id, $data['person_link_info']->pl_person_id);
                    $this->notification_dashboard_model->save_send_link_request_notification($person_id, $user_id);
                } else {
                    $this->profile_model->reconnect_person_link($data['person_link_info']->person_link_id, $data['person_link_info']->pl_person_id, $data['person_link_info']->requested_person_id);

                    $this->notification_dashboard_model->save_send_link_request_notification($data['person_link_info']->pl_person_id, $data['person_link_info']->requested_person_id);
                }
            }
        } else {
            redirect('/link_location');
        }
    }

    public function next_person() {
        $this->link_page_suggestion();
    }

    public function connectivity_page_suggestion() {
        $person_id = $this->session->userdata('user_id');

//START Suggested Person
        $data['suggested_person'] = array();
        $data['teavel_city'] = $this->map_model->select_user_all_travel_location($person_id);
        $data['current_location'] = $this->f_end_model->select_current_location_by_person_id($person_id);
        $data['travel_suggested_person'] = $this->map_model->select_travel_location_person_list($data['teavel_city'], $data['current_location']->geo_id);
        $data['country_suggested_person'] = $this->map_model->select_current_country_person_list($data['teavel_city'], $data['current_location']->person_city, $data['current_location']->person_country);
        $data['city_suggested_person'] = $this->map_model->select_current_city_person_list($data['teavel_city'], $data['current_location']->person_city, $data['current_location']->person_country);
        $data['suggested_person'] = array_merge($data['suggested_person'], $data['travel_suggested_person']);
        $data['suggested_person'] = array_merge($data['suggested_person'], $data['country_suggested_person']);
        $data['suggested_person'] = array_merge($data['suggested_person'], $data['city_suggested_person']);

        $data['person_info'] = array();
        foreach ($data['suggested_person'] as $v_suggested_person) {
            $data['person_info'][$v_suggested_person->person_id] = $this->profile_model->person_info_by_person_id($v_suggested_person->person_id);
            $data['person_work_experience'][$v_suggested_person->person_id] = $this->profile_model->select_person_latest_active_work_experience($v_suggested_person->person_id);
            $data['person_education'][$v_suggested_person->person_id] = $this->profile_model->select_person_latest_running_education($v_suggested_person->person_id);
            $data['linked_person'][$v_suggested_person->person_id] = $this->profile_model->person_link_info_by_requested_person_id($v_suggested_person->person_id);
        }
//END Suggested Person

        echo $this->load->view('user/profile_view/dashboard/link_network_page_suggestion', $data, TRUE);
    }

    public function link_page_suggestion() {
        $person_id = $this->session->userdata('user_id');

//START Suggested Person
        $data['suggested_person'] = array();
        //Education
        $data['person_all_education'] = $this->profile_model->select_user_education_details($person_id);
        $data['education_suggested_person'] = $this->profile_model->select_person_list_by_education($data['person_all_education']);
        //work experrience
        $data['person_all_work_experience'] = $this->profile_model->select_user_work_details($person_id);
        $data['work_suggested_person'] = $this->profile_model->select_person_list_by_work($data['person_all_work_experience']);
        // field of interest
        $data['person_all_field_of_interest'] = $this->profile_model->select_user_interest_field_all($person_id);
        $data['interest_suggested_person'] = $this->profile_model->select_person_list_by_interest($data['person_all_field_of_interest']);

        $data['suggested_person'] = array_merge($data['suggested_person'], $data['education_suggested_person']);
        $data['suggested_person'] = array_merge($data['suggested_person'], $data['work_suggested_person']);
        $data['suggested_person'] = array_merge($data['suggested_person'], $data['interest_suggested_person']);

        $data['person_info'] = array();
        $i = 0;
        $exist = array(0);
        foreach ($data['suggested_person'] as $v_suggested_person) {
            if ($exist[$v_suggested_person->person_id] == 0 && $v_suggested_person->person_id != $person_id) {
                $data['person_info'][$v_suggested_person->person_id] = $this->profile_model->person_info_by_person_id($v_suggested_person->person_id);
                $data['person_work_experience'][$v_suggested_person->person_id] = $this->profile_model->select_person_latest_active_work_experience($v_suggested_person->person_id);
                $data['person_education'][$v_suggested_person->person_id] = $this->profile_model->select_person_latest_running_education($v_suggested_person->person_id);
                $data['linked_person'][$v_suggested_person->person_id] = $this->profile_model->person_link_info_by_requested_person_id($v_suggested_person->person_id);
                $exist[$v_suggested_person->person_id] = 1;
            } else {
                unset($data['suggested_person'][$i]);
            }
            $i++;
        }
//END Suggested Person

        echo $this->load->view('user/profile_view/dashboard/my_link_page_suggestion', $data, TRUE);
    }

    public function my_link($person_url) {
        $data['active_menu'] = 'dashboard';
        $data['active_sub_menu'] = 'my_link';
        $data['left_side'] = 1;
        $data['left_side_menu_view'] = 1;
        $data['start'] = $start = ($this->uri->segment(3)) ? $this->uri->segment(3) : 0;
        $data['limit'] = $limit = 10;

        // LOAD VIEW

        $data['main_content'] = $this->load->view('user/profile_view/dashboard/my_link', $data, true);
        $this->load->view('user/master', $data);
    }

    public function load_link_person_by_ajax($person_url) {
        $person_info = $this->profile_model->person_info_by_url($person_url);
        $person_id = $person_info->person_id;
        $data['person_link'] = $this->profile_model->select_person_link_with_pagination('', '');

        foreach ($data['person_link'] as $v_link) {
            if ($v_link->person_id != $person_id) {
                $data['link_person_info'][$v_link->person_link_id] = $this->profile_model->person_info_by_person_id($v_link->person_id);
                $data['person_work_experience'][$v_link->person_link_id] = $this->profile_model->select_person_latest_active_work_experience($v_link->person_id);
                $data['person_education'][$v_link->person_link_id] = $this->profile_model->select_person_latest_running_education($v_link->person_id);
            } else if ($v_link->requested_person_id != $person_id) {
                $data['link_person_info'][$v_link->person_link_id] = $this->profile_model->person_info_by_person_id($v_link->requested_person_id);
                $data['person_work_experience'][$v_link->person_link_id] = $this->profile_model->select_person_latest_active_work_experience($v_link->person_id);
                $data['person_education'][$v_link->person_link_id] = $this->profile_model->select_person_latest_running_education($v_link->person_id);
            }
        }
        // LOAD VIEW
        echo $this->load->view('user/profile_view/dashboard/my_link_person_by_ajax', $data, true);
    }

    public function accept_person_link_request($link_person_id) {
        $data['person_link_info'] = $this->profile_model->person_link_info_by_link_person_id($link_person_id);
        if ($data['person_link_info']) {
            $this->profile_model->accept_person_link($data['person_link_info']->person_link_id, $link_person_id);
            $person_id = $this->session->userdata('user_id');
            $this->notification_dashboard_model->save_accept_request_notification($link_person_id, $person_id);
            $data['person_link_info'] = $this->profile_model->person_link_info_by_link_person_id($link_person_id);
            $data['person_info'] = $this->profile_model->person_info_by_person_id($link_person_id);
            $data['person_work_experience'] = $this->profile_model->select_person_latest_active_work_experience($data['person_info']->person_id);
            $data['person_education'] = $this->profile_model->select_person_latest_running_education($data['person_info']->person_id);
            echo $this->load->view('user/profile_view/dashboard/my_link_action', $data, true);
        } else {
            echo 1;
        }
    }

    public function cancel_person_link_request($link_person_id) {
        $data['person_link_info'] = $this->profile_model->person_link_info_by_link_person_id($link_person_id);
        if ($data['person_link_info']) {
            $this->profile_model->cancel_person_link($data['person_link_info']->person_link_id, $link_person_id);
        } else {
            echo 1;
        }
    }

    public function remove_person_link($link_person_id) {
        $data['person_link_info'] = $this->profile_model->person_link_info_by_link_person_id($link_person_id);
        if ($data['person_link_info']) {
            $this->profile_model->remove_person_link($data['person_link_info']->person_link_id, $link_person_id);
        } else {
            echo 1;
        }
    }

    public function block_person_link($link_person_id) {
        $person_id = $this->session->userdata('user_id');
        $data['person_link_info'] = $this->profile_model->person_link_info_by_link_person_id($link_person_id);
        if ($data['person_link_info']) {
            if ($person_id == $data['person_link_info']->requested_person_id) {
                $this->profile_model->block_person_link($data['person_link_info']->person_link_id, $data['person_link_info']->requested_person_id, $data['person_link_info']->pl_person_id);
            } else {
                $this->profile_model->block_person_link($data['person_link_info']->person_link_id, $data['person_link_info']->pl_person_id, $data['person_link_info']->requested_person_id);
            }
            $this->link_page_suggestion();
        } else {
            echo 1;
        }
    }
//updated by Kazol
    public function accept_person_link_request_from_profile($link_person_id) {
        $data['person_link_info'] = $this->profile_model->person_link_info_by_link_person_id($link_person_id);
        if ($data['person_link_info']) {
            $this->profile_model->accept_person_link($data['person_link_info']->person_link_id, $link_person_id);
            $person_id = $this->session->userdata('user_id');
            //.........................save_notification for accept request........................
            $this->notification_dashboard_model->save_accept_profile_request_notification($link_person_id, $person_id,'');
            //.........................end save_notification for accept request........................
            $data['person_link_info'] = $this->profile_model->person_link_info_by_link_person_id($link_person_id);
            $data['person_info'] = $this->profile_model->person_info_by_person_id($link_person_id);
            echo $this->load->view('user/profile_view/profile_action', $data, true);
        } else {
            echo 1;
        }
    }

    public function cancel_person_link_request_from_profile($link_person_id) {
        $data['person_link_info'] = $this->profile_model->person_link_info_by_link_person_id($link_person_id);
        if ($data['person_link_info']) {
            $this->profile_model->cancel_person_link($data['person_link_info']->person_link_id, $link_person_id);
            $data['person_link_info'] = $this->profile_model->person_link_info_by_link_person_id($link_person_id);
            $data['person_info'] = $this->profile_model->person_info_by_person_id($link_person_id);
            echo $this->load->view('user/profile_view/profile_action', $data, true);
        } else {
            echo 1;
        }
    }

    public function block_person_link_from_profile($link_person_id) {
        $data['person_link_info'] = $this->profile_model->person_link_info_by_link_person_id($link_person_id);
        if ($data['person_link_info']) {
            $person_id = $this->session->userdata('user_id');
            if ($person_id == $data['person_link_info']->requested_person_id) {
                $this->profile_model->block_person_link($data['person_link_info']->person_link_id, $data['person_link_info']->requested_person_id, $data['person_link_info']->pl_person_id);
            } else {
                $this->profile_model->block_person_link($data['person_link_info']->person_link_id, $data['person_link_info']->pl_person_id, $data['person_link_info']->requested_person_id);
            }
            $data['person_link_info'] = $this->profile_model->person_link_info_by_link_person_id($link_person_id);
            $data['person_info'] = $this->profile_model->person_info_by_person_id($link_person_id);
            echo $this->load->view('user/profile_view/profile_action', $data, true);
        } else {

            echo 1;
        }
    }

    public function remove_person_link_from_profile($link_person_id) {
        $data['person_link_info'] = $this->profile_model->person_link_info_by_link_person_id($link_person_id);
        if ($data['person_link_info']) {
            $this->profile_model->remove_person_link($data['person_link_info']->person_link_id, $link_person_id);
            echo $this->profile_action_view($link_person_id);
        } else {
            echo 1;
        }
    }

    public function accept_suggested_person_link_request($link_person_id) {
        $data['person_link_info'] = $this->profile_model->person_link_info_by_link_person_id($link_person_id);
        if ($data['person_link_info']) {
            $this->profile_model->accept_person_link($data['person_link_info']->person_link_id, $link_person_id);
            $person_id = $this->session->userdata('user_id');
            //.........................save_notification for accept request........................
            $this->notification_dashboard_model->save_accept_request_notification($link_person_id, $person_id);
            //.........................end save_notification for accept request........................
            $data['person_link_info'] = $this->profile_model->person_link_info_by_link_person_id($link_person_id);
            $data['person_info'] = $this->profile_model->person_info_by_person_id($link_person_id);
            echo '';
        } else {
            echo 1;
        }
    }

    public function cancel_suggested_person_link_request($link_person_id) {
        $data['person_link_info'] = $this->profile_model->person_link_info_by_link_person_id($link_person_id);
        if ($data['person_link_info']) {
            $this->profile_model->cancel_person_link($data['person_link_info']->person_link_id, $link_person_id);
        } else {
            echo 1;
        }
    }

    public function block_link_suggested_person($link_person_id) {
        $data['person_link_info'] = $this->profile_model->person_link_info_by_link_person_id($link_person_id);
        if ($data['person_link_info']) {
            $person_id = $this->session->userdata('user_id');
            if ($person_id == $data['person_link_info']->requested_person_id) {
                $this->profile_model->block_person_link($data['person_link_info']->person_link_id, $data['person_link_info']->requested_person_id, $data['person_link_info']->pl_person_id);
            } else {
                $this->profile_model->block_person_link($data['person_link_info']->person_link_id, $data['person_link_info']->pl_person_id, $data['person_link_info']->requested_person_id);
            }
        } else {
            $gdata['person_id'] = $this->session->userdata('user_id');
            $gdata['requested_person_id'] = $link_person_id;
            $gdata['add_link_request_status'] = 5;
            $gdata['add_link_requested_date_time'] = date("Y-m-d H:i:s", strtotime(gmdate('Y-m-d H:i:s')) - $this->session->userdata('time_offset'));
            $this->profile_model->save_tt_link_information($gdata);
            $this->link_page_suggestion();
        }
    }

    public function block_connectivity_suggested_person($link_person_id) {
        $data['person_link_info'] = $this->profile_model->person_link_info_by_link_person_id($link_person_id);
        if ($data['person_link_info']) {
            $person_id = $this->session->userdata('user_id');
            if ($person_id == $data['person_link_info']->requested_person_id) {
                $this->profile_model->block_person_link($data['person_link_info']->person_link_id, $data['person_link_info']->requested_person_id, $data['person_link_info']->pl_person_id);
            } else {
                $this->profile_model->block_person_link($data['person_link_info']->person_link_id, $data['person_link_info']->pl_person_id, $data['person_link_info']->requested_person_id);
            }
        } else {
            $gdata['person_id'] = $this->session->userdata('user_id');
            $gdata['requested_person_id'] = $link_person_id;
            $gdata['add_link_request_status'] = 5;
            $gdata['add_link_requested_date_time'] = date("Y-m-d H:i:s", strtotime(gmdate('Y-m-d H:i:s')) - $this->session->userdata('time_offset'));
            $this->profile_model->save_tt_link_information($gdata);
            $this->connectivity_page_suggestion();
        }
    }

    /*
      -----------@@@RIPON@ Start Update person profile Image----------------------------------
     */

    /**
     * @Function            : upload_profile_image 
     * @Used IN             : @function-'user/modal_edit_image.php'
     * @Description         : upload profile image 
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 11-06-2016 01:00 PM
     * @Updated By          : Md Mashqur Ul Alam 11-01-17
     * @Parameter           : $profile_url
     * @View                : None
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function upload_profile_image($profile_url) {
        $user_id = $this->map_model->model_person_id_by_url($profile_url);

        //checks image file existance
        $error_data = Array();
        if (!$_FILES['person_image']) {
            $error_data['no_image_file'] = 1;
        } else {
            $error_data['no_image_file'] = '';
        }

        //checks temporary image file name
        $file_tmp_loc = $_FILES["person_image"]["tmp_name"];
        if (!$file_tmp_loc) {
            $error_data['error_file_loc'] = 1;
        } else {
            $error_data['error_file_loc'] = '';
        }

        //checks the file has a valid extension type or not
        $file_name = $_FILES["person_image"]["name"];
        $image_allowance_type = Array('jpeg', 'png', 'bmp', 'jpg');
        $file_explode = explode('.', $file_name);
        $file_extention = $file_explode[count($file_explode) - 1];
        if (!in_array(strtolower($file_extention), $image_allowance_type)) {
            $error_data['error_file_type'] = 1;
        } else {
            $error_data['error_file_type'] = '';
        }

        //checks the image size
        $check_image = getimagesize($file_tmp_loc);
        if (!$check_image) {
            $error_data['error_valid_image'] = 1;
        } else {
            $error_data['error_valid_image'] = '';
        }

        $file_size = $_FILES["person_image"]["size"];
        if ($file_size > 5120000) {
            $error_data['error_image_size'] = 1;
        } else {
            $error_data['error_image_size'] = '';
        }

        //checks that all validation has passed or not
        if (count(array_filter($error_data)) == 0) {
            //saves image and return the image path value
            $error_data['image_path_value'] = $this->save_profile_image($user_id);
            $error_data['image_path'] = base_url() . $error_data['image_path_value'];
//            $image_dimension = $this->profile_model->set_image_height_width($error_data['image_path_value']);
//            $error_data['image_height'] = $image_dimension['image_height'];
//            $error_data['image_width'] = $image_dimension['image_width'];
            $image_dimension = $this->profile_model->resize_image_height_width($error_data['image_path_value']);
            $error_data['image_height'] = $image_dimension['height'];
            $error_data['image_width'] = $image_dimension['width'];
        } else {
            $error_data['image_path'] = 0;
        }
        echo json_encode($error_data);
    }

    /**
     * @Function            : save_profile_image 
     * @Used IN             : @function-'user/profile_view/edit_profile.php' - [81]
     * @Description         : update person image  
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 26-05-2016 06:34 PM
     * @Modified By         : Md. Delwar Hossain
     * @Start DateTime      : 5-06-2017 02:00 PM
     * @Parameter           : $user_id
     * @View                : None
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function save_profile_image($user_id) {
        //$user_id = $this->session->userdata('user_id');
        $user_info = $this->person_model->get_single_person_information_by_person_id($user_id);

        //checks the upload path directory exist or not
        $upload_path = 'content-library/' . $user_info->url . '/my-image/' . 'profile-image' . '/';
        if (!is_dir($upload_path)) {
            mkdir($upload_path, 0777, true);
        }


        //uploads the new file and return data
        $file_data = $this->image_model->upload_file($upload_path, 'jpeg|png|jpg', 2048, 'person_image');

        $this->profile_model->update_profile_image_into_database($user_id, $file_data);


        $image_path = $upload_path . $file_data['file_name'];
        
        $img_extension = substr(strrchr($image_path, '.'), 1);
        if($img_extension == "png"){
            $image = imagecreatefrompng($image_path);
            imagejpeg($image, $image_path, 100);
            imagedestroy($image);
        }
        $image_data = exif_read_data($image_path);
        if ($image_data) {
            if (isset($image_data['Orientation'])) {
                return $this->image_model->check_image_orientation($image_data, $image_path);  // used after uploading in live server
            } else {
                return $image_path;
            }
        } else {
            return $image_path;
        }
    }

    /**
     * @Function            : update_person_previous_image 
     * @Used IN             : @function-'save_profile_image' - this@Controller
     * @Description         : update profile previous Image
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 23-06-2016 09:15 AM
     * @Parameter           : $user_info[ARRAY]
     * @View                : None
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function update_person_previous_image($user_info) {
        if ($user_info->person_image != '') {
            $file_name = explode('/', $user_info->person_image);
            $source = 'content-library/' . $user_info->url . '/my-image/' . $file_name[1];

            if (is_file($source)) {
                if (file_exists($source)) {
                    $image_data['content_library_type_id'] = $user_info->person_id;
                    $image_data['content_library_location'] = 'my-image/profile-image/' . $file_name[1];
                    $image_data['content_library_type'] = 1;
                    $this->db->insert('tbl_content_library', $image_data);

                    $dest = 'content-library/' . $user_info->url . '/my-image/profile-image/' . $file_name[1];
                    copy($source, $dest);
                    unlink($source);
                }
            }
        }

        if ($user_info->person_image_thumb != '') {
            $file_name = explode('/', $user_info->person_image_thumb);
            $source = 'content-library/' . $user_info->url . '/my-image/' . $file_name[1];
            if (is_file($source)) {
                if (file_exists($source)) {
                    unlink($source);
                }
            }
        }
    }

    /**
     * @Function            : update_profile_image 
     * @Used IN             : @function-'user/profile_view/edit_profile.php' - [81]
     * @Description         : update profile Image
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 21-06-2016 08:58 AM
     * @Updated By  `       : Md Mashqur Ul Alam 12-01-17
     * @Parameter           : NULL
     * @View                : None
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function update_profile_image($profile_url) {
        $user_id = $this->map_model->model_person_id_by_url($profile_url);
        $crop_status = $this->input->post('crop_status', TRUE);
        $rotate_degree = $this->input->post('degree', TRUE);

        if ($crop_status == 1) {
            $image_path = $this->resize_profile_image();
        } else {
            $image_path = $this->input->post('image_path', TRUE);
        }

        if ($rotate_degree != 0) {
            $image_path = $this->image_model->rotate_image($image_path, $rotate_degree);
        }

        // Moves image file from my-image directory to profile-image directory if exist and removes thumb image
        $user_info = $this->person_model->get_single_person_information_by_person_id($user_id);
        $this->update_person_previous_image($user_info);

        // Saves new profile image path in database
        $image_path_array = explode('/', $image_path);
        $file_explode = explode('.', $image_path_array[4]);
        $file_name = $file_explode[0];
        $file_extention = $file_explode[count($file_explode) - 1];
        $data['person_image'] = 'my-image/profile-image/' . $file_name . '.' . $file_extention;
        $this->utility_model->update_information_in_database('tbl_person', 'person_id', $user_id, $data);

        $this->update_person_thumbnail_image($user_id, $image_path);
        echo 'success';
    }

    /**
     * @Function            : update_person_thumbnail_image 
     * @Used IN             : @function-'update_profile_image' - this@Controller
     * @Description         : update thumbnail profile Image
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 21-06-2016 11:05 AM
     * @Parameter           : NULL
     * @View                : None
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function update_person_thumbnail_image($user_id, $image_path) {
        $person_info = $this->person_model->get_single_person_information_by_person_id($user_id);

        $existing_thumb_pic = 'content-library/' . $person_info->url . '/' . $person_info->person_image_thumb;
        if (file_exists($existing_thumb_pic)) {
            unlink($existing_thumb_pic);
        }

        $image_path_array = explode('/', $image_path);
        $file_explode = explode('.', $image_path_array[4]);
        $file_name = $file_explode[0];
        $file_extention = $file_explode[count($file_explode) - 1];
        $thumbnail_image_path = 'content-library/' . $person_info->url . '/my-image/profile-image/' . $file_name . '_thumb.' . $file_extention;
        $this->image_model->create_thumbnail_image($thumbnail_image_path, $image_path);

        $data['person_image_thumb'] = 'my-image/profile-image/' . $file_name . '_thumb.' . $file_extention; // update person image
        $this->utility_model->update_information_in_database('tbl_person', 'person_id', $user_id, $data);
    }

    /**
     * @Function            : resize_profile_image 
     * @Used IN             : @function-'user/profile_view/edit_profile.php' - [81]
     * @Description         : resize image
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 12-06-2016 11:27 AM
     * @Parameter           : NULL
     * @View                : None
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function resize_profile_image() {
        $top = round(($this->input->post('top', TRUE) - $this->input->post('image_top', TRUE)));
        $left = round(($this->input->post('left', TRUE) - $this->input->post('image_left', TRUE)));

        $box_width = $this->input->post('box_width', TRUE);
        $box_heigth = $this->input->post('box_heigth', TRUE);
        $image_html_heigth = $this->input->post('imageHeigth', TRUE);
        $image_html_width = $this->input->post('imageWidth', TRUE);
        $image_path = $this->input->post('image_path', TRUE);

        list($image_org_width, $image_org_height) = getimagesize($image_path);

        $calculate_height = $image_org_height / $image_html_heigth;
        $calculate_width = $image_org_width / $image_html_width;

        $cropping_top = $top * $calculate_height;
        $cropping_left = $left * $calculate_width;
        $cropping_width = $box_width * $calculate_width;
        $cropping_height = $box_heigth * $calculate_height;

        return $this->image_model->crop_image($cropping_top, $cropping_left, $cropping_height, $cropping_width, $image_path);
    }
    
    /**
     * @Function            : crop_profile_image 
     * @Used IN             : @function-'user/profile_view/edit_profile.php' - [81]
     * @Description         : Crop image
     * @Developed By        : Md. Delwar Hossain
     * @Start DateTime      : 4-06-2016 11:27 AM
     * @Parameter           : NULL
     * @View                : None
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function crop_profile_image(){
        if($this->input->is_ajax_request()){
            $src = $this->input->post('image_source');
            $person_url = $this->input->post('person_url');
            $data['x'] = $this->input->post('x');
            $data['y'] = $this->input->post('y');
            $data['width'] = $this->input->post('w');
            $data['height'] = $this->input->post('h');
            
            $jpeg_quality = 100;
            $img_r = imagecreatefromjpeg($src);
            $img_crop = imagecrop($img_r, $data);
            
            $file_name = substr(strrchr($src, '/'), 1);
            $folder_path = FCPATH."content-library/".$person_url."/my-image/profile-image/";
            if ($img_crop !== FALSE) {
                imagejpeg($img_crop, $folder_path.$file_name, $jpeg_quality);
            }
            $folder_path = substr($folder_path,21);
            echo base_url().$folder_path.$file_name;
        }
    }

    /**
     * @Function            : view_album_image 
     * @Used IN             : @function-'user/profile_view/edit_profile.php'
     * @Description         : view all album image
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 23-06-2016 01:48 PM
     * @Parameter           : NULL
     * @View                : None
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function view_album_image() {
        $user_id = $this->session->userdata('user_id');
        $image_type = $this->input->post('image_type', TRUE);

        switch ($image_type) {
            case '1': // view profile all picture 
                $person_id = $this->input->post('person_id', TRUE);
                $content_library_type = $this->input->post('content_library_type', TRUE);
                $data['content_result'] = $this->person_model->get_person_content_library_information($person_id, $content_library_type, 1);
                echo json_encode($data['content_result']);
                break;

            case '2': // view profile all post image 
                $data['post_result'] = $this->post_model->select_all_post_value_by_person_id($user_id, 4);
                echo json_encode($data['post_result']);
                break;
        }
    }

    /**
     * @Function            : set_profile_image 
     * @Used IN             : @function-'user/profile_view/edit_profile.php' - [81]
     * @Description         : set existing image as profile image
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 22-06-2016 10:59 AM
     * @Parameter           : NULL
     * @View                : None
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function set_profile_image() {
        $content_library_id = $this->input->post('content_library_id', TRUE);
        $content_library_type = $this->input->post('content_library_type', TRUE);

        switch ($content_library_type) {
            case '1': // set person image as profile image
                $this->set_person_image_as_profile_image($content_library_id);
                break;
            case '2': // set post image as profile image
                $this->set_post_image_as_profile_image($content_library_id);
                break;
        }
    }

    /**
     * @Function            : set_person_image_as_profile_image 
     * @Used IN             : @function-'set_profile_image' -   this[Controller]
     * @Description         : set existing person image as profile image
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 26-06-2016 03:38 PM
     * @Updated By          : Md Mashqur Ul Alam [14-01-17]
     * @Parameter           : $content_library_id[INTEGER]
     * @View                : None
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function set_person_image_as_profile_image($content_library_id) {
        $content_info = $this->person_model->get_person_content_library_information_by_id($content_library_id);

        $data['person_image'] = $content_info->content_library_location;
        // update person image
        $this->utility_model->update_information_in_database('tbl_person', 'person_id', $content_info->person_id, $data);

        $image_path = 'content-library/' . $content_info->url . '/' . $content_info->content_library_location;
        $this->update_person_thumbnail_image($content_info->person_id, $image_path);
    }

    /**
     * @Function            : set_post_image_as_profile_image 
     * @Used IN             : @function-'set_profile_image' -   this[Controller]
     * @Description         : set existing post image as profile image
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 27-06-2016 09:09 AM
     * @Parameter           : $content_library_id[INTEGER]
     * @View                : None
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function set_post_image_as_profile_image($content_library_id) {
        $post_info = $this->post_model->select_post_by_post_id($content_library_id);

        $data['person_image'] = $post_info->post_details; // update person image
        $this->utility_model->update_information_in_database('tbl_person', 'person_id', $post_info->person_id, $data);

        $image_path = 'content-library/' . $post_info->url . '/' . $post_info->post_details;
        $this->update_person_thumbnail_image($post_info->person_id, $image_path);
    }

    /**
     * @Function            : delete_profile_image 
     * @Used IN             : @function-'user/profile_view/modal_edit_profile.php' 
     * @Description         : set existing image as profile image
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 22-06-2016 10:59 AM
     * @Parameter           : NULL
     * @View                : None
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function update_profile_image_status() {
        $content_library_id = $this->input->post('content_library_id', TRUE);
        $data['content_deletion_status'] = $this->input->post('person_content_deletion_status', TRUE);
        $this->utility_model->update_information_in_database('tbl_content_library', 'content_library_id', $content_library_id, $data);
        $data['content_result'] = $this->person_model->get_person_content_library_information($this->session->person_id, 1, 1);
        echo json_encode($data['content_result']);
    }

    /**
     * @Function            : view_image_deshboard 
     * @Used IN             : @function-'user/profile_view/modal_edit_profile.php' 
     * @Description         : view dashboard image
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 27-06-2016 11:45 AM
     * @Parameter           : NULL
     * @View                : None
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function view_image_deshboard() {
        $person_id = $this->session->userdata('user_id');
        $data['person_info'] = $this->person_model->get_single_person_information_by_person_id($person_id);
        $image_data = $this->profile_model->get_person_all_image_data_by_person_id($data);
        echo json_encode($image_data);
    }

    
    /**
     * @Function            : view_post_image_album
     * @Description         : Displays post image gallery in content-library
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 17-04-17
     * @Status              : Available       
     * */
    public function view_post_image_album() {
        $data['active_menu'] = 'dashboard';
        $data['active_sub_menu'] = 'content_library';
        $data['left_side'] = 1;
        $data['left_side_menu_view'] = 1;
        $data['post_images'] = $this->profile_model->get_post_image_album_content();
        $data['main_content'] = $this->load->view('user/profile_view/dashboard/image_album', $data, true);
        $this->load->view('user/master', $data);
    }
    
    
    /**
     * @Function            : view_profile_image_album
     * @Description         : Displays profile image gallery in content-library
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 17-04-17
     * @Status              : Available       
     * */
    
    public function view_profile_image_album() {
        $data['active_menu'] = 'dashboard';
        $data['active_sub_menu'] = 'content_library';
        $data['left_side'] = 1;
        $data['left_side_menu_view'] = 1;
        $data['profile_images'] = $this->profile_model->get_profile_image_album_content();
        $data['main_content'] = $this->load->view('user/profile_view/dashboard/image_album', $data, true);
        $this->load->view('user/master', $data);
    }
    
    /**
     * @Function            : delete_image_album_content
     * @Description         : delete image from profile image gallery
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 18-04-17
     * @Status              : Available       
     * */
    public function delete_image_album_content(){
        if($this->input->is_ajax_request()){
            $content_location = $this->input->post('content_location', TRUE);
            $content_type = trim($this->input->post('content_type', TRUE));            
            $replace_string = base_url().'content-library/'.$this->session->person_url.'/';
            $content_library_location = trim(str_replace($replace_string, '', $content_location));
            if($content_type == 'profile-image-album'){
                $this->profile_model->delete_profile_image_album_content($content_library_location);
                echo 'ok';
            }elseif($content_type == 'post-image-album'){
                $this->profile_model->delete_post_image_album_content($content_library_location);
                echo 'ok';
            } 
        }
        
    }

    /*
      -----------@@@RIPON@ End Update person profile Image----------------------------------
     */

    /**
     * @Function            : update_user_name 
     * @Used IN             :      
     * @Description         : 
     * @developed By        : Unknown
     * @update by           : tania
     * @Update Date         : 08-08-2016
     * @Parameter           : none
     * @Return              : none
     * @Status              : Available        
     * */
    public function update_user_name() {
        $first_name = preg_replace('/[^A-Za-z0-9 -]/', '', $this->input->post('first_name', TRUE));
        $last_name = preg_replace('/[^A-Za-z0-9 -]/', '', $this->input->post('last_name', TRUE));
        $perosn_id = $this->input->post('person_id', TRUE);
        $create_name = $this->create_update_name($first_name, $last_name);
        $check_name = $this->sign_up_model->check_exist_sign_up_forbidden($create_name, 2); //2 means forbidden type is name
        $check_first_name = $this->sign_up_model->check_exist_sign_up_forbidden($first_name, 2); //2 means forbidden type is name
        $check_last_name = $this->sign_up_model->check_exist_sign_up_forbidden($last_name, 2); //2 means forbidden type is name
        if ($check_name) {
            echo "1"; // if person name exist in forbidden table
        } else if ($check_first_name) {
            echo "1"; // if person name exist in forbidden table 
        } else if ($check_last_name) {
            echo "1"; // if person name exist in forbidden table  
        } else {
            echo "2"; // if person name not exist in forbidden            
            $this->profile_model->update_user_name($first_name, $last_name, $perosn_id);
            $person_info = $this->profile_model->user_info_by_id($perosn_id);
            $sdata['user_name'] = $person_info->person_first_name . ' ' . $person_info->person_last_name;
            $sdata['person_first_name'] = $person_info->person_first_name;
            $this->session->set_userdata($sdata);
        }
    }

    /**
     * @Function            : create_update_name 
     * @Used IN             : function[update_user_name] controller[profile]   
     * @Description         : used to create name by first name and last name 
     * @developed By        : Tania
     * @Update Date         : 08-08-2016
     * @Parameter           : none
     * @Return              : none
     * @Status              : Available        
     * */
    function create_update_name($person_first_name, $person_last_name) {
        $first_name = str_replace(' ', '', $person_first_name);
        $create_name = preg_replace('/[^A-Za-z0-9 -]/', '', $person_first_name);
        $last_name = preg_replace('/[^A-Za-z0-9 -]/', '', $person_last_name);
        if ($last_name) {
            $create_name = $first_name . ' ' . $last_name;
        }
        return $create_name;        //person name
    }

    public function update_selected_education_Information($personID, $userEducationID, $attended_date, $finished_date, $education_description, $attended_for, $education_view_type) {
        $education_description = str_replace("%20", " ", $education_description);
        $this->profile_model->update_selected_education_Information($personID, $userEducationID, $attended_date, $finished_date, $education_description, $attended_for, $education_view_type);
    }

    public function update_person_url($url_id, $url, $old_url) {
        $user_id = $this->session->userdata('user_id');
        //echo $this->url_model->update_person_url($user_id, $url_id, $url, $old_url);
    }

    /*
     * @Function            : search_company_name 
     * @Used IN             : @function 'companyNameSuggestion' - [edit_profile.js]
     * @Description         : Suggests company name from database based on users 
     *                      input in the company name field in workexperience section
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 02-01-2017 03:50 PM  
     * @Parameter           : NULL
     * @View                : None
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available       
     */

    public function search_company_name() {
        $search_key = $this->input->post('search_key', true);
        $result = $this->profile_model->search_company_name_model($search_key);
        echo json_encode($result);
    }

    public function edit_work_experience($id) {
        $data['work_value'] = $this->profile_model->select_user_work_experience_detail_by_id($id);
        echo $this->load->view('user/profile_view/ajax_view/edit_work_action', $data, TRUE);
    }

    public function update_work_experience($person_work_detail_id) {
        $this->profile_model->update_work_experience_information($person_work_detail_id);
        $data['p_value'] = $this->profile_model->select_user_work_experience_detail_by_id($person_work_detail_id);
        echo $this->load->view('user/profile_view/ajax_view/view_work_single_action', $data, TRUE);
    }

    public function cancel_update_work_experience($person_work_detail_id) {
        $data['p_value'] = $this->profile_model->select_user_work_experience_detail_by_id($person_work_detail_id);
        echo $this->load->view('user/profile_view/ajax_view/view_work_single_action', $data, TRUE);
    }

    /*
     * @Function            : delete_work_experience 
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 11-04-2017 
     * @Status              : Available       
     */
    public function delete_work_experience() {
        if ($this->input->is_ajax_request()) {
            $work_id = $this->input->post('work_detail_id', TRUE);
            $this->profile_model->delete_work_experience($work_id);
        }else{
            redirect();
        }
    }

    public function update_person_interest_field_Information($perosnID, $interest_item) {
        $interest_item1 = str_replace("%20", " ", $interest_item);
        $interest_item2 = str_replace(',', " ", $interest_item1);
        $this->profile_model->update_person_interest_field_Information($perosnID, $interest_item2);
    }

    public function update_person_assessment_skill_Information($perosnID, $assessment_skill) {
        $assessment_skill1 = str_replace("%20", " ", $assessment_skill);
        $assessment_skill2 = str_replace(',', " ", $assessment_skill1);
        $this->profile_model->update_person_assessment_skill_Information($perosnID, $assessment_skill2);
    }

    public function update_person_company_name($CompanyName, $perosnID) {

        $CompanyName = str_replace("%20", " ", $CompanyName);

        $this->profile_model->update_company_name($CompanyName, $perosnID);
        echo $CompanyName;
    }

    public function update_person_Higher_EducationName($Higher_EducationName, $personHigher_Education_Institute_id, $perosnID) {

        $Higher_EducationName = str_replace("%20", " ", $Higher_EducationName);

        $this->profile_model->update_Higher_EducationName($Higher_EducationName, $personHigher_Education_Institute_id, $perosnID);
        echo $Higher_EducationName;
    }

    public function update_person_Designation_Name($person_designation, $person_work_details_id, $perosnID) {

        $person_designation = str_replace("%20", " ", $person_designation);

        $this->profile_model->update_person_Designation_Name($person_designation, $person_work_details_id, $perosnID);
        echo $person_designation;
    }

    public function update_person_Company_title($person_Company_title, $person_work_details_id, $perosnID) {

        $person_Company_title = str_replace("%20", " ", $person_Company_title);

        $this->profile_model->update_person_Company_title($person_Company_title, $person_work_details_id, $perosnID);
        echo $person_Company_title;
    }

    public function update_person_job_responsibility($job_responsibility, $person_work_details_id, $perosnID) {

        $job_responsibility = str_replace("%20", " ", $job_responsibility);

        $this->profile_model->update_person_job_responsibility($job_responsibility, $person_work_details_id, $perosnID);
        echo $job_responsibility;
    }

    public function update_user_Company_Address($Person_Company_Address, $person_work_details_id, $perosnID) {

        $Person_Company_Address = str_replace("%20", " ", $PersonCompanyAddress);

        $this->profile_model->update_person_Company_Address($Person_Company_Address, $person_work_details_id, $perosnID);
        echo $Person_Company_Address;
    }

    public function add_new_work_Information($personID, $user_new_company_name, $user_new_designation, $user_new_address, $user_new_responsibility, $user_new_job_start_date, $user_new_job_end_date, $new_work_current_here, $person_new_work_view_status) {

        $user_new_company_name = str_replace("%20", " ", $user_new_company_name);
        $user_new_designation = str_replace("%20", " ", $user_new_designation);
        $user_new_address = str_replace("%20", " ", $user_new_address);
        $user_new_responsibility = str_replace("%20", " ", $user_new_responsibility);

        $data['user_work_details'] = $this->profile_model->add_new_work_Information($personID, $user_new_company_name, $user_new_designation, $user_new_address, $user_new_responsibility, $user_new_job_start_date, $user_new_job_end_date, $new_work_current_here, $person_new_work_view_status);
        echo $this->load->view('user/profile_view/view_work_experience_ajax_page', $data, TRUE);
    }

    public function update_person_workDetails($personID, $person_work_id, $user_company_name, $user_designation, $user_address, $user_responsibility, $user_job_start_date, $user_job_end_date, $work_current_here, $account_type) {

        $user_company_name = str_replace("%20", " ", $user_company_name);
        $user_designation = str_replace("%20", " ", $user_designation);
        $user_address = str_replace("%20", " ", $user_address);
        $user_responsibility = str_replace("%20", " ", $user_responsibility);

        $this->profile_model->update_person_work_experience($personID, $person_work_id, $user_company_name, $user_designation, $user_address, $user_responsibility, $user_job_start_date, $user_job_end_date, $work_current_here, $account_type);
        $data = array();
        $data['user_company_name'] = $user_company_name;
        $data['Person_Company_Address'] = $Person_Company_Address;
        $data['user_address'] = $user_address;
        $data['user_responsibility'] = $user_responsibility;
        $data['user_job_start_date'] = $user_job_start_date;
        $data['user_job_end_date'] = $user_job_end_date;
        $data['work_current_here'] = $work_current_here;
        $data['account_type'] = $account_type;

        echo $data;
    }

    public function update_personal_Information($personID, $person_join_tt_date, $personal_contact, $person_country_name, $personal_address, $person_city_name, $person_birthday_date) {

        $personal_contact = str_replace("%20", " ", $personal_contact);
        $person_country_name = str_replace("%20", " ", $person_country_name);
        $personal_address = str_replace("%20", " ", $personal_address);
        $person_city_name = str_replace("%20", " ", $person_city_name);
        $person_join_tt_date = str_replace("%20", " ", $person_join_tt_date);
        $person_birthday_date = str_replace("%20", " ", $person_birthday_date);

        $this->profile_model->update_personal_Information($personID, $person_join_tt_date, $personal_contact, $person_country_name, $personal_address, $person_city_name, $person_birthday_date);
    }

    public function update_person_name() {

        $data = array();
        $this->load->helper(array('form', 'url'));
        $this->load->library('form_validation');

        $this->form_validation->set_rules('person_first_name', 'person first name ', 'trim|required|max_length[50]|min_length[1]');
        $this->form_validation->set_rules('person_last_name', 'person last name', 'trim|required|max_length[50]|min_length[1]');

        if ($this->form_validation->run() == FALSE) {
            $sdata = array();
            $sdata['error_msg'] = form_error('person_first_name');
            $sdata['error_msg2'] = form_error('person_last_name');
            $this->session->set_userdata($sdata);
            redirect('profile/profile_setting');
        } else {
            $person_id = $this->session->userdata('user_id');
            $person_first_name = $this->input->post('person_first_name', TRUE);
            $person_last_name = $this->input->post('person_last_name', TRUE);
            $this->profile_model->update_person_name_save($person_first_name, $person_last_name, $person_id);
            redirect('profile/profile_setting');
        }
    }

    public function update_person_email() {

        $data = array();
        $this->load->helper(array('form', 'url'));
        $this->load->library('form_validation');

        $this->form_validation->set_rules('person_email', 'person email', 'trim|required|max_length[50]|valid_email');

        if ($this->form_validation->run() == FALSE) {
            $sdata = array();
            $sdata['error_msg'] = form_error('person_email');
            $this->session->set_userdata($sdata);
            redirect('profile/profile_setting');
        } else {
            $person_id = $this->session->userdata('user_id');
            $person_email = $this->input->post('person_email', TRUE);
            $this->profile_model->update_person_email_save($person_email, $person_id);
            redirect('profile/profile_setting');
        }
    }

    public function update_person_contact() {
        $data = array();
        $this->load->helper(array('form', 'url'));
        $this->load->library('form_validation');

        $this->form_validation->set_rules('person_contact_number', 'Contact Number', 'trim|required|integer|max_length[15]|min_length[11]');

        if ($this->form_validation->run() == FALSE) {
            $sdata = array();
            $sdata['error_msg'] = form_error('person_contact_number');
            $this->session->set_userdata($sdata);
            redirect('profile/profile_setting');
        } else {
            $person_id = $this->session->userdata('user_id');
            $person_contact_number = $this->input->post('person_contact_number', TRUE);
            $this->profile_model->update_person_contact_save($person_contact_number, $person_id);
            redirect('profile/profile_setting');
        }
    }

    public function update_person_address() {

        $data = array();
        $this->load->helper(array('form', 'url'));
        $this->load->library('form_validation');
        $this->form_validation->set_rules('person_address', 'person address', 'trim|max_length[256]');

        if ($this->form_validation->run() == FALSE) {
            $sdata = array();
            $sdata['error_msg'] = form_error('person_address');
            $this->session->set_userdata($sdata);
            redirect('profile/profile_setting');
        } else {
            $person_id = $this->session->userdata('user_id');
            $person_address = $this->input->post('person_address', TRUE);
            $this->profile_model->update_person_address_save($person_address, $person_id);
            redirect('profile/profile_setting');
        }
    }

    public function update_person_zip() {

        $data = array();
        $this->load->helper(array('form', 'url'));
        $this->load->library('form_validation');
        $this->form_validation->set_rules('person_zip', 'person Zip', 'trim|max_length[5]|min_length[4]');

        if ($this->form_validation->run() == FALSE) {
            $sdata = array();
            $sdata['error_msg'] = form_error('person_zip');
            $this->session->set_userdata($sdata);
            redirect('profile/profile_setting');
        } else {
            $person_id = $this->session->userdata('user_id');
            $person_zip = $this->input->post('person_zip', TRUE);
            $this->profile_model->update_person_zip_save($person_zip, $person_id);
            redirect('profile/profile_setting');
        }
    }

//    ===================Add Education Page view function Start=========================

    /*
     * @Function            : add_education_form 
     * @Used IN             : @function- addEducationForm [edit_profile.js]
     * @Description         : loads the view for add education form in profile
     * @Developed By        : Unknown     
     * @Parameter           : $person_id
     * @Comment Added by    : Md Mashqur Ul Alam
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available
     */
    public function add_education_form($person_id) {
        $data['person_id'] = $person_id;
        echo $this->load->view('user/profile_view/ajax_view/add_education_action', $data, TRUE);
    }

    /*
     * @Function            : add_education 
     * @Used IN             : @function- addNewEducation [edit_profile.js]
     * @Description         : Saves a new education detail for user's profile
     * @Developed By        : Unknown     
     * @Parameter           : $person_id
     * @Comment Added by    : Md Mashqur Ul Alam
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available
     */

    public function add_education($person_id) {
        $this->profile_model->save_education_information($person_id);
        $data['user_education_details'] = $this->profile_model->select_limited_user_education_details($person_id, 0);
        echo $this->load->view('user/profile_view/ajax_view/view_education_details_action', $data, TRUE);
    }

    public function edit_education_form($education_details_id) {
        $data['edication_details'] = $this->profile_model->Selected_education_Information($education_details_id);
        echo $this->load->view('user/profile_view/ajax_view/edit_education_form', $data, TRUE);
    }

    public function update_education($education_details_id) {
        $this->profile_model->update_education_information($education_details_id);
        $person_id = $this->profile_model->get_perrson_id($education_details_id);
        $data['user_education_details'] = $this->profile_model->select_limited_user_education_details($person_id->person_id, 0);
        echo $this->load->view('user/profile_view/ajax_view/view_education_details_action', $data, TRUE);
    }

    public function cancel_update_education($education_details_id) {
        $person_id = $this->profile_model->get_perrson_id($education_details_id);
        $data['user_education_details'] = $this->profile_model->select_user_education_details($person_id->person_id);
        echo $this->load->view('user/profile_view/ajax_view/view_education_details_action', $data, TRUE);
    }

    public function remove_selected_education($person_education_details_id) {
        $this->profile_model->remove_selected_education_info($person_education_details_id);
        redirect('profile/profile_setting');
    }

    public function remove_selected_work($person_work_details_id) {
        $this->profile_model->remove_selected_work_info($person_work_details_id);
        redirect('profile/profile_setting');
    }

    public function remove_selected_interest($field_of_interest_id) {
        $this->profile_model->remove_selected_interest_info($field_of_interest_id);
        redirect('profile/profile_setting');
    }

    public function update_interest_field_info() {

        $data = array();
        $this->load->helper(array('form', 'url'));
        $this->load->library('form_validation');

        $this->form_validation->set_rules('field_of_interest_name', 'field_of_interest_name ', 'trim|required|max_length[200]|min_length[1]');


        if ($this->form_validation->run() == FALSE) {
            $sdata = array();
            $sdata['error_msg3'] = form_error('field_of_interest_name');
            $this->session->set_userdata($sdata);
            redirect('profile/profile_setting');
        } else {
            $field_of_interest_id = $this->input->post('field_of_interest_id', TRUE);
            $field_of_interest_name = $this->input->post('field_of_interest_name', TRUE);
            $this->profile_model->save_update_interest_field_info($field_of_interest_id, $field_of_interest_name);
            redirect('profile/profile_setting');
        }
    }

    public function update_education_info() {

        $data = array();
        $this->load->helper(array('form', 'url'));
        $this->load->library('form_validation');

        $this->form_validation->set_rules('education_institution_name', 'education institution name ', 'trim|required|max_length[50]|min_length[1]');
        $this->form_validation->set_rules('educational_description', 'educational description', 'trim|required|max_length[50]|min_length[1]');

        if ($this->form_validation->run() == FALSE) {
            $sdata = array();
            $sdata['error_msg3'] = form_error('education_institution_name');
            $sdata['error_msg4'] = form_error('educational_description');
            $this->session->set_userdata($sdata);
            redirect('profile/profile_setting');
        } else {
            $education_school_id = $this->input->post('education_id', TRUE);
            $education_institution_name = $this->input->post('education_institution_name', TRUE);
            $educational_description = $this->input->post('educational_description', TRUE);
            $this->profile_model->update_education_info_save($education_institution_name, $educational_description, $education_school_id);
            redirect('profile/profile_setting');
        }
    }

    public function update_work_info() {

        $data = array();
        $this->load->helper(array('form', 'url'));
        $this->load->library('form_validation');

        $this->form_validation->set_rules('company_name', 'Company name ', 'trim|required|max_length[100]|min_length[1]');
        $this->form_validation->set_rules('designation', 'Designation ', 'trim|required|max_length[50]|min_length[1]');
        $this->form_validation->set_rules('company_address', 'company address ', 'trim|required|max_length[100]|min_length[1]');
        $this->form_validation->set_rules('work_here', 'work currently here ', 'trim|required');

        if ($this->form_validation->run() == FALSE) {
            $sdata = array();
            $sdata['error_msg3'] = form_error('company_name');
            $sdata['error_msg4'] = form_error('designation');
            $sdata['error_msg5'] = form_error('company_address');
            $sdata['error_msg6'] = form_error('work_currently_here');
            $this->session->set_userdata($sdata);
            redirect('profile/profile_setting');
        } else {
            $person_work_details_id = $this->input->post('pass_work_id', TRUE);
            $company_name = $this->input->post('company_name', TRUE);
            $designation = $this->input->post('designation', TRUE);
            $company_address = $this->input->post('company_address', TRUE);
            $work_currently_here = $this->input->post('work_here', TRUE);

            $this->profile_model->update_work_info_save($person_work_details_id, $company_name, $designation, $company_address, $work_currently_here);
            redirect('profile/profile_setting');
        }
    }

    public function update_education_status($person_education_details_id, $status_id) {

        $this->profile_model->update_education_status_info($person_education_details_id, $status_id);
        redirect('profile/profile_setting');
    }

    public function update_work_see_status($person_work_details_id, $status_id) {

        $this->profile_model->update_work_see_status_info($person_work_details_id, $status_id);
        redirect('profile/profile_setting');
    }

//======================== user work experience Area Start ========================================================  

    public function add_work_exprience_form($person_id) {
        $data['person_id'] = $person_id;
        echo $this->load->view('user/profile_view/ajax_view/add_work_experience', $data, TRUE);
    }

    public function add_work_experience($person_id) { 
       
        $this->profile_model->add_work_information($person_id);
        $page_number = 1;
        $data['person_info'] = $this->profile_model->user_info_by_id($person_id);
        $limit = 0;            
        $data['user_work_details'] = $this->profile_model->select_user_limit_work_details($person_id, $limit);
        $work_detail_count_list = count($this->profile_model->select_user_work_details($person_id));
        $params = array('url' => '', 'div_id' => 'new_work_experience_pagination', 'total_row' => $work_detail_count_list, 'per_page' => 10, 'current_page' => $page_number, 'total_link' => 10);
        $data['new_work_experience_pagination_link'] = $this->tt_pagination->view_pagination_link($params);
        echo $this->load->view('user/profile_view/ajax_view/view_work_experience', $data, TRUE);
    }
    
    public function add_work_experience_ajax_view(){
        if ($this->input->is_ajax_request()) {
            $page_number = $this->input->post('current_page', TRUE);
            $profile_url = $this->input->post('profile_url', TRUE);
            $data['person_info'] = $this->person_model->get_single_person_information_by_person_url($profile_url);                 
            $data['person_info'] = $this->profile_model->user_info_by_id($data['person_info']->person_id);
           
            $limit_offset = ($page_number*10)-10;
             
            $data['user_work_details'] = $this->profile_model->select_user_limit_work_details($data['person_info']->person_id, $limit_offset);
            $work_detail_count_list = count($this->profile_model->select_user_work_details($data['person_info']->person_id));
            $params = array('url' => '', 'div_id' => 'new_work_experience_pagination', 'total_row' => $work_detail_count_list, 'per_page' => 10, 'current_page' => $page_number, 'total_link' => 10);
            $data['new_work_experience_pagination_link'] = $this->tt_pagination->view_pagination_link($params);
            echo $this->load->view('user/profile_view/ajax_view/view_work_experience', $data, TRUE);
        }
    }

    // user work experience info save function end=====================================


    public function post() {
        date_default_timezone_set('Asia/Dhaka');
        $date_time = date("Y-m-d H:i:s", strtotime(gmdate('Y-m-d H:i:s')) - $this->session->userdata('time_offset'));
        $data = array();
        $post_type = $this->input->post('post_type', TRUE);
        $data['post_details'] = $this->input->post('post_details', TRUE);
        $data['posted_by'] = $this->session->userdata('user_id');
        $data['post_date_time'] = $date_time;

//==========================post for pubulic==========================

        if ($post_type == 'public') {

            $data['post_type'] = '1'; // post type 1 for Public......
            $this->profile_model->post_save($data);
        }

//==============================post for My Link =============================================
        elseif ($post_type == 'my_link') {
            $data['post_type'] = '3';     // post type 3 for my Link......
            $this->profile_model->post_save($data);
        }
//==============================post for Group====================
        elseif ($post_type == 'group') {
            $data['post_type'] = '2'; // post type 1 for Public......
            $post_id = $this->profile_model->post_save($data);
            $groups = $this->input->post('group', TRUE);
            $total = count($groups);
            for ($i = 0; $i < $total; $i++) {
                $mdata['group_id'] = $groups[$i];
                $mdata['post_id'] = $post_id;
                $this->profile_model->selected_group_post_save($mdata);
            }
        }


        redirect('profile');
    }

    public function search_person_group_availability() {
        $data = array();
        $person_id = $this->session->userdata('user_id');
        $result = $this->profile_model->search_person_group_availability($person_id);
        if ($result) {
            echo '1';
        } else {
            echo '2';
        }
    }

    public function group_view($group_id = NULL) {
        $data = array();
        $person_id = $this->session->userdata('user_id');
        $data['login_person_details'] = $this->back_end_model->login_person_details($person_id);
        $data['group_id'] = $group_id;
        $data['group_details'] = $this->back_end_model->group_info($group_id);
        $data['main_content'] = $this->load->view('admin/group_view_page', $data, true);
        $this->load->view('admin/back_end_master_page', $data);
    }

//====================== This function for selectd person Information  ==========================================

    public function select_view_user($person_id = NULL) {
        $data = array();
        $data['select_view_user'] = $this->back_end_model->select_view_user_info($person_id);
        $data['main_content'] = $this->load->view('admin/select_view_user_page', $data, true);
        $this->load->view('admin/back_end_master_page', $data);
    }

    //====================== This function for Join Member ==========================================


    public function join_member($group_id = NULL, $person_id = NULL) {

        $result = $this->back_end_model->check_member_requst($person_id, $group_id);
        $data = array();
        if (!$result) {
            $data['person_id'] = $person_id;
            $data['group_id'] = $group_id;
            $data['group_member_status'] = 1;
            $this->back_end_model->save_group_member_information($data);
            $sdata = array();
            $sdata['message'] = 'User Add Successfully !';
            $this->session->set_userdata($sdata);
            redirect('back_end/group_view/' . $group_id);
        } elseif ($result && $result->group_member_status == 3) {
            $sdata = array();
            $sdata['message'] = 'already Request';
            $this->session->set_userdata($sdata);
            redirect('back_end/group_view/' . $group_id);
        } elseif ($result && $result->group_member_status == 1) {
            $sdata = array();
            $sdata['message'] = 'already member';
            $this->session->set_userdata($sdata);
            redirect('back_end/group_view/' . $group_id);
        }
    }

    public function edit_group($group_id = NULL) {
        $data = array();
        $data['group_details'] = $this->group_model->group_info($group_id);

        $data['group_type'] = $this->group_model->group_type_list();
        $data['main_content'] = $this->load->view('f_end/edit_group_page', $data, true);
        $this->load->view('f_end/f_end_master', $data);
    }

    public function active_group($group_id = NULL) {
        $this->group_model->selected_group_active($group_id);
        redirect('profile/student_group');
    }

    public function inactive_group($group_id = NULL) {
        $this->group_model->selected_group_inactive($group_id);
        redirect('profile/student_group');
    }

    public function save_group_member($person_id, $group_id) {

        $user_id = $this->session->userdata('user_id');
        $data = array();
        $data['person_id'] = $person_id;
        $data['group_id'] = $group_id;
        $data['group_member_status'] = 1;
        $data['group_join_date_time'] = date("Y-m-d H:i:s", strtotime(gmdate('Y-m-d H:i:s')) - $this->session->userdata('time_offset'));
        $data['member_added_by'] = $user_id;
        $data['member_approve_by'] = $user_id;
        $this->group_model->save_group_member_information($data);
        $sdata = array();
        $sdata['message'] = 'Group Member Successfully Added...';
        $this->session->set_userdata($sdata);
        redirect('profile/add_group_member/' . $group_id);
    }

    public function save_grade() {
        $this->load->library('form_validation');
        $this->form_validation->set_rules('grade_name', 'Grade name', 'required|trim|max_length[2]');
        $this->form_validation->set_rules('quiz_id', 'Quiz ', 'required|min_length[1]');
        $this->form_validation->set_rules('grade_number', 'Grade Number ', 'required|min_length[1]');
        $this->form_validation->set_rules('grade_total_number', 'grade total number', 'required');
        $group_id = $this->input->post('group_id', true);

        if ($this->form_validation->run() == FALSE) {
            $this->load->library('form_validation');
            redirect('profile/add_grade/' . $group_id);
        } else {

            $person_id = $this->session->userdata('user_id');

            $data = array();
            $data['quiz_id'] = $this->input->post('quiz_id', true);
            $data['resource_person_id'] = $person_id;
            $data['grade_name'] = $this->input->post('grade_name', true);
            $data['grade_number'] = $this->input->post('grade_number', true);
            $data['grade_total_number'] = $this->input->post('grade_total_number', true);
            $data['grade_status'] = 1;
            $this->profile_model->save_grade_info($data);

            $sdata = array();
            $sdata['message'] = 'Grad successfully added...';
            $this->session->set_userdata($sdata);

            redirect('profile/add_grade/' . $group_id);
        }
    }

    public function active_grade($grade_id, $group_id) {

        $this->profile_model->selected_grade_active($grade_id);
        redirect('profile/manage_grade/' . $group_id);
    }

    public function inactive_grade($grade_id, $group_id) {

        $this->profile_model->selected_grade_inactive($grade_id);
        redirect('profile/manage_grade/' . $group_id);
    }

    public function update_grade() {
        $this->load->library('form_validation');
        $this->form_validation->set_rules('grade_name', 'Grade name', 'required|trim|max_length[50]');
        $this->form_validation->set_rules('quiz_id', 'Quiz ', 'required|min_length[1]');
        $this->form_validation->set_rules('grade_number', 'Grade Number ', 'required|min_length[1]');
        $this->form_validation->set_rules('grade_total_number', 'grade total number', 'required');
        $group_id = $this->input->post('group_id', true);
        $grade_id = $this->input->post('grade_id', true);

        if ($this->form_validation->run() == FALSE) {
            $this->load->library('form_validation');
            redirect('profile/edit_grade/' . $grade_id . '/' . $group_id);
        } else {

            $person_id = $this->session->userdata('user_id');
            $data = array();
            $data['quiz_id'] = $this->input->post('quiz_id', true);
            $data['resource_person_id'] = $person_id;
            $data['grade_name'] = $this->input->post('grade_name', true);
            $data['grade_number'] = $this->input->post('grade_number', true);
            $data['grade_total_number'] = $this->input->post('grade_total_number', true);
            $this->profile_model->update_grade_info($data, $grade_id);
            $sdata = array();
            $sdata['message'] = 'Grade successfully added...';
            $this->session->set_userdata($sdata);
            redirect('profile/manage_grade/' . $group_id);
        }
    }

    public function save_credit_card_payment($payment_id, $card_month_value, $card_type_value, $card_year_value, $card_number_value, $total_price, $card_number_cvv) {

        $card_type = $card_type_value;
        if ($card_type) {
            if ($card_type == 'Master') {
                $credit_card_type = 2;
            }
            if ($card_type == 'Visa') {
                $credit_card_type = 3;
            }
            $month = $card_month_value;
            $year = $card_year_value;
            $credit_card_expiry_date = $year . '-' . $month . '-' . '01';
            date_default_timezone_set('Asia/Dhaka');
            $date_time = date("Y/m/d");
            $data['paid_on'] = $date_time;


            $data['payment_status'] = 1;
            $data['payment_method'] = 2;
            $data['paid_amount'] = $total_price;

            $data['credit_card_type'] = $credit_card_type;
            $data['credit_card_number'] = $card_number_value;
            $data['credit_card_expiry_date'] = $credit_card_expiry_date;
            $data['credit_card_verification_number'] = $card_number_cvv;
            $this->profile_model->update_due_payment($payment_details_information_id, $data);
            echo '1';
        } else {
            echo '2';
        }
    }

    public function save_account_payment($payment_id, $payment_details_information_id, $account_number, $payment_amount) {

        $sql = "SELECT * "
                . " FROM tbl_student as s, tbl_course as c "
                . " WHERE "
                . "     s.payment_id = $payment_id"
                . "     AND c.course_id = s.course_id";
        $result = $this->db->query($sql)->row();
        if ($payment_amount < ($result->course_price / 2)) {
            echo 1;
            return;
        }

        $date_time = date("Y/m/d");
        $data['paid_on'] = $date_time;
        if ($payment_amount < $result->course_price) {
            $data['payment_status'] = 6;
        } else if ($payment_amount >= $result->course_price) {
            $data['payment_status'] = 1;
        }

        $data['payment_method'] = 3;
        $data['check_payment_receipt_no'] = $account_number;
        $data['paid_amount'] = $payment_amount;
        $this->profile_model->update_due_payment($payment_details_information_id, $data);

        echo 2;
        return;
    }

//update by tania : date-> 08-08-2016
    /**
     * @Function            : check_profile_url_existance 
     * @Used IN             :      
     * @Description         : 
     * @developed By        : Unknown
     * @update by           : tania
     * @Update Date         : 08-08-2016
     * @Parameter           : none
     * @Return              : none
     * @Status              : Available        
     * */
    function check_profile_url_existance($url) {
        $result = $this->profile_model->check_url_existance($url);
        $person_forbidden_exist = $this->sign_up_model->check_exist_sign_up_forbidden($url, 1);  //1 means forbidden type is url
        if ($result) {
            echo 1;
        } else if ($person_forbidden_exist) {
            echo 1;
        } else {
            echo 2;
        }
    }

//tania
    /**
     * @Function            : check_email_existance 
     * @Used IN             :      
     * @Description         : 
     * @developed By        : Unknown
     * @update by           : tania
     * @Update Date         : 08-08-2016
     * @Parameter           : none
     * @Return              : none
     * @Status              : Available        
     * */
    public function check_email_existance($person_id, $url) {
        $result = $this->profile_model->check_email_existance($person_id, $url);
        $email_forbidden_exist = $this->sign_up_model->check_exist_sign_up_forbidden($url, 4);  //4 means forbidden type is email
        if ($result) {
            echo 1;
        } else if ($email_forbidden_exist) {
            echo 1;
        } else {
            echo 2;
        }
    }

    public function person_available_disk_space() {
        $person_id = $this->session->userdata('user_id');
        $person_role = $this->session->userdata('person_role');        
        $today = date('Y-m-d H:i:s', strtotime(gmdate('Y-m-d H:i:s')));

        $data['person_info'] = $this->profile_model->person_info_by_person_id($person_id);
        $person_role = $data['person_info']->person_role;
        $person_disk_space = 0;
        if ($data['person_info']->resource_person_type == 3) {
            $data['org_resource_person'] = $this->user_course_model->select_organization_resource_person_by_org_id($data['person_info']->organization_id);
            foreach ($data['org_resource_person'] as $value) {
                $dir = "content-library/" . $value->url;
                $person_disk_space += $this->profile_model->person_available_disk_space($dir);
            }
        } else {
            $dir = "content-library/" . $data['person_info']->url;
            $person_disk_space = $this->profile_model->person_available_disk_space($dir);
        }


        //START CHECK FEATURE
        $data['last_feature_detail'] = $result = $this->payment_model->select_last_feature_payment_info_by_id($person_id);
        if ($today > $data['last_feature_detail']->feature_price_expire_date) {
            $feature_price_storage = 1;
        }

        $feature_price_id = explode(',', $data['person_info']->feature_price_id);
        $data['virtual_classroom_feature_info'] = $this->classroom_model->select_active_feature_by_feature_id($feature_price_id[0]);
        if ($data['virtual_classroom_feature_info']) {
            $feature_price_storage = $data['virtual_classroom_feature_info']->feature_price_storage;
        } else {
            $feature_price_storage = 1;
        }

        $available_space = ($feature_price_storage * 1024) - ($person_disk_space / 1024 / 1024);
        $available_space = round(($available_space), 2);

        echo $available_space;
    }

    /*
      -----------@@@RIPON@ Start Changed password field Part----------------------------------
     */

    /**

      /**
     * @Function            : validate_current_password 
     * @Used IN             : @function-'edit_profile.js'
     * @Description         : check person current password in database ans also validate some condition
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 29-12-2016 03:50 PM  
     * @Parameter           : NULL
     * @View                : None
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function validate_current_password() {
        $person_id = $this->session->person_id;
        $current_pass = $this->input->post('current_pass', TRUE);
        $result = $this->profile_model->check_person_password($person_id, $current_pass);
        if ($result) {
            echo 1; // if current password matched
        } else {
            echo 2; // if current password not matched
        }
    }

    /**
     * @Function            : update_changed_password 
     * @Used IN             : @function-'updating password' - [edit_profile.js]
     * @Description         : validate and update users password
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 31-12-2016 02:00 PM  
     * @Parameter           : NULL
     * @View                : None
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available
     * */
    public function update_changed_password() {
        $this->form_validation->set_rules('current_pass', 'Current Password', 'required|trim|callback_check_current_password');
        $this->form_validation->set_rules('new_pass', 'New Password', 'required|trim|min_length[6]|max_length[32]|matches[conf_pass]|callback_check_password_strength');
        $this->form_validation->set_rules('conf_pass', 'Confirm Password', 'required|trim|min_length[6]|max_length[32]|matches[new_pass]|callback_check_password_strength');
        if ($this->form_validation->run() == FALSE) {
            echo '<p class="text-danger"> Sorry Password Update Failed! </p>';
        } else {
            $new_pass = $this->input->post('new_pass', true);
            $person_id = $this->session->person_id;
            $this->profile_model->update_password_model($person_id, $new_pass);
            echo '<p class="text-success"> Password Updated Successfully! </p>';
        }
    }

    /**
     * @Function            : check_password_strength 
     * @Used IN             : @function-'update_changed_password'
     * @Description         : call back function for validation
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 31-12-2016 03:40 PM  
     * @Parameter           : $new_pass
     * @View                : None
     * @Redirect            : None
     * @Return              : Boolean    
     * @Status              : Available
     * */
    public function check_password_strength($new_pass) {
        if (preg_match('/[0-9]/', $new_pass) && preg_match('/[a-zA-z]/', $new_pass)) {
            return true;
        } else {
            return false;
        }
    }

    /*
     * @Function            : check_current_password 
     * @Used IN             : @function-'update_changed_password'
     * @Description         : call back function for validation
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 31-12-2016 03:40 PM  
     * @Parameter           : $current_pass
     * @View                : None
     * @Redirect            : None
     * @Return              : Boolean    
     * @Status              : Available
     */

    public function check_current_password($current_pass) {
        $person_id = $this->session->person_id;
        $result = $this->profile_model->check_person_password($person_id, $current_pass);
        if ($result) {
            return true;
        } else {
            return false;
        }
    }

    /*
      -----------@@@RIPON@ End Changed password field Part----------------------------------
     */
}
