<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Post extends TT_user_login {

    public function __construct() {
        parent::__construct();
    }

    /**
     * @Function            : view_all_post 
     * @Used IN             : @function-'user/home.php'
     * @Description         : view more post
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : Unknown
     * @Parameter           : $person_id[INTEGER], $counter[INTEGER]
     * @View                : None
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function view_more_post($person_id, $counter) {
        $counter1 = $counter + 10;
        $this->view_all_post($person_id, $counter1);
    }

    /**
     * @Function            : view_refrash_post 
     * @Used IN             : @function-'user/home.php'
     * @Description         : view more post
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : Unknown
     * @Parameter           : Null
     * @View                : None
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function view_refrash_post() {
        $person_id = $this->session->userdata('person_id');
        $this->view_all_post($person_id, 10);
    }

    /**
     * @Function            : get_last_post_id 
     * @Used IN             : @function-'user/home.php'
     * @Description         : get last post ID
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : Unknown
     * @Parameter           : $post_id[INTEGER]
     * @View                : None
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function get_last_post_id($post_id) {
        $unread_post_id = Array();
        $user_id = $this->session->userdata('user_id');
        $result1 = $this->post_model->get_last_post_id();
        $post_value = $this->post_model->get_post_compared_id($post_id, $result1->post_id);
        if ($post_value) {
            foreach ($post_value as $value) {
                $result = $this->post_model->check_post_status($user_id, $value->post_id);
                if ($result) {
                    $unread_post_id[] = $result;
                }
            }
        }
        echo count($unread_post_id);
    }

    /**
     * @Function            : view_all_post 
     * @Used IN             : @function-'add_note'              this[@controller],
     * @                    : @function-'add_alert'             this[@controller],
     * @                    : @function-'add_assignment'        this[@controller],
     * @                    : @function-'add_photo_or_video'    this[@controller],
     * @                    : @function-'view_refrash_post'     this[@controller],
     * @                    : @function-'view_more_post'        this[@controller]
     * @Description         : view all post value
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : Unknown
     * @Updated Date Time   : 01-06-2016 11:01 AM
     * @Updated By          : MD Jaherul Islam
     * @Parameter           : $person_id[INTEGER], $counter[INTEGER]
     * @View                : user/post_ajax/view_deshboard_content.php
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function view_all_post($person_id, $counter) {
        $user_id = $this->session->userdata('user_id');
        $data['person_info'] = $this->person_model->get_single_person_information_by_person_id($user_id);
        $data['all_post'] = $this->post_model->select_all_post($person_id, $counter);
        $data['total_post'] = $this->post_model->select_total_post($person_id);
        $data['all_link'] = $this->post_model->get_all_linked_person($user_id);
        $result = $this->post_model->get_last_post_id();
        if ($result) {
            $data['last_post_id'] = $result->post_id;
        } else {
            $data['last_post_id'] = '';
        }
        $post_data = $this->post_model->get_all_post_data($data);
        echo $this->load->view('user/post_ajax/view_deshboard_content', $post_data, TRUE);
    }

    //---------------------------------- End Post Note, Alert, File, Image,Vedio-----------------------------   

    /**
     * @Function            : add_note_form 
     * @Used IN             : @function-'user/home.php'
     * @Description         : add note from
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : Unknown
     * @Parameter           : Null
     * @View                : None
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function add_note_form($person_id) {
        $data['person_id'] = $person_id;
        $data['all_approved_group'] = $this->post_model->select_approved_group_by_person_id($person_id);
        echo $this->load->view('user/post_ajax/add_note_form', $data, TRUE);
    }

    /**
     * @Function            : add_note 
     * @Used IN             : @function-'user/home.php'
     * @Description         : save note valus
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : Unknown
     * @Parameter           : Null
     * @View                : None
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function add_note($person_id) {
        $this->post_model->save_note($person_id);
        $this->view_all_post($person_id, 10);
    }

    /**
     * @Function            : update_note 
     * @Used IN             : @function-'user/post_ajax/edit_post_from.php'
     * @Description         : update note
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 07-06-2016 12:30 PM 
     * @Parameter           : Null
     * @View                : None
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function update_note() {
        $post_id = $this->input->post('post_id', TRUE);
        $this->post_model->update_note_details($post_id);
        $data['encrypted_post_id'] = $this->utility_model->encode_id($post_id, '/', 'Tt');
        $data['base_url'] = base_url();
        $data['view_page'] = 'view-content';
        $data['type'] = 1;
        echo json_encode($data);
    }

    /**
     * @Function            : update_alert 
     * @Used IN             : @function-'user/post_ajax/edit_post_from.php'
     * @Description         : update Alert
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 07-06-2016 01:54 PM 
     * @Parameter           : Null
     * @View                : None
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function update_alert() {
        $post_id = $this->input->post('post_id', TRUE);
        $this->post_model->update_note_details($post_id);
        $data['encrypted_post_id'] = $this->utility_model->encode_id($post_id, '/', 'Tt');
        $data['base_url'] = base_url();
        $data['view_page'] = 'view-content';
        $data['type'] = 1;
        echo json_encode($data);
    }

    /**
     * @Function            : add_alert_form 
     * @Used IN             : @function-'user/home.php'
     * @Description         : add alert from
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : Unknown
     * @Parameter           : Null
     * @View                : None
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function add_alert_form($person_id) {
        $data['person_id'] = $person_id;
        $data['all_approved_group'] = $this->post_model->select_approved_group_by_person_id($person_id);
        echo $this->load->view('user/post_ajax/add_alert_form', $data, TRUE);
    }

    /**
     * @Function            : add_alert 
     * @Used IN             : @function-'user/home.php'
     * @Description         : save note
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : Unknown
     * @Parameter           : $person_id[INTEGER]
     * @View                : None
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function add_alert($person_id) {
        $this->post_model->save_alert($person_id);
        $this->view_all_post($person_id, 10);
    }

    /**
     * @Function            : add_assignment_form 
     * @Used IN             : @function-'user/home.php'
     * @Description         : add assignment from
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : Unknown
     * @Parameter           : $person_id[INTEGER]
     * @View                : None
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function add_assignment_form($person_id) {
        $data['person_id'] = $person_id;
        $data['all_approved_group'] = $this->post_model->select_approved_group_by_person_id($person_id);
        echo $this->load->view('user/post_ajax/add_assignment_form', $data, TRUE);
    }

    /**
     * @Function            : upload_assignment_file 
     * @Used IN             : @function-'user/home.php'
     * @Description         : upload assignment
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 25-01-2016
     * @Parameter           : None
     * @View                : None
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function upload_assignment_file() {
        $user_id = $this->session->userdata('user_id');
        $profile_url = $this->post_model->get_profile_url($user_id);
        $uploaded_file_id = $this->input->post('uploaded_file_id', TRUE);

        if ($_FILES["assignment_file"]) {
            $fileName = $_FILES["assignment_file"]["name"]; // The file name
            $fileTmpLoc = $_FILES["assignment_file"]["tmp_name"]; // File in the PHP tmp folder
            $fileSize = $_FILES["assignment_file"]["size"]; // File size in bytes
            $new_file_name = $profile_url->url . '-' . date('h-i-s-a-m-d-Y', time());
            $file_explode = explode('.', $fileName);
            $file_extention = $file_explode[count($file_explode) - 1];
            if (!$fileTmpLoc) { // if file not chosen
                echo "error_location";
            } else {
                if ($fileSize == 0) {
                    echo 'error_size_zero';
                } else if ($fileSize > 52428800) {
                    echo 'error_size';
                } else if ($this->post_model->check_assignment_file_type(strtolower($file_extention)) == 2) {
                    echo 'error_type';
                } else {
                    if ($uploaded_file_id) {
                        $result = $this->post_model->get_single_post_by_post_id($uploaded_file_id);
                        unlink('content-library/' . $profile_url->url . '/' . $result->post_details);
                        $this->post_model->delete_single_post_by_post_id($uploaded_file_id);
                    }

                    $folder = 'content-library/' . $profile_url->url . '/assignment-file/';
                    if(!is_dir($folder)){
                        mkdir($folder,0755);
                    }
                    $target_file = $folder . $fileName;
                    if (move_uploaded_file($fileTmpLoc, $target_file)) {

                        rename("$target_file", "$folder$new_file_name.$file_extention");

                        $data['posted_by'] = $user_id;
                        $data['post_details'] = "assignment-file/$new_file_name.$file_extention";
                        $data['post_date_time'] = date('Y/m/d H:i:s', time());
                        $data['post_file_original_name'] = $fileName;
                        $data['post_type'] = 3;
                        $data['post_status'] = 5;
                        echo $this->post_model->save_upload_file($data);
                    }
                }
            }
        }
    }

    /**
     * @Function            : add_assignment 
     * @Used IN             : @function-'user/home.php'
     * @Description         : save assignment
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 25-01-2016
     * @Parameter           : $person_id[INTEGER]
     * @View                : None
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function add_assignment($person_id) {
        $this->post_model->save_assignment_file();
        $this->view_all_post($person_id, 10);
    }

    /**
     * @Function            : upload_edit_assignment 
     * @Used IN             : @function-'user/home.php'
     * @Description         : upload edit assignment
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 08-06-2016 08:56 AM  
     * @Parameter           : NULL
     * @View                : None
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function upload_edit_assignment() {
        $user_id = $this->session->userdata('user_id');
        $profile_url = $this->person_model->get_profile_url($user_id);
        $post_id = $this->input->post('post_id', TRUE);
        $this->post_model->upload_edit_assignment($post_id, $profile_url);
    }

    /**
     * @Function            : update_assignment 
     * @Used IN             : @function-'user/home.php'
     * @Description         : Update  assignment
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 08-06-2016 10:09 AM  
     * @Parameter           : NULL
     * @View                : None
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function update_post_file_details() {
        $post_id = $this->input->post('post_id', TRUE);
        $this->post_model->update_post_file_details($post_id);
        $data['encrypted_post_id'] = $this->utility_model->encode_id($post_id, '/', 'Tt');
        $data['base_url'] = base_url();
        $data['view_page'] = 'view-content';
        $data['type'] = 2;
        echo json_encode($data);
    }

    /**
     * @Function            : download_assignment_file 
     * @Used IN             : @function-'user/home.php'
     * @Description         : download assignment file
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 25-01-2016
     * @Parameter           : $post_id[INTEGER]
     * @View                : None
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function download_assignment_file($post_id) {
        $result = $this->post_model->get_single_post_by_post_id($post_id);
        $profile = $this->post_model->get_profile_url($result->posted_by);
        $this->load->helper('download');
        $file_name = $result->post_file_original_name;
        $files_url = 'content-library/' . $profile->url . '/' . $result->post_details;
        $data = file_get_contents("$files_url");
        if ($data) {
            force_download($file_name, $data);
        }
    }

    /**
     * @Function            : add_video_form 
     * @Used IN             : @function-'user/home.php'
     * @Description         : add video from
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 29-01-2016
     * @Parameter           : $person_id[INTEGER]
     * @View                : None
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function add_video_form($person_id) {
        $data['person_id'] = $person_id;
        $data['all_approved_group'] = $this->post_model->select_approved_group_by_person_id($person_id);
        echo $this->load->view('user/post_ajax/add_video_form', $data, TRUE);
    }

    /**
     * @Function            : upload_Image_vedio 
     * @Used IN             : @function-'user/home.php'
     * @Description         : upload image video
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : Unknown
     * @Parameter           : NULL
     * @View                : None
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function upload_Image_vedio() {
        if ($_FILES["imagevediofile"]) {
            $fileTmpLoc = $_FILES["imagevediofile"]["tmp_name"]; // File in the PHP tmp folder

            if (!$fileTmpLoc) { // if file not chosen
                echo "error";
            } else {
                $this->post_model->upload_post_image_video_file();
            }
        }
    }

    /**
     * @Function            : add_photo_or_video 
     * @Used IN             : @function-'user/home.php'
     * @Description         : save photo or video
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : Unknown
     * @Parameter           : $person_id[INTEGER]
     * @View                : None
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function add_photo_or_video($person_id) {
        $this->post_model->save_image_or_video_file();
        $this->view_all_post($person_id, 10);
    }

    /**
     * @Function            : upload_edit_image_video 
     * @Used IN             : @function-'user/home.php'
     * @Description         : upload edit image video
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 08-06-2016 10:51 AM  
     * @Parameter           : NULL
     * @View                : None
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available        
     * */
    function upload_edit_image_video() {
        $user_id = $this->session->userdata('user_id');
        $profile_url = $this->person_model->get_profile_url($user_id);
        $post_id = $this->input->post('post_id', TRUE);
        $post_type = $this->input->post('post_type', TRUE);

        if ($_FILES["image_video_file"]) {
            $new_file_name = $profile_url . '-' . date('h-i-s-a-m-d-Y', time());
            $file_name = $_FILES["image_video_file"]["name"]; // The file name
            $file_temp_loc = $_FILES["image_video_file"]["tmp_name"]; // File in the PHP tmp folder
            $file_size = $_FILES["image_video_file"]["size"]; // File size in bytes

            if (!$file_temp_loc) { // if file not chosen
                echo "error_location";
            } else {
                if ($post_type == 4) {
                    $this->post_model->upload_edit_image($post_id, $profile_url, $new_file_name, $file_name, $file_size, $file_temp_loc);
                }
                if ($post_type == 5) {
                    $this->post_model->upload_edit_video($post_id, $profile_url, $new_file_name, $file_name, $file_size, $file_temp_loc);
                }
            }
        }

//        $this->post_model->upload_edit_image_video($post_id, $profile_url);
    }

    /**
     * @Function            : add_photo_or_video 
     * @Used IN             : @function-'user/post_ajax/edit_post_from.php'
     * @Description         : remove post url
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 05-06-2016 05:50 PM
     * @Parameter           : None
     * @View                : None
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function remove_post_url() {
        $post_id = $this->input->post('post_id', TRUE);
        $data['post_status'] = 2;
        $this->utility_model->update_information_in_database('tbl_post', 'post_id', $post_id, $data);
        $post_comment_url_id = $this->input->post('post_comment_url_id', TRUE);
        $this->utility_model->delete_information_in_database('tbl_post_comment_url', 'post_comment_url_id', $post_comment_url_id);
        echo 'success';
    }

    /**
     * @Function            : delete_post 
     * @Description         : Delete post
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 07-10-2016 04:33 PM
     * @Parameter           : None
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function delete_post() {
        $post_id = $this->input->post('post_id', TRUE);
        $data['post_status'] = 4;
        $this->utility_model->update_information_in_database('tbl_post', 'post_id', $post_id, $data);
        $notification_id = $this->notification_model->get_notification_id_list_by_notification_type_id($post_id, 3);

        if ($notification_id != '') {
            $this->utility_model->delete_information_in_database('tbl_notification', 'notification_id', $notification_id);
            $this->utility_model->delete_information_in_database('tbl_notification_type_info', 'notification_id', $notification_id);
        }
    }

//---------------------------------- End Post Note, Alert, File, Image,Vedio-----------------------------   
//
//
//---------------------------Start Like , Comments & Add to Libraary-----------------

    /**
     * @Function            : add_like 
     * @Used IN             : @function-'user/home.php'
     * @Description         : add person like
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : Unknown
     * @Updated Date Time   : 01-06-2016 10:14 AM
     * @Updated By          : MD Jaherul Islam
     * @Parameter           : $post_id[INTEGER], $person_id[INTEGER], $status[INTEGER]
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function add_like($post_id, $person_id, $status) {
        if ($status == 'like') {
            $this->post_model->save_like($post_id, $person_id);
        } elseif ($status == 'dislike') {
            $this->post_model->remove_like($post_id, $person_id);
        }
        $data['post_value'] = $this->post_model->get_post_value_by_post_id($post_id);
        $data['all_link'] = $this->post_model->get_all_linked_person($person_id);
        if ($data['post_value']->post_like_by != '') {
            $data['post_liked_person'] = $this->post_model->get_all_post_liked_person_info($person_id, $data['all_link'], $data['post_value']->post_like_by);
        } else {
            $data['post_liked_person'] = '';
        }
        echo $this->load->view('user/post_ajax/post_like_action', $data, TRUE);
    }

    /**
     * @Function            : add_write_form 
     * @Used IN             : @function-'user/home.php'
     * @Description         : view add post write form
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : Unknown
     * @Parameter           : $post_id[INTEGER], $person_id[INTEGER]
     * @Return              : NULL    
     * @Status              : Available        
     * */
    function add_write_form($post_id, $person_id) {
        $data['post_id'] = $post_id;
        $data['person_id'] = $person_id;
        $data['person_info'] = $this->person_model->get_single_person_information_by_person_id($person_id);
        echo $this->load->view('user/post_ajax/add_write_form', $data, TRUE);
    }

    /**
     * @Function            : save_post_write 
     * @Used IN             : @function-'user/home.php'
     * @Description         : save post wirte and view 
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : Unknown
     * @Updated Date Time   : 02-06-2016 04:24 PM
     * @Updated By          : MD Jaherul Islam
     * @Parameter           : $post_id[INTEGER], $person_id[INTEGER]
     * @View                : None
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function save_post_write($post_id, $person_id) {
        $this->post_model->save_post_write($post_id, $person_id);
        $data = $this->view_comment_details($post_id, $person_id, 3);
        echo $this->load->view('user/post_ajax/view_comments', $data, TRUE);
    }

    /**
     * @Function            : view_comment_details 
     * @Used IN             : @function-'save_post_write'     this[@Model]
     * @Description         : view all comment details  
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 02-06-2016 05:08 PM
     * @Parameter           : $post_id[INTEGER],$person_id[INTEGER], $counter[INTEGER]
     * @View                : user/post_ajax/view_comments.php
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function view_comment_details($post_id, $person_id, $counter) {
        $data['all_link'] = $this->post_model->get_all_linked_person($person_id);
        $data['post_value'] = $this->post_model->select_post_by_post_id($post_id);
        $data['total_comment'] = $this->post_model->get_total_first_comment_by_post_id($post_id);
        $data['post_comment'][$post_id] = $this->post_model->get_post_first_comment_by_post_id($post_id, $counter);
        return $this->post_model->get_all_post_commment_data($data, $person_id, $post_id);
    }

    /**
     * @Function            : view_writes 
     * @Used IN             : @function-'get_course_value'  super_admin_course[@controller],
     * @Description         : get all available course using category ID  
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : Unknown
     * @Parameter           : $post_id[INTEGER], $counter[INTEGER]
     * @View                : user/post_ajax/view_comments.php
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function view_writes($post_id, $counter) {
        $person_id = $this->session->userdata('user_id');
        $data['all_link'] = $this->post_model->get_all_linked_person($person_id);
        $data['post_value'] = $this->post_model->select_post_by_post_id($post_id);
        $data['total_comment'] = $this->post_model->get_total_first_comment_by_post_id($post_id);
        $data['post_comment'][$post_id] = $this->post_model->get_post_first_comment_by_post_id($post_id, $counter + 5);
        $post_data = $this->post_model->get_all_post_commment_data($data, $person_id, $post_id);
        echo $this->load->view('user/post_ajax/view_comments', $post_data, TRUE);
    }

    /**
     * @Function            : add_to_my_library 
     * @Used IN             : @function-'user/home.php'
     * @Description         : add to my library
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : Unknown
     * @Updated Date Time   : 08-06-2016 09:11 AM
     * @Updated By          : MD Jaherul Islam
     * @Parameter           : $post_id[INTEGER], $person_id[INTEGER], $status[INTEGER]
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function add_to_my_library($post_id, $person_id, $status) {
        if ($status == 'add') {
            $this->post_model->add_to_library($post_id, $person_id);
        } elseif ($status == 'remove') {
            $this->post_model->remove_to_library($post_id, $person_id);
        }
        $data['post_value'] = $this->post_model->get_post_value_by_post_id($post_id);
        $data['all_link'] = $this->post_model->get_all_linked_person($person_id);
        if ($data['post_value']->post_like_by != '') {
            $data['post_liked_person'] = $this->post_model->get_all_post_liked_person_info($person_id, $data['all_link'], $data['post_value']->post_like_by);
        } else {
            $data['post_liked_person'] = '';
        }
        echo $this->load->view('user/post_ajax/post_like_action', $data, TRUE);
    }

//---------------------------END Like , Comments & Add to Libraary-----------------
//
//
//
//---------------------------Start Replay Like , Comments-----------------
    /**
     * @Function            : add_comment_like 
     * @Used IN             : @function-'user/home.php'
     * @Description         : add comment like  
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : Unknown
     * @Updated Date Time   : 01-06-2016 04:45 PM
     * @Updated By          : MD Jaherul Islam
     * @Parameter           : $comment_id[INTEGER], $person_id[INTEGER], $status[INTEGER]
     * @View                : user/post_ajax/comment_like_action.php
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function add_comment_like($comment_id, $person_id, $status) {
        if ($status == 'like') {
            $this->post_model->save_comment_like($comment_id, $person_id);
        } elseif ($status == 'dislike') {
            $this->post_model->remove_comment_like($comment_id, $person_id);
        }
        $result = $this->post_model->get_post_id_for_nested_comment($comment_id);
        $data['post_value'] = $this->post_model->select_post_by_post_id($result->post_id);
        $data['comment_value'] = $this->post_model->get_single_post_comment_value($comment_id);
        $data['all_link'] = $this->post_model->get_all_linked_person($person_id);
        if ($data['comment_value']->comment_like_by != '') {
            $data['comment_liked_person'] = $this->post_model->get_all_post_liked_person_info($person_id, $data['all_link'], $data['comment_value']->comment_like_by);
        }
        echo $this->load->view('user/post_ajax/comment_like_action', $data, TRUE);
    }

    /**
     * @Function            : get_course_by_category_id 
     * @Used IN             : @function-'get_course_value'  super_admin_course[@controller],
     * @Description         : delete post comment
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 01-06-2016 12:45 PM
     * @Parameter           : NULL
     * @View                : None
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function delete_post_comment() {
        $post_id = $this->input->post('post_id', TRUE);
        $deleted_id = $this->input->post('deleted_id', TRUE);
        $deleted_id_array = $this->post_model->get_all_child_comment_id($deleted_id);
        $deleted_id_array[] = $deleted_id;
        $post_info = $this->post_model->select_post_by_post_id($post_id);
        $post_comment_count = ($post_info->post_comment_count - count($deleted_id_array));
        if ($post_comment_count < 0) {
            $data['post_comment_count'] = 0;
        } else {
            $data['post_comment_count'] = $post_comment_count;
        }
        $this->utility_model->update_information_in_database('tbl_post', 'post_id', $post_id, $data);

        $comment_url = $this->post_model->select_all_post_url_value_by_post_id(implode(',', $deleted_id_array), 2);
        if ($comment_url) {
            $this->post_model->delete_post_comment_url(implode(',', $deleted_id_array), 2);
        }
        $this->post_model->delete_post_comment(implode(',', $deleted_id_array));
        $this->view_writes($post_id, 0);
    }

    /**
     * @Function            : add_replay_write_form 
     * @Used IN             : @function-'user/home.php'
     * @Description         : view reply write from 
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : Unknown
     * @Updated Date Time   : 02-06-2016 06:15 PM
     * @Updated By          : MD Jaherul Islam
     * @Parameter           : $comment_id[INTEGER], $person_id[INTEGER]
     * @View                : None
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function add_replay_write_form($comment_id, $person_id) {
        $data['comment_id'] = $comment_id;
        $data['person_id'] = $person_id;
        $data['person_info'] = $this->person_model->get_single_person_information_by_person_id($person_id);
        echo $this->load->view('user/post_ajax/add_reply_comment_form', $data, TRUE);
    }

    /**
     * @Function            : save_reply_comment_write 
     * @Used IN             : @function-'user/home.php'
     * @Description         : save reply comment write
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : Unknown
     * @Updated Date Time   : 02-06-2016 06:35 PM
     * @Updated By          : MD Jaherul Islam
     * @Parameter           : $comment_id[INTEGER], $person_id[INTEGER]
     * @View                : None
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function save_reply_comment_write($comment_id, $person_id) {
        $this->post_model->save_reply_comment_write($comment_id, $person_id);
        $result = $this->post_model->get_post_id_for_nested_comment($comment_id);
        $this->view_comment_reply_details($result->post_id, $comment_id, 1);
    }

    /**
     * @Function            : view_more_reply 
     * @Used IN             : @function-'user/home.php'
     * @Description         : view more reply
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : Unknown
     * @Updated Date Time   : 02-06-2016 12:21 PM
     * @Updated By          : MD Jaherul Islam
     * @Parameter           : $comment_id[INTEGER],$status[INTEGER]
     * @View                : user/post_ajax/view_comment_reply.php
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function view_more_reply($comment_id, $counter) {
        $result = $this->post_model->get_post_id_for_nested_comment($comment_id);
        $counter1 = $counter + 3;
        $this->view_comment_reply_details($result->post_id, $comment_id, $counter1);
    }

    /**
     * @Function            : add_comment_reply_like 
     * @Used IN             : @function-'user/home.php'
     * @Description         : save or remove reply comment like
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : Unknown
     * @Updated Date Time   : 02-02-2016 01:38 PM
     * @Updated By          : MD Jaherul Islam
     * @Parameter           : $comment_id[INTEGER], $person_id[INTEGER], $status[INTEGER]
     * @View                : user/post_ajax/view_comment_reply_like.php
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function add_comment_reply_like($comment_id, $person_id, $status) {
        if ($status == 'like') {
            $this->post_model->save_comment_like($comment_id, $person_id);
        } elseif ($status == 'dislike') {
            $this->post_model->remove_comment_like($comment_id, $person_id);
        }
        $result = $this->post_model->get_post_id_for_nested_comment($comment_id);
        $data['post_value'] = $this->post_model->select_post_by_post_id($result->post_id);
        $data['comment_reply_value'] = $this->post_model->get_single_post_comment_value($comment_id);
        $data['all_link'] = $this->post_model->get_all_linked_person($person_id);
        if ($data['comment_reply_value']->comment_like_by != '') {
            $data['reply_liked_person'] = $this->post_model->get_all_post_liked_person_info($person_id, $data['all_link'], $data['comment_reply_value']->comment_like_by);
        }
        echo $this->load->view('user/post_ajax/view_comment_reply_like', $data, TRUE);
    }

    /**
     * @Function            : delete_comment_reply 
     * @Used IN             : @function-'user/home.php'
     * @Description         : deleted coment reply
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 02-06-2016 11:47 AM
     * @Parameter           : NuLL
     * @View                : user/post_ajax/view_comment_reply_like.php
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function delete_comment_reply() {
        $comment_parent_id = $this->input->post('post_id', TRUE);
        $deleted_id = $this->input->post('deleted_id', TRUE);

        $deleted_id_array = $this->post_model->get_all_child_comment_id($deleted_id);
        $deleted_id_array[] = $deleted_id;

        $result = $this->post_model->get_post_id_for_nested_comment($comment_parent_id);
        $post_info = $this->post_model->select_post_by_post_id($result->post_id);
        $post_comment_count = ($post_info->post_comment_count - count($deleted_id_array));
        if ($post_comment_count < 0) {
            $data['post_comment_count'] = 0;
        } else {
            $data['post_comment_count'] = $post_comment_count;
        }
        $this->utility_model->update_information_in_database('tbl_post', 'post_id', $result->post_id, $data);

        $comment_url = $this->post_model->select_all_post_url_value_by_post_id(implode(',', $deleted_id_array), 2);
        if ($comment_url) {
            $this->post_model->delete_post_comment_url(implode(',', $deleted_id_array), 2);
        }
        $this->post_model->delete_post_comment(implode(',', $deleted_id_array));
        $this->view_comment_reply_details($result->post_id, $comment_parent_id, 1);
    }

    /**
     * @Function            : view_comment_reply_details 
     * @Used IN             : @function-'delete_comment_reply'     this[@Controller]
     * @                    : @function-'view_more_reply'          this[@Controller]
     * @Description         : deleted coment reply
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 02-06-2016 01:03 PM
     * @Parameter           : $post_id[INTEGER], $comment_id[INTEGER], $counter[INTEGER]
     * @View                : user/post_ajax/view_comment_reply
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function view_comment_reply_details($post_id, $comment_id, $counter) {
        $person_id = $this->session->userdata('user_id');
        $data['all_link'] = $this->post_model->get_all_linked_person($person_id);
        $data['post_value'] = $this->post_model->select_post_by_post_id($post_id);
        $data['comment_value'] = $this->post_model->get_single_post_comment_value($comment_id);
        $data['total_comment_replay'] = $this->post_model->get_total_comment_by_comment_id($comment_id);
        $data['comment_reply'][$comment_id] = $this->post_model->get_post_comment_replay_limit_post_comment_id($comment_id, $counter);
        $reply_comment_data = $this->post_model->get_all_post_reply_commment_data($data, $person_id, $comment_id);
        echo $this->load->view('user/post_ajax/view_comment_reply', $reply_comment_data, TRUE);
    }

//---------------------------End Replay Like , Comments-----------------

    function view_post_details($id, $type) {
        $result = $this->post_model->get_post_details($id, $type);
        echo $this->cf->view_emoticons($this->tt_post->get_post_details($result));
    }

    //-----------------------Start Nested Reply----------------------------

    /**
     * @Function            : add_comment_nested_reply_form 
     * @Used IN             : @function-'view/view_replies.php'   
     * @Description         : add nested commment from
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : Unknown
     * @Parameter           : $comment_id[INTEGER], $counter[INTEGER]
     * @View                : user/post_ajax/add_nested_reply_form.php
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function add_comment_nested_reply_form($comment_id, $person_id) {
        $data['comment_id'] = $comment_id;
        $data['person_id'] = $person_id;
        $data['person_info'] = $this->person_model->get_single_person_information_by_person_id($person_id);
        echo $this->load->view('user/post_ajax/add_nested_reply_form', $data, TRUE);
    }

    /**
     * @Function            : save_nested_reply 
     * @Used IN             : @function-'view/home.php'   
     * @Description         : add nested commment from
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : Unknown
     * @Updated Date Time   : 04-06-2016 02:46 PM
     * @Updated By          : MD Jaherul Islam
     * @Parameter           : $comment_reply_id[INTEGER], $person_id[INTEGER]
     * @View                : user/post_ajax/add_nested_reply_form.php
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function save_nested_reply($comment_reply_id, $person_id) {
        $this->post_model->save_nested_reply($comment_reply_id, $person_id);
        $post_data = $this->view_nested_replies_data($comment_reply_id, 1);
        echo $this->load->view('user/post_ajax/view_save_nested_replies', $post_data, TRUE);
    }

    /**
     * @Function            : view_nested_replies 
     * @Used IN             : @function-'view/home.php'   
     * @Description         : view nested replies
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : Unknown
     * @Updated Date Time   : 04-06-2016 11:03 AM
     * @Updated By          : MD Jaherul Islam
     * @Parameter           : $comment_id[INTEGER], $counter[INTEGER]
     * @View                : user/post_ajax/view_replies.php
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function view_nested_replies($comment_id, $counter) {
        $counter1 = $counter + 3;
        $post_data = $this->view_nested_replies_data($comment_id, $counter1);
        echo $this->load->view('user/post_ajax/view_replies', $post_data, TRUE);
    }

    /**
     * @Function            : view_nested_replies_data 
     * @Used IN             : @function-'view_nested_replies'    this[@Model]
     * @Description         : view nested replies data
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 04-06-2016 11:03 AM
     * @Parameter           : $comment_id[INTEGER], $counter[INTEGER]
     * @View                : None
     * @Redirect            : None
     * @Return              : $post_data[ARRAY]    
     * @Status              : Available       
     * */
    function view_nested_replies_data($comment_id, $counter) {
        $person_id = $this->session->userdata('user_id');
        $data['all_link'] = $this->post_model->get_all_linked_person($person_id);
        $data['parent_comment_value'] = $this->post_model->get_post_id_for_nested_comment($comment_id);
        $data['post_value'] = $this->post_model->select_post_by_post_id($data['parent_comment_value']->post_id);
        $data['comment_value'] = $this->post_model->get_single_post_comment_value($comment_id);
        $data['total_nested_reply'] = $this->post_model->get_total_comment_by_comment_id($comment_id);
        $data['nested_reply'] = $this->post_model->get_post_comment_replay_limit_post_comment_id($comment_id, $counter);
        return $this->post_model->get_all_post_nested_reply_data($data, $person_id);
    }

    /**
     * @Function            : view_nested_replies 
     * @Used IN             : @function-'view/post_ajax/view_replies.php'   
     * @Description         : add or remove nested replies like
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : Unknown
     * @Updated Date Time   : 04-06-2016 12:04 AM
     * @Updated By          : MD Jaherul Islam
     * @Parameter           : $comment_id[INTEGER], $person_id[INTEGER], $status[INTEGER]
     * @View                : user/post_ajax/view_replies.php
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function add_replies_like($comment_id, $person_id, $status) {
        if ($status == 'like') {
            $this->post_model->save_comment_like($comment_id, $person_id);
        } elseif ($status == 'dislike') {
            $this->post_model->remove_comment_like($comment_id, $person_id);
        }
        $data['all_link'] = $this->post_model->get_all_linked_person($person_id);
        $data['comment_value'] = $this->post_model->get_single_post_comment_value($comment_id);
        $data['parent_comment_value'] = $this->post_model->get_post_id_for_nested_comment($comment_id);
        $data['post_value'] = $this->post_model->select_post_by_post_id($data['parent_comment_value']->post_id);
        $data['nested_reply_value'] = $this->post_model->get_single_post_comment_value($comment_id);
        if ($data['nested_reply_value']->comment_like_by != '') {
            $data['nested_reply_liked_person'] = $this->post_model->get_all_post_liked_person_info($person_id, $data['all_link'], $data['nested_reply_value']->comment_like_by);
        }
        echo $this->load->view('user/post_ajax/replies_like_action', $data, TRUE);
    }

    /**
     * @Function            : delete_nested_reply 
     * @Used IN             : @function-'view/post_ajax/view_replies.php'   
     * @Description         : deleted comment nested reply
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 04-06-2016 04:19 PM
     * @Parameter           : Null
     * @View                : Null
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function delete_nested_reply() {
        $comment_parent_id = $this->input->post('post_id', TRUE);
        $deleted_id = $this->input->post('deleted_id', TRUE);

        $deleted_id_array = $this->post_model->get_all_child_comment_id($deleted_id);
        $deleted_id_array[] = $deleted_id;
        $result = $this->post_model->get_post_id_for_nested_comment($comment_parent_id);
        $post_info = $this->post_model->select_post_by_post_id($result->post_id);
        $post_comment_count = ($post_info->post_comment_count - count($deleted_id_array));
        if ($post_comment_count < 0) {
            $data['post_comment_count'] = 0;
        } else {
            $data['post_comment_count'] = $post_comment_count;
        }
        $this->utility_model->update_information_in_database('tbl_post', 'post_id', $result->post_id, $data);

        $comment_url = $this->post_model->select_all_post_url_value_by_post_id(implode(',', $deleted_id_array), 2);
        if ($comment_url) {
            $this->post_model->delete_post_comment_url(implode(',', $deleted_id_array), 2);
        }
        $this->post_model->delete_post_comment(implode(',', $deleted_id_array));
        $post_data = $this->view_nested_replies_data($comment_parent_id, 3);
        echo $this->load->view('user/post_ajax/view_replies', $post_data, TRUE);
    }

    //-----------------------End Nested Reply----------------------------
    //------------------------Start Profile view Sction for POST----------------------------

    function change_post_status($post_id, $status, $type = NULL) {
        $this->post_model->change_post_status($post_id, $status);
        $data['type'] = $type;
        $data['post_value'] = $this->post_model->get_single_post_by_post_id($post_id);
        if ($status == 'delete') {
            echo $status;
        } else {
            echo $this->load->view('user/profile_view/dashboard/dashboard_ajax_view/note_alert_content_action', $data, TRUE);
        }
    }

    function edit_post_form($post_id) {
        $data['selected_group_id'] = array();
        $person_id = $this->session->userdata('user_id');
        $data['note_alert_value'] = $this->post_model->get_single_post_by_post_id($post_id);
        $data['all_approved_group'] = $this->post_model->select_approved_group_by_person_id($person_id);
        if ($data['note_alert_value']->post_publication_status == 4) {
            $data['selected_group'] = $this->post_model->get_all_selected_group($post_id);
            foreach ($data['selected_group'] as $value) {
                $data['selected_group_id'][] = $value->group_id;
            }
        }
        echo $this->load->view('user/profile_view/dashboard/dashboard_ajax_view/edit_note_alert_form', $data, TRUE);
    }

    function update_note_alert($post_id) {
        $this->post_model->update_note_alert($post_id);
        $data['note_alert_value'] = $this->post_model->get_single_post_by_post_id($post_id);
        echo $this->load->view('user/profile_view/dashboard/dashboard_ajax_view/view_post_value', $data, TRUE);
    }

    function cancel_update_note_alert($post_id) {
        $data['note_alert_value'] = $this->post_model->get_single_post_by_post_id($post_id);
        echo $this->load->view('user/profile_view/dashboard/dashboard_ajax_view/view_post_value', $data, TRUE);
    }

    function show_view_url($status, $id = NULL) {
        $data = Array();
        $url = $this->input->post('url', TRUE);
        $url_type = $this->input->post('url_type', TRUE);
        $data['post_id'] = $id;
        $data['view_status'] = $status;
        $data['url_type'] = $url_type;
        if ($url_type == 1) {
            $data['url'] = 'https://www.youtube.com/embed/' . $url;
            echo $this->load->view('user/profile_view/dashboard/dashboard_ajax_view/url_info_view', $data, TRUE);
        }
        if ($url_type == 2) {
            $data['url'] = 'https://player.vimeo.com/video/' . $url;
            echo $this->load->view('user/profile_view/dashboard/dashboard_ajax_view/url_info_view', $data, TRUE);
        }
        if ($url_type == 3) {
            $data['url'] = $url;
            $url_data = $this->cf->get_meta_url($data, $url);
            echo $this->load->view('user/profile_view/dashboard/dashboard_ajax_view/url_info_view', $url_data, TRUE);
        }
    }

    //------------------------END Profile view Sction for POST----------------------------


    function upload_image_video() {
        $upload_type = $this->input->post('upload_type', TRUE);
        if ($upload_type == 4) { // image upload
            $total_image = $this->input->post('total_image', TRUE);
            $total_image_array = explode(',', $total_image);
            echo '<pre>';
            print_r($total_image_array);

//        $file_list_array = explode(',', $file_list);
//        echo '<pre>';
//        print_r($file_list_array);
//        print_r($file_list_array[1]);
//        print_r($_FILES['image_file1']);
//        echo 'dd';
        }

        if ($upload_type == 5) { // video upload
            echo '<pre>';
            print_r($_FILES['video_file']);
        }
    }

}
