<?php

defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * Description of notification
 *
 * @author Afrin Noumin
 */
class Notification extends TT_user_login {

    public function __construct() {
        parent::__construct();
        $this->load->model('admin_notification_model');
    }

    /**
     * @Function            : notification view
     * @Used IN             : @view notification
     * @Description         : view 30 days notification when you click view all notification 
     * @Developed By        : Afrin jahan noumin
     * @Start DateTime      : 19-04-2016 04:39 PM  
     * @Updated Date Time   : 28-09-2016 04:44 PM
     * @Updated By          : Md Jaherul Islam
     * @Parameter           : Null
     * @Return              : Null
     * @Status              : available      
     * */
    public function view_notification() {
        $data = array();
        $data['active_menu'] = ''; //left side active menu
        $data['active_sub_menu'] = ''; // left side active sub menu
        $data['left_side_menu_view'] = 1;
        $data['left_side'] = 1;
        $person_id = $this->session->person_id;
        $user_status = $this->session->sess_user_status;
        $selected_date = ($user_status == 1) ? $this->session->sess_user_selected_date : '';
        $this->utility_model->remove_session_data('sess_user_status', 'sess_user_selected_date');
        $notification_data = $this->notification_model->get_all_notification_data($data, $person_id, $selected_date, 0, 10);
        $notification_data['main_content'] = $this->load->view('user/notification/view_notification', $notification_data, true);
        $this->load->view('user/master', $notification_data);
    }

    /**
     * @Function            : view_more_notification
     * @Description         : view notification if user load
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 03-10-2016 03:38 PM  
     * @Parameter           : Null
     * @Return              : Null
     * @Status              : available      
     * */
    function view_more_notification() {
        if ($this->input->is_ajax_request()) {
            $limit = $this->input->post('limit', TRUE);
            $selected_date = $this->session->userdata('sess_user_selected_date');
            $data = Array();
            $person_id = $this->session->userdata('person_id');
            $start_limit = $limit - 5;
            $notification_data = $this->notification_model->get_all_notification_data($data, $person_id, $selected_date, $start_limit, 5);
            echo $this->load->view('user/notification/ajax_view_notification', $notification_data, true);
        } else {
            redirect();
        }
    }

    /**
     * @Function            : view_notification_by_mark
     * @Description         : view notification by mark as read
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 03-10-2016 12:30 PM  
     * @Parameter           : Null
     * @Return              : Null
     * @Status              : available      
     * */
    function view_notification_by_mark() {
        $person_id = $this->session->userdata('person_id');
        $selected_date = $this->session->userdata('sess_user_selected_date');
        $notification_id_array = explode(',', $this->notification_model->get_all_unseen_notifiction_id($person_id, $selected_date));

        foreach ($notification_id_array as $notification_id) {
            $this->notification_model->update_view_notification($person_id, $notification_id);
        }
        $sdata['sess_user_status'] = 1;
        $this->session->set_userdata($sdata);
        redirect('user/view-notification');
    }

    /**
     * @Function            : view_notification_by_date
     * @Description         : view notification using date
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 03-10-2016 12:00 PM  
     * @Parameter           : Null
     * @Return              : Null
     * @Status              : available      
     * */
    function view_notification_by_date() {
        if ($this->input->is_ajax_request()) {
            $data = $sdata = Array();
            $person_id = $this->session->userdata('person_id');
            $sdata['sess_user_selected_date'] = date('Y-m-d', ((strtotime($this->input->post('selected_date', TRUE))) - $this->session->userdata('time_offset')));
            $this->session->set_userdata($sdata);
            $notification_data = $this->notification_model->get_all_notification_data($data, $person_id, $sdata['sess_user_selected_date'], 0, 10);
            echo $this->load->view('user/notification/ajax_view_notification', $notification_data, true);
        } else {
            redirect();
        }
    }

    /**
     * @Function            : update_view_notification
     * @Description         : Update view notification
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 01-10-2016 11:30 AM  
     * @Parameter           : Null
     * @Return              : Null
     * @Status              : available      
     * */
    function update_view_notification() {
        if (empty($this->input->is_ajax_request())) {
            redirect();
        }
        $person_id = $this->session->person_id;
        $notification_id = $this->input->post('notification_id', TRUE);
        $this->notification_model->update_view_notification($person_id, $notification_id);

        $this->redirect_view_page($notification_id); // Redirect view page by notification type
    }

    /**
     * @Function            : mark_all_as_read
     * @Description         : mark all notification as read
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : -
     * @Parameter           : Null
     * @Return              : Null
     * @Status              : available      
     * */
    function mark_all_as_read() {
        if ($this->input->is_ajax_request()) {
            $person_id = $this->session->userdata('person_id');
            $notification_id_array = explode(',', $this->notification_model->get_all_unseen_notifiction_id($person_id));

            foreach ($notification_id_array as $notification_id) {
                $this->notification_model->update_view_notification($person_id, $notification_id);
            }
        } else {
            redirect();
        }
    }

    /**
     * @Function            : redirect_view_page
     * @Description         : redirect view page by using notification type
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 01-10-2016 11:44 AM  
     * @Parameter           : $notification_id[INTEGER]
     * @Return              : Null
     * @Status              : available      
     * */
    private $notification_info;

    function redirect_view_page($notification_id) {
        $this->notification_info = $this->notification_model->select_notification_info_by_notification_id($notification_id);

        switch ($this->notification_info->notification_type) {
            case (in_array($this->notification_info->notification_type, [1, 2])): // for link request accepted/request send
                echo $this->person_model->get_profile_url($this->notification_info->notify_by) . '/profile';
                break;
            case 3: // for group post
                echo 'view-content-group' . '/' . $this->utility_model->encode_id($this->notification_info->notification_type_id, '/', 'Tt') . '/1';
                break;
            case (in_array($this->notification_info->notification_type, [4, 5])): // for group request accepted/request send
                $this->view_notification_group($this->notification_info->notification_type, $this->notification_info->notification_type_id);
                break;
            case 6: // for Course
                $this->view_notification_course();
                break;
            case 7: // for payment method
                $this->notification_for_view_payment_method();
                break;
            case 8: // for Invoice
                $this->notification_for_view_invoice();
                break;
        }
    }

    /**
     * @Function            : view_notification_group
     * @Description         : view group view when click any group post
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 01-10-2016 12:33 PM  
     * @Parameter           : $notification_type[INTEGER],$group_id[INTEGER]
     * @Return              : Null
     * @Status              : available      
     * */
    function view_notification_group($notification_type, $group_id) {
        $group_info = $this->group_model->get_group_info_by_group_id($group_id);
        echo ($notification_type == 4) ? "group/$group_info->url/requested-members" : "group-detail/$group_info->url";
    }

    /**
     * @Function            : view_notification_course
     * @Description         : view course when click notification
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 01-10-2016 11:51 AM  
     * @Parameter           : $course_id[INTEGER]
     * @Return              : Null
     * @Status              : available      
     * */
    function view_notification_course() {
        $course_info = $this->utility_model
                ->get_single_table_information('course_type,course_status', 'tbl_course', 'course_id', $this->notification_info->notification_type_id);
        $notification_description = unserialize($this->notification_info->notification_description);

        if (preg_match("/registered/i", $notification_description[1])) {
            $this->view_notification_course_learner($course_info);
        } else if (preg_match("/assign/i", $notification_description[1])) {
            $this->view_notification_course_learner($course_info);
        } else {
            $this->notification_view_teacher_course($course_info);
        }
    }

    /**
     * @Description         : notification for view teacher
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 22-01-2016 11:45 AM   
     * */
    function notification_view_teacher_course($course_info) {
        switch ($course_info->course_status) {
            case (in_array($course_info->course_status, Array(1, 4))):
                $sData['course_tab'] = 'active';
                break;
            case 3:
                $sData['course_tab'] = 'submission';
                break;
            case (in_array($course_info->course_status, Array(5, 6))):
                $sData['course_tab'] = 'draft';
                break;
        }
        $sData['course_id'] = $this->notification_info->notification_type_id;
        $this->session->set_userdata($sData);
        echo ($this->session->person_role == 3) ? 'course/teacher' : 'course/organization';
    }

    /**
     * @Function            : view_notification_course_learner
     * @Description         : view course learner when click notification
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 01-10-2016 12:05 PM  
     * @Parameter           : $course_id[INTEGER]
     * @Return              : Null
     * @Status              : available      
     * */
    function view_notification_course_learner($course_info) {
        if ($this->notification_info->notify_by == $this->session->person_id) {
            $student_info = $this->student_model->set_type(1)->set_type_id($this->notification_info->notification_type_id)
                            ->set_person_id($this->notification_info->notify_by)->set_student_info_corurse()->get_result();

            if ($student_info) {
                $sData['sess_course_id'] = $this->notification_info->notification_type_id;
                $sData['learner_tab_session'] = ($course_info->course_type == 1) ? 'registration' : 'free';
                $this->session->set_userdata($sData);
                echo 'course/learner';
            } else {
                $this->notification_model->set_notification_id($this->notification_info->notification_id)->delete();
                $this->notification_model->set_notification_type_info_id($this->notification_info->notification_type_info_id)->delete_type_info();
                echo '';
            }
        } else {
            $this->notification_view_teacher_course($course_info);
        }
    }

    function notification_for_view_payment_method() {
        $payment_method = $this->admin_payment_model
                ->set_payment_method_id($this->notification_info->notification_type_id)
                ->set_payment_method_info()
                ->get_result();

        if (!empty($payment_method)) {
            echo 'user/payment-method';
        } else {
            $this->notification_model->set_notification_id($this->notification_info->notification_id)->delete();
            $this->notification_model->set_notification_type_info_id($this->notification_info->notification_type_info_id)->delete_type_info();
            echo 'error';
        }
    }

    /**
     * @Description         : notification for view invoice
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 22-01-2016 11:51 AM   
     * */
    function notification_for_view_invoice() {
        $invoice_info = $this->utility_model->set_single_row_info('invoice_id', 'tbl_invoice', ['invoice_id' => $this->notification_info->notification_type_id])
                ->get_single_row_info();

        if ($invoice_info) {
            $random_number_info = $this->utility_model->set_single_row_info('random_number', 'tbl_random', ['random_type' => 1, 'random_type_id' => $invoice_info->invoice_id])
                    ->get_single_row_info();

            $random_number = $this->tt_random_number->set_random_number($random_number_info->random_number)
                    ->filter_number('37')
                    ->get_filter_number();
            echo 'user/view-invoice/' . $random_number;
        } else {
            $this->notification_model->set_notification_id($this->notification_info->notification_id)->delete();
            $this->notification_model->set_notification_type_info_id($this->notification_info->notification_type_info_id)->delete_type_info();
            echo 'error';
        }
    }

}
