<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Message extends TT_user_login {

    public function __construct() {
        parent::__construct();
        $user_id = $this->session->userdata('user_id');

        if ($user_id == NULL) {
            $sdata = array();
            $sdata['url'] = base_url();
            $i = 1;
            while ($this->uri->segment($i)) {
                $sdata['url'] .= $this->uri->segment($i) . '/';
                $i++;
            }
            $this->session->set_userdata($sdata);
        }
    }

    public function populate_right_side($right_side_content) {
// Right Sidebar Content Information
        $person_id = $this->session->userdata('user_id');
        $data = array();
        if ($right_side_content['quizes']) {
            $data['quizes'] = $this->quiz_model->select_sugested_quiz();
        }
        if ($right_side_content['popular_group']) {
            $data['popular_group'] = $this->group_model->select_popular_group();
        }
        if ($right_side_content['suggested_link']) {
            $data ['person_link'] = $this->profile_model->select_person_link();
            if ($data['person_link']) {
                $link['person_id'] = array('FALSE');
                $link['requested_person_id'] = array('FALSE');
                foreach ($data['person_link'] as $v_person_link) {
                    if ($v_person_link->person_id != $person_id) {
                        $person_linked[$v_person_link->person_id] = TRUE;
                    }
                    if ($v_person_link->requested_person_id != $person_id) {
                        $person_linked[$v_person_link->requested_person_id] = TRUE;
                    }
                }
            }

            $data['suggested_link'] = $this->profile_model->select_suggested_link();

            foreach ($data['suggested_link'] as $v_suggested_link) {
                if (!$person_linked[$v_suggested_link->person_id] && !$person_linked[$v_suggested_link->person_id]) {
                    $data['link_info'][$v_suggested_link->person_id] = $this->profile_model->select_link_person_info(
                            $v_suggested_link->person_id);
                }
                if (!$person_linked[$v_suggested_link->requested_person_id] || !$person_linked[$v_suggested_link->requested_person_id]) {
                    $data['link_info'][$v_suggested_link->requested_person_id] = $this->profile_model->select_link_person_info($v_suggested_link->requested_person_id);
                }
            }
        }

        if ($right_side_content['tt_online_course']) {
//TalhaTraining ONLINE COURSES
            $data['tt_online_course'] = $this->course_model->select_tt_online_course();
        }

        $data['footer_section'] = $this->welcome_model->select_all_section(2, 0);
        foreach ($data['footer_section'] as $section_value) {
            $data['child_menu_with_section'][$section_value->menu_section] = $this->welcome_model->select_child_menu_with_section(2, $section_value->parent_menu_id, $section_value->menu_section);
        }
        $data['view_category'] = $this->welcome_model->select_all_published_category();
        return $data;
    }
    public function index() {
        $data = array();
        $sdata = array();
        $this->session->set_userdata($sdata);
// Right Sidebar Content Information
        $right_side_content = array('FALSE');
        $data = $this->populate_right_side($right_side_content);
        $person_id = $this->session->userdata('user_id');
        $data['active_menu'] = $this->session->userdata('active_menu');
        $data['active_sub_menu'] = $this->session->userdata('active_sub_menu');
        $sdata['active_menu'] = 'message';
        $sdata['active_sub_menu'] = 'AllReceivedMessage';
        $data['left_side_menu_view'] = 1;
        $data['left_side'] = 1;
        $data['main_content'] = $this->load->view('user/message/received_message', $data, true);
        $this->load->view('user/master', $data);
    }

///start of rcv message//
    public function message_recieved() {
        $data = array();
        $sdata = array();
        $sdata['active_menu'] = 'message';
        $sdata['active_sub_menu'] = 'AllReceivedMessage';
        $this->session->set_userdata($sdata);

// Right Sidebar Content Information
        $right_side_content = array('FALSE');
        $data = $this->populate_right_side($right_side_content);
        $person_id = $this->session->userdata('user_id');
        $data['active_menu'] = $this->session->userdata('active_menu');
        $data['active_sub_menu'] = $this->session->userdata('active_sub_menu');
        $data['left_side_menu_view'] = 1;
        $data['left_side'] = 1;
        $deleted_id = array();
        $msg_id_all = array();
        $deleted_msg = $this->message_model->select_receive_delete_message_all();
        foreach ($deleted_msg as $vl) {
            $deleted_id[] = $vl->message_id;
        }

        $all_msg_id = $this->message_model->select_all_msg_id();
        foreach ($all_msg_id as $v) {
            $msg_id_all[] = $v->message_id;
        }
        $msg_id_array = array_diff($msg_id_all, $deleted_id);
        $msg_id = implode(",", $msg_id_array);
        $data['rcv'] = $this->message_model->select_receive_message_all($msg_id);
        if ($data['rcv']) {
            foreach ($data['rcv'] as $val) {
                $data['receive_message'][$val->message_id] = $this->message_model->select_receive_message($val->message_id);
                $data['person_name'][$val->sender_id] = $this->message_model->select_all_person_receiver($val->sender_id);
                $data['receive_message_attachment'][$val->message_id] = $this->message_model->select_all_data_from_message_tbl_attachment_for_receiver($val->message_id);
            }
        }
        $data['main_content'] = $this->load->view('user/message/received_message', $data, true);
        $this->load->view('user/master', $data);
    }

    public function view_received_message($id) {
        $sdata = array();
        $sdata['message_id'] = $id;
        $this->session->set_userdata($sdata);
        redirect("preview-receive-message");
    }

    public function preview_receive_message() {
        $data = array();
        $select_deleted_id_array = array();
        $preview_reply_id_array = array();
        $message_id = $this->session->userdata("message_id");
        $decode_message_id = str_replace("%F2", "/", $message_id);
        $message_id1 = $this->encrypt->decode($decode_message_id);
        if (!$message_id1) {
            redirect("receive-message");
        }
// Right Sidebar Content Information
        $right_side_content = array('FALSE');
        $data = $this->populate_right_side($right_side_content);
        $person_id = $this->session->userdata('user_id');
        $data['active_menu'] = $this->session->userdata('active_menu');
        $data['active_sub_menu'] = $this->session->userdata('active_sub_menu');
        $data['left_side_menu_view'] = 1;
        $data['left_side'] = 1;
        $preview_rcv = $this->message_model->select_rcv_message_details_by_message_id($message_id1);
        foreach ($preview_rcv as $val_view) {
            if ($val_view->message_viewer_id == "") {
                $this->message_model->viewer_id_for_msg_no_viwer_earlier($message_id1, $person_id);
            } else if ($val_view->message_viewer_id != "") {
                $view_id_temp = $val_view->message_viewer_id;
                $view_id_temp_array = explode(",", $view_id_temp);
                if (!in_array($person_id, $view_id_temp_array)) {
                    $viewer_id = $val_view->message_viewer_id . "," . $person_id;
                    $this->message_model->viewer_id_for_msg($message_id1, $viewer_id);
                }
            }
        }
        $data["preview_rcv_message"] = $this->message_model->select_rcv_message_details_by_message_id($message_id1);
        $data['preview_rcv_reply_message'] = $this->message_model->select_msg_for_reply($message_id1);
        if ($data['preview_rcv_reply_message']) {
            $id = explode(",", $data['preview_rcv_reply_message']);
            if ($id[count($id) - 1] == '') {
                array_pop($id);
            }
            $id1 = min($id);
            $preview_rcv_reply_message = $this->message_model->select_msg_for_reply_message($id1);
            if ($preview_rcv_reply_message) {
                $preview_rcv_reply_id = explode(',', $preview_rcv_reply_message);
                if ($preview_rcv_reply_id[count($preview_rcv_reply_id) - 1] == '') {
                    array_pop($preview_rcv_reply_id);
                }
                $preview_reply_id_array2 = array_unique($preview_rcv_reply_id);
                $preview_reply_id_array1 = implode(",", $preview_reply_id_array2);
                $preview_reply_id_array = explode(",", $preview_reply_id_array1);
                rsort($preview_reply_id_array);
                $select_deleted_id = $this->message_model->select_previous_deleted_id();
                if ($select_deleted_id) {
                    foreach ($select_deleted_id as $val_del) {
                        $select_deleted_id_array[] = $val_del->message_id;
                    }
                    for ($i = 0; $i < count($preview_reply_id_array); $i++) {
                        if (!in_array($preview_reply_id_array[$i], $select_deleted_id_array)) {
                            $preview_rcv_reply[] = $this->message_model->select_reply($preview_reply_id_array[$i]);
                        }
                    }
                } else {
                    for ($i = 0; $i < count($preview_reply_id_array); $i++) {
                        $preview_rcv_reply[] = $this->message_model->select_reply($preview_reply_id_array[$i]);
                    }
                }
                $data['rcv_reply'] = $preview_rcv_reply;
                foreach ($data['rcv_reply']as $val) {
                    for ($i = 0; $i < count($val); $i++) {
                        $val_id = $val[$i]->message_id;
                        $data['preview_rcv_message_attachment'][$val[$i]->message_id] = $this->message_model->select_all_data_from_message_tbl_attachment_for_sender($val[$i]->message_id);
                        $sender_id = $val[$i]->sender_id;
                        $receiver_id = $val[$i]->receiver_id;
                        $receiver_id_in_array = explode(",", $receiver_id);
                        foreach ($data['preview_rcv_message_attachment'][$val[$i]->message_id] as $attach_value) {
                            if ($val[$i]->message_id == $attach_value->message_id) {
                                $total_rcv_attach = $attach_value->message_receiver_attachment;
                                $attach_index = array_search($person_id, $receiver_id_in_array);
                                $total_rcv_attach_array = explode(",", $total_rcv_attach);
                                if ($total_rcv_attach_array[count($total_rcv_attach_array) - 1] == '') {
                                    array_pop($total_rcv_attach_array);
                                }
                                $data['total_rcv_attach_array'] = $total_rcv_attach_array[$attach_index];
                            }
                        }
                        $data["message_sender_info"][$val[$i]->message_id] = $this->message_model->preview_message_all_sender_info($sender_id);
                        $data["message_receiver_info"] [$val[$i]->message_id] = $this->message_model->preview_message_all_receiver_id_info($receiver_id);
                        $data["message_receiver_single_info"][$val[$i]->message_id] = $this->message_model->preview_message_all_receiver_id_single_info($receiver_id);
                    }
                }
            }
        } else {
            foreach ($data["preview_rcv_message"] as $val) {
                $data['preview_rcv_message_attachment'][$val->message_id] = $this->message_model->select_all_data_from_message_tbl_attachment_for_sender($val->message_id);
                $sender_id = $val->sender_id;
                $receiver_id = $val->receiver_id;
                $receiver_id_in_array = explode(",", $receiver_id);
            }
            foreach ($data['preview_rcv_message_attachment'][$val->message_id] as $attach_value) {
                if ($val->message_id == $attach_value->message_id) {
                    $total_rcv_attach = $attach_value->message_receiver_attachment;
                    $attach_index = array_search($person_id, $receiver_id_in_array);
                    $total_rcv_attach_array = explode(",", $total_rcv_attach);
                    if ($total_rcv_attach_array[count($total_rcv_attach_array) - 1] == '') {
                        array_pop($total_rcv_attach_array);
                    }
                    $data['total_rcv_attach_array'] = $total_rcv_attach_array[$attach_index];
                }
            }
            $data["message_sender_info"] = $this->message_model->preview_message_sender_info($sender_id);
            $data["message_receiver_info"] = $this->message_model->preview_message_receiver_id_info($receiver_id);
            $data["message_receiver_single_info"] = $this->message_model->preview_message_receiver_id_single_info($receiver_id);
        }
        $data['main_content'] = $this->load->view('user/message/preview_receive_message', $data, true);
        $this->load->view('user/master', $data);
        $this->session->unset_userdata("message_id");
    }

    public function download_authentication() {
        $m_id_en = $this->input->post("message_id");
        $m_id_de = str_replace("%F2", "/", $m_id_en);
        $m_id_sa = $this->encrypt->decode($m_id_de);
        $m_id = str_replace('talha', "", $m_id_sa);
        $message_attachmen_id_en = $this->input->post("message_attachmen_id");
        $message_attachmen_id_de = str_replace("%F2", "/", $message_attachmen_id_en);
        $message_attachmen_id_sa = $this->encrypt->decode($message_attachmen_id_de);
        $message_attachmen_id = str_replace('talha', "", $message_attachmen_id_sa);
        $authen_result = $this->message_model->check_authentication_for_download($m_id, $message_attachmen_id);
        if ($authen_result) {
            echo 'allow';
        }
    }

    public function action_download($m_id_en, $message_attachmen_id_en) {
        $m_id_de = str_replace("%F2", "/", $m_id_en);
        $message_id_sa = $this->encrypt->decode($m_id_de);
        $message_id = str_replace('talha', "", $message_id_sa);
        $message_attachmen_id_de = str_replace("%F2", "/", $message_attachmen_id_en);
        $message_attachmen_id_sa = $this->encrypt->decode($message_attachmen_id_de);
        $message_attachmen_id = str_replace('talha', "", $message_attachmen_id_sa);
        $person_id = $this->session->userdata('user_id');
        $profile_url = $this->post_model->get_profile_url($person_id);
        $download_msg_detail = $this->message_model->download_message_details($message_id);
        $msg_detail = $this->message_model->select_all_msg($message_id);
        $msg_detail->sender_id . '<br>';
        if ($msg_detail->sender_id == $person_id) {
            foreach ($download_msg_detail as $val) {
                $download_rcv_message_attachment[$val->message_id] = $this->message_model->download_message_attach_tbl_detail($message_id, $message_attachmen_id);
                $sender_id = $val->sender_id;
                foreach ($download_rcv_message_attachment[$val->message_id] as $attach_value) {
                    if ($val->message_id == $attach_value->message_id) {
                        $total_rcv_attach = $attach_value->message_sender_attachment;
                        $file_name = $attach_value->message_attachment_original_name;
                        $download_rcv_attach_array_1 = file_get_contents('content-library/' . $profile_url->url . '/' . $total_rcv_attach);
                        $this->load->helper('download');
                        force_download($file_name, $download_rcv_attach_array_1);
                    }
                }
            }
        } else {
            foreach ($download_msg_detail as $val) {
                $download_rcv_message_attachment[$val->message_id] = $this->message_model->download_message_attach_tbl_detail($message_id, $message_attachmen_id);
                $sender_id = $val->sender_id;
                $receiver_id = $val->receiver_id;
                $receiver_id_in_array = explode(",", $receiver_id);
                foreach ($download_rcv_message_attachment[$val->message_id] as $attach_value) {
                    if ($val->message_id == $attach_value->message_id) {
                        $total_rcv_attach = $attach_value->message_receiver_attachment;
                        $file_name = $attach_value->message_attachment_original_name;
                        $attach_index = array_search($person_id, $receiver_id_in_array);
                        $total_rcv_attach_array = explode(",", $total_rcv_attach);
                        if ($total_rcv_attach_array[count($total_rcv_attach_array) - 1] == '') {
                            array_pop($total_rcv_attach_array);
                        }
                        $download_rcv_attach_array = $total_rcv_attach_array[$attach_index];
                        $file_path = 'content-library/' . $profile_url->url . '/' . $download_rcv_attach_array;
                        $download_rcv_attach_array_1 = file_get_contents($file_path);
                        $this->load->helper('download');
                        force_download($file_name, $download_rcv_attach_array_1);
                    }
                }
            }
        }
    }

    public function unread_action() {
        $message_id = $this->input->post("message_id");
        $person_id = $this->session->userdata('user_id');
        $message_data = $this->message_model->select_all_unread_data($message_id);
        foreach ($message_data as $val) {
            $viewer_id = $val->message_viewer_id;
            $viewer_id_array = explode(",", $viewer_id);
        }
        $fliped_view_array = array_flip($viewer_id_array);
        unset($fliped_view_array[$person_id]);
        $final_array = array_flip($fliped_view_array);
        $post_view_by = implode(",", $final_array);
        $result_unread = $this->message_model->update_for_viewer_id_unread_data($post_view_by, $message_id);
        echo "allow";
    }

    public function read_action() {
        $message_id = $this->input->post("message_id");
        $person_id = $this->session->userdata('user_id');
        $message_data = $this->message_model->select_all_unread_data($message_id);
        foreach ($message_data as $val) {
            $viewer_id = $val->message_viewer_id;
        }
        if ($viewer_id == "") {
            $this->message_model->update_for_no_viewer_id_read_data($person_id, $message_id);
        } else {
            $viewer_id_temp = $viewer_id . "," . $person_id;
            $this->message_model->update_for_viewer_id_read_data($viewer_id_temp, $message_id);
        }
        echo "allow";
    }

    public function remove_receive_msg() {
        $message_id = $this->input->post("message_id");
        $user_id = $this->session->userdata('user_id');
        $profile_url = $this->post_model->get_profile_url($user_id);
        $get_reply = $this->message_model->select_reply_exits($message_id);
        if ($get_reply) {
            $get_reply_message_parent = $this->message_model->select_reply_message_for_delete($message_id);
            $id = explode(",", $get_reply_message_parent);
            if ($id[count($id) - 1] == '') {
                array_pop($id);
            }
            $id1 = min($id);
            $get_reply_message_all = $this->message_model->select_msg_for_reply_message($id1);
            $get_reply_message_all1 = explode(",", $get_reply_message_all);
            $get_reply_message_all2 = array_unique($get_reply_message_all1);
            $get_reply_message = implode(",", $get_reply_message_all2);
            $reply_msg_id = explode(",", $get_reply_message);
            if ($reply_msg_id[count($reply_msg_id) - 1] == '') {
                array_pop($reply_msg_id);
            }
            for ($i = 0; $i < count($reply_msg_id); $i++) {
                $delete_msg_id = $this->message_model->delete_single_msg($reply_msg_id[$i]);
                $msg_details = $this->message_model->select_msg_table_data($reply_msg_id[$i]);
                $msg_attach = $this->message_model->select_msg_attach($reply_msg_id[$i]);
                if (!$delete_msg_id) {
                    if ($msg_attach) {
                        foreach ($msg_attach as $valu) {
                            $valu->message_sender_attachment;
                            $receiver_id = explode(",", $msg_details->receiver_id);
                            $sender_id = $msg_details->sender_id;
                            if ($user_id == $sender_id) {
                                $delete_attach_array = 'content-library/' . $profile_url->url . '/' . $valu->message_sender_attachment;
                                if (unlink($delete_attach_array)) {
                                    $this->message_model->insert_deleted_id($reply_msg_id[$i]);
                                }
                            } else if (in_array($user_id, $receiver_id)) {
                                $attach_recver_index = array_search($user_id, $receiver_id);
                                $attach = explode(",", $valu->message_receiver_attachment);
                                $att_file = $attach[$attach_recver_index];
                                $delete_attach_array = 'content-library/' . $profile_url->url . '/' . $att_file;
                                if (unlink($delete_attach_array)) {
                                    $this->message_model->insert_deleted_id($reply_msg_id[$i]);
                                }
                            }
                        }
                    } else {
                        $this->message_model->insert_deleted_id($reply_msg_id[$i]);
                    }
                } else {
                    if ($msg_attach) {
                        foreach ($msg_attach as $valu) {
                            $valu->message_sender_attachment;
                            $receiver_id = explode(",", $msg_details->receiver_id);
                            $sender_id = $msg_details->sender_id;
                            if ($user_id == $sender_id) {
                                $delete_attach_array = 'content-library/' . $profile_url->url . '/' . $valu->message_sender_attachment;
                                if (unlink($delete_attach_array)) {
                                    foreach ($delete_msg_id as $val) {
                                        $deleted_id = $val->message_id;
                                        $deleted_person_id = $val->person_id;
                                    }
                                    $deleted_id_array = explode(",", $deleted_person_id);
                                    if (!in_array($user_id, $deleted_id_array)) {
                                        $deleted_id_temp = $deleted_person_id . "," . $user_id;
                                        $this->message_model->update_for_deleted_id($deleted_id_temp, $reply_msg_id[$i]);
                                    }
                                }
                            } else if (in_array($user_id, $receiver_id)) {
                                $attach_recver_index = array_search($user_id, $receiver_id);
                                $attach = explode(",", $valu->message_receiver_attachment);
                                $att_file = $attach[$attach_recver_index];
                                $delete_attach_array = 'content-library/' . $profile_url->url . '/' . $att_file;
                                if (unlink($delete_attach_array)) {
                                    foreach ($delete_msg_id as $val) {
                                        $deleted_id = $val->message_id;
                                        $deleted_person_id = $val->person_id;
                                    }
                                    $deleted_id_array = explode(",", $deleted_person_id);
                                    if (!in_array($user_id, $deleted_id_array)) {
                                        $deleted_id_temp = $deleted_person_id . "," . $user_id;
                                        $this->message_model->update_for_deleted_id($deleted_id_temp, $reply_msg_id[$i]);
                                    }
                                }
                            }
                        }
                    } else {
                        foreach ($delete_msg_id as $val) {
                            $deleted_id = $val->message_id;
                            $deleted_person_id = $val->person_id;
                        }
                        $deleted_id_array = explode(",", $deleted_person_id);
                        if (!in_array($user_id, $deleted_id_array)) {
                            $deleted_id_temp = $deleted_person_id . "," . $user_id;
                            $this->message_model->update_for_deleted_id($deleted_id_temp, $reply_msg_id[$i]);
                        }
                    }
                }
            }
        } else {
            $delete_msg_id = $this->message_model->delete_single_msg($message_id);
            $msg_details = $this->message_model->select_msg_table_data($message_id);
            $msg_attach = $this->message_model->select_msg_attach($message_id);
            if (!$delete_msg_id) {
                if ($msg_attach) {
                    foreach ($msg_attach as $valu) {
                        $valu->message_sender_attachment;
                        $receiver_id = explode(",", $msg_details->receiver_id);
                        $sender_id = $msg_details->sender_id;
                        if ($user_id == $sender_id) {
                            $delete_attach_array = 'content-library/' . $profile_url->url . '/' . $valu->message_sender_attachment;
                            if (unlink($delete_attach_array)) {
                                $this->message_model->insert_deleted_id($message_id);
                            }
                        } else if (in_array($user_id, $receiver_id)) {
                            $attach_recver_index = array_search($user_id, $receiver_id);
                            $attach = explode(",", $valu->message_receiver_attachment);
                            $att_file = $attach[$attach_recver_index];
                            $delete_attach_array = 'content-library/' . $profile_url->url . '/' . $att_file;
                            if (unlink($delete_attach_array)) {
                                $this->message_model->insert_deleted_id($message_id);
                            }
                        }
                    }
                } else {
                    $this->message_model->insert_deleted_id($message_id);
                }
            } else {
                if ($msg_attach) {
                    foreach ($msg_attach as $valu) {
                        $valu->message_sender_attachment;
                        $receiver_id = explode(",", $msg_details->receiver_id);
                        $sender_id = $msg_details->sender_id;
                        if ($user_id == $sender_id) {
                            $delete_attach_array = file_get_contents('content-library/' . $profile_url->url . '/' . $valu->message_sender_attachment);
                            if (unlink($delete_attach_array)) {
                                foreach ($delete_msg_id as $val) {
                                    $deleted_id = $val->message_id;
                                    $deleted_person_id = $val->person_id;
                                }
                                $deleted_id_array = explode(",", $deleted_person_id);
                                if (!in_array($user_id, $deleted_id_array)) {
                                    $deleted_id_temp = $deleted_person_id . "," . $user_id;
                                    $this->message_model->update_for_deleted_id($deleted_id_temp, $message_id);
                                }
                            }
                        } else if (in_array($user_id, $receiver_id)) {
                            $attach_recver_index = array_search($user_id, $receiver_id);
                            $attach = explode(",", $valu->message_receiver_attachment);
                            $att_file = $attach[$attach_recver_index];
                            $delete_attach_array = 'content-library/' . $profile_url->url . '/' . $att_file;
                            if (unlink($delete_attach_array)) {
                                foreach ($delete_msg_id as $val) {
                                    $deleted_id = $val->message_id;
                                    $deleted_person_id = $val->person_id;
                                }
                                $deleted_id_array = explode(",", $deleted_person_id);
                                if (!in_array($user_id, $deleted_id_array)) {
                                    $deleted_id_temp = $deleted_person_id . "," . $user_id;
                                    $this->message_model->update_for_deleted_id($deleted_id_temp, $message_id);
                                }
                            }
                        }
                    }
                } else {
                    foreach ($delete_msg_id as $val) {
                        $deleted_id = $val->message_id;
                        $deleted_person_id = $val->person_id;
                    }
                    $deleted_id_array = explode(",", $deleted_person_id);
                    if (!in_array($user_id, $deleted_id_array)) {
                        $deleted_id_temp = $deleted_person_id . "," . $user_id;
                        $this->message_model->update_for_deleted_id($deleted_id_temp, $message_id);
                    }
                }
            }
        }
        echo 'redirect';
    }

    public function remove_rcv_selected_msg() {
        $msg_ids = $this->input->post("message_id");
        $msg_id_array = explode(",", $msg_ids);
        $user_id = $this->session->userdata('user_id');
        $profile_url = $this->post_model->get_profile_url($user_id);
        for ($i = 0; $i < count($msg_id_array); $i++) {
            $get_reply = $this->message_model->select_reply_exits($msg_id_array[$i]);
            if ($get_reply) {
                $get_reply_message_parent = $this->message_model->select_reply_message_for_delete($msg_id_array[$i]);
                $id = explode(",", $get_reply_message_parent);
                if ($id[count($id) - 1] == '') {
                    array_pop($id);
                }
                $id1 = min($id);
                $get_reply_message_all = $this->message_model->select_msg_for_reply_message($id1);
                $get_reply_message_all1 = explode(",", $get_reply_message_all);
                $get_reply_message_all2 = array_unique($get_reply_message_all1);
                $get_reply_message = implode(",", $get_reply_message_all2);
                $reply_msg_id1 = explode(",", $get_reply_message);
                if ($reply_msg_id1[count($reply_msg_id1) - 1] == '') {
                    array_pop($reply_msg_id1);
                }
                asort($reply_msg_id1);
                $reply_msg_id2 = implode(",", $reply_msg_id1);
                $reply_msg_id = explode(",", $reply_msg_id2);
                if ($reply_msg_id[count($reply_msg_id) - 1] == '') {
                    array_pop($reply_msg_id);
                }
                for ($j = 0; $j < count($reply_msg_id); $j++) {
                    $delete_msg_id = $this->message_model->delete_single_msg($reply_msg_id[$j]);
                    $msg_details = $this->message_model->select_msg_table_data($reply_msg_id[$j]);
                    $msg_attach = $this->message_model->select_msg_attach($reply_msg_id[$j]);
                    if (!$delete_msg_id) {
                        if ($msg_attach) {
                            foreach ($msg_attach as $valu) {
                                $valu->message_sender_attachment;
                                $receiver_id = explode(",", $msg_details->receiver_id);
                                $sender_id = $msg_details->sender_id;
                                if ($user_id == $sender_id) {
                                    $delete_attach_array = 'content-library/' . $profile_url->url . '/' . $valu->message_sender_attachment;
                                    if (unlink($delete_attach_array)) {
                                        $this->message_model->insert_deleted_id($reply_msg_id[$j]);
                                    }
                                } else if (in_array($user_id, $receiver_id)) {
                                    $attach_recver_index = array_search($user_id, $receiver_id);
                                    $attach = explode(",", $valu->message_receiver_attachment);
                                    $att_file = $attach[$attach_recver_index];
                                    $delete_attach_array = 'content-library/' . $profile_url->url . '/' . $att_file;
                                    if (unlink($delete_attach_array)) {
                                        $this->message_model->insert_deleted_id($reply_msg_id[$j]);
                                    }
                                }
                            }
                        } else {
                            $this->message_model->insert_deleted_id($reply_msg_id[$j]);
                        }
                    } else {
                        if ($msg_attach) {
                            foreach ($msg_attach as $valu) {
                                $valu->message_sender_attachment;
                                $receiver_id = explode(",", $msg_details->receiver_id);
                                $sender_id = $msg_details->sender_id;
                                if ($user_id == $sender_id) {
                                    $delete_attach_array = 'content-library/' . $profile_url->url . '/' . $valu->message_sender_attachment;
                                    if (unlink($delete_attach_array)) {
                                        foreach ($delete_msg_id as $val) {
                                            $deleted_id = $val->message_id;
                                            $deleted_person_id = $val->person_id;
                                        }
                                        $deleted_id_array = explode(",", $deleted_person_id);
                                        if (!in_array($user_id, $deleted_id_array)) {
                                            $deleted_id_temp = $deleted_person_id . "," . $user_id;
                                            $this->message_model->update_for_deleted_id($deleted_id_temp, $reply_msg_id[$j]);
                                        }
                                    }
                                } else if (in_array($user_id, $receiver_id)) {
                                    $attach_recver_index = array_search($user_id, $receiver_id);
                                    $attach = explode(",", $valu->message_receiver_attachment);
                                    $att_file = $attach[$attach_recver_index];
                                    $delete_attach_array = 'content-library/' . $profile_url->url . '/' . $att_file;
                                    if (unlink($delete_attach_array)) {
                                        foreach ($delete_msg_id as $val) {
                                            $deleted_id = $val->message_id;
                                            $deleted_person_id = $val->person_id;
                                        }
                                        $deleted_id_array = explode(",", $deleted_person_id);
                                        if (!in_array($user_id, $deleted_id_array)) {
                                            $deleted_id_temp = $deleted_person_id . "," . $user_id;
                                            $this->message_model->update_for_deleted_id($deleted_id_temp, $reply_msg_id[$j]);
                                        }
                                    }
                                }
                            }
                        } else {
                            foreach ($delete_msg_id as $val) {
                                $deleted_id = $val->message_id;
                                $deleted_person_id = $val->person_id;
                            }
                            $deleted_id_array = explode(",", $deleted_person_id);
                            if (!in_array($user_id, $deleted_id_array)) {
                                $deleted_id_temp = $deleted_person_id . "," . $user_id;
                                $this->message_model->update_for_deleted_id($deleted_id_temp, $reply_msg_id[$j]);
                            }
                        }
                    }
                }
            }//end of get_reply
            else {
                $delete_msg_id = $this->message_model->delete_single_msg($msg_id_array[$i]);
                $msg_details = $this->message_model->select_msg_table_data($msg_id_array[$i]);
                $msg_attach = $this->message_model->select_msg_attach($msg_id_array[$i]);
                if (!$delete_msg_id) {
                    if ($msg_attach) {
                        foreach ($msg_attach as $valu) {
                            $valu->message_sender_attachment;
                            $receiver_id = explode(",", $msg_details->receiver_id);
                            $sender_id = $msg_details->sender_id;
                            if ($user_id == $sender_id) {
                                $delete_attach_array = 'content-library/' . $profile_url->url . '/' . $valu->message_sender_attachment;
                                if (unlink($delete_attach_array)) {
                                    $this->message_model->insert_deleted_id($msg_id_array[$i]);
                                }
                            } else if (in_array($user_id, $receiver_id)) {
                                $attach_recver_index = array_search($user_id, $receiver_id);
                                $attach = explode(",", $valu->message_receiver_attachment);
                                $att_file = $attach[$attach_recver_index];
                                $delete_attach_array = 'content-library/' . $profile_url->url . '/' . $att_file;
                                if (unlink($delete_attach_array)) {
                                    $this->message_model->insert_deleted_id($msg_id_array[$i]);
                                }
                            }
                        }
                    } else {
                        $this->message_model->insert_deleted_id($msg_id_array[$i]);
                    }
                } else {
                    if ($msg_attach) {
                        foreach ($msg_attach as $valu) {
                            $valu->message_sender_attachment;
                            $receiver_id = explode(",", $msg_details->receiver_id);
                            $sender_id = $msg_details->sender_id;
                            if ($user_id == $sender_id) {
                                $delete_attach_array = 'content-library/' . $profile_url->url . '/' . $valu->message_sender_attachment;
                                if (unlink($delete_attach_array)) {
                                    foreach ($delete_msg_id as $val) {
                                        $deleted_id = $val->message_id;
                                        $deleted_person_id = $val->person_id;
                                    }
                                    $deleted_id_array = explode(",", $deleted_person_id);
                                    if (!in_array($user_id, $deleted_id_array)) {
                                        $deleted_id_temp = $deleted_person_id . "," . $user_id;
                                        $this->message_model->update_for_deleted_id($deleted_id_temp, $msg_id_array[$i]);
                                    }
                                }
                            } else if (in_array($user_id, $receiver_id)) {
                                $attach_recver_index = array_search($user_id, $receiver_id);
                                $attach = explode(",", $valu->message_receiver_attachment);
                                $att_file = $attach[$attach_recver_index];
                                $delete_attach_array = 'content-library/' . $profile_url->url . '/' . $att_file;
                                if (unlink($delete_attach_array)) {
                                    foreach ($delete_msg_id as $val) {
                                        $deleted_id = $val->message_id;
                                        $deleted_person_id = $val->person_id;
                                    }
                                    $deleted_id_array = explode(",", $deleted_person_id);
                                    if (!in_array($user_id, $deleted_id_array)) {
                                        $deleted_id_temp = $deleted_person_id . "," . $user_id;
                                        $this->message_model->update_for_deleted_id($deleted_id_temp, $msg_id_array[$i]);
                                    }
                                }
                            }
                        }
                    } else {
                        foreach ($delete_msg_id as $val) {
                            $deleted_id = $val->message_id;
                            $deleted_person_id = $val->person_id;
                        }
                        $deleted_id_array = explode(",", $deleted_person_id);
                        if (!in_array($user_id, $deleted_id_array)) {
                            $deleted_id_temp = $deleted_person_id . "," . $user_id;
                            $this->message_model->update_for_deleted_id($deleted_id_temp, $msg_id_array[$i]);
                        }
                    }
                }
            }
        }//endof $i loop
        echo 'redirect';
    }

//end of rcv message//
//invitation start

    public function invitations_received_message() {
        $data = array();
        $sdata = array();
        $sdata['active_menu'] = 'message';
        $sdata['active_sub_menu'] = 'InvitationsReceivedMessage';
        $this->session->set_userdata($sdata);

// Right Sidebar Content Information
        $right_side_content = array('FALSE');
        $right_side_content['quizes'] = TRUE;
        $right_side_content['popular_group'] = TRUE;
        $right_side_content['suggested_link'] = TRUE;
        $right_side_content['tt_online_course'] = TRUE;
        $data = $this->populate_right_side($right_side_content);
        $data['left_side_menu_view'] = 1;
        $data['left_side'] = 1;
        $person_id = $this->session->userdata('user_id');
        $data['active_menu'] = $this->session->userdata('active_menu');
        $data['active_sub_menu'] = $this->session->userdata('active_sub_menu');
        $data['left_content'] = $this->load->view('user/side_menu', $data, TRUE);
        $data['right_content'] = $this->load->view('user/right_content', $data, TRUE);
        $data['rcv_invitation'] = $this->message_model->select_all_rcv_invitation_msg();
        if ($data['rcv_invitation']) {
            foreach ($data['rcv_invitation'] as $val) {
                $message_id[] = $val->invitation_message_id;
            }
            $person_id = $this->session->userdata('user_id');
            $data['deleted_invitation_id'] = $this->message_model->deleted_invitation_id();

            if ($data['deleted_invitation_id']) {
                foreach ($data['deleted_invitation_id'] as $value) {

                    $deleted_id[] = $value->invitation_message_id;
                }
                $msg_id_array = array_diff($message_id, $deleted_id);
                $msg_id = implode(",", $msg_id_array);
                $data['rcv_invitation_email'] = $this->message_model->select_invitation_rcv_message_all($msg_id);
                if ($data['rcv_invitation_email']) {
                    foreach ($data['rcv_invitation_email'] as $value) {

                        $data['person_info'][$value->invitation_message_sender_id] = $this->message_model->select_sender_info($value->invitation_message_sender_id);
                    }
                }
            } else {
                $data['rcv_invitation_email'] = $this->message_model->select_all_rcv_invitation_msg();

                if ($data['rcv_invitation_email']) {
                    foreach ($data['rcv_invitation_email'] as $value) {

                        $data['person_info'][$value->invitation_message_sender_id] = $this->message_model->select_sender_info($value->invitation_message_sender_id);
                    }
                }
            }
        }

        $data['main_content'] = $this->load->view('user/message/invitation_received_message', $data, true);
        $this->load->view('user/master', $data);
    }

    public function invitations_sent_message() {
        $data = array();
        $sdata = array();
        $message_id = array();
        $deleted_id = array();
        $sdata['active_menu'] = 'message';
        $sdata['active_sub_menu'] = 'InvitationsSentMessage';
        $this->session->set_userdata($sdata);

// Right Sidebar Content Information
        $right_side_content = array('FALSE');
        $right_side_content['quizes'] = TRUE;
        $right_side_content['popular_group'] = TRUE;
        $right_side_content['suggested_link'] = TRUE;
        $right_side_content['tt_online_course'] = TRUE;
        $data = $this->populate_right_side($right_side_content);
        $data['left_side_menu_view'] = 1;
        $data['left_side'] = 1;
        $person_id = $this->session->userdata('user_id');
        $data['active_menu'] = $this->session->userdata('active_menu');
        $data['active_sub_menu'] = $this->session->userdata('active_sub_menu');
        $data['left_content'] = $this->load->view('user/side_menu', $data, TRUE);
        $data['right_content'] = $this->load->view('user/right_content', $data, TRUE);
        $data['sent_invitation'] = $this->message_model->select_all_sent_invitation_msg();
        foreach ($data['sent_invitation'] as $val) {
            $message_id[] = $val->invitation_message_id;
        }
        $person_id = $this->session->userdata('user_id');
        $data['deleted_invitation_id'] = $this->message_model->deleted_invitation_id();

        foreach ($data['deleted_invitation_id'] as $value) {

            $deleted_id[] = $value->invitation_message_id;
        }
        $msg_id_array = array_diff($message_id, $deleted_id);
        $msg_id = implode(",", $msg_id_array);
        $data['sent_invitation_email'] = $this->message_model->select_invitation_sent_message_all($msg_id);
        $data['main_content'] = $this->load->view('user/message/invitation_sent_message', $data, true);
        $this->load->view('user/master', $data);
    }

    public function view_invitation_sent_message($id) {

        $qdata = array();
        $qdata['invitation_message_id'] = $id;

        $this->session->set_userdata($qdata);
        redirect('invitations-message-preview');
    }

    public function invitations_message_preview() {
        $data = array();
        $sdata = array();
        $this->session->set_userdata($sdata);

// Right Sidebar Content Information
        $right_side_content = array('FALSE');
        $data = $this->populate_right_side($right_side_content);
        $person_id = $this->session->userdata('user_id');
        $data['active_menu'] = $this->session->userdata('active_menu');
        $data['active_sub_menu'] = $this->session->userdata('active_sub_menu');
        $data['left_side_menu_view'] = 1;
        $data['left_side'] = 1;
        $invitation_message_id1 = $this->session->userdata('invitation_message_id');
        $decode_message_id = str_replace("%F2", "/", $invitation_message_id1);
        $invitation_message_id = $this->encrypt->decode($decode_message_id);
        if (!$invitation_message_id) {
            redirect("invitations-sent-message");
        }
        $data['invitation_details_view'] = $this->message_model->select_invitation_detail($invitation_message_id);
        $data['person_info'] = $this->message_model->select_sender_info($data['invitation_details_view']->invitation_message_sender_id);
        $data['main_content'] = $this->load->view('user/message/invitation_message_preview', $data, true);
        $this->load->view('user/master', $data);
    }

    public function view_invitation_rcv_message($id) {
        $qdata = array();
        $qdata['invitation_message_id'] = $id;
        $this->session->set_userdata($qdata);
        redirect('invitations-message-receive-preview');
    }

    public function invitations_message_receive_preview() {
        $data = array();
        $sdata = array();
        $this->session->set_userdata($sdata);

// Right Sidebar Content Information
        $right_side_content = array('FALSE');
        $right_side_content['quizes'] = TRUE;
        $right_side_content['popular_group'] = TRUE;
        $right_side_content['suggested_link'] = TRUE;
        $right_side_content['tt_online_course'] = TRUE;
        $data = $this->populate_right_side($right_side_content);

        $person_id = $this->session->userdata('user_id');
        $data['active_menu'] = $this->session->userdata('active_menu');
        $data['active_sub_menu'] = $this->session->userdata('active_sub_menu');
        $data['left_side_menu_view'] = 1;
        $data['left_side'] = 1;
        $invitation_message_id1 = $this->session->userdata('invitation_message_id');
        $decode_message_id = str_replace("%F2", "/", $invitation_message_id1);
        $invitation_message_id = $this->encrypt->decode($decode_message_id);
        if (!$invitation_message_id) {
            redirect("invitations-sent-message");
        }
        $preview_rcv = $this->message_model->select_invitation_rcv_message_details_for_read_unread($invitation_message_id);
        if ($preview_rcv->invitation_viewer_id == "") {
            $this->message_model->viewer_for_invitation_msg_no_viwer_earlier($invitation_message_id);
        } else if ($preview_rcv->invitation_viewer_id != "") {
            $view_id_temp = $preview_rcv->invitation_viewer_id;
            $view_id_temp_array = explode(",", $view_id_temp);            
            if (!in_array($person_id, $view_id_temp_array)) {
                $viewer_id = $preview_rcv->invitation_viewer_id . "," . $person_id;
                $this->message_model->viewer_invitation_msg_for_read_unread($invitation_message_id, $viewer_id);
            }
        }
        $data['invitation_details_view'] = $this->message_model->select_invitation_detail($invitation_message_id);
        $data['person_info'] = $this->message_model->select_sender_info($data['invitation_details_view']->invitation_message_sender_id);
        $data['main_content'] = $this->load->view('user/message/invitation_received_preview_message', $data, true);
        $this->load->view('user/master', $data);
    }

    public function invitation_unread() {
        $message_id = $this->input->post("message_id");       
        $person_id = $this->session->userdata('user_id');
        $message_data = $this->message_model->select_all_invitation_unread_data($message_id);
        foreach ($message_data as $val) {
            $viewer_id = $val->invitation_viewer_id;
            $viewer_id_array = explode(",", $viewer_id);            
        }
        $fliped_view_array = array_flip($viewer_id_array);
        unset($fliped_view_array[$person_id]);
        $final_array = array_flip($fliped_view_array);
        $post_view_by = implode(",", $final_array);
        $result_unread = $this->message_model->update_for_viewer_id_invitation_unread($post_view_by, $message_id);
        echo "allow";
    }

    public function invitation_read() {
        $message_id = $this->input->post("message_id");
        $person_id = $this->session->userdata('user_id');
        $message_data = $this->message_model->select_all_invitation_unread_data($message_id);
        foreach ($message_data as $val) {
            $viewer_id = $val->invitation_viewer_id;
        }
        if ($viewer_id == "") {
            $this->message_model->update_for_no_viewer_id_invitation_read_data($person_id, $message_id);
        } else {
            $viewer_id_temp = $viewer_id . "," . $person_id;
            $this->message_model->update_for_viewer_id_invitation_read_data($viewer_id_temp, $message_id);
        }
        echo "allow";
    }

    public function sent_invitation_msg_remove() {
        $person_id = $this->session->userdata('user_id');
        $invitation_message_id = $this->input->post("invitation_message_id");
        $deleted_row = $this->message_model->select_deleted_id_for_invitation_message_id($invitation_message_id);
        $deleted_id = $deleted_row->invitation_message_deleted_id;
        if ($deleted_id) {
            $deleted_id_array = explode(",", $deleted_id);
            if ($deleted_id_array[count($deleted_id_array) - 1] == '') {
                array_pop($deleted_id_array);
            }
            if (!in_array($person_id, $deleted_id_array)) {
                $delete_id_temp = $deleted_id . "," . $person_id;
                $this->message_model->insert_invitation_deleted_id($delete_id_temp, $invitation_message_id);
            }
        } else {
            $this->message_model->insert_invitation_deleted_id($person_id, $invitation_message_id);
        }
        echo 'redirect';
    }

    public function sent_invitation_selected_msg_remove() {
        $person_id = $this->session->userdata('user_id');
        $invitation_message_id = $this->input->post("message_id");        
        $invitation_message_id_array = explode(",", $invitation_message_id);
        if ($invitation_message_id_array[count($invitation_message_id_array) - 1] == '') {
            array_pop($invitation_message_id_array);
        }
        for ($i = 0; $i < count($invitation_message_id_array); $i++) {            
            $deleted_row = $this->message_model->select_deleted_id_for_invitation_message_id($invitation_message_id_array[$i]);
            $deleted_id = $deleted_row->invitation_message_deleted_id;
            if ($deleted_id) {
                $deleted_id_array = explode(",", $deleted_id);
                if ($deleted_id_array[count($deleted_id_array) - 1] == '') {
                    array_pop($deleted_id_array);
                }                
                if (!in_array($person_id, $deleted_id_array)) {
                    $delete_id_temp = $deleted_id . "," . $person_id;
                    $this->message_model->insert_invitation_deleted_id($delete_id_temp, $invitation_message_id_array[$i]);
                }
            } else {
                $this->message_model->insert_invitation_deleted_id($person_id, $invitation_message_id_array[$i]);
            }
        }
        echo 'redirect';
    }

    public function rcv_invitation_msg_remove() {
        $person_id = $this->session->userdata('user_id');
        $invitation_message_id = $this->input->post("invitation_message_id");
        $deleted_row = $this->message_model->select_deleted_id_for_invitation_message_id($invitation_message_id);
        $deleted_id = $deleted_row->invitation_message_deleted_id;
        if ($deleted_id) {
            $deleted_id_array = explode(",", $deleted_id);
            if ($deleted_id_array[count($deleted_id_array) - 1] == '') {
                array_pop($deleted_id_array);
            }
            if (!in_array($person_id, $deleted_id_array)) {
                $delete_id_temp = $deleted_id . "," . $person_id;
                $this->message_model->insert_invitation_deleted_id($delete_id_temp, $invitation_message_id);
            }
        } else {
            $this->message_model->insert_invitation_deleted_id($person_id, $invitation_message_id);
        }
        echo 'redirect';
    }

    public function rcv_invitation_selected_msg_remove() {
        $person_id = $this->session->userdata('user_id');
        $invitation_message_id = $this->input->post("message_id");
        $invitation_message_id_array = explode(",", $invitation_message_id);
        if ($invitation_message_id_array[count($invitation_message_id_array) - 1] == '') {
            array_pop($invitation_message_id_array);
        }
        for ($i = 0; $i < count($invitation_message_id_array); $i++) {            
            $deleted_row = $this->message_model->select_deleted_id_for_invitation_message_id($invitation_message_id_array[$i]);
            $deleted_id = $deleted_row->invitation_message_deleted_id;
            if ($deleted_id) {
                $deleted_id_array = explode(",", $deleted_id);
                if ($deleted_id_array[count($deleted_id_array) - 1] == '') {
                    array_pop($deleted_id_array);
                }               
                if (!in_array($person_id, $deleted_id_array)) {
                    $delete_id_temp = $deleted_id . "," . $person_id;
                    $this->message_model->insert_invitation_deleted_id($delete_id_temp, $invitation_message_id_array[$i]);
                }
            } else {
                $this->message_model->insert_invitation_deleted_id($person_id, $invitation_message_id_array[$i]);
            }
        }
        echo 'redirect';
    }

//invitation end 
//message_setting_start
    public function message_setting() {
        $data = array();
        $sdata = array();
        $sdata['active_menu'] = 'message';
        $sdata['active_sub_menu'] = 'MessageSetting';
        $this->session->set_userdata($sdata);

// Right Sidebar Content Information
        $right_side_content = array('FALSE');
        $data = $this->populate_right_side($right_side_content);
        $person_id = $this->session->userdata('user_id');
        $data['active_menu'] = $this->session->userdata('active_menu');
        $data['active_sub_menu'] = $this->session->userdata('active_sub_menu');
        $data['left_side_menu_view'] = 1;
        $data['left_side'] = 1;
        $data['message_setting_info'] = $this->message_model->check_messgae_setting();
        $data['main_content'] = $this->load->view('user/message/message_setting', $data, true);
        $this->load->view('user/master', $data);
    }

    public function save_message_option() {
        $person_message_setting = $this->input->post('person_message_setting');
        $save_message_setting = $this->message_model->save_message_setting_option($person_message_setting);
    }

    //message_setting_change
    //start of sent//
    public function send_message() {
        $data = array();

// Right Sidebar Content Information
        $right_side_content = array('FALSE');
        $data = $this->populate_right_side($right_side_content);
        $person_id = $this->session->userdata('user_id');
        $data['active_menu'] = $this->session->userdata('active_menu');
        $data['active_sub_menu'] = $this->session->userdata('active_sub_menu');
        $data['left_side_menu_view'] = 1;
        $data['left_side'] = 1;
        $data['link_person'] = $this->user_course_model->select_link_person($person_id);
        foreach ($data['link_person'] as $v_link) {
            if ($v_link->person_id != $person_id) {
                $data['link_person_info'][$v_link->person_link_id] = $this->profile_model->person_info_by_person_id($v_link->person_id);
            } else if ($v_link->requested_person_id != $person_id) {
                $data['link_person_info'][$v_link->person_link_id] = $this->profile_model->person_info_by_person_id($v_link->requested_person_id);
            }
        }
        $data['main_content'] = $this->load->view('user/message/send_message_form', $data, true);
        $this->load->view('user/master', $data);
    }

    public function sent_message() {
        $data = array();
        $sdata = array();
        $this->session->set_userdata($sdata);

// Right Sidebar Content Information
        $right_side_content = array('FALSE');
        $data = $this->populate_right_side($right_side_content);
        $person_id = $this->session->userdata('user_id');
        $data['active_menu'] = $this->session->userdata('active_menu');
        $data['active_sub_menu'] = $this->session->userdata('active_sub_menu');
        $data['left_side_menu_view'] = 1;
        $data['left_side'] = 1;
        $deleted_id = array();
        $msg_id_all = array();
        $deleted_msg = $this->message_model->select_sent_delete_message_all();
        foreach ($deleted_msg as $vl) {
            $deleted_id[] = $vl->message_id;
        }

        $all_msg_id = $this->message_model->select_all_msg_id();
        foreach ($all_msg_id as $v) {
            $msg_id_all[] = $v->message_id;
        }
        $msg_id_array = array_diff($msg_id_all, $deleted_id);
        $msg_id = implode(",", $msg_id_array);
        $data['sent'] = $this->message_model->select_all_data_from_message_tbl_for_sender($msg_id);

        if ($data['sent']) {
            foreach ($data['sent'] as $val) {
                $data['sent_message'][$val->message_id] = $this->message_model->select_sent_msg($val->message_id);
                $data['sent_message_attachment'][$val->message_id] = $this->message_model->select_all_data_from_message_tbl_attachment_for_sender($val->message_id);
            }
        }
        $data['main_content'] = $this->load->view('user/message/sent_message', $data, true);
        $this->load->view('user/master', $data);
    }

    public function view_message($message_id) {
        $sdata = array();
        $sdata['message_id'] = $message_id;
        $this->session->set_userdata($sdata);
        redirect("preview-message");
    }

    public function preview_message() {
        $data = array();
        $message_id = $this->session->userdata("message_id");
        $decode_message_id = str_replace("%F2", "/", $message_id);
        $message_id1 = $this->encrypt->decode($decode_message_id);
        if (!$message_id) {
            redirect("sent-message");
        }
// Right Sidebar Content Information
        $right_side_content = array('FALSE');
        $data = $this->populate_right_side($right_side_content);
        $person_id = $this->session->userdata('user_id');
        $data['active_menu'] = $this->session->userdata('active_menu');
        $data['active_sub_menu'] = $this->session->userdata('active_sub_menu');
        $data['left_side_menu_view'] = 1;
        $data['left_side'] = 1;
        $data['preview_message'] = $this->message_model->select_message_details_by_message_id($message_id1);
        $data['preview_reply_message'] = $this->message_model->select_msg_for_reply($message_id1);
        if ($data['preview_reply_message']) {
            $id = explode(',', $data['preview_reply_message']);
            if ($id[count($id) - 1] == '') {
                array_pop($id);
            }
            $id1 = min($id);
            $preview_reply_message = $this->message_model->select_msg_for_reply_message_sent($id1);
            if ($preview_reply_message) {
                $preview_rcv_reply_id = explode(',', $preview_reply_message);
                if ($preview_rcv_reply_id[count($preview_rcv_reply_id) - 1] == '') {
                    array_pop($preview_rcv_reply_id);
                }
                $preview_reply_id_array2 = array_unique($preview_rcv_reply_id);
                $preview_reply_id_array1 = implode(",", $preview_reply_id_array2);
                $preview_reply_id_array = explode(",", $preview_reply_id_array1);
                rsort($preview_reply_id_array);
                $select_deleted_id = $this->message_model->select_previous_deleted_id();
                if ($select_deleted_id) {
                    foreach ($select_deleted_id as $val_del) {
                        $select_deleted_id_array[] = $val_del->message_id;
                    }
                    for ($i = 0; $i < count($preview_reply_id_array); $i++) {
                        if (!in_array($preview_reply_id_array[$i], $select_deleted_id_array)) {
                            $preview_rcv_reply[] = $this->message_model->select_reply($preview_reply_id_array[$i]);
                        }
                    }
                } else {
                    for ($i = 0; $i < count($preview_reply_id_array); $i++) {

                        $preview_rcv_reply[] = $this->message_model->select_reply($preview_reply_id_array[$i]);
                    }
                }
                $data['sent_reply'] = $preview_rcv_reply;
                foreach ($data['sent_reply']as $val) {                    
                    for ($i = 0; $i < count($val); $i++) {
                        $val_id = $val[$i]->message_id;
                        $data['preview_message_attachment'][$val[$i]->message_id] = $this->message_model->select_all_data_from_message_tbl_attachment_for_sender($val[$i]->message_id);
                        $sender_id = $val[$i]->sender_id;
                        $receiver_id = $val[$i]->receiver_id;
                        $receiver_id_in_array = explode(",", $receiver_id);
                        foreach ($data['preview_message_attachment'][$val[$i]->message_id] as $attach_value) {
                            if ($val[$i]->message_id == $attach_value->message_id) {
                                $total_rcv_attach = $attach_value->message_receiver_attachment;
                                $attach_index = array_search($person_id, $receiver_id_in_array);
                                $total_rcv_attach_array = explode(",", $total_rcv_attach);
                                if ($total_rcv_attach_array[count($total_rcv_attach_array) - 1] == '') {
                                    array_pop($total_rcv_attach_array);
                                }
                                $data['total_rcv_attach_array'] = $total_rcv_attach_array[$attach_index];
                            }
                        }
                        $data["message_sender_info"] [$val[$i]->message_id] = $this->message_model->preview_message_sender_info($sender_id);
                        $data["message_receiver_info"][$val[$i]->message_id] = $this->message_model->preview_message_receiver_id_info($receiver_id);
                        $data["message_receiver_single_info"][$val[$i]->message_id] = $this->message_model->preview_message_receiver_id_single_info($receiver_id);
                    }
                }
            }
        }
        else {
            foreach ($data["preview_message"] as $val) {
                $data['preview_message_attachment'][$val->message_id] = $this->message_model->select_all_data_from_message_tbl_attachment_for_sender($val->message_id);
                $sender_id = $val->sender_id;
                $receiver_id = $val->receiver_id;
                $receiver_id_in_array = explode(",", $receiver_id);
            }
            foreach ($data['preview_message_attachment'][$val->message_id] as $attach_value) {
                if ($val->message_id == $attach_value->message_id) {
                    $total_rcv_attach = $attach_value->message_receiver_attachment;
                    $attach_index = array_search($person_id, $receiver_id_in_array);
                    $total_rcv_attach_array = explode(",", $total_rcv_attach);
                    if ($total_rcv_attach_array[count($total_rcv_attach_array) - 1] == '') {
                        array_pop($total_rcv_attach_array);
                    }
                    $data['total_rcv_attach_array'] = $total_rcv_attach_array[$attach_index];
                }
            }
            $data["message_sender_info"] = $this->message_model->preview_message_sender_info($sender_id);
            $data["message_receiver_info"] = $this->message_model->preview_message_receiver_id_info($receiver_id);
            $data["message_receiver_single_info"] = $this->message_model->preview_message_receiver_id_single_info($receiver_id);
            $data['main_content'] = $this->load->view('user/message/preview_receive_message', $data, true);
        }
        $data['main_content'] = $this->load->view('user/message/message_preview', $data, true);
        $this->load->view('user/master', $data);
        $this->session->unset_userdata("message_id");
    }

    public function download_authentication_for_sent_msg() {
        $m_id_en = $this->input->post("message_id");
        $m_id_de = str_replace("%F2", "/", $m_id_en);
        $m_id_sa = $this->encrypt->decode($m_id_de);
        $m_id = str_replace('talha', "", $m_id_sa);
        $message_attachmen_id_en = $this->input->post("message_attachmen_id");
        $message_attachmen_id_de = str_replace("%F2", "/", $message_attachmen_id_en);
        $message_attachmen_id_sa = $this->encrypt->decode($message_attachmen_id_de);
        $message_attachmen_id = str_replace('talha', "", $message_attachmen_id_sa);
        // echo $message_attachmen_id;
        $authen_result = $this->message_model->check_authentication_for_download_send($m_id, $message_attachmen_id);
        if ($authen_result) {
            echo 'allow';
        }
    }

    public function action_download_send($m_id_en, $message_attachmen_id_en) {
        $m_id_de = str_replace("%F2", "/", $m_id_en);
        $message_id_sa = $this->encrypt->decode($m_id_de);
        $message_id = str_replace('talha', "", $message_id_sa);
        $message_attachmen_id_de = str_replace("%F2", "/", $message_attachmen_id_en);
        $message_attachmen_id_sa = $this->encrypt->decode($message_attachmen_id_de);
        $message_attachmen_id = str_replace('talha', "", $message_attachmen_id_sa);
        $authen_result = $this->message_model->check_authentication_for_download_send($message_id, $message_attachmen_id);
        if ($authen_result) {
            $download_msg_detail = $this->message_model->download_message_details_send($message_id);
            $person_id = $this->session->userdata('user_id');
            $msg_detail = $this->message_model->select_all_msg($message_id);
            if ($msg_detail->sender_id == $person_id) {
                foreach ($download_msg_detail as $val) {
                    $download_rcv_message_attachment[$val->message_id] = $this->message_model->download_message_attach_tbl_detail($message_id, $message_attachmen_id);
                    $sender_id = $val->sender_id;
                    foreach ($download_rcv_message_attachment[$val->message_id] as $attach_value) {
                        if ($val->message_id == $attach_value->message_id) {
                            $total_rcv_attach = $attach_value->message_sender_attachment;
                            $file_name = $attach_value->message_attachment_original_name;
                        }
                    }
                }
                $profile_url = $this->post_model->get_profile_url($person_id);
                $download_rcv_attach_array_1 = file_get_contents('content-library/' . $profile_url->url . '/' . $total_rcv_attach);
                $this->load->helper('download');
                force_download($file_name, $download_rcv_attach_array_1);
            } else {
                foreach ($download_msg_detail as $val) {
                    $download_rcv_message_attachment[$val->message_id] = $this->message_model->download_message_attach_tbl_detail($message_id, $message_attachmen_id);
                    $sender_id = $val->sender_id;
                    $receiver_id = $val->receiver_id;
                    $receiver_id_in_array = explode(",", $receiver_id);
                    foreach ($download_rcv_message_attachment[$val->message_id] as $attach_value) {
                        if ($val->message_id == $attach_value->message_id) {
                            $total_rcv_attach = $attach_value->message_receiver_attachment;
                            $file_name = $attach_value->message_attachment_original_name;
                            $attach_index = array_search($person_id, $receiver_id_in_array);
                            $total_rcv_attach_array = explode(",", $total_rcv_attach);
                            if ($total_rcv_attach_array[count($total_rcv_attach_array) - 1] == '') {
                                array_pop($total_rcv_attach_array);
                            }
                            $download_rcv_attach_array = $total_rcv_attach_array[$attach_index];
                        }
                    }
                }
                $profile_url = $this->post_model->get_profile_url($person_id);
                $download_rcv_attach_array_1 = file_get_contents('content-library/' . $profile_url->url . '/' . $download_rcv_attach_array);
                $this->load->helper('download');
                force_download($file_name, $download_rcv_attach_array_1);
            }
        }
    }

    public function remove_sent_msg() {
        $message_id = $this->input->post("message_id");
        $user_id = $this->session->userdata('user_id');
        $profile_url = $this->post_model->get_profile_url($user_id);
        $get_reply = $this->message_model->select_reply_exits($message_id);
        if ($get_reply) {
            $get_reply_message_parent = $this->message_model->select_reply_message_for_delete($message_id);
            if ($get_reply_message_parent) {
                $id = explode(",", $get_reply_message_parent);
                if ($id[count($id) - 1] == '') {
                    array_pop($id);
                }
                $id1 = min($id);
                $get_reply_message_all = $this->message_model->select_msg_for_reply_message($id1);
                $get_reply_message_all1 = explode(",", $get_reply_message_all);
                $get_reply_message_all2 = array_unique($get_reply_message_all1);
                $get_reply_message = implode(",", $get_reply_message_all2);
                $reply_msg_id = explode(",", $get_reply_message);
                if ($reply_msg_id[count($reply_msg_id) - 1] == '') {
                    array_pop($reply_msg_id);
                }
                for ($i = 0; $i < count($reply_msg_id); $i++) {
                    $delete_msg_id = $this->message_model->delete_single_msg($reply_msg_id[$i]);
                    $msg_details = $this->message_model->select_msg_table_data($reply_msg_id[$i]);
                    $msg_attach = $this->message_model->select_msg_attach($reply_msg_id[$i]);
                    if (!$delete_msg_id) {
                        if ($msg_attach) {
                            foreach ($msg_attach as $valu) {
                                $valu->message_sender_attachment;
                                $receiver_id = explode(",", $msg_details->receiver_id);                                
                                $sender_id = $msg_details->sender_id;
                                if ($user_id == $sender_id) {
                                    $delete_attach_array = 'content-library/' . $profile_url->url . '/' . $valu->message_sender_attachment;
                                    if (unlink($delete_attach_array)) {
                                        $this->message_model->insert_deleted_id($reply_msg_id[$i]);
                                    }
                                } else if (in_array($user_id, $receiver_id)) {
                                    $attach_recver_index = array_search($user_id, $receiver_id);
                                    $attach = explode(",", $valu->message_receiver_attachment);
                                    $att_file = $attach[$attach_recver_index];
                                    $delete_attach_array = 'content-library/' . $profile_url->url . '/' . $att_file;
                                    if (unlink($delete_attach_array)) {
                                        $this->message_model->insert_deleted_id($reply_msg_id[$i]);
                                    }
                                }
                            }
                        } else {
                            $this->message_model->insert_deleted_id($reply_msg_id[$i]);
                        }
                    } else {
                        if ($msg_attach) {
                            foreach ($msg_attach as $valu) {
                                $valu->message_sender_attachment;
                                $receiver_id = explode(",", $msg_details->receiver_id);
                                $sender_id = $msg_details->sender_id;
                                if ($user_id == $sender_id) {
                                    $delete_attach_array = 'content-library/' . $profile_url->url . '/' . $valu->message_sender_attachment;
                                    if (unlink($delete_attach_array)) {
                                        foreach ($delete_msg_id as $val) {
                                            $deleted_id = $val->message_id;
                                            $deleted_person_id = $val->person_id;
                                        }
                                        $deleted_id_array = explode(",", $deleted_person_id);
                                        if (!in_array($user_id, $deleted_id_array)) {

                                            $deleted_id_temp = $deleted_person_id . "," . $user_id;
                                            $this->message_model->update_for_deleted_id($deleted_id_temp, $reply_msg_id[$i]);
                                        }
                                    }
                                } else if (in_array($user_id, $receiver_id)) {
                                    $attach_recver_index = array_search($user_id, $receiver_id);
                                    $attach = explode(",", $valu->message_receiver_attachment);
                                    $att_file = $attach[$attach_recver_index];
                                    $delete_attach_array = 'content-library/' . $profile_url->url . '/' . $att_file;
                                    if (unlink($delete_attach_array)) {
                                        foreach ($delete_msg_id as $val) {
                                            $deleted_id = $val->message_id;
                                            $deleted_person_id = $val->person_id;
                                        }
                                        $deleted_id_array = explode(",", $deleted_person_id);
                                        if (!in_array($user_id, $deleted_id_array)) {
                                            $deleted_id_temp = $deleted_person_id . "," . $user_id;
                                            $this->message_model->update_for_deleted_id($deleted_id_temp, $reply_msg_id[$i]);
                                        }
                                    }
                                }
                            }
                        } else {
                            foreach ($delete_msg_id as $val) {
                                $deleted_id = $val->message_id;
                                $deleted_person_id = $val->person_id;
                            }
                            $deleted_id_array = explode(",", $deleted_person_id);
                            if (!in_array($user_id, $deleted_id_array)) {

                                $deleted_id_temp = $deleted_person_id . "," . $user_id;
                                $this->message_model->update_for_deleted_id($deleted_id_temp, $reply_msg_id[$i]);
                            }
                        }
                    }
                }
            }/// $get_reply_message_parent if
            else {
                $delete_msg_id = $this->message_model->delete_single_msg($msg_id_array[$i]);
                $msg_details = $this->message_model->select_msg_table_data($msg_id_array[$i]);
                $msg_attach = $this->message_model->select_msg_attach($msg_id_array[$i]);
                if (!$delete_msg_id) {
                    if ($msg_attach) {
                        foreach ($msg_attach as $valu) {
                            $valu->message_sender_attachment;
                            $receiver_id = explode(",", $msg_details->receiver_id);
                            $sender_id = $msg_details->sender_id;
                            if ($user_id == $sender_id) {
                                $delete_attach_array = 'content-library/' . $profile_url->url . '/' . $valu->message_sender_attachment;
                                if (unlink($delete_attach_array)) {
                                    $this->message_model->insert_deleted_id($msg_id_array[$i]);
                                }
                            } else if (in_array($user_id, $receiver_id)) {
                                $attach_recver_index = array_search($user_id, $receiver_id);
                                $attach = explode(",", $valu->message_receiver_attachment);
                                $att_file = $attach[$attach_recver_index];
                                $delete_attach_array = 'content-library/' . $profile_url->url . '/' . $att_file;
                                if (unlink($delete_attach_array)) {
                                    $this->message_model->insert_deleted_id($msg_id_array[$i]);
                                }
                            }
                        }
                    } else {
                        $this->message_model->insert_deleted_id($msg_id_array[$i]);
                    }
                } else {
                    if ($msg_attach) {
                        foreach ($msg_attach as $valu) {
                            $valu->message_sender_attachment;
                            $receiver_id = explode(",", $msg_details->receiver_id);
                            $sender_id = $msg_details->sender_id;
                            if ($user_id == $sender_id) {
                                $delete_attach_array = 'content-library/' . $profile_url->url . '/' . $valu->message_sender_attachment;
                                if (unlink($delete_attach_array)) {
                                    foreach ($delete_msg_id as $val) {
                                        $deleted_id = $val->message_id;
                                        $deleted_person_id = $val->person_id;
                                    }
                                    $deleted_id_array = explode(",", $deleted_person_id);
                                    if (!in_array($user_id, $deleted_id_array)) {
                                        $deleted_id_temp = $deleted_person_id . "," . $user_id;
                                        $this->message_model->update_for_deleted_id($deleted_id_temp, $msg_id_array[$i]);
                                    }
                                }
                            } else if (in_array($user_id, $receiver_id)) {
                                $attach_recver_index = array_search($user_id, $receiver_id);
                                $attach = explode(",", $valu->message_receiver_attachment);
                                $att_file = $attach[$attach_recver_index];
                                $delete_attach_array = 'content-library/' . $profile_url->url . '/' . $att_file;
                                if (unlink($delete_attach_array)) {
                                    foreach ($delete_msg_id as $val) {
                                        $deleted_id = $val->message_id;
                                        $deleted_person_id = $val->person_id;
                                    }
                                    $deleted_id_array = explode(",", $deleted_person_id);
                                    if (!in_array($user_id, $deleted_id_array)) {

                                        $deleted_id_temp = $deleted_person_id . "," . $user_id;
                                        $this->message_model->update_for_deleted_id($deleted_id_temp, $msg_id_array[$i]);
                                    }
                                }
                            }
                        }
                    } else {
                        foreach ($delete_msg_id as $val) {
                            $deleted_id = $val->message_id;
                            $deleted_person_id = $val->person_id;
                        }
                        $deleted_id_array = explode(",", $deleted_person_id);
                        if (!in_array($user_id, $deleted_id_array)) {
                            $deleted_id_temp = $deleted_person_id . "," . $user_id;
                            $this->message_model->update_for_deleted_id($deleted_id_temp, $msg_id_array[$i]);
                        }
                    }
                }
            }/// $get_reply_message_parent else
        } else {

            $delete_msg_id = $this->message_model->delete_single_msg($message_id);
            $msg_details = $this->message_model->select_msg_table_data($message_id);
            $msg_attach = $this->message_model->select_msg_attach($message_id);
            if (!$delete_msg_id) {
                if ($msg_attach) {
                    foreach ($msg_attach as $valu) {
                        $valu->message_sender_attachment;
                        $receiver_id = explode(",", $msg_details->receiver_id);
                        $sender_id = $msg_details->sender_id;
                        if ($user_id == $sender_id) {

                            $delete_attach_array = 'content-library/' . $profile_url->url . '/' . $valu->message_sender_attachment;
                            if (unlink($delete_attach_array)) {
                                $this->message_model->insert_deleted_id($message_id);
                            }
                        } else if (in_array($user_id, $receiver_id)) {

                            $attach_recver_index = array_search($user_id, $receiver_id);
                            $attach = explode(",", $valu->message_receiver_attachment);
                            $att_file = $attach[$attach_recver_index];
                            $delete_attach_array = 'content-library/' . $profile_url->url . '/' . $att_file;
                            if (unlink($delete_attach_array)) {
                                $this->message_model->insert_deleted_id($message_id);
                            }
                        }
                    }
                } else {
                    $this->message_model->insert_deleted_id($message_id);
                }
            } else {
                if ($msg_attach) {
                    foreach ($msg_attach as $valu) {
                        $valu->message_sender_attachment;
                        $receiver_id = explode(",", $msg_details->receiver_id);
                        $sender_id = $msg_details->sender_id;
                        if ($user_id == $sender_id) {
                            $delete_attach_array = 'content-library/' . $profile_url->url . '/' . $valu->message_sender_attachment;
                            if (unlink($delete_attach_array)) {
                                foreach ($delete_msg_id as $val) {
                                    $deleted_id = $val->message_id;
                                    $deleted_person_id = $val->person_id;
                                }
                                $deleted_id_array = explode(",", $deleted_person_id);
                                if (!in_array($user_id, $deleted_id_array)) {
                                    $deleted_id_temp = $deleted_person_id . "," . $user_id;
                                    $this->message_model->update_for_deleted_id($deleted_id_temp, $message_id);
                                }
                            }
                        } else if (in_array($user_id, $receiver_id)) {
                            $attach_recver_index = array_search($user_id, $receiver_id);
                            $attach = explode(",", $valu->message_receiver_attachment);
                            $att_file = $attach[$attach_recver_index];
                            $delete_attach_array = file_get_contents('content-library/' . $profile_url->url . '/' . $att_file);
                            if (unlink($delete_attach_array)) {
                                foreach ($delete_msg_id as $val) {
                                    $deleted_id = $val->message_id;
                                    $deleted_person_id = $val->person_id;
                                }
                                $deleted_id_array = explode(",", $deleted_person_id);
                                if (!in_array($user_id, $deleted_id_array)) {
                                    $deleted_id_temp = $deleted_person_id . "," . $user_id;
                                    $this->message_model->update_for_deleted_id($deleted_id_temp, $message_id);
                                }
                            }
                        }
                    }
                } else {
                    foreach ($delete_msg_id as $val) {
                        $deleted_id = $val->message_id;
                        $deleted_person_id = $val->person_id;
                    }
                    $deleted_id_array = explode(",", $deleted_person_id);
                    if (!in_array($user_id, $deleted_id_array)) {
                        $deleted_id_temp = $deleted_person_id . "," . $user_id;
                        $this->message_model->update_for_deleted_id($deleted_id_temp, $message_id);
                    }
                }
            }
        }
        echo 'redirect';
    }

    public function remove_send_selected_msg() {
        $msg_ids = $this->input->post("message_id");
        $msg_id_array = explode(",", $msg_ids);
        $user_id = $this->session->userdata('user_id');
        $profile_url = $this->post_model->get_profile_url($user_id);
        for ($i = 0; $i < count($msg_id_array); $i++) {
            $get_reply = $this->message_model->select_reply_exits($msg_id_array[$i]);
            if ($get_reply) {
                $get_reply_message_parent = $this->message_model->select_reply_message_for_delete($msg_id_array[$i]);
                if ($get_reply_message_parent) {
                    $id = explode(",", $get_reply_message_parent);
                    if ($id[count($id) - 1] == '') {
                        array_pop($id);
                    }
                    $id1 = min($id);
                    $get_reply_message_all = $this->message_model->select_msg_for_reply_message($id1);
                    $get_reply_message_all1 = explode(",", $get_reply_message_all);
                    $get_reply_message_all2 = array_unique($get_reply_message_all1);
                    $get_reply_message = implode(",", $get_reply_message_all2);
                    $reply_msg_id = explode(",", $get_reply_message);
                    if ($reply_msg_id[count($reply_msg_id) - 1] == '') {
                        array_pop($reply_msg_id);
                    }
                    for ($j = 0; $j < count($reply_msg_id); $j++) {
                        $delete_msg_id = $this->message_model->delete_single_msg($reply_msg_id[$j]);
                        $msg_details = $this->message_model->select_msg_table_data($reply_msg_id[$j]);
                        $msg_attach = $this->message_model->select_msg_attach($reply_msg_id[$j]);
                        if (!$delete_msg_id) {
                            if ($msg_attach) {
                                foreach ($msg_attach as $valu) {
                                    $valu->message_sender_attachment;
                                    $receiver_id = explode(",", $msg_details->receiver_id);
                                    $sender_id = $msg_details->sender_id;
                                    if ($user_id == $sender_id) {
                                        $delete_attach_array = 'content-library/' . $profile_url->url . '/' . $valu->message_sender_attachment;
                                        if (unlink($delete_attach_array)) {
                                            $this->message_model->insert_deleted_id($reply_msg_id[$j]);
                                        }
                                    } else if (in_array($user_id, $receiver_id)) {
                                        $attach_recver_index = array_search($user_id, $receiver_id);
                                        $attach = explode(",", $valu->message_receiver_attachment);
                                        $att_file = $attach[$attach_recver_index];
                                        $delete_attach_array = 'content-library/' . $profile_url->url . '/' . $att_file;
                                        if (unlink($delete_attach_array)) {
                                            $this->message_model->insert_deleted_id($reply_msg_id[$j]);
                                        }
                                    }
                                }
                            } else {
                                $this->message_model->insert_deleted_id($msg_id_array[$i]);
                            }
                        } else {
                            if ($msg_attach) {
                                foreach ($msg_attach as $valu) {
                                    $valu->message_sender_attachment;
                                    $receiver_id = explode(",", $msg_details->receiver_id);
                                    $sender_id = $msg_details->sender_id;
                                    if ($user_id == $sender_id) {
                                        $delete_attach_array = 'content-library/' . $profile_url->url . '/' . $valu->message_sender_attachment;
                                        if (unlink($delete_attach_array)) {
                                            foreach ($delete_msg_id as $val) {
                                                $deleted_id = $val->message_id;
                                                $deleted_person_id = $val->person_id;
                                            }
                                            $deleted_id_array = explode(",", $deleted_person_id);
                                            if (!in_array($user_id, $deleted_id_array)) {
                                                $deleted_id_temp = $deleted_person_id . "," . $user_id;
                                                $this->message_model->update_for_deleted_id($deleted_id_temp, $reply_msg_id[$j]);
                                            }
                                        }
                                    } else if (in_array($user_id, $receiver_id)) {
                                        $attach_recver_index = array_search($user_id, $receiver_id);
                                        $attach = explode(",", $valu->message_receiver_attachment);
                                        $att_file = $attach[$attach_recver_index];
                                        $delete_attach_array = 'content-library/' . $profile_url->url . '/' . $att_file;
                                        if (unlink($delete_attach_array)) {
                                            foreach ($delete_msg_id as $val) {
                                                $deleted_id = $val->message_id;
                                                $deleted_person_id = $val->person_id;
                                            }
                                            $deleted_id_array = explode(",", $deleted_person_id);
                                            if (!in_array($user_id, $deleted_id_array)) {

                                                $deleted_id_temp = $deleted_person_id . "," . $user_id;
                                                $this->message_model->update_for_deleted_id($deleted_id_temp, $reply_msg_id[$j]);
                                            }
                                        }
                                    }
                                }
                            } else {
                                foreach ($delete_msg_id as $val) {
                                    $deleted_id = $val->message_id;
                                    $deleted_person_id = $val->person_id;
                                }
                                $deleted_id_array = explode(",", $deleted_person_id);
                                if (!in_array($user_id, $deleted_id_array)) {
                                    $deleted_id_temp = $deleted_person_id . "," . $user_id;
                                    $this->message_model->update_for_deleted_id($deleted_id_temp, $reply_msg_id[$j]);
                                }
                            }
                        }
                    }//loop end $j
                } else {
                    $delete_msg_id = $this->message_model->delete_single_msg($msg_id_array[$i]);
                    $msg_details = $this->message_model->select_msg_table_data($msg_id_array[$i]);
                    $msg_attach = $this->message_model->select_msg_attach($msg_id_array[$i]);
                    if (!$delete_msg_id) {
                        if ($msg_attach) {
                            foreach ($msg_attach as $valu) {
                                $valu->message_sender_attachment;
                                $receiver_id = explode(",", $msg_details->receiver_id);
                                $sender_id = $msg_details->sender_id;
                                if ($user_id == $sender_id) {
                                    $delete_attach_array = 'content-library/' . $profile_url->url . '/' . $valu->message_sender_attachment;
                                    if (unlink($delete_attach_array)) {
                                        $this->message_model->insert_deleted_id($msg_id_array[$i]);
                                    }
                                } else if (in_array($user_id, $receiver_id)) {
                                    $attach_recver_index = array_search($user_id, $receiver_id);
                                    $attach = explode(",", $valu->message_receiver_attachment);
                                    $att_file = $attach[$attach_recver_index];
                                    $delete_attach_array = 'content-library/' . $profile_url->url . '/' . $att_file;
                                    if (unlink($delete_attach_array)) {
                                        $this->message_model->insert_deleted_id($msg_id_array[$i]);
                                    }
                                }
                            }
                        } else {
                            $this->message_model->insert_deleted_id($msg_id_array[$i]);
                        }
                    } else {
                        if ($msg_attach) {
                            foreach ($msg_attach as $valu) {
                                $valu->message_sender_attachment;
                                $receiver_id = explode(",", $msg_details->receiver_id);
                                $sender_id = $msg_details->sender_id;
                                if ($user_id == $sender_id) {
                                    $delete_attach_array = 'content-library/' . $profile_url->url . '/' . $valu->message_sender_attachment;
                                    if (unlink($delete_attach_array)) {
                                        foreach ($delete_msg_id as $val) {
                                            $deleted_id = $val->message_id;
                                            $deleted_person_id = $val->person_id;
                                        }
                                        $deleted_id_array = explode(",", $deleted_person_id);
                                        if (!in_array($user_id, $deleted_id_array)) {
                                            $deleted_id_temp = $deleted_person_id . "," . $user_id;
                                            $this->message_model->update_for_deleted_id($deleted_id_temp, $msg_id_array[$i]);
                                        }
                                    }
                                } else if (in_array($user_id, $receiver_id)) {
                                    $attach_recver_index = array_search($user_id, $receiver_id);
                                    $attach = explode(",", $valu->message_receiver_attachment);
                                    $att_file = $attach[$attach_recver_index];
                                    $delete_attach_array = 'content-library/' . $profile_url->url . '/' . $att_file;
                                    if (unlink($delete_attach_array)) {
                                        foreach ($delete_msg_id as $val) {
                                            $deleted_id = $val->message_id;
                                            $deleted_person_id = $val->person_id;
                                        }
                                        $deleted_id_array = explode(",", $deleted_person_id);
                                        if (!in_array($user_id, $deleted_id_array)) {
                                            $deleted_id_temp = $deleted_person_id . "," . $user_id;
                                            $this->message_model->update_for_deleted_id($deleted_id_temp, $msg_id_array[$i]);
                                        }
                                    }
                                }
                            }
                        } else {
                            foreach ($delete_msg_id as $val) {
                                $deleted_id = $val->message_id;
                                $deleted_person_id = $val->person_id;
                            }
                            $deleted_id_array = explode(",", $deleted_person_id);
                            if (!in_array($user_id, $deleted_id_array)) {
                                $deleted_id_temp = $deleted_person_id . "," . $user_id;
                                $this->message_model->update_for_deleted_id($deleted_id_temp, $msg_id_array[$i]);
                            }
                        }
                    }
                }// $get_reply_message_parent else e3nd
            }//if get reply
            //if get reply else
            else {
                $delete_msg_id = $this->message_model->delete_single_msg($msg_id_array[$i]);
                $msg_details = $this->message_model->select_msg_table_data($msg_id_array[$i]);
                $msg_attach = $this->message_model->select_msg_attach($msg_id_array[$i]);
                if (!$delete_msg_id) {
                    if ($msg_attach) {
                        foreach ($msg_attach as $valu) {
                            $valu->message_sender_attachment;
                            $receiver_id = explode(",", $msg_details->receiver_id);
                            $sender_id = $msg_details->sender_id;
                            if ($user_id == $sender_id) {
                                $delete_attach_array = 'content-library/' . $profile_url->url . '/' . $valu->message_sender_attachment;
                                if (unlink($delete_attach_array)) {
                                    $this->message_model->insert_deleted_id($msg_id_array[$i]);
                                }
                            } else if (in_array($user_id, $receiver_id)) {
                                $attach_recver_index = array_search($user_id, $receiver_id);
                                $attach = explode(",", $valu->message_receiver_attachment);
                                $att_file = $attach[$attach_recver_index];
                                $delete_attach_array = 'content-library/' . $profile_url->url . '/' . $att_file;
                                if (unlink($delete_attach_array)) {
                                    $this->message_model->insert_deleted_id($msg_id_array[$i]);
                                }
                            }
                        }
                    } else {
                        $this->message_model->insert_deleted_id($msg_id_array[$i]);
                    }
                } else {
                    if ($msg_attach) {
                        foreach ($msg_attach as $valu) {
                            $valu->message_sender_attachment;
                            $receiver_id = explode(",", $msg_details->receiver_id);
                            $sender_id = $msg_details->sender_id;
                            if ($user_id == $sender_id) {
                                $delete_attach_array = 'content-library/' . $profile_url->url . '/' . $valu->message_sender_attachment;
                                if (unlink($delete_attach_array)) {
                                    foreach ($delete_msg_id as $val) {
                                        $deleted_id = $val->message_id;
                                        $deleted_person_id = $val->person_id;
                                    }
                                    $deleted_id_array = explode(",", $deleted_person_id);
                                    if (!in_array($user_id, $deleted_id_array)) {
                                        $deleted_id_temp = $deleted_person_id . "," . $user_id;
                                        $this->message_model->update_for_deleted_id($deleted_id_temp, $msg_id_array[$i]);
                                    }
                                }
                            } else if (in_array($user_id, $receiver_id)) {
                                $attach_recver_index = array_search($user_id, $receiver_id);
                                $attach = explode(",", $valu->message_receiver_attachment);
                                $att_file = $attach[$attach_recver_index];
                                $delete_attach_array = 'content-library/' . $profile_url->url . '/' . $att_file;
                                if (unlink($delete_attach_array)) {
                                    foreach ($delete_msg_id as $val) {
                                        $deleted_id = $val->message_id;
                                        $deleted_person_id = $val->person_id;
                                    }
                                    $deleted_id_array = explode(",", $deleted_person_id);
                                    if (!in_array($user_id, $deleted_id_array)) {
                                        $deleted_id_temp = $deleted_person_id . "," . $user_id;
                                        $this->message_model->update_for_deleted_id($deleted_id_temp, $msg_id_array[$i]);
                                    }
                                }
                            }
                        }
                    } else {
                        foreach ($delete_msg_id as $val) {
                            $deleted_id = $val->message_id;
                            $deleted_person_id = $val->person_id;
                        }
                        $deleted_id_array = explode(",", $deleted_person_id);
                        if (!in_array($user_id, $deleted_id_array)) {
                            $deleted_id_temp = $deleted_person_id . "," . $user_id;
                            $this->message_model->update_for_deleted_id($deleted_id_temp, $msg_id_array[$i]);
                        }
                    }
                }
            }//else get reply
        }//loop end for $i
        echo 'redirect';
    }
// end of sent msg//
    
    public function reply_received_message($id) {
        $sdata = array();
        $sdata['message_id'] = $id;
        $this->session->set_userdata($sdata);
        redirect("reply-message");
    }

    public function reply_message() {
        $data = array();
        $message_id = $this->session->userdata("message_id");
        $decode_message_id = str_replace("%F2", "/", $message_id);
        $message_id1 = $this->encrypt->decode($decode_message_id);
        if (!$message_id1) {
            redirect("receive-message");
        }

// Right Sidebar Content Information
        $right_side_content = array('FALSE');
        $data = $this->populate_right_side($right_side_content);
        $person_id = $this->session->userdata('user_id');
        $data['active_menu'] = $this->session->userdata('active_menu');
        $data['active_sub_menu'] = $this->session->userdata('active_sub_menu');
        $data['left_side_menu_view'] = 1;
        $data['left_side'] = 1;
        $data['link_person'] = $this->user_course_model->select_link_person($person_id);
        foreach ($data['link_person'] as $v_link) {
            if ($v_link->person_id != $person_id) {
                $data['link_person_info'][$v_link->person_link_id] = $this->profile_model->person_info_by_person_id($v_link->person_id);
            } else if ($v_link->requested_person_id != $person_id) {
                $data['link_person_info'][$v_link->person_link_id] = $this->profile_model->person_info_by_person_id($v_link->requested_person_id);
            }
        }
        $preview_rcv = $this->message_model->select_rcv_message_details_by_message_id_for_reply($message_id1);
        foreach ($preview_rcv as $val_view) {
            if ($val_view->message_viewer_id == "") {
                $this->message_model->viewer_id_for_msg_no_viwer_earlier($message_id1, $person_id);
            } else if ($val_view->message_viewer_id != "") {
                $view_id_temp = $val_view->message_viewer_id;
                $view_id_temp_array = explode(",", $view_id_temp);
                if (!in_array($person_id, $view_id_temp_array)) {
                    $viewer_id = $val_view->message_viewer_id . "," . $person_id;
                    $this->message_model->viewer_id_for_msg($message_id1, $viewer_id);
                }
            }
        }
        $data["preview_rcv_message"] = $this->message_model->select_rcv_message_details_by_message_id_for_reply($message_id1);
        foreach ($data["preview_rcv_message"] as $val) {
            $data['preview_rcv_message_attachment'][$val->message_id] = $this->message_model->select_all_data_from_message_tbl_attachment_for_sender($val->message_id);
            $sender_id = $val->sender_id;
            $receiver_id = $val->receiver_id;
            $receiver_id_in_array = explode(",", $receiver_id);
            $only_receiver_id = implode(",", $receiver_id_in_array);
            foreach ($data['preview_rcv_message_attachment'][$val->message_id] as $attach_value) {
                if ($val->message_id == $attach_value->message_id) {
                    $total_rcv_attach = $attach_value->message_receiver_attachment;
                    $attach_index = array_search($person_id, $receiver_id_in_array);
                    $total_rcv_attach_array = explode(",", $total_rcv_attach);
                    if ($total_rcv_attach_array[count($total_rcv_attach_array) - 1] == '') {
                        array_pop($total_rcv_attach_array);
                    }
                    $data['total_rcv_attach_array'] = $total_rcv_attach_array[$attach_index];
                }
            }
        }
        $data["message_sender_info"] = $this->message_model->preview_message_reply_sender_info($sender_id);
        $data["message_receiver_info"] = $this->message_model->preview_message_receiver_reply_id_info($only_receiver_id);
        $data["message_receiver_single_info"] = $this->message_model->preview_message_receiver_reply_id_single_info($only_receiver_id);
        $data['main_content'] = $this->load->view('user/message/reply_message_form', $data, true);
        $this->load->view('user/master', $data);
    }

    public function remove_draft_selected_msg() {
        $message_id = $this->input->post("message_id", TRUE);
        $message_id_array = explode(",", $message_id);
        if ($message_id_array[count($message_id_array) - 1] == '') {
            array_pop($message_id_array);
        }
        for ($i = 0; $i < count($message_id_array); $i++) {
            $selec_all_attachment = $this->message_model->select_all_message_from_tbl_message_attachment($message_id_array[$i]);
            if ($selec_all_attachment) {
                foreach ($selec_all_attachment as $val) {
                    $path = $val->message_sender_attachment;
                    $user_id = $this->session->userdata('user_id');
                    $profile_url2 = $this->post_model->get_profile_url($user_id);
                    $folder = 'content-library/' . $profile_url2->url . "/" . $path;
                    if (unlink($folder)) {
                        $this->message_model->delete_draft_message_attachemnt($val->message_attachmen_id, $message_id_array[$i]);
                    }
                }
            }
        }
        $this->message_model->delete_draft_message($message_id, $message_id_array);
    }

    public function reply_received_message_sender($id) {
        $sdata = array();
        $sdata['message_id'] = $id;
        $this->session->set_userdata($sdata);
        redirect("reply-message-sender");
    }

    public function reply_message_sender() {
        $data = array();
        $message_id = $this->session->userdata("message_id");
        $decode_message_id = str_replace("%F2", "/", $message_id);
        $message_id1 = $this->encrypt->decode($decode_message_id);
        if (!$message_id1) {
            redirect("receive-message");
        }

// Right Sidebar Content Information
        $right_side_content = array('FALSE');
        $data = $this->populate_right_side($right_side_content);
        $person_id = $this->session->userdata('user_id');
        $data['active_menu'] = $this->session->userdata('active_menu');
        $data['active_sub_menu'] = $this->session->userdata('active_sub_menu');
        $data['left_side_menu_view'] = 1;
        $data['left_side'] = 1;
        $data['link_person'] = $this->user_course_model->select_link_person($person_id);
        foreach ($data['link_person'] as $v_link) {
            if ($v_link->person_id != $person_id) {
                $data['link_person_info'][$v_link->person_link_id] = $this->profile_model->person_info_by_person_id($v_link->person_id);
            } else if ($v_link->requested_person_id != $person_id) {
                $data['link_person_info'][$v_link->person_link_id] = $this->profile_model->person_info_by_person_id($v_link->requested_person_id);
            }
        }
        $preview_rcv = $this->message_model->select_rcv_message_details_by_message_id($message_id1);
        foreach ($preview_rcv as $val_view) {
            if ($val_view->message_viewer_id == "") {
                $this->message_model->viewer_id_for_msg_no_viwer_earlier($message_id1, $person_id);
            } else if ($val_view->message_viewer_id != "") {
                $view_id_temp = $val_view->message_viewer_id;
                $view_id_temp_array = explode(",", $view_id_temp);                
                if (!in_array($person_id, $view_id_temp_array)) {
                    $viewer_id = $val_view->message_viewer_id . "," . $person_id;
                    $this->message_model->viewer_id_for_msg($message_id1, $viewer_id);
                }
            }
        }
        $data["preview_rcv_message"] = $this->message_model->select_rcv_message_details_by_message_id($message_id1);
        foreach ($data["preview_rcv_message"] as $val) {
            $data['preview_rcv_message_attachment'][$val->message_id] = $this->message_model->select_all_data_from_message_tbl_attachment_for_sender($val->message_id);
            $sender_id = $val->sender_id;
            $receiver_id = $val->receiver_id;
            $receiver_id_in_array = explode(",", $receiver_id);
            foreach ($data['preview_rcv_message_attachment'][$val->message_id] as $attach_value) {
                if ($val->message_id == $attach_value->message_id) {
                    $total_rcv_attach = $attach_value->message_receiver_attachment;
                    $attach_index = array_search($person_id, $receiver_id_in_array);
                    $total_rcv_attach_array = explode(",", $total_rcv_attach);
                    if ($total_rcv_attach_array[count($total_rcv_attach_array) - 1] == '') {
                        array_pop($total_rcv_attach_array);
                    }
                    $data['total_rcv_attach_array'] = $total_rcv_attach_array[$attach_index];
                }
            }
        }
        $data["message_sender_info"] = $this->message_model->preview_message_reply_sender_info($sender_id);
        $data["message_receiver_info"] = $this->message_model->preview_message_receiver_reply_id_info($only_receiver_id);
        $data["message_receiver_single_info"] = $this->message_model->preview_message_receiver_reply_id_single_info($only_receiver_id);
        $data['main_content'] = $this->load->view('user/message/reply_message_form_sender', $data, true);
        $this->load->view('user/master', $data);
    }

    public function email_id_for_reply() {
        $receiver_id = array();
        $flag = 1;
        //check whether the receivers are in your list or not
        $email_address = $this->input->post('email_address', TRUE);
        $message_id = $this->input->post("message_id");
        $message_id_old = $this->input->post("message_id_old");
        $email_array = explode(",", $email_address);
        if ($email_array[count($email_array) - 1] == '') {
            array_pop($email_array);
        }        
        $count = count($email_array);
        for ($i = 0; $i < $count; $i++) {
            $id = $this->message_model->get_reciever_person_id($email_array[$i]);
            if ($id) {
                $receiver_id[] = $id;                
            } else {
                echo "e_a";
            }
        }
        $receiver_id_array = implode(",", $receiver_id);
        $user_id = $this->session->userdata('user_id');
        $check_result = $this->message_model->check_person_linked($user_id);
        $check_person_id = array();
        $check_requested_person_id = array();
        foreach ($check_result as $value) {
            $check_person_id[] = $value->person_id;
        }
        foreach ($check_result as $value) {
            $check_requested_person_id[] = $value->requested_person_id;
        }
        if ($message_id) {
            $insert_id = $this->message_model->insert_email_info_into_table_by_message_id($message_id, $user_id, $receiver_id_array);
            $reply_id = $this->message_model->insert_message_reply_tbl($insert_id, $message_id_old);
        } else if (!$message_id) {
            $insert_id = $this->message_model->insert_email_info_into_table_without_message_id($user_id, $receiver_id_array);
        }
        echo $insert_id;
    }

    public function message_body_for_reply() {
        $message_body = $this->input->post('message_body', TRUE);
        $user_id = $this->session->userdata('user_id');
        $message_id = $this->input->post('message_id');
        $message_id1 = $this->message_model->save_message_body_draft_value($message_id, $message_body, $user_id);
        echo $message_id1;
    }

    public function reply_msg_send() {
        $receiver_id = array();
        $flag = 1;
        //check whether the receivers are in your list or not
        $email_address = $this->input->post('email_address', TRUE);
        $message_id = $this->input->post('message_id', TRUE);
        $message_id_old = $this->input->post("message_id_old");
        $email_array = explode(",", $email_address);
        if ($email_array[count($email_array) - 1] == '') {
            array_pop($email_array);
        }
        $count = count($email_array);
        for ($i = 0; $i < $count; $i++) {
            $receiver_id[] = $this->message_model->get_reciever_person_id($email_array[$i]);
        }
        $receiver_id_array = implode(",", $receiver_id);
        $user_id = $this->session->userdata('user_id');
        $check_result = $this->message_model->check_person_linked($user_id);
        $check_person_id = array();
        $check_requested_person_id = array();
        foreach ($check_result as $value) {
            $check_person_id[] = $value->person_id;
        }
        foreach ($check_result as $value) {
            $check_requested_person_id[] = $value->requested_person_id;
        }
        $get_linked_person_email = $this->message_model->recieve_email_by_person_id($check_person_id, $check_requested_person_id);
        $linked_person = array();
        foreach ($get_linked_person_email as $value) {
            $linked_person[] = $value->person_id;
        }
        $source_path = array();
        $message_attachmen_id = array();
        $message_attachment_original_name = array();
        $message_attachment_detail = $this->message_model->select_all_attachment_for_one_id($message_id);
        foreach ($message_attachment_detail as $val) {
            $source_path[] = $val->message_sender_attachment;
            $message_attachmen_id[] = $val->message_attachmen_id;
            $message_attachment_original_name[] = $val->message_attachment_original_name;
        }
        if ($message_attachment_original_name) {
            for ($j = 0, $k = 0; $j < count($source_path), $k < count($message_attachmen_id); $j++, $k++) {
                $new_file_path = "";
                for ($i = 0; $i < count($receiver_id); $i++) {
                    $profile_url = $this->post_model->get_profile_url($receiver_id[$i]);                    
                    $profile_url2 = $this->post_model->get_profile_url($user_id);
                    $folder2 = 'content-library/' . $profile_url2->url . "/" . $source_path[$j];
                    $new_file_name = $profile_url->url . '-' . date('h-i-s-a-m-d-Y', time()) . microtime(true);
                    $folder = 'content-library/' . $profile_url->url . '/assignment-file/';
                    $file_path = explode("/", $source_path[$j]);
                    $fileName = $file_path[count($file_path) - 1];
                    $file_explode = explode('.', $fileName);
                    $file_extention = $file_explode[count($file_explode) - 1];
                    $file_name = "$folder$new_file_name.$file_extention";
                    $target_file = $file_name;
                    if (copy("$folder2", "$target_file")) {
                        $new_file_path .= 'assignment-file/' . "$new_file_name.$file_extention" . ",";
                    }
                }
                $new_file_path .= 'assignment-file/' . "$new_file_name.$file_extention" . ",";
                $insert_result_with_attach = $this->message_model->send_draft_message($message_id, $new_file_path, $message_attachmen_id[$k]);
                $reply_id = $this->message_model->insert_message_reply_tbl($message_id, $message_id_old);
            }
            //SAVE DATA
        } else {
            $insert_result_without_attach = $this->message_model->send_draft_message_no_attachment($message_id);
            $reply_id = $this->message_model->insert_message_reply_tbl($message_id, $message_id_old);
        }
        echo '911';
    }

    public function draft_message() {
        $data = array();

// Right Sidebar Content Information
        $right_side_content = array('FALSE');
        $data = $this->populate_right_side($right_side_content);
        $person_id = $this->session->userdata('user_id');
        $data['active_menu'] = $this->session->userdata('active_menu');
        $data['active_sub_menu'] = "DraftMessage";
        $data['left_side_menu_view'] = 1;
        $data['left_side'] = 1;
        $data['draft_message'] = $this->message_model->select_all_data_from_message_tbl_for_draft();
        foreach ($data['draft_message']as $val) {
            $data['draft_message_attachment'][$val->message_id] = $this->message_model->select_all_data_from_message_tbl_attachment_for_draft($val->message_id);
        }
        $data['main_content'] = $this->load->view('user/message/draft_message', $data, true);
        $this->load->view('user/master', $data);
    }

    public function view_draft($message_id) {
        $sdata = array();
        $sdata['message_id'] = $message_id;
        $this->session->set_userdata($sdata);
        redirect('edit-draft-message');
    }

    public function draft_message_send() {
        $data = array();
        $message_id = $this->session->userdata("message_id");
        $decode_message_id = str_replace("%F2", "/", $message_id);
        $message_id1 = $this->encrypt->decode($decode_message_id);
        if (!$message_id) {
            redirect("draft-message");
        }
// Right Sidebar Content Information
        $right_side_content = array('FALSE');
        $data = $this->populate_right_side($right_side_content);
        $person_id = $this->session->userdata('user_id');
        $data['active_menu'] = $this->session->userdata('active_menu');
        $data['active_sub_menu'] = $this->session->userdata('active_sub_menu');
        $data['left_side_menu_view'] = 1;
        $data['left_side'] = 1;
        $data['link_person'] = $this->user_course_model->select_link_person($person_id);
        foreach ($data['link_person'] as $v_link) {
            if ($v_link->person_id != $person_id) {
                $data['link_person_info'][$v_link->person_link_id] = $this->profile_model->person_info_by_person_id($v_link->person_id);
            } else if ($v_link->requested_person_id != $person_id) {
                $data['link_person_info'][$v_link->person_link_id] = $this->profile_model->person_info_by_person_id($v_link->requested_person_id);
            }
        }
        $data["message_id"] = $message_id1;
        $data['edit_draft_message'] = $this->message_model->select_message_details_by_message_id($message_id1);
        foreach ($data['edit_draft_message'] as $val) {
            $data['edit_draft_message_attachment'][$val->message_id] = $this->message_model->select_all_data_from_message_tbl_attachment_for_sender($val->message_id);
            $sender_id = $val->sender_id;
            $receiver_id = $val->receiver_id;
        }
        $data["message_sender_info"] = $this->message_model->preview_message_sender_info($sender_id);
        if ($receiver_id) {
            $data["message_receiver_info"] = $this->message_model->preview_message_receiver_id_info($receiver_id);
        }
        $data['main_content'] = $this->load->view('user/message/draft_message_form', $data, true);
        $this->load->view('user/master', $data);
        $this->session->unset_userdata("message_id");
    }

    //draft_message_email
    public function draft_email_id() {
        $receiver_id = array();
        $flag = 1;
        //check whether the receivers are in your list or not
        $email_address = $this->input->post('email_address', TRUE);
        $email_array = explode(",", $email_address);
        if ($email_array[count($email_array) - 1] == '') {
            array_pop($email_array);
        }
        $count = count($email_array);
        for ($i = 0; $i < $count; $i++) {
            $id = $this->message_model->get_reciever_person_id($email_array[$i]);
            if ($id) {
                $receiver_id[] = $id;
            } else {
                echo "3";
            }
        }
        $receiver_id_array = implode(",", $receiver_id);
        $user_id = $this->session->userdata('user_id');
        $check_result = $this->message_model->check_person_linked($user_id);
        $check_person_id = array();
        $check_requested_person_id = array();
        foreach ($check_result as $value) {
            $check_person_id[] = $value->person_id;
        }

        foreach ($check_result as $value) {
            $check_requested_person_id[] = $value->requested_person_id;
        }
        $get_linked_person_email = $this->message_model->recieve_email_by_person_id($check_person_id, $check_requested_person_id);
        $linked_person = array();
        foreach ($get_linked_person_email as $value) {
            $linked_person[] = $value->person_id;
        }
        $temp = 0;
        for ($i = 0; $i < count($receiver_id); $i++) {
            if (in_array($receiver_id[$i], $linked_person)) {
                $temp = 1;
            } else {
                $temp = 2;
            }
        }
        $message_id = $this->input->post("message_id");

        if ($temp == 1) {
//upload_files are moved to the reciever's content library
            if ($message_id) {
                $insert_id = $this->message_model->insert_email_info_into_table_by_message_id($message_id, $user_id, $receiver_id_array);
            }
        } elseif ($temp == 2) {
            echo "Please Enter Email Address From Your Link ";
        }
    }

    public function draft_message_body() {
        $message_body = $this->input->post('message_body', TRUE);
        $user_id = $this->session->userdata('user_id');
        $message_id = $this->input->post("message_id");
        $message_id1 = $this->message_model->save_message_body_draft_value($message_id, $message_body, $user_id);
    }

    public function draft_message_submit() {
        $receiver_id = array();
        $flag = 1;
        //check whether the receivers are in your list or not
        $email_address = $this->input->post('email_address', TRUE);
        $message_id = $this->input->post('message_id', TRUE);
        $email_array = explode(",", $email_address);
        if ($email_array[count($email_array) - 1] == '') {
            array_pop($email_array);
        }
        $count = count($email_array);
        for ($i = 0; $i < $count; $i++) {
            $receiver_id[] = $this->message_model->get_reciever_person_id($email_array[$i]);
        }
        $receiver_id_array = implode(",", $receiver_id);
        $user_id = $this->session->userdata('user_id');
        $check_result = $this->message_model->check_person_linked($user_id);
        $check_person_id = array();
        $check_requested_person_id = array();
        foreach ($check_result as $value) {
            $check_person_id[] = $value->person_id;
        }

        foreach ($check_result as $value) {
            $check_requested_person_id[] = $value->requested_person_id;
        }
        $get_linked_person_email = $this->message_model->recieve_email_by_person_id($check_person_id, $check_requested_person_id);
        $linked_person = array();
        foreach ($get_linked_person_email as $value) {
            $linked_person[] = $value->person_id;
        }
        $temp = 0;
        for ($i = 0; $i < count($receiver_id); $i++) {
            if (in_array($receiver_id[$i], $linked_person)) {
                $temp = 1;
                continue;
            } else {
                $temp = 2;
                break;
            }
        }
        $source_path = array();
        $message_attachmen_id = array();
        $message_attachment_original_name = array();
        $message_attachment_detail = $this->message_model->select_all_attachment_for_one_id($message_id);
        foreach ($message_attachment_detail as $val) {
            $source_path[] = $val->message_sender_attachment;
            $message_attachmen_id[] = $val->message_attachmen_id;
            $message_attachment_original_name[] = $val->message_attachment_original_name;
        }
        if ($temp == 1) {
            $new_file_path = "";
            if ($message_attachment_original_name) {
                for ($j = 0, $k = 0; $j < count($source_path), $k < count($message_attachmen_id); $j++, $k++) {
                    $new_file_path = "";
                    for ($i = 0; $i < count($receiver_id); $i++) {
                        $profile_url = $this->post_model->get_profile_url($receiver_id[$i]);                        
                        $profile_url2 = $this->post_model->get_profile_url($user_id);
                        $folder2 = 'content-library/' . $profile_url2->url . "/" . $source_path[$j];
                        $new_file_name = $profile_url->url . '-' . date('h-i-s-a-m-d-Y', time()) . microtime(true);
                        $folder = 'content-library/' . $profile_url->url . '/assignment-file/';
                        $file_path = explode("/", $source_path[$j]);
                        $fileName = $file_path[count($file_path) - 1];
                        $file_explode = explode('.', $fileName);
                        $file_extention = $file_explode[count($file_explode) - 1];
                        $file_name = "$folder$new_file_name.$file_extention";
                        $target_file = $file_name;
                        if (copy("$folder2", "$target_file")) {
                            $new_file_path .= 'assignment-file/' . "$new_file_name.$file_extention" . ",";
                        }
                    }
                    $insert_result_with_attach = $this->message_model->send_draft_message($message_id, $new_file_path, $message_attachmen_id[$k]);
                }

                //SAVE DATA
            } else {
                $insert_result_without_attach = $this->message_model->send_draft_message_no_attachment($message_id);
            }
            echo '911';
        } elseif ($temp == 2) {
            echo '2';
        }
    }

    public function save_sender_message_body_for_draft() {
        $message_body = $this->input->post('message_body', TRUE);
        $user_id = $this->session->userdata('user_id');
        $message_id = $this->input->post('message_id');
        $message_id1 = $this->message_model->save_message_body_draft_value($message_id, $message_body, $user_id);
        echo $message_id1;
    }

    //files upload in only in sender id and send only sender_info in database for draft
    public function upload_message_file() {
        $user_id = $this->session->userdata('user_id');        
        $profile_url = $this->post_model->get_profile_url($user_id);
        $message_id = $this->input->post("message_id");
        $total_size = $this->input->post("total_size");
        if ($message_id) {
            $fileName = $_FILES["message_files"]["name"]; // The file name
            if ($fileName) {
                $fileTmpLoc = $_FILES["message_files"]["tmp_name"];
                if (file_get_contents($fileTmpLoc)) { // File in the PHP tmp folder
                    $fileType = $_FILES["message_files"]["type"]; // The type of file it is
                    $fileSize = $_FILES["message_files"]["size"]; // File size in bytes
                    $fileErrorMsg = $_FILES["message_files"]["error"]; // 0 for false... and 1 for true
                    $new_file_name = $profile_url->url . '-' . date('h-i-s-a-m-d-Y', time());
                    if (!$fileTmpLoc) { // if file not chosen
                        echo "ERROR: Please browse for a file before clicking the upload button.";
                    } else {
                        if ($total_size < 26214400) {
                            $folder = 'content-library/' . $profile_url->url . '/assignment-file/';
                            $target_file = $folder . $fileName;
                            if (move_uploaded_file($fileTmpLoc, $target_file)) {
                                $file_explode = explode('.', $fileName);
                                $file_extention = $file_explode[count($file_explode) - 1];
                                rename("$target_file", "$folder$new_file_name.$file_extention");
                                $file_name = "$folder$new_file_name.$file_extention";
                                $new_file_path = "assignment-file/" . "$new_file_name.$file_extention";
                                $message_attachment_tbl_id = $this->message_model->save_sender_draft_attachment_value_after_message_body($message_id, $new_file_path);
                                echo $message_attachment_tbl_id . "," . $file_name . "," . $fileName;
                            }
                        } else {
                            echo 'File size must less then 25 Mb';
                        }
                    }
                } else {
                    echo "null";
                }
            }
        } else if ($message_id == '') {
            $message_generate_id = $this->message_model->for_only_attachment_generate_message_id($user_id);

            $fileName = $_FILES["message_files"]["name"];
            if ($fileName) {
                $fileTmpLoc = $_FILES["message_files"]["tmp_name"]; // File in the PHP tmp folder
                if (file_get_contents($fileTmpLoc)) {
                    $fileType = $_FILES["message_files"]["type"]; // The type of file it is
                    $fileSize = $_FILES["message_files"]["size"]; // File size in bytes
                    $fileErrorMsg = $_FILES["message_files"]["error"]; // 0 for false... and 1 for true
                    $new_file_name = $profile_url->url . '-' . date('h-i-s-a-m-d-Y', time());
                    if (!$fileTmpLoc) { // if file not chosen
                        echo "ERROR: Please browse for a file before clicking the upload button.";
                    } else {
                        if ($total_size < 26214400) {
                            $folder = 'content-library/' . $profile_url->url . '/assignment-file/';
                            $target_file = $folder . $fileName;
                            if (move_uploaded_file($fileTmpLoc, $target_file)) {
                                $file_explode = explode('.', $fileName);
                                $file_extention = $file_explode[count($file_explode) - 1];
                                rename("$target_file", "$folder$new_file_name.$file_extention");
                                $file_name = "$folder$new_file_name.$file_extention";
                                $new_file_path = "assignment-file/" . "$new_file_name.$file_extention";
                                $message_attachment_tbl_id = $this->message_model->save_sender_draft_attachment_value_after_message_body($message_generate_id, $new_file_path);
                                echo $message_attachment_tbl_id . "," . $file_name . "," . $fileName;
                            }
                        } else {
                            echo 'File size must less then 25 Mb';
                        }
                    }
                } else {
                    echo "null";
                }
            }
        }
    }

//save email for new message
    public function save_email_for_draft() {
        $receiver_id = array();
        $flag = 1;
        //check whether the receivers are in your list or not
        $email_address = $this->input->post('email_address', TRUE);
        $message_id = $this->input->post("message_id");
        $email_array = explode(",", $email_address);
        if ($email_array[count($email_array) - 1] == '') {
            array_pop($email_array);
        }
        $count = count($email_array);
        for ($i = 0; $i < $count; $i++) {
            $id = $this->message_model->get_reciever_person_id($email_array[$i]);
            if ($id) {
                $receiver_id[] = $id;
            } else {
                echo "e_a";
            }
        }
        $receiver_id_array = implode(",", $receiver_id);
        $user_id = $this->session->userdata('user_id');
        $check_result = $this->message_model->check_person_linked($user_id);
        $check_person_id = array();
        $check_requested_person_id = array();
        foreach ($check_result as $value) {
            $check_person_id[] = $value->person_id;
        }
        foreach ($check_result as $value) {
            $check_requested_person_id[] = $value->requested_person_id;
        }
        $get_linked_person_email = $this->message_model->recieve_email_by_person_id($check_person_id, $check_requested_person_id);
        $linked_person = array();
        foreach ($get_linked_person_email as $value) {
            $linked_person[] = $value->person_id;
        }
        $temp = 0;
        for ($i = 0; $i < count($receiver_id); $i++) {
            if (in_array($receiver_id[$i], $linked_person)) {
                $temp = 1;
            } else {
                $temp = 2;
            }
        }
        if ($temp == 1) {
            if ($message_id) {
                $insert_id = $this->message_model->insert_email_info_into_table_by_message_id($message_id, $user_id, $receiver_id_array);
            } else if (!$message_id) {
                $insert_id = $this->message_model->insert_email_info_into_table_without_message_id($user_id, $receiver_id_array);
            }
            echo $insert_id;
        } elseif ($temp == 2) {
            echo "Please Enter Email Address From Your Link ";
        }
    }

    public function delete_upload_file() {
        $message_id = $this->input->post("message_id");
        $hidden_uploaded_file_path = $this->input->post("hidden_uploaded_file_path");
        $message_attachmen_id = $this->input->post("message_attachmen_id");
        if (unlink($hidden_uploaded_file_path)) {
            $this->message_model->cancel_upload_file($message_id, $message_attachmen_id);
        }
    }

    public function delete_upload_file_draft() {
        $message_id = $this->input->post("message_id");
        $hidden_uploaded_file_path2 = $this->input->post("hidden_uploaded_file_path2");
        $message_attachmen_id = $this->input->post("message_attachmen_id");
        if (unlink($hidden_uploaded_file_path2)) {
            $this->message_model->cancel_upload_file($message_id, $message_attachmen_id);
        }
    }

    public function existing_delete_upload_file_draft() {
        $user_id = $this->session->userdata('user_id');
        $profile_url = $this->post_model->get_profile_url($user_id);
        $message_id = $this->input->post("message_id");
        $hidden_uploaded_file_path = $this->input->post("hidden_uploaded_file_path");
        $message_attachmen_id = $this->input->post("message_attachmen_id_exist");
        $folder = 'content-library/' . $profile_url->url . '/' . $hidden_uploaded_file_path;
        if (unlink($folder)) {
            $this->message_model->cancel_upload_file($message_id, $message_attachmen_id);
        }
    }

    public function sent_mylinked_person_message() {
        $receiver_id = array();
        $flag = 1;
        //check whether the receivers are in your list or not
        $email_address = $this->input->post('email_address', TRUE);
        $message_id = $this->input->post('message_id', TRUE);
        $email_array = explode(",", $email_address);
        if ($email_array[count($email_array) - 1] == '') {
            array_pop($email_array);
        }
        $count = count($email_array);
        for ($i = 0; $i < $count; $i++) {
            $receiver_id[] = $this->message_model->get_reciever_person_id($email_array[$i]);
        }
        $receiver_id_array = implode(",", $receiver_id);
        $user_id = $this->session->userdata('user_id');
        $check_result = $this->message_model->check_person_linked($user_id);
        $check_person_id = array();
        $check_requested_person_id = array();
        foreach ($check_result as $value) {
            $check_person_id[] = $value->person_id;
        }
        foreach ($check_result as $value) {
            $check_requested_person_id[] = $value->requested_person_id;
        }
        $get_linked_person_email = $this->message_model->recieve_email_by_person_id($check_person_id, $check_requested_person_id);
        $linked_person = array();
        foreach ($get_linked_person_email as $value) {
            $linked_person[] = $value->person_id;
        }
        $temp = 0;
        for ($i = 0; $i < count($receiver_id); $i++) {
            if (in_array($receiver_id[$i], $linked_person)) {
                $temp = 1;
                continue;
            } else {
                $temp = 2;
                break;
            }
        }
        $source_path = array();
        $message_attachmen_id = array();
        $message_attachment_original_name = array();
        $message_attachment_detail = $this->message_model->select_all_attachment_for_one_id($message_id);
        foreach ($message_attachment_detail as $val) {
            $source_path[] = $val->message_sender_attachment;
            $message_attachmen_id[] = $val->message_attachmen_id;
            $message_attachment_original_name[] = $val->message_attachment_original_name;
        }
        if ($temp == 1) {
            if ($message_attachment_original_name) {
                for ($j = 0, $k = 0; $j < count($source_path), $k < count($message_attachmen_id); $j++, $k++) {
                    $new_file_path = "";
                    for ($i = 0; $i < count($receiver_id); $i++) {
                        $profile_url = $this->post_model->get_profile_url($receiver_id[$i]);                        
                        $profile_url2 = $this->post_model->get_profile_url($user_id);
                        $folder2 = 'content-library/' . $profile_url2->url . "/" . $source_path[$j];
                        $new_file_name = $profile_url->url . '-' . date('h-i-s-a-m-d-Y', time()) . microtime(true);
                        $folder = 'content-library/' . $profile_url->url . '/assignment-file/';
                        $file_path = explode("/", $source_path[$j]);
                        $fileName = $file_path[count($file_path) - 1];
                        $file_explode = explode('.', $fileName);
                        $file_extention = $file_explode[count($file_explode) - 1];
                        $file_name = "$folder$new_file_name.$file_extention";
                        $target_file = $file_name;
                        if (copy("$folder2", "$target_file")) {
                            $new_file_path .= 'assignment-file/' . "$new_file_name.$file_extention" . ",";
                        }
                    }
                    $insert_result_with_attach = $this->message_model->send_draft_message($message_id, $new_file_path, $message_attachmen_id[$k]);
                }
                //SAVE DATA
            } else {
                $insert_result_without_attach = $this->message_model->send_draft_message_no_attachment($message_id);
            }
            echo 1;
            //$sdata = array();
            //$sdata['sent_msg'] = "your message has been sent";
            //  $this->session->set_userdata($sdata);
        } elseif ($temp == 2) {

            // echo "Please Enter Email Address From Your Link ";
            echo 2;
        }
    }

    /*
      -----------@@@RIPON@ Start Course Message Part (03-09-2016)----------------------------------
     */

    /**
     * @Function            : course_sent_massage 
     * @Description         : validate all kind of password related condition and update password
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 03-09-2016 12:36 AM  
     * @Parameter           : NULL
     * @Return              : NULL    
     * @Status              : Available        
     * */
    function course_sent_massage() {
        $data = array();
        $p_data = $this->set_permession_message_data($data, 'course_sent_message');

        $p_data['main_content'] = $this->load->view('user/message/course_sent_message', $p_data, true);
        $this->load->view('user/master', $p_data);
    }

    /**
     * @Function            : course_received_massage 
     * @Description         : validate all kind of password related condition and update password
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 03-09-2016 12:43 AM  
     * @Parameter           : NULL
     * @Return              : NULL    
     * @Status              : Available        
     * */
    function course_received_massage() {
        $data = array();
        $p_data = $this->set_permession_message_data($data, 'course_received_message');

        $p_data['main_content'] = $this->load->view('user/message/course_received_message', $p_data, true);
        $this->load->view('user/master', $p_data);
    }

    /**
     * @Function            : set_permession_message_data 
     * @Description         : set right site permission data
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 03-09-2016 12:52 AM  
     * @Parameter           : $data, $active_sub_menu
     * @Return              : NULL    
     * @Status              : Available        
     * */
    function set_permession_message_data($data, $active_sub_menu) {
        $data['active_menu'] = $sdata['active_menu'] = 'message';
        $data['active_sub_menu'] = $sdata['active_sub_menu'] = $active_sub_menu;
        $data['active_sub_menu_item'] = $sdata['active_sub_menu_item'] = '';
        $data['left_side_menu_view'] = 1;
        $data['left_side'] = 1;
        $this->session->set_userdata($sdata);
        return $data;
    }

    /*
      -----------@@@RIPON@ End Course Message Part (03-09-2016)----------------------------------
     */
}
