<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Manage_admin_video extends CI_Controller {
    public function __construct() {
        parent::__construct();
        $this->load->library('tt_video_converter');
        $this->load->model('manage_admin_video_model');
    }
    
    /**
     * @Author              : Md. Delwar Hossain    
     * @CreatedDate         : 11-07-17   
     * @ModifiedDate        : Null
     * @ModifiedBy          : Null
     * @Route               : 'add-admin-video'
     * @Description         : Admin add video data in db 
     * @view                : manage_admin_video/add_admin_video
     * @redirect            : 'manage-admin-video'
     * @deprecated          : No
     * @exception           : 
     * @inheritDoc          : 
     * @Function            : add_admin_video_workfile() is used for insert workfile info if video has workfile
     * @Parameter           : Null
     * @Return              : Null       
     * @value               : $data pass by add_admin_video_info function for insert data in db
     * @Status              : Available
     * @version             : v2.1       
    * */
    public function add_admin_video(){
        if (!$this->input->post('save_video_workfile', TRUE)) {
            $data['active_menu'] = 'video_course_back_end';
            $data['active_sub_menu'] = 'add_video_back_end';
            $data['video_counter'] = 1;

            $data['main_content'] = $this->load->view('manage_admin_video/add_admin_video', $data, TRUE);
            $this->load->view('admin/admin_master', $data);
        }else{
            $all_video_form_counter_value = explode(',', $this->input->post('all_video_form_counter', TRUE));
            $all_video_form_counter = array_filter($all_video_form_counter_value);
            for ($i = 0; $i < (count($all_video_form_counter)); $i++) {
                $data['manage_video_id'] = $manage_video_id = $this->input->post('manage_video_id'.$all_video_form_counter[$i], TRUE);
                
                $data['manage_video_title'] = $this->input->post('manage_video_title'.$all_video_form_counter[$i], TRUE);
                $data['manage_video_payment_type'] = $this->input->post('manage_video_payment_type['.$all_video_form_counter[$i].']', TRUE);
                if($data['manage_video_payment_type'] == ""){
                    $data['manage_video_payment_type'] = 1;
                }
                $data['manage_video_work_file'] = $this->input->post('manage_video_work_file['.$all_video_form_counter[$i].']', TRUE);
                if($data['manage_video_work_file'] == ""){
                    $data['manage_video_work_file'] = 2;
                }
                $data['manage_video_status'] = $this->input->post('manage_video_status['.$all_video_form_counter[$i].']', TRUE);
                if($data['manage_video_status'] == ""){
                    $data['manage_video_status'] = 2;
                }
                elseif ($data['manage_video_status'] = 1) {
                    if($data['manage_video_title'] == ''){
                        $data['manage_video_status'] = 2;
                    }
                }
                
                if($data['manage_video_work_file'] == 1){
                    $work_file_id = $this->input->post('work_file_id'.$all_video_form_counter[$i], TRUE);
                    if($work_file_id != ''){
                        $work_file_status = $this->add_admin_video_workfile($all_video_form_counter[$i], $work_file_id, $data['manage_video_title'], $data['manage_video_payment_type']);
                        $data['manage_video_work_file'] = 1;
                        $data['manage_video_status'] = $work_file_status;
                    }else{
                        $data['manage_video_work_file'] = 2;
                    }
                }
                if($manage_video_id != ''){
                    $this->manage_admin_video_model->update_admin_video_info($manage_video_id, $data, '');
                }
            }
            redirect('manage-admin-video');
        }
    }
    
    /**
     * @Author              : Md. Delwar Hossain    
     * @CreatedDate         : 27-07-17   
     * @ModifiedDate        : Null
     * @ModifiedBy          : Null
     * @Route               : Null
     * @Description         : Admin add video workfile data insert in db 
     * @view                : Null
     * @redirect            : Null
     * @deprecated          : No
     * @exception           : 
     * @inheritDoc          : 
     * @Used in             : add_admin_video(), edit_admin_video()
     * @Parameter           : $video_counter, $work_file_id
     * @Return              : Null       
     * @value               : $work_files pass by add_admin_video_workfile function for insert data in db
     * @Status              : Available
     * @version             : v2.1       
    * */
    public function add_admin_video_workfile($video_counter, $work_file_id, $manage_video_title, $manage_video_payment_type) {
        $work_files['work_file_name'] = $this->input->post('work_file_name'.$video_counter, TRUE);
        if($manage_video_title != ''){
            if($work_files['work_file_name'] == ''){
                $work_files['work_file_status'] = 2;
            }else{
                $work_files['work_file_status'] = 1;
            }
        }else{
            $work_files['work_file_status'] = 2;
        }
        $work_files['work_file_payment_type'] = $this->input->post('work_file_payment_type['.$video_counter.']', TRUE);
        if($work_files['work_file_payment_type'] == ''){
            $work_files['work_file_payment_type'] = 1;
        }
        elseif($manage_video_payment_type != 2){
            $work_files['work_file_payment_type'] = 1;
        }
        $this->manage_admin_video_model->update_admin_video_work_file_info($work_file_id, $work_files);
        return $work_files['work_file_status'];
    }
    
    /**
     * @Author              : Md. Delwar Hossain    
     * @CreatedDate         : 11-07-17   
     * @ModifiedDate        : Null
     * @ModifiedBy          : Null
     * @Route               : 'manage-admin-video'
     * @Description         : Admin shows the uploaded video
     * @view                : manage_admin_video/manage_admin_video
     * @redirect            : Null
     * @deprecated          : No
     * @exception           : 
     * @inheritDoc          : 
     * @Parameter           : Null
     * @Return              : Null       
     * @value               : $data pass the details information of all videos
     * @Status              : Available
     * @version             : v2.1       
    * */
    public function manage_admin_video($section_id = NULL){
        $data = array();
        $data['active_menu'] = 'video_course_back_end';
        $data['active_sub_menu'] = 'manage_video_back_end';
        
        if($section_id != ''){
            $data['section_id'] = $section_id;
            //$data['video_course_id'] = $video_course_id;
            //$this->session->set_userdata($data);
        }
        //$this->cf->dd($data);
        $limit_offset = 0;
        $page_number = 1;
        $data['serial'] = 0;
        $data['manage_admin_video_info'] = $this->manage_admin_video_model->manage_admin_video_info($limit_offset);
        $total_row = $data['manage_admin_video_info']['count_all_video'];
        $params = array('url' => '', 'div_id' => 'manage_admin_video_pagination', 'total_row' => $total_row, 'per_page' => 10, 'current_page' => $page_number, 'total_link' => 10);
        $data['manage_admin_video_pagination'] = $this->tt_pagination->view_pagination_link($params);
        
        $data['main_content'] = $this->load->view('manage_admin_video/manage_admin_video', $data, TRUE);
        $this->load->view('admin/admin_master', $data);       
    }
    
    /**
     * @Author              : Md. Delwar Hossain    
     * @CreatedDate         : 30-07-17   
     * @ModifiedDate        : Null
     * @ModifiedBy          : Null
     * @Route               : 'download-manage-admin-video-workfile/(.+)'
     * @Description         : Download video work file
     * @view                : Null
     * @redirect            : Null
     * @deprecated          : No
     * @exception           : 
     * @inheritDoc          : 
     * @Parameter           : $work_file_id
     * @Return              : Download file       
     * @value               : $work_files is used for get work file information from db
     *                          $work_file_name is used for keep workfile name
     * @Status              : Available
     * @version             : v2.1       
    * */
    public function download_manage_admin_video_workfile($work_file_id) {
        $work_files = $this->manage_admin_video_model->get_admin_workfile_information_by_work_file_id($work_file_id);
        
        $this->load->helper('download');
        $work_file_name = substr(strrchr($work_files->work_file_location , '/'), 1);
        $data = file_get_contents("$work_files->work_file_location");
        if ($data) {
            force_download($work_file_name, $data);
        } else {
            return;
        }
    }
    
    /**
     * @Author              : Md. Delwar Hossain    
     * @CreatedDate         : 26-07-17   
     * @ModifiedDate        : Null
     * @ModifiedBy          : Null
     * @Route               : 'view-single-video/(.+)'
     * @Description         : play the uploaded video 
     * @view                : manage_admin_video/view_single_video
     * @redirect            : Null
     * @deprecated          : No
     * @exception           : 
     * @inheritDoc          : 
     * @Parameter           : $encrypt_data
     * @Return              : Null
     * @value               : $decrypt_data is used for keep the $encrypt_data value which string is replace %F2 to /
                              $manage_video_info_id is used for keep decrypt value in array
     * @Status              : Available
     * @version             : v2.1       
    * */
    public function view_single_video($encrypt_data){
        $data = array();
        $decrypt_data = str_replace("%F2", "/", $encrypt_data);
        $manage_video_info_id = $this->encryption->decrypt($decrypt_data);
        $manage_video_info_id = explode(',',$manage_video_info_id);
        if(isset($manage_video_info_id[1])){
            $data['manage_single_video'] = $this->manage_admin_video_model->get_admin_video_information_by_manage_video_location_id($manage_video_info_id[1]);                   
        
            if(!isset($data['manage_single_video'])){
                redirect('not-found');
            }
        }else if(isset($manage_video_info_id[0])){
            $data['manage_video'] = $this->manage_admin_video_model->get_admin_video_information_by_manage_video_id($manage_video_info_id[0]);                   
            if(!isset($data['manage_video']) || empty($data['manage_video'])){
                redirect('not-found');
            }
        } else {
            redirect('not-found');
        }
        $data['main_content'] = $this->load->view('manage_admin_video/view_single_video', $data, TRUE);
        $this->load->view('manage_admin_video/admin_video_master', $data);       
    }
    
    /**
     * @Author              : Md. Delwar Hossain    
     * @CreatedDate         : 27-07-17   
     * @ModifiedDate        : Null
     * @ModifiedBy          : Null
     * @Route               : 'view-single-video-user-info'
     * @Description         : User location, device info insert in db when user see video 
     * @view                : Null
     * @redirect            : Null
     * @deprecated          : No
     * @exception           : 
     * @inheritDoc          : 
     * @Function            : get_user_current_address() is used for get user current location by latitude and longitude     
                                add_view_content_info() is used for insert the data of $view_content_info in db     
     * @Parameter           : Null
     * @Return              : Null
     * @value               : $latitude is used for keep user location latitude value 
                              $longitude is used for keep user location longitude value 
                              $address is used for keep user location value 
                              $geo_information array is used for insert user location value in db
                              $view_content_info_device_resolution is used for keep user device resolution
                              $view_content_info is used for keep view_content_info_id from db
                              $person_view_content_info array is used for insert $person_view_content_info data in db
     * @Status              : Available
     * @version             : v2.1       
    * */
    public function view_single_video_user_info() {
        if($this->input->is_ajax_request()){
            $manage_video_id = $this->input->post('manage_video_id');
            $latitude = $this->input->post('latitude');
            $longitude = $this->input->post('longitude');
            $width = $this->input->post('width');
            $height = $this->input->post('height');
            
            if(isset($latitude) && isset($longitude)){
                $address = $this->get_user_current_address($latitude,$longitude);
                $address = $address ? $address : '';
                $split_address = explode(',', $address);
                //$secondLast = $split_address[count($split_address) - 2];
                end($split_address); 
                $geo_information['geo_city_name'] = prev($split_address);
                $geo_information['geo_country_name'] = substr(strrchr($address, ","), 1);
                $geo_information['geo_latitude_longitude'] = '('.$latitude.','.$longitude.')';
                
                $geo_information = $this->manage_admin_video_model->add_geo_information_info($geo_information);
            }
            
            $geo_information_id = isset($geo_information) ? $geo_information : '';
            $view_content_info_device_resolution = isset($height) ? $height : '';
            
            $view_content_info = $this->add_view_content_info($manage_video_id, $geo_information_id, $view_content_info_device_resolution);

            if($this->session->userdata('person_id')){
                $person_view_content_info['person_id'] = $this->session->userdata('person_id'); 
                $person_view_content_info['view_content_info_id'] = $view_content_info['view_content_info_id'];
                $this->manage_admin_video_model->add_person_view_content_info($person_view_content_info);
            }
        }
    }
    
    /**
     * @Author              : Md. Delwar Hossain    
     * @CreatedDate         : 25-07-17   
     * @ModifiedDate        : Null
     * @ModifiedBy          : Null
     * @Route               : Null
     * @Description         : Get the user current address
     * @view                : Null
     * @redirect            : Null
     * @deprecated          : No
     * @exception           : 
     * @inheritDoc          : 
     * @Used in             : view_single_video()     
     * @Parameter           : $latitude, $longitude
     * @Return              : $address
     * @value               : $geocodeFromLatLong is used for get the location data by google api
                              $output is used for keep location data
                              $address is used for keep formatted address data from json data
     * @Status              : Available
     * @version             : v2.1       
    * */
    public function get_user_current_address($latitude,$longitude){
        if(!empty($latitude) && !empty($longitude)){
            $geocodeFromLatLong = file_get_contents('http://maps.googleapis.com/maps/api/geocode/json?latlng='.trim($latitude).','.trim($longitude).'&sensor=false'); 
            $output = json_decode($geocodeFromLatLong);
            $status = $output->status;
            $address = ($status=="OK")?$output->results[1]->formatted_address:'';
            if(!empty($address)){
                return $address;
            }else{
                return false;
            }
        }else{
            return false;   
        }
    }
    
    /**
     * @Author              : Md. Delwar Hossain    
     * @CreatedDate         : 25-07-17   
     * @ModifiedDate        : Null
     * @ModifiedBy          : Null
     * @Route               : Null
     * @Description         : Get the user current address
     * @view                : Null
     * @redirect            : Null
     * @deprecated          : No
     * @exception           : 
     * @inheritDoc          : 
     * @Used in             : view_single_video()     
     * @Parameter           : $data, $geo_information_id, $view_content_info_device_resolution
     * @Return              : $view_content_info
     * @value               : $view_content_info is used for insert data in db
     * @Status              : Available
     * @version             : v2.1       
    * */
    public function add_view_content_info($manage_video_id , $geo_information_id, $view_content_info_device_resolution) {
        $view_content_info['geo_information_id'] = $geo_information_id;
        $view_content_info['view_content_info_type'] = 1; 
        $view_content_info['view_content_info_type_id'] = $manage_video_id; 
        $view_content_info['view_content_info_device_name'] = $_SERVER['HTTP_USER_AGENT'];
        $view_content_info['view_content_info_device_resolution'] = $view_content_info_device_resolution; 
        $view_content_info['view_content_info_visitor_ip_address'] = $_SERVER['REMOTE_ADDR']; 
        $view_content_info['view_content_info_visitor_browser'] = $this->utility_model->get_browser_name();
        if(isset($_SERVER['HTTP_REFERER'])){
            $view_content_info['view_content_info_visitor_referrer'] = $_SERVER['HTTP_REFERER']; 
        }
        $view_content_info['view_content_info_id'] = $this->manage_admin_video_model->add_view_content_info($view_content_info);
        return $view_content_info;
    }
    
    /**
     * @Author              : Md. Delwar Hossain    
     * @CreatedDate         : 11-07-17   
     * @ModifiedDate        : Null
     * @ModifiedBy          : Null
     * @Route               : 'add-admin-video-form'
     * @Description         : Admin shows the add video form page by ajax calling in first time only when 'add-admin-video' url load
     * @view                : manage_admin_video/ajax_view/add_admin_single_video
     * @redirect            : Null
     * @deprecated          : No
     * @exception           : 
     * @inheritDoc          : 
     * @Parameter           : Null
     * @Return              : Add video form page       
     * @value               : $data['video_counter'] variable is created for pass to count add video form open & manage the form id, name
     * @Status              : Available
     * @version             : v2.1       
    * */
    public function add_admin_video_form() {
        if($this->input->is_ajax_request()){
            $data['video_counter'] = $this->input->post('video_counter');
            echo $this->load->view('manage_admin_video/ajax_view/add_admin_single_video', $data, true);
        }
    }
    
    /**
     * @Author              : Md. Delwar Hossain    
     * @CreatedDate         : 11-07-17   
     * @ModifiedDate        : Null
     * @ModifiedBy          : Null
     * @Route               : 'add-single-admin-video'
     * @Description         : This is ajax called function. Here single video view by click on add more video
     * @view                : manage_admin_video/ajax_view/add_admin_single_video
     * @redirect            : Null
     * @deprecated          : No
     * @exception           : 
     * @inheritDoc          : 
     * @Parameter           : Null
     * @Return              : Add single video form page         
     * @value               : $data['video_counter'] variable is created for pass to count how many times add video form open & manage the form id, name, values
     * @Status              : Available
     * @version             : v2.1       
    * */
    public function add_single_admin_video() {
        if($this->input->is_ajax_request()){
            $video_counter = $this->input->post('video_counter');
            $data['video_counter'] = ++$video_counter;
            echo $this->load->view('manage_admin_video/ajax_view/add_admin_single_video', $data, true);
        }
    }
    
    /**
     * @Author              : Md. Delwar Hossain    
     * @CreatedDate         : 12-07-17   
     * @ModifiedDate        : Null
     * @ModifiedBy          : Null
     * @Route               : 'upload-admin-video'
     * @Description         : uploaded video information insert in db & convert video
     * @view                : Null
     * @redirect            : Null
     * @deprecated          : No
     * @exception           : 
     * @inheritDoc          : 
     * @Functions           : get_manage_admin_video_field_info() is used to collect video form all input field data
     *                          get_upload_file_name() is used to make new video name
     *                          make_manage_admin_video_directory() is used for make directory
     *                          get_admin_upload_video_duration() is used for get upload video duration
     *                          convert_admin_video() is used for convert upload video
     *                          get_manage_admin_video_location() is used for get converted video location
     * @Parameter           : Null
     * @Return              : inserted video data       
     * @value               : $manage_video array value is for insert/update video information on tbl_manage_video
                              $manage_video_location array value is for insert/update video information on tbl_manage_video_location
     * @Status              : Available
     * @version             : v2.1       
    * */
    public function upload_admin_video() {
        if($this->input->is_ajax_request()){
            ini_set('max_execution_time', 7200);
            $manage_video_id = $this->input->post('manage_video_id', TRUE);
            $data['video_file'] = $this->input->post('video_file', TRUE);
            $manage_video[] = array();
            $manage_video = $this->get_manage_admin_video_field_info();
            $video_course_folder_name = $this->manage_admin_video_model->get_video_course_url_by_manage_video_id($manage_video_id);
            //$this->cf->dd($video_course_url);
            if (isset($_FILES['video_file']['name'])) {
                $fileTmpLoc = $_FILES["video_file"]["tmp_name"];
                $fileName = $_FILES["video_file"]["name"];
                $fileSize = $_FILES["video_file"]["size"];
                $new_file_name = $this->get_upload_file_name($fileName);
                
                if (!$fileTmpLoc) { // if file not chosen
                    echo "error";
                } else {
                    if ($fileSize < 524288000) {
                        if($video_course_folder_name){
                            $upload_path = 'content-library/talhatraining/my-video/'.$video_course_folder_name.'/';
                        }else{
                            $upload_path = 'content-library/talhatraining/my-video/';
                        }
                        $config['upload_path'] = $upload_path;
                        $config['allowed_types'] = '*';
                        $config['max_size'] = 0;
                        $config['max_file_name'] = 200;
                        $config['file_name'] = $new_file_name;

                        $this->make_manage_admin_video_directory($manage_video_id , $upload_path);
                        $this->load->library('upload', $config);

                        if (!$this->upload->do_upload('video_file')) {
                            echo $this->upload->display_errors();
                        } else {
                            $manage_video['manage_video_size'] = $fileSize;
                            $manage_video['manage_video_time_length'] = $this->get_admin_upload_video_duration($fileTmpLoc);
                            $converted_output = $this->convert_admin_video();
                            $manage_video['manage_video_conversion_data'] = json_encode($converted_output);
                            
                            $manage_video_location = $this->get_manage_admin_video_location($converted_output, $upload_path);
                            if($manage_video_id == ''){
                                $manage_video_id = $this->manage_admin_video_model->add_admin_video_info($manage_video, $manage_video_location);
                                if(isset($manage_video_id)){
                                    echo $manage_video_id;
                                }else{
                                    echo 'not-upload';
                                }
                            }else{
                                $this->manage_admin_video_model->update_admin_video_info($manage_video_id, $manage_video, $manage_video_location);
                                echo $manage_video_id;
                            }
                        }
                    }else{
                        echo "error";
                    }
                }
            }
        }
    }
    
    /**
     * @Author              : Md. Delwar Hossain    
     * @CreatedDate         : 23-07-17   
     * @ModifiedDate        : Null
     * @ModifiedBy          : Null
     * @Route               : 
     * @Description         : Collect all input field data
     * @view                : Null
     * @redirect            : Null
     * @deprecated          : No
     * @exception           : 
     * @inheritDoc          : 
     * @Used in             : upload_admin_video()
     * @Parameter           : Null
     * @Return              : $manage_video data       
     * @value               : $manage_video array value is for insert/update video information on tbl_manage_video
     * @Status              : Available
     * @version             : v2.1       
    * */
    public function get_manage_admin_video_field_info(){
        $manage_video['person_id'] = 1;
        $manage_video['video_course_id'] = 0;
        $manage_video['manage_video_title'] = $this->input->post('manage_video_title', TRUE);
        $manage_video['manage_video_work_file'] = $this->input->post('manage_video_work_file', TRUE);
        if($manage_video['manage_video_work_file'] == 'undefined'){
            $manage_video['manage_video_work_file'] = 2;
        }
        $manage_video['manage_video_payment_type'] = $this->input->post('manage_video_payment_type', TRUE);
        if($manage_video['manage_video_payment_type'] == 'undefined'){
            $manage_video['manage_video_payment_type'] = 1;
        }
        $manage_video['manage_video_status'] = $this->input->post('manage_video_status', TRUE);
        if($manage_video['manage_video_status'] == 'undefined'){
            $manage_video['manage_video_status'] = 2;
        }
        $manage_video['manage_video_upload_date'] = date('Y/m/d H:i:s', (time() - $this->session->userdata('time_offset')));
        
        return $manage_video;
    }
    
    /**
     * @Author              : Md. Delwar Hossain    
     * @CreatedDate         : 23-07-17   
     * @ModifiedDate        : Null
     * @ModifiedBy          : Null
     * @Route               : 
     * @Description         : Make directory of uploaded video
     * @view                : Null
     * @redirect            : Null
     * @deprecated          : No
     * @exception           : 
     * @inheritDoc          : 
     * @Used in             : upload_admin_video()
     * @Parameter           : $manage_video_id , $upload_path
     * @Return              : Null       
     * @value               : $video_upload_info is used for get video information
     * @Status              : Available
     * @version             : v2.1       
    * */
    public function make_manage_admin_video_directory($manage_video_id , $upload_path) {
        if($manage_video_id == ''){
            if (!is_dir($upload_path)) {
                mkdir($upload_path, 0777);
            }
        }else{
            $video_upload_info = $this->manage_admin_video_model->get_admin_video_information_by_manage_video_id($manage_video_id);
            foreach($video_upload_info as $video_info){
                $file_path = $video_info->manage_video_location;
                if (file_exists($file_path)) {
                    unlink($file_path);
                }
            }
        }
    }
    
    /**
     * @Author              : Md. Delwar Hossain    
     * @CreatedDate         : 23-07-17   
     * @ModifiedDate        : Null
     * @ModifiedBy          : Null
     * @Route               : 
     * @Description         : Convert uploaded video
     * @view                : Null
     * @redirect            : Null
     * @deprecated          : No
     * @exception           : 
     * @inheritDoc          : 
     * @Used in             : upload_admin_video()
     * @Parameter           : Null
     * @Return              : $converted_output       
     * @value               : $converted_output is used for get converted video information
     * @Status              : Available
     * @version             : v2.1       
    * */
    public function convert_admin_video() {
        $time_start = microtime(true);
        $converted_output = $this->tt_video_converter->set_file($this->upload->data())
                        ->convert_video()->get_full_report();
        $time_end = microtime(true);
        $converted_output['conversion_time'] = $time_end - $time_start;
        return $converted_output;
    }
    
    /**
     * @Author              : Md. Delwar Hossain    
     * @CreatedDate         : 23-07-17   
     * @ModifiedDate        : Null
     * @ModifiedBy          : Null
     * @Route               : 
     * @Description         : Manage converted video location by following there resulation
     * @view                : Null
     * @redirect            : Null
     * @deprecated          : No
     * @exception           : 
     * @inheritDoc          : 
     * @Used in             : upload_admin_video()
     * @Parameter           : $converted_output , $upload_path
     * @Return              : $manage_video_location       
     * @value               : $file_path_1080p, $file_path_720p, $file_path_360p, $file_path_144p is used for keep converted video path
                                $filename_1080p, $filename_720p, $filename_360p, $filename_144p is used for keep converted video name
                                $manage_video_location is used for keep all resulation videos final location
     * @Status              : Available
     * @version             : v2.1       
    * */
    public function get_manage_admin_video_location($converted_output, $upload_path){
        if(isset($converted_output['converted_files_path']['1080p'])){
            $file_path_1080p = $converted_output['converted_files_path']['1080p'];
            $filename_1080p = substr(strrchr($file_path_1080p, "/"), 1);
        }
        if(isset($converted_output['converted_files_path']['720p'])){
            $file_path_720p = $converted_output['converted_files_path']['720p'];
            $filename_720p = substr(strrchr($file_path_720p, "/"), 1);
        }
        if(isset($converted_output['converted_files_path']['360p'])){
            $file_path_360p = $converted_output['converted_files_path']['360p'];
            $filename_360p = substr(strrchr($file_path_360p, "/"), 1);
        }
        if(isset($converted_output['converted_files_path']['144p'])){
            $file_path_144p = $converted_output['converted_files_path']['144p'];
            $filename_144p = substr(strrchr($file_path_144p, "/"), 1);
        }
        if(isset($filename_1080p)){
           $manage_video_location['manage_video_location_1080p'] = $upload_path . $filename_1080p;  
        }
        if(isset($filename_720p)){
            $manage_video_location['manage_video_location_720p'] = $upload_path. $filename_720p; 
        }
        if(isset($filename_360p)){
            $manage_video_location['manage_video_location_360p'] = $upload_path . $filename_360p;
        }
        if(isset($filename_144p)){
            $manage_video_location['manage_video_location_144p'] = $upload_path . $filename_144p;
        }
        return $manage_video_location;
    }
    
    /**
     * @Author              : Md. Delwar Hossain    
     * @CreatedDate         : 12-07-17   
     * @ModifiedDate        : Null
     * @ModifiedBy          : Null
     * @Route               : Null
     * @Description         : Get admin upload video duration
     * @view                : Null
     * @redirect            : Null
     * @deprecated          : No
     * @exception           : 
     * @inheritDoc          : 
     * @Parameter           : $admin_video_path is used for get video file location
     * @Return              : video total duration   
     * @value               : $admin_video_path is used for get video file location
                              $check_admin_video_path is used for check path by shell_exec
                              $search is used for search duration value in $check_admin_video_path & which will match, it will be returned
     * @Status              : Available
     * @version             : v2.1       
    * */
    public function get_admin_upload_video_duration($admin_video_path) {
        $matches = '';
        $check_admin_video_path = shell_exec("ffmpeg -i \"{$admin_video_path}\" 2>&1");
        $search = '/Duration: (.*?),/';
        preg_match($search, $check_admin_video_path, $matches);
        if (isset($matches[1])) {
            return $matches[1];
        } else {
            return 0;
        }
    }
    
    /**
     * @Author              : Md. Delwar Hossain    
     * @CreatedDate         : 27-07-17   
     * @ModifiedDate        : Null
     * @ModifiedBy          : Null
     * @Route               : 'upload-admin-video-work-file'
     * @Description         : uploaded video workfile information insert in db & convert video
     * @view                : Null
     * @redirect            : Null
     * @deprecated          : No
     * @exception           : 
     * @inheritDoc          : 
     * @Functions           : get_manage_admin_workfile_field_info() is used to collect video workfile form all input field data
     *                          get_upload_file_name() is used to make new workfile name
     *                          make_manage_admin_workfile_directory() is used for make directory
     * @Parameter           : Null
     * @Return              : inserted workfile id       
     * @value               : $work_files array value is for insert/update workfile information on tbl_work_files
     * @Status              : Available
     * @version             : v2.1       
    * */
    public function upload_admin_video_work_file(){
        if($this->input->is_ajax_request()){
            $work_file_id = $this->input->post('work_file_id', TRUE);
            $manage_video_id = $this->input->post('work_file_type_id', TRUE);
            $data['work_file'] = $this->input->post('work_file', TRUE);
            $work_files[] = array();
            $work_files = $this->get_manage_admin_workfile_field_info();
            $video_course_folder_name = $this->manage_admin_video_model->get_video_course_url_by_manage_video_id($manage_video_id);
            
            if ($_FILES['work_file']) {
                $fileTmpLoc = $_FILES["work_file"]["tmp_name"];
                $fileName = $_FILES["work_file"]["name"];
                $fileSize = $_FILES["work_file"]["size"];
                $new_file_name = $this->get_upload_file_name($fileName);
                if (!$fileTmpLoc) {
                    echo "error";
                } else {
                    if ($fileSize != 0) {
                        if ($fileSize < 524288000) {
                            if($video_course_folder_name){
                                $upload_path = 'content-library/talhatraining/my-video/'.$video_course_folder_name.'/';
                            }else{
                                $upload_path = 'content-library/talhatraining/my-video/';
                            }
                            $config['upload_path'] = $upload_path;
                            $config['allowed_types'] = 'zip|rar|txt|rtf|pdf|gif|jpeg|jpg|png|psd|epub|azw3|cbr|lit|mobi|swf|
                                                        docx|xlsx|pub|pptx|one|doc|vsdx|accdb|xlsb|mso|rpmsg|asd|xls|oft|thmx|mdb|
                                                        xlsm|mpp|obi|pst|snp|xsn|olm||ost|dotx|vsd|laccdb|accdr|wbk|pptm|dot|ppt|xlam|
                                                        onepkg|xltx|mde|docm|pip|ppsx|ppsm|accde|grv|xla|slk|potx|iaf|xlt|crtx|xlb|vss|
                                                        xar|xlw|pps|pa|oab|dotm||mpd|svd|ops|pot|xlm|mpt|acl|xltm|mdt|ade|xl|vst|accdc|mdw|
                                                        accdt|mat|vdx|xsf|xll|sldx|mda|mar|ppam|accda|ppa|vsx|puz|prf|maf|vtx|potm|xlc|wll|accdp|
                                                        mam|sldm|maq|accdu|cnv|maw|xslb';
                            $config['max_size'] = 0;
                            $config['max_file_name'] = 200;
                            $config['file_name'] = $new_file_name;
                            $this->make_manage_admin_workfile_directory($work_file_id, $upload_path);
                            
                            $this->load->library('upload', $config);

                            if (!$this->upload->do_upload('work_file')) {
                                echo $this->upload->display_errors();
                            } else {
                                $work_files['work_file_size'] = $fileSize;
                                $work_files['work_file_location'] = $upload_path.$new_file_name;
                                
                                if($work_file_id == ''){
                                    $work_file_id = $this->manage_admin_video_model->add_admin_video_workfile_info($work_files);
                                    echo $work_file_id;
                                }else{
                                    $this->manage_admin_video_model->update_admin_video_work_file_info($work_file_id, $work_files);
                                    echo $work_file_id;
                                }
                            }
                        }else{
                            echo 'error';
                        }
                    }else{
                        echo 'error';
                    }
                }
            }
        }
    }
    
    /**
     * @Author              : Md. Delwar Hossain    
     * @CreatedDate         : 27-07-17   
     * @ModifiedDate        : Null
     * @ModifiedBy          : Null
     * @Route               : 
     * @Description         : Collect all input field data
     * @view                : Null
     * @redirect            : Null
     * @deprecated          : No
     * @exception           : 
     * @inheritDoc          : 
     * @Used in             : upload_admin_video_work_file()
     * @Parameter           : Null
     * @Return              : $work_files data       
     * @value               : $work_files array value is for insert/update workfile information on tbl_work_files
     * @Status              : Available
     * @version             : v2.1       
    * */
    public function get_manage_admin_workfile_field_info(){
        $work_files['work_file_type'] = 2;
        $work_files['work_file_type_id'] = $manage_video_id = $this->input->post('work_file_type_id', TRUE);
        $work_files['work_file_name'] = $this->input->post('work_file_name', TRUE);
        $work_files['work_file_payment_type'] = $this->input->post('work_file_payment_type', TRUE);
        if($work_files['work_file_payment_type'] == 'undefined'){
            $work_files['work_file_payment_type'] = 1;
        }
        $video_info = $this->manage_admin_video_model->get_admin_video_information_by_manage_video_id($manage_video_id);
        if(isset($video_info)){
            $work_files['work_file_status'] = $video_info[0]->manage_video_status;
        }
        $work_files['work_file_upload_date'] = date('Y/m/d H:i:s', (time() - $this->session->userdata('time_offset')));
        return $work_files;
    }
    
    /**
     * @Author              : Md. Delwar Hossain    
     * @CreatedDate         : 27-07-17   
     * @ModifiedDate        : Null
     * @ModifiedBy          : Null
     * @Route               : 
     * @Description         : Make directory of uploaded video
     * @view                : Null
     * @redirect            : Null
     * @deprecated          : No
     * @exception           : 
     * @inheritDoc          : 
     * @Used in             : upload_admin_video_work_file()
     * @Parameter           : $work_file_id , $upload_path
     * @Return              : Null       
     * @value               : $work_files is used for get work files information
     * @Status              : Available
     * @version             : v2.1       
    * */
    public function make_manage_admin_workfile_directory($work_file_id , $upload_path) {
        if($work_file_id == ''){
            if (!is_dir($upload_path)) {
                mkdir($upload_path, 0777);
            }
        }else{
            $work_files = $this->manage_admin_video_model->get_admin_workfile_information_by_work_file_id($work_file_id);
            $workfile_path = $work_files->work_file_location;
            if (file_exists($workfile_path)) {
                unlink($workfile_path);
            }
        }
    }
    
    /**
     * @Author              : Md. Delwar Hossain    
     * @CreatedDate         : 27-07-17   
     * @ModifiedDate        : Null
     * @ModifiedBy          : Null
     * @Route               : 
     * @Description         : Make directory of uploaded video
     * @view                : Null
     * @redirect            : Null
     * @deprecated          : No
     * @exception           : 
     * @inheritDoc          : 
     * @Used in             : upload_admin_video(), upload_admin_video_work_file()
     * @Parameter           : $fileName
     * @Return              : $new_file_name       
     * @value               : $file_basename is used for keep file name
     *                          $file_ext is used for keep file extention
     *                          $upload_time is used for keep file upload time
     *                          $new_file_name is used for keep upload file new name
     * @Status              : Available
     * @version             : v2.1       
    * */
    public function get_upload_file_name($fileName){
        $file_basename = substr($fileName, 0, strripos($fileName, '.')); 
        $file_ext = substr($fileName, strripos($fileName, '.')); 
        $file_name = str_replace(" ", "_", $file_basename);
        $upload_time = date('Y-m-d_H-i-s', (time() - $this->session->userdata('time_offset')));
        $new_file_name = $file_name.'_'.$upload_time.$file_ext;
        return $new_file_name;
    }
    
    /**
     * @Author              : Md. Delwar Hossain    
     * @CreatedDate         : 30-07-17   
     * @ModifiedDate        : Null
     * @ModifiedBy          : Null
     * @Route               : 'edit-admin-video/(.+)'
     * @Description         : Edit manage video information
     * @view                : manage_admin_video/edit_admin_video
     * @redirect            : 'manage-admin-video'
     * @deprecated          : No
     * @exception           : 
     * @inheritDoc          : 
     * @Function            : add_admin_video_workfile()
     * @Parameter           : $encrypt_data
     * @Return              : Null      
     * @value               : $decrypt_data is used for keep the $encrypt_data value which string is replace %F2 to /
     *                          $data array is used for update $data value in db
     *                          $all_video_form_counter is used for counter value
     *                          $work_file_id is used for keep $work_file_id if video have
     * @Status              : Available
     * @version             : v2.1       
    * */
    public function edit_admin_video($encrypt_data, $section_id = NULL){
        $decrypt_data = str_replace("%F2", "/", $encrypt_data);
        $manage_video_id = $this->encryption->decrypt($decrypt_data);
        if (!$this->input->post('update_video_workfile', TRUE)) {
            $data[] = array();
            $data['active_menu'] = 'video_course_back_end';
            $data['active_sub_menu'] = 'manage_video_back_end';
            $data['video_counter'] = 1;
            $data['section_id'] = $section_id;
            $data['encrypt_data'] = $encrypt_data;
            $data['manage_video'] = $this->manage_admin_video_model->get_admin_video_information_by_manage_video_id($manage_video_id);                   
            if(!isset($data['manage_video']) || empty($data['manage_video'])){
                redirect('not-found');
            }
            $data['work_files'] = $this->manage_admin_video_model->get_admin_workfile_information_by_work_file_type_id($manage_video_id);
            
            $data['main_content'] = $this->load->view('manage_admin_video/edit_admin_video', $data, TRUE);
            $this->load->view('admin/admin_master', $data);
        }
        else{
            $all_video_form_counter_value = explode(',', $this->input->post('all_video_form_counter', TRUE));
            $all_video_form_counter = array_filter($all_video_form_counter_value);
            for ($i = 0; $i < (count($all_video_form_counter)); $i++) {
                $data['manage_video_id'] = $manage_video_id;
                
                $data['manage_video_title'] = $this->input->post('manage_video_title'.$all_video_form_counter[$i], TRUE);
                $data['manage_video_payment_type'] = $this->input->post('manage_video_payment_type['.$all_video_form_counter[$i].']', TRUE);
                $data['manage_video_work_file'] = $this->input->post('manage_video_work_file['.$all_video_form_counter[$i].']', TRUE);
                $data['manage_video_status'] = $this->input->post('manage_video_status['.$all_video_form_counter[$i].']', TRUE);
                if ($data['manage_video_status'] = 1) {
                    if($data['manage_video_title'] == ''){
                        $data['manage_video_status'] = 2;
                    }
                }
                
                
                if($data['manage_video_work_file'] == 1){
                    $work_file_id = $this->input->post('work_file_id'.$all_video_form_counter[$i], TRUE);
                    if($work_file_id != ''){
                        $work_file_status = $this->add_admin_video_workfile($all_video_form_counter[$i], $work_file_id, $data['manage_video_title'], $data['manage_video_payment_type']);
                        $data['manage_video_work_file'] = 1;
                        $data['manage_video_status'] = $work_file_status;
                    }else{
                        $data['manage_video_work_file'] = 2;
                    }
                }
                $this->manage_admin_video_model->update_admin_video_info($manage_video_id, $data, '');
                if($section_id == 'manage_admin_video'){
                    redirect('manage-admin-video');
                }else{
                    redirect('section-total-video/'.$section_id);
                }
                
            }
        }
    }
    
    public function not_found() {
        $vdata = array();
        $vdata['active_menu'] = '';
        $vdata['active_sub_menu'] = '';
        $vdata['main_content'] = $this->load->view('manage_admin_video/not_found', $vdata, true); //error_page
        $this->load->view('manage_admin_video/admin_video_master', $vdata);
    }
    
    /**
     * @Author              : Md. Delwar Hossain    
     * @CreatedDate         : 27-07-17   
     * @ModifiedDate        : Null
     * @ModifiedBy          : Null
     * @Route               : 'delete-admin-video'
     * @Description         : Delete manage video all information, video, workfile(if have)
     * @view                : Null
     * @redirect            : Null
     * @deprecated          : No
     * @exception           : 
     * @inheritDoc          : 
     * @Parameter           : Null
     * @Return              : Null       
     * @value               : $manage_video_id is used for keep manage_video_id value
     *                          $manage_video_info is used for keep video information from db
     *                          $work_file is used for keep workfile information from db
     * @Status              : Available
     * @version             : v2.1       
    * */
    public function delete_admin_video(){
        if($this->input->is_ajax_request()){
            $manage_video_id = $this->input->post('manage_video_id');
            $manage_video_info = $this->manage_admin_video_model->get_admin_video_information_by_manage_video_id($manage_video_id);
            foreach($manage_video_info as $video_info){
                $file_path = $video_info->manage_video_location;
                if (file_exists($file_path)) {
                    unlink($file_path);
                }
            }
            $work_file = $this->manage_admin_video_model->get_admin_workfile_information_by_work_file_type_id($manage_video_id);
            if(isset($work_file)){
               $workfile_path = $work_file->work_file_location;
               if (file_exists($workfile_path)) {
                    unlink($workfile_path);
                }
            }
            $this->manage_admin_video_model->delete_admin_video_info($manage_video_id);
        }
    }
    
    /**
     * @Author              : Md. Delwar Hossain    
     * @CreatedDate         : 27-07-17   
     * @ModifiedDate        : Null
     * @ModifiedBy          : Null
     * @Route               : 'delete-single-resolution-video'
     * @Description         : Delete single resolution manage video location information
     * @view                : Null
     * @redirect            : Null
     * @deprecated          : No
     * @exception           : 
     * @inheritDoc          : 
     * @Parameter           : Null
     * @Return              : Null       
     * @value               : $manage_video_location_id is used for keep manage_video_location_id value
     *                          $manage_video_location_info is used for keep video location information from db
     *                          $manage_video_info is used for keep video information from db
     *                          $work_file is used for keep workfile information from db
     * @Status              : Available
     * @version             : v2.1       
    * */
    public function delete_single_resolution_video(){
        if($this->input->is_ajax_request()){
            $manage_video_location_id = $this->input->post('manage_video_location_id');
            $manage_video_location_info = $this->manage_admin_video_model->get_admin_video_information_by_manage_video_location_id($manage_video_location_id);
            $manage_video_info = $this->manage_admin_video_model->get_admin_video_information_by_manage_video_id($manage_video_location_info->manage_video_id);
            
            $file_path = $manage_video_location_info->manage_video_location;
            if (file_exists($file_path)) {
                unlink($file_path);
            }
            
            if(count($manage_video_info) > 1){
                $this->manage_admin_video_model->delete_single_resolution_video($manage_video_location_id);
            }
            else{
                $work_file = $this->manage_admin_video_model->get_admin_workfile_information_by_work_file_type_id($manage_video_location_info->manage_video_id);
                if(isset($work_file)){
                   $workfile_path = $work_file->work_file_location;
                   if (file_exists($workfile_path)) {
                        unlink($workfile_path);
                    }
                }
                $this->manage_admin_video_model->delete_admin_video_info($manage_video_location_info->manage_video_id);
            }
        }
    }
    
    /**
     * @Author              : Md. Delwar Hossain    
     * @CreatedDate         : 27-07-17   
     * @ModifiedDate        : Null
     * @ModifiedBy          : Null
     * @Route               : 'delete-admin-video-workfile'
     * @Description         : Delete manage video workfile information
     * @view                : Null
     * @redirect            : Null
     * @deprecated          : No
     * @exception           : 
     * @inheritDoc          : 
     * @Parameter           : Null
     * @Return              : Null       
     * @value               : $work_file_type_id is used for keep $work_file_type_id value
     *                          $work_files is used for keep workfile information from db
     *                          $file_path is used for keep workfile location
     * @Status              : Available
     * @version             : v2.1       
    * */
    public function delete_admin_video_workfile(){
        if($this->input->is_ajax_request()){
            $work_file_type_id = $this->input->post('work_file_type_id');
            $work_files = $this->manage_admin_video_model->get_admin_workfile_information_by_work_file_type_id($work_file_type_id);
            $file_path = $work_files->work_file_location;
            if (file_exists($file_path)) {
                unlink($file_path);
            }
            $this->manage_admin_video_model->delete_admin_video_workfile($work_file_type_id);
        }
    }
    
    /**
     * @Author              : Md. Delwar Hossain    
     * @CreatedDate         : 29-07-17   
     * @ModifiedDate        : Null
     * @ModifiedBy          : Null
     * @Route               : 'search-admin-video'
     * @Description         : search admin video information
     * @view                : manage_admin_video/ajax_view/search_admin_video
     * @redirect            : Null
     * @deprecated          : No
     * @exception           : 
     * @inheritDoc          : 
     * @Parameter           : Null
     * @Return              : Null       
     * @value               : $search_value is used for keep search_value value
     *                          $manage_admin_video_status is used for keep manage_admin_video_status value
     *                          $data['manage_admin_video_info'] is used for keep manage_admin_video_info from db
     * @Status              : Available
     * @version             : v2.1       
    * */
    public function search_admin_video() {
        if ($this->input->is_ajax_request()) {
            $search_value = $this->input->post('search_value', TRUE);
            $manage_admin_video_status = $this->input->post('manage_admin_video_status', TRUE);
            
            $page = $this->input->post('page_number', TRUE);
            $page_number = isset($page) ? $page : 1 ;
            $limit_offset = ($page_number - 1) * 10;
            $data['serial'] = $limit_offset;
            $data['manage_admin_video_info'] = $this->manage_admin_video_model->search_admin_video_info($search_value, $manage_admin_video_status, $limit_offset);
            $total_row = $data['manage_admin_video_info']['count_all_video'];
            $params = array('url' => '', 'div_id' => 'manage_admin_video_pagination', 'total_row' => $total_row, 'per_page' => 10, 'current_page' => $page_number, 'total_link' => 10);
            $data['manage_admin_video_pagination'] = $this->tt_pagination->view_pagination_link($params);
            echo $this->load->view('manage_admin_video/ajax_view/search_admin_video', $data, TRUE);
        } else {
            redirect('manage-admin-video');
        }
    }
    
    /**
     * @Author              : Md. Delwar Hossain    
     * @CreatedDate         : 29-07-17   
     * @ModifiedDate        : Null
     * @ModifiedBy          : Null
     * @Route               : 'pagination-admin-video'
     * @Description         : pagination admin video page
     * @view                : manage_admin_video/ajax_view/search_admin_video
     * @redirect            : Null
     * @deprecated          : No
     * @exception           : 
     * @inheritDoc          : 
     * @Parameter           : Null
     * @Return              : Null       
     * @value               : $data['manage_admin_video_info'] is used for keep manage_admin_video_info from db
     * @Status              : Available
     * @version             : v2.1       
    * */
    public function pagination_admin_video() {
        if ($this->input->is_ajax_request()) {
            $page_number = $this->input->post('page_number');
            $limit_offset = ($page_number * 10) - 10;
            $data['serial'] = $limit_offset;
            $data['manage_admin_video_info'] = $this->manage_admin_video_model->manage_admin_video_info($limit_offset);
            $total_row = $data['manage_admin_video_info']['count_all_video'];
            $params = array('url' => '', 'div_id' => 'manage_admin_video_pagination', 'total_row' => $total_row, 'per_page' => 10, 'current_page' => $page_number, 'total_link' => 10);
            $data['manage_admin_video_pagination'] = $this->tt_pagination->view_pagination_link($params);
            echo $this->load->view('manage_admin_video/ajax_view/search_admin_video', $data, true);
        } else {
            redirect('manage-admin-video');
        }
    }
}