<?php

class Learner {

    public function __construct() {
        parent::__construct();
        $user_id = $this->session->userdata('user_id');
        if ($user_id == NULL) {
            redirect('sign-in', 'refresh');
        }
        $this->load->model('f_end_model', 'f_model');
        $this->load->model('user_course_model');
        $this->load->model('classroom_model', 'cr_model');
        $sdata['f_group'] = count($this->f_model->select_all_group());
        $sdata['f_quiz'] = count($this->f_model->select_all_quiz());
        $sdata['f_question'] = count($this->f_model->select_all_question());
        $sdata['f_group_mem'] = count($this->f_model->select_all_member_group());

        $this->cr_model->check_for_not_held_class();
        $this->session->set_userdata($sdata);
    }

    public function get_timezone_offset($remote_tz, $origin_tz = null) {
        date_default_timezone_set('UTC');
        if ($origin_tz === null) {
            if (!is_string($origin_tz = date_default_timezone_get())) {
                return false; // A UTC timestamp was returned -- bail out!
            }
        }
        $origin_dtz = new DateTimeZone($origin_tz);
        $remote_dtz = new DateTimeZone($remote_tz);
        $origin_dt = new DateTime("now", $origin_dtz);
        $remote_dt = new DateTime("now", $remote_dtz);
        $offset = $origin_dtz->getOffset($origin_dt) - $remote_dtz->getOffset($remote_dt);
        return $offset;
    }

    public function dashboard() {
        $data['user_role'] = '';
        $data['active'] = 'dashboard';
        $data['main_content'] = $this->load->view('f_end/classroom/classroom_dashboard', $data, true);
        $this->load->view('f_end/f_end_master', $data);
    }

    public function populate_right_side($right_side_content) {
// Right Sidebar Content Information
        $person_id = $this->session->userdata('user_id');
        $data = array();
        if ($right_side_content['quizes']) {
            $data['quizes'] = $this->quiz_model->select_sugested_quiz();
        }
        if ($right_side_content['popular_group']) {
            $data['popular_group'] = $this->group_model->select_popular_group();
        }
        if ($right_side_content['suggested_link']) {
            $data['person_link'] = $this->profile_model->select_person_link();
            if ($data['person_link']) {
                $link['person_id'] = array('FALSE');
                $link['requested_person_id'] = array('FALSE');
                foreach ($data['person_link'] as $v_person_link) {
                    if ($v_person_link->person_id != $person_id) {
                        $person_linked[$v_person_link->person_id] = TRUE;
                    }
                    if ($v_person_link->requested_person_id != $person_id) {
                        $person_linked[$v_person_link->requested_person_id] = TRUE;
                    }
                }
            }

            $data['suggested_link'] = $this->profile_model->select_suggested_link();

            foreach ($data['suggested_link'] as $v_suggested_link) {
                if (!$person_linked[$v_suggested_link->person_id] && !$person_linked[$v_suggested_link->person_id]) {
                    $data['link_info'][$v_suggested_link->person_id] = $this->profile_model->select_link_person_info($v_suggested_link->person_id);
                }
                if (!$person_linked[$v_suggested_link->requested_person_id] || !$person_linked[$v_suggested_link->requested_person_id]) {
                    $data['link_info'][$v_suggested_link->requested_person_id] = $this->profile_model->select_link_person_info($v_suggested_link->requested_person_id);
                }
            }
        }

        if ($right_side_content['tt_online_course']) {
//TalhaTraining ONLINE COURSES
            $data['tt_online_course'] = $this->course_model->select_tt_online_course();
        }
        return $data;
    }

    /**
     * @Function            : schedule_a_class
     * @Developed By        : Mahabub-A-Mawla <mahabub.cgbd@yahoo.com> <+8801925821707> | 
     * @DevelopeDateTime    : 02-05-2015 05:00 PM   | 
     * @Updated Date Time   : 05-06-2015 03:00 PM   | dd-mm-yyyy hh:mm AM   |
     * @Updated By          : Mahabub-A-Mawla       | Name                  |
     * @parameter           : NONE
     * @return              : NONE
     * @redirect            : no
     * */
    public function schedule_a_class() {
        $active_menu = $this->session->userdata('active_menu');
        if ($active_menu == 'organization') {
            $this->schedule_organization_class();
        }

        if ($active_menu == 'teacher') {
            $this->schedule_teacher_class();
        }

        if ($active_menu == 'student') {
            $this->schedule_students_class();
        }
    }

    public function schedule_teacher_class() {
// Left AND Right Sidebar Content Information
        $right_side_content = array('FALSE');
        $right_side_content['quizes'] = TRUE;
        $right_side_content['popular_group'] = TRUE;
        $right_side_content['suggested_link'] = TRUE;
        $right_side_content['tt_online_course'] = TRUE;
        $data = $this->populate_right_side($right_side_content);

        $person_id = $this->session->userdata('user_id');
        $person_role = $this->session->userdata('person_role');
        $data['active_menu'] = $this->session->userdata('active_menu');
        $data['active_sub_menu'] = $this->session->userdata('active_sub_menu');
        $data['active_sub_menu_item'] = $sdata['active_sub_menu_item'] = 'scheduling';
        $this->session->set_userdata($sdata);
        $data['left_content'] = $this->load->view('user/side_menu', $data, TRUE);
        $data['right_content'] = $this->load->view('user/right_content', $data, TRUE);

        $this->form_validation->set_rules('classroom_title', 'Classroom Title', 'required|trim|max_length[100]|xss_clean');
        $this->form_validation->set_rules('class_date', 'Classroom Date', 'required|trim||xss_clean');
        $this->form_validation->set_rules('classroom_instruction', 'Classroom Instruction', 'trim|max_length[250]|xss_clean');
        $this->form_validation->set_rules('class_start_time', 'Classroom Start Time Hour', 'required|trim|xss_clean');
        $this->form_validation->set_rules('duration', 'Duration Minute', 'required|trim|xss_clean');
        $this->form_validation->set_rules('selected_course_id', 'Classroom course ID ', 'required|trim|xss_clean');
        $this->form_validation->set_rules('classroom_record_status', 'Classroom Record Status', 'required|trim|xss_clean');
        $this->form_validation->set_rules('classroom_language', 'Classroom Language', 'trim|xss_clean');
        $this->form_validation->set_rules('webcam', 'webcam');
        $this->form_validation->set_rules('audio', 'audio');

        if ($this->form_validation->run() == FALSE) {
            $data['person_info'] = $this->profile_model->person_info_by_person_id($person_id);

            if ($data['person_info']->feature_price_id != NULL) {
                $data['feature_info'] = $this->classroom_model->select_feture_detail($data['person_info']->feature_price_id);
                $data['total_attendees'] = $data['feature_info']->virtual_classroom_attendees_number;
            } else {
                $data['total_attendees'] = 9;
            }

            if ($data['person_info']->person_role == 3) {

                $organization_id = $this->session->userdata('organization_id');
                if ($organization_id) { // Organization Teacher
                    $data['org_resource_person'] = $this->classroom_model->select_organization_resource_person_by_org_id($organization_id);
                    $config = array();
                    $config['tt'] = TRUE;
                    $config['org_pending'] = TRUE;
                    $config['org_approved'] = TRUE;
                    $config['other_approved'] = TRUE;
                    $data['course_categories'] = $this->user_course_model->select_org_course_category($data['person_info']->person_id, $data['org_resource_person'], $config);
                } else { //Individual Teacher
                    $data['course_categories'] = $this->user_course_model->select_resource_person_course_category($data['person_info']->person_id);
                }
            } else if ($data['person_info']->person_role == 4) {
                $organization_id = $this->session->userdata('organization_id');
                $data['org_resource_person'] = $this->classroom_model->select_organization_resource_person_by_org_id($organization_id);
                $config = array();
                $config['tt'] = TRUE;
                $config['org_pending'] = TRUE;
                $config['org_approved'] = TRUE;
                $config['other_approved'] = TRUE;
                $data['course_categories'] = $this->user_course_model->select_org_course_category($data['person_info']->person_id, $data['org_resource_person'], $config);
            }
// LOAD VIEW
            $data['main_content'] = $this->load->view('user/class/schedule_a_class', $data, true);
            $this->load->view('user/master', $data);
//PROTOTYPE VIEW
        } else {
            if ($_POST) {
                $classroom_id = $this->classroom_model->save_class_schedule_information();
                $sdata = array();
                $sdata['message'] = '<span class="success">New Course Schedule Added Successfully';
                $this->session->set_userdata($sdata);
                $data['classroom_info'] = $this->classroom_model->select_classroom_info($classroom_id);
                redirect('class-schedual-invite-to-learner/' . $data['classroom_info']->url);
            }
        }
    }

    public function schedule_organization_class() {
// Left AND Right Sidebar Content Information
        $right_side_content = array('FALSE');
        $right_side_content['quizes'] = TRUE;
        $right_side_content['popular_group'] = TRUE;
        $right_side_content['suggested_link'] = TRUE;
        $right_side_content['tt_online_course'] = TRUE;
        $data = $this->populate_right_side($right_side_content);

        $person_id = $this->session->userdata('user_id');
        $person_role = $this->session->userdata('person_role');
        $data['active_menu'] = $this->session->userdata('active_menu');
        $data['active_sub_menu'] = $this->session->userdata('active_sub_menu');
        $data['active_sub_menu_item'] = $sdata['active_sub_menu_item'] = 'scheduling';
        $this->session->set_userdata($sdata);
        $data['left_content'] = $this->load->view('user/side_menu', $data, TRUE);
        $data['right_content'] = $this->load->view('user/right_content', $data, TRUE);
        $this->form_validation->set_rules('classroom_title', 'Classroom Title', 'required|trim|max_length[100]|xss_clean');
        $this->form_validation->set_rules('class_date', 'Classroom Date', 'required|trim||xss_clean');
        $this->form_validation->set_rules('classroom_instruction', 'Classroom Instruction', 'trim|max_length[250]|xss_clean');
        $this->form_validation->set_rules('class_start_time', 'Classroom Start Time Hour', 'required|trim|xss_clean');
        $this->form_validation->set_rules('duration', 'Duration Minute', 'required|trim|xss_clean');
        $this->form_validation->set_rules('selected_course_id', 'Classroom course ID ', 'required|trim|xss_clean');
        $this->form_validation->set_rules('classroom_record_status', 'Classroom Record Status', 'required|trim|xss_clean');
        $this->form_validation->set_rules('classroom_language', 'Classroom Language', 'trim|xss_clean');
        $this->form_validation->set_rules('webcam', 'webcam');
        $this->form_validation->set_rules('audio', 'audio');

        if ($this->form_validation->run() == FALSE) {
            $data['active'] = 'add_course';
            $person_id = $this->session->userdata('user_id');

            $data['person_info'] = $this->profile_model->person_info_by_person_id($person_id);
            if ($data['person_info']->feature_price_id != NULL) {
                $data['feature_info'] = $this->classroom_model->select_feture_detail($data['person_info']->feature_price_id);
                $data['total_attendees'] = $data['feature_info']->virtual_classroom_attendees_number;
            } else {
                $data['total_attendees'] = 9;
            }

            if ($data['person_info']->person_role == 4) {
                $organization_id = $this->session->userdata('organization_id');
                $data['org_resource_person'] = $this->classroom_model->select_organization_resource_person_by_org_id($organization_id);
                $config = array();
                $config['tt'] = TRUE;
                $config['org_pending'] = TRUE;
                $config['org_approved'] = TRUE;
                $config['other_approved'] = TRUE;
                $data['course_categories'] = $this->user_course_model->select_org_course_category($data['person_info']->person_id, $data['org_resource_person'], $config);
            }
// LOAD VIEW
            $data['main_content'] = $this->load->view('user/class/schedule_a_class', $data, true);
            $this->load->view('user/master', $data);
//PROTOTYPE VIEW
        } else {
            if ($_POST) {
                $classroom_id = $this->classroom_model->save_class_schedule_information();
                $sdata = array();
                $sdata['message'] = '<span class="success">New Course Schedule Added Successfully';
                $this->session->set_userdata($sdata);
                $data['classroom_info'] = $this->classroom_model->select_classroom_info($classroom_id);
                redirect('class-schedual-invite-to-learner/' . $data['classroom_info']->url);
            }
        }
    }

//This function is for generate Profile ID using First name and Last name field
    public function check_profile_id_existance($profile_id) {

        if ($profile_id != '') {
            $i = 1;
            do {
                $result = $this->f_end_model->check_url($profile_id);
                if ($result) {
                    $profile_id .=$i;
                    $i++;
                }
            } while ($result);
            echo $profile_id;
        } else {
            echo '';
        }
    }

    public function check_schedule_availability() {

        $schedule_date = $this->input->post('scheduleDate', TRUE);
        $schedule_time = $this->input->post('scheduleTime', TRUE);
        $class_duration = $this->input->post('classDuration', TRUE) * 60;

        $schedule_start_date_time = date('Y-m-d H:i:s', strtotime($schedule_date . ' ' . $schedule_time));
        $schedule_end_date_time = date('Y-m-d H:i:s', strtotime($schedule_start_date_time) + $class_duration);
        $person_id = $this->session->userdata('user_id');
        $organization_id = $this->session->userdata('organization_id');
        $data['org_resource_person'] = $this->classroom_model->select_organization_resource_person_by_org_id($organization_id);
        $scheduled_class = 0;

        foreach ($data['org_resource_person'] as $value) {

            $result = $this->cr_model->person_class_schedule_by_date_time($value->person_id, $schedule_start_date_time, $schedule_end_date_time);

            if ($result) {
                $scheduled_class++;
            }
        }

        $data['person_info'] = $this->profile_model->person_info_by_person_id($person_id);

        if ($data['person_info']->feature_price_id) {
            $data['feature_info'] = $this->cr_model->organization_feature_info($data['person_info']->feature_price_id);

            if ($scheduled_class == $data['feature_info']->virtual_classroom_number) {
                echo 1;
                return;
            }
        } else {
            // Free Class

            if ($scheduled_class == 1) {
                echo 1;
                return;
            }
        }

        echo 2;
        return;
    }

    public function classroom_url_check($url) {

        $old_url = $this->input->post('old_url');
        if ($old_url == $url) {
            return true;
        } else {
            $result = $this->super_admin_model->check_menu_url($url);
            if ($result) {
                $this->form_validation->set_message('classroom_url_check', "URL Already Exist");
                return false;
            } else {
                $sp = '/[!@#$%&*()^,_;:]/';
                if (preg_match($sp, $url)) {

                    $this->form_validation->set_message('classroom_url_check', "URL Cann't contain any '/[!@#$%&*()^,._;:]/'  if need use '-' Don't use Space");
                    return FALSE;
                } else if (strstr($url, ' ')) {
                    $this->form_validation->set_message('classroom_url_check', " Don't use Space if need use '-', alse URL Cann't contain any special carecter like '/[!@#$%&*()^,._;:-]/'");
                    return FALSE;
                } else {
                    $this->form_validation->set_message('classroom_url_check', "OK");
                    return TRUE;
                }
            }
        }
    }

    public function check_url_existance($url) {
        $result = $this->f_end_model->check_url($url);
        if ($result) {
            echo '1';
        } else {
            echo '2';
        }
    }

    /**
     * @Function            : url_check (Callback function)
     * @Developed By        : Mahabub-A-Mawla <mahabub.cgbd@yahoo.com> <+8801925821707> | 
     * @DevelopeDateTime    : 02-05-2015 05:00 PM   | 
     * @Updated Date Time   : 05-06-2015 03:00 PM   | dd-mm-yyyy hh:mm AM   |
     * @Updated By          : Mahabub-A-Mawla       | Name                  |
     * @parameter           : string $url
     * @return              : true/false
     * @redirect            : no
     * */
    public function url_check($url) {

        $old_url = $this->input->post('old_url', TRUE);

        if ($old_url == $url) {
            return TRUE;
        }

        $sp = '/[!@#$%&*()^,._;:]/';

        if (preg_match($sp, $url)) {
            $this->form_validation->set_message('url_check', "URL Cann't contain any '/[!@#$%&*()^,._;:]/'  if need use '-' Don't use Space");
            return FALSE;
        } else if (strstr($url, ' ')) {
            $this->form_validation->set_message('url_check', " Don't use Space if need use '-', alse URL Cann't contain any special carecter like '/[!@#$%&*()^,._;:-]/'");
            return FALSE;
        } else if ($this->super_admin_course_model->check_course_category_url($url)) {
            $this->form_validation->set_message('url_check', "This URL Already Exist");
            return FALSE;
        } else {
            $this->form_validation->set_message('url_check', "OK");
            return TRUE;
        }
    }

    public function select_category_course($category_id) {
        $person_id = $this->session->userdata('user_id');
        $organization_id = $this->session->userdata('organization_id');
        $data['org_resource_person'] = $this->classroom_model->select_organization_resource_person_by_org_id($organization_id);

        $data['courses'] = $this->classroom_model->select_course_by_person_and_category_id($category_id, $person_id, $data['org_resource_person']);

        foreach ($data['courses'] as $v_course) {
            $data['class_session_number'][$v_course->course_id] = $this->classroom_model->select_class_session_number($person_id, $v_course->course_id);
        }
        echo $this->load->view('user/class/course_list', $data);
    }

    public function add_course_from_schedule_class() {

        $course_category_id = $this->input->post('courseCategoryId', TRUE);
        $category_name = $this->input->post('categoryName', TRUE);
        $course_name = $this->input->post('courseName', TRUE);
        $course_type = $this->input->post('courseType', TRUE);
        $course_price = $this->input->post('coursePrice', TRUE);

        $person_id = $this->session->userdata('user_id');
        $data['person_info'] = $this->profile_model->person_info_by_person_id($person_id);

        $course_data['course_category_id'] = $course_category_id;
        if ($course_category_id == 'other') {
            $cdata = array();
            $c_data['course_category_name'] = $category_name;
            $c_data['person_id'] = $person_id;
            $c_data['course_category_access_level'] = 1;
            $c_data['course_category_status'] = 3;
            $this->db->insert('tbl_course_category', $c_data);
            $course_category_id = $this->db->insert_id();
            $return_data = $course_category_id . ',' . $category_name;
//Save Course Category url and update to course category table
            if ($category_name != '') {
                $category_name = str_replace(' ', '-', $category_name);
                $i = 1;
                do {
                    $result = $this->f_end_model->check_url($category_name);
                    if ($result) {
                        $category_name = $category_name . $i;
                        $i++;
                    }
                } while ($result);
                $udata['url'] = $category_name;
            }

            $udata['url_type'] = '5';
            $udata['url_status'] = '1';
            $this->db->insert('tbl_url', $udata);
            $url_id = $this->db->insert_id();

            $this->db->set('url_id', $url_id);
            $this->db->where('course_category_id', $course_category_id);
            $this->db->update('tbl_course_category');
        }

        $course_data['course_category_id'] = $course_category_id;
        $course_data['course_name'] = $course_name;
        $course_data['resource_person_id'] = $data['person_info']->resource_person_id;
        $course_data['person_id'] = $this->session->userdata('user_id');

        if ($course_name != '') {
            $course_name = str_replace(' ', '-', $course_name);
            $i = 1;
            do {
                $result = $this->f_end_model->check_url($course_name);
                if ($result) {
                    $course_name = $course_name . $i;
                    $i++;
                }
            } while ($result);
            $udata['url'] = $course_name;
        }

        $udata['url_type'] = '1';
        $udata['url_status'] = '1';
        $this->db->insert('tbl_url', $udata);
        $course_data['url_id'] = $this->db->insert_id();

        $course_data['course_type'] = $course_type;
        $course_data['course_price'] = $course_price;
        $course_data['course_language'] = 'English';
        $course_data['course_access_level'] = 1;
        $course_data['course_level'] = 1;
        $course_data['course_status'] = 3;

        $this->cr_model->save_course_info($course_data);

        if ($data['person_info']->feature_price_id != NULL) {
            $data['feature_info'] = $this->classroom_model->select_feture_detail($data['person_info']->feature_price_id);
            $data['total_attendees'] = $data['feature_info']->virtual_classroom_attendees_number;
        } else {
            $data['total_attendees'] = 9;
        }

        if ($data['person_info']->person_role == 3) {
            $organization_id = $this->session->userdata('organization_id');
            if ($organization_id) {
                $data['org_resource_person'] = $this->classroom_model->select_organization_resource_person_by_org_id($organization_id);
                $config = array();
                $config['tt'] = TRUE;
                $config['org_pending'] = TRUE;
                $config['org_approved'] = TRUE;
                $config['other_approved'] = TRUE;
                $data['course_categories'] = $this->user_course_model->select_org_course_category($data['person_info']->person_id, $data['org_resource_person'], $config);
            } else { //Individual Teacher
                $data['course_categories'] = $this->user_course_model->select_resource_person_course_category($data['person_info']->person_id);
            }
        } else if ($data['person_info']->person_role == 4) {
            $organization_id = $this->session->userdata('organization_id');
            $data['org_resource_person'] = $this->classroom_model->select_organization_resource_person_by_org_id($organization_id);
            $config = array();
            $config['tt'] = TRUE;
            $config['org_pending'] = TRUE;
            $config['org_approved'] = TRUE;
            $config['other_approved'] = TRUE;
            $data['course_categories'] = $this->user_course_model->select_org_course_category($data['person_info']->person_id, $data['org_resource_person'], $config);
        }

        $category_info = $this->cr_model->select_course_category_info($course_category_id);
        if ($category_info->person_id == $person_id) {
            $data['courses'] = $this->classroom_model->select_category_course($course_category_id, TRUE, TRUE);
        } else {
            $data['courses'] = $this->classroom_model->select_others_category_course($course_category_id, FALSE, TRUE);
        }
        foreach ($data['courses'] as $v_course) {
            $data['class_session_number'][$v_course->course_id] = $this->classroom_model->select_class_session_number($person_id, $v_course->course_id);
        }

        echo $this->load->view('user/class/schedule_class_course_selection', $data);
    }

    public function preview_email($classroom_id = null) {
        $data = array();
        $data['email_message'] = $this->input->post('message', FALSE);

        $data['classroom_info'] = $this->classroom_model->select_classroom_info($classroom_id);
        echo $this->load->view('user/class/email_preview', $data);
    }

    public function class_schedual_invite_to_learner($url) {

// Left AND Right Sidebar Content Information
        $right_side_content = array('FALSE');
        $right_side_content['quizes'] = TRUE;
        $right_side_content['popular_group'] = TRUE;
        $right_side_content['suggested_link'] = TRUE;
        $right_side_content['tt_online_course'] = TRUE;
        $data = $this->populate_right_side($right_side_content);

        $person_id = $this->session->userdata('user_id');
        $person_role = $this->session->userdata('person_role');
        $data['active_menu'] = $this->session->userdata('active_menu');
        $data['active_sub_menu'] = $this->session->userdata('active_sub_menu');
        $data['active_sub_menu_item'] = $this->session->userdata('active_sub_menu_item');
        $data['tab'] = 'invite_learners';
        $data['left_content'] = $this->load->view('user/side_menu', $data, TRUE);
        $data['right_content'] = $this->load->view('user/right_content', $data, TRUE);

        $data['classroom_info'] = $this->classroom_model->select_classroom_info_by_url($url);

        $classroom_id = $data['classroom_info']->classroom_id;
        $data['classroom_id'] = $classroom_id;

        $data['classroom_info'] = $this->classroom_model->select_classroom_info_by_id($classroom_id);
        $data['course_id'] = $course_id = $data['classroom_info']->course_id;
        $data['course_info'] = $this->classroom_model->select_course_info_by_id($course_id);
        $data['course_student'] = $this->user_course_model->select_course_student_list($course_id);
// my link
        if ($data['course_info']->course_access_level == 3) {
            $data['link_person'] = $this->user_course_model->select_link_person($person_id);
        }
// Only Group
        else if ($data['course_info']->course_access_level == 4) {
            $data['group'] = $this->user_course_model->select_group_by_person_id($person_id);
//select_group_information_by_id($group_id);
        }
// Special Person
        else if ($data['course_info']->course_access_level == 5) {
            $data['all_tt_user'] = $this->user_course_model->select_all_talhatraining_user();  //only Organization / Trainer / Student
        }

        if ($person_role == 3) {
            $data['person_info'] = '';
        } else if ($person_role == 4) {
            $data['person_info'] = $this->profile_model->organization_info_by_person_id($person_id);
            $data['resource_persons'] = $this->user_course_model->select_organization_all_resource_persons($data['person_info']->organization_id);
        }
        $this->form_validation->set_rules('invitation_email', 'Invitation Email', 'trim|xss_clean|');
        $this->form_validation->set_rules('invitation_message', 'Invitation Message', 'trim|xss_clean|');

        if ($this->form_validation->run() == FALSE) {

// Right Sidebar Content Information

            $data['quizes'] = $this->quiz_model->select_sugested_quiz();
            $data['popular_group'] = $this->group_model->select_popular_group();
//Start suggested Link
            $data['person_link'] = $this->profile_model->select_person_link();
            if ($data['person_link']) {
                $link['person_id'] = array('FALSE');
                $link['requested_person_id'] = array('FALSE');
                foreach ($data['person_link'] as $v_person_link) {
                    if ($v_person_link->person_id != $person_id) {
                        $person_linked[$v_person_link->person_id] = TRUE;
                    }
                    if ($v_person_link->requested_person_id != $person_id) {
                        $person_linked[$v_person_link->requested_person_id] = TRUE;
                    }
                }
            }

            $data['suggested_link'] = $this->profile_model->select_suggested_link();

            foreach ($data['suggested_link'] as $v_suggested_link) {
                if (!$person_linked[$v_suggested_link->person_id] && !$person_linked[$v_suggested_link->person_id]) {
                    $data['link_info'][$v_suggested_link->person_id] = $this->profile_model->select_link_person_info($v_suggested_link->person_id);
                }
                if (!$person_linked[$v_suggested_link->requested_person_id] || !$person_linked[$v_suggested_link->requested_person_id]) {
                    $data['link_info'][$v_suggested_link->requested_person_id] = $this->profile_model->select_link_person_info($v_suggested_link->requested_person_id);
                }
            }
//End suggested Link
            $data['tt_online_course'] = $this->course_model->select_tt_online_course();

// LOAD VIEW //NEW VIEW 
            $data['main_content'] = $this->load->view('user/class/invite_learner', $data, true);
            $this->load->view('user/master', $data);
// PROTOTYPE VIEW
      } else {
            if ($_POST['btn'] == 'Skip Invite Learner') {
                redirect('schedule-review-and-publish/' . $course_id);
            } else if ($_POST['btn'] == 'Invite Learner') {
                /*
                 * Start Send Invitation Mail 
                 */
                $to_addresses = '';
                $data['person_info'] = array();
                $to_address = trim($this->input->post('to_address', true));
                $to_address = explode(",", $to_address);

// Insert Person Email to tbl_course_person_permission for PUBLIC
                if ($data['course_info']->course_access_level == 1) {
                    for ($i = 0; $i < count($to_address); $i++) {
                        $data['person_info'][$to_address[$i]] = $this->user_course_model->select_user_information_by_email($to_address[$i]);
                        $to_addresses .= $to_address[$i] . ', ';

                        $person_permission_info = $this->user_course_model->check_person_course_permission($data['course_info']->course_id, $to_address[$i]);
//
                        if (!$person_permission_info) {
                            $course_permission_id[] = $this->user_course_model->set_course_permission($data['course_info']->course_id, $to_address[$i]);
                        } else {
                            $course_permission_id[] = $person_permission_info->course_person_permission_id;
                            $this->user_course_model->update_course_permission($person_permission_info->course_person_permission_id);
                        }
                    }
                }

// Insert Eerson email to tbl_course_permission for LINK
                else if ($data['course_info']->course_access_level == 3) {
                    array_pop($to_address);
                    for ($i = 0; $i < count($to_address) - 1; $i++) {
                        $data['person_info'][$to_address[$i]] = $this->user_course_model->select_user_information_by_id($to_address[$i]);
                        $to_addresses .= $data['person_info'][$to_address[$i]]->person_email . ', ';

                        $person_permission_info = $this->user_course_model->check_person_course_group_permission($data['course_info']->course_id, $to_address[$i]);

                        if (!$person_permission_info) {
                            $course_permission_id[] = $this->user_course_model->set_course_permission($data['course_info']->course_id, $data['person_info'][$to_address[$i]]->person_email);
                        } else {
                            $course_permission_id[] = $person_permission_info->course_person_permission_id;
                            $this->user_course_model->update_course_permission($person_permission_info->course_person_permission_id);
                        }
                    }
                }

// Insert person-id to tbl_course_permission for Only GROUPS
                else if ($data['course_info']->course_access_level == 4) {
                    $to_address = array();
                    $selected_group_id = trim($this->input->post('to_address', true));
                    $selected_group_id = explode(",", $selected_group_id);
                    array_pop($selected_group_id);

                    for ($i = 0; $i < count($selected_group_id); $i++) {

                        $group_permission_info = $this->user_course_model->check_person_course_group_permission($data['course_info']->course_id, $selected_group_id[$i]);
                        if (!$group_permission_info) {
                            $course_permission_id[] = $this->user_course_model->set_course_group_permission($data['course_info']->course_id, $selected_group_id[$i]);
                        } else {
                            $course_permission_id[] = $group_permission_info->course_group_permission_id;
                            $this->user_course_model->update_course_group_permission($group_permission_info->course_group_permission_id);
                        }
                        $data['group_member'] = $this->user_course_model->select_group_member($selected_group_id[$i]);
                        foreach ($data['group_member'] as $v_group_member) {
                            $to_address[] = $v_group_member->person_email;
                            $data['person_info'][$v_group_member->person_id] = $this->user_course_model->select_user_information_by_id($v_group_member->person_id);
                            $to_addresses .= $data['person_info'][$v_group_member->person_id]->person_email . ', ';
                        }
                    }

                }
// Insert person-id to tbl_course_permission for SPECIAL User
                else if ($data['course_info']->course_access_level == 5) {
                    array_pop($to_address);

                    for ($i = 0; $i < count($to_address) - 1; $i++) {
                        $data['person_info'][$to_address[$i]] = $this->user_course_model->select_user_information_by_id($to_address[$i]);
                        $to_addresses .= $data['person_info'][$to_address[$i]]->person_email . ', ';

                        $person_permission_info = $this->user_course_model->check_person_course_group_permission($data['course_info']->course_id, $to_address[$i]);

                        if (!$person_permission_info) {
                            $course_permission_id[] = $this->user_course_model->set_course_permission($data['course_info']->course_id, $data['person_info'][$to_address[$i]]->person_email);
                        } else {
                            $course_permission_id[] = $person_permission_info->course_person_permission_id;
                            $this->user_course_model->update_course_permission($person_permission_info->course_person_permission_id);
                        }
                    }
                }

                /*
                 * Collect Email Subject and Message
                 */
                $data['subject'] = $this->input->post('subject', TRUE);
                $data['message'] = $this->input->post('invitation_message', FALSE);
                /*
                 * Sending Email To Users
                 */

                $mdata = array();
                if ($data['course_info']->course_access_level == 4) { // for GROUP
                    $g = 0;
                    for ($i = 0; $i < count($to_address); $i++) {
                        $mdata['from_address'] = $this->session->userdata('user_email');
                        $mdata['company_name'] = 'Talha Training';
                        $mdata['admin_name'] = 'Talha Training Administrator';

                        $mdata['to_address'] = $to_address[$i];

                        $mdata['to_addresses'] = $to_addresses;
                        $mdata['subject'] = 'Course Invitation for Enrole';
                        $mdata['message'] = $data['message'];
                        $mdata['classroom_info'] = $data['classroom_info'];
                        $mdata['course_permission_id'] = $course_permission_id[$g++];
                        $mdata['course_info'] = $data['course_info'];
                        $this->mailer_model->send_email_to_learners($mdata, 'invite_schedule_to_learners');
                    }
                } else {
                    for ($i = 0; $i < count($to_address); $i++) {  // Public, Special,  TT user
                        $mdata['from_address'] = $this->session->userdata('user_email');
                        $mdata['company_name'] = 'Talha Training';
                        $mdata['admin_name'] = 'Talha Training Administrator';

                        if ($data['person_info'][$to_address[$i]]->person_email) {
                            $mdata['to_address'] = $data['person_info'][$to_address[$i]]->person_email;
                        } else {
                            $mdata['to_address'] = $to_address[$i];
                        }
                        $mdata['to_addresses'] = $to_addresses;
                        $mdata['subject'] = 'Course Invitation for Enrole';
                        $mdata['message'] = $data['message'];

                        $mdata['classroom_info'] = $data['classroom_info'];

                        $mdata['course_permission_id'] = $course_permission_id[$i];
                        $mdata['course_info'] = $data['course_info'];

                        $this->mailer_model->send_email_to_learners($mdata, 'invite_schedule_to_learners');
                    }
                }
                /*
                 * END Send Invitation Mail 
                 */

                /*
                 * Below PART WILL BE REMOVE 
                 */
                $sdata = array();
                $sdata['message'] = '<span class="success">Invitation Mail Sent Succesfully';
                $this->session->set_userdata($sdata);

                $person_id = $this->session->userdata('user_id');
                $person_role = $this->session->userdata('person_role');
                $data['active'] = '';
                $data['tab'] = 'review_and_publish';

                $data['course_id'] = $course_id;
                $data['course_info'] = $this->user_course_model->select_course_info($course_id);
//NEW VIEW


                $data['main_content'] = $this->load->view('user/class/review_and_publish', $data, true);
                $this->load->view('user/master', $data);
                return;
                /*
                 * ABOVE PART WILL BE REMOVE 
                 */
                redirect('schedule-review-and-publish/' . $course_id);
            } else {
                $sdata = array();
                $sdata['message'] = '<span class="danger">Please Enter Requred invitation  field to add a new Course</span>';
                $this->session->set_userdata($sdata);
                redirect('create-course');
            }
        }
    }

    public function schedule_review_and_publish($url) {
// Left AND Right Sidebar Content Information
        $right_side_content = array('FALSE');
        $right_side_content['quizes'] = TRUE;
        $right_side_content['popular_group'] = TRUE;
        $right_side_content['suggested_link'] = TRUE;
        $right_side_content['tt_online_course'] = TRUE;
        $data = $this->populate_right_side($right_side_content);

        $person_id = $this->session->userdata('user_id');
        $person_role = $this->session->userdata('person_role');
        $data['active_menu'] = $this->session->userdata('active_menu');
        $data['active_sub_menu'] = $this->session->userdata('active_sub_menu');
        $data['active_sub_menu_item'] = $this->session->userdata('active_sub_menu_item');
        $data['tab'] = 'review_and_publish';
        $data['left_content'] = $this->load->view('user/side_menu', $data, TRUE);
        $data['right_content'] = $this->load->view('user/right_content', $data, TRUE);

        $data['classroom_info'] = $this->classroom_model->select_classroom_info_by_url($url);
        if (!$data['classroom_info']) {
            redirect();
        }
        $data['course_info'] = $this->classroom_model->select_course_info_by_id($data['classroom_info']->course_id);
        if (!$data['course_info']) {
            redirect();
        }
        $data['classroom_id'] = $data['classroom_info']->classroom_id;
        $data['course_id'] = $data['classroom_info']->course_id;

// LOAD VIEW
        $data['main_content'] = $this->load->view('user/class/review_and_publish', $data, true);
        $this->load->view('user/master', $data);
    }

    public function publish_class($url) {

// Left AND Right Sidebar Content Information
        $person_id = $this->session->userdata('user_id');
        $person_role = $this->session->userdata('person_role');

        $data['classroom_info'] = $this->classroom_model->select_classroom_info_by_url($url);
        if (!$data['classroom_info']) {
            redirect();
        }
        $data['course_info'] = $this->user_course_model->select_course_info($data['classroom_info']->course_id);
        if (!$data['course_info']) {
            redirect();
        }

        $data['classroom_id'] = $data['classroom_info']->classroom_id;
        $data['course_id'] = $data['classroom_info']->course_id;

        $this->db->set('classroom_status', 0);
        $this->db->where('classroom_id', $data['classroom_info']->classroom_id);
        $this->db->update('tbl_classroom');

        redirect('classroom/upcoming-class');
    }

    public function launch_class($url) {

// Left AND Right Sidebar Content Information
        $person_id = $this->session->userdata('user_id');
        $person_role = $this->session->userdata('person_role');

        $data['classroom_info'] = $this->classroom_model->select_classroom_info_by_url($url);
        if (!$data['classroom_info']) {
            redirect();
        }
        $data['course_info'] = $this->user_course_model->select_course_info($data['classroom_info']->course_id);
        if (!$data['course_info']) {
            redirect();
        }

        $data['classroom_id'] = $data['classroom_info']->classroom_id;
        $data['course_id'] = $data['classroom_info']->course_id;
        redirect('start-class/' . $data['classroom_info']->classroom_id);
    }

    public function update_classroom_url($urlID, $NewURL) {

        $NewURL = str_replace("%20", " ", $NewURL);
        $this->profile_model->update_person_url($urlID, $NewURL);
        $data['classroom_info'] = $this->classroom_model->select_classroom_info_by_url($NewURL);
        echo $this->load->view('user/class/review_publish_updated_url_view', $data, TRUE);
    }

    public function edit_scheduled_class($url) {
// Left AND Right Sidebar Content Information
        $right_side_content = array('FALSE');
        $right_side_content['quizes'] = TRUE;
        $right_side_content['popular_group'] = TRUE;
        $right_side_content['suggested_link'] = TRUE;
        $right_side_content['tt_online_course'] = TRUE;
        $data = $this->populate_right_side($right_side_content);

        $person_id = $this->session->userdata('user_id');
        $person_role = $this->session->userdata('person_role');
        $data['active_menu'] = $this->session->userdata('active_menu');
        $data['active_sub_menu'] = $this->session->userdata('active_sub_menu');
        $data['active_sub_menu_item'] = $this->session->userdata('active_sub_menu_item');
        $data['left_content'] = $this->load->view('user/side_menu', $data, TRUE);
        $data['right_content'] = $this->load->view('user/right_content', $data, TRUE);

        $data['classroom_info'] = $this->classroom_model->select_classroom_info_by_url($url);
        $classroom_id = $data['classroom_info']->classroom_id;

        $this->form_validation->set_rules('classroom_title', 'Classroom Title', 'required|trim|max_length[100]|xss_clean');
        $this->form_validation->set_rules('class_date', 'Classroom Date', 'required|trim||xss_clean');
        $this->form_validation->set_rules('classroom_instruction', 'Classroom Instruction', 'trim|max_length[250]|xss_clean');
        $this->form_validation->set_rules('class_start_time', 'Classroom Start Time Hour', 'required|trim|xss_clean');
        $this->form_validation->set_rules('duration', 'Duration Minute', 'required|trim|xss_clean');
        $this->form_validation->set_rules('selected_course_id', 'Classroom course ID ', 'required|trim|xss_clean');
        $this->form_validation->set_rules('classroom_record_status', 'Classroom Record Status', 'required|trim|xss_clean');
        $this->form_validation->set_rules('classroom_language', 'Classroom Language', 'trim|xss_clean');
        $this->form_validation->set_rules('webcam', 'webcam');
        $this->form_validation->set_rules('audio', 'audio');

        if ($this->form_validation->run() == FALSE) {

            $data['person_info'] = $this->profile_model->person_info_by_person_id($person_id);
            if ($data['person_info']->feature_price_id != NULL) {
                $data['feature_info'] = $this->classroom_model->
                        select_feture_detail($data['person_info']->feature_price_id);
                $data['total_attendees'] = $data['feature_info']->virtual_classroom_attendees_number;
            } else {
                $data['total_attendees'] = 9;
            }

            if ($data['person_info']->person_role == 4) {
                $organization_id = $this->session->userdata('organization_id');
                $data['org_resource_person'] = $this->classroom_model->select_organization_resource_person_by_org_id($organization_id);
                $config = array();
                $config['tt'] = TRUE;
                $config['org_pending'] = TRUE;
                $config['org_approved'] = TRUE;
                $config['other_approved'] = TRUE;
                $data['course_categories'] = $this->user_course_model->select_org_course_category($data['person_info']->person_id, $data['org_resource_person'], $config);
            } $data['main_content'] = $this->load->view('user/class/edit_scheduled_class', $data, true);
            $this->load->view('user/master', $data);
//PROTOTYPE VIEW

        } else {
            if ($_POST) {
                $this->classroom_model->update_class_schedule_information($classroom_id);
                $sdata = array();
                $sdata['message'] = '<span class="success">Course Schedule Updated Successfully';
                $this->session->set_userdata($sdata);
                $data['classroom_info'] = $this->classroom_model->select_classroom_info($classroom_id);
                redirect('class-schedual-invite-to-learner/' . $data['classroom_info']->url);
            }
        }
    }

    public function online_classroom() {
        $data['user_role'] = '';
        $data['active'] = 'online_classroom';
        $resource_person_id = $this->session->userdata('user_id');
        $data['attendee'] = $this->cr_model->select_class_room_student($resource_person_id);
        $this->load->view('f_end/classroom/online_classroom', $data);
    }

    public function start_class($url) {
        $data = array();
        $sdata = array();
        $data['user_role'] = '';
        $data['active'] = 'online_classroom';
        $person_id = $this->session->userdata('user_id');
        $person_role = $this->session->userdata('user_role');
        $organization_id = $this->session->userdata('organization_id');
        $classroom_id = $this->session->userdata('classroom_id');
        if ($person_id == null || $person_role != 3 || $person_role != 4) {
            
        } else {
            $sdata['message'] = "<p style='color:red;'>Sorry you can\'t start any class";
            $this->session->set_userdata($sdata);
            redirect('sign-in');
        }

        $data['classroom_info'] = $this->classroom_model->select_classroom_info_by_url($url);
        $classroom_id = $data['classroom_info']->classroom_id;
        $course_id = $data['classroom_info']->course_id;
        /**
         * START Classroom Availability Checking
         * Organization Running Class is = or < Available Classroom // it can't be greater
         * If == then redirect to course detail page and give a message
         */
        $data['person_info'] = $this->profile_model->person_info_by_person_id($person_id);

        $result = $this->cr_model->select_person_active_classroom_by_person_id($person_id);
        if ($result) {

            $this->cr_model->inactivate_classroom($result->classroom_id); // not started ==0
            if ($result->person_id == $person_id) {
                redirect('start-class/' . $result->url);
            }
        }

        if ($data['person_info']->feature_price_id) {

            $data['org_all_active_resource_person'] = $this->classroom_model->select_organization_active_resource_person_by_org_id($organization_id);
            $active_class = 0;
            foreach ($data['org_all_active_resource_person'] as $v_person) {
                $result = $this->cr_model->select_person_active_classroom_by_person_id($v_person->person_id);
                if ($result) {
                    $active_class++;
                }
            }

            $data['feature_info'] = $this->cr_model->organization_feature_info($data['person_info']->feature_price_id);
            if ($active_class == $data['feature_info']->virtual_classroom_number) {
                $sdata['message'] = "<p style='color:red;'>Theire is no available class room now </p>";
                $this->session->set_userdata($sdata);
                redirect('classroom/current-class');
            }
        } else {
// Free Class 
            $data['current_classroom_list'] = $this->cr_model->select_current_classroom($organization_id);
            $result = $this->cr_model->select_person_active_classroom_by_person_id($person_id);
            if ($result) {
                if ($result->person_id == $person_id) {
                    $sdata['message'] = "<p style='color:red;'>Your another class is running</p>";
                    $this->session->set_userdata($sdata);
                    redirect('classroom/current-class');
                }
            }

            if (count($data['current_classroom_list']) == 1) {
                $sdata['message'] = "<p style='color:red;'>Their is no available class room now </p>";
                $this->session->set_userdata($sdata);
                redirect('classroom/current-class');
            }
        }
        /*
         * End Classroom Availability Checking
         */
        /*
         * Checking schedule time
         */

        $person_time_zone = $data['person_info']->person_time_zone;
        date_default_timezone_set("$person_time_zone");
        $class_start_time = date('Y-m-d H:i:s', strtotime($data['classroom_info']->class_start_time));
        $now = date('Y-m-d H:i:s');
        if ($now >= $class_start_time) {

            $this->cr_model->activate_classroom($classroom_id);
        }

        /*
         * END checking schedule time
         */
//Now we can Proceed to START CLASS 

        $data['resource_person_info'] = $this->cr_model->select_course_resource_person($course_id);
        $class_time_in_second = $data['resource_person_info']->class_hour_per_day * 60 * 60;

//SELECT Unexpectedly End classroom
        $data['unexpectedly_end_classroom'] = $this->cr_model->select_classroom_info_by_person_id($person_id, $class_time_in_second);
        if ($data['unexpectedly_end_classroom']) {
            $sdata['classroom_id'] = $classroom_id = $data['unexpectedly_end_classroom']->classroom_id;
        }

        if (!$classroom_id) {
//Save New ClassRoom if no Active Classroom id
            $sdata['classroom_id'] = $classroom_id = $this->cr_model->save_started_classroom_information($person_id, $course_id, $organization_id);
            $data['classroom_info'] = $this->cr_model->select_classroom_info_by_id($classroom_id);
        }

        $this->session->set_userdata($sdata);

        $data['classroom_info'] = $this->cr_model->select_classroom_info_by_id($classroom_id);

        /* ACTIVATE CLASSROOM AGAIN for Leave OR Unexpectedly End Classroom */
        $class_possible_end_time = date("H:i:s", strtotime($data['classroom_info']->class_start_time) + $class_time_in_second);
//
        $now = date("H:i:s");
        if ($data['classroom_info']->classroom_status == 3 && $now < $class_possible_end_time) {
            $this->cr_model->activate_classroom($classroom_id);
        }

        $data['all_students'] = $this->cr_model->select_class_room_student($course_id);
        foreach ($data['all_students'] as $v_course_student) {
            $data['attendee_student'][$v_course_student->student_id] = $this->cr_model->select_class_room_attended_student($v_course_student->student_id);
        }

        $this->load->view('f_end/classroom/online_classroom', $data);
    }

    public function save_active_classroom_last_time($classroom_id) {
        $last_active_time = date('H:i:s');
        $this->cr_model->save_active_classroom_last_time($last_active_time, $classroom_id);
    }

    public function save_active_classroom_student_leave_time($classroom_student_id) {
        $class_leave_time = date('H:i:s');
        $this->cr_model->save_active_classroom_student_leave_time($class_leave_time, $classroom_student_id);
    }

    /*
     * Student Attend in a class using this function 
     * function paremeter $classroom_id
     */

    public function attend_in_class($course_id) {
        $data = array();
        $sdata = array();
        $crs_data = array();

        $person_id = $this->session->userdata('user_id');
        $data ['user_role'] = '';
        $data['active'] = 'online_classroom';
// Course Resource Person Information 
// Also Course Information 
        $data['curse_info'] = $this->cr_model->select_course_info($course_id);
        $data['resource_person_info'] = $this->cr_model->select_course_resource_person($course_id);
        $class_time_in_second = $data['resource_person_info']->class_hour_per_day * 60 * 60;

        /* SELECT RECENTLY RUNNING Classroom */
        $data['classroom_info'] = $this->cr_model->select_recent_classroom_info($course_id);

        $data['student_info'] = $this->cr_model->select_student_info($person_id);
        $classroom_student_id = $this->session->userdata('classroom_student_id');
        if ($data['classroom_info']) {
            $data['classroom_student_info'] = $this->cr_model->select_classroom_student_information($data['classroom_info']->classroom_id, $data['student_info']->student_id);
            $sdata['classroom_student_id'] = $classroom_student_id =  $data['classroom_student_info']->classroom_student_id;
        }

        if (!$classroom_student_id && $data ['classroom_info']) {
            $crs_data['classroom_id'] = $data['classroom_info']->classroom_id;
            $crs_data['student_id'] = $data['student_info']->student_id;
            $crs_data['attendance_time'] = date('H:i:s');
            $crs_data['classroom_student_join_status'] = 1;
            $sdata['classroom_student_id'] = $classroom_student_id = $this->cr_model->save_classroom_student($crs_data);
        }
        $this->session->set_userdata($sdata);

        if ($classroom_student_id) {
            $data['classroom_student_info'] = $this->cr_model->
                    select_classroom_student_info($classroom_student_id);
        }

        /* ACTIVATE CLASSROOM AGAIN for Leave OR Unexpectedly End Classroom */
        $class_possible_end_time = date("H:i:s", strtotime($data['classroom_info']->
                        class_start_time) + $class_time_in_second);
        $now = date("H:i:s");
        if ($data['classroom_student_info']->classroom_student_join_status == 2 && $now < $class_possible_end_time) {
            $this->cr_model->activate_classroom_student_again($classroom_student_id);
        }

        /**
         * SELECT Course All Student 
         * SELECT Classroom Attended Student
         */
        $data['all_students'] = $this->cr_model->select_class_room_student($course_id);
        foreach ($data['all_students'] as $v_course_student) {
            $data['attendee_student'][$v_course_student->student_id] = $this->cr_model->select_class_room_attended_student($v_course_student->student_id);
        }

        if (!$data['classroom_info']) {
            $sdata = array();
            $sdata['message'] = "<p style='color:red'>This Course Class is not running Currently<p>";
            $this->session->set_userdata($sdata);
            redirect($data['curse_info']->url);
        }
        $this->load->view('f_end/classroom/online_classroom', $data);
    }

    public function end_session($course_id, $classroom_id) {
        $data['curse_info'] = $this->cr_model->select_course_info($course_id);
        $this->cr_model->end_session($classroom_id);
        $this->session->unset_userdata('classroom_id');
        redirect($data['curse_info']->url);
    }

    public function end_session_from_current_classroom($classroom_id) {
        $this->cr_model->end_session($classroom_id);
        $this->session->unset_userdata('classroom_id');
        redirect('current-classroom/');
    }

    public function leave_classroom($course_id, $classroom_student_id) {
        $data['curse_info'] = $this->cr_model->select_course_info($course_id);
        $this->cr_model->leave_classroom($classroom_student_id);
        $this->session->unset_userdata('classroom_student_id');
        redirect($data['curse_info']->url);
    }

    public function current_classroom() {
        $data = array();
        $data['active'] = '';
        $data['tab'] = 'course_profile';

        $person_id = $this->session->userdata('user_id');
        $organization_id = $this->session->userdata('organization_id');
        $data['person_info'] = $this->profile_model->person_info_by_person_id($person_id);
        $data['feature_info'] = $this->cr_model->organization_feature_info($data['person_info']->feature_price_id);
        $data['current_classroom_list'] = $this->cr_model->select_current_classroom($organization_id);

//Attended Student Information
        foreach ($data['current_classroom_list'] as $v_classroom) {
            $data['attended_student_list'][$v_classroom->classroom_id] = $this->cr_model->select_attended_student($v_classroom->classroom_id);
            $data['total_student'][$v_classroom->classroom_id] = count($this->cr_model->select_attended_student($v_classroom->classroom_id));
            $data['total_active_student'][$v_classroom->classroom_id] = count($this->cr_model->select_active_student($v_classroom->classroom_id));
            $data['total_unexpectedly_leave_student'][$v_classroom->classroom_id] = count($this->cr_model->select_unexpectedly_leave_student($v_classroom->classroom_id));
        }
        $data['main_content'] = $this->load->view('f_end/classroom/current_classroom_list', $data, true);
        $this->load->view('f_end/f_end_master', $data);
    }

    public function classroom_detail($classroom_id) {
        $data = array();
        $data['active'] = '';
        $data ['tab'] = 'course_profile';

        $person_id = $this->session->userdata('user_id');

        $organization_id = $this->session->userdata('organization_id');
        $data['person_info'] = $this->profile_model->person_info_by_person_id($person_id);
        $data['feature_info'] = $this->cr_model->organization_feature_info(
                $data['person_info']->feature_price_id);
//currently running classroom 
        $data['current_classroom_list'] = $this->cr_model->select_current_classroom($organization_id);
//Classroom Detail Information by Classroom ID


        $data['classroom_detail'] = $this->cr_model->select_classroom_info_by_id($classroom_id);
        $data['classroom_student_list'] = $this->cr_model->select_classroom_student($classroom_id);

        $data['main_content'] = $this->load->view(
                'f_end/classroom/classroom_detail', $data, true);
        $this->load->view('f_end/f_end_master', $data);
    }

    public function update_classroom_status($classroom_id) {
        $this->cr_model->update_classroom_status(10);
        $this->session->unset_userdata('classroom_id');
    }

    /* MY CLASS Management */

    public function my_class() {
        $person_id = $this->session->userdata('user_id');
        $person_role = $this->session->userdata('person_role');

        $data = array();

//Student Classes
        $data['student_classes'] = $this->cr_model->select_student_Classes($person_id);
//
//        //Resource Person Classes
        if ($person_role = 3) {
            $data['resource_person_classes'] = $this->cr_model->select_resource_person_Classes($person_id);
        }

        $data['my_class'] = array_merge($data['resource_person_classes'], $data['student_classes']);

        $data['main_content'] = $this->load->view('user/class/upcoming_class', $data, true);
        $this->load->view('user/master', $data);
    }

    public function upcoming_class($start = NULL) {
        $active_menu = $this->session->userdata('active_menu');

        if ($active_menu == 'organization') {
            $this->organization_upcoming_class($start);
        }

        if ($active_menu == 'teacher') {
            $this->teacher_upcoming_class($start);
        }

        if ($active_menu == 'student') {
            $this->student_upcoming_class($start);
        }
    }

    public function current_class($start = NULL) {
        $active_menu = $this->session->userdata('active_menu');
        if ($active_menu == 'organization') {
            $this->organization_current_class($start);
        }

        if ($active_menu == 'teacher') {
            $this->teacher_current_class($start);
        }

        if ($active_menu == 'student') {
            $this->student_current_class($start);
        }
    }

    public function previous_class($start = NULL) {
        $active_menu = $this->session->userdata('active_menu');

        if ($active_menu == 'organization') {
            $this->organization_previous_class($start);
        }

        if ($active_menu == 'teacher') {
            $this->teacher_previous_class($start);
        }

        if ($active_menu == 'student') {
            $this->student_previous_class($start);
        }
    }

// Student Class
    public function student_upcoming_class() {
        $data = array();
        $person_id = $this->session->userdata('user_id');
        $person_role = $this->session->userdata('person_role');
        $data['active_menu'] = 'student';
        $data['active_sub_menu'] = 'upcomming';
        $data['left_content'] = $this
                ->load->view('user/side_menu', $data, TRUE);
        $data['right_content'] = $this->load->view('user/right_content', $data, TRUE);

        $data['classes'] = $this->cr_model->select_student_upcoming_classes($person_id);
        $data['main_content'] = $this->load->view('user/class/my_classes', $data, true);
        $this->load->view('user/master', $data);
    }

    public function student_current_class() {
        $data = array();
        $person_id = $this->session->userdata('user_id');
        $person_role = $this->session->userdata('person_role');
        $data['active_menu'] = 'student';
        $data['active_sub_menu'] = 'current';
        $data['left_content'] = $this->load->view('user/side_menu', $data, TRUE);
        $data['right_content'] = $this->load->view('user/right_content', $data, TRUE);
        $data['classes'] = $this->cr_model->select_student_current_classes($person_id);
        $data['main_content'] = $this->load->view('user/class/my_classes', $data, true);
        $this->load->view('user/master', $data);
    }

    public function student_previous_class() {
        $data = array();
        $person_id = $this->session->userdata('user_id');
        $person_role = $this->session->userdata('person_role');

        $data['active_menu'] = 'student';
        $data['active_sub_menu'] = 'previous';
        $data['left_content'] = $this->load->view('user/side_menu', $data, TRUE);
        $data['right_content'] = $this->load->view('user/right_content', $data, TRUE);
        $data['classes'] = $this->cr_model->select_student_upcoming_classes($person_id);
        $data['main_content'] = $this->load->view('user/class/my_classes', $data, true);
        $this->load->view('user/master', $data);
    }

// Teacher Class
    public function learner_upcoming_class() {
        // Left AND Right Sidebar Content Information
        $right_side_content = array('FALSE');
        $right_side_content['quizes'] = TRUE;
        $right_side_content['popular_group'] = TRUE;
        $right_side_content['suggested_link'] = TRUE;
        $right_side_content['tt_online_course'] = TRUE;
        $data = $this->populate_right_side($right_side_content);

        $person_id = $this->session->userdata('user_id');
        $person_role = $this->session->userdata('person_role');
        $sdata = array();
        $data['active_menu'] = $sdata['active_menu'] = 'teacher';
        $data['active_sub_menu'] = $sdata['active_sub_menu'] = 'teacher_classroom';
        $data['active_sub_menu_item'] = $sdata['active_sub_menu_item'] = 'upcoming';
        $this->session->set_userdata($sdata);
        $data['left_content'] = $this->load->view('user/side_menu', $data, TRUE);
        $data['right_content'] = $this->load->view('user/right_content', $data, TRUE);

        $data['start'] = $start = ($this->uri->segment(3)) ? $this->uri->segment(3) : 0;
        $data['limit'] = $limit = 5;

        $data['person_info'] = $this->profile_model->select_link_person_info($person_id);
        $data['total_classes'] = count($this->cr_model->select_teacher_upcoming_classes($person_id, '', ''));
        $data['classes'] = $this->cr_model->select_teacher_upcoming_classes($person_id, $start, $limit);
        $data['this_page'] = count($data['classes']);

        if (!$data['classes']) {
            $sdata = array();
            $sdata['message'] = 'You do not have any Upcoming class';
            $this->session->set_userdata($sdata);
        }



// TALHATRAING UPCOMING AND VIDEO COURSE
        $data['tt_upcomming_course'] = $this->course_model->select_tt_upcoming_course(); //SHORT BY START DATE
        $data['tt_video_course'] = $this->course_model->
                select_tt_video_course(); //SHORT BY START DATE
// LOAD VIEW
        $data['main_content'] = $this->load->view('user/class/my_classes', $data, true);
        $this->load->view('user/master', $data);
    }

    public function teacher_current_class() {
// Left AND Right Sidebar Content Information
        $right_side_content = array('FALSE');
        $right_side_content['quizes'] = TRUE;
        $right_side_content ['popular_group'] = TRUE;
        $right_side_content['suggested_link'] = TRUE;
        $right_side_content['tt_online_course'] = TRUE;
        $data = $this->populate_right_side($right_side_content);

        $person_id = $this->session->userdata('user_id');
        $person_role = $this->session->userdata('person_role');
        $data['active_menu'] = $this->session->userdata('active_menu');
        $data['active_sub_menu'] = $this->session->userdata('active_sub_menu');
        $data['active_sub_menu_item'] = $sdata['active_sub_menu_item'] = 'current';
        $this->session->set_userdata($sdata);
        $data['left_content'] = $this->load->view('user/side_menu', $data, TRUE);
        $data['right_content'] = $this->load->view('user/right_content', $data, TRUE);

        $data['start'] = $start = ($this->uri->segment(3)) ? $this->uri->segment(3) : 0;
        $data['limit'] = $limit = 5;

        $data['person_info'] = $this->profile_model->select_link_person_info($person_id);
        $data['total_classes'] = count($this->cr_model->select_teacher_current_classes($person_id, '', ''));
        $data['classes'] = $this->cr_model->select_teacher_current_classes($person_id, $start, $limit);
        $data['this_page'] = count($data['classes']);

        if (!$data['classes']) {
            $sdata = array();
            $sdata['message'] = 'You do not have any Current class';
            $this->session->set_userdata($sdata);
        }

// TALHATRAING UPCOMING AND VIDEO COURSE
        $data['tt_upcomming_course'] = $this->course_model->select_tt_upcoming_course(); //SHORT BY START DATE
        $data['tt_video_course'] = $this->course_model->select_tt_video_course(); //SHORT BY START DATE
// LOAD VIEW
        $data['main_content'] = $this->load->view('user/class/my_classes', $data, true);
        $this->load->view('user/master', $data);
    }

    public function teacher_previous_class() {
// Left AND Right Sidebar Content Information
        $right_side_content = array('FALSE');
        $right_side_content['quizes'] = TRUE;
        $right_side_content['popular_group'] = TRUE;
        $right_side_content['suggested_link'] = TRUE;
        $right_side_content['tt_online_course'] = TRUE;
        $data = $this->populate_right_side($right_side_content);

        $person_id = $this->session->userdata('user_id');
        $person_role = $this->session->userdata('person_role');
        $data['active_menu'] = $this->session->userdata('active_menu');
        $data['active_sub_menu'] = $this->session->userdata('active_sub_menu');
        $data['active_sub_menu_item'] = $sdata['active_sub_menu_item'] = 'previous';
        $this->session->set_userdata($sdata);
        $data['left_content'] = $this->load->view('user/side_menu', $data, TRUE);
        $data['right_content'] = $this->load->view('user/right_content', $data, TRUE);

        $data['start'] = $start = ($this->uri->segment(3)) ? $this->uri->segment(3) : 0;
        $data['limit'] = $limit = 5;

        $data['person_info'] = $this->profile_model->select_link_person_info($person_id);
        $data['total_classes'] = count($this->cr_model->select_organization_previous_classes($person_id, '', ''));
        $data['classes'] = $this->cr_model->select_organization_previous_classes($person_id, $start, $limit);
        $data['this_page'] = count($data['classes']);

        if (!$data['classes']) {
            $sdata = array();
            $sdata ['message'] = 'You do not have any Previous class';
            $this->session->set_userdata($sdata);
        }


// TALHATRAING UPCOMING AND VIDEO COURSE
        $data['tt_upcomming_course'] = $this->course_model->select_tt_upcoming_course(); //SHORT BY START DATE
        $data['tt_video_course'] = $this->course_model->select_tt_video_course(); //SHORT BY START DATE
// LOAD VIEW
        $data['main_content'] = $this->load->view('user/class/my_classes', $data, true);
        $this->load->view('user/master', $data);
    }

// Organization Class

    public function organization_upcoming_class() {
// Left AND Right Sidebar Content Information
        $right_side_content = array('FALSE');
        $right_side_content['quizes'] = TRUE;
        $right_side_content['popular_group'] = TRUE;
        $right_side_content['suggested_link'] = TRUE;
        $right_side_content['tt_online_course'] = TRUE;
        $data = $this->populate_right_side($right_side_content);

        $person_id = $this->session->userdata('user_id');
        $person_role = $this->session->userdata('person_role');
        $sdata = array();
        $data['active_menu'] = $sdata['active_menu'] = 'organization';
        $data['active_sub_menu'] = $sdata['active_sub_menu'] = 'organization_classroom';
        $data['active_sub_menu_item'] = $sdata['active_sub_menu_item'] = 'upcoming';
        $this->session->set_userdata($sdata);
        $data['left_content'] = $this->load->view('user/side_menu', $data, TRUE);
        $data['right_content'] = $this->load->view('user/right_content', $data, TRUE);

        $data['start'] = $start = ($this->uri->segment(3)) ? $this->uri->segment(3) : 0;
        $data['limit'] = $limit = 5;

        $data['person_info'] = $this->profile_model->select_link_person_info($person_id);

        if ($data['person_info']->person_role == 3) {

            $organization_id = $this->session->userdata('organization_id');
            if ($organization_id) {
                $data['org_resource_person'] = $this->classroom_model->select_organization_resource_person_by_org_id($organization_id);
                $config = array();
                $config['tt'] = TRUE;
                $config['org_pending'] = TRUE;
                $config['org_approved'] = TRUE;
                $config['other_approved'] = TRUE;
                $data['course_categories'] = $this->user_course_model->select_org_course_category($data['person_info']->person_id, $data['org_resource_person'], $config);
            }
        }

        if ($data['person_info']->person_role == 4) {
            $organization_id = $this->session->userdata('organization_id');
            $data['org_resource_person'] = $this->classroom_model->select_organization_resource_person_by_org_id($organization_id);
            $config = array();
            $config['tt'] = TRUE;
            $config['org_pending'] = TRUE;
            $config['org_approved'] = TRUE;
            $config['other_approved'] = TRUE;
            $data['course_categories'] = $this->user_course_model->select_org_course_category($data['person_info']->person_id, $data['org_resource_person'], $config);
        }

        $data['total_classes'] = count($this->cr_model->select_organization_upcoming_classes($data['org_resource_person'], '', ''));
        $data['classes'] = $this->cr_model->select_organization_upcoming_classes($data['org_resource_person'], $start, $limit);
        $data['this_page'] = count($data['classes']);

        if (!$data['classes']) {
            $sdata = array();
            $sdata['message'] = 'You do not have any Upcoming class';
            $this->session->set_userdata($sdata);
        }



// TALHATRAING UPCOMING AND VIDEO COURSE
        $data['tt_upcomming_course'] = $this->course_model->select_tt_upcoming_course(); //SHORT BY START DATE
        $data['tt_video_course'] = $this->course_model->
                select_tt_video_course(); //SHORT BY START DATE
// LOAD VIEW
        $data['main_content'] = $this->load->view('user/class/my_classes', $data, true);
        $this->load->view('user/master', $data);
    }

    public function organization_current_class($start = NULL) {
// Left AND Right Sidebar Content Information
        $right_side_content = array('FALSE');
        $right_side_content['quizes'] = TRUE;
        $right_side_content ['popular_group'] = TRUE;
        $right_side_content['suggested_link'] = TRUE;
        $right_side_content['tt_online_course'] = TRUE;
        $data = $this->populate_right_side($right_side_content);

        $person_id = $this->session->userdata('user_id');
        $person_role = $this->session->userdata('person_role');
        $data['active_menu'] = $this->session->userdata('active_menu');
        $data['active_sub_menu'] = $this->session->userdata('active_sub_menu');
        $data['active_sub_menu_item'] = $sdata['active_sub_menu_item'] = 'current';
        $this->session->set_userdata($sdata);
        $data['left_content'] = $this->load->view('user/side_menu', $data, TRUE);
        $data['right_content'] = $this->load->view('user/right_content', $data, TRUE);

        $data['start'] = $start = ($this->uri->segment(3)) ? $this->uri->segment(3) : 0;
        $data['limit'] = $limit = 5;

        $data['person_info'] = $this->profile_model->select_link_person_info($person_id);

        if ($data['person_info']->person_role == 4) {
            $organization_id = $this->session->userdata('organization_id');
            $data['org_resource_person'] = $this->classroom_model->select_organization_resource_person_by_org_id($organization_id);
            $config = array();
            $config['tt'] = TRUE;
            $config['org_pending'] = TRUE;
            $config['org_approved'] = TRUE;
            $config['other_approved'] = TRUE;
            $data['course_categories'] = $this->user_course_model->select_org_course_category($data['person_info']->person_id, $data['org_resource_person'], $config);
        }

        $data['total_classes'] = count($this->cr_model->select_organization_current_classes($data['org_resource_person'], '', ''));
        $data['classes'] = $this->cr_model->select_organization_current_classes($data['org_resource_person'], $start, $limit);
        $data['this_page'] = count($data['classes']);

        if (!$data['classes']) {
            $sdata = array();
            $sdata['message'] = 'You do not have any Current class';
            $this->session->set_userdata($sdata);
        }

// TALHATRAING UPCOMING AND VIDEO COURSE
        $data['tt_upcomming_course'] = $this->course_model->select_tt_upcoming_course(); //SHORT BY START DATE
        $data['tt_video_course'] = $this->course_model->select_tt_video_course(); //SHORT BY START DATE
// LOAD VIEW
        $data['main_content'] = $this->load->view('user/class/my_classes', $data, true);
        $this->load->view('user/master', $data);
    }

    public function organization_previous_class($start = NULL) {
// Left AND Right Sidebar Content Information
        $right_side_content = array('FALSE');
        $right_side_content['quizes'] = TRUE;
        $right_side_content['popular_group'] = TRUE;
        $right_side_content['suggested_link'] = TRUE;
        $right_side_content['tt_online_course'] = TRUE;
        $data = $this->populate_right_side($right_side_content);

        $person_id = $this->session->userdata('user_id');
        $person_role = $this->session->userdata('person_role');
        $data['active_menu'] = $this->session->userdata('active_menu');
        $data['active_sub_menu'] = $this->session->userdata('active_sub_menu');
        $data['active_sub_menu_item'] = $sdata['active_sub_menu_item'] = 'previous';
        $this->session->set_userdata($sdata);
        $data['left_content'] = $this->load->view('user/side_menu', $data, TRUE);
        $data['right_content'] = $this->load->view('user/right_content', $data, TRUE);

        $data['start'] = $start = ($this->uri->segment(3)) ? $this->uri->segment(3) : 0;
        $data['limit'] = $limit = 5;

        $data['person_info'] = $this->profile_model->select_link_person_info($person_id);
        $data['total_classes'] = count($this->cr_model->select_organization_previous_classes($person_id, '', ''));
        $data['classes'] = $this->cr_model->select_organization_previous_classes($person_id, $start, $limit);
        $data['this_page'] = count($data['classes']);

        if (!$data['classes']) {
            $sdata = array();
            $sdata ['message'] = 'You do not have any Previous class';
            $this->session->set_userdata($sdata);
        }

// TALHATRAING UPCOMING AND VIDEO COURSE
        $data['tt_upcomming_course'] = $this->course_model->select_tt_upcoming_course(); //SHORT BY START DATE
        $data['tt_video_course'] = $this->course_model->select_tt_video_course(); //SHORT BY START DATE
// LOAD VIEW
        $data['main_content'] = $this->load->view('user/class/my_classes', $data, true);
        $this->load->view('user/master', $data);
    }

    public function delete_schedule_class($classroom_id) {
        $data = array();
        $sdata = array();
        $data['show_data'] = '';
        $dta['classroom_info'] = $this->cr_model->select_classroom_info($classroom_id);
        $this->cr_model->delete_schedule_class($classroom_id);
        $data['classroom_info'] = $this->cr_model->select_classroom_info($classroom_id);
        echo $this->load->view('user/class/my_class_actions', $data, true);
    }

    public function cancel_schedule_class($classroom_id) {
        $data = array();
        $sdata = array();
        $data['show_data'] = '';
        $person_id = $this->session->userdata('user_id');
        $data['person_info'] = $this->profile_model->select_link_person_info($person_id);
        $dta['classroom_info'] = $this->cr_model->select_classroom_info($classroom_id);
        $this->cr_model->cancel_schedule_class($classroom_id);
        $data['classroom_info'] = $this->cr_model->select_classroom_info($classroom_id);
        echo $this->load->view('user/class/my_class_actions', $data, true);
    }

    public function reschedule_schedule_class($classroom_id) {
        $data = array();
        $sdata = array();

        $dta['classroom_info'] = $this->cr_model->select_classroom_info($classroom_id);
        $this->cr_model->reschedule_schedule_class($classroom_id);
        $data['classroom_info'] = $this->cr_model->select_classroom_info($classroom_id);
        echo $this->load->view('user/class/my_class_actions', $data, true);
    }

}
