<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Group extends TT_user_login {

    public function __construct() {
        parent::__construct();
        $user_id = $this->session->userdata('user_id');
        if ($user_id == NULL) {
            $sdata = array();
            $sdata['url'] = base_url();
            $i = 1;
            while ($this->uri->segment($i)) {
                $sdata['url'] .= $this->uri->segment($i) . '/';
                $i++;
            }
            $this->session->set_userdata($sdata);
            $this->session->unset_userdata('url');
        }
        
        $data['left_side_menu_view'] = 1;
        $data['left_side'] = 1;
        $this->load->model('f_end_model');
    }


//START LEARNER  GROUP
    public function learner_group($page = NULL) {
        $data = array();
        $sdata = array();
        $user_id = $this->session->userdata('user_id');
        $data['active_menu'] = $sdata['active_menu'] = 'learner';
        $data['active_sub_menu'] = $sdata['active_sub_menu'] = 'learner_group';
        $sdata['redirect'] = 'groups/organization';
        $this->session->set_userdata($sdata);

        //$data['geo_info'][0] = $this->f_end_model->select_person_current_location($user_id);
        $data['left_side'] = 1;
        $data['left_side_menu_view'] = 1;
        if ($page != NULL) {
            $data['page'] = $page;
            $number = $page * 10 - 10;
            $data['serial'] = $number;
        } else {
            $data['page'] = 0;
            $data['serial'] = 0;
            $number = 0;
        }

        $data['count_member_group_list'] = $this->group_model->count_select_student_connected_group($user_id);
        $data['member_group_list'] = $this->group_model->select_student_connected_group($user_id, $number);

        foreach ($data['member_group_list'] as $v_group) {
            $data['total_member'][$v_group->group_id] = $this->group_model->group_total_member($v_group->group_id);
            $data['group_requested_members'][$v_group->group_id] = $this->group_model->select_group_requested_member_list_info($v_group->group_id);
            $data['selected_group'][$v_group->group_id] = $this->group_model->selected_group_details($v_group->group_id);
        }

        $data['main_content'] = $this->load->view('user/group/view_group_learner', $data, true);
        $this->load->view('user/master', $data);
    }

    public function search_learner_group($page = NULL) {

        $user_id = $this->session->userdata('user_id');

        if ($page != NULL) {
            $data['page'] = $page;
            $number = $page * 10 - 10;
            $data['serial'] = $number;
        } else {
            $data['page'] = 0;
            $data['serial'] = 0;
            $number = 0;
        }
        $value = $this->input->post("value", TRUE);
        $data['count_member_group_list'] = $this->group_model->count_select_student_connected_group_for_searching($user_id, $value);
        $data['member_group_list'] = $this->group_model->select_student_connected_group_for_searching($user_id, $number, $value);

        foreach ($data['member_group_list'] as $v_group) {
            $data['total_member'][$v_group->group_id] = $this->group_model->group_total_member($v_group->group_id);
            $data['group_requested_members'][$v_group->group_id] = $this->group_model->select_group_requested_member_list_info($v_group->group_id);
            $data['selected_group'][$v_group->group_id] = $this->group_model->selected_group_details($v_group->group_id);
        }

        echo $this->load->view('user/group/view_group_learner_search_ajax_page', $data, true);
    }

//START TEACHER GROUP
    public function teacher_group($page = NULL) {
        $data = array();
        $user_id = $this->session->userdata('user_id');
        $sdata = array();
        if ($page != NULL) {
            $data['page'] = $page;
            $number = $page * 10 - 10;
            $data['serial'] = $number;
        } else {
            $data['page'] = 0;
            $data['serial'] = 0;
            $number = 0;
        }
        $data['active_menu'] = $sdata['active_menu'] = 'teacher';
        $data['active_sub_menu'] = $sdata['active_sub_menu'] = 'teacher_group';
        $sdata['redirect'] = 'groups/organization';
        $this->session->set_userdata($sdata);
        $data['left_side'] = 1;
        $data['left_side_menu_view'] = 1;

        $data['member_group_list'] = $this->group_model->created_group_info($user_id, $number);
        $data['count_member_group_list'] = $this->group_model->count_created_group_info($user_id);
        foreach ($data['member_group_list'] as $v_group) {
            $data['total_member'][$v_group->group_id] = $this->group_model->group_total_member($v_group->group_id);
            $data['group_requested_members'][$v_group->group_id] = $this->group_model->select_group_requested_member_list_info($v_group->group_id);
            $data['selected_group'][$v_group->group_id] = $this->group_model->selected_group_details($v_group->group_id);
        }


        $sdata = array();
        $sdata['redirect_url'] = 'groups/organization';
        $this->session->set_userdata($sdata);
        $data['main_content'] = $this->load->view('user/group/view_group', $data, true);
        $this->load->view('user/master', $data);
    }

//START ORGANIZATION GROUP
    public function organization_group($page = NULL) {
        $data = array();
        $user_id = $this->session->userdata('user_id');
        $sdata = array();
        $data['active_menu'] = $sdata['active_menu'] = 'organization';
        $data['active_sub_menu'] = $sdata['active_sub_menu'] = 'Group';
        $sdata['redirect'] = 'groups/organization';
        $this->session->set_userdata($sdata);
        $data['left_side'] = 1;
        $data['left_side_menu_view'] = 1;
        if ($page != NULL) {
            $data['page'] = $page;
            $number = $page * 10 - 10;
            $data['serial'] = $number;
        } else {
            $data['page'] = 0;
            $data['serial'] = 0;
            $number = 0;
        }

        $data['member_group_list'] = $this->group_model->created_group_info($user_id, $number);
        $data['count_member_group_list'] = $this->group_model->count_created_group_info($user_id);
        foreach ($data['member_group_list'] as $v_group) {
            $data['total_member'][$v_group->group_id] = $this->group_model->group_total_member($v_group->group_id);
            $data['group_requested_members'][$v_group->group_id] = $this->group_model->select_group_requested_member_list_info($v_group->group_id);
            $data['selected_group'][$v_group->group_id] = $this->group_model->selected_group_details($v_group->group_id);
        }

        $sdata = array();
        $sdata['redirect_url'] = 'groups/organization';
        $this->session->set_userdata($sdata);
        $data['main_content'] = $this->load->view('user/group/view_group', $data, true);
        $this->load->view('user/master', $data);
    }

    function ascdscding_order_group($page = NULL) {

        if ($page != NULL) {
            $data['page'] = $page;
            $number = $page * 10 - 10;
            $data['serial'] = $number;
        } else {
            $data['page'] = 0;
            $data['serial'] = 0;
            $number = 0;
        }

        $value = $this->input->post("value", TRUE);
        $user_id = $this->session->userdata('user_id');
        if ($value == 'a_group') {
            $data['member_group_list'] = $this->group_model->created_group_info_asc($user_id, $number);
            $data['count_member_group_list'] = $this->group_model->count_created_group_info($user_id);
            foreach ($data['member_group_list'] as $v_group) {
                $data['total_member'][$v_group->group_id] = $this->group_model->group_total_member($v_group->group_id);
                $data['group_requested_members'][$v_group->group_id] = $this->group_model->select_group_requested_member_list_info($v_group->group_id);
                $data['selected_group'][$v_group->group_id] = $this->group_model->selected_group_details($v_group->group_id);
            }
        } else if ($value == 'd_group') {
            $data['member_group_list'] = $this->group_model->created_group_info_dsc($user_id, $number);
            $data['count_member_group_list'] = $this->group_model->count_created_group_info($user_id);
            foreach ($data['member_group_list'] as $v_group) {
                $data['total_member'][$v_group->group_id] = $this->group_model->group_total_member($v_group->group_id);
                $data['group_requested_members'][$v_group->group_id] = $this->group_model->select_group_requested_member_list_info($v_group->group_id);
                $data['selected_group'][$v_group->group_id] = $this->group_model->selected_group_details($v_group->group_id);
            }
        } else if ($value == 'a_member') {
            $data['member_group_list'] = $this->group_model->created_group_info_asc_member($user_id, $number);
            $data['count_member_group_list'] = $this->group_model->count_created_group_info($user_id);
            foreach ($data['member_group_list'] as $v_group) {
                $data['total_member'][$v_group->group_id] = $this->group_model->group_total_member($v_group->group_id);
                $data['group_requested_members'][$v_group->group_id] = $this->group_model->select_group_requested_member_list_info($v_group->group_id);
                $data['selected_group'][$v_group->group_id] = $this->group_model->selected_group_details($v_group->group_id);
            }
        } else if ($value == 'd_member') {
            $data['member_group_list'] = $this->group_model->created_group_info_dsc_member($user_id, $number);
            $data['count_member_group_list'] = $this->group_model->count_created_group_info($user_id);
            foreach ($data['member_group_list'] as $v_group) {
                $data['total_member'][$v_group->group_id] = $this->group_model->group_total_member($v_group->group_id);
                $data['group_requested_members'][$v_group->group_id] = $this->group_model->select_group_requested_member_list_info($v_group->group_id);
                $data['selected_group'][$v_group->group_id] = $this->group_model->selected_group_details($v_group->group_id);
            }
        } else if ($value == 'a_request') {
            $data['member_group_list'] = $this->group_model->created_group_info_asc_request_member($user_id, $number);
            $data['count_member_group_list'] = $this->group_model->count_created_group_info($user_id);
            foreach ($data['member_group_list'] as $v_group) {
                $data['total_member'][$v_group->group_id] = $this->group_model->group_total_member($v_group->group_id);
                $data['group_requested_members'][$v_group->group_id] = $this->group_model->select_group_requested_member_list_info($v_group->group_id);
                $data['selected_group'][$v_group->group_id] = $this->group_model->selected_group_details($v_group->group_id);
            }
        } else if ($value == 'd_request') {
            $data['member_group_list'] = $this->group_model->created_group_info_dsc_request_member($user_id, $number);
            $data['count_member_group_list'] = $this->group_model->count_created_group_info($user_id);
            foreach ($data['member_group_list'] as $v_group) {
                $data['total_member'][$v_group->group_id] = $this->group_model->group_total_member($v_group->group_id);
                $data['group_requested_members'][$v_group->group_id] = $this->group_model->select_group_requested_member_list_info($v_group->group_id);
                $data['selected_group'][$v_group->group_id] = $this->group_model->selected_group_details($v_group->group_id);
            }
        } else if ($value == 'search') {
            $given_text = $this->input->post("given_text", TRUE);
            $data['member_group_list'] = $this->group_model->created_group_info_by_searching_given_text($user_id, $number, $given_text);
            $data['count_member_group_list'] = $this->group_model->count_created_group_info_for_search($user_id, $given_text);
            foreach ($data['member_group_list'] as $v_group) {
                $data['total_member'][$v_group->group_id] = $this->group_model->group_total_member($v_group->group_id);
                $data['group_requested_members'][$v_group->group_id] = $this->group_model->select_group_requested_member_list_info($v_group->group_id);
                $data['selected_group'][$v_group->group_id] = $this->group_model->selected_group_details($v_group->group_id);
            }
        }

        echo $this->load->view('user/group/view_group_ascding_dscding', $data, true);
    }

    function search_group_by_text($page = NULL) {
        if ($page != NULL) {
            $data['page'] = $page;
            $number = $page * 10 - 10;
            $data['serial'] = $number;
        } else {
            $data['page'] = 0;
            $data['serial'] = 0;
            $number = 0;
        }

        $given_text = $this->input->post("given_text", TRUE);
        $user_id = $this->session->userdata('user_id');
        $data['member_group_list'] = $this->group_model->created_group_info_by_searching_given_text($user_id, $number, $given_text);

        $data['count_member_group_list'] = $this->group_model->count_created_group_info_for_search($user_id, $given_text);
        foreach ($data['member_group_list'] as $v_group) {
            $data['total_member'][$v_group->group_id] = $this->group_model->group_total_member($v_group->group_id);
            $data['group_requested_members'][$v_group->group_id] = $this->group_model->select_group_requested_member_list_info($v_group->group_id);
            $data['selected_group'][$v_group->group_id] = $this->group_model->selected_group_details($v_group->group_id);
        }
        echo $this->load->view('user/group/view_group_ascding_dscding', $data, true);
    }

//START ORGANIZATION GROUP
    public function detail_group_list($page = NULL) {

        $user_id = $this->session->userdata('user_id');
        $data['active_menu'] = $this->session->userdata('active_menu');
        $data['active_sub_menu'] = $this->session->userdata('active_sub_menu');

        $sdata = array();
        $sdata['redirect'] = 'groups-detail';
        if ($page != NULL) {
            $data['page'] = $page;
            $number = $page * 10 - 10;
            $data['serial'] = $number;
        } else {
            $data['page'] = 0;
            $data['serial'] = 0;
            $number = 0;
        }
        $this->session->set_userdata($sdata);
        
        $data['left_side_menu_view'] = 1;
        $data['left_side'] = 1;
        $data['member_group_list'] = $this->group_model->select_group_info_for_group_member($user_id, $number);
        $data['count_group_list'] = $this->group_model->select_count_group_info_for_group_member($user_id);
        
        if ($data['member_group_list']) {
            foreach ($data['member_group_list'] as $v_group) {
                $data['group_creator'][$v_group->group_id] = $v_group->group_created_by;
                $data['group_details'][$v_group->group_id] = $this->group_model->group_info_by_url($v_group->url);
                $data['group_member_list'][$v_group->group_id] = $this->group_model->select_group_member_list_info($v_group->group_id);
                $data['group_note_post'][$v_group->group_id] = $this->group_model->select_group_all_note_post($v_group->group_id);
                $data['group_alert_post'][$v_group->group_id] = $this->group_model->select_group_all_alert_post($v_group->group_id);
                $data['group_assignment_post'][$v_group->group_id] = $this->group_model->select_group_all_assignment_post($v_group->group_id);
                
                $data['group_photo_post'][$v_group->group_id] = $this->group_model->select_group_all_photo_post($v_group->group_id);
                $data['group_video_post'][$v_group->group_id] = $this->group_model->select_group_all_video_post($v_group->group_id);
                
            }
        }
        $data['main_content'] = $this->load->view('user/group/view_detail_group', $data, true);
        $this->load->view('user/master', $data);
    }

    function search_detail_group($page = NULL) {
        $user_id = $this->session->userdata('user_id');
        if ($page != NULL) {
            $data['page'] = $page;
            $number = $page * 10 - 10;
            $data['serial'] = $number;
        } else {
            $data['page'] = 0;
            $data['serial'] = 0;
            $number = 0;
        }
        $value = $this->input->post("value", TRUE);
        $given_text = $this->input->post("given_text", TRUE);
        if ($value == 'search') {
            $data['member_group_list'] = $this->group_model->select_group_info_by_giving_search_text($user_id, $number, $given_text);
            $data['count_group_list'] = $this->group_model->select_count_group_info_for_group_member_for_search($user_id, $given_text);
        }
        if ($value == 'a_group') {
            $data['member_group_list'] = $this->group_model->select_detail_group_info_asc($user_id, $number);
            $data['count_group_list'] = $this->group_model->select_count_group_info_for_group_member($user_id);
        }
        if ($value == 'd_group') {
            $data['member_group_list'] = $this->group_model->select_detail_group_info_dsc($user_id, $number);
            $data['count_group_list'] = $this->group_model->select_count_group_info_for_group_member($user_id);
        }

        if ($data['member_group_list']) {
            foreach ($data['member_group_list'] as $v_group) {
                $data['group_creator'][$v_group->group_id] = $v_group->group_created_by;
                $data['group_details'][$v_group->group_id] = $this->group_model->group_info_by_url($v_group->url);
                $data['group_member_list'][$v_group->group_id] = $this->group_model->select_group_member_list_info($v_group->group_id);
                $data['group_note_post'][$v_group->group_id] = $this->group_model->select_group_all_note_post($v_group->group_id);
                $data['group_alert_post'][$v_group->group_id] = $this->group_model->select_group_all_alert_post($v_group->group_id);
                $data['group_assignment_post'][$v_group->group_id] = $this->group_model->select_group_all_assignment_post($v_group->group_id);
                //$data['group_quiz'][$v_group->group_id] = $this->group_model->select_group_quiz_list($v_group->group_id);
                $data['group_photo_post'][$v_group->group_id] = $this->group_model->select_group_all_photo_post($v_group->group_id);
                $data['group_video_post'][$v_group->group_id] = $this->group_model->select_group_all_video_post($v_group->group_id);
                //$data['group_courses'][$v_group->group_id] = $this->group_model->select_group_courses($v_group->group_id);
                //$data['group_video_courses'][$v_group->group_id] = $this->group_model->select_group_video_courses($v_group->group_id);
            }
        }

        echo $this->load->view('user/group/view_search_group_detail', $data, true);
    }

    function groups_learner_detail($page = NULL) {
        $user_id = $this->session->userdata('user_id');
        $data['active_menu'] = $this->session->userdata('active_menu');
        $data['active_sub_menu'] = $this->session->userdata('active_sub_menu');

        $sdata = array();
        $sdata['redirect'] = 'groups-detail';
        if ($page != NULL) {
            $data['page'] = $page;
            $number = $page * 10 - 10;
            $data['serial'] = $number;
        } else {
            $data['page'] = 0;
            $data['serial'] = 0;
            $number = 0;
        }
        $this->session->set_userdata($sdata);

        //$data['geo_info'][0] = $this->f_end_model->select_person_current_location($user_id);
        $data['left_side_menu_view'] = 1;
        $data['left_side'] = 1;
        $data['member_group_list'] = $this->group_model->select_group_info_for_group_learner_member($user_id, $number);
        $data['count_group_list'] = $this->group_model->select_count_group_info_for_group_learner_member($user_id);
        
        if ($data['member_group_list']) {
            foreach ($data['member_group_list'] as $v_group) {
                $data['group_creator'][$v_group->group_id] = $v_group->group_created_by;
                $data['group_details'][$v_group->group_id] = $this->group_model->group_info_by_url($v_group->url);
                $data['group_member_list'][$v_group->group_id] = $this->group_model->select_group_member_list_info($v_group->group_id);
                $data['group_note_post'][$v_group->group_id] = $this->group_model->select_group_all_note_post($v_group->group_id);
                $data['group_alert_post'][$v_group->group_id] = $this->group_model->select_group_all_alert_post($v_group->group_id);
                $data['group_assignment_post'][$v_group->group_id] = $this->group_model->select_group_all_assignment_post($v_group->group_id);
                //$data['group_quiz'][$v_group->group_id] = $this->group_model->select_group_quiz_list($v_group->group_id);
                $data['group_photo_post'][$v_group->group_id] = $this->group_model->select_group_all_photo_post($v_group->group_id);
                $data['group_video_post'][$v_group->group_id] = $this->group_model->select_group_all_video_post($v_group->group_id);
                $data['group_courses'][$v_group->group_id] = $this->group_model->select_group_courses($v_group->group_id);
                $data['group_video_courses'][$v_group->group_id] = $this->group_model->select_group_video_courses($v_group->group_id);
            }
        }
        $data['main_content'] = $this->load->view('user/group/view_learner_detail_group', $data, true);
        $this->load->view('user/master', $data);
    }

    function search_detail_group_learner($page = NULL) {
        $user_id = $this->session->userdata('user_id');
        if ($page != NULL) {
            $data['page'] = $page;
            $number = $page * 10 - 10;
            $data['serial'] = $number;
        } else {
            $data['page'] = 0;
            $data['serial'] = 0;
            $number = 0;
        }
        $value = $this->input->post("value", TRUE);
        $given_text = $this->input->post("given_text", TRUE);
        if ($value == 'search') {
            $data['count_group_list'] = $this->group_model->select_count_group_info_for_group_learner_member_for_search($user_id, $given_text);
            $data['member_group_list'] = $this->group_model->select_learner_group_info_by_giving_search_text($user_id, $number, $given_text);
        }
        if ($value == 'a_group') {
            $data['count_group_list'] = $this->group_model->select_count_group_info_for_group_learner_member($user_id);
            $data['member_group_list'] = $this->group_model->select_detail_learner_group_info_asc($user_id, $number);
        }
        if ($value == 'd_group') {
            $data['count_group_list'] = $this->group_model->select_count_group_info_for_group_learner_member($user_id);
            $data['member_group_list'] = $this->group_model->select_detail_learner_group_info_dsc($user_id, $number);
        }

        if ($data['member_group_list']) {
            foreach ($data['member_group_list'] as $v_group) {
                $data['group_creator'][$v_group->group_id] = $v_group->group_created_by;
                $data['group_details'][$v_group->group_id] = $this->group_model->group_info_by_url($v_group->url);
                $data['group_member_list'][$v_group->group_id] = $this->group_model->select_group_member_list_info($v_group->group_id);
                $data['group_note_post'][$v_group->group_id] = $this->group_model->select_group_all_note_post($v_group->group_id);
                $data['group_alert_post'][$v_group->group_id] = $this->group_model->select_group_all_alert_post($v_group->group_id);
                $data['group_assignment_post'][$v_group->group_id] = $this->group_model->select_group_all_assignment_post($v_group->group_id);
                $data['group_quiz'][$v_group->group_id] = $this->group_model->select_group_quiz_list($v_group->group_id);
                $data['group_photo_post'][$v_group->group_id] = $this->group_model->select_group_all_photo_post($v_group->group_id);
                $data['group_video_post'][$v_group->group_id] = $this->group_model->select_group_all_video_post($v_group->group_id);
                $data['group_courses'][$v_group->group_id] = $this->group_model->select_group_courses($v_group->group_id);
                $data['group_video_courses'][$v_group->group_id] = $this->group_model->select_group_video_courses($v_group->group_id);
            }
        }

        echo $this->load->view('user/group/view_detail_learner_group_ajax_page', $data, true);
    }

    public function fornt_end_group_course_list($url_name) {

        $data = array();
        $user_id = $this->session->userdata('user_id');
        $data['active_menu'] = $this->session->userdata('active_menu');
        $data['active_sub_menu'] = $this->session->userdata('active_sub_menu');
        $data['left_side_menu_view'] = 1;
        $data['left_side'] = 1;
        $sdata = array();
        $sdata['redirect'] = 'groups-detail';
        $this->session->set_userdata($sdata);
        //$data['geo_info'][0] = $this->f_end_model->select_person_current_location($user_id);
        $data['url_id'] = $this->group_model->get_url_id($url_name);
        $data['url'] = $url_name;
        $data['grp_id'] = $this->group_model->select_group_id_for_note($data['url_id']->url_id);
        $data['course_id'] = $this->group_model->select_courses_for_group($data['grp_id']->group_id);
        if ($data['course_id']) {
            foreach ($data['course_id'] as $val) {

                $data['group_course_info'][$val->course_id] = $this->group_model->select_group_course_info_by_course_id($val->course_id);
                $data['course_url'][$val->course_id] = $this->group_model->select_course_url($data['group_course_info'][$val->course_id]->url_id);
                $data['group_course_student'][$val->course_id] = $this->group_model->select_group_course_student($val->course_id);
            }
        }


        $data['main_content'] = $this->load->view('user/group/group_course_list', $data, TRUE);
        $this->load->view('user/master', $data);
    }

    public function fornt_end_group_course_member_details($url_name, $grp_url) {
        $data = array();
        $user_id = $this->session->userdata('user_id');
        $data['active_menu'] = $this->session->userdata('active_menu');
        $data['active_sub_menu'] = $this->session->userdata('active_sub_menu');

        $sdata = array();
        $sdata['redirect'] = 'groups-detail';
        $this->session->set_userdata($sdata);
        $data['left_side_menu_view'] = 1;
        $data['left_side'] = 1;
        //$data['geo_info'][0] = $this->f_end_model->select_person_current_location($user_id);
        $data['url_id'] = $this->group_model->get_url_id($url_name);
        $data['grp_url_id'] = $this->group_model->get_url_id($grp_url);
        
        $data['url'] = $url_name;
        $data['grp_url'] = $grp_url;
        $data['grp_id'] = $this->group_model->select_group_id_for_note($data['grp_url_id']->url_id);
        $person_id = $this->session->userdata('person_id');
        $data['check_person_status'] = $this->group_model->select_person_role($person_id);
        
        $data['course_id'] = $this->group_model->select_course_id_by_url($data['url_id']->url_id);

        $data['student_id'] = $this->group_model->select_student_for_that_course($data['course_id']->course_id);

        if ($data['student_id']) {
            foreach ($data['student_id'] as $val) {
                $data['student_info'][$val->person_id] = $this->group_model->select_student_info_person_id($val->person_id);

                $data['person_payment_status'][$val->person_id] = $this->group_model->select_payment_status($val->payment_id);
            }
        }

        $data['main_content'] = $this->load->view('user/group/view_group_course_member_details', $data, true);
        $this->load->view('user/master', $data);
    }

    public function fornt_end_group_video_course_list($url_name) {
        $data = array();
        $data['active_menu'] = $this->session->userdata('active_menu');
        $data['active_sub_menu'] = $this->session->userdata('active_sub_menu');
        $data['active'] = 'detail_group_list';

        $data['url_id'] = $this->super_admin_group_model->get_url_id($url_name);
        $data['url'] = $url_name;
        $data['grp_id'] = $this->super_admin_group_model->select_group_id_for_note($data['url_id']->url_id);
        $data['course_id'] = $this->super_admin_group_model->select_video_courses_for_group($data['grp_id']->group_id);
        $data['left_side_menu_view'] = 1;
        $data['left_side'] = 1;
        if ($data['course_id']) {
            foreach ($data['course_id'] as $val) {

                $data['group_course_info'][$val->course_id] = $this->super_admin_group_model->select_group_video_course_info_by_course_id($val->course_id);
                $data['course_url'] = $this->super_admin_group_model->select_course_url($data['group_course_info'][$val->course_id]->url_id);
                $data['group_course_student'][$val->course_id] = $this->super_admin_group_model->select_group_video_course_student($val->course_id);
            }
        }

        $data['main_content'] = $this->load->view('user/group/group_video_course_list', $data, true);
        $this->load->view('user/master', $data);
    }

    public function group_notes($group_url) {
        $data['left_side_menu_view'] = 1;
        $data['left_side'] = 1;
        $person_id = $this->session->userdata('user_id');
        $data['active_menu'] = $this->session->userdata('active_menu');
        $data['active_sub_menu'] = $this->session->userdata('active_sub_menu');
        //$data['geo_info'][0] = $this->f_end_model->select_person_current_location($person_id);
        $sdata = array();
        $sdata['group_url'] = $group_url;
        $sdata['post_type'] = 'note';
        $this->session->set_userdata($sdata);
        $data['group_url'] = $group_url;
        $user_id = $this->session->userdata('user_id');
        
        $page_number = 1;
        $data['group_details'] = $this->group_model->group_info_by_url($group_url);
        $data['total_group_note_post'] = count($this->group_model->select_group_all_note_post($data['group_details']->group_id));
        $data['group_note_post'] = $this->group_model->select_limited_group_all_note_post($data['group_details']->group_id, 0);        
        //$this->cf->dd($data['group_note_post']);
        $params = array('url' => '', 'div_id' => 'group_detail_note_pagination_link', 'total_row' => $data['total_group_note_post'], 'per_page' => 10, 'current_page' => $page_number, 'total_link' => 10);
        $data['group_detail_note_pagination_link'] = $this->tt_pagination->view_pagination_link($params);
        
        $data['main_content'] = $this->load->view('user/group/group_notes', $data, true);
        $this->load->view('user/master', $data);
    }
    
    public function group_detail_note_ajax_view(){
        if ($this->input->is_ajax_request()) {
        $data['left_side_menu_view'] = 1;
        $data['left_side'] = 1;
        $person_id = $this->session->userdata('user_id');
        $data['active_menu'] = $this->session->userdata('active_menu');
        $data['active_sub_menu'] = $this->session->userdata('active_sub_menu');
        $data['geo_info'][0] = $this->f_end_model->select_person_current_location($person_id);
        $sdata = array();
        //$sdata['group_url'] = $group_url;
        $sdata['post_type'] = 'note';
        $this->session->set_userdata($sdata);
        
        $user_id = $this->session->userdata('user_id');
        
        $page_number = $this->input->post('current_page', TRUE);
        $group_url = $this->input->post('group_url', TRUE);
        $limit_offset = ($page_number*10)-10;
        $data['group_url'] = $group_url;
        $data['group_details'] = $this->group_model->group_info_by_url($group_url);
        $data['total_group_note_post'] = count($this->group_model->select_group_all_note_post($data['group_details']->group_id));
        $data['group_note_post'] = $this->group_model->select_limited_group_all_note_post($data['group_details']->group_id, $limit_offset);        
        //$this->cf->dd($data['group_note_post']);
        $params = array('url' => '', 'div_id' => 'group_detail_note_pagination_link', 'total_row' => $data['total_group_note_post'], 'per_page' => 10, 'current_page' => $page_number, 'total_link' => 10);
        $data['group_detail_note_pagination_link'] = $this->tt_pagination->view_pagination_link($params);
        
        echo $this->load->view('user/group/group_note_ajax_view', $data, true);
        }
    }

    public function group_alerts($group_url) {
        $person_id = $this->session->userdata('user_id');
        $data['active_menu'] = $this->session->userdata('active_menu');
        $data['active_sub_menu'] = $this->session->userdata('active_sub_menu');

        //$data['geo_info'][0] = $this->f_end_model->select_person_current_location($person_id);
        $page_number = 1;
        $data['left_side_menu_view'] = 1;
        $data['left_side'] = 1;
        $sdata = array();
        $sdata['group_url'] = $group_url;
        $sdata['post_type'] = 'alert';
        $this->session->set_userdata($sdata);
        $data['group_url'] = $group_url;
        $data['group_details'] = $this->group_model->group_info_by_url($group_url);
        $data['total_group_alert_post'] = count($this->group_model->select_group_all_alert_post($data['group_details']->group_id));
        $data['group_alert_post'] = $this->group_model->select_limited_group_all_alert_post($data['group_details']->group_id, 0);
        
        $params = array('url' => '', 'div_id' => 'group_detail_alert_pagination_link', 'total_row' => $data['total_group_alert_post'], 'per_page' => 10, 'current_page' => $page_number, 'total_link' => 10);
        $data['group_detail_alert_pagination_link'] = $this->tt_pagination->view_pagination_link($params);
        
        $data['main_content'] = $this->load->view('user/group/group_alerts', $data, true);
        $this->load->view('user/master', $data);
    }
    
    public function group_detail_alert_ajax_view(){
        if ($this->input->is_ajax_request()) {
        $person_id = $this->session->userdata('user_id');
        $data['active_menu'] = $this->session->userdata('active_menu');
        $data['active_sub_menu'] = $this->session->userdata('active_sub_menu');

        //$data['geo_info'][0] = $this->f_end_model->select_person_current_location($person_id);
        $page_number = 1;
        $data['left_side_menu_view'] = 1;
        $data['left_side'] = 1;
        $sdata = array();       
        $sdata['post_type'] = 'alert';
       
        $page_number = $this->input->post('current_page', TRUE);
        $group_url = $this->input->post('group_url', TRUE);
        $limit_offset = ($page_number*10)-10;
        
        $data['group_url'] = $group_url;
        $data['group_details'] = $this->group_model->group_info_by_url($group_url);
        $data['total_group_alert_post'] = count($this->group_model->select_group_all_alert_post($data['group_details']->group_id));
        $data['group_alert_post'] = $this->group_model->select_limited_group_all_alert_post($data['group_details']->group_id, $limit_offset);
        
        $params = array('url' => '', 'div_id' => 'group_detail_alert_pagination_link', 'total_row' => $data['total_group_alert_post'], 'per_page' => 10, 'current_page' => $page_number, 'total_link' => 10);
        $data['group_detail_alert_pagination_link'] = $this->tt_pagination->view_pagination_link($params);
        
        echo $this->load->view('user/group/group_alert_ajax_view', $data, true);
        }
    }

    public function group_assignments($group_url) {
        $data['left_side_menu_view'] = 1;
        $data['left_side'] = 1;
        $person_id = $this->session->userdata('user_id');
        $data['active_menu'] = $this->session->userdata('active_menu');
        $data['active_sub_menu'] = $this->session->userdata('active_sub_menu');
        //$data['geo_info'][0] = $this->f_end_model->select_person_current_location($person_id);

        $page_number = 1;
        $sdata = array();
        $sdata['group_url'] = $group_url;
        $sdata['post_type'] = 'assignment';
        $this->session->set_userdata($sdata);
        $data['group_url'] = $group_url;
        $data['group_details'] = $this->group_model->group_info_by_url($group_url);
        $data['total_group_assignment_post'] = count($this->group_model->get_all_group_post(3, $data['group_details']->group_id));
        $data['group_assignment_post'] = $this->group_model->get_limited_all_group_post(3, $data['group_details']->group_id, 0);
        //$this->cf->dd($data['group_assignment_post']);
        $params = array('url' => '', 'div_id' => 'group_detail_assignment_pagination_link', 'total_row' => $data['total_group_assignment_post'], 'per_page' => 10, 'current_page' => $page_number, 'total_link' => 10);
        $data['group_detail_assignment_pagination_link'] = $this->tt_pagination->view_pagination_link($params);

        $data['main_content'] = $this->load->view('user/group/group_assignments', $data, true);
        $this->load->view('user/master', $data);
    }
    
    public function group_detail_assignment_ajax_view(){
        if ($this->input->is_ajax_request()) {
        $data['left_side_menu_view'] = 1;
        $data['left_side'] = 1;
        $person_id = $this->session->userdata('user_id');
        $data['active_menu'] = $this->session->userdata('active_menu');
        $data['active_sub_menu'] = $this->session->userdata('active_sub_menu');
        //$data['geo_info'][0] = $this->f_end_model->select_person_current_location($person_id);

        $page_number = $this->input->post('current_page', TRUE);
        $group_url = $this->input->post('group_url', TRUE);
        $limit_offset = ($page_number*10)-10;
        $sdata = array();
        //$sdata['group_url'] = $group_url;
        $sdata['post_type'] = 'assignment';
        $this->session->set_userdata($sdata);
        $data['group_url'] = $group_url;
        $data['group_details'] = $this->group_model->group_info_by_url($group_url);
        $data['total_group_assignment_post'] = count($this->group_model->get_all_group_post(3, $data['group_details']->group_id));
        $data['group_assignment_post'] = $this->group_model->get_limited_all_group_post(3, $data['group_details']->group_id, $limit_offset);
        //$this->cf->dd($data['group_assignment_post']);
        $params = array('url' => '', 'div_id' => 'group_detail_assignment_pagination_link', 'total_row' => $data['total_group_assignment_post'], 'per_page' => 10, 'current_page' => $page_number, 'total_link' => 10);
        $data['group_detail_assignment_pagination_link'] = $this->tt_pagination->view_pagination_link($params);

        echo $this->load->view('user/group/group_assignment_ajax_view', $data, true);
        }
    }

    function ajax_group_post() {
        $person_url = $this->input->post('person_url', TRUE);
        $data['group_url'] = $this->input->post('group_url', TRUE);
        $data['type'] = $this->input->post('type', TRUE);
        $data['group_details'] = $this->group_model->group_info_by_url($data['group_url']);

        switch ($data['type']) {
            case 1:
                $data['group_note_post'] = $this->group_model->get_all_group_post($data['type'], $data['group_details']->group_id, $person_url);
                break;
            case 2:
                $data['group_alert_post'] = $this->group_model->get_all_group_post($data['type'], $data['group_details']->group_id, $person_url);
                break;
            case 3:
                $data['group_assignment_post'] = $this->group_model->get_all_group_post($data['type'], $data['group_details']->group_id, $person_url);
                break;
            case 4:
                $data['group_photo_post'] = $this->group_model->get_all_group_post($data['type'], $data['group_details']->group_id, $person_url);
                break;
            case 5:
                $data['group_video_post'] = $this->group_model->get_all_group_post($data['type'], $data['group_details']->group_id, $person_url);
                break;
        }

        echo $this->load->view('user/group/ajax_group_post', $data, true);
    }

    public function group_photos($group_url) {
        // Right Sidebar Content Information

        $person_id = $this->session->userdata('user_id');
        $data['active_menu'] = $this->session->userdata('active_menu');
        $data['active_sub_menu'] = $this->session->userdata('active_sub_menu');

        $data['left_side_menu_view'] = 1;
        $data['left_side'] = 1;
        $sdata = array();
        $sdata['group_url'] = $group_url;
        $sdata['post_type'] = 'photo';
        $this->session->set_userdata($sdata);
        $data['group_url'] = $group_url;
        $user_id = $this->session->userdata('user_id');
        $data['group_details'] = $this->group_model->group_info_by_url($group_url);
        $data['group_photo_post'] = $this->group_model->select_group_all_photo_post($data['group_details']->group_id);
        foreach ($data['group_photo_post'] as $v_photo) {
            $data['profile_url'] = $this->post_model->get_profile_url($v_photo->posted_by);
        }

        $data['main_content'] = $this->load->view('user/group/group_photos', $data, true);
        $this->load->view('user/master', $data);
    }

    public function group_videos($group_url) {
        // Right Sidebar Content Information
        $person_id = $this->session->userdata('user_id');
        $data['active_menu'] = $this->session->userdata('active_menu');
        $data['active_sub_menu'] = $this->session->userdata('active_sub_menu');
        $data['left_content'] = $this->load->view('user/side_menu', $data, TRUE);
        $data['right_content'] = $this->load->view('user/right_content', $data, TRUE);
        //$data['geo_info'][0] = $this->f_end_model->select_person_current_location($person_id);

        $data['left_side_menu_view'] = 1;
        $data['left_side'] = 1;
        $sdata = array();
        $sdata['group_url'] = $group_url;
        $sdata['post_type'] = 'video';
        $this->session->set_userdata($sdata);

        $user_id = $this->session->userdata('user_id');
        $data['group_details'] = $this->group_model->group_info_by_url($group_url);
        $data['group_video_post'] = $this->group_model->select_group_all_video_post($data['group_details']->group_id);
        foreach ($data['group_video_post'] as $v_video) {
            $data['profile_url'] = $this->post_model->get_profile_url($v_video->posted_by);
        }
        $data['group_url'] = $group_url;
        $data['main_content'] = $this->load->view('user/group/group_videos', $data, true);
        $this->load->view('user/master', $data);
    }

    public function make_active_group_post($post_id) {
        $this->group_model->active_selected_post($post_id);

        redirect('group/' . $this->session->userdata('group_url') . '/' . $this->session->userdata('post_type'));
    }

    public function make_inactive_group_post($post_id) {
        $this->group_model->inactive_selected_post($post_id);
        redirect('group/' . $this->session->userdata('group_url') . '/' . $this->session->userdata('post_type'));
    }

    public function make_archive_group_post($post_id) {
        $this->group_model->archive_selected_post($post_id);
        redirect('group/' . $this->session->userdata('group_url') . '/' . $this->session->userdata('post_type'));
    }

    public function check_group_url() {

        $code = $this->uri->segment(2);


        $result = $this->f_end_model->selected_group_details_info_by_code($code);

        if ($result) {
            $data = array();
            $data['group_info'] = $this->group_model->group_info($result->group_id);
            $data['main_content'] = $this->load->view('front_end/group_public_view', $data, true);
            $this->load->view('front_end/master', $data);
        } else {
            echo ('Invalid URL!');
            exit();
        }
    }

    public function check_public_group_code_for_edit($code, $old_code) {
        if ($old_code == $code) {
            echo '2';
        } else {
            $result = $this->group_model->check_group_code($code);
            if ($result) {
                echo '1';
            } else {
                echo '2';
            }
        }
    }

    public function check_group_url_for_edit($url, $old_url) {
        if ($old_url == $url) {
            echo '2';
        } else {
            $result = $this->group_model->check_group_url($url);
            if ($result) {
                echo '1';
            } else {
                echo '2';
            }
        }
    }

    public function create_group() {
        $person_role = $this->session->userdata('person_role');
        $person_id = $this->session->userdata('user_id');
        if ($person_role == 5) {
            redirect('all-group');
        }
        $data['left_side_menu_view'] = 1;
        $data['left_side'] = 1;
        $data['active_menu'] = $this->session->userdata('active_menu');
        $data['active_sub_menu'] = $this->session->userdata('active_sub_menu');
        $this->load->library('form_validation');
        $this->form_validation->set_rules('group_name', 'Group Name', 'trim|required|max_length[50]');
        $this->form_validation->set_rules('group_type', 'Group Type', 'trim|required|max_length[50]');
        $this->form_validation->set_rules('group_other_type', 'Group Type', 'trim|max_length[50]');
        $this->form_validation->set_rules('group_url', 'Group Url', 'trim|max_length[50]|callback_check_group_url_exist');

        $this->form_validation->set_rules('group_description', 'Group Description', 'trim');
        $this->form_validation->set_rules('group_public_id', 'group invitation code', 'trim|callback_group_invitation_code_exist');
        $this->form_validation->set_rules('group_permission', 'group_permission', 'required');
        $this->form_validation->set_rules('group_status', 'Group Status', 'required');
        $this->form_validation->set_rules('created_by', 'Created Time');

        if ($this->form_validation->run() == FALSE) {
            $data['active'] = 'create';
            $data['group_type'] = $this->group_model->group_type_list();
            $data['main_content'] = $this->load->view('user/group/create_group', $data, true);
            $this->load->view('user/master', $data);
        } else {
            if ($_POST) {

                $group_data['group_name'] = $this->input->post('group_name', TRUE);
                $group_data['group_type_id'] = $this->input->post('group_type', TRUE);

//save other goup type
                $category_data = array();
                if ($group_data['group_type_id'] == 'other') {
                    $type_data['group_type_name'] = $this->input->post('group_other_type', TRUE);
                    $type_data['group_type_status'] = 3;
                    $check_type = $this->group_model->check_whether_group_type_exists_or_not($type_data['group_type_name']);
                    if (!$check_type) {
                        $this->db->insert('tbl_group_type', $type_data);
                        $insert_id = $this->db->insert_id();
                        $group_data['group_type_id'] = $insert_id;
                    }
                }

                $url = $this->input->post('group_url', true);

                $insert_url_id = $this->url_model->create_group_url($url);

                $group_data['group_description'] = $this->input->post('group_description', TRUE);
                $group_data['group_public_id'] = $this->input->post('group_public_id', TRUE);
                $group_data['group_created_by'] = $this->session->userdata('user_id');
                $group_data['group_permission'] = $this->input->post('group_permission', TRUE);
                $group_data['url_id'] = $insert_url_id;
                $group_data['group_status'] = $this->input->post('group_status', TRUE);                
                $group_data['group_created_date_time'] = date('Y-m-d H:i:s', strtotime(gmdate('Y-m-d H:i:s')));


                $this->group_model->save_group_information($group_data);

                redirect('groups/' . $this->session->userdata('active_menu'));
            }
            redirect('groups/' . $this->session->userdata('active_menu'));
        }
    }
     /**
     * @Function            : check_group_url_exist 
     * @Description         : existing url checking
     * @Developed By        : kazol [10-05-2017]            
     * */
    public function check_group_url_exist($url,$old_url){
            if ($old_url == $url) {
               return true;
           }else{
                $result = $this->url_model->check_url_exists1($url);
            if ($result == 1) {
                $this->form_validation->set_message('check_group_url_exist', "URL Already Exist");
                return false;
            }else{
                $sp = '/^[0-9a-zA-Z\-]+$/';
                if (!preg_match($sp, $url)) {
                    $this->form_validation->set_message('check_group_url_exist', "URL Cann't contain any '/[!@#$%&*()^,._;:]/'  if need use '-' Don't use Space");
                    return FALSE;
                } else if (strstr($url, ' ')) {
                    $this->form_validation->set_message('check_group_url_exist', " Use '-' in place of space");
                    return FALSE;
                } else if ($this->url_model->check_url_exists1($url) == 1) {
                    $this->form_validation->set_message('check_group_url_exist', "This URL Already Exist");
                    return FALSE;
                } else {
                    return TRUE;
                }
            }
        }
    }
     /**
     * @Function            : group_invitation_code_exist 
     * @Description         : existing invitation code checking
     * @Developed By        : kazol [10-05-2017]           
     * */
    public function group_invitation_code_exist($group_public_id,$old_public_id){
        if ($old_public_id == $group_public_id) {
            return true;
        } else{
        $result = $this->group_model->check_group_public_id($group_public_id);
            if ($result == 1) {
                $this->form_validation->set_message('group_invitation_code_exist', "Group public id exist");
                return false;
            } else {
                $sp = '/^[0-9a-zA-Z]+$/';
                if (!preg_match($sp, $group_public_id)) {
                    $this->form_validation->set_message('group_invitation_code_exist', "Allowed valid chatacter 0-9, a-z or A-Z (space not allowed)");
                    return FALSE;
                } else {
                    return TRUE;
                }
            }
        }
    }
   /**
     * @Function            : edit_group 
     * @Description         : Loads the edit group form
     * @Developed By        : Unknown
     * @Updated By          : Md Mashqur Ul Alam [03-09-17]
     * @Parameter           : $group_url    
     * @Status              : available      
     * */
    public function edit_group($group_url) {
// Right Sidebar Content Information
        $data['left_side_menu_view'] = 1;
        $data['left_side'] = 1;
        $person_id = $this->session->userdata('user_id');
        $data['active_menu'] = $this->session->userdata('active_menu');
        $data['active_sub_menu'] = $this->session->userdata('active_sub_menu');
        //$data['geo_info'][0] = $this->f_end_model->select_person_current_location($person_id);
        $data['group_details'] = $this->group_model->group_info_by_url($group_url);
        
        $this->load->library('form_validation');
        $this->form_validation->set_rules('group_name', 'Group Name', 'trim|required|max_length[50]');
        $this->form_validation->set_rules('group_type', 'Group Type', 'trim|required|max_length[50]');
        $this->form_validation->set_rules('group_other_type', 'Group Type', 'trim|max_length[50]');
        //$this->form_validation->set_rules('group_description', 'Group Description', 'required');
        $this->form_validation->set_rules('group_public_id', 'group public code', 'trim|required|callback_group_invitation_code_exist[' . $data['group_details']->group_public_id . ']');
        $this->form_validation->set_rules('group_url', 'Group URL', 'trim|max_length[50]|callback_check_group_url_exist[' . $data['group_details']->url . ']');
        $this->form_validation->set_rules('group_permission', 'group_permission', 'required');

        
        $data['group_type'] = $this->group_model->all_group_type_list($data['group_details']->group_type_id);
        if ($this->form_validation->run() == FALSE) {

            $data['main_content'] = $this->load->view('user/group/edit_group', $data, true);
            $this->load->view('user/master', $data);
        } else {

            $group_data['group_name'] = $this->input->post('group_name', TRUE);
            $group_data['group_type_id'] = $this->input->post('group_type', TRUE);

//save other goup type
            $category_data = array();
            if ($group_data['group_type_id'] == 'other') {
                $type_data['group_type_name'] = $this->input->post('group_other_type', TRUE);
                $type_data['group_type_publication_status'] = 1;
                $this->db->insert('tbl_group_type', $type_data);
                $insert_id = $this->db->insert_id();
                $group_data['group_type_id'] = $insert_id;
            }

            $url_id = $this->input->post('url_id', TRUE);
            $udata = array();
            $udata['url'] = $this->input->post('group_url', TRUE);
            $this->url_model->update_group_url($url_id, $udata['url']);

            $group_data['group_description'] = $this->input->post('group_description', TRUE);

            $group_data['group_public_id'] = $this->input->post('group_public_id', TRUE);
            $group_data['group_description'] = $this->input->post('group_description', TRUE);
            $group_data['group_created_by'] = $this->session->userdata('user_id');
            $group_data['group_permission'] = $this->input->post('group_permission', TRUE);
            $group_data['group_status'] = $this->input->post('group_status', TRUE);

            $this->group_model->update_group_information($group_data, $data['group_details']->group_id);
            $this->session->unset_userdata('group_id');
            $redirect_url = $this->session->userdata('redirect_url');
            redirect("$redirect_url");
        }
    }

    public function group_members($group_url = NULL, $page = NULL) {
        // Right Sidebar Content Information
        $person_id = $this->session->userdata('user_id');
        $data['left_side_menu_view'] = 1;
        $data['left_side'] = 1;
        $sdata = array();
        $sdata['group_url'] = $group_url;
        $sdata['redirect'] = 'group/' . $group_url . '/members';
        $this->session->set_userdata($sdata);

        $data['active_menu'] = $this->session->userdata('active_menu');
        $data['active_sub_menu'] = $this->session->userdata('active_sub_menu');
        $data['group_url'] = $group_url;
        //$data['geo_info'][0] = $this->f_end_model->select_person_current_location($person_id);
        if ($page != NULL) {
            $data['page'] = $page;
            $number = $page * 10 - 10;
            $data['serial'] = $number;
        } else {
            $data['page'] = 0;
            $data['serial'] = 0;
            $number = 0;
        }
        $user_id = $this->session->userdata('user_id');
        $data['group_details'] = $this->group_model->group_info_by_url($group_url);
        $data['totall_member'] = $this->group_model->count_select_group_member_list_info($data['group_details']->group_id);
        $data['group_member_list'] = $this->group_model->view_select_group_member_list_info($data['group_details']->group_id, $number);
//        foreach ($data['group_member_list'] as $v_group_member) {
//            $data['group_member_quiz'][$v_group_member->group_member_id] = $this->group_model->select_group_member_all_quiz($v_group_member->group_member_id);
//        }

        $data['main_content'] = $this->load->view('user/group/group_member_list', $data, true);
        $this->load->view('user/master', $data);
    }

    public function make_active_group_member($group_member_id) {
        $this->group_model->active_select_member($group_member_id);
        $person_id = $this->session->userdata('user_id');
        //...........................start save notification for group member acceptance........................
        $this->notification_model->save_group_member_active_notification($person_id, $group_member_id);
        //...........................End save notification for group member acceptance........................
        redirect($this->session->userdata('redirect'));
    }

    public function delete_group_member($group_member_id) {
        $this->group_model->archive_select_member($group_member_id);
        redirect($this->session->userdata('redirect'));
    }

    public function make_pending_group_member($group_member_id) {
        $this->group_model->pending_select_member($group_member_id);
        redirect($this->session->userdata('redirect'));
    }

    public function make_archive_group_member($group_member_id) {
        $this->group_model->archive_select_member($group_member_id);
        redirect($this->session->userdata('redirect'));
    }

    public function make_block_group_member($group_member_id) {
        $this->group_model->block_select_member($group_member_id);
        redirect($this->session->userdata('redirect'));
    }

    public function group_requested_members($group_url = NULL, $page = NULL) {
        // Right Sidebar Content Information
        $data['left_side_menu_view'] = 1;
        $data['left_side'] = 1;
      
        $sdata = array();
        $sdata['group_url'] = $group_url;
        $sdata['redirect'] = 'group/' . $group_url . '/requested-members';
        $this->session->set_userdata($sdata);
        if ($page != NULL) {
            $data['page'] = $page;
            $number = $page * 10 - 10;
            $data['serial'] = $number;
        } else {
            $data['page'] = 0;
            $data['serial'] = 0;
            $number = 0;
        }
        $data['group_url'] = $group_url;
        $data['active_menu'] = $this->session->userdata('active_menu');
        $data['active_sub_menu'] = $this->session->userdata('active_sub_menu');
        
        $user_id = $this->session->userdata('user_id');
        $data['group_details'] = $this->group_model->group_info_by_url($group_url);
        $data['totall_pending_member'] = $this->group_model->count_select_group_requested_member_list_info($data['group_details']->group_id);
        $data['group_requested_member_list'] = $this->group_model->view_select_group_requested_member_list_info($data['group_details']->group_id, $number);

        $data['main_content'] = $this->load->view('user/group/group_requested_members', $data, true);
        $this->load->view('user/master', $data);
    }

    public function number_wise_pending_list($page = NULL) {
        $value = $this->input->post("value", TRUE);
        $group_url = $this->input->post("group_url", TRUE);

        if ($page != NULL) {
            $data['page'] = $page;
            if ($value == 10) {
                $number = $page * 10 - 10;
            } else if ($value == 20) {
                $number = $page * 20 - 20;
            } else if ($value == 50) {
                $number = $page * 50 - 50;
            } else if ($value == 100) {
                $number = $page * 100 - 100;
            } else if ($value == 500) {
                $number = $page * 500 - 500;
            }
            $data['serial'] = $number;
        } else {
            $data['page'] = 0;
            $data['serial'] = 0;
            $number = 0;
        }
        $data['value'] = $value;
        $data['group_details'] = $this->group_model->group_info_by_url($group_url);
        $data['totall_pending_member'] = $this->group_model->count_select_group_requested_member_list_info($data['group_details']->group_id);
        $data['group_requested_member_list'] = $this->group_model->view_select_group_requested_member_list_info_number_wise($data['group_details']->group_id, $value, $number);
        echo $this->load->view('user/group/group_requested_members_ajax_pending_list', $data, true);
    }

    public function accept_all_pending_member() {
        $member_id = $this->input->post("group_member_id", TRUE);
        $value = $this->input->post("value", TRUE);
        $member_id_array = explode(",", $member_id);
        if ($member_id_array[count($member_id_array) - 1] == '') {
            array_pop($member_id_array);
        }

        if ($member_id) {
            $this->group_model->change_selected_group_member_status($member_id_array, $member_id, $value);
        }
    }

    public function group_detail($group_url = NULL) {

        $person_id = $this->session->userdata('user_id');
        $data['active_menu'] = $this->session->userdata('active_menu');
        $data['active_sub_menu'] = $this->session->userdata('active_sub_menu');
        //$data['geo_info'][0] = $this->f_end_model->select_person_current_location($person_id);
        $data['left_side_menu_view'] = 1;
        $data['left_side'] = 1;
        $sdata = array();
        $sdata['group_url'] = $group_url;
        $sdata['redirect'] = 'group-detail/' . $group_url;
        $this->session->set_userdata($sdata);

        $data['group_details'] = $this->group_model->group_info_by_url($group_url);
        $data['group_id'] = $data['group_details']->group_id;
        
        $data['group_member_list'] = $this->group_model->select_group_member_list_info($data['group_details']->group_id);
        $data['group_requested_members'] = $this->group_model->select_group_requested_member_list_info($data['group_details']->group_id);
        //$data['group_quiz'] = $this->group_model->select_group_quiz_list($data['group_details']->group_id);

        $data['main_content'] = $this->load->view('user/group/group_detail', $data, true);
        $this->load->view('user/master', $data);
    }

    public function group_member_quizes($profile_url) {
        // Right Sidebar Content Information
        $person_id = $this->session->userdata('user_id');
        $data['active_menu'] = $this->session->userdata('active_menu');
        $data['active_sub_menu'] = $this->session->userdata('active_sub_menu');
        $data['left_content'] = $this->load->view('user/side_menu', $data, TRUE);
        $data['right_content'] = $this->load->view('user/right_content', $data, TRUE);
        //$data['geo_info'][0] = $this->f_end_model->select_person_current_location($person_id);
        $data['left_side_menu_view'] = 1;
        $data['left_side'] = 1;
        $group_url = $this->session->userdata('group_url');
        $data['group_details'] = $this->group_model->group_info_by_url($group_url);
        $data['person_info'] = $this->profile_model->user_info_by_profile_url($profile_url);
        //$data['person_group_member_info'] = $this->group_model->user_group_member_info($data['person_info']->person_id, $data['group_details']->group_id);

        $data['user_all_quiz'] = $this->group_model->select_user_all_quiz($data['person_info']->person_id);
//        foreach ($data['user_all_quiz'] as $v_user_quiz) {
//            //Quiz Total Quistion
//            //User Quiz Grade
//            //Quiz Time
//        }

        $data['main_content'] = $this->load->view('user/group/group_member_quiz_list', $data, true);
        $this->load->view('user/master', $data);
    }

    public function group_quizes($group_url) {
        // Right Sidebar Content Information

        $data['left_side_menu_view'] = 1;
        $data['left_side'] = 1;
        $person_id = $this->session->userdata('user_id');
        $data['active_menu'] = $this->session->userdata('active_menu');
        $data['active_sub_menu'] = $this->session->userdata('active_sub_menu');
        //$data['geo_info'][0] = $this->f_end_model->select_person_current_location($person_id);

//        $group_url = $this->session->userdata('group_url');
        $data['group_details'] = $this->group_model->group_info_by_url($group_url);
        $data['group_all_quizes'] = $this->group_model->select_group_quiz_list($data['group_details']->group_id);
        foreach ($data['group_all_quizes'] as $v_quiz) {
            $data['quiz_all_questions'][$v_quiz->quiz_id] = $this->group_model->select_question_by_quiz_id($v_quiz->quiz_id);
        }

        $data['main_content'] = $this->load->view('user/group/group_quiz_list', $data, true);
        $this->load->view('user/master', $data);
    }

    public function publish_group($group_url) {
        $data['group_details'] = $this->group_model->group_info_by_url($group_url);
        $this->group_model->selected_group_active($data['group_details']->group_id);
        redirect($this->session->userdata('redirect'));
    }

    public function unpublish_group($group_url) {
        $data['group_details'] = $this->group_model->group_info_by_url($group_url);
        $this->group_model->selected_group_inactive($data['group_details']->group_id);
        redirect($this->session->userdata('redirect'));
    }

    public function archive_group($group_url) {
        $data['group_details'] = $this->group_model->group_info_by_url($group_url);
        $this->group_model->selected_group_archive($data['group_details']->group_id);
        redirect('groups/' . $this->session->userdata('active_menu'));
    }

    public function group_invitation1($group_url) {
        // Right Sidebar Content Information

        $data['left_side_menu_view'] = 1;
        $data['left_side'] = 1;
        $person_id = $this->session->userdata('user_id');
        $data['active_menu'] = $this->session->userdata('active_menu');
        $data['active_sub_menu'] = $this->session->userdata('active_sub_menu');
        //$data['geo_info'][0] = $this->f_end_model->select_person_current_location($person_id);

        $data['group_details'] = $this->group_model->group_info_by_url($group_url);

        $data['main_content'] = $this->load->view('user/group/group_invitation', $data, true);
        $this->load->view('user/master', $data);
    }

    public function group_invitation($group_url) {
        // Right Sidebar Content Information
        $person_id = $this->session->userdata('user_id');
        $data['active_menu'] = $this->session->userdata('active_menu');
        $data['active_sub_menu'] = $this->session->userdata('active_sub_menu');
        $data['left_content'] = $this->load->view('user/side_menu', $data, TRUE);
        $data['right_content'] = $this->load->view('user/right_content', $data, TRUE);
        //$data['geo_info'][0] = $this->f_end_model->select_person_current_location($person_id);

        $person_id = $this->session->userdata('user_id');
        $person_role = $this->session->userdata('person_role');
        $data['active_menu'] = $this->session->userdata('active_menu');
        $data['active_sub_menu'] = $this->session->userdata('active_sub_menu');
        $data['tab'] = 'invite_learners';
        $data['group_details'] = $this->group_model->group_info_by_url($group_url);

        if ($data['group_details']->group_permission == 3) {// my link
            $data['link_person'] = $this->user_course_model->select_link_person($person_id);
        } else if ($data['group_details']->group_permission == 4) {// Only Group
            $data['group'] = $this->user_course_model->select_group_by_person_id($person_id);

        } else if ($data['group_details']->group_permission == 5) {// Special Person
            $data['all_tt_user'] = $this->user_course_model->select_all_talhatraining_user();  //only Organization / Trainer / Student
        } else {
            $data['all_tt_user'] = $this->user_course_model->select_all_talhatraining_user();  //only Organization / Trainer / Student
        }

        if ($person_role == 3) {
            $data['person_info'] = '';
        } else if ($person_role == 4) {
            $data['person_info'] = $this->profile_model->organization_info_by_person_id($person_id);
            $data['resource_persons'] = $this->user_course_model->select_organization_all_resource_persons($data['person_info']->organization_id);
        }

        $this->load->helper(array('form', 'url'));
        $this->load->library('form_validation');
        $this->form_validation->set_rules('invitation_email', 'Invitation Email', 'trim');
        $this->form_validation->set_rules('invitation_message', 'Invitation Message', 'trim');

        if ($this->form_validation->run() == FALSE) {
            $data['main_content'] = $this->load->view('user/group/group_invitation', $data, true);
            $this->load->view('user/master', $data);
        } else {
            /*
             * Start Send Invitation Mail 
             */
            $to_addresses = '';
            $data['person_info'] = array();
            $to_address = trim($this->input->post('to_address', true));
            $to_address = explode(",", $to_address);

// Insert Person Email to tbl_course_person_permission for PUBLIC
            if ($data['group_details']->group_permission == 1) {
                for ($i = 0; $i < count($to_address); $i++) {
                    $data['person_info'][$to_address[$i]] = $this->user_course_model->select_user_information_by_email($to_address[$i]);
                    $to_addresses .= $to_address[$i] . ', ';

                }
                $to_address[] = '0';
            }

// Insert Eerson email to tbl_course_permission for LINK
            else if ($data['group_details']->group_permission == 3) {
                for ($i = 0; $i < count($to_address) - 1; $i++) {
                    $data['person_info'][$to_address[$i]] = $this->user_course_model->select_user_information_by_id($to_address[$i]);
                    $to_addresses .= $data['person_info'][$to_address[$i]]->person_email . ', ';
                }
            }

// Insert person-id to tbl_course_permission for Only GROUPS
            else if ($data['group_details']->group_permission == 4) {
                $to_address = array();
                $selected_group_id = trim($this->input->post('to_address', true));
                $selected_group_id = explode(",", $selected_group_id);

                for ($i = 0; $i < count($selected_group_id); $i++) {

                    $data['group_member'] = $this->user_course_model->select_group_member($selected_group_id[$i++]);
                    foreach ($data['group_member'] as $v_group_member) {
                        $to_address[] = $v_group_member->person_email;
                        $data['person_info'][$v_group_member->person_id] = $this->user_course_model->select_user_information_by_id($v_group_member->person_id);
                        $to_addresses .= $data['person_info'][$v_group_member->person_id]->person_email . ', ';
                    }
                }
                $to_address[] = '0'; //balancing for exploeded extra data in case of group
            }

// Insert person-id to tbl_course_permission for SPECIAL User
            else if ($data['group_details']->group_permission == 5) {
                for ($i = 0; $i < count($to_address) - 1; $i++) {
                    $data['person_info'][$to_address[$i]] = $this->user_course_model->select_user_information_by_id($to_address[$i]);
                    $to_addresses .= $data['person_info'][$to_address[$i]]->person_email . ', ';

                    $person_permission_info = $this->user_course_model->check_person_course_group_permission($data['course_info']->course_id, $to_address[$i]);

                    if (!$person_permission_info) {
                        $course_permission_id[] = $this->user_course_model->set_course_permission($data['course_info']->course_id, $data['person_info'][$to_address[$i]]->person_email);
                    } else {
                        $course_permission_id[] = $person_permission_info->course_person_permission_id;
                        $this->user_course_model->update_course_permission($person_permission_info->course_person_permission_id);
                    }
                }
            }

            /*
             * Collect Email Subject and Message
             */
            $data['message'] = $this->input->post('invitation_message', true);
            /*
             * Sending Email To Users
             */
            $mdata = array();
            if ($data['group_details']->group_permission == 4) {
                $g = 0;
                for ($i = 0; $i < count($to_address) - 1; $i++) {
                    $mdata['from_address'] = $this->session->userdata('user_email');
                    $mdata['company_name'] = 'Talha Training';
                    $mdata['admin_name'] = 'Talha Training Administrator';

                    $mdata['to_address'] = $to_address[$i];

                    $mdata['to_addresses'] = $to_addresses;
                    $mdata['subject'] = 'Group Invitation for Enrole';
                    $mdata['message'] = $data['message'];

                    $mdata['group_details'] = $data['group_details'];
                    $this->mailer_model->send_email_to_learners($mdata, 'group_invitation_email');
                }
            } else {
                for ($i = 0; $i < count($to_address) - 1; $i++) {
                    $mdata['from_address'] = $this->session->userdata('user_email');
                    $mdata['company_name'] = 'Talha Training';
                    $mdata['admin_name'] = 'Talha Training Administrator';

                    $mdata['to_address'] = $to_address[$i];
                    $mdata['to_addresses'] = $to_addresses;
                    $mdata['subject'] = 'Course Invitation for Enrole';
                    $mdata['message'] = $data['message'];

                    $mdata['group_details'] = $data['group_details'];
                    $this->mailer_model->send_email_to_learners($mdata, 'group_invitation_email');
                }
            }

            $this->group_detail($data['group_details']->url);
            return;
            /*
             * ABOVE PART WILL BE REMOVE 
             */
            redirect('group-detail/' . $data['group_details']->url);
        }
    }

    public function preview_group_email($group_url) {
        $data = array();
        $data['email_message'] = $this->input->post('message');
        $data['group_details'] = $this->group_model->group_info_by_url($group_url);
        echo $this->load->view('user/group/group_invitation_email_preview', $data, TRUE);
    }

    public function group_public_view() {
        $data = $this->welcome_model->generate_menu();
        $person_id = $this->session->userdata('user_id');
        $code = $this->uri->segment(2);
        $data['code'] = $code;
        $data['message'] = '';

        $data['group_info'] = $this->group_model->check_join_group_code_id($code);
        if (!$data['group_info']) {
            redirect();
        }

        $data['group_member_info'] = $this->group_model->check_member_requst($person_id, $data['group_info']->group_id);

        $data['group_creator_info'] = $this->profile_model->person_info_by_id($data['group_info']->group_created_by);
        $data['group_member_list'] = $this->group_model->select_group_member_list_info($data['group_info']->group_id);
        $data['group_quiz'] = $this->group_model->select_group_quiz_list($data['group_info']->group_id);
        $data['group_popular_quiz'] = $this->group_model->select_group_popular_quiz($data['group_info']->group_id);

        $data['main_content'] = $this->load->view('front_end/group_public_view', $data, true);
        $this->load->view('front_end/master', $data);
    }

    public function group_view() {
        $person_id = $this->session->userdata('user_id');
        $code = $this->uri->segment(2);

        $result = $this->f_end_model->selected_group_details_info_by_code($code);

        $data = array();
        $data['group_info'] = $this->group_model->group_info_for_public($result->group_id);
        if (!$data['group_info']) {
            redirect();
        }
        $data['group_creator_info'] = $this->profile_model->person_info_by_id($data['group_info']->group_created_by);
        $data['group_member_info'] = $this->group_model->check_member_requst($data['group_creator_info']->person_id, $result->group_id);

        $data['group_member_list'] = $this->group_model->select_group_member_list_info($data['group_info']->group_id);
        $data['group_quiz'] = $this->group_model->select_group_quiz_list($data['group_info']->group_id);
        $data['group_popular_quiz'] = $this->group_model->select_group_popular_quiz($data['group_info']->group_id);

        if ($result) {
            if ($result->group_permission == '1') {
                $data['main_content'] = $this->load->view('front_end/group_public_view', $data, true);
                $this->load->view('front_end/master', $data);
            } else if ($result->group_permission == '2') {
                $data['main_content'] = $this->load->view('front_end/group_public_view', $data, true);
                $this->load->view('front_end/master', $data);
            } else if ($result->group_permission == '3') {
                $data['main_content'] = $this->load->view('front_end/group_public_view', $data, true);
                $this->load->view('front_end/master', $data);
            } else if ($result->group_permission == '4') {
                $data['main_content'] = $this->load->view('front_end/group_public_view', $data, true);
                $this->load->view('front_end/master', $data);
            }
        } else {
            echo ('Invalid URL!');
            exit();
        }
    }

    public function select_group_more_members() {

        $group_id = $this->uri->segment(2);
        $start = $this->uri->segment(3);
        $limit = 4;
        $data['group_member_list'] = $this->group_model->select_group_more_members($group_id, $start, $limit);
        echo $this->load->view('front_end/group_more_members', $data, true);
    }

    public function select_group_more_quiz() {
        $group_id = $this->uri->segment(2);
        $start = $this->uri->segment(3);
        $limit = 4;
        $data['group_quiz'] = $this->group_model->select_group_more_quiz($group_id, $start, $limit);
        echo $this->load->view('front_end/group_more_quiz', $data, true);
    }

    public function select_group_more_popular_quiz() {
        $group_id = $this->uri->segment(2);
        $start = $this->uri->segment(3);
        $limit = 4;
        $data['group_quiz'] = $this->group_model->select_group_more_popular_quiz($group_id, $start, $limit);
        echo $this->load->view('front_end/group_more_quiz', $data, true);
    }

    /**
     * @Function            : join_group_by_group_code
     * @Used IN             : side_menu.php
     * @Description         : send join group requst by group public id
     * @Developed By        : Afrin jahan noumin 
     * @Start DateTime      : 1/06/2016
     * @Updated Date Time   : 
     * @Updated By          :       
     * @Parameter           : 
     * @View                :  group join modal
     * @Redirect            : 'group/' . $group_url
     * @Return              :   
     * @Status              : Available       
     */
    public function join_group_by_group_code() {

        if ($_POST) {
            $group_code = $this->input->post('group_public_id', TRUE);
            $data = array();
            $user_id = $this->session->userdata('user_id');
            $data['group_info'] = $this->group_model->group_info_by_public_id($group_code);
            if (!$data['group_info']) {
                redirect('groups/' . $this->session->userdata('active_menu'));
            }
            $group_url = $data['group_info']->url;
            $group_id = $data['group_info']->group_id;
            $result = $this->group_model->check_member_requst($user_id, $group_id);
            $gdata = array();
            if (!$result) {
                $gdata['person_id'] = $user_id;
                $gdata['group_id'] = $group_id;
                $offset = $this->session->userdata('time_offset');
                $gdata['group_join_date_time'] = date('y-m-d-h-i-s', (time() - $offset));
                $gdata['group_member_status'] = 3;
                $this->group_model->save_group_member_information($gdata);
                //...............................save notification for group join request..............
                $this->notification_model->save_group_request_notification_to_creator($user_id, $data['group_info']);
                //............................... end save notification for group join request..............
                redirect('group/' . $group_url);
            } elseif ($result && $result->group_member_status == 3) {

                redirect('group/' . $group_url);
            } elseif ($result && $result->group_member_status == 1) {

                redirect('group/' . $group_url);
            } elseif ($result && $result->group_member_status == 2) {
                $this->group_model->active_archive_member_id($user_id, $group_id);

                redirect('group/' . $group_url);
            }
            redirect('group/' . $group_url);
        }
    }

    public function leave_group() {
        $group_code = $this->uri->segment(3);
        $group_member_id = $this->uri->segment(4);
        $data = array();
        $person_id = $this->session->userdata('user_id');

        $data['group_info'] = $this->group_model->group_info_by_public_id($group_code);
        $group_id = $data['group_info']->group_id;
        $group_url = $data['group_info']->url;
        if (!$data['group_info']) {
            redirect();
        }

        $result = $this->group_model->check_member_requst($person_id, $group_id);
        if ($result) {
            $this->group_model->leave_group_member($group_id, $person_id);
            redirect('group/' . $group_url);
        }
    }

    public function cancel_group_request() {
        $group_code = $this->uri->segment(3);
        $group_member_id = $this->uri->segment(4);
        $data = array();
        $person_id = $this->session->userdata('user_id');

        $data['group_info'] = $this->group_model->group_info_by_public_id($group_code);
        $group_id = $data['group_info']->group_id;
        $group_url = $data['group_info']->url;
        if (!$data['group_info']) {
            redirect('group/' . $group_url);
        }
        $result = $this->group_model->check_member_requst($person_id, $group_id);
        if ($result) {
            $this->group_model->leave_group_member($group_id, $person_id);
            $data['code'] = '';
            redirect('group/' . $group_url);
        }
    }

    //topic:fornt end group
    //By:afrin Jahan Noumen
    //function: check group type exists or not
    public function check_front_end_group_type() {
        $value = $this->input->post("value", TRUE);
        $check_type = $this->group_model->check_whether_group_type_exists_or_not($value);
        if ($check_type) {
            echo 1;
        }
    }

    public function check_edit_front_end_group_type() {
        $value = $this->input->post("value", TRUE);
        $check_type = $this->group_model->check_whether_group_type_exists_or_not($value);
        if ($check_type) {
            echo 1;
        }
    }

    public function fornt_end_group_url_exists() {
        $url_status = $this->input->post('url_status', TRUE);
        $video_url = $this->input->post('group_url', TRUE);
        if ($url_status == '1') {
            echo $this->url_model->check_url_exists($video_url);
        } else {
            echo $this->url_model->check_url_exists1($video_url);
        }
    }

    //view each content of group
    public function view_content_group($post_id) {
        $data = array();
        $person_id = $this->session->userdata('user_id');
        $data['active_menu'] = 'As Organization';
        $data['active_sub_menu'] = 'Organization Group';
        //$data['geo_info'][0] = $this->f_end_model->select_person_current_location($person_id);
        $data['left_side_menu_view'] = 1;
        $data['left_side'] = 1;
        $data['post_value'] = $this->post_model->select_post_by_post_id($post_id);
        $data["person_info"] = $this->super_admin_group_model->select_student_info_person_id($data['post_value']->posted_by);
        $data['post_url'] = $this->post_model->select_post_comment_url($post_id, 1);
        $data['post_function'][$post_id] = $this->post_model->get_post_value_by_post_id($post_id);
        $data['total_comment'][$post_id] = $this->post_model->get_total_first_comment_by_post_id($post_id);

        $data['post_comment'][$post_id] = $this->post_model->get_post_first_comment_by_post_id($post_id);
        foreach ($data['post_comment'][$post_id] as $post_comment_value) {
            $data['comment_url'][$post_comment_value->comment_id] = $this->post_model->select_post_comment_url($post_comment_value->comment_id, 2);

            $data['comment_reply'][$post_comment_value->comment_id] = $this->post_model->get_post_comment_replay_limit_post_comment_id($post_comment_value->comment_id);
            $data['total_comment_reply'][$post_comment_value->comment_id] = $this->post_model->get_total_comment_by_comment_id($post_comment_value->comment_id);
            foreach ($data['comment_reply'][$post_comment_value->comment_id] as $comment_reply_value) {
                $data['reply_comment_url'][$comment_reply_value->comment_id] = $this->post_model->select_post_comment_url($comment_reply_value->comment_id, 2);
                $data['total_nested_reply'][$comment_reply_value->comment_id] = $this->post_model->get_total_comment_by_comment_id($comment_reply_value->comment_id);
            }
        }


        if ($data['post_value']->post_type == 3 || $data['post_value']->post_type == 4 || $data['post_value']->post_type == 5) {
            $profile_url = $this->post_model->get_profile_url($data['post_value']->posted_by);
            $data['file_path'] = 'content-library/' . $profile_url->url . '/' . $data['post_value']->post_details;
        }

        $data['main_content'] = $this->load->view('user/group/view_video', $data, true);
        $this->load->view('user/master', $data);
    }

    //download group content
    public function download_fornt_end_assigment_file_authenticate() {
        $person_id = $this->session->userdata('user_id');
        $group_id = $this->input->post("group_id");
        $check_group_creator = $this->group_model->select_group_creator($group_id);
        
        if ($check_group_creator->group_created_by == $person_id) {
            echo 1;
        }
    }

    public function download_assignment_file_fornt_end_group($post_id) {
        $post_info = $this->group_model->select_specific_post_info($post_id);
        $post_path = $post_info->post_details;
        $file_name = $post_info->post_file_original_name;
        $post_by = $post_info->posted_by;
        $profile_url = $this->post_model->get_profile_url($post_by);
        $file_path = 'content-library/' . $profile_url->url . '/' . $post_path;

        $download_post_path = file_get_contents($file_path);
        $this->load->helper('download');
        force_download($file_name, $download_post_path);
    }

    public function remove_fornt_group_media_file_backend() {
        $post_id = $this->input->post("post_id");
        $group_id = $this->input->post("group_id");
        $person_id = $this->session->userdata('user_id');
        $post_info = $this->group_model->select_specific_post_info($post_id);
        $post_path = $post_info->post_details;
        $post_by = $post_info->posted_by;

        $group_creator = $this->group_model->check_group_creator_id($group_id);
        if ($group_creator->group_created_by == $person_id) {

            $this->group_model->remove_post_group_note_by_admin_or_creator($post_id, $group_id);
            $check_all_grp_delete = $this->group_model->select_post_visibity_for_all_group($post_id);
            foreach ($check_all_grp_delete as $val) {
                $grp_id[] = $val->group_id;
            }
            $group_id_array = implode(",", $grp_id);
            
            $check_post = $this->group_model->check_group_visibility_for_that_post($post_id, $group_id_array, $grp_id);
            
            if ($check_post == NULL) {
            
                $this->group_model->change_post_status($post_id);
            }
        } else {
            echo 1;
        }
    }

    public function check_join_group_code() {

        $code = $this->input->post("value", TRUE);
        $result = $this->group_model->check_join_group_code_id($code);
        if ($result) {
            $check_group_status = $this->group_model->check_join_group_status($result->group_id);

            if ($check_group_status->group_status == 0 || $check_group_status->group_status == 2) {
                echo 3;
            } else {
                $check_member_status = $this->group_model->check_group_member_status($result->group_id);
                if ($check_member_status) {
                    echo 4;
                } else {
                    echo 1;
                }
            }
        } else {

            echo 2;
        }
    }

//end afrin jahan noumin .....
}

?>