<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Front_end_support extends CI_Controller {
    public function __construct() {
        parent::__construct();
        $this->load->model('front_end_support_model');
        //$this->load->model('sign_up_model');  //for generate captcha
    }

    /*     * ----------------------------------support knowledgebase frontend start here ------------------- * */

    /**
     * @Function            : support
     * @Used IN             : $route['support'] = "front_end_support/support";    line 42
     * @Description         : used to load support page (front_end)
     * @Developed By        : Tania Akter
     * @Start DateTime      : 27/04/2016  
     * @Status              : available      
     * */
    function support() {
        $user_id = $this->session->userdata('user_id');
        $data = $this->welcome_model->generate_menu();
        $data['content_variable'] = 'support_view_content';
        $data['knowledgebase_all_info'] = $this->front_end_support_model->select_all_knowledgebase_info();
        $data['main_content'] = $this->load->view('front_end/tt_support/support', $data, TRUE);
        if ($user_id) {
            $this->load->view('user/master', $data);
        } else {
            $this->load->view('front_end/master', $data);
        }
    }

    /**
     * @Function            : support_knowledgebase
     * @Used IN             : front_end/tt_support/support   line--24
     * @Description         : used to display knowledgebase answer
     * @Developed By        : Tania Akter
     * @Start DateTime      : 27/04/2016  
     * @Status              : available      
     * */
    function support_knowledgebase($support_id) {
        $user_id = $this->session->userdata('user_id');
        $data = $this->welcome_model->generate_menu();
        $data['content_variable'] = 'support_view_content';
        $data['knowledgebase_answer'] = $this->front_end_support_model->get_knowledgebase_info($support_id);
        $data['related_knowledgebase'] = $this->front_end_support_model->select_related_knowledgebase_info(5);
        $data['total_knowledgebase'] = $this->front_end_support_model->select_total_related_knowledgebase_info();
        $data['main_content'] = $this->load->view('front_end/tt_support/support_knowledgebase_answer', $data, TRUE);
        if ($user_id) {
            $this->load->view('user/master', $data);
        } else {
            $this->load->view('front_end/master', $data);
        }
    }

    /**
     * @Function            : support_more_knowledgebase
     * @Used IN             : front_end/tt_support/support_knowledgebase_answer line--53 
     * @Description         : used to get more knowledgebase info
     * @Developed By        : Tania Akter
     * @Start DateTime      : 30/04/2016  
     * @Status              : available      
     * */
    function support_more_knowledgebase() {
        $counter = $this->input->post('counter', TRUE);
        $data['related_knowledgebase'] = $this->front_end_support_model->select_related_knowledgebase_info($counter + 3);
        $data['total_knowledgebase'] = $this->front_end_support_model->select_total_related_knowledgebase_info();
        echo $this->load->view('front_end/tt_support/more_knowledgebase', $data, true);
    }

    /** ---------------------support knowledgebase frontend end here------------------------------- * */
    /** ---------------------support idea frontend start here------------------------------- * */

    /**
     * @Function            : ideas
     * @Used IN             : front_end/tt_support/ideas.php  
     * @Description         : used to load idea page with all active ideas.
     * @Developed By        : Tania Akter
     * @Start DateTime      : 30/04/2016  
     * @Status              : available      
     * */
    function ideas() {
        $user_id = $this->session->userdata('user_id');
        $data = $this->welcome_model->generate_menu();
        $data['content_variable'] = 'support_view_content';
        $data['all_ideas'] = $this->front_end_support_model->select_all_ideas_info();
        $data['main_content'] = $this->load->view('front_end/tt_support/ideas', $data, TRUE);
        if ($user_id) {
            $this->load->view('user/master', $data);
        } else {
            $this->load->view('front_end/master', $data);
        }
    }

    /**
     * @Function            : idea_share
     * @Used IN             : front_end/tt_support/ideas   line---31 
     * @Description         : used to share idea
     * @Developed By        : Tania Akter
     * @Start DateTime      : 30/04/2016  
     * @Status              : available      
     * */
    function idea_share() {
        $user_id = $this->session->userdata('user_id');
        $data = $this->welcome_model->generate_menu();
        $data['content_variable'] = 'support_view_content';
        if ($user_id == NULL) {
            $sdata['message'] = 'Please sign in to share your idea.';
            $this->session->set_userdata($sdata);
            redirect('ideas');
        } else {
            //$data['captcha'] = $this->sign_up_model->generate_captcha();
            $data['main_content'] = $this->load->view('front_end/tt_support/idea_share', $data, TRUE);
            if ($user_id) {
                $this->load->view('user/master', $data);
            } else {
                $this->load->view('front_end/master', $data);
            }
        }
    }

    /**
     * @Function            : add_idea
     * @Used IN             : front_end/tt_support/idea_share   line--17
     * @Description         : used to add idea
     * @Developed By        : Tania Akter
     * @Updated By          : Kazol
     * @Start DateTime      : 2/04/2016  
     * @Status              : available      
     * */
    function add_idea() {
        $user_id = $this->session->userdata('user_id');
        $person_url = $this->front_end_support_model->get_profile_url($user_id);        
        $data['content_variable'] = 'support_view_content';
        $this->load->library('form_validation');
        $this->form_validation->set_rules('idea_title', 'idea_title', 'required');
        $this->form_validation->set_rules('idea_describe', 'idea_describe', 'required');
        $this->form_validation->set_rules('google_captcha', 'google_captcha', 'required');
        if ($this->form_validation->run() == FALSE){
            $data['main_content'] = $this->load->view('front_end/tt_support/idea_share', $data, TRUE);
            if ($user_id) {
                $this->load->view('user/master', $data);
            } else {
                $this->load->view('front_end/master', $data);
            }
        }else{
                
        $this->front_end_support_model->save_idea($user_id, $person_url);
        $sdata['message1'] = 'Thank you for your idea, we are going to deploy this idea soon..';
        $this->session->set_userdata($sdata);
        redirect('ideas');
        }
    }

    /**
     * @Function            : support_idea
     * @Used IN             : front_end/tt_support/ideas.php   line-- 50 
     * @Description         : used to view idea details
     * @Developed By        : Tania Akter
     * @Start DateTime      : 3/04/2016  
     * @Status              : available      
     * */
    function support_idea($support_id) {
        $user_id = $this->session->userdata('person_id');
        $data = $this->welcome_model->generate_menu();
        $data['content_variable'] = 'support_view_content';
        $data['reply'] = '1';
        //$data['captcha'] = $this->sign_up_model->generate_captcha();
        $data['sign_in_person_info'] = $this->front_end_support_model->sign_in_person_all_info($user_id);
        $data['idea_answer'] = $this->front_end_support_model->get_idea_info($support_id);
        $data['related_idea'] = $this->front_end_support_model->select_related_info(5, 2);
        $data['total_idea'] = $this->front_end_support_model->select_total_related_idea_info();
        $data['all_idea_reply'] = $this->front_end_support_model->get_all_idea_reply($support_id);
        foreach ($data['all_idea_reply'] as $idea_reply_value) {
            $data['idea_reply_attachment'][$idea_reply_value->support_reply_id] = $this->front_end_support_model->get_reply_download_info($idea_reply_value->support_reply_id, 2);
        }
        $data['get_download'] = $this->front_end_support_model->get_download_info($support_id, 1);
        $data['main_content'] = $this->load->view('front_end/tt_support/support_idea_answer', $data, TRUE);
        if ($user_id) {
            $this->load->view('user/master', $data);
        } else {
            $this->load->view('front_end/master', $data);
        }
    }

    /**
     * @Function            :support_more_idea
     * @Used IN             : front_end/tt_support/support_idea_answer    line--335
     * @Description         : used to view more idea
     * @Developed By        : Tania Akter
     * @Start DateTime      : 3/04/2016  
     * @Status              : available      
     * */
    function support_more_idea() {
        $counter = $this->input->post('counter', TRUE);
        $data['related_idea'] = $this->front_end_support_model->select_related_info($counter + 3, 2);
        $data['total_idea'] = $this->front_end_support_model->select_total_related_idea_info();
        echo $this->load->view('front_end/tt_support/more_idea', $data, true);
    }

    /**
     * @Function            : add_reply_idea
     * @Used IN             : front_end/tt_support/support_idea_answer    line--241
     * @Description         : used to reply in support idea
     * @Developed By        : Tania Akter
     * @Updated by          : Kazol
     * @Start DateTime      : 3/04/2016  
     * @Status              : available      
     * */
    function add_reply_idea($support_id) {
        $user_id = $this->input->post('reply_person_id', TRUE);       
        if(isset($user_id)){
            $person_url = $this->front_end_support_model->get_profile_url($user_id);
        }        
        $this->form_validation->set_rules('support_reply_description','Idea reply description','required');
        if(!$this->form_validation->run()){
            $this->support_idea($support_id);
        }else{
        $this->front_end_support_model->save_reply_idea($user_id, $person_url, $support_id);
        redirect('support-idea/' . $support_id);
        }
    }

    /**
     * @Function            :download_idea_file
     * @Used IN             : front_end/tt_support/support_idea_answer  line---44,55, 64, 75, 86, 95
     * @Description         : used to download idea file
     * @Developed By        : Tania Akter
     * @Start DateTime      : 3/04/2016  
     * @Status              : available      
     * */
    function download_idea_file($support_attachment_id) {
        $result = $this->front_end_support_model->get_idea_download_file_info($support_attachment_id);
        $this->load->helper('download');
        $file_name = explode('/', $result->support_attachment_location);
        $file_path = $result->support_attachment_location;
        $files_url = 'content-library/' . $result->url . '/' . $file_path;
        $data = file_get_contents("$files_url");
        force_download($file_name[1], $data);
    }

    /**
     * @Function            :download_idea_reply_file
     * @Used IN             : front_end/tt_support/support_idea_answer  line---144,155, 165, 175, 186, 195 
     * @Description         : used to download idea reply file
     * @Developed By        : Tania Akter
     * @Start DateTime      : 3/04/2016  
     * @Status              : available      
     * */
    function download_idea_reply_file($support_attachment_id) {
        $result = $this->front_end_support_model->get_reply_idea_doenload_file_info($support_attachment_id);
        $this->load->helper('download');
        $file_name = explode('/', $result->support_attachment_location);
        $file_path = $result->support_attachment_location;
        $files_url = 'content-library/' . $result->url . '/' . $file_path;
        $data = file_get_contents("$files_url");
        force_download($file_name[1], $data);
    }

    /** ---------------------support idea frontend end here------------------------------- * */
    /** ---------------------support bug report frontend start here------------------------------- * */

    /**
     * @Function            :bug_report
     * @Used IN             : $route['bug-report'] = "front_end_support/bug_report";  
     * @Description         : used to load bug report page
     * @Developed By        : Tania Akter
     * @Start DateTime      : 15/05/2016  
     * @Status              : available      
     * */
    function bug_report() {
        $user_id = $this->session->userdata('user_id');
        $data = $this->welcome_model->generate_menu();
        $data['content_variable'] = 'support_view_content';
        $data['all_bug_reports'] = $this->front_end_support_model->select_all_bug_reports_info();
        $data['main_content'] = $this->load->view('front_end/tt_support/bug_report', $data, TRUE);
        if ($user_id) {
            $this->load->view('user/master', $data);
        } else {
            $this->load->view('front_end/master', $data);
        }
    }

    /**
     * @Function            : bug_report_add
     * @Used IN             : front_end/tt_support/bug_report
     * @Description         : used to report a bug 
     * @Developed By        : Tania Akter
     * @Start DateTime      : 15/05/2016  
     * @Status              : available      
     * */
    function bug_report_add() {
        $data = $this->welcome_model->generate_menu();
        $user_id = $this->session->userdata('user_id');
        if ($user_id == '') {
            $sdata['message'] = 'Please sign in to report a bug.';
            $this->session->set_userdata($sdata);
            redirect('bug-report');
        } else {
            $person_url = $this->front_end_support_model->get_profile_url($user_id);            
            $data['content_variable'] = 'support_view_content';
            $this->load->library('form_validation');
            $this->form_validation->set_rules('bug_subject', 'Bug_subject', 'required');
            $this->form_validation->set_rules('bug_describe', 'Bug_describe', 'required');
            $this->form_validation->set_rules('google_captcha', 'google_captcha', 'required');
            if ($this->form_validation->run() == FALSE) {
                //$data['captcha'] = $this->sign_up_model->generate_captcha();                            //31-05-2016
                $data['main_content'] = $this->load->view('front_end/tt_support/report_a_bug', $data, TRUE);
                $this->load->view('user/master', $data);
            } else {
                $this->front_end_support_model->save_bug_report($user_id, $person_url);
                $sdata['message1'] = 'Thank you for submitting this bug, we are going to work on it soon..';
                $this->session->set_userdata($sdata);
                redirect('bug-report');
            }
        }
    }

    /**
     * @Function            : support_bug_report
     * @Used IN             : front_end/tt_support/more_bug_report, 
      front_end/tt_support/support_bug_report_answer,
      front_end/tt_support/bug_report
     * @Description         : used to view bug report details
     * @Developed By        : Tania Akter
     * @Start DateTime      : 15/05/2016  
     * @Status              : available      
     * */
    function support_bug_report($support_id) {
        $user_id = $this->session->userdata('person_id');
        $data = $this->welcome_model->generate_menu();
        $data['content_variable'] = 'support_view_content';
        $data['reply'] = '1';
        //$data['captcha'] = $this->sign_up_model->generate_captcha();
        $data['sign_in_person_info'] = $this->front_end_support_model->sign_in_person_all_info($user_id);
        $data['bug_report_answer'] = $this->front_end_support_model->get_bug_report_info($support_id);
        $data['related_bug_report'] = $this->front_end_support_model->select_related_info(5, 3);
        $data['total_bug_report'] = $this->front_end_support_model->select_total_related_bug_report_info();
        $data['all_bug_report_reply'] = $this->front_end_support_model->get_all_bug_report_reply($support_id);
        foreach ($data['all_bug_report_reply'] as $bug_report_reply_value) {
            $data['bug_report_reply_attachment'][$bug_report_reply_value->support_reply_id] = $this->front_end_support_model->get_reply_download_info($bug_report_reply_value->support_reply_id, 2);
        }
        $data['get_download'] = $this->front_end_support_model->get_download_info($support_id, 1);
        $data['main_content'] = $this->load->view('front_end/tt_support/support_bug_report_answer', $data, TRUE);
        if ($user_id) {
            $this->load->view('user/master', $data);
        } else {
            $this->load->view('front_end/master', $data);
        }
    }

    /**
     * @Function            :support_more_bug_report
     * @Used IN             : fron_end/tt_support/support_bug_report_answer
     * @Description         : get more bug report
     * @Developed By        : Tania Akter
     * @Start DateTime      : 16/05/2016  
     * @Status              : available      
     * */
    function support_more_bug_report() {
        $counter = $this->input->post('counter', TRUE);
        $data['related_bug_report'] = $this->front_end_support_model->select_related_info($counter + 3, 3);
        $data['total_bug_report'] = $this->front_end_support_model->select_total_related_bug_report_info();
        echo $this->load->view('front_end/tt_support/more_bug_report', $data, true);
    }

    /**
     * @Function            :download_bug_report_attachment
     * @Used IN             : front_end/tt_support/support_bug_report_answer
     * @Description         : used to download bug report attachment
     * @Developed By        : Tania Akter
     * @Start DateTime      : 15/05/2016  
     * @Status              : available      
     * */
    function download_bug_report_attachment($support_attachment_id) {
        $result = $this->front_end_support_model->get_idea_download_file_info($support_attachment_id);
        $this->load->helper('download');
        $file_name = explode('/', $result->support_attachment_location);
        $file_path = $result->support_attachment_location;
        $files_url = 'content-library/' . $result->url . '/' . $file_path;
        $data = file_get_contents("$files_url");
        force_download($file_name[1], $data);
    }

    /**
     * @Function            :add_reply_bug_report
     * @Used IN             : front_end/tt_support/support_bug_report_answer
     * @Description         : used to add reply on bug report
     * @Developed By        : Tania Akter
     * @Updated By          : Kazol
     * @Start DateTime      : 15/05/2016  
     * @Status              : available      
     * */
    function add_reply_bug_report($support_id) {
        $user_id = $this->input->post('reply_person_id', TRUE);
        if(isset($user_id)){
           $person_url = $this->front_end_support_model->get_profile_url($user_id); 
        }        
        $this->form_validation->set_rules('reply_bug_report_description','Reply bug report description','required');
        if(!$this->form_validation->run()){
            $this->support_bug_report($support_id);
        }else{
        $this->front_end_support_model->save_reply_bug_report($user_id, $person_url, $support_id);
        redirect('support-bug-report/' . $support_id);                  //31-05-2016
        }
    }

    /**
     * @Function            :download_bug_report_reply_attachment
     * @Used IN             : front_end/tt_support/support_bug_report_answer
     * @Description         : used to download bug report reply attachment
     * @Developed By        : Tania Akter
     * @Start DateTime      : 15/05/2016  
     * @Status              : available      
     * */
    function download_bug_report_reply_attachment($support_attachment_id) {
        $result = $this->front_end_support_model->get_reply_idea_doenload_file_info($support_attachment_id);
        $this->load->helper('download');
        $file_name = explode('/', $result->support_attachment_location);
        $file_path = $result->support_attachment_location;
        $files_url = 'content-library/' . $result->url . '/' . $file_path;
        $data = file_get_contents("$files_url");
        force_download($file_name[1], $data);
    }

    /** ---------------------support  bug report  frontend end here------------------------------- * */
}
