<?php
defined('BASEPATH') OR exit('No direct script access allowed');


class Classroom extends TT_user_login {
    public function __construct() {
        parent::__construct();
        $this->classroom_model->check_for_not_held_class();
    }
   

/*
      -----------@@@RIPON@ Start ClassRoom Part----------------------------------
     */

    /**
     * @Function            : schedule_class 
     * @Used IN             : @function-'schedule_class.php' 
     * @Description         : scheduling class
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 02-02-2016 01:38 PM    
     * @Status              : available      
     * */
    function schedule_class() {
  
        $data['left_side_menu_view'] = 1;
        $data['left_side']=1;
        $data['active_menu'] = $this->session->userdata('active_menu');
        $data['active_sub_menu'] = $this->session->userdata('active_sub_menu');
        $data['active_sub_menu_item'] = $sdata['active_sub_menu_item'] = 'scheduling';
        $this->session->set_userdata($sdata);
     
        $data['active'] = 'add_course';

        $person_id = $this->session->userdata('user_id');
        $data['person_info'] = $this->profile_model->get_single_person_information_by_person_id($person_id);
        if ($data['person_info']->person_role == 3) {
            $data['resource_person_info'] = $this->profile_model->select_resource_person_info($data['person_info']->person_id);
            if ($data['resource_person_info']->resource_person_type == 1) {
                $data['course_category'] = $this->user_course_model->select_tt_and_org_teacher_category_by_resource_person_id($data['resource_person_info']->person_id, $data['resource_person_info']->resource_person_id);
            } else if ($data['resource_person_info']->resource_person_type == 2) {
                $data['course_category'] = $this->user_course_model->select_individual_teacher_category_person_id($data['resource_person_info']->person_id);
            } else if ($data['resource_person_info']->resource_person_type == 3) {
                $data['course_category'] = $this->user_course_model->select_tt_and_org_teacher_category_by_resource_person_id($data['resource_person_info']->person_id, $data['resource_person_info']->resource_person_id);
            }
        } else if ($data['person_info']->person_role == 4) {
            $data['resource_person_info'] = $this->profile_model->select_resource_person_info($data['person_info']->person_id);
            $data['course_category'] = $this->user_course_model->select_organization_category_by_organization_id($data['resource_person_info']->organization_id);
        }

        $data['feature_info'] = $this->super_admin_feature_model->check_course_feature_information($data['person_info']->person_id);
        if ($data['feature_info']) {
            $data['feature_status'] = 1;

            $this->form_validation->set_rules('hidden_feature_stauus', 'Feature', 'callback_check_feature_status');
            $this->form_validation->set_rules('classroom_title', 'Classroom Title', 'required|trim|max_length[256]|xss_clean');
            $this->form_validation->set_rules('hidden_course_id', 'Course Name', 'required|trim|xss_clean|callback_check_course_id');
            $this->form_validation->set_rules('hidden_course_name', 'Course Name', 'trim|xss_clean');
            $this->form_validation->set_rules('class_date', 'Class Start Date', 'required|trim|xss_clean|callback_check_class_start_date[' . $data['feature_info']->virtual_classroom_per_day . ']');
            $this->form_validation->set_rules('class_start_time', 'Class Start Time', 'required|trim|xss_clean|callback_check_class_start_date_time1');
            $this->form_validation->set_rules('duration', 'Class Duration', 'required|trim|xss_clean|callback_check_class_duration[' . $data['feature_info']->virtual_classroom_number . ']');
            $this->form_validation->set_rules('classroom_instruction', 'Classroom Instruction', 'trim|xss_clean');
        } else {
            $this->form_validation->set_rules('hidden_feature_stauus', 'Feature', 'callback_check_feature_status');
            $data['feature_status'] = 0;
        }

        if ($this->form_validation->run() == FALSE) {
            $data['main_content'] = $this->load->view('user/class/schedule_class', $data, true);
            $this->load->view('user/master', $data);
        } else {
            $classroom_id = $this->classroom_model->save_classroom_information();
            $data['classroom_info'] = $this->classroom_model->select_classroom_info_by_classroom_id($classroom_id);
            redirect('schedule-review-and-publish/' . $data['classroom_info']->url, 'refresh');
        }
    }

    /**
     * @Function            : schedule_class 
     * @Used IN             : @function-'schedule_class.php' 
     * @Description         : scheduling class
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 02-02-2016 01:38 PM    
     * @Status              : available      
     * */
    public function edit_scheduled_class($classroom_url) {
      
        $data['active_menu'] = $this->session->userdata('active_menu');
        $data['active_sub_menu'] = $this->session->userdata('active_sub_menu');
        $data['active_sub_menu_item'] = $this->session->userdata('active_sub_menu_item');
        $data['left_side_menu_view'] = 1;
        $data['left_side']=1;
        $data['classroom_info'] = $this->classroom_model->select_classroom_info_by_classroom_url($classroom_url);
        if (!$data['classroom_info']) {
            redirect();
        }

        $person_id = $this->session->userdata('user_id');
        $data['person_info'] = $this->profile_model->get_single_person_information_by_person_id($person_id);
        if ($data['person_info']->person_role == 3) {
            $data['resource_person_info'] = $this->profile_model->select_resource_person_info($data['person_info']->person_id);
            if ($data['resource_person_info']->resource_person_type == 1) {
                $data['course_category'] = $this->user_course_model->select_tt_and_org_teacher_category_by_resource_person_id($data['resource_person_info']->person_id, $data['resource_person_info']->resource_person_id);
            } else if ($data['resource_person_info']->resource_person_type == 2) {
                $data['course_category'] = $this->user_course_model->select_individual_teacher_category_person_id($data['resource_person_info']->person_id);
            } else if ($data['resource_person_info']->resource_person_type == 3) {
                $data['course_category'] = $this->user_course_model->select_tt_and_org_teacher_category_by_resource_person_id($data['resource_person_info']->person_id, $data['resource_person_info']->resource_person_id);
            }
        } else if ($data['person_info']->person_role == 4) {
            $data['resource_person_info'] = $this->profile_model->select_resource_person_info($data['person_info']->person_id);
            $data['course_category'] = $this->user_course_model->select_organization_category_by_organization_id($data['resource_person_info']->organization_id);
        }

        $data['feature_info'] = $this->super_admin_feature_model->check_course_feature_information($data['person_info']->person_id);
        if ($data['feature_info']) {
            $data['feature_status'] = 1;

            $this->form_validation->set_rules('hidden_feature_stauus', 'Feature', 'callback_check_feature_status');
            $this->form_validation->set_rules('classroom_title', 'Classroom Title', 'required|trim|max_length[256]|xss_clean');
            $this->form_validation->set_rules('hidden_course_id', 'Course Name', 'required|trim|xss_clean|callback_check_course_id');
            $this->form_validation->set_rules('hidden_course_name', 'Course Name', 'trim|xss_clean');
            $this->form_validation->set_rules('class_date', 'Class Start Date', 'required|trim|xss_clean|callback_check_class_start_date_for_edit[' . $data['feature_info']->virtual_classroom_per_day . ',' . $data['classroom_info']->classroom_id . ']');
            $this->form_validation->set_rules('class_start_time', 'Class Start Time', 'required|trim|xss_clean|callback_check_class_start_date_time1');
            $this->form_validation->set_rules('duration', 'Class Duration', 'required|trim|xss_clean|callback_check_class_duration_edit[' . $data['feature_info']->virtual_classroom_number . ',' . $data['classroom_info']->classroom_id . ']');
            $this->form_validation->set_rules('classroom_instruction', 'Classroom Instruction', 'trim|xss_clean');
        } else {
            $this->form_validation->set_rules('hidden_feature_stauus', 'Feature', 'callback_check_feature_status');
            $data['feature_status'] = 0;
        }

        if ($this->form_validation->run() == FALSE) {
            $data['main_content'] = $this->load->view('user/class/edit_scheduled_class', $data, true);
            $this->load->view('user/master', $data);
        } else {
            $classroom_id = $this->classroom_model->update_class_schedule_information($data['classroom_info']);
            $data['classroom_info'] = $this->classroom_model->select_classroom_info_by_classroom_id($classroom_id);
            redirect('schedule-review-and-publish/' . $data['classroom_info']->url, 'refresh');
        }
    }

    /**
     * @Function            : get_course_by_category_id 
     * @Used IN             : @function-'add_course.php'  @MODAL
     * @Description         : get all available course using category ID  
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 02-02-2016 01:38 PM    
     * @Status              : available      
     * */
    function get_course_by_category_id() {
        $course_category_id = $this->input->post('course_category_id', TRUE);
        $person_id = $this->session->userdata('user_id');
        $data['person_info'] = $this->profile_model->get_single_person_information_by_person_id($person_id);
        if ($data['person_info']->person_role == 3) {
            $data['resource_person_info'] = $this->profile_model->select_resource_person_info($data['person_info']->person_id);
            if ($data['resource_person_info']->resource_person_type == 1) {
                $data['all_courses'] = $this->user_course_model->select_assigned_tt_course_by_person_id($data['resource_person_info']->person_id, $data['resource_person_info']->resource_person_id, $course_category_id);
            } else if ($data['resource_person_info']->resource_person_type == 2) {
                $data['all_courses'] = $this->user_course_model->select_individual_teacher_course_by_person_id($data['resource_person_info']->person_id, $course_category_id);
            } else if ($data['resource_person_info']->resource_person_type == 3) {
                $data['all_courses'] = $this->user_course_model->select_assigned_tt_course_by_person_id($data['resource_person_info']->person_id, $data['resource_person_info']->resource_person_id, $course_category_id);
            }
        } else if ($data['person_info']->person_role == 4) {
            $data['resource_person_info'] = $this->profile_model->select_resource_person_info($data['person_info']->person_id);
            $data['all_courses'] = $this->user_course_model->select_categories_organization_course_by_organization_id($data['resource_person_info']->organization_id, $course_category_id);
        }
        echo $this->load->view('user/class/ajax_page/view_course', $data, true);
    }

    /**
     * @Function            : check_class_start_date_time 
     * @Used IN             : @function-'scedule_class.php' 
     * @Description         : check class start date time
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 12-03-2016 11:47 AM    
     * @Status              : available      
     * */
    function check_class_start_date_time() {
        $today = date('Y-m-d H:i', (time() - $this->session->userdata('time_offset')));
        $class_start_date_time1 = strtotime($this->input->post('class_start_date_time', TRUE));
        $class_start_date_time = date("Y-m-d H:i", $class_start_date_time1);
        if ($class_start_date_time >= $today) {
            echo 1;
        } else {
            echo 2;
        }
    }

    /**
     * @Function            : check_class_start_date_time1 
     * @Used IN             : @function-'scedule_class.php' 
     * @Description         : check class start date time in server validation
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 12-03-2016 12:29 AM    
     * @Status              : available      
     * */
    function check_class_start_date_time1($start_time) {
        $today = date('Y-m-d H:i', (time() - $this->session->userdata('time_offset')));
        $class_date = $this->input->post('class_date', TRUE);
        $class_date_time = $class_date . ' ' . date('H:i', strtotime($start_time));
        if ($class_date_time >= $today) {
            return TRUE;
        } else {
            $this->form_validation->set_message('check_class_start_date_time1', "Start time must grather than today");
            return FALSE;
        }
    }

    /**
     * @Function            : check_feature_status 
     * @Used IN             : @function-'schedule_class.php' 
     * @Description         : check feature status
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 07-03-2016 07:53 PM    
     * @Status              : available      
     * */
    function check_feature_status() {
        $person_id = $this->session->userdata('user_id');
        $data['feature_info'] = $this->super_admin_feature_model->check_course_feature_information($person_id);
        if ($data['feature_info']) {
            return TRUE;
        } else {
            $this->form_validation->set_message('check_feature_status', "Please update your account to create paid course");
            return FALSE;
        }
    }

    /**
     * @Function            : check_class_start_date 
     * @Used IN             : @function-'schedule_class.php' 
     * @Description         : check class start date
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 12-03-2016 08:32 PM    
     * @Status              : available      
     * */
    public function check_class_start_date($class_start_date, $virtual_classroom_per_day) {
        $person_id = $this->session->userdata('user_id');
        $schedule_person_id = $this->profile_model->get_person_id_by_person_information($person_id);
        $classroom_id = '';
        $date = new DateTime();
        $current_date = $date->format('Y-m-d');
        if ($current_date > $class_start_date) {
            $this->form_validation->set_message('check_class_start_date', "Class start date must grather than today");
            return FALSE;
        } else if ($virtual_classroom_per_day <= count($this->classroom_model->check_classroom_schedule_date($class_start_date, $schedule_person_id, $classroom_id))) {
            $this->form_validation->set_message('check_class_start_date', "You have already used maximum classroom in this day");
            return FALSE;
        } else {
            return TRUE;
        }
    }

    /**
     * @Function            : check_class_start_date_for_edit 
     * @Used IN             : @function-'edit_schedule_class.php' 
     * @Description         : check class start date for edit schedult class
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 14-03-2016 02:32 AM    
     * @Status              : available      
     * */
    function check_class_start_date_for_edit($class_start_date, $combine_variable) {
        $combine_variable_array = explode(',', $combine_variable);
        $virtual_classroom_per_day = $combine_variable_array[0];
        $classroom_id = $combine_variable_array[1];
        $person_id = $this->session->userdata('user_id');
        
        $schedule_person_id = $this->profile_model->get_person_id_by_person_information($person_id);
        $date = new DateTime();
        $current_date = $date->format('Y-m-d');
        if ($current_date > $class_start_date) {
            $this->form_validation->set_message('check_class_start_date', "Class start date must grather than today");
            return FALSE;
        } else if ($virtual_classroom_per_day <= count($this->classroom_model->check_classroom_schedule_date($class_start_date, $schedule_person_id, $classroom_id))) {
            $this->form_validation->set_message('check_class_start_date', "You have already used maximum classroom in this day");
            return FALSE;
        } else {
            return TRUE;
        }
    }

    /**
     * @Function            : check_class_duration 
     * @Used IN             : @function-'schedule_class.php' 
     * @Description         : check class duration
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 12-03-2016 08:38 PM    
     * @Status              : available      
     * */
    public function check_class_duration($duration, $virtual_classroom_number) {
        if (($duration < 30) || ($duration > 180)) {
            $this->form_validation->set_message('check_class_duration', "Class Duration range 30 min to 180 min");
            return FALSE;
        } else {
            $person_id = $this->session->userdata('user_id');
            $schedule_person_id = $this->profile_model->get_person_id_by_person_information($person_id);
            $classroom_id = '';
            $class_date = $this->input->post('class_date', TRUE);
            $class_start_time1 = $class_date . ' ' . date('H:i:s', strtotime($this->input->post('class_start_time', TRUE)));
            $class_end_time1 = strtotime($class_start_time1) + ($duration * 60);
            $class_start_time = date('Y-m-d H:i:s', strtotime("$class_start_time1"));
            $class_end_time = date('Y-m-d H:i:s', $class_end_time1);
            if (count($this->classroom_model->check_classroom_schedule($class_start_time, $class_end_time, $schedule_person_id, $classroom_id)) >= $virtual_classroom_number) {
                $this->form_validation->set_message('check_class_duration', "You have already used maximum classroom");
                return FALSE;
            } else {
                return TRUE;
            }
        }
    }

    /**
     * @Function            : check_class_duration_edit 
     * @Used IN             : @function-'edit-schedule_class.php' 
     * @Description         : check class duration
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 14-03-2016 02:35 PM    
     * @Status              : available      
     * */
    public function check_class_duration_edit($duration, $combine_variable) {
        $combine_variable_array = explode(',', $combine_variable);
        $virtual_classroom_number = $combine_variable_array[0];
        $classroom_id = $combine_variable_array[1];
        if (($duration < 30) || ($duration > 180)) {
            $this->form_validation->set_message('check_class_duration', "Class Duration range 30 min to 180 min");
            return FALSE;
        } else {
            $person_id = $this->session->userdata('user_id');
            $schedule_person_id = $this->profile_model->get_person_id_by_person_information($person_id);
            $class_date = $this->input->post('class_date', TRUE);
            $class_start_time1 = $class_date . ' ' . date('H:i:s', strtotime($this->input->post('class_start_time', TRUE)));
            $class_end_time1 = strtotime($class_start_time1) + ($duration * 60);
            $class_start_time = date('Y-m-d H:i:s', strtotime("$class_start_time1"));
            $class_end_time = date('Y-m-d H:i:s', $class_end_time1);
            if (count($this->classroom_model->check_classroom_schedule($class_start_time, $class_end_time, $schedule_person_id, $classroom_id)) >= $virtual_classroom_number) {
                $this->form_validation->set_message('check_class_duration', "You have already used maximum classroom");
                return FALSE;
            } else {
                return TRUE;
            }
        }
    }

    /**
     * @Function            : check_date_time_feature_status 
     * @Used IN             : @function-'schedule_class.php' 
     * @Description         : check date time into feature status
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 13-03-2016 02:16 PM    
     * @Status              : available      
     * */
    function check_date_time_feature_status() {
        $person_id = $this->session->userdata('user_id');
        $schedule_person_id = $this->profile_model->get_person_id_by_person_information($person_id);
        $class_date = $this->input->post('class_date', TRUE);
        $class_start_time1 = $class_date . ' ' . date('H:i:s', strtotime($this->input->post('start_time', TRUE)));
        $class_duration = $this->input->post('duration', true);
        $classroom_id = $this->input->post('classroom_id', true);
        $class_end_time1 = strtotime($class_start_time1) + ($class_duration * 60);
        $class_start_time = date('Y-m-d H:i:s', strtotime("$class_start_time1"));
        $class_end_time = date('Y-m-d H:i:s', $class_end_time1);
        echo count($this->classroom_model->check_classroom_schedule($class_start_time, $class_end_time, $schedule_person_id, $classroom_id));
    }

    /**
     * @Function            : check_classroom_start_date_with_feature 
     * @Used IN             : @function-'schedule_class.php' 
     * @Description         : check date into feature status
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 13-03-2016 02:55 PM    
     * @Status              : available      
     * */
    function check_classroom_start_date_with_feature() {
        $person_id = $this->session->userdata('user_id');
        $schedule_person_id = $this->profile_model->get_person_id_by_person_information($person_id);
        $start_date = $this->input->post('start_date', TRUE);
        $classroom_id = $this->input->post('classroom_id', TRUE);
        echo count($this->classroom_model->check_classroom_schedule_date($start_date, $schedule_person_id, $classroom_id));
    }

    /**
     * @Function            : schedule_review_and_publish 
     * @Used IN             : @function-'review_and_publish.php' 
     * @Description         : schedule class review and published
     * @Developed By        : Mahabub -A - Mawla
     * @Start DateTime      : Unknown
     * @Updated Date Time   : 13-02-2016 02:22 AM
     * @Updated By          : Ripon Jaherul      
     * @Status              : available      
     * */
    public function schedule_review_and_publish($url) {
        $data['active_menu'] = $this->session->userdata('active_menu');
        $data['active_sub_menu'] = $this->session->userdata('active_sub_menu');
        $data['active_sub_menu_item'] = $this->session->userdata('active_sub_menu_item');
        $data['tab'] = 'review_and_publish';
        $data['left_side_menu_view'] = 1;
        $data['left_side']=1;
        $data['classroom_info'] = $this->classroom_model->select_classroom_info_by_classroom_url($url);
        if (!$data['classroom_info']) {
            redirect();
        }
        $data['classroom_id'] = $data['classroom_info']->classroom_id;
        $data['course_id'] = $data['classroom_info']->course_id;
        $data['main_content'] = $this->load->view('user/class/review_and_publish', $data, true);
        $this->load->view('user/master', $data);
    }

    /**
     * @Function            : update_classroom_url_form 
     * @Used IN             : @function-'review_and_publish.php' 
     * @Description         : check class duration
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 13-03-2016 03:11 AM    
     * @Status              : available      
     * */
    function update_classroom_url_form() {
        $classroom_id = $this->input->post('classroom_id', TRUE);
        $data['classroom_info'] = $this->classroom_model->select_classroom_info_by_classroom_id($classroom_id);
        echo $this->load->view('user/class/ajax_page/add_classroom_url_form', $data, true);
    }

    /**
     * @Function            : check_classroom_url 
     * @Used IN             : @function-'review_and_publish.php' 
     * @Description         : check class duration
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 13-03-2016 04:15 AM    
     * @Status              : available      
     * */
    function check_classroom_url() {
        $new_classroom_url = $this->input->post('new_classroom_url', TRUE);
        echo $this->url_model->check_url_exists1($new_classroom_url);
    }

    /**
     * @Function            : save_update_classroom_url 
     * @Used IN             : @function-'review_and_publish.php' 
     * @Description         : check class duration
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 13-03-2016 09:25 AM    
     * @Status              : available      
     * */
    function save_update_classroom_url() {
        $new_classroom_url = $this->input->post('new_classroom_url', TRUE);
        $classroom_id = $this->input->post('classroom_id', TRUE);
        $data['classroom_info'] = $this->classroom_model->select_classroom_info_by_classroom_id($classroom_id);
        if ($new_classroom_url != $data['classroom_info']->url) {
            echo $this->url_model->update_classroom_url($data['classroom_info']->classroom_url_id, $new_classroom_url);
        } else {
            echo $data['classroom_info']->url;
        }
    }

    /**
     * @Function            : publish_class 
     * @Used IN             : @function-'review_and_publish.php' 
     * @Description         : check class duration
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 13-03-2016 10:57 AM    
     * @Status              : available      
     * */
    public function publish_class($url) {
        redirect('classroom/upcoming-class');
    }

    /**
     * @Function            : upcoming_class 
     * @Used IN             : @function-'classroom/upcomming_class.php' 
     * @Description         : view upcomming class
     * @Developed By        : Mahabub-A-Mawla
     * @Start DateTime      : Unknown 
     * @Updated Date Time   : 13-03-2016 11:05 AM
     * @Updated By          : Ripon Jaherul   
     * @Status              : available      
     * */
    public function upcoming_class($start = NULL) {
        $active_menu = $this->session->userdata('active_menu');
        if ($active_menu == 'organization') {
            $this->organization_upcoming_class($start);
        } else if ($active_menu == 'teacher') {
            $this->teacher_upcoming_class($start);
        } else if ($active_menu == 'learner') {
            $this->learner_upcoming_class($start);
        } else {
            redirect();
        }
    }

    /**
     * @Function            : organization_upcoming_class 
     * @Used IN             : @function-'classroom/upcomming_class.php' 
     * @Description         : view organization upcomming class
     * @Developed By        : Mahabub-A-Mawla
     * @Start DateTime      : Unknown 
     * @Updated Date Time   : 13-03-2016 07:08 PM
     * @Updated By          : Ripon Jaherul   
     * @Status              : available      
     * */
    public function organization_upcoming_class() {
   
        $data['left_side_menu_view'] = 1;
        $data['left_side']=1;
        $person_id = $this->session->userdata('user_id');
        $data['person_info'] = $this->profile_model->get_single_person_information_by_person_id($person_id);
        if ($data['person_info']->person_role != 4) {
            redirect();
        }

        $sdata = array();
        $data['active_menu'] = $sdata['active_menu'] = 'organization';
        $data['active_sub_menu'] = $sdata['active_sub_menu'] = 'organization_classroom';
        $data['active_sub_menu_item'] = $sdata['active_sub_menu_item'] = 'upcoming';
        $this->session->set_userdata($sdata);
        $data['start'] = $start = ($this->uri->segment(3)) ? $this->uri->segment(3) : 0;
        $data['limit'] = $limit = 5;

        $data['i'] = 0;
        $data['status'] = 1;
        $schedule_person_id = $this->profile_model->get_person_id_by_person_information($person_id);
        $todays_date = date('Y-m-d H:i', (time() - $this->session->userdata('time_offset')));
        $data['all_classes'] = $this->classroom_model->get_upcomming_classroom_by_person_id($schedule_person_id, $todays_date, '');
        if (!$data['all_classes']) {
            $data['classroom_status_message'] = 'You do not have any Upcoming class';
        } else {
            $data['classroom_status_message'] = '';
        }

        foreach ($data['all_classes'] as $class_value) {
            $data['course_info'][$class_value->classroom_id] = $this->user_course_model->select_course_information_by_course_id($class_value->course_id);
            $data['resource_person_info'][$class_value->classroom_id] = $this->profile_model->select_resource_person_info_by_resource_person_id($data['course_info'][$class_value->classroom_id]->resource_person_id);
            $data['organization_info'][$class_value->classroom_id] = $this->profile_model->select_organization_info_by_organization_id($data['resource_person_info'][$class_value->classroom_id]->organization_id);
        }

        $data['main_content'] = $this->load->view('user/class/my_classes', $data, true);
        $this->load->view('user/master', $data);
    }

    /**
     * @Function            : teacher_upcoming_class 
     * @Used IN             : @function-'classroom/teacher_upcomming_class.php' 
     * @Description         : view teacher upcomming class
     * @Developed By        : Mahabub-A-Mawla
     * @Start DateTime      : Unknown 
     * @Updated Date Time   : 14-03-2016 01:25 PM
     * @Updated By          : Ripon Jaherul   
     * @Status              : available      
     * */
    public function teacher_upcoming_class() {
        $person_id = $this->session->userdata('user_id');
        $data['person_info'] = $this->profile_model->get_single_person_information_by_person_id($person_id);
        if ($data['person_info']->person_role != 3) {
            redirect();
        }

        $sdata = array();
        $data['active_menu'] = $sdata['active_menu'] = 'teacher';
        $data['active_sub_menu'] = $sdata['active_sub_menu'] = 'teacher_classroom';
        $data['active_sub_menu_item'] = $sdata['active_sub_menu_item'] = 'upcoming';
        $this->session->set_userdata($sdata);
        $data['left_side_menu_view'] = 1;
        $data['left_side']=1;
        $data['start'] = $start = ($this->uri->segment(3)) ? $this->uri->segment(3) : 0;
        $data['limit'] = $limit = 5;

        if ($data['person_info']->person_role == 3) {
            $resource_person_info = $this->profile_model->select_resource_person_info($data['person_info']->person_id);
        }

        $data['i'] = 0;
        $data['status'] = 1;
        $today = date('Y-m-d H:i', (time() - $this->session->userdata('time_offset')));
        $data['all_classes'] = $this->classroom_model->get_upcomming_classroom_by_person_id($person_id, $today, $resource_person_info->resource_person_id);
        if (!$data['all_classes']) {
            $data['classroom_status_message'] = 'You do not have any Upcoming class';
        } else {
            $data['classroom_status_message'] = '';
        }

        foreach ($data['all_classes'] as $class_value) {
            $data['course_info'][$class_value->classroom_id] = $this->user_course_model->select_course_information_by_course_id($class_value->course_id);
            $data['resource_person_info'][$class_value->classroom_id] = $this->profile_model->select_resource_person_info_by_resource_person_id($data['course_info'][$class_value->classroom_id]->resource_person_id);
            if ($data['resource_person_info'][$class_value->classroom_id]->resource_person_type == 3) {
                $data['organization_info'][$class_value->classroom_id] = $this->profile_model->select_organization_info_by_organization_id($data['resource_person_info'][$class_value->classroom_id]->organization_id);
            }
        }
        $data['main_content'] = $this->load->view('user/class/my_classes', $data, true);
        $this->load->view('user/master', $data);
    }

    /**
     * @Function            : learner_upcoming_class 
     * @Used IN             : @function-'classroom/teacher_upcomming_class.php' 
     * @Description         : view learner upcomming class
     * @Developed By        : Mahabub-A-Mawla
     * @Start DateTime      : Unknown 
     * @Updated Date Time   : 18-03-2016 05:57 PM
     * @Updated By          : Ripon Jaherul   
     * @Status              : available      
     * */
    public function learner_upcoming_class() {
        $sdata = array();
        $data['active_menu'] = $sdata['active_menu'] = 'learner';
        $data['active_sub_menu'] = $sdata['active_sub_menu'] = 'learner_classroom';
        $data['active_sub_menu_item'] = $sdata['active_sub_menu_item'] = 'upcoming';
        $data['left_side_menu_view'] = 1;
        $data['left_side']=1;
        $this->session->set_userdata($sdata);
        $data['start'] = $start = ($this->uri->segment(3)) ? $this->uri->segment(3) : 0;
        $data['limit'] = $limit = 5;

        $person_id = $this->session->userdata('user_id');
        $data['person_info'] = $this->profile_model->get_single_person_information_by_person_id($person_id);

        $data['i'] = 0;
        $data['status'] = 1;
        $today = date('Y-m-d H:i', (time() - $this->session->userdata('time_offset')));
        $data['all_classes'] = $this->classroom_model->get_learner_upcomming_classroom_by_person_id($person_id, $today);
        if ($data['all_classes']) {
            $data['classroom_status_message'] = '';
        } else {
            $data['classroom_status_message'] = 'You do not have any Upcoming class';
        }

        foreach ($data['all_classes'] as $class_value) {
            $data['course_info'][$class_value->classroom_id] = $this->user_course_model->select_course_information_by_course_id($class_value->course_id);
            $data['resource_person_info'][$class_value->classroom_id] = $this->profile_model->select_resource_person_info_by_resource_person_id($data['course_info'][$class_value->classroom_id]->resource_person_id);
            if ($data['resource_person_info'][$class_value->classroom_id]->resource_person_type == 3) {
                $data['organization_info'][$class_value->classroom_id] = $this->profile_model->select_organization_info_by_organization_id($data['resource_person_info'][$class_value->classroom_id]->organization_id);
            }
        }

        $data['main_content'] = $this->load->view('user/class/my_classes_as_learner', $data, true);
        $this->load->view('user/master', $data);
    }

    /**
     * @Function            : check_classroom_action 
     * @Used IN             : @function-'classroom/my_classs.php' 
     * @Description         : check classroom action
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 14-03-2016 12:20 PM   
     * @Status              : available      
     * */
    public function check_classroom_action() {
        $status = $this->input->post('status', TRUE);
        $classroom_id = $this->input->post('classroom_id', TRUE);
        if ($status == 'Delete') {
            $data['classroom_status'] = 6;
            $this->user_course_model->update_information_in_database('tbl_classroom', 'classroom_id', $classroom_id, $data);
        } else if ($status == 'Cancel') {
            $data['classroom_status'] = 5;
            $this->user_course_model->update_information_in_database('tbl_classroom', 'classroom_id', $classroom_id, $data);
        }
        echo 'success';
    }

    /**
     * @Function            : check_learner_classroom_action 
     * @Used IN             : @function-'classroom/my_classs_as_learner.php' 
     * @Description         : check classroom action
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 19-03-2016 12:20 PM   
     * @Status              : available      
     * */
    function check_learner_classroom_action() {
        $classroom_student_id = $this->input->post('classroom_student_id', TRUE);
        $this->user_course_model->delete_information_in_database('tbl_classroom_student', 'classroom_student_id', $classroom_student_id);
        echo 'success';
    }

    /**
     * @Function            : current_class 
     * @Used IN             : @function-'courrent_class_view 
     * @Description         : view teacher upcomming class
     * @Developed By        : Mahabub-A-Mawla
     * @Start DateTime      : Unknown 
     * @Status              : available      
     * */
    public function current_class($start = NULL) {
        $active_menu = $this->session->userdata('active_menu');
        if ($active_menu == 'organization') {
            $this->organization_current_class($start);
        }
        if ($active_menu == 'teacher') {
            $this->teacher_current_class($start);
        }
        if ($active_menu == 'learner') {
            $this->learner_current_class($start);
        }
    }

    /**
     * @Function            : organization_current_class 
     * @Used IN             : @function-'classroom/my_classs.php'  
     * @Description         : view teacher current class
     * @Developed By        : Mahabub-A-Mawla
     * @Start DateTime      : Unknown 
     * @Updated Date Time   : 14-03-2016 04:58 PM
     * @Updated By          : Ripon Jaherul   
     * @Status              : available      
     * */
    public function organization_current_class($start = NULL) {
        
        $person_id = $this->session->userdata('user_id');
        $data['person_info'] = $this->profile_model->get_single_person_information_by_person_id($person_id);
        if ($data['person_info']->person_role != 4) {
            redirect();
        }
        $data['left_side_menu_view'] = 1;
        $data['left_side']=1;
        $data['active_menu'] = $this->session->userdata('active_menu');
        $data['active_sub_menu'] = $this->session->userdata('active_sub_menu');
        $data['active_sub_menu_item'] = $sdata['active_sub_menu_item'] = 'current';
        $this->session->set_userdata($sdata);
        $data['start'] = $start = ($this->uri->segment(3)) ? $this->uri->segment(3) : 0;
        $data['limit'] = $limit = 5;

        $data['i'] = 0;
        $data['status'] = 2;
        $schedule_person_id = $this->profile_model->get_person_id_by_person_information($person_id);
        $todays_date = date('Y-m-d H:i', (time() - $this->session->userdata('time_offset')));
        $data['all_classes'] = $this->classroom_model->get_current_classroom_by_person_id($schedule_person_id, $todays_date,'');
        if (!$data['all_classes']) {
            $data['classroom_status_message'] = 'You do not have any Upcoming class';
        } else {
            $data['classroom_status_message'] = '';
        }

        foreach ($data['all_classes'] as $class_value) {
            $data['course_info'][$class_value->classroom_id] = $this->user_course_model->select_course_information_by_course_id($class_value->course_id);
            $data['resource_person_info'][$class_value->classroom_id] = $this->profile_model->select_resource_person_info_by_resource_person_id($data['course_info'][$class_value->classroom_id]->resource_person_id);
            $data['organization_info'][$class_value->classroom_id] = $this->profile_model->select_organization_info_by_organization_id($data['resource_person_info'][$class_value->classroom_id]->organization_id);
        }

        $data['main_content'] = $this->load->view('user/class/my_classes', $data, true);
        $this->load->view('user/master', $data);
    }

    /**
     * @Function            : teacher_current_class 
     * @Used IN             : @function-'classroom/my_classs.php'  
     * @Description         : view teacher current class
     * @Developed By        : Mahabub-A-Mawla
     * @Start DateTime      : Unknown 
     * @Updated Date Time   : 14-03-2016 04:33 PM
     * @Updated By          : Ripon Jaherul   
     * @Status              : available      
     * */
    public function teacher_current_class() {
        $person_id = $this->session->userdata('user_id');
        $data['person_info'] = $this->profile_model->get_single_person_information_by_person_id($person_id);
        if ($data['person_info']->person_role != 3) {
            redirect();
        }
        $data['left_side_menu_view'] = 1;
        $data['left_side']=1;
        $data['active_menu'] = $this->session->userdata('active_menu');
        $data['active_sub_menu'] = $this->session->userdata('active_sub_menu');
        $data['active_sub_menu_item'] = $sdata['active_sub_menu_item'] = 'current';
        $this->session->set_userdata($sdata);
        $data['start'] = $start = ($this->uri->segment(3)) ? $this->uri->segment(3) : 0;
        $data['limit'] = $limit = 5;

        if ($data['person_info']->person_role == 3) {
            $resource_person_info = $this->profile_model->select_resource_person_info($data['person_info']->person_id);
        }

        $data['i'] = 0;
        $data['status'] = 2;
        $today = date('Y-m-d H:i', (time() - $this->session->userdata('time_offset')));
        $data['all_classes'] = $this->classroom_model->get_current_classroom_by_person_id($person_id, $today, $resource_person_info->resource_person_id);
        if (!$data['all_classes']) {
            $data['classroom_status_message'] = 'You do not have any Current class';
        } else {
            $data['classroom_status_message'] = '';
        }

        foreach ($data['all_classes'] as $class_value) {
            $data['course_info'][$class_value->classroom_id] = $this->user_course_model->select_course_information_by_course_id($class_value->course_id);
            $data['resource_person_info'][$class_value->classroom_id] = $this->profile_model->select_resource_person_info_by_resource_person_id($data['course_info'][$class_value->classroom_id]->resource_person_id);
            if ($data['resource_person_info'][$class_value->classroom_id]->resource_person_type == 3) {
                $data['organization_info'][$class_value->classroom_id] = $this->profile_model->select_organization_info_by_organization_id($data['resource_person_info'][$class_value->classroom_id]->organization_id);
            }
        }

        $data['main_content'] = $this->load->view('user/class/my_classes', $data, true);
        $this->load->view('user/master', $data);
    }

    /**
     * @Function            : learner_current_class 
     * @Used IN             : @function-'classroom/my_class_as_learner.php'  
     * @Description         : view learner current class
     * @Developed By        : Mahabub-A-Mawla
     * @Start DateTime      : Unknown 
     * @Updated Date Time   : 18-03-2016 07:56 PM
     * @Updated By          : Ripon Jaherul   
     * @Status              : available      
     * */
    public function learner_current_class() {
        $data['active_menu'] = $this->session->userdata('active_menu');
        $data['active_sub_menu'] = $this->session->userdata('active_sub_menu');
        $data['active_sub_menu_item'] = $sdata['active_sub_menu_item'] = 'current';
        $this->session->set_userdata($sdata);
        $data['left_side_menu_view'] = 1;
        $data['left_side']=1;
        $data['start'] = $start = ($this->uri->segment(3)) ? $this->uri->segment(3) : 0;
        $data['limit'] = $limit = 5;

        $person_id = $this->session->userdata('user_id');
        $data['person_info'] = $this->profile_model->get_single_person_information_by_person_id($person_id);

        $data['i'] = 0;
        $data['status'] = 2;
        $today = date('Y-m-d H:i', (time() - $this->session->userdata('time_offset')));
        $data['all_classes'] = $this->classroom_model->get_learner_current_classroom_by_person_id($person_id, $today);
        if ($data['all_classes']) {
            $data['classroom_status_message'] = '';
        } else {
            $data['classroom_status_message'] = 'You do not have any Current class';
        }

        foreach ($data['all_classes'] as $class_value) {
            $data['course_info'][$class_value->classroom_id] = $this->user_course_model->select_course_information_by_course_id($class_value->course_id);
            $data['resource_person_info'][$class_value->classroom_id] = $this->profile_model->select_resource_person_info_by_resource_person_id($data['course_info'][$class_value->classroom_id]->resource_person_id);
            if ($data['resource_person_info'][$class_value->classroom_id]->resource_person_type == 3) {
                $data['organization_info'][$class_value->classroom_id] = $this->profile_model->select_organization_info_by_organization_id($data['resource_person_info'][$class_value->classroom_id]->organization_id);
            }
        }

        $data['main_content'] = $this->load->view('user/class/my_classes_as_learner', $data, true);
        $this->load->view('user/master', $data);
    }

    /**
     * @Function            : previous_class 
     * @Used IN             : @function-'courrent_class_view 
     * @Description         : view teacher upcomming class
     * @Developed By        : Mahabub-A-Mawla
     * @Start DateTime      : Unknown 
     * @Status              : available      
     * */
    public function previous_class($start = NULL) {
        $active_menu = $this->session->userdata('active_menu');
        if ($active_menu == 'organization') {
            $this->organization_previous_class($start);
        } else if ($active_menu == 'teacher') {
            $this->teacher_previous_class($start);
        } else if ($active_menu == 'learner') {
            $this->learner_previous_class($start);
        } else {
            redirect();
        }
    }

    /**
     * @Function            : organization_previous_class 
     * @Used IN             : @function-'classroom/my_classs.php'  
     * @Description         : view organization previous class
     * @Developed By        : Mahabub-A-Mawla
     * @Start DateTime      : Unknown 
     * @Updated Date Time   : 14-03-2016 05:06 PM
     * @Updated By          : Ripon Jaherul   
     * @Status              : available      
     * */
    public function organization_previous_class($start = NULL) {
        $person_id = $this->session->userdata('user_id');
        $data['person_info'] = $this->profile_model->get_single_person_information_by_person_id($person_id);
        if ($data['person_info']->person_role != 4) {
            redirect();
        }
        $data['active_menu'] = $this->session->userdata('active_menu');
        $data['active_sub_menu'] = $this->session->userdata('active_sub_menu');
        $data['active_sub_menu_item'] = $sdata['active_sub_menu_item'] = 'previous';
        $this->session->set_userdata($sdata);
        $data['left_side']=1;
        $data['left_side_menu_view'] = 1;
        $data['start'] = $start = ($this->uri->segment(3)) ? $this->uri->segment(3) : 0;
        $data['limit'] = $limit = 5;

        $data['i'] = 0;
        $data['status'] = 3;
        $schedule_person_id = $this->profile_model->get_person_id_by_person_information($person_id);
        $todays_date = date('Y-m-d H:i', (time() - $this->session->userdata('time_offset')));
        $data['all_classes'] = $this->classroom_model->get_previous_classroom_by_person_id($schedule_person_id, $todays_date,'');
        if (!$data['all_classes']) {
            $data['classroom_status_message'] = 'You do not have any Previous class';
        } else {
            $data['classroom_status_message'] = '';
        }

        foreach ($data['all_classes'] as $class_value) {
            $data['course_info'][$class_value->classroom_id] = $this->user_course_model->select_course_information_by_course_id($class_value->course_id);
            $data['resource_person_info'][$class_value->classroom_id] = $this->profile_model->select_resource_person_info_by_resource_person_id($data['course_info'][$class_value->classroom_id]->resource_person_id);
            $data['organization_info'][$class_value->classroom_id] = $this->profile_model->select_organization_info_by_organization_id($data['resource_person_info'][$class_value->classroom_id]->organization_id);
        }

        $data['main_content'] = $this->load->view('user/class/my_classes', $data, true);
        $this->load->view('user/master', $data);
    }

    /**
     * @Function            : teacher_previous_class 
     * @Used IN             : @function-'classroom/my_classs.php'  
     * @Description         : view teacher previous class
     * @Developed By        : Mahabub-A-Mawla
     * @Start DateTime      : Unknown 
     * @Updated Date Time   : 14-03-2016 05:18 PM
     * @Updated By          : Ripon Jaherul   
     * @Status              : available      
     * */
    public function teacher_previous_class() {
       $person_id = $this->session->userdata('user_id');
        $data['person_info'] = $this->profile_model->get_single_person_information_by_person_id($person_id);
        if ($data['person_info']->person_role != 3) {
            redirect();
        }
        $data['active_menu'] = $this->session->userdata('active_menu');
        $data['active_sub_menu'] = $this->session->userdata('active_sub_menu');
        $data['active_sub_menu_item'] = $sdata['active_sub_menu_item'] = 'previous';
        $this->session->set_userdata($sdata);
        $data['left_side']=1;
        $data['left_side_menu_view'] = 1;
        $data['start'] = $start = ($this->uri->segment(3)) ? $this->uri->segment(3) : 0;
        $data['limit'] = $limit = 5;

        if ($data['person_info']->person_role == 3) {
            $resource_person_info = $this->profile_model->select_resource_person_info($data['person_info']->person_id);
        }

        $data['i'] = 0;
        $data['status'] = 3;
        $todays_date = date('Y-m-d H:i', (time() - $this->session->userdata('time_offset')));
        $data['all_classes'] = $this->classroom_model->get_previous_classroom_by_person_id($person_id, $todays_date, $resource_person_info->resource_person_id);
        if (!$data['all_classes']) {
            $data['classroom_status_message'] = 'You do not have any Previous class';
        } else {
            $data['classroom_status_message'] = '';
        }

        foreach ($data['all_classes'] as $class_value) {
            $data['course_info'][$class_value->classroom_id] = $this->user_course_model->select_course_information_by_course_id($class_value->course_id);
            $data['resource_person_info'][$class_value->classroom_id] = $this->profile_model->select_resource_person_info_by_resource_person_id($data['course_info'][$class_value->classroom_id]->resource_person_id);
            $data['organization_info'][$class_value->classroom_id] = $this->profile_model->select_organization_info_by_organization_id($data['resource_person_info'][$class_value->classroom_id]->organization_id);
        }

        $data['main_content'] = $this->load->view('user/class/my_classes', $data, true);
        $this->load->view('user/master', $data);
    }

    /**
     * @Function            : learner_previous_class 
     * @Used IN             : @function-'classroom/my_class_as_learner.php' 
     * @Description         : view learner previous class
     * @Developed By        : Mahabub-A-Mawla
     * @Start DateTime      : Unknown 
     * @Updated Date Time   : 18-03-2016 08:12 PM
     * @Updated By          : Ripon Jaherul   
     * @Status              : available      
     * */
    public function learner_previous_class() {
        $data['active_menu'] = $this->session->userdata('active_menu');
        $data['active_sub_menu'] = $this->session->userdata('active_sub_menu');
        $data['active_sub_menu_item'] = $sdata['active_sub_menu_item'] = 'previous';
        $this->session->set_userdata($sdata);
        $data['start'] = $start = ($this->uri->segment(3)) ? $this->uri->segment(3) : 0;
        $data['limit'] = $limit = 5;
        $data['left_side']=1;
        $data['left_side_menu_view'] = 1;
        $person_id = $this->session->userdata('user_id');
        $data['person_info'] = $this->profile_model->get_single_person_information_by_person_id($person_id);

        $data['i'] = 0;
        $data['status'] = 3;
        $today = date('Y-m-d H:i', (time() - $this->session->userdata('time_offset')));
        $data['all_classes'] = $this->classroom_model->get_learner_previous_classroom_by_person_id($person_id, $today);
        if ($data['all_classes']) {
            $data['classroom_status_message'] = '';
        } else {
            $data['classroom_status_message'] = 'You do not have any Previous class';
        }

        foreach ($data['all_classes'] as $class_value) {
            $data['course_info'][$class_value->classroom_id] = $this->user_course_model->select_course_information_by_course_id($class_value->course_id);
            $data['resource_person_info'][$class_value->classroom_id] = $this->profile_model->select_resource_person_info_by_resource_person_id($data['course_info'][$class_value->classroom_id]->resource_person_id);
            if ($data['resource_person_info'][$class_value->classroom_id]->resource_person_type == 3) {
                $data['organization_info'][$class_value->classroom_id] = $this->profile_model->select_organization_info_by_organization_id($data['resource_person_info'][$class_value->classroom_id]->organization_id);
            }
        }
        $data['main_content'] = $this->load->view('user/class/my_classes_as_learner', $data, true);
        $this->load->view('user/master', $data);
    }

    /**
     * @Function            : course_student_list 
     * @Used IN             : @function-'classroom/my_classs.php'  
     * @Description         : view registrad student list
     * @Developed By        : Mahabub-A-Mawla
     * @Start DateTime      : Unknown 
     * @Updated Date Time   : 15-03-2016 05:21 PM
     * @Updated By          : Ripon Jaherul   
     * @Status              : available      
     * */
    public function course_student_list($classroom_url) {
        $data = array();
        $data['active_menu'] = $this->session->userdata('active_menu');
        $data['active_sub_menu'] = $this->session->userdata('active_sub_menu');
        $data['active_sub_menu_item'] = $sdata['active_sub_menu_item'] = 'Course';
        $data['left_side']=1;
        $data['left_side_menu_view'] = 1;
        $this->session->set_userdata($sdata);
        $data['tab'] = 'course_profile';
        $data['left_content'] = $this->load->view('user/side_menu', $data, TRUE);

        $person_id = $this->session->userdata('user_id');
        $data['person_info'] = $this->profile_model->get_single_person_information_by_person_id($person_id);
        $data['classroom_info'] = $this->classroom_model->select_classroom_info_by_classroom_url($classroom_url);
        $data['course_registered_student'] = $this->user_course_model->select_course_registered_student_by_course_id($data['classroom_info']->course_id);
        foreach ($data['course_registered_student'] as $student_value) {
            $data['assign_student_info'][$student_value->student_id] = $this->classroom_model->assign_student_info_student_id($data['classroom_info']->classroom_id, $student_value->student_id);
        }

        $data['main_content'] = $this->load->view('user/class/course_registered_student', $data, true);
        $this->load->view('user/master', $data);
    }

    /**
     * @Function            : change_student_permission 
     * @Used IN             : @function-'course_registrad_student.php'  
     * @Description         : change permission in course registrad student
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 17-03-2016 05:21 PM   
     * @Status              : available      
     * */
    function change_student_permission() {
        $person_id = $this->session->userdata('user_id');
        $total_class = 0;
        $type = $this->input->post('type', TRUE);
        $csData['classroom_id'] = $this->input->post('classroom_id', TRUE);
        $feature_info = $this->super_admin_feature_model->check_course_feature_information($person_id);
        $assigned_student_info = count($this->classroom_model->get_all_assigned_student_by_classroom_id($csData['classroom_id']));

        if ($feature_info->virtual_classroom_attendees_number > $assigned_student_info) {
            $data['classroom_info'] = $this->classroom_model->select_classroom_info_by_classroom_id($csData['classroom_id']);
            $csData['student_id'] = $this->input->post('student_id', TRUE);
            $data['student_info'] = $this->classroom_model->get_student_information_student_id($csData['student_id']);
            $all_student_id = $this->classroom_model->get_all_student_id_by_person_id($data['student_info']->person_id);
            if ($all_student_id->student_id_string != '') {
                $all_classroom_id = $this->classroom_model->get_all_classroom_id_by_multiple_student_id($all_student_id->student_id_string);
                if ($all_classroom_id->classroom_id_string != '') {
                    $total_class = count($this->classroom_model->get_remaining_classroom_by_classroom_id_with_date($all_classroom_id->classroom_id_string, $data['classroom_info']->class_start_time, $data['classroom_info']->class_end_time));
                }
            }
            if ($type == 'Assign') {
                if ($total_class < 1) {
                    $csData['attendance_time'] = date('Y-m-d H:i:s', (time() - $this->session->userdata('time_offset')));
                    $csData['classroom_student_join_status'] = 6;
                    $this->user_course_model->save_information_in_database('tbl_classroom_student', $csData);
                    $data['assigned_student_info'] = $this->classroom_model->get_assigned_student_information_student_id($csData['student_id']);
                    echo $this->load->view('user/course/ajax_page/student_list_action', $data, true);
                } else {
                    echo 2;
                }
            } else if ($type == 'Unassign') {
                $this->classroom_model->remove_assigned_student($csData['classroom_id'], $csData['student_id']);
                $data['assigned_student_info'] = $this->classroom_model->get_assigned_student_information_student_id($csData['student_id']);
                echo $this->load->view('user/course/ajax_page/student_list_action', $data, true);
            }
        } else {
            echo 3;
        }
    }

    public function assigned_student($classroom_url) {
        $data = array();
        $person_id = $this->session->userdata('user_id');
        $data['active_menu'] = $this->session->userdata('active_menu');
        $data['active_sub_menu'] = $this->session->userdata('active_sub_menu');
        $data['active_sub_menu_item'] = $sdata['active_sub_menu_item'] = 'Course';
        $this->session->set_userdata($sdata);
        $data['left_side_menu_view'] = 1;
        $data['left_side']=1;
        $data['tab'] = 'course_profile';
        $data['left_content'] = $this->load->view('user/side_menu', $data, TRUE);
        $data['person_info'] = $this->profile_model->person_info_by_person_id($person_id);
        $feature_price_id = explode(',', $data['person_info']->feature_price_id);
        $data['virtual_classroom_feature_info'] = $this->classroom_model->select_active_feature_by_feature_id($feature_price_id[0]);
        if ($data['virtual_classroom_feature_info']) {
            $data['virtual_classroom_number'] = $data['virtual_classroom_feature_info']->virtual_classroom_number;
            $data['virtual_classroom_attendees_number'] = $data['virtual_classroom_feature_info']->virtual_classroom_attendees_number;
            $data['virtual_classroom_type'] = $data['virtual_classroom_feature_info']->virtual_classroom_type;
        }

        $data['classroom_info'] = $this->classroom_model->select_classroom_info_for_all_status($classroom_url);
        $data['course_info'] = $this->user_course_model->select_course_info_by_id($data['classroom_info']->course_id);
        $course_creator_info = $this->profile_model->person_info_by_person_id($data['course_info']->person_id);
        $course_url = $data['course_info']->url;
        $data['course_id'] = $course_id = $data['course_info']->course_id;
        if (!$data['course_info']) {
            $sdata = array();
            $sdata['message'] = 'This Course Informationis not Found';
            $this->session->set_userdata($sdata);
            redirect('course/' . $this->session->userdata('active_menu'));
        }
        if ($data['person_info']->resource_person_id != $data['course_info']->resource_person_id) {
            if ($data['person_info']->person_id != $data['course_info']->person_id) {
                $organization_owner_information = $this->profile_model->person_info_by_organization_id($course_creator_info->organization_id);
                if ($organization_owner_information->person_id != $data['person_info']->person_id) {
                    redirect('course/' . $this->session->userdata('active_menu'));
                }
            }
        }

        $data['assign'] = TRUE;
        $data['student'] = $this->classroom_model->select_assigned_student($data['classroom_info']->classroom_id);
        foreach ($data['student'] as $value) {
            $data['student_payment_info'][$value->student_id] = $this->payment_model->payment_info_by_payment_id($value->payment_id);
            $data['student_status'][$value->student_id] = $this->classroom_model->select_assigned_student_by_student_id($value->student_id, $data['classroom_info']->classroom_id);
        }

        $data['main_content'] = $this->load->view('user/class/classroom_assigned_student', $data, true);
        $this->load->view('user/master', $data);
    }

    /*
      -----------@@@RIPON@ End ClassRoom Part----------------------------------
     */
}
