<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Batch extends TT_user_login {

    public function __construct() {
        parent::__construct();
    }

    /* --------------------------------------- add batch  tania ----------------------------------------------------- */
    /*
     * Function         : create_teacher_batch
     * Used IN          : $route['teacher/add-batch'] = "batch/create_teacher_batch";  line--1206
     * Description      : used to create batch by teacher
     * Parameter        : none
     * return           : none
     * redirect         : none
     * Developed By     : Unknown
     * Update By        : Tania Akter
     * Date             : 15-06-2016
     */

    function create_teacher_batch() {
        $sdata = array();
        $sdata['active_menu'] = 'teacher';
        $sdata['active_sub_menu'] = 'teacher_batch';
        $this->session->set_userdata($sdata);
        $this->create_batch();
    }

    /*
     * Function         : create_organization_batch
     * Used IN          : $route['organization/add-batch'] = "batch/create_organization_batch";   line --1207
     * Description      : used to create batch by org
     * Parameter        : none
     * return           : none
     * redirect         : none
     * Developed By     : unknown
     * Updated By       : Tania Akter
     * Date             : 15-06-2016
     */

    function create_organization_batch() {
        $sdata = array();
        $sdata['active_menu'] = 'organization';
        $sdata['active_sub_menu'] = 'organization_batch';
        $this->session->set_userdata($sdata);
        $this->create_batch();
    }

////super_created_batch   //tania  13-06-2016 

    /*
     * Function         : create_batch
     * Used IN          : function [create_teacher_batch] controller[batch], function[create_organization_batch] controller[batch]
     * Description      : used to create batch
     * Parameter        : none
     * return           : none
     * view             : user/batch/create_batch
     * redirect         : redirect('batch/' . $this->session->userdata('active_menu')) (batch/organization, batch/teacher)
     * Developed By     : Tania Akter
     * Date             : 
     */
    function create_batch() {
        $person_id = $this->session->userdata('user_id');
        $data = $this->view_for_right_side_menu();     //for right side menu
        $this->add_batch_form_validation();            //used for form validation
        $data['person_info'] = $this->person_model->get_single_person_information_by_person_id($person_id);    //person_info
        $data['courses'] = $this->batch_model->select_all_active_courses($data['person_info']); //course_info
        if ($this->form_validation->run() == FALSE) {
            $data['main_content'] = $this->load->view('user/batch/create_batch', $data, true);
            $this->load->view('user/master', $data);
        } else {
            $this->batch_model->save_course_batch_information();
            redirect('batch/' . $this->session->userdata('active_menu'));
        }
    }

    /*
     * Function         : view_for_right_side_menu
     * Used IN          : function[create_batch]controller[batch]
     * Description      : for view right side menu
     * Parameter        : none
     * return           : $data(contain right side menu )
     * redirect         : none
     * Developed By     : Tania Akter
     * Date             : 
     */

    function view_for_right_side_menu() {
        $data = array();
        $data['active_menu'] = $this->session->userdata('active_menu');
        $data['active_sub_menu'] = $this->session->userdata('active_sub_menu');
        $data['left_side_menu_view'] = 1;
        $data['left_side'] = 1;
        return $data;
    }

    /*
     * Function         : add_batch_form_validation
     * Used IN          : function[create_batch]controller[batch]
     * Description      : used to add batch form validation
     * Parameter        : none
     * return           : none
     * redirect         : none
     * view             : none
     * Developed By     : Tania Akter
     * Date             : 
     */

    function add_batch_form_validation() {
        $this->form_validation->set_rules('course_batch_name', 'Batch name', 'required|trim|max_length[50]');
        $this->form_validation->set_rules('course', 'course information', 'required|callback_select_course');
        $this->form_validation->set_rules('course_batch_start_date', 'Course batch start date', 'required|trim');
        $this->form_validation->set_rules('course_batch_finish_date', 'Course batch finish date', 'required|trim');
    }

    /*
     * Function         : select_course
     * Used IN          : function[add_batch_form_validation] controller[batch]
     * Description      : used to select course validation
     * Parameter        : $course
     * return           : true, false(validation message)
     * redirect         : none
     * view             : none
     * Developed By     : Tania Akter
     * Date             : 
     */

    function select_course($course) {
        if ($course == '') {
            $this->form_validation->set_message('select_course', "<span style=color:red>Please select course</span>");
            return FALSE;
        } else {
            return TRUE;
        }
    }

    /*
     * Function         : batch_course_info
     * Used IN          : user/batch/create_batch , user/batch/edit_batch, $route['batch-course-info'] = "batch/batch_course_info";  
     * Description      : get batch course information
     * Parameter        : none
     * return           : none
     * redirect         : none
     * view             : user/batch/ajax_page/ajax_batch_course_info
     * Developed By     : Tania Akter
     * Date             : 15-06-2016
     */

    function batch_course_info() {
        $course_id = $this->input->post('course_id', TRUE);
        $data['course_info'] = $this->batch_model->select_course_info_by_course_id($course_id);
        echo $this->load->view('user/batch/ajax_page/ajax_batch_course_info', $data, TRUE);
    }

    /*
     * Function         : manage_organization_batch
     * Used IN          : user/side_menu
     * Description      : used to view organization batch
     * Parameter        : none
     * return           : none
     * redirect         : none
     * view             : user/batch/view_course_batch
     * Developed By     : Tania Akter
     * Date             : 
     */

    function manage_organization_batch() {
        $person_id = $this->session->userdata('user_id');
        $data = array();
        $data['active_menu'] = 'organization';
        $data['active_sub_menu'] = 'organization_batch';
        $data['left_side_menu_view'] = 1;
        $data['left_side'] = 1;
        $data['course_value_for_search'] = 3;       //search batch in header menu
        $this->auto_update_course_batch_type(); //used to update course batch type
        $data['total_created_batch'] = $this->batch_model->get_total_batch_status($person_id, 4); //4= create
        $data['total_running_batch'] = $this->batch_model->get_total_batch_status($person_id, 1); //1= running
        $data['total_finished_batch'] = $this->batch_model->get_total_batch_status($person_id, 2); //2= finished
        $data['total_cancel_batch'] = $this->batch_model->get_total_batch_status($person_id, 3); //3=cancel
        $data['page'] = 1;
        $data['batch_tab'] = $this->get_batch_tab();
        $data['created_batch_info'] = $this->batch_model->get_batch_info($person_id, 4); //4= create batch
        foreach ($data['created_batch_info'] as $created_batch) {
            $data['course_registrated_student'][$created_batch->course_id] = $this->batch_model->get_course_registarted_student($created_batch->course_id);
            $data['batch_created_by'][$created_batch->person_id] = $this->person_model->get_single_person_information_by_person_id($created_batch->person_id);
            $data['batch_resource_person'][$created_batch->resource_person_id] = $this->batch_model->get_resource_person_info($created_batch->resource_person_id);
            $data['student_number_in_batch'][$created_batch->course_batch_id] = $this->batch_model->count_number_of_student_in_batch($created_batch->course_batch_id);
        }

        // running batch
        $data['running_batch_info'] = $this->batch_model->get_batch_info($person_id, 1);   //1= running batch     
        foreach ($data['running_batch_info'] as $running_batch) {
            $data['course_registrated_student'][$running_batch->course_id] = $this->batch_model->get_course_registarted_student($running_batch->course_id);
            $data['batch_created_by'][$running_batch->person_id] = $this->person_model->get_single_person_information_by_person_id($running_batch->person_id);
            $data['batch_resource_person'][$running_batch->resource_person_id] = $this->batch_model->get_resource_person_info($running_batch->resource_person_id);
            $data['student_number_in_batch'][$running_batch->course_batch_id] = $this->batch_model->count_number_of_student_in_batch($running_batch->course_batch_id);
        }
        //finished batch 
        $data['finished_batch_info'] = $this->batch_model->get_batch_info($person_id, 2); //2= finished batch      
        foreach ($data['finished_batch_info'] as $finished_batch) {
            $data['batch_created_by'][$finished_batch->person_id] = $this->person_model->get_single_person_information_by_person_id($finished_batch->person_id);
            $data['batch_resource_person'][$finished_batch->resource_person_id] = $this->batch_model->get_resource_person_info($finished_batch->resource_person_id);
            $data['student_number_in_batch'][$finished_batch->course_batch_id] = $this->batch_model->count_number_of_student_in_batch($finished_batch->course_batch_id);
        }

        //cancel batch
        $data['cancel_batch_info'] = $this->batch_model->get_batch_info($person_id, 3); //3=cancel batch      
        foreach ($data['cancel_batch_info'] as $cancel_batch) {
            $data['batch_created_by'][$cancel_batch->person_id] = $this->person_model->get_single_person_information_by_person_id($cancel_batch->person_id);
            $data['batch_resource_person'][$cancel_batch->resource_person_id] = $this->batch_model->get_resource_person_info($cancel_batch->resource_person_id);
            $data['student_number_in_batch'][$cancel_batch->course_batch_id] = $this->batch_model->count_number_of_student_in_batch($cancel_batch->course_batch_id);
        }

        $data['main_content'] = $this->load->view('user/batch/view_course_batch', $data, true);
        $this->load->view('user/master', $data);
    }

    /*
     * Function         : auto_update_course_batch_type 
     * Used IN          : function[manage_organization_batch] controller[batch], function[manage_teacher_batch] controller[batch]
     * Description      : used to auto update batch type
     * Parameter        : none
     * return           : none
     * redirect         : none
     * Developed By     : Tania Akter
     * Date             : 
     */

    function auto_update_course_batch_type() {
        $batch_info = $this->batch_model->select_batch_info();
        foreach ($batch_info as $course_batch) {
            $start_date = $course_batch->course_batch_start_date;
            $finish_date = $course_batch->course_batch_finish_date;
            $present_date = date("Y-m-d");
            if ($start_date < $present_date && $present_date < $finish_date) {
                $this->batch_model->update_batch_type($course_batch->course_batch_id, 1); //1= running
            } else if ($start_date < $present_date && $present_date > $finish_date) {
                $this->batch_model->update_batch_type($course_batch->course_batch_id, 2); //2=finished
            }
        }
    }

    /*
     * Function         : manage_teacher_batch
     * Used IN          : user/side_menu
     * Description      : used to view teacher batch
     * Parameter        : none
     * return           : none
     * redirect         : none
     * view             : user/batch/view_course_batch
     * Developed By     : Tania Akter
     * Updated By       : Md Mashqur Ul Alam [06-03-17] - Menu Highlight fix
     * Date             : 
     */

    function manage_teacher_batch() {
        $person_id = $this->session->userdata('user_id');
        $data['active_menu'] = 'teacher';
        $data['active_sub_menu'] = 'teacher_batch';
        $data['left_side_menu_view'] = 1;
        $data['left_side'] = 1;
        $data['course_value_for_search'] = 3;       //search batch in header menu
        $this->auto_update_course_batch_type();    //used to update course batch type
        $resource_person_info = $this->person_model->select_resource_person_information_by_person_id($person_id);
        $data['total_created_batch'] = $this->batch_model->get_total_teacher_batch_status($resource_person_info->resource_person_id, 4); //4=create
        $data['total_running_batch'] = $this->batch_model->get_total_teacher_batch_status($resource_person_info->resource_person_id, 1); //1=running
        $data['total_finished_batch'] = $this->batch_model->get_total_teacher_batch_status($resource_person_info->resource_person_id, 2); //finished
        $data['total_cancel_batch'] = $this->batch_model->get_total_teacher_batch_status($resource_person_info->resource_person_id, 3); //3= cancel
        $data['page'] = 1;
        $data['batch_tab'] = $this->get_batch_tab();
        $data['created_batch_info'] = $this->batch_model->get_teacher_batch_info($resource_person_info->resource_person_id, 4); //4=create
        foreach ($data['created_batch_info'] as $created_batch) {
            $data['course_registrated_student'][$created_batch->course_id] = $this->batch_model->get_course_registarted_student($created_batch->course_id);
            $data['batch_created_by'][$created_batch->person_id] = $this->person_model->get_single_person_information_by_person_id($created_batch->person_id);
            $data['batch_resource_person'][$created_batch->resource_person_id] = $this->batch_model->get_resource_person_info($created_batch->resource_person_id);
            $data['student_number_in_batch'][$created_batch->course_batch_id] = $this->batch_model->count_number_of_student_in_batch($created_batch->course_batch_id);
        }
        // running batch
        $data['running_batch_info'] = $this->batch_model->get_teacher_batch_info($resource_person_info->resource_person_id, 1); //1=running
        foreach ($data['running_batch_info'] as $running_batch) {
            $data['course_registrated_student'][$running_batch->course_id] = $this->batch_model->get_course_registarted_student($running_batch->course_id);
            $data['batch_created_by'][$running_batch->person_id] = $this->person_model->get_single_person_information_by_person_id($running_batch->person_id);
            $data['batch_resource_person'][$running_batch->resource_person_id] = $this->batch_model->get_resource_person_info($running_batch->resource_person_id);
            $data['student_number_in_batch'][$running_batch->course_batch_id] = $this->batch_model->count_number_of_student_in_batch($running_batch->course_batch_id);
        }
        // finished batch
        $data['finished_batch_info'] = $this->batch_model->get_teacher_batch_info($resource_person_info->resource_person_id, 2); //finished
        foreach ($data['finished_batch_info'] as $finished_batch) {
            $data['batch_created_by'][$finished_batch->person_id] = $this->person_model->get_single_person_information_by_person_id($finished_batch->person_id);
            $data['batch_resource_person'][$finished_batch->resource_person_id] = $this->batch_model->get_resource_person_info($finished_batch->resource_person_id);
            $data['student_number_in_batch'][$finished_batch->course_batch_id] = $this->batch_model->count_number_of_student_in_batch($finished_batch->course_batch_id);
        }
        //cancel batch
        $data['cancel_batch_info'] = $this->batch_model->get_teacher_batch_info($resource_person_info->resource_person_id, 3); //3= cancel
        foreach ($data['cancel_batch_info'] as $cancel_batch) {
            $data['batch_created_by'][$cancel_batch->person_id] = $this->person_model->get_single_person_information_by_person_id($cancel_batch->person_id);
            $data['batch_resource_person'][$cancel_batch->resource_person_id] = $this->batch_model->get_resource_person_info($cancel_batch->resource_person_id);
            $data['student_number_in_batch'][$cancel_batch->course_batch_id] = $this->batch_model->count_number_of_student_in_batch($cancel_batch->course_batch_id);
        }
        $data['main_content'] = $this->load->view('user/batch/view_course_batch', $data, true);
        $this->load->view('user/master', $data);
    }

    /*
     * Function         : assign_studen_for_batch
     * Used IN          : user/course/course_registered_student, user\batch\ajax_page\student_batch_assign.php
     * Description      : get registrared student in batch
     * Parameter        : none
     * return           : none
     * redirect         : none
     * view             : user/batch/ajax_page/student_batch_assign
     * Developed By     : Tania Akter
     * Date             : 
     */

    function assign_studen_for_batch() {
        $data['student_id'] = $student_id = $this->input->post('student_id', TRUE);
        $data['batch_info'] = $this->batch_model->select_batch_for_student($data['student_id']);
        echo $this->load->view('user/batch/ajax_page/student_batch_assign', $data, true);
    }

    /*
     * Function         : update_student_in_tbl_course_batch
     * Used IN          : user\batch\ajax_page\student_batch_assign.php
     * Description      : update student in batch
     * Parameter        : none
     * return           : none
     * redirect         : none
     * Developed By     : Tania Akter
     * Date             : 
     */

    function update_student_in_tbl_course_batch() {
        $this->batch_model->update_assign_student_for_batch();
    }

    /*
     * Function         : view_assigned_batch
     * Used IN          : user\course\course_registered_student.php
     * Description      : used to view student who assigned in batch
     * Parameter        : none
     * return           : none
     * redirect         : none
     * view             : user/batch/ajax_page/view_student_assigned_batch
     * Developed By     : Tania Akter
     * Date             : 
     */

    function view_assigned_batch() {
        $data['student_id'] = $student_id = $this->input->post('student_id', TRUE);
        $course_id = $this->input->post('course_id', TRUE);
        $data['batch_info'] = $this->batch_model->select_assigned_batch_for_view($student_id, $course_id);
        echo $this->load->view('user/batch/ajax_page/view_student_assigned_batch', $data, true);
    }

    /*
     * Function         : 
     * Used IN          : user\batch\ajax_page\student_batch_assign.php , user\batch\ajax_page\view_student_assigned_batch.php
     * Description      : used to remove student from batch
     * Parameter        : none
     * return           : none
     * redirect         : none
     * view             : user/batch/ajax_page/view_student_assigned_batch
     * Developed By     : Tania Akter
     * Date             : 
     */

    function remove_student() {
        $data['student_id'] = $student_id = $this->input->post('studentID', TRUE);
        $course_id = $this->input->post('courseID', TRUE);
        $this->batch_model->remove_student_from_assigned_batch();
        $data['batch_info'] = $this->batch_model->select_assigned_batch_for_view($student_id, $course_id);
        echo $this->load->view('user/batch/ajax_page/view_student_assigned_batch', $data, true);
    }

    /*
     * Function         : cancel_batch
     * Used IN          : user\batch\ajax_page\view_created_batch.php , user\batch\ajax_page\view_running_batch.php, user\batch\view_course_batch.php
     * Description      : used to cancel batch
     * Parameter        : none
     * return           : none
     * redirect         : none
     * Developed By     : Tania Akter
     * Date             : 
     */

    function cancel_batch() {
        $course_batch_id = $this->input->post('course_batch_id', TRUE);
        $this->batch_model->cancel_batch_by_course_batch_id($course_batch_id);
    }

    /*
     * Function         : edit_batch
     * Used IN          : user\batch\view_course_batch.php, user\batch\edit_batch.php, user\batch\ajax_page\view_cancel_batch.php, user\batch\ajax_page\view_created_batch.php
     * Description      : used to edit batch
     * Parameter        :$course_batch_id, $batch_tab(created, running, finished, cancel)
     * return           : none
     * redirect         : redirect('batch/organization'),  redirect('batch/teacher');
     * view             : user/batch/edit_batch
     * Developed By     : Tania Akter
     * Date             : 
     */

    function edit_batch($course_batch_id, $batch_tab) {
        $this->session->userdata('active_menu');
        $this->add_batch_form_validation();            //used for form validation    
        $person_id = $this->session->userdata('user_id');
        $data = $this->view_for_right_side_menu();
        $data['batch_tab'] = $batch_tab;
        $data['batch_info'] = $this->batch_model->get_batch_information($course_batch_id);
        $course_id = $data['batch_info']->course_id;
        $data['resourse_person_info'] = $this->batch_model->get_resourse_info_by_course_id($course_id);
        $data['person_info'] = $person_info = $this->person_model->get_single_person_information_by_person_id($person_id);    //person_info
        $data['course_data'] = $this->batch_model->select_all_active_courses($data['person_info']);           //course_info
        if ($this->form_validation->run() == FALSE) {
            $data['main_content'] = $this->load->view('user/batch/edit_batch', $data, true);
            $this->load->view('user/master', $data);
        } else if ($data['batch_info']->course_batch_status == 3) { //cancel batch
            $this->batch_model->update_batch_information($course_batch_id, 4);      //created batch
            if ($person_info->person_role == 3) {   // 3 means person is teacher
                redirect('batch/teacher');
            } else if ($person_info->person_role == 4) { // 4 means person is organization
                redirect('batch/organization');
            }
        } else {
            $this->batch_model->update_batch_information($course_batch_id, $data['batch_info']->course_batch_status);
            $sdata['batch_tab'] = $batch_tab;
            $this->session->set_userdata($sdata);
            if ($person_info->person_role == 3) {   // 3 means person is teacher
                redirect('batch/teacher');
            } else if ($person_info->person_role == 4) {    // 4 means person is organization
                redirect('batch/organization');
            }
        }
    }

    /*
     * Function         : delete_batch
     * Used IN          : user\batch\view_course_batch.php, user\batch\ajax_page\view_created_batch.php, user\batch\ajax_page\view_cancel_batch.php
     * Description      : used to delete batch
     * Parameter        : none
     * return           : none
     * redirect         : none
     * Developed By     : Tania Akter
     * Date             : 
     */

    function delete_batch() {
        $course_batch_id = $this->input->post('course_batch_id', TRUE);
        $this->batch_model->delete_batch_by_course_batch_id($course_batch_id);
    }

    /*
     * Function         : view_assigned_student
     * Used IN          : user\batch\ajax_page\view_finished_batch.php , user\batch\ajax_page\view_created_batch.php, user\batch\view_course_batch.php
     * Description      : used to view assigned student
     * Parameter        : $course_batch_id
     * return           : none
     * redirect         : none
     * view             : user/batch/batch_assigned_student_list
     * Developed By     : Tania Akter
     * Date             : 
     */

    function view_assigned_student($encoded_course_batch_id) {
        $course_batch_id = $this->utility_model->decode_id($encoded_course_batch_id, 'Tt', '/');
        $person_id = $this->session->userdata('user_id');
        $data['person_info'] = $this->person_model->get_single_person_information_by_person_id($person_id);
        $data['active_menu'] = $this->session->userdata('active_menu');
        $data['active_sub_menu'] = $this->session->userdata('active_sub_menu');
        $data['active_sub_menu_item'] = $sdata['active_sub_menu_item'] = 'My Batch';
        $data['left_side_menu_view'] = 1;
        $data['left_side'] = 1;
        $data['course_batch_id'] = $course_batch_id;
        $data['batch_info'] = $batch_info = $this->batch_model->get_batch_information($course_batch_id);
        $data['course_url'] = $this->batch_model->get_course_url($course_batch_id);
        $data['student_number'] = count(explode(',', $batch_info->student_id));
        //$data['assigned_student_info'] = $this->batch_model->get_batch_assigned_student_list($batch_info->student_id);
        $this->load->model('certificate_model');
        $data['assigned_student_info'] = $this->certificate_model->get_student_info($batch_info->student_id);
        $data['main_content'] = $this->load->view('user/batch/batch_assigned_student_list', $data, true);
        $this->load->view('user/master', $data);
    }

    /*
     * Function         : batch_pagination
     * Used IN          : user/batch/view_course_batch,user\batch\ajax_page\view_created_batch.php,  
     *                    user\batch\ajax_page\view_running_batch.php, 
     *                    user\batch\ajax_page\view_finished_batch.php,
     *                    user\batch\ajax_page\view_cancel_batch.php,
     *                    user\batch\ajax_page\search_created_batch_view.php
     * Description      : used to pagination 
     * Parameter        : none
     * return           : none
     * redirect         : none
     * Developed By     : Tania Akter
     * Date             : 
     */

    function batch_pagination() {
        $person_id = $this->session->userdata('user_id');
        $batch_type = $this->input->post('batch_type', TRUE);
        $page = $this->input->post('page_number', TRUE);
        $limit = $page * 5 - 5;
        if ($batch_type == 'created') {
            $this->view_created_batch_for_ajax_view($page, $limit, $person_id);
        } else if ($batch_type == 'running') {
            $this->view_running_batch_for_ajax_view($page, $limit, $person_id);
        } else if ($batch_type == 'finished') {
            $this->view_finished_batch_for_ajax_view($page, $limit, $person_id);
        } else if ($batch_type == 'cancel') {
            $this->view_cancel_batch_for_ajax_view($page, $limit, $person_id);
        }
    }

    /*
     * Function         : view_created_batch_for_ajax_view
     * Used IN          : function[batch_pagination] controller[batch]
     * Description      : 
     * Parameter        :
     * return           :
     * redirect         :
     * view             : user/batch/ajax_page/view_created_batch
     * Developed By     : Tania Akter
     * Date             : 
     */

    function view_created_batch_for_ajax_view($page, $limit, $person_id) {
        $person_info = $this->person_model->get_single_person_information_by_person_id($person_id);    //person_info
        $data['page'] = $page;
        if ($person_info->person_role == 4) {   //person is organization
            $data['created_batch_info'] = $this->batch_model->get_batch_info_pagination($person_id, 4, $limit); //4= create batch
            $data['total_created_batch'] = $this->batch_model->get_total_batch_status($person_id, 4); //4= create
            foreach ($data['created_batch_info'] as $created_batch) {
                $data['course_registrated_student'][$created_batch->course_id] = $this->batch_model->get_course_registarted_student($created_batch->course_id);
                $data['batch_created_by'][$created_batch->person_id] = $this->person_model->get_single_person_information_by_person_id($created_batch->person_id);
                $data['batch_resource_person'][$created_batch->resource_person_id] = $this->batch_model->get_resource_person_info($created_batch->resource_person_id);
                $data['student_number_in_batch'][$created_batch->course_batch_id] = $this->batch_model->count_number_of_student_in_batch($created_batch->course_batch_id);
            }
        } else if ($person_info->person_role == 3) {    //person is teacher
            $resource_person_info = $this->person_model->select_resource_person_information_by_person_id($person_id);
            $data['total_created_batch'] = $this->batch_model->get_total_teacher_batch_status($resource_person_info->resource_person_id, 4); //4=create
            $data['created_batch_info'] = $this->batch_model->get_teacher_batch_info_pagination($resource_person_info->resource_person_id, 4, $limit); //4=create
            foreach ($data['created_batch_info'] as $created_batch) {
                $data['course_registrated_student'][$created_batch->course_id] = $this->batch_model->get_course_registarted_student($created_batch->course_id);
                $data['batch_created_by'][$created_batch->person_id] = $this->person_model->get_single_person_information_by_person_id($created_batch->person_id);
                $data['batch_resource_person'][$created_batch->resource_person_id] = $this->batch_model->get_resource_person_info($created_batch->resource_person_id);
                $data['student_number_in_batch'][$created_batch->course_batch_id] = $this->batch_model->count_number_of_student_in_batch($created_batch->course_batch_id);
            }
        }
        echo $this->load->view('user/batch/ajax_page/view_created_batch', $data, TRUE);
    }

    /*
     * Function         : view_running_batch_for_ajax_view 
     * Used IN          : function[batch_pagination] controller[batch]
     * Description      : 
     * Parameter        :
     * return           :
     * redirect         :
     * view             : user/batch/ajax_page/view_running_batch 
     * Developed By     : Tania Akter
     * Date             : 
     */

    function view_running_batch_for_ajax_view($page, $limit, $person_id) {
        $person_info = $this->person_model->get_single_person_information_by_person_id($person_id);    //person_info
        $data['page'] = $page;
        if ($person_info->person_role == 4) {   //person is organization
            $data['total_running_batch'] = $this->batch_model->get_total_batch_status($person_id, 1); //1= running
            $data['running_batch_info'] = $this->batch_model->get_batch_info_pagination($person_id, 1, $limit);   //1= running batch     
            foreach ($data['running_batch_info'] as $running_batch) {
                $data['course_registrated_student'][$running_batch->course_id] = $this->batch_model->get_course_registarted_student($running_batch->course_id);
                $data['batch_created_by'][$running_batch->person_id] = $this->person_model->get_single_person_information_by_person_id($running_batch->person_id);
                $data['batch_resource_person'][$running_batch->resource_person_id] = $this->batch_model->get_resource_person_info($running_batch->resource_person_id);
                $data['student_number_in_batch'][$running_batch->course_batch_id] = $this->batch_model->count_number_of_student_in_batch($running_batch->course_batch_id);
            }
        } else if ($person_info->person_role == 3) {    //person is teacher
            $resource_person_info = $this->person_model->select_resource_person_information_by_person_id($person_id);
            $data['total_running_batch'] = $this->batch_model->get_total_teacher_batch_status($resource_person_info->resource_person_id, 1); //1=running
            $data['running_batch_info'] = $this->batch_model->get_teacher_batch_info_pagination($resource_person_info->resource_person_id, 1, $limit); //1=running
            foreach ($data['running_batch_info'] as $running_batch) {
                $data['course_registrated_student'][$running_batch->course_id] = $this->batch_model->get_course_registarted_student($running_batch->course_id);
                $data['batch_created_by'][$running_batch->person_id] = $this->person_model->get_single_person_information_by_person_id($running_batch->person_id);
                $data['batch_resource_person'][$running_batch->resource_person_id] = $this->batch_model->get_resource_person_info($running_batch->resource_person_id);
                $data['student_number_in_batch'][$running_batch->course_batch_id] = $this->batch_model->count_number_of_student_in_batch($running_batch->course_batch_id);
            }
        }
        echo $this->load->view('user/batch/ajax_page/view_running_batch', $data, TRUE);
    }

    /*
     * Function         : view_finished_batch_for_ajax_view
     * Used IN          : function[batch_pagination] controller[batch]
     * Description      : 
     * Parameter        :
     * return           :
     * redirect         :
     *  view            : user/batch/ajax_page/view_finished_batch 
     * Developed By     : Tania Akter
     * Date             : 
     */

    function view_finished_batch_for_ajax_view($page, $limit, $person_id) {
        $person_info = $this->person_model->get_single_person_information_by_person_id($person_id);    //person_info
        $data['page'] = $page;
        if ($person_info->person_role == 4) {   //person is organization
            $data['total_finished_batch'] = $this->batch_model->get_total_batch_status($person_id, 2); //2= finished
            $data['finished_batch_info'] = $this->batch_model->get_batch_info_pagination($person_id, 2, $limit); //2= finished batch      
            foreach ($data['finished_batch_info'] as $finished_batch) {
                $data['batch_created_by'][$finished_batch->person_id] = $this->person_model->get_single_person_information_by_person_id($finished_batch->person_id);
                $data['batch_resource_person'][$finished_batch->resource_person_id] = $this->batch_model->get_resource_person_info($finished_batch->resource_person_id);
                $data['student_number_in_batch'][$finished_batch->course_batch_id] = $this->batch_model->count_number_of_student_in_batch($finished_batch->course_batch_id);
            }
        } else if ($person_info->person_role == 3) {     //person is teacher
            $resource_person_info = $this->person_model->select_resource_person_information_by_person_id($person_id);
            $data['total_finished_batch'] = $this->batch_model->get_total_teacher_batch_status($resource_person_info->resource_person_id, 2); //finished
            $data['finished_batch_info'] = $this->batch_model->get_teacher_batch_info_pagination($resource_person_info->resource_person_id, 2, $limit); //finished
            foreach ($data['finished_batch_info'] as $finished_batch) {
                $data['batch_created_by'][$finished_batch->person_id] = $this->person_model->get_single_person_information_by_person_id($finished_batch->person_id);
                $data['batch_resource_person'][$finished_batch->resource_person_id] = $this->batch_model->get_resource_person_info($finished_batch->resource_person_id);
                $data['student_number_in_batch'][$finished_batch->course_batch_id] = $this->batch_model->count_number_of_student_in_batch($finished_batch->course_batch_id);
            }
        }
        echo $this->load->view('user/batch/ajax_page/view_finished_batch', $data, TRUE);
    }

    /*
     * Function         : view_cancel_batch_for_ajax_view
     * Used IN          : function[batch_pagination] controller[batch]
     * Description      : 
     * Parameter        : $page, 
     *                    $limit, 
     *                    $person_id
     * return           : none
     * redirect         : none
     * view             : user/batch/ajax_page/view_cancel_batch
     * Developed By     : Tania Akter
     * Date             : 
     */

    function view_cancel_batch_for_ajax_view($page, $limit, $person_id) {
        $person_info = $this->person_model->get_single_person_information_by_person_id($person_id);    //person_info
        $data['page'] = $page;
        if ($person_info->person_role == 4) {   //person is organization
            $data['total_cancel_batch'] = $this->batch_model->get_total_batch_status($person_id, 3); //3=cancel
            $data['cancel_batch_info'] = $this->batch_model->get_batch_info_pagination($person_id, 3, $limit); //3=cancel batch      
            foreach ($data['cancel_batch_info'] as $cancel_batch) {
                $data['batch_created_by'][$cancel_batch->person_id] = $this->person_model->get_single_person_information_by_person_id($cancel_batch->person_id);
                $data['batch_resource_person'][$cancel_batch->resource_person_id] = $this->batch_model->get_resource_person_info($cancel_batch->resource_person_id);
                $data['student_number_in_batch'][$cancel_batch->course_batch_id] = $this->batch_model->count_number_of_student_in_batch($cancel_batch->course_batch_id);
            }
        } else if ($person_info->person_role == 3) {    //person is teacher
            $resource_person_info = $this->person_model->select_resource_person_information_by_person_id($person_id);
            $data['total_cancel_batch'] = $this->batch_model->get_total_teacher_batch_status($resource_person_info->resource_person_id, 3); //3= cancel           
            $data['cancel_batch_info'] = $this->batch_model->get_teacher_batch_info_pagination($resource_person_info->resource_person_id, 3, $limit); //3= cancel
            foreach ($data['cancel_batch_info'] as $cancel_batch) {
                $data['batch_created_by'][$cancel_batch->person_id] = $this->person_model->get_single_person_information_by_person_id($cancel_batch->person_id);
                $data['batch_resource_person'][$cancel_batch->resource_person_id] = $this->batch_model->get_resource_person_info($cancel_batch->resource_person_id);
                $data['student_number_in_batch'][$cancel_batch->course_batch_id] = $this->batch_model->count_number_of_student_in_batch($cancel_batch->course_batch_id);
            }
        }
        echo $this->load->view('user/batch/ajax_page/view_cancel_batch', $data, TRUE);
    }

    /*
     * Function         : view_search_batch
     * Used IN          : 
     * Description      : 
     * Parameter        :
     * return           :
     * redirect         :
     * view             : user/batch/ajax_page/view_cancel_batch
     * Developed By     : Tania Akter
     * Date             : 
     */

    function view_search_batch() {
        $search_value = $this->input->post('search_value', TRUE);
        $person_id = $this->input->post('person_id', TRUE);
        $person_info = $this->person_model->get_single_person_information_by_person_id($person_id);    //person_info
        // $data['page'] = $page;
        $data['page'] = 1;
        if ($person_info->person_role == 4) {   //person is organization
            $data['created_batch_info'] = $this->batch_model->get_searched_batch($person_id, 4, $search_value); //4= create batch
            $data['total_created_batch'] = $this->batch_model->get_total_batch_by_search_value($person_id, 4, $search_value); //4= create
            //$data['total_created_batch'] = $this->batch_model->get_total_batch_status($person_id, 4); //4= create
            foreach ($data['created_batch_info'] as $created_batch) {
                $data['course_registrated_student'][$created_batch->course_id] = $this->batch_model->get_course_registarted_student($created_batch->course_id);
                $data['batch_created_by'][$created_batch->person_id] = $this->person_model->get_single_person_information_by_person_id($created_batch->person_id);
                $data['batch_resource_person'][$created_batch->resource_person_id] = $this->batch_model->get_resource_person_info($created_batch->resource_person_id);
                $data['student_number_in_batch'][$created_batch->course_batch_id] = $this->batch_model->count_number_of_student_in_batch($created_batch->course_batch_id);
            }
        } else if ($person_info->person_role == 3) {    //person is teacher
            $resource_person_info = $this->person_model->select_resource_person_information_by_person_id($person_id);
            $data['total_created_batch'] = $this->batch_model->get_total_teacher_batch_by_search_value($resource_person_info->resource_person_id, 4, $search_value); //4=create
            // $data['total_created_batch'] = $this->batch_model->get_total_teacher_batch_status($resource_person_info->resource_person_id, 4); //4=create
            $data['created_batch_info'] = $this->batch_model->get_searched_teacher_batch($resource_person_info->resource_person_id, 4, $search_value); //4=create
            foreach ($data['created_batch_info'] as $created_batch) {
                $data['course_registrated_student'][$created_batch->course_id] = $this->batch_model->get_course_registarted_student($created_batch->course_id);
                $data['batch_created_by'][$created_batch->person_id] = $this->person_model->get_single_person_information_by_person_id($created_batch->person_id);
                $data['batch_resource_person'][$created_batch->resource_person_id] = $this->batch_model->get_resource_person_info($created_batch->resource_person_id);
                $data['student_number_in_batch'][$created_batch->course_batch_id] = $this->batch_model->count_number_of_student_in_batch($created_batch->course_batch_id);
            }
        }
        echo $this->load->view('user/batch/ajax_page/search_created_batch_view', $data, TRUE);
    }

    /*
     * Function         : searched_batch_by_type
     * Used IN          : user\batch\view_course_batch.php
     * Description      : 
     * Parameter        : none
     * return           : none
     * redirect         : none
     * view             : user/batch/ajax_page/search_batch_view
     * Developed By     : Tania Akter
     * Date             : 
     */

    function searched_batch_by_type() {
        $data['batch_type'] = $this->input->post('batchType', TRUE);
        echo $this->load->view('user/batch/ajax_page/search_batch_view', $data, TRUE);
    }

    /*
     * Function         : view_individual_search_batch
     * Used IN          : user\batch\ajax_page\search_batch_view.php
     * Description      : 
     * Parameter        : none
     * return           : none
     * redirect         : none
     * view             : none
     * Developed By     : Tania Akter
     * Date             : 
     */

    function view_individual_search_batch() {
        $person_id = $this->session->userdata('user_id');
        $batch_type = $this->input->post('batch_type', TRUE);
        $search_value = $this->input->post('search_value', TRUE);
        if ($batch_type == 'created') {
            $this->search_view_created_batch_for_ajax_view($search_value, $person_id);
        } else if ($batch_type == 'running') {
            $this->search_view_running_batch_for_ajax_view($search_value, $person_id);
        } else if ($batch_type == 'finished') {
            $this->search_view_finished_batch_for_ajax_view($search_value, $person_id);
        } else if ($batch_type == 'cancel') {
            $this->search_view_cancel_batch_for_ajax_view($search_value, $person_id);
        }
    }

    /*
     * Function         : search_view_created_batch_for_ajax_view
     * Used IN          : function[view_individual_search_batch] controller[batch]
     * Description      : 
     * Parameter        : $search_value, 
     *                    $person_id)
     * return           : none
     * redirect         : none
     * view             : user/batch/ajax_page/view_created_batch
     * Developed By     : Tania Akter
     * Date             : 
     */

    function search_view_created_batch_for_ajax_view($search_value, $person_id) {
        $person_info = $this->person_model->get_single_person_information_by_person_id($person_id);    //person_info
        // $data['page'] = $page;
        $data['page'] = 1;
        if ($person_info->person_role == 4) {   //person is organization
            $data['created_batch_info'] = $this->batch_model->get_searched_batch($person_id, 4, $search_value); //4= create batch
            $data['total_created_batch'] = $this->batch_model->get_total_batch_by_search_value($person_id, 4, $search_value); //4= create
            //$data['total_created_batch'] = $this->batch_model->get_total_batch_status($person_id, 4); //4= create
            foreach ($data['created_batch_info'] as $created_batch) {
                $data['course_registrated_student'][$created_batch->course_id] = $this->batch_model->get_course_registarted_student($created_batch->course_id);
                $data['batch_created_by'][$created_batch->person_id] = $this->person_model->get_single_person_information_by_person_id($created_batch->person_id);
                $data['batch_resource_person'][$created_batch->resource_person_id] = $this->batch_model->get_resource_person_info($created_batch->resource_person_id);
                $data['student_number_in_batch'][$created_batch->course_batch_id] = $this->batch_model->count_number_of_student_in_batch($created_batch->course_batch_id);
            }
        } else if ($person_info->person_role == 3) {    //person is teacher
            $resource_person_info = $this->person_model->select_resource_person_information_by_person_id($person_id);
            $data['total_created_batch'] = $this->batch_model->get_total_teacher_batch_by_search_value($resource_person_info->resource_person_id, 4, $search_value); //4=create
            // $data['total_created_batch'] = $this->batch_model->get_total_teacher_batch_status($resource_person_info->resource_person_id, 4); //4=create
            $data['created_batch_info'] = $this->batch_model->get_searched_teacher_batch($resource_person_info->resource_person_id, 4, $search_value); //4=create
            foreach ($data['created_batch_info'] as $created_batch) {
                $data['course_registrated_student'][$created_batch->course_id] = $this->batch_model->get_course_registarted_student($created_batch->course_id);
                $data['batch_created_by'][$created_batch->person_id] = $this->person_model->get_single_person_information_by_person_id($created_batch->person_id);
                $data['batch_resource_person'][$created_batch->resource_person_id] = $this->batch_model->get_resource_person_info($created_batch->resource_person_id);
                $data['student_number_in_batch'][$created_batch->course_batch_id] = $this->batch_model->count_number_of_student_in_batch($created_batch->course_batch_id);
            }
        }
        echo $this->load->view('user/batch/ajax_page/view_created_batch', $data, TRUE);
    }

    /*
     * Function         : search_view_running_batch_for_ajax_view
     * Used IN          : function[view_individual_search_batch] controller[batch]
     * Description      : 
     * Parameter        : $search_value, 
     *                    $person_id
     * return           : none
     * redirect         : none
     * view             : user/batch/ajax_page/view_running_batch
     * Developed By     : Tania Akter
     * Date             : 
     */

    function search_view_running_batch_for_ajax_view($search_value, $person_id) {
        $person_info = $this->person_model->get_single_person_information_by_person_id($person_id);    //person_info
        $data['page'] = 1;
        if ($person_info->person_role == 4) {   //person is organization
            $data['total_running_batch'] = $this->batch_model->get_total_batch_by_search_value($person_id, 1, $search_value); //1= running
            // $data['total_running_batch'] = $this->batch_model->get_total_batch_status($person_id, 1); //1= running
            $data['running_batch_info'] = $this->batch_model->get_searched_batch($person_id, 1, $search_value);  //1= running batch     
            foreach ($data['running_batch_info'] as $running_batch) {
                $data['course_registrated_student'][$running_batch->course_id] = $this->batch_model->get_course_registarted_student($running_batch->course_id);
                $data['batch_created_by'][$running_batch->person_id] = $this->person_model->get_single_person_information_by_person_id($running_batch->person_id);
                $data['batch_resource_person'][$running_batch->resource_person_id] = $this->batch_model->get_resource_person_info($running_batch->resource_person_id);
                $data['student_number_in_batch'][$running_batch->course_batch_id] = $this->batch_model->count_number_of_student_in_batch($running_batch->course_batch_id);
            }
        } else if ($person_info->person_role == 3) {    //person is teacher
            $resource_person_info = $this->person_model->select_resource_person_information_by_person_id($person_id);
            $data['total_running_batch'] = $this->batch_model->get_total_teacher_batch_by_search_value($resource_person_info->resource_person_id, 1, $search_value); //1=running
            //$data['total_running_batch'] = $this->batch_model->get_total_teacher_batch_status($resource_person_info->resource_person_id, 1); //1=running
            $data['running_batch_info'] = $this->batch_model->get_searched_teacher_batch($resource_person_info->resource_person_id, 1, $search_value); //1=running
            foreach ($data['running_batch_info'] as $running_batch) {
                $data['course_registrated_student'][$running_batch->course_id] = $this->batch_model->get_course_registarted_student($running_batch->course_id);
                $data['batch_created_by'][$running_batch->person_id] = $this->person_model->get_single_person_information_by_person_id($running_batch->person_id);
                $data['batch_resource_person'][$running_batch->resource_person_id] = $this->batch_model->get_resource_person_info($running_batch->resource_person_id);
                $data['student_number_in_batch'][$running_batch->course_batch_id] = $this->batch_model->count_number_of_student_in_batch($running_batch->course_batch_id);
            }
        }
        echo $this->load->view('user/batch/ajax_page/view_running_batch', $data, TRUE);
    }

    /*
     * Function         : search_view_finished_batch_for_ajax_view
     * Used IN          : function[view_individual_search_batch] controller[batch]
     * Description      : 
     * Parameter        : $search_value, 
     *                    $person_id
     * return           : none
     * redirect         : none
     * view             : user/batch/ajax_page/view_finished_batch
     * Developed By     : Tania Akter
     * Date             : 
     */

    function search_view_finished_batch_for_ajax_view($search_value, $person_id) {
        $person_info = $this->person_model->get_single_person_information_by_person_id($person_id);    //person_info
        $data['page'] = 1;
        if ($person_info->person_role == 4) {   //person is organization
            $data['total_finished_batch'] = $this->batch_model->get_total_batch_by_search_value($person_id, 2, $search_value); //2= finished
            //    $data['total_finished_batch'] = $this->batch_model->get_total_batch_status($person_id, 2); //2= finished
            $data['finished_batch_info'] = $this->batch_model->get_searched_batch($person_id, 2, $search_value); //2= finished batch      
            foreach ($data['finished_batch_info'] as $finished_batch) {
                $data['batch_created_by'][$finished_batch->person_id] = $this->person_model->get_single_person_information_by_person_id($finished_batch->person_id);
                $data['batch_resource_person'][$finished_batch->resource_person_id] = $this->batch_model->get_resource_person_info($finished_batch->resource_person_id);
                $data['student_number_in_batch'][$finished_batch->course_batch_id] = $this->batch_model->count_number_of_student_in_batch($finished_batch->course_batch_id);
            }
        } else if ($person_info->person_role == 3) {     //person is teacher
            $resource_person_info = $this->person_model->select_resource_person_information_by_person_id($person_id);
            $data['total_finished_batch'] = $this->batch_model->get_total_teacher_batch_by_search_value($resource_person_info->resource_person_id, 2, $search_value); //finished
            // $data['total_finished_batch'] = $this->batch_model->get_total_teacher_batch_status($resource_person_info->resource_person_id, 2); //finished
            $data['finished_batch_info'] = $this->batch_model->get_searched_teacher_batch($resource_person_info->resource_person_id, 2, $search_value); //finished
            foreach ($data['finished_batch_info'] as $finished_batch) {
                $data['batch_created_by'][$finished_batch->person_id] = $this->person_model->get_single_person_information_by_person_id($finished_batch->person_id);
                $data['batch_resource_person'][$finished_batch->resource_person_id] = $this->batch_model->get_resource_person_info($finished_batch->resource_person_id);
                $data['student_number_in_batch'][$finished_batch->course_batch_id] = $this->batch_model->count_number_of_student_in_batch($finished_batch->course_batch_id);
            }
        }
        echo $this->load->view('user/batch/ajax_page/view_finished_batch', $data, TRUE);
    }

    /*
     * Function         : search_view_cancel_batch_for_ajax_view
     * Used IN          : function[view_individual_search_batch] controller[batch]
     * Description      : 
     * Parameter        : $search_value, 
     *                    $person_id
     * return           : $search_value,
     *                    $person_id
     * redirect         : none
     * view             : user/batch/ajax_page/view_cancel_batch
     * Developed By     : Tania Akter
     * Date             : 
     */

    function search_view_cancel_batch_for_ajax_view($search_value, $person_id) {
        $person_info = $this->person_model->get_single_person_information_by_person_id($person_id);    //person_info
        $data['page'] = 1;
        if ($person_info->person_role == 4) {   //person is organization
            $data['total_cancel_batch'] = $this->batch_model->get_total_batch_by_search_value($person_id, 3, $search_value); //3=cancel
            // $data['total_cancel_batch'] = $this->batch_model->get_total_batch_status($person_id, 3); //3=cancel
            $data['cancel_batch_info'] = $this->batch_model->get_searched_batch($person_id, 3, $search_value);  //3=cancel batch      
            foreach ($data['cancel_batch_info'] as $cancel_batch) {
                $data['batch_created_by'][$cancel_batch->person_id] = $this->person_model->get_single_person_information_by_person_id($cancel_batch->person_id);
                $data['batch_resource_person'][$cancel_batch->resource_person_id] = $this->batch_model->get_resource_person_info($cancel_batch->resource_person_id);
                $data['student_number_in_batch'][$cancel_batch->course_batch_id] = $this->batch_model->count_number_of_student_in_batch($cancel_batch->course_batch_id);
            }
        } else if ($person_info->person_role == 3) {    //person is teacher
            $resource_person_info = $this->person_model->select_resource_person_information_by_person_id($person_id);
            $data['total_cancel_batch'] = $this->batch_model->get_total_teacher_batch_by_search_value($resource_person_info->resource_person_id, 3, $search_value); //3= cancel           
            // $data['total_cancel_batch'] = $this->batch_model->get_total_teacher_batch_status($resource_person_info->resource_person_id, 3); //3= cancel           
            $data['cancel_batch_info'] = $this->batch_model->get_searched_teacher_batch($resource_person_info->resource_person_id, 3, $search_value); //3= cancel
            foreach ($data['cancel_batch_info'] as $cancel_batch) {
                $data['batch_created_by'][$cancel_batch->person_id] = $this->person_model->get_single_person_information_by_person_id($cancel_batch->person_id);
                $data['batch_resource_person'][$cancel_batch->resource_person_id] = $this->batch_model->get_resource_person_info($cancel_batch->resource_person_id);
                $data['student_number_in_batch'][$cancel_batch->course_batch_id] = $this->batch_model->count_number_of_student_in_batch($cancel_batch->course_batch_id);
            }
        }
        echo $this->load->view('user/batch/ajax_page/view_cancel_batch', $data, TRUE);
    }

    /* ------------------------------------------------------ end add batch ---------------------------------------------------- */
    /* ---------------------- start view batch course wise  06-09-2016 ------------------- */
    /*
     * Function         : view_organization_batch_status 
     * Used IN          : 
     *                    
     * Description      : used to get total course wise batch type
     * Parameter        : $person_id, $type, $course_id 
     * return           : batch info
     * redirect         : none
     * Developed By     : Tania Akter
     * Date             : 06-09-2016
     */

    function view_organization_batch_status($course_url) {
        $person_id = $this->session->userdata('user_id');
        $data = array();
        $data['active_menu'] = 'organization';
        $data['active_sub_menu'] = $this->session->userdata('active_sub_menu');
        $data['left_side_menu_view'] = 1;
        $data['left_side'] = 1;
        // $data['course_value_for_search'] = 3;       //search batch in header menu
        $this->auto_update_course_batch_type(); //used to update course batch type               
        $data['course_info'] = $course_info = $this->user_course_model->get_course_information_with_url_by_course_url($course_url);
        $data['course_creator_info'] = $this->person_model->get_single_person_information_by_person_id($course_info->person_id);
        $data['total_created_batch'] = $this->batch_model->get_total_batch_status_course_wise($person_id, 4, $course_info->course_id); //4= create
        $data['total_running_batch'] = $this->batch_model->get_total_batch_status_course_wise($person_id, 1, $course_info->course_id); //1= running
        $data['total_finished_batch'] = $this->batch_model->get_total_batch_status_course_wise($person_id, 2, $course_info->course_id); //2= finished
        $data['total_cancel_batch'] = $this->batch_model->get_total_batch_status_course_wise($person_id, 3, $course_info->course_id); //3=cancel
        $data['page'] = 1;
        $data['batch_tab'] = $this->get_batch_tab();
        $data['created_batch_info'] = $this->batch_model->get_batch_info_course_wise($person_id, 4, $course_info->course_id); //4= create batch
        foreach ($data['created_batch_info'] as $created_batch) {
            $data['course_registrated_student'][$created_batch->course_id] = $this->batch_model->get_course_registarted_student($created_batch->course_id);
            $data['batch_created_by'][$created_batch->person_id] = $this->person_model->get_single_person_information_by_person_id($created_batch->person_id);
            $data['batch_resource_person'][$created_batch->resource_person_id] = $this->batch_model->get_resource_person_info($created_batch->resource_person_id);
            $data['student_number_in_batch'][$created_batch->course_batch_id] = $this->batch_model->count_number_of_student_in_batch($created_batch->course_batch_id);
        }

        // running batch
        $data['running_batch_info'] = $this->batch_model->get_batch_info_course_wise($person_id, 1, $course_info->course_id);   //1= running batch     
        foreach ($data['running_batch_info'] as $running_batch) {
            $data['course_registrated_student'][$running_batch->course_id] = $this->batch_model->get_course_registarted_student($running_batch->course_id);
            $data['batch_created_by'][$running_batch->person_id] = $this->person_model->get_single_person_information_by_person_id($running_batch->person_id);
            $data['batch_resource_person'][$running_batch->resource_person_id] = $this->batch_model->get_resource_person_info($running_batch->resource_person_id);
            $data['student_number_in_batch'][$running_batch->course_batch_id] = $this->batch_model->count_number_of_student_in_batch($running_batch->course_batch_id);
        }
        //finished batch 
        $data['finished_batch_info'] = $this->batch_model->get_batch_info_course_wise($person_id, 2, $course_info->course_id); //2= finished batch      
        foreach ($data['finished_batch_info'] as $finished_batch) {
            $data['batch_created_by'][$finished_batch->person_id] = $this->person_model->get_single_person_information_by_person_id($finished_batch->person_id);
            $data['batch_resource_person'][$finished_batch->resource_person_id] = $this->batch_model->get_resource_person_info($finished_batch->resource_person_id);
            $data['student_number_in_batch'][$finished_batch->course_batch_id] = $this->batch_model->count_number_of_student_in_batch($finished_batch->course_batch_id);
        }

        //cancel batch
        $data['cancel_batch_info'] = $this->batch_model->get_batch_info_course_wise($person_id, 3, $course_info->course_id); //3=cancel batch      
        foreach ($data['cancel_batch_info'] as $cancel_batch) {
            $data['batch_created_by'][$cancel_batch->person_id] = $this->person_model->get_single_person_information_by_person_id($cancel_batch->person_id);
            $data['batch_resource_person'][$cancel_batch->resource_person_id] = $this->batch_model->get_resource_person_info($cancel_batch->resource_person_id);
            $data['student_number_in_batch'][$cancel_batch->course_batch_id] = $this->batch_model->count_number_of_student_in_batch($cancel_batch->course_batch_id);
        }
        $data['main_content'] = $this->load->view('user/batch/view_batch_status', $data, TRUE);
        $this->load->view('user/master', $data);
    }

    function view_teacher_batch_status($course_url) {
        $person_id = $this->session->userdata('user_id');
        $data['active_menu'] = 'teacher';
        $data['active_sub_menu'] = $this->session->userdata('active_sub_menu');
        $data['left_side_menu_view'] = 1;
        $data['left_side'] = 1;
        $data['course_value_for_search'] = 3;       //search batch in header menu
        $this->auto_update_course_batch_type();    //used to update course batch type
        $data['course_info'] = $course_info = $this->user_course_model->get_course_information_with_url_by_course_url($course_url);
        $course_id = $course_info->course_id;
        $resource_person_info = $this->person_model->select_resource_person_information_by_person_id($person_id);

        $resource_person_id = $resource_person_info->resource_person_id;

        $data['total_created_batch'] = $this->batch_model->get_total_teacher_batch_status_course_wise($resource_person_id, 4, $course_id); //4=create
        $data['total_running_batch'] = $this->batch_model->get_total_teacher_batch_status_course_wise($resource_person_id, 1, $course_id); //1=running
        $data['total_finished_batch'] = $this->batch_model->get_total_teacher_batch_status_course_wise($resource_person_id, 2, $course_id); //finished
        $data['total_cancel_batch'] = $this->batch_model->get_total_teacher_batch_status_course_wise($resource_person_id, 3, $course_id); //3= cancel
        $data['page'] = 1;
        $data['batch_tab'] = $this->get_batch_tab();
        $data['created_batch_info'] = $this->batch_model->get_teacher_batch_info_course_wise($resource_person_id, 4, $course_id); //4=create
        foreach ($data['created_batch_info'] as $created_batch) {
            $data['course_registrated_student'][$created_batch->course_id] = $this->batch_model->get_course_registarted_student($created_batch->course_id);
            $data['batch_created_by'][$created_batch->person_id] = $this->person_model->get_single_person_information_by_person_id($created_batch->person_id);
            $data['batch_resource_person'][$created_batch->resource_person_id] = $this->batch_model->get_resource_person_info($created_batch->resource_person_id);
            $data['student_number_in_batch'][$created_batch->course_batch_id] = $this->batch_model->count_number_of_student_in_batch($created_batch->course_batch_id);
        }
        // running batch
        $data['running_batch_info'] = $this->batch_model->get_teacher_batch_info_course_wise($resource_person_id, 1, $course_id); //1=running
        foreach ($data['running_batch_info'] as $running_batch) {
            $data['course_registrated_student'][$running_batch->course_id] = $this->batch_model->get_course_registarted_student($running_batch->course_id);
            $data['batch_created_by'][$running_batch->person_id] = $this->person_model->get_single_person_information_by_person_id($running_batch->person_id);
            $data['batch_resource_person'][$running_batch->resource_person_id] = $this->batch_model->get_resource_person_info($running_batch->resource_person_id);
            $data['student_number_in_batch'][$running_batch->course_batch_id] = $this->batch_model->count_number_of_student_in_batch($running_batch->course_batch_id);
        }
        // finished batch
        $data['finished_batch_info'] = $this->batch_model->get_teacher_batch_info_course_wise($resource_person_id, 2, $course_id); //finished
        foreach ($data['finished_batch_info'] as $finished_batch) {
            $data['batch_created_by'][$finished_batch->person_id] = $this->person_model->get_single_person_information_by_person_id($finished_batch->person_id);
            $data['batch_resource_person'][$finished_batch->resource_person_id] = $this->batch_model->get_resource_person_info($finished_batch->resource_person_id);
            $data['student_number_in_batch'][$finished_batch->course_batch_id] = $this->batch_model->count_number_of_student_in_batch($finished_batch->course_batch_id);
        }
        //cancel batch
        $data['cancel_batch_info'] = $this->batch_model->get_teacher_batch_info_course_wise($resource_person_id, 3, $course_id); //3= cancel
        foreach ($data['cancel_batch_info'] as $cancel_batch) {
            $data['batch_created_by'][$cancel_batch->person_id] = $this->person_model->get_single_person_information_by_person_id($cancel_batch->person_id);
            $data['batch_resource_person'][$cancel_batch->resource_person_id] = $this->batch_model->get_resource_person_info($cancel_batch->resource_person_id);
            $data['student_number_in_batch'][$cancel_batch->course_batch_id] = $this->batch_model->count_number_of_student_in_batch($cancel_batch->course_batch_id);
        }
        $data['main_content'] = $this->load->view('user/batch/view_course_batch', $data, true);
        $this->load->view('user/master', $data);
    }

    function batch_pagination_course_wise() {
        $person_id = $this->session->userdata('user_id');
        $batch_type = $this->input->post('batch_type', TRUE);
        $course_id = $this->input->post('course_id', TRUE);
        $page = $this->input->post('page_number', TRUE);
        $limit = $page * 5 - 5;
        if ($batch_type == 'created') {
            $this->view_created_batch_course_wise($page, $limit, $person_id, $course_id);
        } else if ($batch_type == 'running') {
            $this->view_running_batch_course_wise($page, $limit, $person_id, $course_id);
        } else if ($batch_type == 'finished') {
            $this->view_finished_batch_course_wise($page, $limit, $person_id, $course_id);
        } else if ($batch_type == 'cancel') {
            $this->view_cancel_batch_course_wise($page, $limit, $person_id, $course_id);
        }
    }

    function view_created_batch_course_wise($page, $limit, $person_id, $course_id) {
        $person_info = $this->person_model->get_single_person_information_by_person_id($person_id);    //person_info
        $data['course_id'] = $course_id;
        $data['page'] = $page;
        if ($person_info->person_role == 4) {   //person is organization
            $data['created_batch_info'] = $this->batch_model->get_batch_info_pagination_course($person_id, 4, $limit, $course_id); //4= create batch
            $data['total_created_batch'] = $this->batch_model->get_total_batch_status_course($person_id, 4, $course_id); //4= create
            foreach ($data['created_batch_info'] as $created_batch) {
                $data['course_registrated_student'][$created_batch->course_id] = $this->batch_model->get_course_registarted_student($created_batch->course_id);
                $data['batch_created_by'][$created_batch->person_id] = $this->person_model->get_single_person_information_by_person_id($created_batch->person_id);
                $data['batch_resource_person'][$created_batch->resource_person_id] = $this->batch_model->get_resource_person_info($created_batch->resource_person_id);
                $data['student_number_in_batch'][$created_batch->course_batch_id] = $this->batch_model->count_number_of_student_in_batch($created_batch->course_batch_id);
            }
        } else if ($person_info->person_role == 3) {    //person is teacher
            $resource_person_info = $this->person_model->select_resource_person_information_by_person_id($person_id);
            $data['total_created_batch'] = $this->batch_model->get_total_teacher_batch_status_course($resource_person_info->resource_person_id, 4, $course_id); //4=create
            $data['created_batch_info'] = $this->batch_model->get_teacher_batch_info_pagination_course($resource_person_info->resource_person_id, 4, $limit, $course_id); //4=create
            foreach ($data['created_batch_info'] as $created_batch) {
                $data['course_registrated_student'][$created_batch->course_id] = $this->batch_model->get_course_registarted_student($created_batch->course_id);
                $data['batch_created_by'][$created_batch->person_id] = $this->person_model->get_single_person_information_by_person_id($created_batch->person_id);
                $data['batch_resource_person'][$created_batch->resource_person_id] = $this->batch_model->get_resource_person_info($created_batch->resource_person_id);
                $data['student_number_in_batch'][$created_batch->course_batch_id] = $this->batch_model->count_number_of_student_in_batch($created_batch->course_batch_id);
            }
        }
        echo $this->load->view('user/batch/ajax_page/view_created_batch_course_wise', $data, TRUE);
    }

    function view_running_batch_course_wise($page, $limit, $person_id, $course_id) {
        $person_info = $this->person_model->get_single_person_information_by_person_id($person_id);    //person_info
        $data['course_id'] = $course_id;
        $data['page'] = $page;
        if ($person_info->person_role == 4) {   //person is organization
            $data['total_running_batch'] = $this->batch_model->get_total_batch_status_course($person_id, 1, $course_id); //1= running
            $data['running_batch_info'] = $this->batch_model->get_batch_info_pagination_course($person_id, 1, $limit, $course_id);   //1= running batch     
            foreach ($data['running_batch_info'] as $running_batch) {
                $data['course_registrated_student'][$running_batch->course_id] = $this->batch_model->get_course_registarted_student($running_batch->course_id);
                $data['batch_created_by'][$running_batch->person_id] = $this->person_model->get_single_person_information_by_person_id($running_batch->person_id);
                $data['batch_resource_person'][$running_batch->resource_person_id] = $this->batch_model->get_resource_person_info($running_batch->resource_person_id);
                $data['student_number_in_batch'][$running_batch->course_batch_id] = $this->batch_model->count_number_of_student_in_batch($running_batch->course_batch_id);
            }
        } else if ($person_info->person_role == 3) {    //person is teacher
            $resource_person_info = $this->person_model->select_resource_person_information_by_person_id($person_id);
            $data['total_running_batch'] = $this->batch_model->get_total_teacher_batch_status_course($resource_person_info->resource_person_id, 1, $course_id); //1=running
            $data['running_batch_info'] = $this->batch_model->get_teacher_batch_info_pagination_course($resource_person_info->resource_person_id, 1, $limit, $course_id); //1=running
            foreach ($data['running_batch_info'] as $running_batch) {
                $data['course_registrated_student'][$running_batch->course_id] = $this->batch_model->get_course_registarted_student($running_batch->course_id);
                $data['batch_created_by'][$running_batch->person_id] = $this->person_model->get_single_person_information_by_person_id($running_batch->person_id);
                $data['batch_resource_person'][$running_batch->resource_person_id] = $this->batch_model->get_resource_person_info($running_batch->resource_person_id);
                $data['student_number_in_batch'][$running_batch->course_batch_id] = $this->batch_model->count_number_of_student_in_batch($running_batch->course_batch_id);
            }
        }
        echo $this->load->view('user/batch/ajax_page/view_running_batch_course_wise', $data, TRUE);
    }

    /*
     * Function         : view_finished_batch_for_ajax_view
     * Used IN          : function[batch_pagination] controller[batch]
     * Description      : 
     * Parameter        :
     * return           :
     * redirect         :
     *  view            : user/batch/ajax_page/view_finished_batch 
     * Developed By     : Tania Akter
     * Date             : 
     */

    function view_finished_batch_course_wise($page, $limit, $person_id, $course_id) {
        $person_info = $this->person_model->get_single_person_information_by_person_id($person_id);    //person_info
        $data['course_id'] = $course_id;
        $data['page'] = $page;
        if ($person_info->person_role == 4) {   //person is organization
            $data['total_finished_batch'] = $this->batch_model->get_total_batch_status_course($person_id, 2, $course_id); //2= finished
            $data['finished_batch_info'] = $this->batch_model->get_batch_info_pagination_course($person_id, 2, $limit, $course_id); //2= finished batch      
            foreach ($data['finished_batch_info'] as $finished_batch) {
                $data['batch_created_by'][$finished_batch->person_id] = $this->person_model->get_single_person_information_by_person_id($finished_batch->person_id);
                $data['batch_resource_person'][$finished_batch->resource_person_id] = $this->batch_model->get_resource_person_info($finished_batch->resource_person_id);
                $data['student_number_in_batch'][$finished_batch->course_batch_id] = $this->batch_model->count_number_of_student_in_batch($finished_batch->course_batch_id);
            }
        } else if ($person_info->person_role == 3) {     //person is teacher
            $resource_person_info = $this->person_model->select_resource_person_information_by_person_id($person_id);
            $data['total_finished_batch'] = $this->batch_model->get_total_teacher_batch_status_course($resource_person_info->resource_person_id, 2, $course_id); //finished
            $data['finished_batch_info'] = $this->batch_model->get_teacher_batch_info_pagination_course($resource_person_info->resource_person_id, 2, $limit, $course_id); //finished
            foreach ($data['finished_batch_info'] as $finished_batch) {
                $data['batch_created_by'][$finished_batch->person_id] = $this->person_model->get_single_person_information_by_person_id($finished_batch->person_id);
                $data['batch_resource_person'][$finished_batch->resource_person_id] = $this->batch_model->get_resource_person_info($finished_batch->resource_person_id);
                $data['student_number_in_batch'][$finished_batch->course_batch_id] = $this->batch_model->count_number_of_student_in_batch($finished_batch->course_batch_id);
            }
        }
        echo $this->load->view('user/batch/ajax_page/view_finished_batch_course_wise', $data, TRUE);
    }

    /*
     * Function         : view_cancel_batch_for_ajax_view
     * Used IN          : function[batch_pagination] controller[batch]
     * Description      : 
     * Parameter        : $page, 
     *                    $limit, 
     *                    $person_id
     * return           : none
     * redirect         : none
     * view             : user/batch/ajax_page/view_cancel_batch
     * Developed By     : Tania Akter
     * Date             : 
     */

    function view_cancel_batch_course_wise($page, $limit, $person_id, $course_id) {
        $person_info = $this->person_model->get_single_person_information_by_person_id($person_id);    //person_info
        $data['course_id'] = $course_id;
        $data['page'] = $page;
        if ($person_info->person_role == 4) {   //person is organization
            $data['total_cancel_batch'] = $this->batch_model->get_total_batch_status_course($person_id, 3, $course_id); //3=cancel
            $data['cancel_batch_info'] = $this->batch_model->get_batch_info_pagination_course($person_id, 3, $limit, $course_id); //3=cancel batch      
            foreach ($data['cancel_batch_info'] as $cancel_batch) {
                $data['batch_created_by'][$cancel_batch->person_id] = $this->person_model->get_single_person_information_by_person_id($cancel_batch->person_id);
                $data['batch_resource_person'][$cancel_batch->resource_person_id] = $this->batch_model->get_resource_person_info($cancel_batch->resource_person_id);
                $data['student_number_in_batch'][$cancel_batch->course_batch_id] = $this->batch_model->count_number_of_student_in_batch($cancel_batch->course_batch_id);
            }
        } else if ($person_info->person_role == 3) {    //person is teacher
            $resource_person_info = $this->person_model->select_resource_person_information_by_person_id($person_id);
            $data['total_cancel_batch'] = $this->batch_model->get_total_teacher_batch_status_course($resource_person_info->resource_person_id, 3, $course_id); //3= cancel           
            $data['cancel_batch_info'] = $this->batch_model->get_teacher_batch_info_pagination_course($resource_person_info->resource_person_id, 3, $limit, $course_id); //3= cancel
            foreach ($data['cancel_batch_info'] as $cancel_batch) {
                $data['batch_created_by'][$cancel_batch->person_id] = $this->person_model->get_single_person_information_by_person_id($cancel_batch->person_id);
                $data['batch_resource_person'][$cancel_batch->resource_person_id] = $this->batch_model->get_resource_person_info($cancel_batch->resource_person_id);
                $data['student_number_in_batch'][$cancel_batch->course_batch_id] = $this->batch_model->count_number_of_student_in_batch($cancel_batch->course_batch_id);
            }
        }
        echo $this->load->view('user/batch/ajax_page/view_cancel_batch_course_wise', $data, TRUE);
    }

    /* ---------------------- end  06-09-2016 ------------------- */

    //18-09-2016
    function remove_assignd_student() {
        $this->batch_model->remove_assigned_student_from_batch();
    }

    function unassigned_student_list($course_url) {
        $data['course_info'] = $this->user_course_model->get_course_information_with_url_by_course_url($course_url);
        $data['main_content'] = $this->load->view('user/course/course_registered_student1', $data, true);
        $this->load->view('user/master', $data);
    }

    function get_batch_tab() {
        $tab = $this->session->userdata('batch_tab');
        if ($tab != '') {
            $tab = $this->session->userdata('batch_tab');
        } else {
            $tab = 'created';
        }
        return $tab;
    }

    /* ---------------------- Start Learner Batch (Front End) ------------------- */

    /**
     * @Function            : view_user_batch
     * @Used IN             : $route['learner-batch']
     * @Description         : Loads the view page for batch in user batch
     * @Developed By        : MD Mashqur Ul Alam
     * @Start DateTime      : 18-02-17
     * @Parameter           : Null
     * @Status              : Available       
     * */
    function view_learner_batch() {
        $data = $this->set_batch_side_menu();
        $data['batch_data'] = $this->get_batch_data();
        $data['main_content'] = $this->load->view('user/batch/view_learner_batch', $data, TRUE);
        $this->load->view('user/master', $data);
    }

    /**
     * @Function            : set_batch_side_menu
     * @Used IN             : view_user_batch
     * @Description         : sets the parameter for displaying side menu
     *                       in user batch view
     * @Developed By        : MD Mashqur Ul Alam
     * @Start DateTime      : 18-02-17
     * @Parameter           : Null
     * @Status              : Available
     * */
    function set_batch_side_menu() {
        $data['active_menu'] = 'learner';
        $data['active_sub_menu'] = 'learner_batch';
        $data['left_side_menu_view'] = 1;
        $data['left_side'] = 1;
        return $data;
    }

    /**
     * @Function            : get_learner_batch_details
     * @Used IN             : view_learner_batch
     * @Description         : get the learner batch details from datbase
     * @Developed By        : MD Mashqur Ul Alam
     * @Start DateTime      : 20-02-17
     * @Parameter           : Null
     * @Status              : Available       
     * */
    function get_batch_data() {
        $person_id = $this->session->userdata('person_id');
        $student_data = $this->batch_model->get_student_detail_by_person_id($person_id);
        if (!empty($student_data)) {
            $data = [];
            foreach ($student_data as $sdt) {                
                $batch_detail = $this->batch_model->get_learner_batch_detail($sdt->course_id, $sdt->student_id);
                foreach ($batch_detail as $bdtl) {
                    $data[$bdtl->course_batch_id]['batch_name'] = $bdtl->course_batch_name;
                    $data[$bdtl->course_batch_id]['batch_status'] = $this->batch_status_for_view($bdtl->course_batch_status);
                    $course_detail = $this->batch_model->get_learner_course_detail($sdt->course_id);
                    $data[$bdtl->course_batch_id]['course_title'] = $course_detail->course_name;
                    $data[$bdtl->course_batch_id]['course_url'] = $course_detail->url;
                    $resource_person = $this->batch_model->get_resource_person_detail_by_id($course_detail->resource_person_id);
                    $data[$bdtl->course_batch_id]['resource_person_name'] = $resource_person->person_first_name . ' ' . $resource_person->person_last_name;
                    $data[$bdtl->course_batch_id]['resource_person_url'] = $resource_person->url;
                    $course_by_detail = $this->batch_model->get_course_by_detail($course_detail->course_by_id);
                    $data[$bdtl->course_batch_id]['course_by_name'] = $course_by_detail->person_first_name . ' ' . $course_by_detail->person_last_name;
                    $data[$bdtl->course_batch_id]['course_by_url'] = $course_by_detail->url;
                    $data[$bdtl->course_batch_id]['course_registered_student'] = $this->batch_model->get_course_registered_student($sdt->course_id);
                    $data[$bdtl->course_batch_id]['certificate'] = $this->batch_model->get_certificate_student_roll($person_id, $bdtl->course_batch_id);
                }                
            }
            return $data;
        }
    }

    /**
     * @Function            : batch_status_for_view
     * @Used IN             : get_learner_batch_details
     * @Description         : Retrun the output string for batch status
     * @Developed By        : MD Mashqur Ul Alam
     * @Start DateTime      : 20-02-17
     * @Parameter           : $batch_status
     * @Status              : Available       
     * */
    function batch_status_for_view($batch_status) {
        switch ($batch_status) {
            case "1":
                return 'Running';
            case "2":
                return 'Finished';
            case "3":
                return 'Drop';
            case "4":
                return 'Upcoming';
            case "5":
                return 'Archieved';
            Default:
                return 'Undefined';
        }
    }

    /* ---------------------- End Learner Batch (Front End) ------------------- */
}
