<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Babbamamma extends CI_Controller {

    public function __construct() {
        parent::__construct();

        $person_id = $this->session->person_id;
        $person_status = $this->session->person_status;
        if ($person_id && ($person_status == 1)) {
            $person_role = $this->session->person_role;
            if (in_array($person_role, Array(1, 2, 6, 7, 8, 9))) {
                redirect('super-admin');
            } else {
                redirect();
            }
        }
    }

    /**
     * @Function            : index 
     * @Used IN             : @function-'get_course_value'  super_admin_course[@controller],
     * @Description         : view admin login page
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 11-05-2016 12:34 PM
     * @Parameter           : NULL
     * @View                : admin/admin_login.php
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available       
     * */
    public function index() {
        $this->load->view('admin/admin_login');
    }

    /**
     * @Function            : check_admin_login 
     * @Used IN             : @function-'admin/admin_login.php - [34]
     * @Description         : check admin login 
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 11-05-2016 12:34 PM
     * @Parameter           : NULL
     * @View                : NULL
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available       
     * */
    public function check_admin_login() {
        $person_email = $this->input->post('person_email', TRUE);
        $person_password = md5($this->input->post('person_password', TRUE));
        $person_info = $this->person_model->get_person_information_for_login($person_email, $person_password);
        $this->check_admin_login_validation($person_info);
    }

    /**
     * @Function            : check_admin_login_validation 
     * @Used IN             : @function-'check_admin_login'     this[@controller]
     * @Description         : check admin login 
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 11-05-2016 12:34 PM
     * @Parameter           : $person_info[ARRAY]
     * @View                : NULL
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function check_admin_login_validation($person_info) {
        $sdata = Array();
        if ($person_info) {
            if ($person_info->person_role == 3 || $person_info->person_role == 4 || $person_info->person_role == 5) {
                redirect('sign-in');
            }
            if ($person_info->person_status != 1) {
                $sdata['exception'] = 'Please contact support';
                $this->session->set_userdata($sdata);
                redirect('babbamamma');
            }
            if ($person_info->person_status == 1) {
                $this->login_admin_user($person_info);
            }
        } else {
            $sdata['exception'] = 'Your Email / Password Invalid !';
            $this->session->set_userdata($sdata);
            redirect('babbamamma');
        }
    }

    /**
     * @Function            : login_admin_user 
     * @Used IN             : @function-'check_admin_login_validation'     this[@controller]
     * @Description         : admin login user
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 11-05-2016 12:37 PM
     * @Parameter           : $person_info[ARRAY]
     * @View                : NULL
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function login_admin_user($person_info) {
        $person_time_zone = $this->input->post('person_time_zone', TRUE);
        $this->application_model->update_person_time_zone($person_info->person_id, $person_time_zone); // save person time in to database        
        $sdata['person_pc_info_id'] = $this->application_model->save_login_person_pc_information($person_info);
        $sdata['person_id'] = $person_info->person_id;
        $sdata['person_url'] = $person_info->url;
        $sdata['person_role'] = $person_info->person_role;
        $sdata['person_status'] = $person_info->person_status;
        $sdata['login_start_time'] = time();
        $_SESSION['login_person_url'] = $person_info->url;
        
        // Source Directory is not required anymore for File Manage
//        $directory = 'source/' . $person_info->url . '/';          // Make directory for uploaded tinymce file
//        if (!is_dir($directory)) {
//            mkdir($directory, 777, TRUE);
//        }
        $this->session->set_userdata($sdata);

        redirect('super-admin');
    }
}
