<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Application extends CI_Controller {

    public function __construct() {
        parent::__construct();
    }

    /**
     * @Function            : view_detail_quiz_result 
     * @Description         : displays quiz result in profile section 
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 21-01-17
     * @Parameter           : $quiz_public_id, $profile_url
     * @Return              : NULL    
     * @Status              : Available       
     * */
    public function view_detail_quiz_result($quiz_public_id, $profile_url) {
        $data = $this->welcome_model->generate_menu();
        $person_info = $this->person_model->get_single_person_information_by_person_url($profile_url);
        $person_id = $person_info->person_id;

        $data['active_menu'] = '';
        $data['active_sub_menu'] = '';
        $data['right_content_variation'] = 1; // for profile right content
        $data['profile_person_id'] = $person_id;

        $data['quiz_info'] = $this->quiz_model->select_quiz_by_public_id($quiz_public_id);
        $data['quiz_questions'] = $this->quiz_model->select_active_question_by_quiz_id($data['quiz_info']->quiz_id);
        $data['quiz_result'] = $this->quiz_model->select_quiz_result($person_id, $data['quiz_info']->quiz_id);
        if (!$data['quiz_info'] || !$data['quiz_questions'] || !$data['quiz_result']) {
            redirect('quizes/learner');
        }

        $data['correct_ans'] = $correct_ans = $data['quiz_result']->quiz_correct_answer;
        $data['wrong_ans'] = $wrong_ans = $data['quiz_result']->quiz_wrong_answer;
        $data['total_question'] = $total_question = $data['quiz_result']->quiz_total_question;
        $data['total_marks'] = $total_marks = $data['quiz_result']->quiz_total_marks;
        $data['receive_marks'] = $receive_marks = $data['quiz_result']->quiz_receive_marks;
        $data['taken_time'] = $taken_time = $data['quiz_result']->quiz_finish_time;
        if (!$correct_ans) {
            $correct_ans = 0;
        }
        if (!$wrong_ans) {
            $wrong_ans = 0;
        }
        if (!$receive_marks) {
            $receive_marks = 0;
        }

        $data['unanswered'] = $total_question - ($correct_ans + $wrong_ans);
        if ($total_question) {
            $data['correct_percentage'] = ($correct_ans * 100) / $total_question;
        } else {
            $data['correct_percentage'] = 0;
        }
        if ($total_marks) {
            $data['marks_percentage'] = ($receive_marks * 100) / $total_marks;
        } else {
            $data['marks_percentage'] = 0;
        }

        $data['main_content'] = $this->load->view('user/profile_view/profile_view_quiz_result', $data, true);
        $this->load->view('user/master', $data);
    }

    /**
     * @Function            : user_profile 
     * @Description         : View Profile as Public or login 
     * @Developed By        : Unknown
     * @Start DateTime      : Unknown
     * @Updated Date Time   : 01-08-2016 06:09 PM
     * @Updated By          : MD Jaherul Islam, Md Mashqur Ul Alam (01-12-16)
     * @Parameter           : $profile_url[STRING]
     * @Return              : NULL    
     * @Status              : Available       
     * */
    public function user_profile($profile_url) {

        $person_id = $this->session->userdata('user_id');
        $profile_id = $this->session->userdata('profile_id');       
        $data = $this->welcome_model->generate_menu();
        $data['person_info'] = $this->person_model->get_single_person_information_by_person_url($profile_url);
        if (!$data['person_info']) {
            redirect();
        }
        
        $sData['view_person_id'] = $data['person_info']->person_id;
        $sData['view_person_url'] = $data['person_info']->url;
        $sData['view_person_name'] = $data['person_info']->person_first_name;
        $this->session->set_userdata($sData);

        $data['active_menu'] = '';
        $data['active_sub_menu'] = '';
        $data['right_content_variation'] = 1; // for profile right content
        $data['profile_person_id'] = $data['person_info']->person_id;
        $data['today'] = $today = date('Y-m-d', time() - $this->session->userdata('time_offset'));
        $data['person_link'] = $this->post_model->get_all_link_by_person_id($data['person_info']->person_id);

        $quiz_data = $this->quiz_model->view_quiz_result_for_profile($data['person_info']->person_id, $data);
        $course_data = $this->profile_model->get_all_course_created_by_person_id($quiz_data, $quiz_data['person_info']->person_id);
        $link_data = $this->profile_model->get_total_friends($course_data, $course_data['person_info']->person_id);

        if ($person_id) {
            $link_data['person_link_info'] = $this->profile_model->person_link_info_by_link_person_id($link_data['person_info']->person_id);
        } else {
            $link_data['person_link_info'] = '';
        }
        $link_data['person_accepted_link'] = $this->profile_model->select_person_accepted_link($link_data['person_info']->person_id);
        $profiled_data = $this->profile_model->get_profiled_person_information($link_data, $data['person_info']->person_id);
        
        $profiled_data['viewer_info'] = '';
        $profiled_data['viewer_info'] = $this->profile_model->person_info_by_url($profile_id);

        if (isset($profiled_data['viewer_info'])) {
            if ($profiled_data['viewer_info']->person_role == 3 || $profiled_data['viewer_info']->person_role == 4 || $profiled_data['viewer_info']->person_role == 5) {
                if ($profiled_data['viewer_info']->person_view_profile_date != $today) {
                    $this->db->set('person_view_profile', NULL)
                            ->where('person_id', $profiled_data['viewer_info']->person_id)
                            ->update('tbl_person');
                    $profiled_data['viewer_info'] = $this->profile_model->person_info_by_url($profile_id);
                } else {
                    //Start Check Feature for Explore Expert Resume
                    $profiled_data['last_feature_detail'] = $result = $this->user_payment_model->select_last_feature_payment_info_by_id($this->session->userdata('person_id'));
                    $payment_id = $profiled_data['last_feature_detail']->payment_id;
                    $profiled_data['bill_payment_info'] = $this->user_payment_model->payment_info_by_payment_id($payment_id);
                    $profiled_data['total_paid'] = $this->user_payment_model->total_payment_info_by_payment_id($payment_id);

                    if ($profiled_data['last_feature_detail']->feature_price_expire_date < $today && $data['last_feature_detail']->feature_price_payment_status == 1) {
                        $profiled_data['feature_status'] = 'NeedUpdate';
                    }
                    if ($profiled_data['last_feature_detail']->payment_status != 1 && $data['last_feature_detail']->feature_price_payment_status == 2) {
                        $profiled_data['feature_status'] = 'NeedUpdate';
                    } else {
                        $profiled_data['feature_status'] = 'Updated';
                    }

                    $feature_price_id = explode(',', $profiled_data['viewer_info']->feature_price_id);

                    $profiled_data['explore_expert_resume_feature_info'] = $this->classroom_model->select_active_feature_by_feature_id($feature_price_id[2]);
                    if ($profiled_data['explore_expert_resume_feature_info']) {
                        $profiled_data['explore_expert_resume_per_day'] = $profiled_data['explore_expert_resume_feature_info']->explore_expert_resume_per_day;
                    } else {
                        $profiled_data['explore_expert_resume_per_day'] = 30;
                    }

                    $person_total_profile_view = count(explode(',', $data['viewer_info']->person_view_profile)) - 1;

                    if ($person_total_profile_view >= $profiled_data['explore_expert_resume_per_day'] && $profiled_data['viewer_info']->person_id != $this->session->userdata('person_id')) {
                        redirect($profiled_data['viewer_info']->url . '/profile');
                    }
                    //End Check Feature for Explore Expert Resume
                    if ($profiled_data['viewer_info']->person_id != $profiled_data['person_info']->person_id) {
                        $person_view_profile = $profiled_data['viewer_info']->person_view_profile;
                        if ($person_view_profile) {
                            if (strstr($profiled_data['person_info']->person_id, $profiled_data['viewer_info']->person_view_profile)) {
                                $person_view_profile = $person_view_profile . $profiled_data['person_info']->person_id . ',';
                            }
                        } else {
                            $person_view_profile = $profiled_data['person_info']->person_id . ',';
                        }
                        $this->db->set('person_view_profile_date', $today)
                                ->set('person_view_profile', $person_view_profile)
                                ->where('person_id', $profiled_data['viewer_info']->person_id)
                                ->update('tbl_person');
                    }
                }
            }
        }
        // data for change profile picture image gallery modal
        $profiled_data['content_result'] = $this->person_model->get_person_content_library_by_person_id($data['person_info']->person_id);
        $profiled_data['post_result'] = $this->post_model->get_person_post_details_by_person_id($data['person_info']->person_id, 4);

        // Following section added by Md Mashqur Ul Alam
        $profiled_data['profile_url'] = $profile_url;
        $profiled_data['profile_image'] = $data['person_info']->person_image;
        $profiled_data['resource_person_type'] = $this->person_model->get_resource_person_type($data['person_info']->person_id);
        $profiled_data['url_changed_data'] = $this->profile_model->check_profile_url_change_status($data);
        $profiled_data['current_city'] = $this->load->view('user/profile_view/dashboard/current_location', $profile_url, true);
        $profiled_data['travels'] = $this->load->view('user/profile_view/dashboard/travel_location', $profile_url, true);
        $profiled_data['connectivity'] = $this->load->view('user/profile_view/dashboard/links_network', $profile_url, true);
        $profiled_data['my_link'] = $this->load->view('user/profile_view/dashboard/my_link', $profile_url, true);
        $profiled_data['linked_person_id'] = $this->profile_model->get_linked_person_id($data['person_info']->person_id);
        
        $learner_course_data = $this->get_profile_learner_course_data($data['person_info']->person_id);
        $profiled_data['learner_course'] = $this->load->view('user/profile_view/dashboard/profile_learner_course', $learner_course_data, TRUE);
        $teacher_course_data = $this->profile_teacher_course_data($data['person_info']->person_id);
        $profiled_data['teacher_course'] = $this->load->view('user/profile_view/dashboard/profile_teacher_course', $teacher_course_data, TRUE);
        $organization_course_data = $this->get_organization_course_data($data['person_info']);
        if(isset($organization_course_data)){
            $profiled_data['organization_course'] = $this->load->view('user/profile_view/dashboard/profile_organization_course', $organization_course_data, TRUE);
        }else{
            $profiled_data['organization_course'] = '';
        }
        // Following section added by Md Delwar Hossain
        $profiled_data['profile_name'] = $data['person_info']->person_first_name . " " . $data['person_info']->person_last_name;
        $profiled_data['profile_url_link'] = base_url() . $profile_url . '/profile';
        $profiled_data['profile_image_link'] = base_url().'content-library/'.$profile_url.'/' . $data['person_info']->person_image;
        
        $user_public_work_education = $this->profile_model->user_public_work_education_details($data['person_info']->person_id);
        $profiled_data['user_public_work_education'] = $user_public_work_education;
        $profiled_data['user_public_work_education_detail'] = $this->user_public_work_education_details($profiled_data['user_public_work_education']);
        
        $profiled_data['profile_person_id'] = $data['person_info']->person_id;
        $profiled_data['public_post_note'] = $this->load->view('user/profile_view/dashboard/public_post_note', $profiled_data, true);
        $profiled_data['public_post_alert'] = $this->load->view('user/profile_view/dashboard/public_post_alert', $profiled_data, true);
        $profiled_data['public_post_assignment'] = $this->load->view('user/profile_view/dashboard/public_post_assignment', $profiled_data, true);
        $profiled_data['public_post_image'] = $this->load->view('user/profile_view/dashboard/public_post_image', $profiled_data, true);
        $profiled_data['public_post_video'] = $this->load->view('user/profile_view/dashboard/public_post_video', $profiled_data, true);

        //Profile Video Course Tab
        $teacher_video_course_data = $this->profile_teacher_video_course_data($data['person_info']->person_id);
        $profiled_data['teacher_video_course'] = $this->load->view('user/profile_view/dashboard/profile_teacher_video_course', $teacher_video_course_data, TRUE);
        $organization_video_course_data = $this->get_organization_video_course_data($data['person_info']);
        $profiled_data['organization_video_course'] = $this->load->view('user/profile_view/dashboard/profile_organization_video_course', $organization_video_course_data, TRUE);
        
        $profiled_data['main_content'] = $this->load->view('user/profile_view/profile', $profiled_data, true);
        $this->load->view('user/master', $profiled_data);
    }
    
    /*
     * @Function            : user_public_work_education_details @function 
     * @Used IN             : @function-'user_profile'  
     * @Description         : checks data for current education and work info
     * @Developed By        : Md. Delwar Hossain
     * @Start DateTime      : 22-3-17 10.00 AM
     * @Parameter           : $user_public_work_education_detail
     * @Return              : $data   
     * @Status              : available      
     */
    function user_public_work_education_details($user_public_work_education_detail){
        foreach ($user_public_work_education_detail['user_detail'] as $person_details) {
            $p_id = $person_details->person_id;
            $data[$p_id] = $person_details->person_id;
            
            if ($user_public_work_education_detail['user_public_work']) {
                foreach ($user_public_work_education_detail['user_public_work'] as $user_work) {
                    // checking work details exist for the certain id or not
                    if($user_work->person_id == $p_id){
                        //checking currently work here status
                        if($user_work->work_currently_here == 1 && $user_work->job_end_date == NULL){
                            $data['job_responsibility_details'] = $user_work->job_responsibility_details;
                            break;
                        } elseif($user_work->job_end_date != NULL) {
                            $data['job_responsibility_details'] = $user_work->job_responsibility_details;
                            break;
                        }
                        else{}
                    }
                }
            }
            elseif($user_public_work_education_detail['user_public_education']){
                foreach ($user_public_work_education_detail['user_public_education'] as $user_education) {
                    if($user_education->person_id == $p_id){
                        if($user_education->attended_for == 5 ){
                            $data['educational_description'] = $user_education->educational_description;
                            break;
                        }
                        elseif($user_education->attended_for == 4 ){
                            $data['educational_description'] = $user_education->educational_description;
                            break;
                        }
                        elseif($user_education->attended_for == 3 ){
                            $data['educational_description'] = $user_education->educational_description;
                            break;
                        }
                        elseif($user_education->attended_for == 2 ){
                            $data['educational_description'] = $user_education->educational_description;
                            break;
                        }
                        elseif($user_education->attended_for == 1 ){
                            $data['educational_description'] = $user_education->educational_description;
                            break;
                        }
                        else{}
                    }
                }
            }
        }
        return $data;
    }

    /**
     * @Function            : get_profile_learner_course_data
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 22-03-17
     * @Parameter           : $person_id
     * @Status              : Available       
     * */
    function get_profile_learner_course_data($person_id) {
        $data['learner'] = $this->profile_model->get_profile_learner_course($person_id);
        $total_row = $this->profile_model->get_profile_learner_course($person_id, '', TRUE);
        $params = array('url' => '', 'div_id' => 'learnerPagination', 'total_row' => $total_row, 'per_page' => 5, 'current_page' => 1, 'total_link' => 5);
        $data['learner_pagination'] = $this->tt_pagination->view_pagination_link($params);
        return $data;
    }

        /**
     * @Function            : get_profile_learner_course_ajax
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 22-03-17
     * @Parameter           : NULL
     * @Status              : Available       
     * */
    function get_profile_learner_course_ajax() {
        if ($this->input->is_ajax_request()) {
            $profile_url = $this->input->post('profile_url', TRUE);
            $current_page = $this->input->post('current_page', TRUE);
            $person_info = $this->person_model->get_single_person_information_by_person_url($profile_url);
            $ofsset = ($current_page * 5) - 5;
            $data['learner'] = $this->profile_model->get_profile_learner_course($person_info->person_id, $ofsset);
            $total_row = $this->profile_model->get_profile_learner_course($person_info->person_id, '', TRUE);
            $params = array('url' => '', 'div_id' => 'learnerPagination', 'total_row' => $total_row, 'per_page' => 5, 'current_page' => $current_page, 'total_link' => 5);
            $data['learner_pagination'] = $this->tt_pagination->view_pagination_link($params);
            echo $this->load->view('user/profile_view/dashboard/profile_learner_course', $data, TRUE);
        }
    }

    /**
     * @Function            : get_profile_teacher_course_ajax
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 22-03-17
     * @Parameter           : NULL
     * @Status              : Available       
     * */
    function get_profile_teacher_course_ajax() {
        if ($this->input->is_ajax_request()) {
            $profile_url = $this->input->post('profile_url', TRUE);
            $current_page = $this->input->post('current_page', TRUE);
            $person_info = $this->person_model->get_single_person_information_by_person_url($profile_url);
            $ofsset = ($current_page * 5) - 5;

            $resource_person_type = $this->person_model->get_resource_person_type($person_info->person_id);
            if (isset($resource_person_type) && (!empty($resource_person_type))) {
                $data['teacher']['course_detail'] = $this->profile_model->get_profile_teacher_course($person_info->person_id, $ofsset);
                foreach ($data['teacher']['course_detail'] as $course) {
                    if ($course->course_type == 1) {
                        $data['teacher']['price'][$course->course_id] = $this->get_course_price($course->course_id);
                    }
                    $data['teacher']['registered_students'][$course->course_id] = $this->profile_model->get_course_registered_student_number($course->course_id);
                }
                $total_row = $this->profile_model->get_profile_teacher_course($person_info->person_id, '', TRUE);
                $params = array('url' => '', 'div_id' => 'teacherPagination', 'total_row' => $total_row, 'per_page' => 5, 'current_page' => $current_page, 'total_link' => 5);
                $data['teacher_pagination'] = $this->tt_pagination->view_pagination_link($params);
                echo $this->load->view('user/profile_view/dashboard/profile_teacher_course', $data, TRUE);
            }
        }
    }

    /**
     * @Function            : profile_teacher_course_data
     * @Description         : get teacher course detail for profile
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 20-03-17
     * @Parameter           : $person_id
     * @Status              : Available       
     * */
    function profile_teacher_course_data($person_id) {
        $resource_person_type = $this->person_model->get_resource_person_type($person_id);
        if (isset($resource_person_type) && (!empty($resource_person_type))) {
            $data['teacher']['course_detail'] = $this->profile_model->get_profile_teacher_course($person_id);
            foreach ($data['teacher']['course_detail'] as $course) {
                if ($course->course_type == 1) {
                    $data['teacher']['price'][$course->course_id] = $this->get_course_price($course->course_id);
                }
                $data['teacher']['registered_students'][$course->course_id] = $this->profile_model->get_course_registered_student_number($course->course_id);
            }

            $total_row = $this->profile_model->get_profile_teacher_course($person_id, '', TRUE);
            $params = array('url' => '', 'div_id' => 'teacherPagination', 'total_row' => $total_row, 'per_page' => 5, 'current_page' => 1, 'total_link' => 5);
            $data['teacher_pagination'] = $this->tt_pagination->view_pagination_link($params);
            return $data;
        }
    }
    
    /*
     * @Function            : profile_teacher_course_data
     * @Description         : Get the price of a course
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 20-03-17
     * @Parameter           : $course_id
     * @Status              : Available       
     * */

    function get_course_price($course_id) {
        $price_info = $this->profile_model->get_course_price($course_id);
        if ($price_info->price_currency == 1) {
            return 'BDT ' . $price_info->price;
        } elseif ($price_info->price_currency == 2) {
            return 'USD ' . $price_info->price;
        }
    }

    
    /**
     * @Function            : get_profile_organization_course_ajax
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 22-03-17
     * @Parameter           : NULL
     * @Status              : Available       
     * */
    function get_profile_organization_course_ajax() {
        if ($this->input->is_ajax_request()) {
            $profile_url = $this->input->post('profile_url', TRUE);
            $current_page = $this->input->post('current_page', TRUE);
            $person_info = $this->person_model->get_single_person_information_by_person_url($profile_url);
            $offset = ($current_page * 5) - 5;      

            $organization_course = $this->get_organization_course_data($person_info, $offset, $current_page);
            echo $this->load->view('user/profile_view/dashboard/profile_organization_course', $organization_course, TRUE);
        }
    }

    /*
     * @Function            : get_organization_course_data
     * @Description         : checks organitaion organitaion and teacher type 
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 21-03-17
     * @Parameter           : $person_info
     * @Status              : Available       
     * */

    function get_organization_course_data($person_info, $offset = 0, $current_page = 1) {
        if ($person_info->person_role == 4) {
            $person_id = $person_info->person_id;            
        } elseif ($person_info->person_role == 3) {
            $resource_person_type = $this->person_model->get_resource_person_type($person_info->person_id, $offset);
            if ($resource_person_type == 1) {
                $person_id = 1;                
            } elseif ($resource_person_type == 3) {
                $person_id = $this->profile_model->get_org_id_by_teacher_id($person_info->person_id);               
            }
        }
        if(isset($person_id)){
        $data['organization'] = $this->get_profile_organization_course_data($person_id, $offset);
        $total_row = $this->profile_model->get_profile_organization_course($person_id, '', TRUE);
        $params = array('url' => '', 'div_id' => 'organizationPagination', 'total_row' => $total_row, 'per_page' => 5, 'current_page' => $current_page, 'total_link' => 5);
        $data['organization_pagination'] = $this->tt_pagination->view_pagination_link($params);        
        return $data;
        }
        
    }
        
    /*
     * @Function            : get_profile_organization_course_data
     * @Description         : get organization course detail for profile
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 21-03-17
     * @Parameter           : $org_person_id
     * @Status              : Available       
     * */

    function get_profile_organization_course_data($org_person_id, $offset) {
        $data['course_detail'] = $this->profile_model->get_profile_organization_course($org_person_id, $offset);
        foreach ($data['course_detail'] as $course) {
            if ($course->course_type == 1) {
                $data['price'][$course->course_id] = $this->get_course_price($course->course_id);
            }
            $data['registered_students'][$course->course_id] = $this->profile_model->get_course_registered_student_number($course->course_id);
        }
        return $data;
    }

    /**
     * @Function            : get_profile_teacher_video_course_ajax
     * @Developed By        : Md. Delwar Hossain
     * @Start DateTime      : 12-06-17
     * @Parameter           : NULL
     * @Status              : Available       
     * */
    function get_profile_teacher_video_course_ajax() {
        if ($this->input->is_ajax_request()) {
            $page_number = $this->input->post('page_number', TRUE);
            $person_id = $this->input->post('teacher_id', TRUE);
            $limit_offset = ($page_number * 5) - 5;
            
            $data['person_detail'] = $this->person_model->get_single_person_information_by_person_id($person_id);
            $resource_person_type = $this->person_model->get_resource_person_type($person_id);
            if (isset($resource_person_type) && (!empty($resource_person_type))) {
                $data['teacher']['video_course_detail'] = $this->profile_model->get_profile_teacher_video_course($person_id, $limit_offset);
    //            foreach ($data['teacher']['video_course_detail'] as $video_course) {
    //                $data['teacher']['registered_students'][$video_course->video_management_id] = $this->profile_model->get_course_registered_student_number($video_course->video_management_id);
    //            }

                $total_row = $this->profile_model->get_profile_teacher_video_course($person_id, '', TRUE);
                $params = array('url' => '', 'div_id' => 'teacherVideoCoursePagination', 'total_row' => $total_row, 'per_page' => 5, 'current_page' => $page_number, 'total_link' => 5);
                $data['teacher_video_course_pagination'] = $this->tt_pagination->view_pagination_link($params);
            
                echo $this->load->view('user/profile_view/dashboard/profile_teacher_video_course', $data, TRUE);
            }
        }
    }
    
    /**
     * @Function            : profile_teacher_video_course_data
     * @Description         : get teacher video course detail for profile
     * @Developed By        : Md. Delwar Hossain
     * @Start DateTime      : 12-06-17
     * @Parameter           : $person_id
     * @Status              : Available       
     * */    
    function profile_teacher_video_course_data($person_id){
        $data['person_detail'] = $this->person_model->get_single_person_information_by_person_id($person_id);
        $resource_person_type = $this->person_model->get_resource_person_type($person_id);
        if (isset($resource_person_type) && (!empty($resource_person_type))) {
            $data['teacher']['video_course_detail'] = $this->profile_model->get_profile_teacher_video_course($person_id);
//            foreach ($data['teacher']['video_course_detail'] as $video_course) {
//                $data['teacher']['registered_students'][$video_course->video_management_id] = $this->profile_model->get_video_course_registered_student_number($video_course->video_management_id);
//            }
            
            $total_row = $this->profile_model->get_profile_teacher_video_course($person_id, '', TRUE);
            $params = array('url' => '', 'div_id' => 'teacherVideoCoursePagination', 'total_row' => $total_row, 'per_page' => 5, 'current_page' => 1, 'total_link' => 5);
            $data['teacher_video_course_pagination'] = $this->tt_pagination->view_pagination_link($params);
            return $data;
        }
    }
    
    /**
     * @Function            : get_profile_organization_video_course_ajax
     * @Developed By        : Md. Delwar Hossain
     * @Start DateTime      : 13-06-17
     * @Parameter           : NULL
     * @Status              : Available       
     * */
    function get_profile_organization_video_course_ajax() {
        if ($this->input->is_ajax_request()) {
            $person_id = $this->input->post('org_id', TRUE);
            $current_page = $this->input->post('page_number', TRUE);
            $person_info = $this->person_model->get_single_person_information_by_person_id($person_id);
            $offset = ($current_page * 5) - 5;      

            $organization_video_course = $this->get_organization_video_course_data($person_info, $offset, $current_page);
            echo $this->load->view('user/profile_view/dashboard/profile_organization_video_course', $organization_video_course, TRUE);
        }
    }
    
    /*
     * @Function            : get_organization_video_course_data
     * @Description         : checks organization organization and teacher type 
     * @Developed By        : Md. Delwar Hossain
     * @Start DateTime      : 13-06-17
     * @Parameter           : $person_info
     * @Status              : Available       
     * */
    function get_organization_video_course_data($person_info, $offset = 0, $current_page = 1) {
        if ($person_info->person_role == 4) {
            $person_id = $person_info->person_id;            
        } elseif ($person_info->person_role == 3) {
            $resource_person_type = $this->person_model->get_resource_person_type($person_info->person_id, $offset);
            if ($resource_person_type == 1) {
                $person_id = 1;                
            } elseif ($resource_person_type == 3) {
                $person_id = $this->profile_model->get_org_id_by_teacher_id($person_info->person_id);               
            }
        }
        if(isset($person_id)){
        $data['person_detail'] = $person_info;
        $data['organization'] = $this->get_profile_organization_video_course_data($person_id, $offset);
        $total_row = $this->profile_model->get_profile_organization_video_course($person_id, '', TRUE);
        $params = array('url' => '', 'div_id' => 'organizationVideoCoursePagination', 'total_row' => $total_row, 'per_page' => 5, 'current_page' => $current_page, 'total_link' => 5);
        $data['organization_video_course_pagination'] = $this->tt_pagination->view_pagination_link($params);        
        return $data;
        }
    }
    
    /*
     * @Function            : get_profile_organization_video_course_data
     * @Description         : get organization course detail for profile
     * @Developed By        : Md. Delwar Hossain
     * @Start DateTime      : 13-06-17
     * @Parameter           : $org_person_id
     * @Status              : Available       
     * */
    function get_profile_organization_video_course_data($org_person_id, $offset) {
        $data['video_course_detail'] = $this->profile_model->get_profile_organization_video_course($org_person_id, $offset);
//        foreach ($data['video_course_detail'] as $video_course) {
//            $data['registered_students'][$video_course->video_management_id] = $this->profile_model->get_video_course_registered_student_number($video_course->video_management_id);
//        }
        return $data;
    }

    
    /**
     * @Function            : delete_draft_post 
     * @Used IN             : @function-'check_login'   this[@Controller]
     * @Description         : if user post any file but does not submit
     * @Developed By        : Mohammad Jaherul Islam
     * @Start DateTime      : 18-04-2016 06:26 PM  
     * @Parameter           : NULL
     * @Return              : None    
     * @Status              : Available        
     * */
    function delete_draft_post() {        
        $current_date = date('Y/m/d H:i:s');
        $result = $this->utility_model->get_date_different_with_current_date($current_date);

        foreach ($result as $value) {
            if ($value->DiffDate > 1) {
                $result1 = $this->person_model->get_single_person_information_by_person_id($value->posted_by);
                $file_path = $folder = 'content-library/' . $result1->url . '/' . $value->post_details;
                if (file_exists($file_path)) {
                    unlink($file_path);
                }
                $this->utility_model->delete_information_in_database('tbl_post', 'post_id', $value->post_id);
            }
        }
    }

    /*
      -----------@@@TANIA@ Start Contact Part----------------------------------
     */

    /**
     * @Function            : contact
     * @Used IN             : $route['contact'] = "application/contact";   line-25
     * @Description         : This function is used to load contact page 
     * @Developed By        : Tania Akter
     * @Start DateTime      : 25/04/2016  
     * @Status              : available      
     * */
    public function contact() {
        $user_id = $this->session->userdata('user_id');
        $this->contact_form_validation();
        if ($this->form_validation->run() == FALSE) {
            $data = $this->welcome_model->generate_menu();  //used to view mega menu 
            $data['right_content_variation'] = 0;
            //$data['captcha'] = $this->sign_up_model->generate_captcha();
            $data['main_content'] = $this->load->view('front_end/contact/contact_form', $data, TRUE);
            if ($user_id) {
                $this->load->view('user/master', $data);
            } else {
                $this->load->view('front_end/master', $data);
            }
        } else {
            $sdata = array();
            $sdata['message'] = 'Your request has been send. We will contact you soon';
            $this->session->set_userdata($sdata);
            $this->mailer_model->send_contact_email_user('contact_email_user');
            $this->mailer_model->send_contact_email_talhatraining('contact_email_for_talhatraining');
            redirect('contact');
        }
    }

    /**
     * @Function            : contact_form_validation
     * @Used IN             : function[] controller[]
     * @Description         : This function is used to  contact form validation 
     * @Developed By        : Tania Akter
     * @Start DateTime      : 30/05/2016  
     * @Status              : available      
     * */
    function contact_form_validation() {
        $this->form_validation->set_rules('select_contact_for', 'Contact For', 'required|callback_select_contact_reason');

        $this->form_validation->set_rules('describe_request', 'Describe Request', 'required');
        $this->form_validation->set_rules('person_name', 'Person Name', 'required|trim|max_length[100]|callback_check_contact_person_name');
        $this->form_validation->set_rules('email_address', 'Email', 'required|trim|max_length[256]|callback_contact_email_check');
        $this->form_validation->set_rules('person_country', 'Country', 'required');
        $this->form_validation->set_rules('person_contact_number', 'Person Contact', 'required|numeric|max_length[16]|trim');
        $this->form_validation->set_rules('google_captcha', 'google_captcha', 'required');
        //$this->form_validation->set_rules('captcha', 'captcha', 'required|trim|strip_tags|callback_captcha_check_contact');
    }

    /**
     * @Function            : select_contact_reason
     * @Used IN             : function[contact_form_validation] controller[application]
     * @Description         : This function is used to  contact reason  validation 
     * @Developed By        : Tania Akter
     * @Start DateTime      : 30/05/2016  
     * @Status              : available      
     * */
    function select_contact_reason($select_contact_for) {
        if ($select_contact_for == 1 || $select_contact_for == 2 || $select_contact_for == 3 || $select_contact_for == 4 || $select_contact_for == 5 || $select_contact_for == 6) {
            return TRUE;
        } else {
            $this->form_validation->set_message('select_contact_reason', "<span style=color:red>Please select contact for</span>");
            return FALSE;
        }
    }

    /**
     * @Function            : check_contact_person_name
     * @Used IN             : function[contact_form_validation] controller[application]
     * @Description         : This function is used to  person name validation 
     * @Developed By        : Tania Akter
     * @Start DateTime      : 30/05/2016  
     * @Status              : available      
     * */
    function check_contact_person_name($person_name) {
        $sp = '/[^A-Za-z \- \.]/';
        if (!preg_match($sp, $person_name)) {
            return TRUE;  // person name ok no need to show error( validation message)
        } else {
            $this->form_validation->set_message('check_contact_person_name', "Person Name can't contain special Character");
            return FALSE; // it show error( validation message)
        }
    }

    /**
     * @Function            : contact_email_check
     * @Used IN             : function[contact_form_validation] controller[application]
     * @Description         : This function is used to email validation 
     * @Developed By        : Tania Akter
     * @Start DateTime      : 30/05/2016  
     * @Status              : available      
     * */
    function contact_email_check($contact_person_email) {
        $sp = '/^(([^<>()[\]\\.,;:\s@\"]+(\.[^<>()[\]\\.,;:\s@\"]+)*)|(\".+\"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/';
        if (preg_match($sp, $contact_person_email)) {
            return TRUE;  // person name ok no need to show error( validation message)  
        } else {
            $this->form_validation->set_message('contact_email_check', "Invalid email address");
            return FALSE; // it show error( validation message)   
        }
    }

    
    /*
      -----------@@@TANIA@ End Contact Part----------------------------------
     */



    /*
      -----------@@@RIPON@ Start URL Function Part----------------------------------
     */

    /**
     * @Function            : url_function 
     * @Used IN             : @function-'get_course_value'  super_admin_course[@controller],
     * @Description         : get url and using different function
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 04-05-2016 09:43 AM
     * @Updated Date Time   : 02-02-2016 01:38 PM
     * @Updated By          : MD Jaherul Islam
     * @Parameter           : NULL
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function url_function() {
        $url1 = $this->uri->segment(1);
        $url2 = $this->uri->segment(2);
        if ($url2) {
            $url_info = $this->url_model->get_single_url_information($url2);
        } else {
            $url_info = $this->url_model->get_single_url_information($url1);
        }
        $this->view_url_value($url_info);
    }

    /**
     * @Function            : view_url_value 
     * @Used IN             : @function-'url_function'     this[@controller],
     * @Description         : get url and using different function
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 04-05-2016 10:10 AM
     * @Parameter           : $url_info[ARRAY]
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function view_url_value($url_info) {
        if ($url_info) {
            switch ($url_info->url_type) {
                case 1:
                    $this->public_menu_view($url_info->url);
                    break;
                case 2:
                    $this->view_public_group($url_info->url);
                    break;
                case 3:
                    $this->view_public_category($url_info->url);
                    break;
                case 4:
                    $this->view_public_quiz();
                    break;
                case 5:
                    $this->single_course_view($url_info->url);
                    break;
                case 8:
                    $this->video_course($url_info->url);
                    break;
                case 10:
                    $this->video_profile($url_info->url);
                    break;
                case 11:
                    $this->start_class($url_info->url);
                    break;
                default :
                    $this->invalid_url();
                    break;
            }
        } else {
            $this->invalid_url();
        }
    }

    /*
      -----------@@@RIPON@ End URL Function Part----------------------------------
     */

    /**
     * @Function            : public_menu_view 
     * @Used IN             : @function-'view_url_value'     this[@controller],
     * @Description         : get url for view public quiz
     * @Developed By        : MD Jaherul Islam
     * @updated By          : Md Mashqur Ul Alam 16-03-17
     * @Start DateTime      : 04-05-2016 11:30 AM
     * @Parameter           : $url[STRING]
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function public_menu_view($url) {
        $menu_info = $this->super_admin_model->check_menu_url_for_public_view($url);
        if ($menu_info) {
            $course_info = $this->utility_model->get_single_table_information('*', 'tbl_course', 'url_id', $menu_info->url_id);

            if (isset($course_info)) {
                $this->course_public_view($url);
            }

            $video_course_info = $this->user_video_model->get_single_public_video_course_by_menu_id($menu_info->menu_id);
            if ($video_course_info) {
                $this->video_course($video_course_info->url);
            }

            if (!$course_info && !$video_course_info) {
                redirect();
            }
        } else {
            redirect();
        }
    }

    /**
     * @Function            : view_public_group 
     * @Used IN             : @function-'view_url_value'     this[@controller],
     * @Description         : get url for view public group
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 04-05-2016 01:00 AM
     * @Parameter           : $url[STRING]
     * @Return              : NULL    
     * @Status              : Available       
     * */
    public function view_public_group($url) {
        redirect('group/' . $url);
    }

    /**
     * @Function            : view_public_category 
     * @Used IN             : @function-'view_url_value'     this[@controller],
     * @Description         : get url for view public course by category wise
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 04-05-2016 01:12 AM
     * @Parameter           : $url[STRING]
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function view_public_category($url) {
        redirect('course/' . $url);
    }

    /**
     * @Function            : view_public_quiz 
     * @Used IN             : @function-'view_url_value'     this[@controller],
     * @Description         : get url for view public quiz
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 04-05-2016 02:23 AM
     * @Parameter           : $url[STRING]
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function view_public_quiz() {
        redirect('all-quiz');
    }

    /**
     * @Function            : single_course_view 
     * @Used IN             : @function-'view_url_value'     this[@controller],
     * @Description         : view single course view
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 27-08-2016 09:27 AM
     * @Parameter           : $url[STRING]
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function single_course_view($url) {
        $this->course_public_view($url);
    }

    /**
     * @Function            : view_public_quiz 
     * @Used IN             : @function-'view_url_value'     this[@controller],
     * @Description         : get url for view public quiz
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 04-05-2016 02:23 AM
     * @Parameter           : $url[STRING]
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function video_profile($url) {
        redirect($url . '/profile');
    }

    /**
     * @Function            : start_class 
     * @Used IN             : @function-'view_url_value'     this[@controller],
     * @Description         : get url for view public quiz
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 04-05-2016 03:00 PM
     * @Parameter           : $url[STRING]
     * @Return              : NULL    
     * @Status              : Available       
     * */
    public function start_class($url) {
        redirect('start-class/' . $url);
    }

    /**
     * @Function            : invalid_url 
     * @Used IN             : @function-'url_function'      this[@controller]
     * @Description         : View if user get invalid url
     * @Developed By        : Mohammad Jaherul Islam
     * @Start DateTime      : 10-04-2016 10:53 PM
     * @Parameter           : None
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function invalid_url() {
        $data = $this->welcome_model->generate_menu();
        $data['meta_description'] = '';
        $data['meta_keywords'] = '';
        $data['author'] = '';
        $data['active'] = '';
        $data['right_content_variation'] = 0;
        $person_id = $this->session->userdata('person_id');
        $person_role = $this->session->userdata('person_role');

        if ($person_role == 1 || $person_role == 2 || $person_role == 6) {
            redirect('super_admin/error');
        } else {
            $data['main_content'] = $this->load->view('error_page', $data, TRUE);
            if ($person_id) {
                $this->load->view('user/master', $data);
            } else if (!$person_id) {
                $this->load->view('front_end/master', $data);
            }
        }
    }

    /*
      -----------@@@RIPON@ Start Single Course public View Part----------------------------------
     */

    /*
      -----------@@@RIPON@ Start Course Single Public View Part(27-08-16)----------------------------------
     */

    /**
     * @Function            : course_public_view 
     * @Used IN             : @function-'view_url_value'     this[@controller],
     * @Description         : view public course
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 26-08-2016 04:40 PM
     * @Parameter           : $url[STRING]
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function course_public_view($url) {
        $data = Array();
        $data['course_info'] = $this->user_course_model->get_course_information_with_url_by_course_url($url);
        if (!$data['course_info']) {
            redirect();
        }

        $person_id = $this->session->userdata('person_id');
        $data['course_creator_info'] = $this->utility_model->get_single_table_information('person_first_name,person_last_name', 'tbl_person', 'person_id', $data['course_info']->course_creator_id);

        if ($person_id && in_array($data['course_info']->course_access_level, Array(1, 2))) {
            $result = $this->course_model->check_course_authentication_for_public_view($person_id, $data['course_info']->course_creator_id, $data['course_info']->resource_person_id, $data['course_info']->course_status);

            (in_array($result, Array(1, 2))) ? $this->view_single_course($person_id, $data, $result) : redirect();
        } else if (!$person_id && ($data['course_info']->course_access_level == 1)) {
            (in_array($data['course_info']->course_status, Array(1, 4))) ? $this->view_single_course($person_id, $data, 2) : redirect();
        } else {
            redirect();
        }
    }

    /**
     * @Function            : view_single_course 
     * @Used IN             : @function-'view_url_value'     this[@controller],
     * @Description         : view single public course
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 27-08-2016 11:03 AM
     * @Parameter           : $data[Array], $status[INTEGER]
     * @Return              : NULL    
     * @Status              : Available       
     * */
    public function view_single_course($person_id, $data, $status) {
        if ($status == 2) {
            $this->course_model->count_course_view($data['course_info']->course_id);
        }
        $menu_data = $this->welcome_model->generate_menu();
        $merge_data = array_merge($data, $menu_data);
        $merge_data['status'] = $status;
        $merge_data['right_content_variation'] = 0;
        $merge_data['content_variable'] = 'course_view_content';

        if ($merge_data['course_info']->course_type == 1) {
            $merge_data['price_info'] = $this->price_model->get_single_price_information(1, $merge_data['course_info']->course_id);
        }
        $work_file_data = $this->work_file_model
                        ->set_course_id($merge_data['course_info']->course_id)->set_data($merge_data)->work_file_for_course_details();

        $work_file_data['course_quiz_file'] = '';

        $work_file_data['main_content'] = $this->load->view('front_end/course_detail', $work_file_data, true);
        if ($person_id) {
            $this->load->view('user/master', $work_file_data);
        } else if (!$person_id) {
            $this->load->view('front_end/master', $work_file_data);
        }
    }

    /*
      -----------@@@RIPON@ End Course Single Public View Part(27-08-16)----------------------------------
     */

    /*
      -----------@@@RIPON@ Start Single Video Course public View Part----------------------------------
     */

    /**
     * @Function            : video_course 
     * @Used IN             : @function-'url_function'      this[@controller]
     * @Description         : View public video course  
     * @Developed By        : Mohammad Jaherul Islam
     * @Start DateTime      : 10-04-2016 10:53 PM
     * @Parameter           : video_url[STRING]
     * @View                : None
     * @Redirect            : None OR view_video_course()
     * @Return              : NULL    
     * @Status              : Available       
     * */
    public function video_course($video_url) {
        $data = $this->welcome_model->generate_menu();
        $data['tab'] = '1'; //for default Tab open (course details)
        $data['video_course_info'] = $this->user_video_model->get_single_video_course_information_by_url($video_url);
        if (!$data['video_course_info']) {
            redirect();
        }

        $person_id = $this->session->userdata('person_id');
        if ($person_id) { // only for login user
            if ($data['video_course_info']->video_management_status == 1 || $data['video_course_info']->video_management_status == 4) {
                $this->check_login_user_authentication_for_view_video_course($person_id, $data, 1);  // if video course are active OR apporved
            } else {
                $this->check_login_user_authentication_for_view_video_course($person_id, $data, 2);  // if video course are not active OR apporved
            }
        } else {  // without login
            if ($data['video_course_info']->video_management_status == 1 || $data['video_course_info']->video_management_status == 4) {
                $this->view_video_course($data, 1); // if video course status are published OR apporved
            } else {
                redirect();  // else redirect to home page
            }
        }
    }

    /**
     * @Function            : check_login_user_authentication_for_view_video_course 
     * @Used IN             : @function-'video_course'      this[@controller],
     * @Description         : check login user authentication for view video course  
     * @Developed By        : Mohammad Jaherul Islam
     * @Start DateTime      : 10-04-2016 12:00 PM
     * @Parameter           : $person_id[INTEGER],$data[ARRAY],$status[INTEGER]
     * @View                : None
     * @Redirect            : Home Page OR View_video_course
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function check_login_user_authentication_for_view_video_course($person_id, $data, $status) {
        $result = $this->person_model->check_user_authentication_for_view_video_course($person_id, $data['video_course_info']->course_creator_id, $data['video_course_info']->resource_person_id);
        if ($status == 1) {   // for published or apporved video course
            if ($result == 1) {
                $this->view_video_course($data, 2);  // if peroson is super Admin OR Admin OR course creator OR org_teacher OR assigned resource person 
            } else if ($result == 2) {
                $this->view_video_course($data, 1);
            }
        } else if ($status == 2) {   // for not published or apporved video course
            if ($result == 1) {
                $this->view_video_course($data, 2);   // if peroson is super Admin OR Admin OR course creator OR org_teacher OR assigned resource person
            } else if ($result == 2) {
                redirect();
            }
        }
    }

    /**
     * @Function            : view_video_course 
     * @Used IN             : @function-'video_course'     this[@controller],
     * @Description         : view video course
     * @Developed By        : Mohammad Jaherul Islam
     * @Start DateTime      : 10-04-2016 04:04 AM 
     * @Parameter           : $data[ARRAY],$sataus[INTEGER]
     * @View                : video_course_details.php
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available       
     * */
    public function view_video_course($data, $status) {
        $person_id = $this->session->userdata('person_id');
        $video_access_permission = $this->user_video_model->check_video_course_access_level($person_id, $data);
        $data['free_video_info'] = '';
        $data['right_content_variation'] = 0;

        if ($status == 1) {
            $this->update_video_course_view($data['video_course_info']->video_management_id, $data['video_course_info']->video_course_view);
        }

        $data['course_creator_url'] = $this->utility_model->get_profile_url($data['video_course_info']->course_creator_id);
        $free_video_info = $this->user_video_model->get_single_free_video_information_by_video_course_id($data['video_course_info']->video_management_id);
        if ($free_video_info) {
            if ($free_video_info->upload_video_status == 1) {
                $data['free_video_info'] = $free_video_info;
            } else {
                if ($video_access_permission == 1) { //  for authorize user
                    $data['free_video_info'] = $free_video_info;
                } else if ($video_access_permission == 2) { //  for non authorize user
                    $data['free_video_info'] = '';
                }
            }
        }

        if ($video_access_permission == 1) {  //  for authorize user
            $data['all_section'] = $this->user_video_model->select_all_video_course_section_by_video_course_id($data['video_course_info']->video_management_id);
        } else if ($video_access_permission == 2) {  //  for non authorize user
            $data['all_section'] = $this->user_video_model->select_active_video_course_section_by_video_course_id($data['video_course_info']->video_management_id);
        }

        if ($data['all_section']) {
            foreach ($data['all_section'] as $section_value) {
                if ($video_access_permission == 1) { //  for authorize user
                    $data['upload_video_info'][$section_value->upload_video_section_name] = $this->user_video_model->get_all_upload_id_by_section_name1($data['video_course_info']->video_management_id, $section_value->upload_video_section_name);
                } else if ($video_access_permission == 2) { //  for non authorize user
                    $data['upload_video_info'][$section_value->upload_video_section_name] = $this->user_video_model->get_active_upload_id_by_section_name($data['video_course_info']->video_management_id, $section_value->upload_video_section_name);
                }
            }
        }

        if ($video_access_permission == 1) { //  for authorize user
            $data['total_uploaded_video'] = $this->user_video_model->get_total_uploaded_video_by_video_course_id($data['video_course_info']->video_management_id, 1);
            $data['total_video_duration'] = $this->user_video_model->get_total_uploaded_video_duration_by_video_course_id($data['video_course_info']->video_management_id, 1);
            $data['all_work_file'] = $this->user_video_model->select_all_work_file_by_video_course_id($data['video_course_info']->video_management_id, 1);
        } else if ($video_access_permission == 2) { //  for non authorize user
            $data['total_uploaded_video'] = $this->user_video_model->get_total_uploaded_video_by_video_course_id($data['video_course_info']->video_management_id, 2);
            $data['total_video_duration'] = $this->user_video_model->get_total_uploaded_video_duration_by_video_course_id($data['video_course_info']->video_management_id, 2);
            $data['all_work_file'] = $this->user_video_model->select_all_work_file_by_video_course_id($data['video_course_info']->video_management_id, 2);
        }

//        $data['course_quiz'] = $this->quiz_model->select_video_course_quiz_permission($data['video_course_info']->video_management_id);
//        $data['quiz_info'] = '';
//        if ($data['course_quiz']) {
//            $data['quiz_info'] = $this->quiz_model->select_active_quiz_by_id($data['course_quiz']->quiz_id);
//            if ($data['quiz_info']) {
//                $data['creator_info'] = $this->person_model->get_single_person_information_by_person_id($data['quiz_info']->person_id);
//                $data['first_question'] = $this->quiz_model->select_quiz_first_question($data['quiz_info']->quiz_id);
//            }
//        }

        $data['all_registered_student'] = $this->registration_model->select_all_course_registered_student($data['video_course_info']->video_management_id, 2);
        $data['video_course_info']->video_training_objectives = $this->tinymce_model->changed_text_to_special_character($data['video_course_info']->video_training_objectives);
        $data['video_course_info']->video_training_outline = $this->tinymce_model->changed_text_to_special_character($data['video_course_info']->video_training_outline);        
        $data['main_content'] = $this->load->view('front_end/video_course_detail', $data, true);
        if ($person_id) {
            $this->load->view('user/master', $data);
        } else if (!$person_id) {
            $this->load->view('front_end/master', $data);
        }
    }

    /**
     * @Function            : get_uploaded_video_by_search 
     * @Used IN             : @function-'front_end/video_course_details.php, [100]
     * @Description         : search uploaded video
     * @Developed By        : Mohammad Jaherul Islam
     * @Start DateTime      : 12-04-2016 04:07 AM 
     * @Parameter           : None
     * @View                : front_end/ajax_page/view_video_side_menu.php
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function get_uploaded_video_by_search() {
        $person_id = $this->session->userdata('person_id');
        $video_course_id = $this->input->post('video_course_id', TRUE);
        $data['video_course_info'] = $this->user_video_model->get_single_video_course_information_by_id($video_course_id);
        $video_access_permission = $this->user_video_model->check_video_course_access_level($person_id, $data);

        $search_input = $this->input->post('search_input', TRUE);
        if ($video_access_permission == 1) {  //  for authorize user
            $data['all_section'] = $this->user_video_model->select_all_video_course_section_by_search($video_course_id, $search_input, 1);
        } else if ($video_access_permission == 2) {  //  for non authorize user
            $data['all_section'] = $this->user_video_model->select_all_video_course_section_by_search($video_course_id, $search_input, 2);
        }

        if ($data['all_section']) {
            foreach ($data['all_section'] as $section_value) {
                if ($video_access_permission == 1) { //  for authorize user
                    $data['upload_video_info'][$section_value->upload_video_section_name] = $this->user_video_model->get_all_upload_video_info_by_search($video_course_id, $section_value->upload_video_section_name, $search_input, 1);
                } else if ($video_access_permission == 2) { //  for non authorize user
                    $data['upload_video_info'][$section_value->upload_video_section_name] = $this->user_video_model->get_all_upload_video_info_by_search($video_course_id, $section_value->upload_video_section_name, $search_input, 2);
                }
            }
        }
        echo $this->load->view('front_end/ajax_page/view_video_side_menu', $data, true);
    }

    /**
     * @Function            : update_video_course_view 
     * @Used IN             : @function-'view_video_course, this[@controller]  [1770]
     * @Description         : update video course view
     * @Developed By        : Mohammad Jaherul Islam
     * @Start DateTime      : 12-04-2016 12:42 AM 
     * @Parameter           : $video_course_id[INTEGER], $video_course_view[INTEGER]
     * @View                : None
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function update_video_course_view($video_course_id, $video_course_view) {
        if ($video_course_view != '') {
            $vData['video_course_view'] = ++$video_course_view;
        } else {
            $vData['video_course_view'] = 1;
        }
        $this->utility_model->update_information_in_database('tbl_video_management', 'video_management_id', $video_course_id, $vData);
    }

    /**
     * @Function            : get_single_uploaded_vedio_by_upload_video_id 
     * @Used IN             : @function-'front_end/video_course_details.php, [132]
     * @Description         : get single uploaded video by upload_video_id
     * @Developed By        : Mohammad Jaherul Islam
     * @Start DateTime      : 11-04-2016 03:22 AM 
     * @Parameter           : None
     * @View                : front_end/ajax_page/view_single_video_course.php
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function get_single_uploaded_vedio_by_upload_video_id() {
        $upload_video_id = $this->input->post('upload_video_id', TRUE);
        $data['upload_video_info'] = $this->user_video_model->get_upload_video_information_by_upload_video_id($upload_video_id);
        $data['course_creator_url'] = $this->utility_model->get_profile_url($data['upload_video_info']->course_creator_id);
        echo $this->load->view('front_end/ajax_page/view_single_video_course', $data, true);
    }

    /**
     * @Function            : download_video_course_work_file 
     * @Used IN             : @function-'front_end/video_course_details.php, [274]
     * @Description         : download video course work file 
     * @Developed By        : Mohammad Jaherul Islam
     * @Start DateTime      : 11-04-2016 05:58 AM 
     * @Parameter           : $work_file_id[INTEGER]
     * @View                : None
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function download_video_course_work_file($work_file_id) {
        $work_file_info = $this->user_video_model->get_upload_video_work_file_info_by_work_file_id($work_file_id);
        $course_creator_url = $this->utility_model->get_profile_url($work_file_info->course_creator_id);

        $this->load->helper('download');
        $work_file_name1 = explode('/', $work_file_info->work_files_url);
        $work_file_name = $work_file_name1[4]; //to view work file extension
        $files_url = 'content-library/' . $course_creator_url . $work_file_info->work_files_url;
        $data = file_get_contents("$files_url");
        if ($data) {
            force_download($work_file_name, $data);
        } else {
            return;
        }
    }

    /*
      -----------@@@RIPON@ Start Single Video Course public View Part----------------------------------
     */

    /*
      -----------@@@RIPON@ Start public search View Part----------------------------------
     */

    /**
     * @Function            : view_searched_value 
     * @Used IN             : @function-'front_end/master/header_menu.php'
     * @Description         : view search value
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 27-03-2016 09:00 AM     
     * @Status              : available      
     * */
    public function view_searched_information() {
        $this->load->model('all_video_course_model');
        $data = Array();
        $search_value = preg_replace('/\s+/', ' ', trim($this->input->post('search_value', TRUE)));
        if ($search_value != '') {
            $person_data = $this->person_model->get_person_value_by_search($data, $search_value, 0, 2);
            $course_data = $this->course_model->get_course_value_by_search($person_data, $search_value, 0, 2);
            $video_course_data = $this->user_video_model->get_video_course_value_by_search($course_data, $search_value, 0, 2);
            $group_data = $this->group_model->get_group_value_by_search($video_course_data, $search_value, 0, 2);
            $quiz_data = $this->quiz_model->get_quiz_value_by_search($group_data, $search_value, 0, 2);
            if ($quiz_data) {
                $quiz_data['search_value'] = $search_value;
                echo $this->load->view('front_end/ajax_page/view_searched_info', $quiz_data, TRUE);
            } else {
                echo 'no';
            }
        } else {
            echo 'no';
        }
    }

    /**
     * @Function            : get_more_search_information 
     * @Used IN             : @function-'front_end/ajax/view_searched_info.php'
     * @Description         : view search value
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 27-03-2016 09:00 AM     
     * @Status              : available      
     * */
    function get_more_search_information() {
        $data['type'] = $this->input->post('type', TRUE);
        $data['counter'] = $this->input->post('counter', TRUE);
        $data['search_value'] = $this->input->post('search_value', TRUE);

        switch ($data['type']) {
            case 'person':
                $data['searched_person'] = $this->person_model->get_searched_person_information($data['search_value'], $data['counter'], $data['counter'] + 10);
                $data['total_searched_person'] = $this->person_model->get_total_searched_person_information($data['search_value']);
                break;
            case 'course':
                $data['searched_course'] = $this->course_model->get_searched_course_information($data['search_value'], $data['counter'], $data['counter'] + 10);
                $data['total_searched_course'] = $this->course_model->get_total_searched_course_information($data['search_value']);
                break;
            case 'video_course':
                $data['searched_video_course'] = $this->user_video_model->get_searched_video_course_information($data['search_value'], $data['counter'], $data['counter'] + 10);
                $data['total_searched_video_course'] = $this->user_video_model->get_total_searched_video_course_information($data['search_value']);
                break;
            case 'group':
                $data['searched_group'] = $this->group_model->get_searched_group_information($data['search_value'], $data['counter'], $data['counter'] + 10);
                $data['total_searched_group'] = $this->group_model->get_total_searched_group_information($data['search_value']);
                break;
            case 'quiz':
                $data['searched_quiz'] = $this->quiz_model->get_searched_quiz_information($data['search_value'], $data['counter'], $data['counter'] + 10);
                $data['total_searched_quiz'] = $this->quiz_model->get_total_searched_quiz_information($data['search_value']);
                break;
        }
        echo $this->load->view('front_end/ajax_page/view_all_search_value', $data, TRUE);
    }

    /**
     * @Function            : view_certificate_by_student_roll
     * @Description         : Display Certificate
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 01-03-17     
     * @Status              : available      
     * */
    public function verify_certificate_by_student_roll($student_roll) {
        $this->load->model('certificate_model');
        $data = $this->welcome_model->generate_menu();
        $data['certificate_data'] = $this->get_certificate_detail($student_roll);
        if (!isset($data['certificate_data']) || empty($data['certificate_data'])) {
            redirect();
        }
        $data['main_content'] = $this->load->view('front_end/verify_certificate_view', $data, TRUE);
        $this->load->view('front_end/master', $data);
    }

    /**
     * @Function            : get_certificate_detail
     * @Description         : get detail information of a single certificate
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 01-03-17  
     *  @parameter           : $student_roll
     * @Status              : available      
     * */
    public function get_certificate_detail($student_roll) {
        $data = $this->certificate_model->certificate_info_for_public_view($student_roll);
        $data->student_name = $this->certificate_model->get_student_name_by_id($data->person_id);
        return $data;
    }
    
    /**
     * @Function            : profile_skill_meter_ajax_view
     * @Description         : profile skill meter tab
     * @Developed By        : Md. Delwar Hossain
     * @Start DateTime      : 14-06-17  
     * @Status              : available      
     * */
    function profile_skill_meter_ajax_view(){
        if ($this->input->is_ajax_request()) {
            $profile_url = $this->input->post('profile_url', TRUE);
            $data['person_info'] = $this->person_model->get_single_person_information_by_person_url($profile_url);   
            $page_number = $this->input->post('current_page', TRUE);
            $limit_data = ($page_number*10);
            
            $data['all_quiz'] = $this->quiz_model->select_learner_limit_quiz_by_person_id($data['person_info']->person_id,0, $limit_data);
            $data['all_row_quiz'] = count($this->quiz_model->select_learner_all_quiz_by_person_id($data['person_info']->person_id));
            foreach ($data['all_quiz'] as $v_quiz) {
                $data['quiz_result'][$v_quiz->quiz_id] = $this->quiz_model->select_quiz_result($data['person_info']->person_id, $v_quiz->quiz_id);

                $data['quiz_questions'][$v_quiz->quiz_id] = $this->quiz_model->select_active_question_by_quiz_id($v_quiz->quiz_id);
                $data['quiz_total_participant'] = $this->quiz_model->select_person_rank($v_quiz->quiz_id);
                $rank = 1;
                foreach ($data['quiz_total_participant'] as $v_rank) {
                    if ($data['person_info']->person_id == $v_rank->person_id) {
                        break;
                    }
                    $rank++;
                    if ($rank >= 25) {
                        break;
                    }
                }
                $data['rank'][$v_quiz->quiz_id] = $rank;
            }
            echo $this->load->view('user/profile_view/dashboard/dashboard_ajax_view/profile_skill_meter_ajax_view', $data, true);
        }
    }

    public function view_quiz_result_for_profile_ajax_view(){
        if ($this->input->is_ajax_request()) {
            $profile_url = $this->input->post('profile_url', TRUE);
            $data['person_info'] = $this->person_model->get_single_person_information_by_person_url($profile_url);   
            $page_number = $this->input->post('current_page', TRUE);
            $limit_offset = ($page_number*10)-10;

            $data['all_quiz'] = $this->quiz_model->select_learner_limit_quiz_by_person_id($data['person_info']->person_id, $limit_offset);
            $data['all_row_quiz'] = count($this->quiz_model->select_learner_all_quiz_by_person_id($data['person_info']->person_id));
            foreach ($data['all_quiz'] as $v_quiz) {
                $data['quiz_result'][$v_quiz->quiz_id] = $this->quiz_model->select_quiz_result($data['person_info']->person_id, $v_quiz->quiz_id);

                $data['quiz_questions'][$v_quiz->quiz_id] = $this->quiz_model->select_active_question_by_quiz_id($v_quiz->quiz_id);
                $data['quiz_total_participant'] = $this->quiz_model->select_person_rank($v_quiz->quiz_id);
                $rank = 1;
                foreach ($data['quiz_total_participant'] as $v_rank) {
                    if ($data['person_info']->person_id == $v_rank->person_id) {
                        break;
                    }
                    $rank++;
                    if ($rank >= 25) {
                        break;
                    }
                }
                $data['rank'][$v_quiz->quiz_id] = $rank;
            }
            $params = array('url' => '', 'div_id' => 'learner_quiz_pagination', 'total_row' => $data['all_row_quiz'], 'per_page' => 10, 'current_page' => $page_number, 'total_link' => 10);
            $data['pagination_link'] = $this->tt_pagination->view_pagination_link($params);
            echo $this->load->view('user/profile_view/dashboard/learner_quiz_ajax_profile_view', $data, true);
        }
    }
    public function profile_work_experience_ajax_view(){
         if ($this->input->is_ajax_request()) {
            $page_number = $this->input->post('current_page', TRUE);
            $profile_url = $this->input->post('profile_url', TRUE);
            $limit_offset = ($page_number*10)-10;
            
            $data['person_info'] = $this->person_model->get_single_person_information_by_person_url($profile_url);
            $data['user_work_details'] = $this->profile_model->get_work_details($data['person_info']->person_id, $limit_offset);
            $work_detail_count_list = count($this->profile_model->select_user_work_details($data['person_info']->person_id));
            $params = array('url' => '', 'div_id' => 'work_experience_pagination', 'total_row' => $work_detail_count_list, 'per_page' => 10, 'current_page' => $page_number, 'total_link' => 10);
            $data['work_experience_pagination_link'] = $this->tt_pagination->view_pagination_link($params);
            echo $this->load->view('user/profile_view/dashboard/dashboard_ajax_view/profile_work_experience_ajax_view', $data, true);
            
         }
        
    }
    public function profile_language_ajax_view(){
        if ($this->input->is_ajax_request()) {
            $page_number = $this->input->post('current_page', TRUE);
            $profile_url = $this->input->post('profile_url', TRUE);
            $limit_offset = ($page_number*10)-10;
            
            $data['person_info'] = $this->person_model->get_single_person_information_by_person_url($profile_url);
            $data['person_language'] = $this->super_admin_model->select_person_limited_language_by_id($data['person_info']->person_id, $limit_offset);
            $total_person_language = count($this->super_admin_model->select_person_language_by_id($data['person_info']->person_id));        
            $params = array('url' => '', 'div_id' => 'profile_language_pagination', 'total_row' => $total_person_language, 'per_page' => 10, 'current_page' => $page_number, 'total_link' => 10);
            $data['profile_language_pagination'] = $this->tt_pagination->view_pagination_link($params);
            echo $this->load->view('user/profile_view/dashboard/dashboard_ajax_view/profile_language_ajax_view', $data, true);
        }
    }  
    
    public function profile_education_ajax_view(){
        if ($this->input->is_ajax_request()) {
            $page_number = $this->input->post('current_page', TRUE);
            $profile_url = $this->input->post('profile_url', TRUE);
            $limit_offset = ($page_number*10)-10;
            
            $data['person_info'] = $this->person_model->get_single_person_information_by_person_url($profile_url);
            $data['user_education_details'] = $this->profile_model->get_education_details($data['person_info']->person_id, $limit_offset);
            $total_education = count($this->profile_model->select_user_education_details($data['person_info']->person_id));        
            $params = array('url' => '', 'div_id' => 'profile_education_pagination', 'total_row' => $total_education, 'per_page' => 10, 'current_page' => $page_number, 'total_link' => 10);
            $data['profile_education_pagination'] = $this->tt_pagination->view_pagination_link($params);
            echo $this->load->view('user/profile_view/dashboard/dashboard_ajax_view/profile_education_ajax_view', $data, true);
        }
    }    
    

    /*
      -----------@@@RIPON@ End public search View Part----------------------------------
     */
}
