<?php

defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * Description of admin_payment
 *
 * @author Ripon
 */
class Admin_payment extends TT_admin_login {

    public function __construct() {
        parent::__construct();
        $this->load->model('admin_payment_model');    //here, admin_payment_model is loaded
    }

    /**
     * @Description         : view payment method
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 29-12-2016 09:53 AM   
     * */
    private $payment_method_id;
    private $payment_method_messgae;

    function view_payment_method($person_url) {
        $data = [];
        $data['person_info'] = $this->person_model->set_person_url($person_url)->set_field_name('person_id,person_first_name,person_last_name,person_role,person_country')
                        ->set_info_by_url()->get_info();
        $data['active_menu'] = 'user_management';
        $data['active_sub_menu'] = $data['person_info']->person_role;
        $this->session->set_userdata('payment_person_id', $data['person_info']->person_id);
        $this->session->set_userdata('payment_person_url', $person_url);

        $payment_data = $this->get_user_payment_information($data);

        $payment_data['main_content'] = $this->load->view('admin/payment/view_payment_mothod', $payment_data, true);
        $this->load->view('admin/admin_master', $payment_data);
    }

    /**
     * @Description         : get all user payment information
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 29-12-2016 10:33 AM   
     * */
    function get_user_payment_information($data) {
        $data['all_bank'] = $this->utility_model->set_single_row_info('*', 'tbl_bank', ['bank_status' => 1])->get_all_data();

        $data['payment_method_info'] = $this->utility_model
                        ->set_single_row_info('*', 'tbl_person_bkash_payment_info', ['person_id' => $data['person_info']->person_id])->get_single_row_info();
        $data['payment_type'] = 1;
        if (empty($data['payment_method_info'])) {
            $data['payment_method_info'] = $this->utility_model
                            ->set_single_row_info('*', 'tbl_person_check_payment_info', ['person_id' => $data['person_info']->person_id])->get_single_row_info();

            if ($data['payment_method_info']) {
                $data['bank_branch_info'] = $this->utility_model
                                ->set_single_row_info('bank_id,bank_branch_name', 'tbl_bank_branch', ['bank_branch_id' => $data['payment_method_info']->bank_branch_id])->get_single_row_info();
                $data['bank_info'] = $this->utility_model
                                ->set_single_row_info('bank_name', 'tbl_bank', ['bank_id' => $data['bank_branch_info']->bank_id])->get_single_row_info();
            }

            $data['payment_type'] = 2;
            if (empty($data['payment_method_info'])) {
                $data['payment_method_info'] = $this->utility_model
                                ->set_single_row_info('*', 'tbl_person_paypal_payment_info', ['person_id' => $data['person_info']->person_id])->get_single_row_info();
                $data['payment_type'] = 3;
            }
        }
        return $data;
    }

    /**
     * @Description         : save bkash payment method
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 29-12-2016 10:53 AM   
     * */
    function save_bkash_payment_method() {
        $this->form_validation->set_rules('bkash_number_type', 'Bkash Number Type', 'required');
        $this->form_validation->set_rules('bkash_number', 'Bkash Number', 'required|min_length[11]|max_length[11]|numeric|callback_check_bkash_number_existence');
        if ($this->form_validation->run() == FALSE) {
            // set variable into session
            $this->set_session_for_add_bkash_payment();
            // redirect to payment method
            redirect('admin/view-payment-method/' . $this->session->payment_person_url);
        } else {
            // save bkash payment number
            $this->save_bkash_payment_information();
            // send mail for add payment method
            $this->send_notification_for_payment()->save_notification();
            // redirect payment method
            redirect('admin/view-payment-method/' . $this->session->payment_person_url);
        }
    }

    /**
     * @Description         : check baksh number existence
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 29-12-2016 11:16 AM   
     * */
    function check_bkash_number_existence($bkash_number) {
        $bkash_payment_info = $this->utility_model
                        ->set_single_row_info('*', 'tbl_person_bkash_payment_info', ['bkash_number' => $bkash_number])->get_single_row_info();
        if ($bkash_payment_info) {
            $this->form_validation->set_message('check_bkash_number_existence', 'bkash number already exists');
            return FALSE;
        } else {
            return TRUE;
        }
    }

    /**
     * @Description         : set variable into session for save bkash payment
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 29-12-2016 11:18 PM   
     * */
    function set_session_for_add_bkash_payment() {
        $data = [];
        $data['type'] = 1;
        $data['bkash_number_type_value'] = set_value('bkash_number_type');
        $data['bkash_number_type_error'] = form_error('bkash_number_type');
        $data['bkash_number_value'] = set_value('bkash_number');
        $data['bkash_number_error'] = form_error('bkash_number');
        $this->session->set_userdata($data);
    }

    /**
     * @Description         : save check payment information
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 29-12-2016 11:21 PM   
     * */
    function save_bkash_payment_information() {
        $this->payment_process_model->person_id = $this->session->payment_person_id;
        $this->payment_process_model->bkash_number_type = $this->input->post('bkash_number_type', TRUE);
        $this->payment_process_model->bkash_number = trim($this->input->post('bkash_number', TRUE));
        $this->payment_process_model->set_table_name('tbl_person_bkash_payment_info')->save();

        $this->payment_method_messgae = 'added bKash payment method';
        $this->payment_method_id = $this->payment_process_model->set_insert_id()->get_id();
    }

    /**
     * @Description         : check payment method bkash number
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 29-12-2016 10:53 AM   
     * */
    function check_payment_bkash_number() {
        if (empty($this->input->is_ajax_request())) {
            redirect();
        }
        $bkash_number = $this->input->post('bkash_number', TRUE);
        $bkash_payment_info = $this->utility_model
                        ->set_single_row_info('*', 'tbl_person_bkash_payment_info', ['bkash_number' => $bkash_number])->get_single_row_info();
        echo ($bkash_payment_info) ? 1 : 2;
    }

    /**
     * @Description         : get bkash payment info
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 29-12-2016 11:49 AM   
     * */
    function get_bkash_payment_info() {
        if (empty($this->input->is_ajax_request())) {
            redirect();
        }
        $bkash_payment_id = $this->input->post('bkash_payment_id', TRUE);
        $bkash_payment_info = $this->utility_model
                        ->set_single_row_info('*', 'tbl_person_bkash_payment_info', ['person_bkash_payment_info_id' => $bkash_payment_id])->get_single_row_info();

        echo json_encode($bkash_payment_info);
    }

    /**
     * @Description         : get bkash payment info
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 26-12-2016 10:12 AM   
     * */
    function update_bkash_payment_method() {
        $this->payment_method_id = $this->input->post('bkash_payment_id', TRUE);
        $bkash_number_info = $this->utility_model
                ->set_single_row_info('bkash_number', 'tbl_person_bkash_payment_info', ['person_bkash_payment_info_id' => $this->payment_method_id])
                ->get_single_row_info();

        if (empty($bkash_number_info)) {
            redirect('admin/view-payment-method/' . $this->session->payment_person_url);
        }

        $this->form_validation->set_rules('edit_bkash_number_type', 'Bkash Number Type', 'required');
        // if previous number does not and new number same then check validation
        if (trim($this->input->post('edit_bkash_number', TRUE)) != $bkash_number_info->bkash_number) {
            $this->form_validation->set_rules('edit_bkash_number', 'Bkash Number', 'required|min_length[11]|max_length[11]|numeric|callback_check_bkash_number_existence');
        }

        if ($this->form_validation->run() == FALSE) {
            // set variable into session
            $this->set_session_for_update_bkash_payment();
            // refirect to payment method
            redirect('admin/view-payment-method/' . $this->session->payment_person_url);
        } else {
            // update bkash payment number
            $this->update_bkash_payment_information();
            // send mail for add payment method
            $this->send_notification_for_payment()->save_notification();
            // redirect payment method
            redirect('admin/view-payment-method/' . $this->session->payment_person_url);
        }
    }

    /**
     * @Description         : set variable into session for update bkash payment
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 29-12-2016 02:37 PM   
     * */
    function set_session_for_update_bkash_payment() {
        $data = [];
        $data['type'] = 2;
        $data['bkash_payment_method_id'] = $this->payment_method_id;
        $data['bkash_number_type_value'] = set_value('edit_bkash_number_type');
        $data['bkash_number_type_error'] = form_error('edit_bkash_number_type');
        $data['bkash_number_value'] = set_value('edit_bkash_number');
        $data['bkash_number_error'] = form_error('edit_bkash_number');
        $this->session->set_userdata($data);
    }

    /**
     * @Description         : update bkash payment information
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 29-12-2016 02:42 PM   
     * */
    function update_bkash_payment_information() {
        $this->payment_process_model->bkash_number_type = $this->input->post('edit_bkash_number_type', TRUE);
        $this->payment_process_model->bkash_number = trim($this->input->post('edit_bkash_number', TRUE));
        $this->payment_process_model->set_primary_key('person_bkash_payment_info_id')
                ->set_primary_key_value($this->payment_method_id)->set_table_name('tbl_person_bkash_payment_info')->update();

        // set notification type [for update bkash payment method]
        $this->payment_method_messgae = 'updated bKash payment method';
    }

    /**
     * @Description         : delete bkash payment method
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 29-12-2016 02:52 PM   
     * */
    function delete_bkash_payment_method() {
        if (empty($this->input->is_ajax_request())) {
            redirect();
        }
        $this->payment_process_model->set_primary_key('person_bkash_payment_info_id')
                ->set_primary_key_value($this->input->post('bkash_payment_id', TRUE))->set_table_name('tbl_person_bkash_payment_info')->delete();
    }

//    -------------------------------- Check payment mathod-----------------------------
    /**
     * @Description         : view bank branch name by bank ID
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 29-12-2016 03:07 PM   
     * */
    function view_bank_branch_name() {
        if (empty($this->input->is_ajax_request())) {
            redirect();
        }
        $bank_id = $this->input->post('bank_id', TRUE);
        $bank_branchs = $this->bank_branch_model->set_bank_id($bank_id)
                        ->set_bank_branch_status(1)->set_branch_name_by_bank_id()->get_result();
        echo json_encode($bank_branchs);
    }

    /**
     * @Description         : check account number
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 29-12-2016 03:07 PM   
     * */
    function check_account_number() {
        if (empty($this->input->is_ajax_request())) {
            redirect();
        }
        $bank_id = $this->input->post('bank_id', TRUE);
        $branch_info = $this->bank_branch_model->set_bank_id($bank_id)->set_all_bank_branch_id_by_bank_id()->get_result();
        $account_number_info = $this->bank_branch_model->set_field_name('person_account_number')
                        ->set_bank_branch_id(explode(',', $branch_info->id))->set_account_number($this->input->post('account_number'))
                        ->set_check_payment_account_number_by_all_branch_id()->get_result();

        echo ($account_number_info) ? 1 : 2;
    }

    /**
     * @Description         : save check payment method
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 29-12-2016 03:51 PM   
     * */
    function save_check_payment_method() {
        $this->form_validation->set_rules('bank_id', 'Bank Name', 'required');
        $this->form_validation->set_rules('bank_branch_id', 'Bank Branch Name', 'required');
        $this->form_validation->set_rules('person_account_number', 'Account number', 'required|callback_check_account_number_existence');
        if ($this->form_validation->run() == FALSE) {
            $data = [];
            $data['check_type'] = 3; // for save payment information
            $data['validation_error'] = validation_errors();
            $this->session->set_userdata($data);

            redirect('admin/view-payment-method/' . $this->session->payment_person_url);
        } else {
            // save check payment information
            $this->save_check_payment_information();

            // send mail for add payment method
            $this->send_notification_for_payment()->save_notification();
            // redirect payment method
            redirect('admin/view-payment-method/' . $this->session->payment_person_url);
        }
    }

    /**
     * @Description         : check account number existence 
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 29-12-2016 04:02 PM   
     * */
    function check_account_number_existence($account_number) {
        $bank_id = $this->input->post('bank_id', TRUE);
        $branch_info = $this->bank_branch_model->set_bank_id($bank_id)->set_all_bank_branch_id_by_bank_id()->get_result();
        $account_number_info = $this->bank_branch_model->set_field_name('person_account_number')
                        ->set_bank_branch_id(explode(',', $branch_info->id))->set_account_number($account_number)
                        ->set_check_payment_account_number_by_all_branch_id()->get_result();

        if ($account_number_info) {
            $this->form_validation->set_message('check_account_number_existence', 'Account number already exists');
            return FALSE;
        } else {
            return TRUE;
        }
    }

    /**
     * @Description         : save check payment information
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 29-12-2016 04:02 PM   
     * */
    function save_check_payment_information() {
        $this->payment_process_model->person_id = $this->session->payment_person_id;
        $this->payment_process_model->bank_branch_id = $this->input->post('bank_branch_id', TRUE);
        $this->payment_process_model->person_account_number = trim($this->input->post('person_account_number', TRUE));
        $this->payment_process_model->set_table_name('tbl_person_check_payment_info')->save();

        $this->payment_method_messgae = 'added cheque payment method';
        $this->payment_method_id = $this->payment_process_model->set_insert_id()->get_id();
    }

    /**
     * @Description         : get check payment information
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 31-12-2016 09:54 AM   
     * */
    function get_check_payment_info() {
        if (empty($this->input->is_ajax_request())) {
            redirect();
        }

        $data = [];
        $check_payment_id = $this->input->post('check_payment_id', TRUE);
        $data['check_payment_info'] = $this->utility_model
                ->set_single_row_info('*', 'tbl_person_check_payment_info', ['person_check_payment_info_id' => $check_payment_id])
                ->get_single_row_info();
        $data['branch_info'] = $this->utility_model
                ->set_single_row_info('*', 'tbl_bank_branch', ['bank_branch_id' => $data['check_payment_info']->bank_branch_id])
                ->get_single_row_info();
        echo json_encode($data);
    }

    /**
     * @Description         : update check payment method
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 31-12-2016 10:16 AM   
     * */
    function update_check_payment_method() {
        $this->payment_method_id = $this->input->post('check_payment_id', TRUE);

        $check_payment_info = $this->utility_model
                ->set_single_row_info('person_account_number', 'tbl_person_check_payment_info', ['person_check_payment_info_id' => $this->payment_method_id])
                ->get_single_row_info();

        if (!$check_payment_info) {
            redirect('admin/view-payment-method/' . $this->session->payment_person_url);
        }

        $this->form_validation->set_rules('edit_bank_id', 'Bank Name', 'required');
        $this->form_validation->set_rules('edit_bank_branch_id', 'Bank Branch Name', 'required|trim');

        if ($check_payment_info->person_account_number != $this->input->post('edit_person_account_number', TRUE)) {
            $this->form_validation->set_rules('edit_person_account_number', 'Account number', 'required|callback_check_edit_account_number_existence');
        }
        if ($this->form_validation->run() == FALSE) {
            $data = [];
            $data['check_type'] = 4; // for save payment information
            $data['validation_error'] = validation_errors();
            $this->session->set_userdata($data);

            redirect('admin/view-payment-method/' . $this->session->payment_person_url);
        } else {
            // save check payment information
            $this->update_check_payment_information();
            // send notification for add payment method
            $this->send_notification_for_payment()->save_notification();
            // redirect payment method
            redirect('admin/view-payment-method/' . $this->session->payment_person_url);
        }
    }

    /**
     * @Description         : check account number existence for edit
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 31-12-2016 10:28 AM   
     * */
    function check_edit_account_number_existence($account_number) {
        $bank_id = $this->input->post('edit_bank_id', TRUE);
        $branch_info = $this->bank_branch_model->set_bank_id($bank_id)->set_all_bank_branch_id_by_bank_id()->get_result();
        $account_number_info = $this->bank_branch_model->set_field_name('person_account_number')
                        ->set_bank_branch_id(explode(',', $branch_info->id))->set_account_number($account_number)
                        ->set_check_payment_account_number_by_all_branch_id()->get_result();

        if ($account_number_info) {
            $this->form_validation->set_message('check_edit_account_number_existence', 'Account number already exists');
            return FALSE;
        } else {
            return TRUE;
        }
    }

    /**
     * @Description         : update check payment information
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 31-12-2016 10:50 AM   
     * */
    function update_check_payment_information() {
        $this->payment_process_model->bank_branch_id = $this->input->post('edit_bank_branch_id', TRUE);
        $this->payment_process_model->person_account_number = trim($this->input->post('edit_person_account_number', TRUE));
        $this->payment_process_model->set_primary_key('person_check_payment_info_id')
                ->set_primary_key_value($this->payment_method_id)->set_table_name('tbl_person_check_payment_info')->update();

        $this->payment_method_messgae = 'updated cheque payment method';
    }

    /**
     * @Description         : delete check payment information
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 28-12-2016 05:06 PM   
     * */
    function delete_check_payment_method() {
        if (empty($this->input->is_ajax_request())) {
            redirect();
        }
        $this->payment_process_model->set_primary_key('person_check_payment_info_id')
                ->set_primary_key_value($this->input->post('check_payment_id', TRUE))->set_table_name('tbl_person_check_payment_info')->delete();
    }

    //--------------------paypal----------------------
    /**
     * @Description         : save paypal payment method
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 31-12-2016 11:37 AM   
     * */
    function save_paypal_payment_method() {
        $this->form_validation->set_rules('paypal_email', 'Paypal Email', 'required|valid_email|is_unique[tbl_person_paypal_payment_info.paypal_email]');
        if ($this->form_validation->run() == FALSE) {
            $data = [];
            $data['paypal_type'] = 5; // for save payment information
            $data['paypal_error'] = form_error('paypal_email');
            $this->session->set_userdata($data);
            redirect('admin/view-payment-method/' . $this->session->payment_person_url);
        } else {
            // save bkash payment number
            $this->save_paypal_payment_information();

            // send mail for add payment method
            $this->send_notification_for_payment()->save_notification();
            // redirect payment method
            redirect('admin/view-payment-method/' . $this->session->payment_person_url);
        }
    }

    /**
     * @Description         : save paypal payment information
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 31-12-2016 11:40 AM   
     * */
    function save_paypal_payment_information() {
        $this->payment_process_model->person_id = $this->session->payment_person_id;
        $this->payment_process_model->paypal_email = trim($this->input->post('paypal_email', TRUE));
        $this->payment_process_model->set_table_name('tbl_person_paypal_payment_info')->save();

        $this->payment_method_messgae = 'added paypal payment method';
        $this->payment_method_id = $this->payment_process_model->set_insert_id()->get_id();
    }

    /**
     * @Description         : cehck paypal email
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 31-12-2016 11:32 PM   
     * */
    function check_paypal_email() {
        if (empty($this->input->is_ajax_request())) {
            redirect();
        }
        $paypal_email = $this->input->post('paypal_email', TRUE);
        $paypal_payment_info = $this->utility_model
                        ->set_single_row_info('*', 'tbl_person_paypal_payment_info', ['paypal_email' => $paypal_email])->get_single_row_info();

        echo (!empty($paypal_payment_info)) ? 1 : 2;
    }

    /**
     * @Description         : update check payment information
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 31-12-2016 11:45 AM   
     * */
    function get_paypal_payment_info() {
        if (empty($this->input->is_ajax_request())) {
            redirect();
        }

        $payment_method_id = $this->input->post('payment_method_id', TRUE);
        $paypal_payment_info = $this->utility_model
                ->set_single_row_info('*', 'tbl_person_paypal_payment_info', ['person_paypal_payment_info_id' => $payment_method_id])
                ->get_single_row_info();

        echo json_encode($paypal_payment_info);
    }

    /**
     * @Description         : update check payment information
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 31-12-2016 11:52 AM   
     * */
    function update_paypal_payment_method() {
        $this->payment_method_id = $this->input->Post('paypal_method_id', TRUE);
        $previous_email = $this->utility_model
                        ->set_single_row_info('paypal_email', 'tbl_person_paypal_payment_info', ['person_paypal_payment_info_id' => $this->payment_method_id])
                        ->get_single_row_info()->paypal_email;

        if ($previous_email != trim($this->input->post('edit_paypal_email'))) {
            $this->form_validation->set_rules('edit_paypal_email', 'Paypal Email', 'required|valid_email|is_unique[tbl_person_paypal_payment_info.paypal_email]');
        } else {
            $this->form_validation->set_rules('edit_paypal_email', 'Paypal Email', 'required|valid_email');
        }

        if ($this->form_validation->run() == FALSE) {
            $data = [];
            $data['paypal_type'] = 6; // for save payment information
            $data['paypal_email_value'] = set_value('edit_paypal_email'); // for save payment information
            $data['paypal_error'] = form_error('edit_paypal_email');
            $data['sess_payment_method_id'] = $this->payment_method_id;
            $this->session->set_userdata($data);
            redirect('admin/view-payment-method/' . $this->session->payment_person_url);
        } else {
            // save bkash payment number
            $this->update_paypal_payment_information();

            // send mail for add payment method
            $this->send_notification_for_payment()->save_notification();
            // redirect payment method
            redirect('admin/view-payment-method/' . $this->session->payment_person_url);
        }
    }

    /**
     * @Description         : update paypal payment information
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 26-12-2016 06:24 PM   
     * */
    function update_paypal_payment_information() {
        $this->payment_process_model->paypal_email = trim($this->input->post('edit_paypal_email', TRUE));
        $this->payment_process_model->set_primary_key('person_paypal_payment_info_id')
                ->set_primary_key_value($this->payment_method_id)->set_table_name('tbl_person_paypal_payment_info')->update();

        $this->payment_method_messgae = 'updated paypal payment method';
    }

    /**
     * @Description         : delete paypal payment information
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 28-12-2016 04:55 PM   
     * */
    function delete_paypal_payment_method() {
        if (empty($this->input->is_ajax_request())) {
            redirect();
        }
        $this->payment_process_model->set_primary_key('person_paypal_payment_info_id')
                ->set_primary_key_value($this->input->post('paypal_payment_id', TRUE))->set_table_name('tbl_person_paypal_payment_info')->delete();
    }

    /**
     * @Description         : save notification for payment method
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 29-12-2016 11:23 AM   
     * */
    private $notify_to;
    private $notify_by;
    private $notification_type;
    private $notification_type_id;
    private $notification_description;

    function send_notification_for_payment() {
        $notification_description = [];
        $person_info = $this->person_model->set_person_id($this->session->payment_person_id)->set_field_name('person_first_name,person_last_name')->set_info_by_id()->get_info();
        $notification_description[1] = '<strong>Talha Training</strong> ' . $this->payment_method_messgae . ' for <strong>' . $person_info->person_first_name . ' ' . $person_info->person_last_name . '</strong>.';
        $notification_description[$this->session->payment_person_id] = '<strong>Talha Training</strong> ' . $this->payment_method_messgae . ' for <strong>you</strong>.';

        $this->notify_by = 1;
        $this->notify_to = implode(',', array_keys($notification_description));
        $this->notification_type = 7;
        $this->notification_description = serialize($notification_description);
        $this->notification_type_id = $this->payment_method_id;
        return $this;
    }

    /**
     * @Description         : save notification
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 15-01-2016 06:40 PM   
     * */
    function save_notification() {
        // save notification information
        $this->notification_model
                ->set_notify_by($this->notify_by)
                ->set_notify_to($this->notify_to)
                ->set_notification_description($this->notification_description)
                ->set_notification_type($this->notification_type)
                ->save();

        // save notification type 
        $this->notification_model->set_insert_id()
                ->set_notification_type_info_id($this->notification_type_id)
                ->save_type_info();
        return $this;
    }

}
