<?php

defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * Description of Admin_education_institute
 *
 * @author Md Mashqur Ul Alam
 */
class Admin_education_institute extends TT_admin_login {

    public function __construct() {
        parent::__construct();
        $this->load->model('admin_payment_model');
    }

    /**
     * @Function            : view_eduIns 
     * @Used IN             : @route- 'admin/education-institute'
     * @Description         : Loads the admin education institute view page
     *                        along with necessary data.
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 03-12-2016 03:22 PM  
     * @Parameter           : Null
     * @View                : admin/education_institute/education_institute_view.php
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available        
     * */
    public function view_eduIns() {
        $data['active_menu'] = 'eduIns';
        $data['active_sub_menu'] = 'view_eduIns';
        $data['all_eduIns_name'] = $this->super_admin_profile_model->select_all_eduIns_model();
        $data['pagination_link'] = $this->get_pagination_data();
        $data['main_content'] = $this->load->view('admin/education_institute/education_institute_view', $data, true);
        $this->load->view('admin/admin_master', $data);
    }

    /*
     * @Function            : get_pagination_data 
     * @Used IN             : @function- 'view_eduIns', 'view_eduIns_name'
     * @Description         : Loads the view of pagination using pagination library
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 20-12-2016 05:32 PM  
     * @Parameter           : Null
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available        
     */

    public function get_pagination_data($current_page = 1, $condition = null, $search_text = '') {
        $total_eduIns = $this->super_admin_profile_model->total_eduIns_model($condition, $search_text);
        $params = array('url' => '', 'div_id' => 'eduInsPagination', 'total_row' => $total_eduIns, 'per_page' => 10, 'current_page' => $current_page, 'total_link' => 5);
        $data = $this->tt_pagination->view_pagination_link($params);
        return $data;
    }

    /*
     * @Function            : view_eduIns_name 
     * @Used IN             : @function- searching education institute name
     * @Description         : Loads the list of education institute name based 
     *                        on search
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 20-12-2016 05:32 PM  
     * @Parameter           : Null
     * @Redirect            : None
     * @Return              : ajax page with list of education institute name   
     * @Status              : Available        
     */

    public function view_eduIns_name() {
        if ($this->input->is_ajax_request()) {
            $array_key = array('pubStatus', 'insType', 'insName', 'country', 'city', 'currentPage');
            $data = $this->input->post($array_key, true);
            $condition = [];
            $search_text = $data['insName'];
            $current_page = $data['currentPage'];

            if ($data['pubStatus'] != null) {
                $condition['education_institute_status'] = $data['pubStatus'];
            }
            if ($data['insType'] != null) {
                $condition['education_institute_type'] = $data['insType'];
            }
            if ($data['country'] != null) {
                $condition['education_institute_country'] = $data['country'];
            }
            if ($data['city'] != null) {
                $condition['education_institute_city'] = $data['city'];
            }

            if (isset($condition) || isset($search_text)) {
                $output['all_eduIns_name'] = $this->super_admin_profile_model->view_eduIns_name_model($condition, $search_text, $current_page);
            }

            $output['pagination_link'] = $this->get_pagination_data($current_page, $condition, $search_text);
            $view_page = $this->load->view('admin/education_institute/education_institute_view_ajax', $output, true);

            echo $view_page;
        } else {
            redirect('admin/education-institute');
        }
    }

    /**
     * @Function            : save_eduIns 
     * @Used IN             : @route- 'admin/save-education-institute'
     * @Description         : Saves new education institute added from admin
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 15-12-2016 04:53 PM  
     * @Parameter           : Null
     * @View                : Null
     * @Redirect            : admin/education-institute
     * @Return              : NULL    
     * @Status              : Available        
     * */
    public function save_eduIns() {
        $this->form_validation->set_rules('education_institute_name',
                                          'Education Institute Name', 
                                          'required|trim|max_length[256]');
        $this->form_validation->set_rules('education_institute_type',
                                          'Education Institute Type',
                                          'required|trim|integer');               
        $this->form_validation->set_rules('education_institute_country',
                                          'Country Name',
                                          'required|trim|alpha');
        $this->form_validation->set_rules('education_institute_city',
                                          'State/City Name',
                                          'required|trim|alpha_dash');
        $this->form_validation->set_rules('education_institute_status',
                                          'Publication Status',
                                          'required|trim|integer');
        
        if($this->form_validation->run() == FALSE){
            $this->session->set_userdata('eduIns_error', 'Sorry Saving Education Institute Failed!');
            redirect('admin/education-institute');
        }else{
            $input_field = array('education_institute_name',
            'education_institute_type',
            'education_institute_country',
            'education_institute_city',
            'education_institute_status'
        );
        $data = $this->input->post($input_field, true);
        $this->super_admin_profile_model->save_eduIns_model($data);
        $this->session->set_userdata('eduIns_success', 'Education Institute Saved Successfully!');
        redirect('admin/education-institute');
        }        
        
    }

    /**
     * @Function            : get_eduIns 
     * @Used IN             : @route- 'admin/get-education-institute'
     * @Description         : Gets the education institute info by id
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 17-12-2016 12:30 PM  
     * @Parameter           : Null
     * @View                : Null
     * @Redirect            : None
     * @Return              : $result    
     * @Status              : Available        
     * */
    public function get_eduIns() {
        if ($this->input->is_ajax_request()) {
            $eduIns_id = $this->input->post('education_institute_id');
            $data = $this->super_admin_profile_model->select_eduIns_by_id($eduIns_id);
            $result = json_encode($data);
            echo $result;
        } else {
            redirect('admin/education-institute');
        }
    }

    /**
     * @Function            : update_eduIns 
     * @Used IN             : @route- 'admin/update-education-institute'
     * @Description         : Updates education institute info
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 18-12-2016 02:30 PM  
     * @Parameter           : Null
     * @View                : Null     
     * @Return              : None   
     * @Status              : Available        
     * */
    public function update_eduIns() {
        $this->form_validation->set_rules('education_institute_name',
                                          'Education Institute Name',
                                          'required|trim|max_length[256]');
        $this->form_validation->set_rules('education_institute_type',
                                          'Education Institute Type',
                                          'required|trim|integer');
        $this->form_validation->set_rules('education_institute_country',
                                          'Country Name',
                                          'required|trim|alpha');
        $this->form_validation->set_rules('education_institute_city',
                                          'State/City Name',
                                          'required|trim|alpha_dash');
        $this->form_validation->set_rules('education_institute_status',
                                          'Publication Status',
                                          'required|trim|integer');
        $this->form_validation->set_rules('education_institute_id',
                                          'Unique Id of Education Institute',
                                          'required|trim|integer');

        if($this->form_validation->run() == FALSE){
            $this->session->set_userdata('eduIns_error', 'Sorry Education Institute Update Failed!');
            redirect('admin/education-institute');
        }else{
            $eduIns_id = $this->input->post('education_institute_id', true);
        $input_field = array(
            'education_institute_name',
            'education_institute_type',
            'education_institute_country',
            'education_institute_city',
            'education_institute_status'
        );
        $data = $this->input->post($input_field, true);
        $this->super_admin_profile_model->update_eduIns_model($data, $eduIns_id);
        $this->session->set_userdata('eduIns_success', 'Education Institute Update Successfully!');
        redirect('admin/education-institute');
        }
    }

    /**
     * @Function            : delete_eduIns 
     * @Used IN             : @route- 'admin/delete-education-institute'
     * @Description         : Deletes education institute info
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 18-12-2016 03:00 PM  
     * @Parameter           : Null
     * @View                : Null     
     * @Return              : None   
     * @Status              : Available        
     * */
    public function delete_eduIns() {
        if ($this->input->is_ajax_request()) {
            $eduIns_id = $this->input->post('eduIns_id');
            $data = $this->super_admin_profile_model->delete_eduIns_model($eduIns_id);
        } else {
            redirect('admin/education-institute');
        }
    }
    
    
        /**
     * @Function            : approve_edu_ins 
     * @Used IN             : @route- 'admin/approve-edu-ins'
     * @Description         : Approve education institute status
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 10-01-2017
     * @Status              : Available        
     * */
    public function approve_edu_ins(){
        if($this->input->is_ajax_request()){
            $education_institute_id = $this->input->post('edu_ins_id');
            $this->super_admin_profile_model->approve_edu_ins_model($education_institute_id);
            echo json_encode('1');
        }
    }

}
