<?php

/**
 * Description of Admin_bank
 *
 * @author User
 */
class Admin_bank extends TT_admin_login {

    public function __construct() {
        parent::__construct();
        $this->load->model(['bank_model', 'bank_branch_model', 'payment_process_model']);
    }

    /*
      -----------@@@RIPON@ Start Bank View Part----------------------------------
     */

    /**
     * @Description         : view all bank name
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 02-05-2016 09:55 AM        
     * */
    function view_bank() {
        $data = [];
        $data['active_menu'] = 'bank';
        $data['active_sub_menu'] = 'view_bank';
        $data['page_number'] = 1;
        $data['all_bank_name'] = $this->bank_model->set_limit(0)->select_all_bank_info()->get_result();

        // get all bank related data
        $bank_data = $this->get_bank_data($data);
        $bank_data['main_content'] = $this->load->view('admin/bank/bank_view', $bank_data, true);
        $this->load->view('admin/admin_master', $bank_data);
    }

    /**
     * @Description         : get bank data
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 14-12-2016 05:16 PM        
     * */
    function get_bank_data($data) {
        foreach ($data['all_bank_name'] as $value) {
            $data['total_branch'][$value->bank_id] = $this->bank_branch_model->set_bank_id($value->bank_id)
                            ->total_bank_branch()->get_result();
        }

        $total_bank = $this->bank_model->total_bank()->get_result();
        $params = array('url' => '', 'div_id' => 'bankPagination', 'total_row' => $total_bank, 'per_page' => 10, 'current_page' => $data['page_number'], 'total_link' => 10);
        $data['pagination_link'] = $this->tt_pagination->view_pagination_link($params);
        return $data;
    }

    /**
     * @Function            : save_bank_name 
     * @Used IN             : @function-'admin/bank/bank_view.php' [93]
     * @Description         : save bank name
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 02-05-2016 10:13 AM  
     * @Parameter           : None
     * @View                : None
     * @Redirect            : admin/bank
     * @Return              : NULL    
     * @Status              : Available        
     * */
    function save_bank_name() {
        $this->form_validation->set_rules('bank_name', 'Bank Name', 'required|trim|callback_bank_name_existence');
        $this->form_validation->set_rules('bank_status', 'Bank Status', 'required|trim');
        if ($this->form_validation->run() == FALSE) {
            $s_data['message'] = 'There is some error to save Bank name!';
            set_session($s_data);
            redirect('admin/bank');
        } else {
            $this->bank_model->bank_name = trim($this->input->post('bank_name', TRUE));
            $this->bank_model->bank_status = $this->input->post('bank_status', TRUE);
            $this->bank_model->save();
            redirect('admin/bank');
        }
    }

    /**
     * @Description         : get bank information
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 14-12-2016 02:55 PM      
     * */
    function get_bank_info() {
        if ((filter_input(INPUT_SERVER, 'HTTP_X_REQUESTED_WITH')) && (filter_input(INPUT_SERVER, 'HTTP_X_REQUESTED_WITH') == 'XMLHttpRequest')) {
            $all_bank_name = $this->utility_model->set_single_row_info('*', 'tbl_bank', [])->get_all_data();
            echo json_encode($all_bank_name);
        } else {
            redirect('');
        }
    }

    /**
     * @Description         : view bank name
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 14-12-2016 03:55 PM      
     * */
    function view_bank_name() {
        if ((filter_input(INPUT_SERVER, 'HTTP_X_REQUESTED_WITH')) && (filter_input(INPUT_SERVER, 'HTTP_X_REQUESTED_WITH') == 'XMLHttpRequest')) {
            $data = [];
            $search_input = $this->input->post('search_input', TRUE);
            $data['page_number'] = $this->input->post('page_number', TRUE);
            $limit = ($data['page_number'] == 1) ? 0 : (($data['page_number'] * 10) - 10);
            $data['all_bank_name'] = $this->bank_model->set_search_input($search_input)->set_limit($limit)->select_all_bank_info()->get_result();

            // get all bank related data
            $bank_data = $this->get_bank_data($data);
            $view_page = $this->load->view('admin/bank/ajax_page/view_bank', $bank_data, TRUE);
            echo json_encode($view_page);
        } else {
            redirect('');
        }
    }

    /**
     * @Description         : update bank status
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 14-12-2016 11:55 AM      
     * */
    private $total_modify_bank;
    private $total_modify_branch;

    function update_bank_status() {
        if ((filter_input(INPUT_SERVER, 'HTTP_X_REQUESTED_WITH')) && (filter_input(INPUT_SERVER, 'HTTP_X_REQUESTED_WITH') == 'XMLHttpRequest')) {
            $bank_id = $this->input->post('bank_id', TRUE);
            $bank_status = $this->input->post('bank_status', TRUE);

            // update bank name
            if ($bank_status == 1) {
                $this->modify_bank_branch_information($bank_id);
            }
            $this->bank_model->bank_status = $this->input->post('bank_status', TRUE);
            $this->bank_model->set_bank_id($this->input->post('bank_id', TRUE))->update();

            $data = [];
            $data['total_modify_bank'] = $this->total_modify_bank;
            $data['total_modify_branch'] = $this->total_modify_branch;
            echo json_encode($data);
        } else {
            redirect('');
        }
    }

    /**
     * @Description         : modify bank branch information id user(front end) multiple same bank name AS pending
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 14-12-2016 11:55 AM      
     * */
    function modify_bank_branch_information($bank_id) {
        $bank_name = $this->utility_model->set_single_row_info('bank_name', 'tbl_bank', ['bank_id' => $bank_id])
                        ->get_single_row_info()->bank_name;

        // get all bank information by bank name
        $all_bank_id = $this->bank_model->set_bank_id($bank_id)->set_bank_name($bank_name)
                        ->set_all_bank_id_by_bank_name()->get_result()->id;

        if (!empty($all_bank_id)) {
            $all_bank_id_array = explode(',', $all_bank_id);

            // get all branch information by multiple bank ID
            $this->update_branch_information($all_bank_id_array, $bank_id);

            // delete all duplicat bank name
            $this->delete_duplicate_bank($all_bank_id_array);
        }
    }

    /**
     * @Description         : update branch information by bank ID
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 20-12-2016 12:20 AM      
     * */
    function update_branch_information($all_bank_id_array, $bank_id) {
        // get total deleted bank
        $this->total_modify_bank = count($all_bank_id_array);
        $all_bank_id_array[] = $bank_id;

        // get branch information by multiple bank ID
        $bank_branch_info = $this->bank_branch_model->set_bank_id($all_bank_id_array)
                        ->set_all_branch_info_by_multiple_bank_id()->get_result();

        // get total modified branch
        $this->total_modify_branch = count($bank_branch_info);

        // update branch bank_id(forign key)
        foreach ($bank_branch_info as $value) {
            $this->bank_branch_model->set_bank_branch_id($value->bank_branch_id);
            $this->bank_branch_model->bank_id = $bank_id;
            $this->bank_branch_model->update();
        }
    }

    /**
     * @Description         : delete all duplicate branch
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 20-12-2016 12:41 PM      
     * */
    function delete_duplicate_bank($all_bank_id_array) {
        foreach ($all_bank_id_array as $value) {
            $this->bank_model->set_bank_id($value)->delete();
        }
    }

    /**
     * @Description         : delete single bank status
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 14-12-2016 12:41 AM      
     * */
    function delete_single_bank_name() {
        if ((filter_input(INPUT_SERVER, 'HTTP_X_REQUESTED_WITH')) && (filter_input(INPUT_SERVER, 'HTTP_X_REQUESTED_WITH') == 'XMLHttpRequest')) {
            $this->bank_model->set_bank_id($this->input->post('bank_id', TRUE))->delete();
        } else {
            redirect('');
        }
    }

    /**
     * @Function            : update_bank_name 
     * @Used IN             : @function-'admin/bank/bank_view.php' [57]
     * @Description         : Update bank name
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 02-05-2016 06:13 PM  
     * @Parameter           : None
     * @View                : None
     * @Redirect            : admin/bank
     * @Return              : NULL    
     * @Status              : Available        
     * */
    function update_bank_name() {
        $this->form_validation->set_rules('edit_bank_name', 'Bank Name', 'required|trim|callback_edit_bank_name_existence');
        $this->form_validation->set_rules('edit_bank_status', 'Bank Status', 'required');
        if ($this->form_validation->run() == FALSE) {
            $s_data['message'] = 'There is some error to update Bank name!';
            set_session($s_data);
            redirect('admin/bank');
        } else {
            $this->bank_model->bank_name = trim($this->input->post('edit_bank_name', TRUE));
            $this->bank_model->bank_status = $this->input->post('edit_bank_status', TRUE);
            $this->bank_model->set_bank_id($this->input->post('edit_bank_id', TRUE))->update();
            redirect('admin/bank');
        }
    }

    /**
     * @Function            : bank_name_existence 
     * @Used IN             : @function-'save_bank_name'     this[@controller] - [79]
     * @Description         : check bank name existence for add bank name (php validation)
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 02-05-2016 11:28 AM  
     * @Parameter           : $bank_name[STRING]
     * @View                : None
     * @Redirect            : None
     * @Return              : TRUE/FALSE   
     * @Status              : Available        
     * */
    function bank_name_existence($bank_name) {
        $bank_info = $this->utility_model
                        ->set_single_row_info('bank_name', 'tbl_bank', ['bank_name' => $bank_name])->get_single_row_info();
        if ($bank_info) {
            $this->form_validation->set_message('bank_name_existence', "Bank Name Already Exists");
            return FALSE;
        } else {
            return TRUE;
        }
    }

    /**
     * @Function            : edit_bank_name_existence 
     * @Used IN             : @function-'update_bank_name'     this[@controller] - [104]
     * @Description         : check bank name existence for edit bank name (php validation)
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 02-05-2016 11:28 AM  
     * @Parameter           : $bank_name[STRING]
     * @View                : None
     * @Redirect            : None
     * @Return              : TRUE/FALSE   
     * @Status              : Available        
     * */
    function edit_bank_name_existence($bank_name) {
        $bank_id = $this->input->post('edit_bank_id', TRUE);
        $bank_info = $this->bank_model->set_bank_id($bank_id)
                        ->set_bank_name($bank_name)->set_bank_info_for_edit()->get_result();
        if ($bank_info) {
            $this->form_validation->set_message('edit_bank_name_existence', "Bank Name Already Exists");
            return FALSE;
        } else {
            return TRUE;
        }
    }

    /*
      -----------@@@RIPON@ End Bank View Part----------------------------------
     */



    /*
      -----------@@@RIPON@ Start Bank Branch View Part----------------------------------
     */

    /**
     * @Description         : view bank branch
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 15-12-2016 02:18 PM      
     * */
    function view_bank_branch($arg = '') {
        $data = [];
        $data['active_menu'] = 'bank';
        $data['active_sub_menu'] = 'view_bank_branch';
        $data['page_number'] = 1;
        $data['all_bank'] = $this->utility_model->set_single_row_info('*', 'tbl_bank', ['bank_status' => 1])->get_all_data();
        $data['all_bank_branchs'] = $this->bank_branch_model->set_bank_id($arg)->set_limit(0)->select_all_bank_branch_info()->get_result();

        // get all bank branch realted data
        $branch_data = $this->get_bank_branch_data($data);

        $branch_data['main_content'] = $this->load->view('admin/bank/bank_branch_view', $branch_data, TRUE);
        $this->load->view('admin/admin_master', $branch_data);
    }

    /**
     * @Description         : view bank branch for pagination
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 15-12-2016 04:59 PM      
     * */
    function view_bank_branch_name() {
        if ((filter_input(INPUT_SERVER, 'HTTP_X_REQUESTED_WITH')) && (filter_input(INPUT_SERVER, 'HTTP_X_REQUESTED_WITH') == 'XMLHttpRequest')) {
            $data['page_number'] = $this->input->post('page_number', TRUE);
            $limit = ($data['page_number'] == 1) ? 0 : (($data['page_number'] * 10) - 10);
            $data['all_bank_branchs'] = $this->bank_branch_model->set_bank_id($this->input->post('bank_id', TRUE))
                            ->set_limit($limit)->select_all_bank_branch_info()->get_result();

            // get all bank branch realted data
            $branch_data = $this->get_bank_branch_data($data);
            $view_page = $this->load->view('admin/bank/ajax_page/bank_branch_view', $branch_data, TRUE);
            echo json_encode($view_page);
        } else {
            redirect('');
        }
    }

    /**
     * @Description         : view bank branch data
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 15-12-2016 02:18 PM      
     * */
    function get_bank_branch_data($data) {
        foreach ($data['all_bank_branchs'] as $value) {
            $data['bank_name'][$value->bank_branch_id] = $this->utility_model
                            ->set_single_row_info('bank_name', 'tbl_bank', ['bank_id' => $value->bank_id])->get_single_row_info();
        }

        $total_bank = $this->bank_branch_model->total_bank_branch()->get_result();
        $params = array('url' => '', 'div_id' => 'bankBranchPagination', 'total_row' => $total_bank, 'per_page' => 10, 'current_page' => $data['page_number'], 'total_link' => 10);
        $data['pagination_link'] = $this->tt_pagination->view_pagination_link($params);
        return $data;
    }

    /**
     * @Description         : save bank branch
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 15-12-2016 02:49 PM      
     * */
    function save_bank_branch() {
        $this->form_validation->set_rules('bank_id', 'Bank Name', 'required');
        $this->form_validation->set_rules('bank_branch_name', 'Bank Branch Name', 'required|trim|callback_check_bank_branch_name');
        $this->form_validation->set_rules('bank_branch_status', 'Bank Branch Status', 'required');
        if ($this->form_validation->run() == FALSE) {
            $s_data['message'] = 'There is some error to save Bank branch name!';
            set_session($s_data);
            redirect('admin/bank-branch');
        } else {
            $this->bank_branch_model->bank_id = $this->input->post('bank_id', TRUE);
            $this->bank_branch_model->bank_branch_name = $this->input->post('bank_branch_name', TRUE);
            $this->bank_branch_model->bank_branch_status = $this->input->post('bank_branch_status', TRUE);
            $this->bank_branch_model->save();
            redirect('admin/bank-branch');
        }
    }

    /**
     * @Description         : update bank branch
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 18-12-2016 03:28 PM      
     * */
    function update_bank_branch() {
        $this->form_validation->set_rules('edit_bank_id', 'Bank Name', 'required');
        $this->form_validation->set_rules('edit_bank_branch_name', 'Bank Branch Name', 'required|trim|callback_check_edit_bank_branch_name');
        $this->form_validation->set_rules('edit_bank_branch_status', 'Bank Branch Status', 'required');
        if ($this->form_validation->run() == FALSE) {
            $s_data['message'] = 'There is some error to save Bank branch name!';
            set_session($s_data);
            redirect('admin/bank-branch');
        } else {
            $this->bank_branch_model->bank_id = $this->input->post('edit_bank_id', TRUE);
            $this->bank_branch_model->bank_branch_name = $this->input->post('edit_bank_branch_name', TRUE);
            $this->bank_branch_model->bank_branch_status = $this->input->post('edit_bank_branch_status', TRUE);
            $this->bank_branch_model->set_bank_branch_id($this->input->post('bank_branch_id', TRUE))->update();
            redirect('admin/bank-branch');
        }
    }

    /**
     * @Description         : check bank branch name
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 18-12-2016 03:29 PM      
     * */
    function check_bank_branch_name($branch_name) {
        $branch_bank_info = $this->bank_branch_model->
                        set_bank_id($this->input->post('bank_id', TRUE))->set_branch_name($branch_name)
                        ->check_bank_branch_name()->get_result();
        return ($branch_bank_info) ? FALSE : TRUE;
    }

    /**
     * @Description         : check bank branch name for edit
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 18-12-2016 03:35 PM      
     * */
    function check_edit_bank_branch_name($branch_name) {
        $branch_bank_info = $this->bank_branch_model->
                        set_bank_id($this->input->post('edit_bank_id', TRUE))->set_branch_name($branch_name)
                        ->set_bank_branch_id($this->input->post('bank_branch_id', TRUE))
                        ->check_bank_branch_name()->get_result();
        return ($branch_bank_info) ? FALSE : TRUE;
    }

    /**
     * @Description         : update bank branch status
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 15-12-2016 03:37 PM      
     * */
    private $total_deleted_bank_branch;

    function update_bank_branch_status() {
        if ((filter_input(INPUT_SERVER, 'HTTP_X_REQUESTED_WITH')) && (filter_input(INPUT_SERVER, 'HTTP_X_REQUESTED_WITH') == 'XMLHttpRequest')) {
            $bank_branch_id = $this->input->post('bank_branch_id', TRUE);
            $bank_branch_status = $this->input->post('bank_branch_status', TRUE);

            // update duplicate branch
            $this->update_duplicate_branch($bank_branch_id, $bank_branch_status);

            // update bank branch status
            $this->bank_branch_model->bank_branch_status = $bank_branch_status;
            $this->bank_branch_model->set_bank_branch_id($bank_branch_id)->update();

            $data = [];
            $data['total_deleted_branch'] = $this->total_deleted_bank_branch;
            echo json_encode($data);
        } else {
            redirect('');
        }
    }

    /**
     * @Description         : update duplicate brunch
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 21-12-2016 12:19 PM      
     * */
    function update_duplicate_branch($bank_branch_id, $bank_branch_status) {
        if ($bank_branch_status == 1) {
            $bank_branch_info = $this->utility_model->set_single_row_info('bank_id,bank_branch_name', 'tbl_bank_branch', ['bank_branch_id' => $bank_branch_id])
                    ->get_single_row_info();

            $all_bank_branch_id = $this->bank_branch_model->set_bank_branch_id($bank_branch_id)
                            ->set_bank_id($bank_branch_info->bank_id)->set_branch_name($bank_branch_info->bank_branch_name)
                            ->set_bank_branch_id_by_branch_name()->get_result()->id;

            if (!empty($all_bank_branch_id)) {
                $bank_branch_id_array = explode(',', $all_bank_branch_id);

                //set total deleted bank branch
                $this->total_deleted_bank_branch = count($bank_branch_id_array);

                // update check payment status
                $this->get_check_payment_info($bank_branch_id, $bank_branch_id_array);

                // Delete bank branch
                $this->delete_multiple_bank_branch($bank_branch_id_array);
            }
        }
    }

    /**
     * @Description         : get check payment information for update bank branch
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 21-12-2016 12:29 PM      
     * */
    function get_check_payment_info($bank_branch_id, $bank_branch_id_array) {
        $check_payment_id = $this->bank_branch_model->set_bank_branch_id($bank_branch_id_array)
                        ->set_check_payment_id_by_all_branch_id()->get_result()->id;

        if (!empty($check_payment_id)) {
            $check_payment_id_array = explode(',', $check_payment_id);

            // update payment status
            $this->update_check_payment_status($bank_branch_id, $check_payment_id_array);
        }
    }

    /**
     * @Description         : update check payment status
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 21-12-2016 12:29 PM      
     * */
    function update_check_payment_status($bank_branch_id, $check_payment_id_array) {
        foreach ($check_payment_id_array as $value) {
            $this->payment_process_model->bank_branch_id = $bank_branch_id;
            $this->payment_process_model->set_primary_key('person_check_payment_info_id')
                    ->set_primary_key_value($value)
                    ->set_table_name('tbl_person_check_payment_info')->update();
        }
    }

    /**
     * @Description         : delete multiple bank branch information
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 21-12-2016 12:29 PM      
     * */
    function delete_multiple_bank_branch($bank_branch_id_array) {
        foreach ($bank_branch_id_array as $value) {
            $this->bank_branch_model->set_bank_branch_id($value)->delete();
        }
    }

    /**
     * @Description         : get bank branch info
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 18-12-2016 12:19 PM      
     * */
    function get_bank_branch_info() {
        if ((filter_input(INPUT_SERVER, 'HTTP_X_REQUESTED_WITH')) && (filter_input(INPUT_SERVER, 'HTTP_X_REQUESTED_WITH') == 'XMLHttpRequest')) {
            $data = [];
            $branch_bank_id = $this->input->post('branch_bank_id', TRUE);
            $data['branch_bank_info'] = $this->utility_model
                            ->set_single_row_info('*', 'tbl_bank_branch', ['bank_branch_id' => $branch_bank_id])->get_single_row_info();
            echo json_encode($data);
        } else {
            redirect('');
        }
    }

    /**
     * @Description         : check bank branch namr
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 18-12-2016 02:22 PM      
     * */
    function check_bank_name() {
        if ((filter_input(INPUT_SERVER, 'HTTP_X_REQUESTED_WITH')) && (filter_input(INPUT_SERVER, 'HTTP_X_REQUESTED_WITH') == 'XMLHttpRequest')) {
            $bank_branch_id = $this->input->post('bank_branch_id', TRUE);
            $bank_id = $this->input->post('bank_id', TRUE);
            $baranch_name = $this->input->post('baranch_name', TRUE);
            $branch_bank_info = $this->bank_branch_model->
                            set_bank_id($bank_id)->set_branch_name($baranch_name)->set_bank_branch_id($bank_branch_id)
                            ->check_bank_branch_name()->get_result();
            echo ($branch_bank_info) ? 1 : 2;
        } else {
            redirect('');
        }
    }

    /**
     * @Description         : delete bank branch
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 15-12-2016 04:35 PM      
     * */
    function delete_bank_branch() {
        if ((filter_input(INPUT_SERVER, 'HTTP_X_REQUESTED_WITH')) && (filter_input(INPUT_SERVER, 'HTTP_X_REQUESTED_WITH') == 'XMLHttpRequest')) {
            $this->bank_branch_model->set_bank_branch_id($this->input->post('bank_branch_id', TRUE))->delete();
        } else {
            redirect('');
        }
    }

    /**
     * @Description         : get bank branch infor by bank ID
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 10-01-2016 03:54 PM      
     * */
    function get_bank_branch_bank() {
        if (empty($this->input->is_ajax_request())) {
            redirect();
        }

        $bank_id = $this->input->post('bank_id', TRUE);
        $bank_branch_info = $this->bank_branch_model->set_bank_id($bank_id)->set_bank_branch_status(1)->set_branch_name_by_bank_id()->get_result();
        echo json_encode($bank_branch_info);
    }

}
